/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
export declare function createMockDebugLogger(options?: {
    stripAnsi?: boolean;
}): {
    emitConsoleLog: import("vitest").Mock<(...args: any[]) => any>;
    debugLogger: {
        log: import("vitest").Mock<(message: unknown, ...args: unknown[]) => void>;
        error: import("vitest").Mock<(message: unknown, ...args: unknown[]) => void>;
        warn: import("vitest").Mock<(message: unknown, ...args: unknown[]) => void>;
        debug: import("vitest").Mock<(...args: any[]) => any>;
        info: import("vitest").Mock<(...args: any[]) => any>;
    };
};
/**
 * A helper specifically designed for `vi.mock('@google/gemini-cli-core', ...)` to easily
 * mock both `debugLogger` and `coreEvents.emitConsoleLog`.
 *
 * Example:
 * ```typescript
 * vi.mock('@google/gemini-cli-core', async (importOriginal) => {
 *   const { mockCoreDebugLogger } = await import('../../test-utils/mockDebugLogger.js');
 *   return mockCoreDebugLogger(
 *     await importOriginal<typeof import('@google/gemini-cli-core')>(),
 *     { stripAnsi: true }
 *   );
 * });
 * ```
 */
export declare function mockCoreDebugLogger<T extends Record<string, unknown>>(actual: T, options?: {
    stripAnsi?: boolean;
}): T;
