/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { type Assertion } from 'vitest';
export declare function toMatchSvgSnapshot(this: Assertion, renderInstance: {
    lastFrameRaw?: (options?: {
        allowEmpty?: boolean;
    }) => string;
    lastFrame?: (options?: {
        allowEmpty?: boolean;
    }) => string;
    generateSvg: () => string;
}, options?: {
    allowEmpty?: boolean;
    name?: string;
}): Promise<{
    pass: boolean;
    message: () => string;
}>;
declare module 'vitest' {
    interface Assertion<T = any> extends CustomMatchers<T> {
    }
    interface AsymmetricMatchersContaining extends CustomMatchers {
    }
    interface CustomMatchers<T = unknown> {
        toHaveOnlyValidCharacters(): T;
        toMatchSvgSnapshot(options?: {
            allowEmpty?: boolean;
            name?: string;
        }): Promise<void>;
    }
}
