import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from 'react';
import { Box, Text } from 'ink';
import { theme } from '../semantic-colors.js';
import { RadioButtonSelect } from '../components/shared/RadioButtonSelect.js';
import { useKeypress } from '../hooks/useKeypress.js';
import { openBrowserSecurely, shouldLaunchBrowser, } from '@google/gemini-cli-core';
import { runExitCleanup } from '../../utils/cleanup.js';
export function BannedAccountDialog({ accountSuspensionInfo, onExit, onChangeAuth, }) {
    const [errorMessage, setErrorMessage] = useState(null);
    const appealUrl = accountSuspensionInfo.appealUrl;
    const appealLinkText = accountSuspensionInfo.appealLinkText ?? 'Open the Google Form';
    const items = useMemo(() => {
        const menuItems = [];
        if (appealUrl) {
            menuItems.push({
                label: appealLinkText,
                value: 'open_form',
                key: 'open_form',
            });
        }
        menuItems.push({
            label: 'Change authentication',
            value: 'change_auth',
            key: 'change_auth',
        }, {
            label: 'Exit',
            value: 'exit',
            key: 'exit',
        });
        return menuItems;
    }, [appealUrl, appealLinkText]);
    useKeypress((key) => {
        if (key.name === 'escape') {
            void handleExit();
            return true;
        }
        return false;
    }, { isActive: true });
    const handleExit = useCallback(async () => {
        await runExitCleanup();
        onExit();
    }, [onExit]);
    const handleSelect = useCallback(async (choice) => {
        if (choice === 'open_form' && appealUrl) {
            if (!shouldLaunchBrowser()) {
                setErrorMessage(`Please open this URL in a browser: ${appealUrl}`);
                return;
            }
            try {
                await openBrowserSecurely(appealUrl);
            }
            catch {
                setErrorMessage(`Failed to open browser. Please visit: ${appealUrl}`);
            }
        }
        else if (choice === 'change_auth') {
            onChangeAuth();
        }
        else {
            await handleExit();
        }
    }, [handleExit, onChangeAuth, appealUrl]);
    return (_jsxs(Box, { flexDirection: "column", padding: 1, children: [_jsx(Text, { bold: true, color: theme.status.error, children: "Error: Account Suspended" }), _jsx(Box, { marginTop: 1, children: _jsx(Text, { children: accountSuspensionInfo.message }) }), appealUrl && (_jsxs(_Fragment, { children: [_jsx(Box, { marginTop: 1, children: _jsx(Text, { children: "Appeal URL:" }) }), _jsx(Box, { children: _jsxs(Text, { color: theme.text.link, children: ["[", appealUrl, "]"] }) })] })), errorMessage && (_jsx(Box, { marginTop: 1, children: _jsx(Text, { color: theme.status.error, children: errorMessage }) })), _jsx(Box, { marginTop: 1, children: _jsx(RadioButtonSelect, { items: items, onSelect: (choice) => void handleSelect(choice) }) }), _jsx(Box, { marginTop: 1, children: _jsx(Text, { dimColor: true, children: "Escape to exit" }) })] }));
}
//# sourceMappingURL=BannedAccountDialog.js.map