import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Text } from 'ink';
import { theme } from '../semantic-colors.js';
import { useUIState } from '../contexts/UIStateContext.js';
import { TransientMessageType } from '../../utils/events.js';
export function shouldShowToast(uiState) {
    return (uiState.ctrlCPressedOnce ||
        Boolean(uiState.transientMessage) ||
        uiState.ctrlDPressedOnce ||
        (uiState.showEscapePrompt &&
            (uiState.buffer.text.length > 0 || uiState.history.length > 0)) ||
        Boolean(uiState.queueErrorMessage));
}
export const ToastDisplay = () => {
    const uiState = useUIState();
    if (uiState.ctrlCPressedOnce) {
        return (_jsx(Text, { color: theme.status.warning, children: "Press Ctrl+C again to exit." }));
    }
    if (uiState.transientMessage?.type === TransientMessageType.Warning &&
        uiState.transientMessage.text) {
        return (_jsx(Text, { color: theme.status.warning, children: uiState.transientMessage.text }));
    }
    if (uiState.ctrlDPressedOnce) {
        return (_jsx(Text, { color: theme.status.warning, children: "Press Ctrl+D again to exit." }));
    }
    if (uiState.showEscapePrompt) {
        const isPromptEmpty = uiState.buffer.text.length === 0;
        const hasHistory = uiState.history.length > 0;
        if (isPromptEmpty && !hasHistory) {
            return null;
        }
        return (_jsxs(Text, { color: theme.text.secondary, children: ["Press Esc again to ", isPromptEmpty ? 'rewind' : 'clear prompt', "."] }));
    }
    if (uiState.transientMessage?.type === TransientMessageType.Hint &&
        uiState.transientMessage.text) {
        return (_jsx(Text, { color: theme.text.secondary, children: uiState.transientMessage.text }));
    }
    if (uiState.queueErrorMessage) {
        return _jsx(Text, { color: theme.status.error, children: uiState.queueErrorMessage });
    }
    return null;
};
//# sourceMappingURL=ToastDisplay.js.map