/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.sql;

import com.amazonaws.secretsmanager.caching.SecretCache;
import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.sql.AWSSecretsManagerDriver;
import java.sql.SQLException;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.utils.StringUtils;

public final class AWSSecretsManagerRedshiftDriver
extends AWSSecretsManagerDriver {
    public static final String ACCESS_DENIED_FOR_USER_USING_PASSWORD_TO_DATABASE = "28P01";
    public static final String SUBPREFIX = "redshift";

    public AWSSecretsManagerRedshiftDriver() {
    }

    public AWSSecretsManagerRedshiftDriver(SecretCache cache) {
        super(cache);
    }

    public AWSSecretsManagerRedshiftDriver(SecretsManagerClientBuilder builder) {
        super(builder);
    }

    public AWSSecretsManagerRedshiftDriver(SecretsManagerClient client) {
        super(client);
    }

    public AWSSecretsManagerRedshiftDriver(SecretCacheConfiguration cacheConfig) {
        super(cacheConfig);
    }

    @Override
    public String getPropertySubprefix() {
        return SUBPREFIX;
    }

    @Override
    public boolean isExceptionDueToAuthenticationError(Exception e) {
        if (e instanceof SQLException) {
            SQLException sqle = (SQLException)e;
            String sqlState = sqle.getSQLState();
            return sqlState.equals(ACCESS_DENIED_FOR_USER_USING_PASSWORD_TO_DATABASE);
        }
        return false;
    }

    @Override
    public String constructUrlFromEndpointPortDatabase(String endpoint, String port, String dbname) {
        String url = "jdbc:redshift://" + endpoint;
        if (StringUtils.isNotBlank((CharSequence)port)) {
            url = url + ":" + port;
        }
        if (StringUtils.isNotBlank((CharSequence)dbname)) {
            url = url + "/" + dbname;
        }
        return url;
    }

    @Override
    public String getDefaultDriverClass() {
        return "com.amazon.redshift.Driver";
    }

    static {
        AWSSecretsManagerDriver.register(new AWSSecretsManagerRedshiftDriver());
    }
}

