/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.ing.data.cassandra.jdbc.json.CassandraBlobDeserializer;
import com.ing.data.cassandra.jdbc.json.CassandraBlobSerializer;
import com.ing.data.cassandra.jdbc.json.CassandraDateDeserializer;
import com.ing.data.cassandra.jdbc.json.CassandraDateTimeDeserializer;
import com.ing.data.cassandra.jdbc.json.CassandraTimeDeserializer;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;

public final class JsonUtil {
    static ObjectMapper objectMapperInstance = null;

    private JsonUtil() {
    }

    public static ObjectMapper getObjectMapper() {
        if (objectMapperInstance != null) {
            return objectMapperInstance;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.registerModule((Module)new JavaTimeModule());
        SimpleModule cassandraExtensionsModule = new SimpleModule();
        cassandraExtensionsModule.addDeserializer(ByteBuffer.class, (JsonDeserializer)new CassandraBlobDeserializer());
        cassandraExtensionsModule.addDeserializer(LocalDate.class, (JsonDeserializer)new CassandraDateDeserializer());
        cassandraExtensionsModule.addDeserializer(LocalTime.class, (JsonDeserializer)new CassandraTimeDeserializer());
        cassandraExtensionsModule.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new CassandraDateTimeDeserializer());
        cassandraExtensionsModule.addSerializer(ByteBuffer.class, (JsonSerializer)new CassandraBlobSerializer());
        objectMapper.registerModule((Module)cassandraExtensionsModule);
        objectMapperInstance = objectMapper;
        return objectMapper;
    }
}

