/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aebuilder.value;

import com.databricks.client.sqlengine.aeprocessor.AEColumnInfo;
import com.databricks.client.sqlengine.aeprocessor.AEQTableName;
import com.databricks.client.sqlengine.aeprocessor.AEUtils;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AERename;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.parser.parsetree.IPTNode;
import com.databricks.client.sqlengine.parser.parsetree.PTIdentifierNode;
import com.databricks.client.sqlengine.parser.parsetree.PTListNode;
import com.databricks.client.sqlengine.parser.parsetree.PTNonterminalNode;
import com.databricks.client.sqlengine.parser.type.PTListType;
import com.databricks.client.sqlengine.parser.type.PTNonterminalType;
import com.databricks.client.sqlengine.parser.type.PTPositionalType;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.Iterator;
import java.util.List;

public class AESelectListBuilder
extends AEBuilderBase<AEValueExprList> {
    public AESelectListBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
        if (aEQueryScope == null) {
            throw new NullPointerException("query scope for select list can not be null");
        }
    }

    @Override
    public AEValueExprList visit(PTListNode pTListNode) throws ErrorException {
        assert (pTListNode != null);
        if (pTListNode.getListType() != PTListType.SELECT_LIST) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        AEValueExprList aEValueExprList = new AEValueExprList();
        List<IPTNode> list = pTListNode.getImmutableChildList();
        block4: for (int i = 0; i < list.size(); ++i) {
            IPTNode iPTNode = list.get(i);
            if (!(iPTNode instanceof PTNonterminalNode)) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iPTNode;
            switch (pTNonterminalNode.getNonterminalType()) {
                case DERIVED_COLUMN: {
                    aEValueExprList.addNode(this.buildSelectListItem(pTNonterminalNode));
                    continue block4;
                }
                case COLUMN_REFERENCE: {
                    this.buildStarColumn(pTNonterminalNode, aEValueExprList);
                    continue block4;
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidParseTreeException();
                }
            }
        }
        return aEValueExprList;
    }

    private void buildStarColumn(PTNonterminalNode pTNonterminalNode, AEValueExprList aEValueExprList) throws ErrorException {
        assert (pTNonterminalNode.getNonterminalType() == PTNonterminalType.COLUMN_REFERENCE);
        AEQueryScope aEQueryScope = this.getQueryScope();
        String string = AEUtils.getIdentifierString(pTNonterminalNode.getChild(PTPositionalType.TABLE_IDENT));
        String string2 = AEUtils.getIdentifierString(pTNonterminalNode.getChild(PTPositionalType.SCHEMA_IDENT));
        String string3 = AEUtils.getIdentifierString(pTNonterminalNode.getChild(PTPositionalType.CATALOG_IDENT));
        if ("".equals(string)) {
            if (!string2.equals("") || !string3.equals("")) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            Iterator<AEColumnInfo> iterator = aEQueryScope.getColumnItr();
            this.constructColumns(iterator, aEValueExprList);
        } else {
            AEQTableName aEQTableName = AEUtils.adjustCatalogAndSchema(new AEQTableName(string3, string2, string), aEQueryScope.getDataEngine().getContext(), false);
            Iterator<AEColumnInfo> iterator = aEQueryScope.getColumnItr(aEQTableName);
            this.constructColumns(iterator, aEValueExprList);
        }
    }

    private void constructColumns(Iterator<AEColumnInfo> iterator, AEValueExprList aEValueExprList) {
        while (iterator.hasNext()) {
            AEColumnInfo aEColumnInfo = iterator.next();
            aEColumnInfo.setResolvedQueryScope(this.getQueryScope());
            aEValueExprList.addNode(new AEColumnReference(aEColumnInfo));
        }
    }

    private AEValueExpr buildSelectListItem(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        assert (null != pTNonterminalNode && PTNonterminalType.DERIVED_COLUMN == pTNonterminalNode.getNonterminalType());
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.VALUE_EXPRESSION_GENERAL);
        AEValueExpr aEValueExpr = (AEValueExpr)new AEValueExprBuilder(this.getQueryScope()).build(iPTNode);
        IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.AS);
        if (!iPTNode2.isEmptyNode()) {
            if (!(iPTNode2 instanceof PTIdentifierNode)) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            aEValueExpr = new AERename(((PTIdentifierNode)iPTNode2).getIdentifier(), aEValueExpr);
        }
        return aEValueExpr;
    }
}

