/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.jdbc;

import com.databricks.client.hivecommon.DownloadableResultSettings;
import com.databricks.client.hivecommon.HttpErrorEmulationSettings;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc.common.CommonUtils;
import com.databricks.client.jdbc.common.ProxySettings;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkArrowResultLink;
import com.databricks.client.jdbc42.internal.apache.http.HttpHost;
import com.databricks.client.jdbc42.internal.apache.http.auth.AuthScope;
import com.databricks.client.jdbc42.internal.apache.http.auth.Credentials;
import com.databricks.client.jdbc42.internal.apache.http.auth.UsernamePasswordCredentials;
import com.databricks.client.jdbc42.internal.apache.http.client.CredentialsProvider;
import com.databricks.client.jdbc42.internal.apache.http.client.config.RequestConfig;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpGet;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpUriRequest;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.BasicCredentialsProvider;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.CloseableHttpClient;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.HttpClientBuilder;
import com.databricks.client.jdbc42.internal.apache.http.util.EntityUtils;
import com.databricks.client.jdbc42.internal.jpountz.lz4.LZ4FrameInputStream;
import com.databricks.client.spark.jdbc.DownloadableExecutionContext;
import com.databricks.client.spark.jdbc.ResultFileDownloadMonitor;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResultFileDownloadHandler
implements Runnable {
    public ErrorException m_errorException;
    public byte[] m_resultFile;
    public TSparkArrowResultLink m_resultLink;
    public AtomicBoolean m_isDownloadFinished;
    public boolean m_isDownloadScheduled = false;
    public Semaphore m_downloadCompletionSemaphore = new Semaphore(0);
    public int m_downloadTimeout;
    public boolean m_isLinkExpired;
    public boolean m_isDownloadTimedout = false;
    public int m_httpCode;
    public AtomicBoolean m_isFileDownloadedSuccessfully = new AtomicBoolean(false);
    DownloadableExecutionContext m_executionContext;
    int m_resultFileLinkExpiryBuffer;
    boolean m_checkResultFileLinkExpiry = true;
    HttpUriRequest m_httpRequest;
    private static final int NOTHING_TO_READ_FROM_STREAM = -1;
    private static final String REDACTED_STRING = "***";

    public ResultFileDownloadHandler(DownloadableExecutionContext downloadableExecutionContext, TSparkArrowResultLink tSparkArrowResultLink) {
        LogUtilities.logFunctionEntrance(downloadableExecutionContext.getLogger(), new Object[0]);
        this.m_executionContext = downloadableExecutionContext;
        this.m_resultLink = tSparkArrowResultLink;
        this.m_isDownloadFinished = new AtomicBoolean(false);
    }

    public boolean isFileDownloadSuccessfully() {
        LogUtilities.logFunctionEntrance(this.m_executionContext.getLogger(), new Object[0]);
        try {
            this.waitForDownloadComplete();
        }
        catch (ErrorException errorException) {
            LogUtilities.logWarning("Got an ErrorException when waiting for download to complete: " + errorException.getMessage(), this.m_executionContext.getLogger());
            return false;
        }
        catch (InterruptedException interruptedException) {
            LogUtilities.logWarning("Got an InterruptedException when waiting for download to complete: " + interruptedException.getMessage(), this.m_executionContext.getLogger());
            return false;
        }
        return this.m_isFileDownloadedSuccessfully.get();
    }

    private String getFileLinkUrlForLogging() {
        LogUtilities.logFunctionEntrance(this.m_executionContext.getLogger(), new Object[0]);
        if (this.m_executionContext.m_settings.m_enableCloudFetchUrlLogging.booleanValue()) {
            return this.m_resultLink.getFileLink();
        }
        return REDACTED_STRING;
    }

    private synchronized void waitForDownloadComplete() throws InterruptedException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_executionContext.getLogger(), new Object[0]);
        if (this.m_executionContext.m_settings.m_enableCloudFetchErrorTesting.booleanValue()) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(this.getFileLinkUrlForLogging());
            throw errorException;
        }
        if (!this.m_isDownloadFinished.get()) {
            DownloadableResultSettings downloadableResultSettings = this.m_executionContext.m_settings.m_downloadableResultSettings;
            if (downloadableResultSettings.m_downloadTimeout > 0) {
                if (!this.m_downloadCompletionSemaphore.tryAcquire(downloadableResultSettings.m_downloadTimeout, TimeUnit.SECONDS)) {
                    this.m_isDownloadTimedout = true;
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.FILE_DOWNLOAD_TIEMOUT.name(), new String[]{this.getFileLinkUrlForLogging(), String.valueOf(downloadableResultSettings.m_downloadTimeout), "ResultFileDownloadTimeout"});
                    throw errorException;
                }
            } else {
                LogUtilities.logInfo("Wait the result file to be downloaded without a timeout. Notice: it may wait forever if the download thread hangs. To avoid the risk of hanging, you can set ResultFileDownloadTimeoutto a value greater than zero.", this.m_executionContext.getLogger());
                this.m_downloadCompletionSemaphore.acquire();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        Iterator<Map.Entry<String, String>> iterator;
        Object object3;
        Object object4;
        long l;
        long l2;
        LogUtilities.logFunctionEntrance(this.m_executionContext.getLogger(), new Object[0]);
        this.m_isFileDownloadedSuccessfully.set(false);
        this.m_isLinkExpired = false;
        this.m_isDownloadTimedout = false;
        if (this.m_checkResultFileLinkExpiry && ((l2 = this.m_resultLink.getExpiryTime()) < (l = System.currentTimeMillis()) || l2 - l < (long)(this.m_executionContext.m_settings.m_downloadableResultSettings.m_resultFileLinkExpiryBuffer / 1000))) {
            this.m_isLinkExpired = true;
            return;
        }
        int n = this.m_executionContext.m_settings.m_downloadableResultSettings.m_downloadTimeout * 1000;
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(n).setConnectionRequestTimeout(n).setSocketTimeout(n);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        this.m_httpRequest = new HttpGet(this.m_resultLink.getFileLink());
        if (this.m_executionContext.m_settings.m_proxySettings.m_useProxy && !this.m_executionContext.m_settings.m_proxySettings.m_disableProxyForCloudFetch.booleanValue() && !CommonUtils.isHostInProxyBypassList(this.m_executionContext.m_settings.m_proxySettings, this.m_httpRequest)) {
            object4 = this.m_executionContext.m_settings.m_proxySettings;
            object3 = new HttpHost(((ProxySettings)object4).m_proxyHost, ((ProxySettings)object4).m_proxyPort);
            builder.setProxy((HttpHost)object3);
            if (((ProxySettings)object4).m_proxyAuth == ProxySettings.ProxyAuthentication.BASIC) {
                iterator = new BasicCredentialsProvider();
                AuthScope object22 = new AuthScope(((ProxySettings)object4).m_proxyHost, ((ProxySettings)object4).m_proxyPort);
                object = new UsernamePasswordCredentials(((ProxySettings)object4).m_proxyUid, ((ProxySettings)object4).m_proxyPwd);
                iterator.setCredentials(object22, (Credentials)object);
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)((Object)iterator));
            }
        }
        ResultFileDownloadMonitor.getResultFileDownloadMonitor();
        object4 = builder.build();
        object3 = httpClientBuilder.setDefaultRequestConfig((RequestConfig)object4).build();
        if (this.m_executionContext.m_settings.m_enableAdditionalHttpHeadersForCloudFetch.booleanValue()) {
            if (this.m_resultLink.getHttpHeadersSize() > 0) {
                LogUtilities.logDebug("The size of additional Http headers for cloud fetch is " + this.m_resultLink.getHttpHeadersSize(), this.m_executionContext.getLogger());
                for (Map.Entry<String, String> entry : this.m_resultLink.getHttpHeaders().entrySet()) {
                    this.m_httpRequest.addHeader(entry.getKey(), entry.getValue());
                }
            } else {
                LogUtilities.logDebug("Additional Http headers for cloud fetch not found.", this.m_executionContext.getLogger());
            }
        }
        ResultFileDownloadMonitor.getResultFileDownloadMonitor().addDownloadTask(this.m_httpRequest);
        try {
            iterator = ((CloseableHttpClient)object3).execute(this.m_httpRequest);
            this.m_httpCode = iterator.getStatusLine().getStatusCode();
            HttpErrorEmulationSettings httpErrorEmulationSettings = this.m_executionContext.m_settings.m_thriftHTTPSettings.m_httpErrorEmulationSettingsMap.get("Download");
            if (null != httpErrorEmulationSettings) {
                ++httpErrorEmulationSettings.m_apiIndex;
                if (httpErrorEmulationSettings.shouldEmulateError()) {
                    this.m_httpCode = httpErrorEmulationSettings.populateEmulatedHttpResponse().getStatusLine().getStatusCode();
                    LogUtilities.logDebug("Emulate Http error code " + this.m_httpCode + " for downloaidng reasult.", this.m_executionContext.getLogger());
                }
            }
            if (200 != this.m_httpCode) {
                LogUtilities.logWarning("Got Http status code: " + this.m_httpCode + " when downloading " + this.getFileLinkUrlForLogging(), this.m_executionContext.getLogger());
                this.m_isFileDownloadedSuccessfully.set(false);
            } else {
                if (this.m_executionContext.m_isLz4Compressed) {
                    object = EntityUtils.toByteArray(iterator.getEntity());
                    this.m_resultFile = new byte[(int)this.m_resultLink.getBytesNum()];
                    LZ4FrameInputStream lZ4FrameInputStream = new LZ4FrameInputStream(new ByteArrayInputStream((byte[])object));
                    int n2 = 0;
                    int n3 = 0;
                    while (-1 != (n3 = lZ4FrameInputStream.read(this.m_resultFile, n2, this.m_resultFile.length - n2)) && (n2 += n3) < this.m_resultFile.length) {
                    }
                    lZ4FrameInputStream.close();
                    if (-1 != n3) {
                        byte[] byArray = new byte[1];
                        n3 = lZ4FrameInputStream.read(byArray, 0, 1);
                        if (-1 != n3) {
                            LogUtilities.logWarning("The total bytes num in the link should be " + this.m_resultLink.getBytesNum() + " bytes. The uncompressed bytes is more than that. The downloaded results from " + this.getFileLinkUrlForLogging() + " will be discarded.", this.m_executionContext.getLogger());
                            this.m_isFileDownloadedSuccessfully.set(false);
                        } else {
                            this.m_isFileDownloadedSuccessfully.set(true);
                        }
                    } else if (n2 != (int)this.m_resultLink.getBytesNum()) {
                        LogUtilities.logWarning("The total bytes num in the link should be " + this.m_resultLink.getBytesNum() + " bytes. The uncompressed stream only has " + n2 + "bytesThe downloaded results from " + this.getFileLinkUrlForLogging() + " will be discarded.", this.m_executionContext.getLogger());
                        this.m_isFileDownloadedSuccessfully.set(false);
                    } else {
                        this.m_isFileDownloadedSuccessfully.set(true);
                    }
                } else {
                    this.m_resultFile = EntityUtils.toByteArray(iterator.getEntity());
                    if ((long)this.m_resultFile.length != this.m_resultLink.getBytesNum()) {
                        LogUtilities.logWarning("the total bytes num in the should be " + this.m_resultLink.getBytesNum() + " bytes. The total bytes downloaded is" + this.m_resultFile.length + "bytesThe downloaded results from " + this.getFileLinkUrlForLogging() + " will be discarded.", this.m_executionContext.getLogger());
                        this.m_isFileDownloadedSuccessfully.set(false);
                    } else {
                        this.m_isFileDownloadedSuccessfully.set(true);
                    }
                }
                EntityUtils.consume(iterator.getEntity());
            }
        }
        catch (IOException iOException) {
            LogUtilities.logWarning("Encountered an IOException during downloading " + this.getFileLinkUrlForLogging() + ". The exception is " + iOException.getMessage() + iOException.getCause().getMessage(), this.m_executionContext.getLogger());
            this.m_isFileDownloadedSuccessfully.set(false);
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Encountered an Exception during downloading " + this.getFileLinkUrlForLogging() + ". The exception is " + exception.getMessage(), this.m_executionContext.getLogger());
            this.m_isFileDownloadedSuccessfully.set(false);
        }
        finally {
            try {
                object3.close();
                ResultFileDownloadMonitor.getResultFileDownloadMonitor().removeDownloadTask(this.m_httpRequest);
            }
            catch (IOException iOException) {
                LogUtilities.logWarning("Encountered an IOException while closing the HTTP client. Exception detail: " + iOException.getMessage(), this.m_executionContext.getLogger());
            }
            this.m_isDownloadFinished.set(true);
            this.m_downloadCompletionSemaphore.release();
        }
    }
}

