/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.http.protocol;

import com.databricks.client.jdbc42.internal.apache.http.HttpException;
import com.databricks.client.jdbc42.internal.apache.http.HttpResponse;
import com.databricks.client.jdbc42.internal.apache.http.HttpResponseInterceptor;
import com.databricks.client.jdbc42.internal.apache.http.annotation.Contract;
import com.databricks.client.jdbc42.internal.apache.http.annotation.ThreadingBehavior;
import com.databricks.client.jdbc42.internal.apache.http.protocol.HttpContext;
import com.databricks.client.jdbc42.internal.apache.http.protocol.HttpDateGenerator;
import com.databricks.client.jdbc42.internal.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

