/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.output;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.output.MigrateErrorResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.internal.exception.FlywayMigrateException;
import org.flywaydb.core.internal.exception.FlywaySqlException;

public class ErrorOutput
implements OperationResult {
    public ErrorOutputItem error;

    public ErrorOutput(ErrorCode errorCode, String message, String stackTrace, Integer lineNumber, String path, ErrorCause cause) {
        this.error = new ErrorOutputItem(errorCode, null, null, message, stackTrace, lineNumber, path, cause);
    }

    public ErrorOutput(ErrorCode errorCode, String sqlState, Integer sqlErrorCode, String message, String stackTrace, Integer lineNumber, String path, ErrorCause cause) {
        this.error = new ErrorOutputItem(errorCode, sqlState, sqlErrorCode, message, stackTrace, lineNumber, path, cause);
    }

    public static ErrorOutput fromException(Exception exception) {
        FlywayMigrateException flywayMigrateException;
        String message = exception.getMessage();
        if (exception instanceof FlywayMigrateException && (flywayMigrateException = (FlywayMigrateException)exception).getAbsolutePathOnDisk() != null) {
            return new ErrorOutput(flywayMigrateException.getMigrationErrorCode(), null, null, message == null ? "Error occurred" : message, null, flywayMigrateException.getLineNumber(), flywayMigrateException.getAbsolutePathOnDisk(), ErrorOutput.getCause(exception).orElse(null));
        }
        if (exception instanceof FlywaySqlException) {
            FlywaySqlException flywaySqlException = (FlywaySqlException)exception;
            return new ErrorOutput(flywaySqlException.getErrorCode(), flywaySqlException.getSqlState(), flywaySqlException.getSqlErrorCode(), message == null ? "Error occurred" : message, null, null, null, ErrorOutput.getCause(exception).orElse(null));
        }
        if (exception instanceof FlywayException) {
            FlywayException flywayException = (FlywayException)exception;
            return new ErrorOutput(flywayException.getErrorCode(), null, null, message == null ? "Error occurred" : message, null, null, null, ErrorOutput.getCause(exception).orElse(null));
        }
        return new ErrorOutput(CoreErrorCode.FAULT, null, null, message == null ? "Fault occurred" : message, ErrorOutput.getStackTrace(exception), null, null, ErrorOutput.getCause(exception).orElse(null));
    }

    public static MigrateErrorResult fromMigrateException(FlywayMigrateException exception) {
        return exception.getErrorResult();
    }

    public static OperationResult toOperationResult(Exception exception) {
        if (exception instanceof FlywayMigrateException) {
            return ErrorOutput.fromMigrateException((FlywayMigrateException)exception);
        }
        return ErrorOutput.fromException(exception);
    }

    private static String getStackTrace(Throwable exception) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)output, true, StandardCharsets.UTF_8);
        exception.printStackTrace(printStream);
        return output.toString(StandardCharsets.UTF_8);
    }

    private static Optional<ErrorCause> getCause(Throwable e) {
        return Optional.ofNullable(e.getCause()).map(cause -> new ErrorCause(cause.getMessage(), ErrorOutput.getStackTrace(cause), ErrorOutput.getCause(cause).orElse(null)));
    }

    public static class ErrorOutputItem {
        public ErrorCode errorCode;
        public String sqlState;
        public Integer sqlErrorCode;
        public String message;
        public String stackTrace;
        public Integer lineNumber;
        public String path;
        public ErrorCause cause;

        ErrorOutputItem(ErrorCode errorCode, String sqlState, Integer sqlErrorCode, String message, String stackTrace, Integer lineNumber, String path, ErrorCause cause) {
            this.errorCode = errorCode;
            this.sqlState = sqlState;
            this.sqlErrorCode = sqlErrorCode;
            this.message = message;
            this.stackTrace = stackTrace;
            this.lineNumber = lineNumber;
            this.path = path;
            this.cause = cause;
        }
    }

    public record ErrorCause(String message, String stackTrace, ErrorCause cause) {
    }
}

