/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.clickhouse;

import java.sql.SQLException;
import org.flywaydb.community.database.clickhouse.ClickHouseConnection;
import org.flywaydb.community.database.clickhouse.ClickHouseDatabase;
import org.flywaydb.community.database.clickhouse.ClickHouseSchema;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.StringUtils;

public class ClickHouseTable
extends Table<ClickHouseDatabase, ClickHouseSchema> {
    private static final Log LOG = LogFactory.getLog(ClickHouseTable.class);

    public ClickHouseTable(JdbcTemplate jdbcTemplate, ClickHouseDatabase database, ClickHouseSchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
    }

    protected void doDrop() throws SQLException {
        String clusterName = ((ClickHouseDatabase)this.database).getClusterName();
        this.jdbcTemplate.executeStatement("DROP TABLE " + String.valueOf((Object)this) + (String)(StringUtils.hasText((String)clusterName) ? " ON CLUSTER " + clusterName : ""));
    }

    protected boolean doExists() throws SQLException {
        ClickHouseConnection systemConnection = ((ClickHouseDatabase)this.database).getSystemConnection();
        int count = systemConnection.getJdbcTemplate().queryForInt("SELECT COUNT() FROM system.tables WHERE database = ? AND name = ?", new String[]{((ClickHouseSchema)this.schema).getName(), this.name});
        return count > 0;
    }

    protected void doLock() throws SQLException {
        LOG.debug("Unable to lock " + String.valueOf((Object)this) + " as ClickHouse does not support locking. No concurrent migration supported.");
    }
}

