#ifndef _TDFFPIL_INC
#define _TDFFPIL_INC
#ifdef __cplusplus
extern "C" {
#endif

/*
 *+			T D F F P I L

 * Include File name:
      tdffpil

 * Function:
      Include file for tdFfpilMin and tdFfpilFull modules.

 * Description:
      Contains extern definitions from tdFfpilMin.c and tdFfpilFull.c
      and internal prototypes of tdFfpilMin routines used by tdFfpilFull.

 * Language:
      C


 * Support: Tony Farrell, AAO

 *-

 * Sccs Id:     tdffpil.h, Release 1.1, 12/10/99

 * History:
     10-Dec-1999 - TJF - Original version
 */

/*
 *  Include files
 */
#include "fpil.h"


/*
 *   This structure represents the telescope parameters which must
 *   be passed to FpilModelCvtInit() as it's tel argument when
 *   using the 2dF instrument model.
 */
typedef struct {
    double ma;        /* Azimuth   misalignment of polar axis (arcsec) */
    double me;        /* Elevation misalignment of polar axis (arcsec) */
    double np;        /* Non perpendicularity of axes (arcsec)         */
    double ch;        /* Collimation error in HA (arcsec)              */
    double hf;        /* Horseshoe flexure coefficent (arcsec)         */
    double zgt;       /* Z-gear transducer reading                     */
    double adc_a;     /* ADC position angle for element A              */
    double adc_b;     /* ADC position angle for element A              */
} TdfFpilTelParams;
/*
 * exported function prototypes
 */
extern void  TdfFpil___SetupMinStructs(
    FpilCollisionChecksType *routines,
    FpilInstParamsType      *params);

extern void TdfFpilMinInit(FpilType *inst);
extern void TdfFpilFullInit(FpilType *inst);


#define TDFFPIL__MALLOCERR 10

#ifdef __cplusplus
}
#endif
#endif
