/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.FileBuffer;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.io.nio.HeaderException;
import com.terracottatech.frs.io.nio.NIOConstants;
import com.terracottatech.frs.io.nio.NIOStreamImpl;
import com.terracottatech.frs.io.nio.SegmentHeaders;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOSegment {
    static final int FILE_HEADER_SIZE = 42;
    private static final short IMPL_NUMBER = 2;
    private final NIOStreamImpl parent;
    private final int segNum;
    private final File src;
    private long lowestMarker;
    private long minMarker;
    private boolean wasClosed;
    private long size;
    private UUID streamId;
    static final Logger LOGGER = LoggerFactory.getLogger(IOManager.class);

    NIOSegment(NIOStreamImpl p, File file) {
        this.parent = p;
        this.src = file;
        this.segNum = NIOConstants.convertSegmentNumber(file);
    }

    File getFile() {
        return this.src;
    }

    NIOStreamImpl getStream() {
        return this.parent;
    }

    private FileChannel createFileChannel() throws IOException {
        return new FileInputStream(this.getFile()).getChannel();
    }

    NIOSegment openForHeader() throws IOException, HeaderException {
        FileBuffer buffer = this.parent != null ? this.parent.createFileBuffer(this.createFileChannel(), 42) : new FileBuffer(this.createFileChannel(), ByteBuffer.allocate(42));
        this.size = buffer.size();
        if (this.size < 42L) {
            buffer.close();
            throw new HeaderException("bad header", this);
        }
        buffer.read(1);
        this.readFileHeader(buffer);
        this.wasClosed = this.wasProperlyClosed(buffer);
        buffer.close();
        return this;
    }

    void readFileHeader(Chunk readBuffer) throws IOException, HeaderException {
        if (readBuffer.remaining() < 42L) {
            throw new IOException("file buffering size too small");
        }
        byte[] code = new byte[4];
        if (readBuffer.get(code) != 4) {
            throw new HeaderException("empty file", this);
        }
        if (!SegmentHeaders.LOG_FILE.validate(code)) {
            throw new HeaderException("file header is corrupted " + new String(code), this);
        }
        short impl = readBuffer.getShort();
        int checkSeg = readBuffer.getInt();
        if (this.segNum != checkSeg) {
            throw new HeaderException("the filename does not match the internal file structure", this);
        }
        if (impl != 2) {
            throw new HeaderException("unknown implementation number", this);
        }
        this.streamId = new UUID(readBuffer.getLong(), readBuffer.getLong());
        this.lowestMarker = readBuffer.getLong();
        this.minMarker = readBuffer.getLong();
    }

    void insertFileHeader(long lowestMarker, long marker) throws IOException {
        this.lowestMarker = lowestMarker;
        this.minMarker = marker;
        if (lowestMarker < 99L || marker < 99L) {
            throw new AssertionError((Object)"bad markers");
        }
        this.streamId = this.parent != null ? this.parent.getStreamId() : UUID.randomUUID();
    }

    public int getSegmentId() {
        return this.segNum;
    }

    UUID getStreamId() {
        return this.streamId;
    }

    long getBaseMarker() {
        return this.minMarker;
    }

    long getMinimumMarker() {
        return this.lowestMarker;
    }

    long size() {
        return this.size;
    }

    public boolean wasProperlyClosed() {
        return this.wasClosed;
    }

    private boolean wasProperlyClosed(FileBuffer buffer) throws IOException {
        buffer.clear();
        buffer.position(buffer.size() - (long)buffer.capacity()).read(1);
        int fileEnd = buffer.getInt(buffer.remaining() - 4L);
        return SegmentHeaders.CLOSE_FILE.validate(fileEnd) || SegmentHeaders.JUMP_LIST.validate(fileEnd);
    }

    public String toString() {
        return "NIOSegment{segNum=" + this.segNum + ", src=" + this.src + ", lowestMarker=" + this.lowestMarker + ", minMarker=" + this.minMarker + ", wasClosed=" + this.wasClosed + '}';
    }
}

