# t00082 - Test case for advanced diagram filter inclusion test with subclasses and namespaces
## Config
```yaml
diagrams:
  t00082_class:
    type: class
    glob:
      - t00082.cc
    generate_packages: true
    filter_mode: advanced
    include:
      anyof:
        subclasses:
          - clanguml::t00082::ns1::nsA::A1
        namespaces:
          - clanguml::t00082::ns2::nsB
        context:
          - clanguml::t00082::ns3::nsC::B3
    exclude:
      allof:
        elements:
          - clanguml::t00082::ns1::nsA::D1
    using_namespace: clanguml::t00082
```
## Source code
File `tests/t00082/t00082.cc`
```cpp
namespace clanguml::t00082 {
namespace ns1 {
namespace nsA {
struct A1 { };
struct B1 : public A1 { };
struct C1 : public B1 { };
struct D1 : public C1 { };
}
}
namespace ns2 {
namespace nsB {
struct A2 { };
struct B2 : public A2 { };
struct C2 : public B2 { };
}
}
namespace ns3 {
namespace nsC {
struct A3 { };
struct B3 : public A3 { };
struct C3 : public B3 { };
struct D3 { };
}
}
namespace ns4 {
namespace nsD {
struct A4 { };
}
}
}
```
## Generated PlantUML diagrams
![t00082_class](./t00082_class.svg "Test case for advanced diagram filter inclusion test with subclasses and namespaces")
## Generated Mermaid diagrams
![t00082_class](./t00082_class_mermaid.svg "Test case for advanced diagram filter inclusion test with subclasses and namespaces")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "display_name": "ns1",
      "elements": [
        {
          "display_name": "nsA",
          "elements": [
            {
              "bases": [],
              "display_name": "A1",
              "id": "12142696412443839931",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "A1",
              "namespace": "clanguml::t00082::ns1::nsA",
              "source_location": {
                "column": 8,
                "file": "t00082.cc",
                "line": 4,
                "translation_unit": "t00082.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [
                {
                  "access": "public",
                  "id": "12142696412443839931",
                  "is_virtual": false
                }
              ],
              "display_name": "B1",
              "id": "15596320250571206658",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "B1",
              "namespace": "clanguml::t00082::ns1::nsA",
              "source_location": {
                "column": 8,
                "file": "t00082.cc",
                "line": 5,
                "translation_unit": "t00082.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [
                {
                  "access": "public",
                  "id": "15596320250571206658",
                  "is_virtual": false
                }
              ],
              "display_name": "C1",
              "id": "1635220505473283595",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "C1",
              "namespace": "clanguml::t00082::ns1::nsA",
              "source_location": {
                "column": 8,
                "file": "t00082.cc",
                "line": 6,
                "translation_unit": "t00082.cc"
              },
              "template_parameters": [],
              "type": "class"
            }
          ],
          "name": "nsA",
          "type": "namespace"
        }
      ],
      "name": "ns1",
      "type": "namespace"
    },
    {
      "display_name": "ns2",
      "elements": [
        {
          "display_name": "nsB",
          "elements": [
            {
              "bases": [],
              "display_name": "A2",
              "id": "16760820400747278589",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "A2",
              "namespace": "clanguml::t00082::ns2::nsB",
              "source_location": {
                "column": 8,
                "file": "t00082.cc",
                "line": 12,
                "translation_unit": "t00082.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [
                {
                  "access": "public",
                  "id": "16760820400747278589",
                  "is_virtual": false
                }
              ],
              "display_name": "B2",
              "id": "15689724057597125831",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "B2",
              "namespace": "clanguml::t00082::ns2::nsB",
              "source_location": {
                "column": 8,
                "file": "t00082.cc",
                "line": 13,
                "translation_unit": "t00082.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [
                {
                  "access": "public",
                  "id": "15689724057597125831",
                  "is_virtual": false
                }
              ],
              "display_name": "C2",
              "id": "600480210374819483",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "C2",
              "namespace": "clanguml::t00082::ns2::nsB",
              "source_location": {
                "column": 8,
                "file": "t00082.cc",
                "line": 14,
                "translation_unit": "t00082.cc"
              },
              "template_parameters": [],
              "type": "class"
            }
          ],
          "name": "nsB",
          "type": "namespace"
        }
      ],
      "name": "ns2",
      "type": "namespace"
    },
    {
      "display_name": "ns3",
      "elements": [
        {
          "display_name": "nsC",
          "elements": [
            {
              "bases": [],
              "display_name": "A3",
              "id": "3338977750360426719",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "A3",
              "namespace": "clanguml::t00082::ns3::nsC",
              "source_location": {
                "column": 8,
                "file": "t00082.cc",
                "line": 19,
                "translation_unit": "t00082.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [
                {
                  "access": "public",
                  "id": "3338977750360426719",
                  "is_virtual": false
                }
              ],
              "display_name": "B3",
              "id": "16268840963729643490",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "B3",
              "namespace": "clanguml::t00082::ns3::nsC",
              "source_location": {
                "column": 8,
                "file": "t00082.cc",
                "line": 20,
                "translation_unit": "t00082.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [
                {
                  "access": "public",
                  "id": "16268840963729643490",
                  "is_virtual": false
                }
              ],
              "display_name": "C3",
              "id": "6275205058551246711",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "C3",
              "namespace": "clanguml::t00082::ns3::nsC",
              "source_location": {
                "column": 8,
                "file": "t00082.cc",
                "line": 21,
                "translation_unit": "t00082.cc"
              },
              "template_parameters": [],
              "type": "class"
            }
          ],
          "name": "nsC",
          "type": "namespace"
        }
      ],
      "name": "ns3",
      "type": "namespace"
    }
  ],
  "name": "t00082_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "12142696412443839931",
      "source": "15596320250571206658",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "15596320250571206658",
      "source": "1635220505473283595",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "16760820400747278589",
      "source": "15689724057597125831",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "15689724057597125831",
      "source": "600480210374819483",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "3338977750360426719",
      "source": "16268840963729643490",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "16268840963729643490",
      "source": "6275205058551246711",
      "type": "extension"
    }
  ],
  "using_namespace": "clanguml::t00082"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00082</data>
  <node id="n0">
   <data key="nd2">ns1</data>
   <data key="nd1">namespace</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n1">
     <data key="nd2">nsA</data>
     <data key="nd1">namespace</data>
     <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n2">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[A1]]></data>
       <data key="nd6">false</data>
      </node>
      <node id="n3">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[B1]]></data>
       <data key="nd6">false</data>
      </node>
      <node id="n4">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[C1]]></data>
       <data key="nd6">false</data>
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <node id="n5">
   <data key="nd2">ns2</data>
   <data key="nd1">namespace</data>
   <graph id="g3" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n6">
     <data key="nd2">nsB</data>
     <data key="nd1">namespace</data>
     <graph id="g4" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n7">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[A2]]></data>
       <data key="nd6">false</data>
      </node>
      <node id="n8">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[B2]]></data>
       <data key="nd6">false</data>
      </node>
      <node id="n9">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[C2]]></data>
       <data key="nd6">false</data>
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <node id="n10">
   <data key="nd2">ns3</data>
   <data key="nd1">namespace</data>
   <graph id="g5" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n11">
     <data key="nd2">nsC</data>
     <data key="nd1">namespace</data>
     <graph id="g6" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n12">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[A3]]></data>
       <data key="nd6">false</data>
      </node>
      <node id="n13">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[B3]]></data>
       <data key="nd6">false</data>
      </node>
      <node id="n14">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[C3]]></data>
       <data key="nd6">false</data>
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <edge id="e0" source="n3" target="n2">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n4" target="n3">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n8" target="n7">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n9" target="n8">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n13" target="n12">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n14" target="n13">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
