# t00079 - Test case for context diagram exclude filter with relationships option
## Config
```yaml
diagrams:
  t00079_class:
    type: class
    glob:
      - t00079.cc
    include:
      namespaces:
        - clanguml::t00079
    exclude:
      context:
        - match:
            radius: 1
            pattern: clanguml::t00079::A
            relationships:
              - inheritance
              - aggregation
    using_namespace: clanguml::t00079
```
## Source code
File `tests/t00079/t00079.cc`
```cpp
namespace clanguml {
namespace t00079 {

struct Base { };

struct D { };
struct E { };
struct A : public Base {
    D d;
    E *e;
};

struct B {
    A *a;
};

struct C {
    A a;
};

}
}
```
## Generated PlantUML diagrams
![t00079_class](./t00079_class.svg "Test case for context diagram exclude filter with relationships option")
## Generated Mermaid diagrams
![t00079_class](./t00079_class_mermaid.svg "Test case for context diagram exclude filter with relationships option")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "E",
      "id": "18284199960848715524",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "E",
      "namespace": "clanguml::t00079",
      "source_location": {
        "column": 8,
        "file": "t00079.cc",
        "line": 7,
        "translation_unit": "t00079.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B",
      "id": "17719745761779016384",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "a",
          "source_location": {
            "column": 8,
            "file": "t00079.cc",
            "line": 14,
            "translation_unit": "t00079.cc"
          },
          "type": "A *"
        }
      ],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00079",
      "source_location": {
        "column": 8,
        "file": "t00079.cc",
        "line": 13,
        "translation_unit": "t00079.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00079_class",
  "package_type": "namespace",
  "relationships": [],
  "using_namespace": "clanguml::t00079"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00079</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[E]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
  </node>
 </graph>
</graphml>

```
