# t00040 - Relationship and access filter test
## Config
```yaml
diagrams:
  t00040_class:
    type: class
    generate_packages: false
    glob:
      - t00040.cc
    using_namespace: clanguml::t00040
    include:
      namespaces:
        - clanguml::t00040
      access:
        - public
        - protected
    exclude:
      relationships:
        - dependency
      elements:
        - clanguml::t00040::B
```
## Source code
File `tests/t00040/t00040.cc`
```cpp
namespace clanguml::t00040 {

struct B { };

struct A {
public:
    int get_a() { return hidden_a_; }

protected:
    int ii_;

private:
    void foo() { }

    int hidden_a_;
};

class AA : public A {
public:
};

class AAA : public AA {
public:
    int get_aaa() { return hidden_aaa_; }
    B *b;

private:
    int hidden_aaa_;
};

struct R {
    void foo(A *a) { }
};

} // namespace clanguml::t00040

```
## Generated PlantUML diagrams
![t00040_class](./t00040_class.svg "Relationship and access filter test")
## Generated Mermaid diagrams
![t00040_class](./t00040_class_mermaid.svg "Relationship and access filter test")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A",
      "id": "2460640048669901416",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "protected",
          "is_static": false,
          "name": "ii_",
          "source_location": {
            "column": 9,
            "file": "t00040.cc",
            "line": 10,
            "translation_unit": "t00040.cc"
          },
          "type": "int"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "get_a",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_a",
          "parameters": [],
          "source_location": {
            "column": 9,
            "file": "t00040.cc",
            "line": 7,
            "translation_unit": "t00040.cc"
          },
          "template_parameters": [],
          "type": "int"
        }
      ],
      "name": "A",
      "namespace": "clanguml::t00040",
      "source_location": {
        "column": 8,
        "file": "t00040.cc",
        "line": 5,
        "translation_unit": "t00040.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "2460640048669901416",
          "is_virtual": false
        }
      ],
      "display_name": "AA",
      "id": "4272926502238129020",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "AA",
      "namespace": "clanguml::t00040",
      "source_location": {
        "column": 7,
        "file": "t00040.cc",
        "line": 18,
        "translation_unit": "t00040.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "4272926502238129020",
          "is_virtual": false
        }
      ],
      "display_name": "AAA",
      "id": "5962975267457266952",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "b",
          "source_location": {
            "column": 8,
            "file": "t00040.cc",
            "line": 25,
            "translation_unit": "t00040.cc"
          },
          "type": "B *"
        }
      ],
      "methods": [
        {
          "access": "public",
          "display_name": "get_aaa",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "get_aaa",
          "parameters": [],
          "source_location": {
            "column": 9,
            "file": "t00040.cc",
            "line": 24,
            "translation_unit": "t00040.cc"
          },
          "template_parameters": [],
          "type": "int"
        }
      ],
      "name": "AAA",
      "namespace": "clanguml::t00040",
      "source_location": {
        "column": 7,
        "file": "t00040.cc",
        "line": 22,
        "translation_unit": "t00040.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "12312280167800812318",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "foo",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "foo",
          "parameters": [
            {
              "name": "a",
              "type": "A *"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00040.cc",
            "line": 32,
            "translation_unit": "t00040.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "R",
      "namespace": "clanguml::t00040",
      "source_location": {
        "column": 8,
        "file": "t00040.cc",
        "line": 31,
        "translation_unit": "t00040.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00040_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "2460640048669901416",
      "source": "4272926502238129020",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "4272926502238129020",
      "source": "5962975267457266952",
      "type": "extension"
    }
  ],
  "using_namespace": "clanguml::t00040"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00040</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[AA]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[AAA]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
  </node>
  <edge id="e0" source="n1" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n2" target="n1">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
