# t00032 - Class template with template base classes test case
## Config
```yaml
diagrams:
  t00032_class:
    type: class
    glob:
      - t00032.cc
    using_namespace: clanguml::t00032
    include:
      namespaces:
        - clanguml::t00032

```
## Source code
File `tests/t00032/t00032.cc`
```cpp
#include <memory>
#include <vector>

namespace clanguml {
namespace t00032 {

struct Base { };

struct TBase { };

struct A {
    void operator()() { }
};

struct B {
    void operator()() { }
};

struct C {
    void operator()() { }
};

template <typename T, typename L, typename... Ts>
struct Overload : public Base, public T, public Ts... {
    using Ts::operator()...;
    L counter;
};

template <class... Ts> Overload(Ts...) -> Overload<Ts...>;

struct R {
    Overload<TBase, int, A, B, C> overload;
};

} // namespace t00032
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00032_class](./t00032_class.svg "Class template with template base classes test case")
## Generated Mermaid diagrams
![t00032_class](./t00032_class_mermaid.svg "Class template with template base classes test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "Base",
      "id": "12955169833821057686",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "Base",
      "namespace": "clanguml::t00032",
      "source_location": {
        "column": 8,
        "file": "t00032.cc",
        "line": 7,
        "translation_unit": "t00032.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "TBase",
      "id": "4350215636817022017",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "TBase",
      "namespace": "clanguml::t00032",
      "source_location": {
        "column": 8,
        "file": "t00032.cc",
        "line": 9,
        "translation_unit": "t00032.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A",
      "id": "5503278826664569878",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "operator()",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": true,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "operator()",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00032.cc",
            "line": 12,
            "translation_unit": "t00032.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "A",
      "namespace": "clanguml::t00032",
      "source_location": {
        "column": 8,
        "file": "t00032.cc",
        "line": 11,
        "translation_unit": "t00032.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B",
      "id": "5897880462208237975",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "operator()",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": true,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "operator()",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00032.cc",
            "line": 16,
            "translation_unit": "t00032.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "B",
      "namespace": "clanguml::t00032",
      "source_location": {
        "column": 8,
        "file": "t00032.cc",
        "line": 15,
        "translation_unit": "t00032.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C",
      "id": "11983714054920587061",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "operator()",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": true,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": false,
          "name": "operator()",
          "parameters": [],
          "source_location": {
            "column": 10,
            "file": "t00032.cc",
            "line": 20,
            "translation_unit": "t00032.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "C",
      "namespace": "clanguml::t00032",
      "source_location": {
        "column": 8,
        "file": "t00032.cc",
        "line": 19,
        "translation_unit": "t00032.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "12955169833821057686",
          "is_virtual": false
        }
      ],
      "display_name": "Overload<T,L,Ts...>",
      "id": "11707383983765533439",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "counter",
          "source_location": {
            "column": 7,
            "file": "t00032.cc",
            "line": 26,
            "translation_unit": "t00032.cc"
          },
          "type": "L"
        }
      ],
      "methods": [],
      "name": "Overload",
      "namespace": "clanguml::t00032",
      "source_location": {
        "column": 8,
        "file": "t00032.cc",
        "line": 24,
        "translation_unit": "t00032.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        },
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "L",
          "template_parameters": []
        },
        {
          "is_variadic": true,
          "kind": "template_type",
          "name": "Ts...",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "4350215636817022017",
          "is_virtual": false
        },
        {
          "access": "public",
          "id": "5503278826664569878",
          "is_virtual": false
        },
        {
          "access": "public",
          "id": "5897880462208237975",
          "is_virtual": false
        },
        {
          "access": "public",
          "id": "11983714054920587061",
          "is_virtual": false
        }
      ],
      "display_name": "Overload<TBase,int,A,B,C>",
      "id": "13651640377415034291",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "Overload",
      "namespace": "clanguml::t00032",
      "source_location": {
        "column": 35,
        "file": "t00032.cc",
        "line": 32,
        "translation_unit": "t00032.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "TBase"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "int"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "A"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "B"
        },
        {
          "is_variadic": false,
          "kind": "argument",
          "template_parameters": [],
          "type": "C"
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "684318938660586562",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "overload",
          "source_location": {
            "column": 35,
            "file": "t00032.cc",
            "line": 32,
            "translation_unit": "t00032.cc"
          },
          "type": "Overload<TBase,int,A,B,C>"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00032",
      "source_location": {
        "column": 8,
        "file": "t00032.cc",
        "line": 31,
        "translation_unit": "t00032.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00032_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "12955169833821057686",
      "source": "11707383983765533439",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "4350215636817022017",
      "source": "13651640377415034291",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "5503278826664569878",
      "source": "13651640377415034291",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "5897880462208237975",
      "source": "13651640377415034291",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "11983714054920587061",
      "source": "13651640377415034291",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "11707383983765533439",
      "source": "13651640377415034291",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "13651640377415034291",
      "label": "overload",
      "source": "684318938660586562",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00032"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00032</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Base]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[TBase]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Overload<T,L,Ts...>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Overload<TBase,int,A,B,C>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
  </node>
  <edge id="e0" source="n5" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n6" target="n1">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n6" target="n2">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n6" target="n3">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n6" target="n4">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n6" target="n5">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n7" target="n6">
   <data key="ed0">aggregation</data>
   <data key="ed2">overload</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
