<p align="center">
  <img
    width="400"
    src="https://raw.githubusercontent.com/starship/starship/master/media/logo.png"
    alt="Starship – Cross-shell prompt"
 />
</p>

<p align="center">
  <a href="https://github.com/starship/starship/actions"
    ><img
      src="https://img.shields.io/github/actions/workflow/status/starship/starship/workflow.yml?branch=master&label=workflow&style=flat-square"
      alt="GitHub Actions workflow status"
 /></a>
  <a href="https://crates.io/crates/starship"
    ><img
      src="https://img.shields.io/crates/v/starship?style=flat-square"
      alt="Crates.io version"
 /></a>
  <a href="https://repology.org/project/starship/versions"
    ><img
      src="https://img.shields.io/repology/repositories/starship?label=in%20repositories&style=flat-square"
      alt="Packaging status" /></a
><br />
  <a href="https://discord.gg/starship"
    ><img
      src="https://img.shields.io/discord/567163873606500352?label=discord&logoColor=white&style=flat-square"
      alt="Chat on Discord"
 /></a>
  <a href="https://twitter.com/StarshipPrompt"
    ><img
      src="https://img.shields.io/badge/twitter-@StarshipPrompt-1DA1F3?style=flat-square"
      alt="Follow @StarshipPrompt on Twitter"
 /></a>
  <a href="https://stand-with-ukraine.pp.ua"
    ><img
      src="https://raw.githubusercontent.com/vshymanskyy/StandWithUkraine/main/badges/StandWithUkraineFlat.svg"
      alt="Stand With Ukraine"
 /></a>
</p>

<p align="center">
  <a href="https://starship.rs">ওয়েবসাইট</a>
 · 
<a href="#🚀-installation">ইন্সটল</a>
 ·
<a href="https://starship.rs/config/"> কনফিগ</a>
</p>

<p align="center">
  <a href="https://github.com/starship/starship/blob/master/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-us.png"
      alt="English"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/de-DE/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-de.png"
      alt="Deutsch"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/es-ES/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-es.png"
      alt="Español"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/fr-FR/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-fr.png"
      alt="Français"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/id-ID/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-id.png"
      alt="Bahasa Indonesia"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/it-IT/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-it.png"
      alt="Italiano"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/ja-JP/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-jp.png"
      alt="日本語"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/pt-BR/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-br.png"
      alt="Português do Brasil"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/ru-RU/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-ru.png"
      alt="Русский"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/uk-UA/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-ua.png"
      alt="Українська"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/vi-VN/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-vn.png"
      alt="Tiếng Việt"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/zh-CN/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-cn.png"
      alt="简体中文"
 /></a>
  &nbsp;
  <a
    href="https://github.com/starship/starship/blob/master/docs/zh-TW/guide/README.md"
    ><img
      height="20"
      src="https://raw.githubusercontent.com/starship/starship/master/media/flag-tw.png"
      alt="繁體中文"
 /></a>
</p>

<h1></h1>

<img
  src="https://raw.githubusercontent.com/starship/starship/master/media/demo.gif"
  alt="Starship with iTerm2 and the Snazzy theme"
  width="50%"
  align="right"
 />

**আপনার টার্মিনাল এর জন্য একটি সহজ, প্রচণ্ড দ্রুত এবং অশেষভাবে কাস্টমাইজ করার  মতো সুবিধাসম্পন্ন একটি প্রম্প্ট!**

- **দ্রুত:** দ্রুত - সত্যি সত্যিই _অনেক_ দ্রুত! 🚀
- **কাস্টমাইজ করার সুবিধা:** প্রম্পটের প্রতিটি দিক কনফিগ করুন মন মত ।
- **ব্যতিক্রমহীন:** যেকোনো অপারেটিং সিস্টেম ও শেলে কাজ করে ।
- **চালাক:** এক নজরে দরকারি সকল তথ্য দেখা যায় ।
- **ফিচার সমৃদ্ধ:** আপনার প্রিয় সকল টুল ব্যবহার করতে পারবেন ।
- **সহজ:** অনায়াসে ইন্সটল করুন – মিনিটের মধ্যে ব্যবহার শুরু করে দিন ।

<p align="center">
<a href="https://starship.rs/config/"><strong>Starship এর ডকুমেন্টেশন ঘুরে দেখুন&nbsp;&nbsp;▶</strong></a>
</p>

<a name="🚀-installation"></a>

## 🚀 ইন্সটল

### পূর্বশর্ত

- আপনার থেকে টার্মিনালে একটি [Nerd Font](https://www.nerdfonts.com/) ব্যবহার করতে হবে (উদাহরণস্বরূপ আপনি [FiraCode Nerd Font](https://www.nerdfonts.com/font-downloads) টি ব্যবহার করতে পারেন) ।

### ধাপ ১.  Starship ইন্সটল করুন

ইনস্টলেশন নির্দেশিকা দেখতে নিচের তালিকা থেকে আপনার অপারেটিং সিস্টেম বাছাই করুন:

<details>
<summary>অ্যান্ড্রয়েড</summary>

নিম্নলিখিত প্যাকেজ ম্যানেজার গুলোর মধ্যে থেকে যেকোনো একটি ব্যবহার করে Starship ইন্সটল করুন:

| রিপোজিটরি                                                                         | নির্দেশাবলী            |
| --------------------------------------------------------------------------------- | ---------------------- |
| [Termux](https://github.com/termux/termux-packages/tree/master/packages/starship) | `pkg install starship` |

</details>

<details>
<summary>বিএসডি</summary>

নিম্নলিখিত প্যাকেজ ম্যানেজার গুলোর মধ্যে থেকে যেকোনো একটি ব্যবহার করে Starship ইন্সটল করুন:

| ডিস্ট্রিবিউশন | রিপোজিটরি                                                | নির্দেশাবলী                       |
| ------------- | -------------------------------------------------------- | --------------------------------- |
| **_যেকোনো_**  | **[crates.io](https://crates.io/crates/starship)**       | `cargo install starship --locked` |
| FreeBSD       | [FreshPorts](https://www.freshports.org/shells/starship) | `pkg install starship`            |
| NetBSD        | [pkgsrc](https://pkgsrc.se/shells/starship)              | `pkgin install starship`          |

</details>

<details>
<summary>লিনাক্স </summary>

আপনার সিস্টেম এর জন্য লেটেস্ট সংস্করণটি ইন্সটল করুন:

```sh
curl -sS https://starship.rs/install.sh | sh
```

অথবা, নিম্নলিখিত প্যাকেজ ম্যানেজার গুলোর মধ্যে থেকে যেকোনো একটি ব্যবহার করে Starship ইন্সটল করুন:

| ডিস্ট্রিবিউশন      | রিপোজিটরি                                                                                       | নির্দেশাবলী                                                                    |
| ------------------ | ----------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------ |
| **_যেকোনো_**       | **[crates.io](https://crates.io/crates/starship)**                                              | `cargo install starship --locked`                                              |
| _যেকোনো_           | [conda-forge](https://anaconda.org/conda-forge/starship)                                        | `conda install -c conda-forge starship`                                        |
| _যেকোনো_           | [Linuxbrew](https://formulae.brew.sh/formula/starship)                                          | `brew install starship`                                                        |
| Alpine Linux 3.13+ | [Alpine Linux Packages](https://pkgs.alpinelinux.org/packages?name=starship)                    | `apk add starship`                                                             |
| Arch Linux         | [Arch Linux Extra](https://archlinux.org/packages/extra/x86_64/starship)                        | `pacman -S starship`                                                           |
| CentOS 7+          | [Copr](https://copr.fedorainfracloud.org/coprs/atim/starship)                                   | `dnf copr enable atim/starship` <br /> `dnf install starship` |
| Gentoo             | [Gentoo Packages](https://packages.gentoo.org/packages/app-shells/starship)                     | `emerge app-shells/starship`                                                   |
| Manjaro            |                                                                                                 | `pacman -S starship`                                                           |
| NixOS              | [nixpkgs](https://github.com/NixOS/nixpkgs/blob/master/pkgs/tools/misc/starship/default.nix)    | `nix-env -iA nixpkgs.starship`                                                 |
| openSUSE           | [OSS](https://software.opensuse.org/package/starship)                                           | `zypper in starship`                                                           |
| Void Linux         | [Void Linux Packages](https://github.com/void-linux/void-packages/tree/master/srcpkgs/starship) | `xbps-install -S starship`                                                     |

</details>

<details>
<summary>ম্যাক ওএস </summary>

আপনার সিস্টেম এর জন্য লেটেস্ট সংস্করণটি ইন্সটল করুন:

```sh
curl -sS https://starship.rs/install.sh | sh
```

অথবা, নিম্নলিখিত প্যাকেজ ম্যানেজার গুলোর মধ্যে থেকে যেকোনো একটি ব্যবহার করে Starship ইন্সটল করুন:

| রিপোজিটরি                                                | নির্দেশাবলী                             |
| -------------------------------------------------------- | --------------------------------------- |
| **[crates.io](https://crates.io/crates/starship)**       | `cargo install starship --locked`       |
| [conda-forge](https://anaconda.org/conda-forge/starship) | `conda install -c conda-forge starship` |
| [Homebrew](https://formulae.brew.sh/formula/starship)    | `brew install starship`                 |
| [MacPorts](https://ports.macports.org/port/starship)     | `port install starship`                 |

</details>

<details>
<summary>উইন্ডোজ</summary>

আপনার সিস্টেম এর জন্য লেটেস্ট সংস্করণটি [রিলিজ সেকশনে](https://github.com/starship/starship/releases/latest) থাকা MSI-ইন্সটলার ব্যবহার করে ইন্সটল করুন ।

নিম্নলিখিত প্যাকেজ ম্যানেজার গুলোর মধ্যে থেকে যেকোনো একটি ব্যবহার করে Starship ইন্সটল করুন:

| রিপোজিটরি                                                                                    | নির্দেশাবলী                             |
| -------------------------------------------------------------------------------------------- | --------------------------------------- |
| **[crates.io](https://crates.io/crates/starship)**                                           | `cargo install starship --locked`       |
| [Chocolatey](https://community.chocolatey.org/packages/starship)                             | `choco install starship`                |
| [conda-forge](https://anaconda.org/conda-forge/starship)                                     | `conda install -c conda-forge starship` |
| [Scoop](https://github.com/ScoopInstaller/Main/blob/master/bucket/starship.json)             | `scoop install starship`                |
| [winget](https://github.com/microsoft/winget-pkgs/tree/master/manifests/s/Starship/Starship) | `winget install --id Starship.Starship` |

</details>

### ধাপ ২. Starship ব্যবহার করার জন্য আপনার শেল প্রস্তুত করুন

Starship চালু করতে আপনার শেল কে ঠিক মতো কনফিগার করুন । নিম্নলিখিত তালিকা থেকে আপনার শেল বাছাই করুন:

<details>
<summary>Bash</summary>

`~/.bashrc` এর শেষে নিম্নলিখিত লাইন টি যোগ করুন:

```sh
eval "$(starship init bash)"
```

</details>

<details>
<summary>Cmd</summary>

আপনাকে Cmd এর সাথে [Clink](https://chrisant996.github.io/clink/clink.html) (v1.2.30+) ব্যবহার করতে হবে । `%LocalAppData%\clink\starship.lua` ফাইল টি তৈরি করে তার মধ্যে নিম্নলিখিত লাইন টি যোগ করুন:

```lua
load(io.popen('starship init cmd'):read("*a"))()
```

</details>

<details>
<summary>Elvish</summary>

`~/.elvish/rc.elv` এর শেষে নিম্নলিখিত লাইন টি যোগ করুন:

```sh
eval (starship init elvish)
```

বিঃদ্রঃ শুধুমাত্র Elvish v0.18+ কাজ করবে ।

</details>

<details>
<summary>Fish</summary>

`~/.config/fish/config.fish` এর শেষে নিম্নলিখিত লাইন টি যোগ করুন:

```fish
starship init fish | source
```

</details>

<details>
<summary>Ion</summary>

`~/.config/ion/initrc` এর শেষে নিম্নলিখিত লাইন টি যোগ করুন:

```sh
eval $(starship init ion)
```

</details>

<details>
<summary>Nushell</summary>

আপনার Nushell env ফাইলের (Nushell এ `$nu.env-path` কমান্ডটি রান করে ফাইলটি খুঁজে বের করুন) শেষে নিম্নলিখিত লাইনগুলি যোগ করুন:

```sh
mkdir ~/.cache/starship
starship init nu | save -f ~/.cache/starship/init.nu
```

এরপর আপনার Nushell কনফিগের (Nushell এ `$nu.config-path` কমান্ডটি রান করে ফাইলটি খুঁজে বের করুন) শেষে নিম্নলিখিত লাইনটি যোগ করুন:

```sh
use ~/.cache/starship/init.nu
```

বিঃদ্রঃ শুধুমাত্র Nushell v0.78+ কাজ করবে ।

</details>

<details>
<summary>PowerShell</summary>

আপনার PowerShell কনফিগের (PowerShell এ `$PROFILE` কমান্ডটি রান করে ফাইলটি খুঁজে বের করুন) শেষে নিম্নলিখিত লাইনটি যোগ করুন:

```powershell
Invoke-Expression (&starship init powershell)
```

</details>

<details>
<summary>Tcsh</summary>

`~/.tcshrc` এর শেষে নিম্নলিখিত লাইন টি যোগ করুন:

```sh
eval `starship init tcsh`
```

</details>

<details>
<summary>Xonsh</summary>

`~/.xonshrc` এর শেষে নিম্নলিখিত লাইন টি যোগ করুন:

```python
execx($(starship init xonsh))
```

</details>

<details>
<summary>Zsh</summary>

`~/.zshrc` এর শেষে নিম্নলিখিত লাইন টি যোগ করুন:

```sh
eval "$(starship init zsh)"
```

</details>

### ধাপ ৩. Starship কনফিগার করুন

নতুন একটি শেল চালু করুন, এরপর আপনি আপনার সুন্দর নতুন শেল প্রম্প্ট দেখতে পাবেন । পূর্ব নির্ধারিত কনফিগ যদি ভালো লেগে থাকে, তাহলে উপভোগ করুন!

আপনি যদি Starship কে নিজের মতো করে কাস্টমাইজ করতে চান:

- **[কনফিগারেশন](https://starship.rs/config/)** – আপনার নিজের ইচ্ছা মতো নিজের প্রম্প্টকে পরিবর্তন করতে শিখুন

- **[অন্যদের তৈরি কনফিগ](https://starship.rs/presets/)** – অন্যদের তৈরি করা সুন্দর কনফিগ দেখে অনুপ্রাণিত হন

## 🤝 নিজে অবদান রাখুন

আমরা সবসময় **সকল দক্ষতা স্তরের** অবদানকারীদের খুঁজছি! আপনি যদি সহজ ভাবে এই প্রোজেক্টে অবদান রাখতে চান তাইলে ["good first issue"](https://github.com/starship/starship/labels/🌱%20good%20first%20issue) গুলির সমাধান করার চেষ্টা করতে পারেন ।

আপনি যদি ইংরেজি ছাড়া অন্য কোন ভাষায় সাবলীল হন, তাহলে আপনি আমাদের ডকুমেন্টেশন অনুবাদে এবং আপ-টু-ডেট রাখতে সহায়তা করতে পারেন, আমরা খুবই কৃতজ্ঞ হব ।  যদি এক্ষেত্রে সাহায্য করতে চান, তাহলে [Starship Crowdin](https://translate.starship.rs/) পেইজ এ গিয়ে আপনার অনুবাদ গুলি যোগ করতে পারবেন ।

আপনি যদি Starship এ অবদান রাখতে আগ্রহী হন, অনুগ্রহ করে আমাদের অবদান রাখার [নির্দেশিকা ও নিয়মকানুন](https://github.com/starship/starship/blob/master/CONTRIBUTING.md) দেখে নিবেন ।  এছাড়াও, নির্দ্বিধায় আমাদের [Discord](https://discord.gg/8Jzqu3T) সার্ভারে এসে হাই বলে যান । 👋

## 💭 অনুপ্রেরণা

অনুগ্রহ করে Starship এর পূর্ববর্তী এইসব প্রোজেক্ট থেকে ঘুরে আসুন, যারা Starship তৈরিতে অনেক অনুপ্রেরণা দিয়েছে । 🙏

- **[denysdovhan/spaceship-prompt](https://github.com/denysdovhan/spaceship-prompt)** – A ZSH prompt for astronauts.

- **[denysdovhan/robbyrussell-node](https://github.com/denysdovhan/robbyrussell-node)** – Cross-shell robbyrussell theme written in JavaScript.

- **[reujab/silver](https://github.com/reujab/silver)** – A cross-shell customizable powerline-like prompt with icons.

## ❤️ স্পনসর

[একজন স্পনসর হয়ে](https://github.com/sponsors/starship) এই প্রোজেক্টটিকে আর্থিক ভাবে সহায়তা করুন । আপনার নাম অথবা লোগো নিম্নে দেখা যাবে আপনার ওয়েবসাইট এর লিঙ্ক সহ ।

<p align="center">
    <br>
    <img width="100" src="https://raw.githubusercontent.com/starship/starship/master/media/icon.png" alt="Starship rocket icon">
</p>

## 📝 লাইসেন্স

Copyright © 2019-present, [Starship Contributors](https://github.com/starship/starship/graphs/contributors).<br /> এই প্রোজেক্টটি [ISC](https://github.com/starship/starship/blob/master/LICENSE) লাইসেন্সের অধিনে রয়েছে ।
