// automatically generated by rust-bindgen 0.69.2

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }

    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }

    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }

    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const __bool_true_false_are_defined: u32 = 1;
pub const true_: u32 = 1;
pub const false_: u32 = 0;
pub const BSD: u32 = 199506;
pub const BSD4_3: u32 = 1;
pub const BSD4_4: u32 = 1;
pub const NeXTBSD: u32 = 1995064;
pub const NeXTBSD4_0: u32 = 0;
pub const __DARWIN_UNIX03: u32 = 1;
pub const __DARWIN_64_BIT_INO_T: u32 = 1;
pub const __DARWIN_VERS_1050: u32 = 1;
pub const __DARWIN_NON_CANCELABLE: u32 = 0;
pub const __DARWIN_SUF_UNIX03: &[u8; 10] = b"$UNIX2003\0";
pub const __DARWIN_SUF_64_BIT_INO_T: &[u8; 9] = b"$INODE64\0";
pub const __DARWIN_SUF_1050: &[u8; 6] = b"$1050\0";
pub const __DARWIN_SUF_EXTSN: &[u8; 14] = b"$DARWIN_EXTSN\0";
pub const __DARWIN_C_ANSI: u32 = 4096;
pub const __DARWIN_C_FULL: u32 = 900000;
pub const __DARWIN_C_LEVEL: u32 = 900000;
pub const __STDC_WANT_LIB_EXT1__: u32 = 1;
pub const __DARWIN_NO_LONG_LONG: u32 = 0;
pub const _DARWIN_FEATURE_64_BIT_INODE: u32 = 1;
pub const _DARWIN_FEATURE_UNIX_CONFORMANCE: u32 = 3;
pub const __PTHREAD_SIZE__: u32 = 8176;
pub const __PTHREAD_ATTR_SIZE__: u32 = 56;
pub const __PTHREAD_MUTEXATTR_SIZE__: u32 = 8;
pub const __PTHREAD_MUTEX_SIZE__: u32 = 56;
pub const __PTHREAD_CONDATTR_SIZE__: u32 = 8;
pub const __PTHREAD_COND_SIZE__: u32 = 40;
pub const __PTHREAD_ONCE_SIZE__: u32 = 8;
pub const __PTHREAD_RWLOCK_SIZE__: u32 = 192;
pub const __PTHREAD_RWLOCKATTR_SIZE__: u32 = 16;
pub const _QUAD_HIGHWORD: u32 = 1;
pub const _QUAD_LOWWORD: u32 = 0;
pub const __DARWIN_LITTLE_ENDIAN: u32 = 1234;
pub const __DARWIN_BIG_ENDIAN: u32 = 4321;
pub const __DARWIN_PDP_ENDIAN: u32 = 3412;
pub const __DARWIN_BYTE_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const __API_TO_BE_DEPRECATED: u32 = 100000;
pub const __API_TO_BE_DEPRECATED_MACOS: u32 = 100000;
pub const __API_TO_BE_DEPRECATED_IOS: u32 = 100000;
pub const __API_TO_BE_DEPRECATED_MACCATALYST: u32 = 100000;
pub const __API_TO_BE_DEPRECATED_WATCHOS: u32 = 100000;
pub const __API_TO_BE_DEPRECATED_TVOS: u32 = 100000;
pub const __API_TO_BE_DEPRECATED_DRIVERKIT: u32 = 100000;
pub const __API_TO_BE_DEPRECATED_VISIONOS: u32 = 100000;
pub const __MAC_10_0: u32 = 1000;
pub const __MAC_10_1: u32 = 1010;
pub const __MAC_10_2: u32 = 1020;
pub const __MAC_10_3: u32 = 1030;
pub const __MAC_10_4: u32 = 1040;
pub const __MAC_10_5: u32 = 1050;
pub const __MAC_10_6: u32 = 1060;
pub const __MAC_10_7: u32 = 1070;
pub const __MAC_10_8: u32 = 1080;
pub const __MAC_10_9: u32 = 1090;
pub const __MAC_10_10: u32 = 101000;
pub const __MAC_10_10_2: u32 = 101002;
pub const __MAC_10_10_3: u32 = 101003;
pub const __MAC_10_11: u32 = 101100;
pub const __MAC_10_11_2: u32 = 101102;
pub const __MAC_10_11_3: u32 = 101103;
pub const __MAC_10_11_4: u32 = 101104;
pub const __MAC_10_12: u32 = 101200;
pub const __MAC_10_12_1: u32 = 101201;
pub const __MAC_10_12_2: u32 = 101202;
pub const __MAC_10_12_4: u32 = 101204;
pub const __MAC_10_13: u32 = 101300;
pub const __MAC_10_13_1: u32 = 101301;
pub const __MAC_10_13_2: u32 = 101302;
pub const __MAC_10_13_4: u32 = 101304;
pub const __MAC_10_14: u32 = 101400;
pub const __MAC_10_14_1: u32 = 101401;
pub const __MAC_10_14_4: u32 = 101404;
pub const __MAC_10_14_5: u32 = 101405;
pub const __MAC_10_14_6: u32 = 101406;
pub const __MAC_10_15: u32 = 101500;
pub const __MAC_10_15_1: u32 = 101501;
pub const __MAC_10_15_4: u32 = 101504;
pub const __MAC_10_16: u32 = 101600;
pub const __MAC_11_0: u32 = 110000;
pub const __MAC_11_1: u32 = 110100;
pub const __MAC_11_3: u32 = 110300;
pub const __MAC_11_4: u32 = 110400;
pub const __MAC_11_5: u32 = 110500;
pub const __MAC_11_6: u32 = 110600;
pub const __MAC_12_0: u32 = 120000;
pub const __MAC_12_1: u32 = 120100;
pub const __MAC_12_2: u32 = 120200;
pub const __MAC_12_3: u32 = 120300;
pub const __MAC_12_4: u32 = 120400;
pub const __MAC_12_5: u32 = 120500;
pub const __MAC_12_6: u32 = 120600;
pub const __MAC_12_7: u32 = 120700;
pub const __MAC_13_0: u32 = 130000;
pub const __MAC_13_1: u32 = 130100;
pub const __MAC_13_2: u32 = 130200;
pub const __MAC_13_3: u32 = 130300;
pub const __MAC_13_4: u32 = 130400;
pub const __MAC_13_5: u32 = 130500;
pub const __MAC_13_6: u32 = 130600;
pub const __MAC_14_0: u32 = 140000;
pub const __MAC_14_1: u32 = 140100;
pub const __MAC_14_2: u32 = 140200;
pub const __IPHONE_2_0: u32 = 20000;
pub const __IPHONE_2_1: u32 = 20100;
pub const __IPHONE_2_2: u32 = 20200;
pub const __IPHONE_3_0: u32 = 30000;
pub const __IPHONE_3_1: u32 = 30100;
pub const __IPHONE_3_2: u32 = 30200;
pub const __IPHONE_4_0: u32 = 40000;
pub const __IPHONE_4_1: u32 = 40100;
pub const __IPHONE_4_2: u32 = 40200;
pub const __IPHONE_4_3: u32 = 40300;
pub const __IPHONE_5_0: u32 = 50000;
pub const __IPHONE_5_1: u32 = 50100;
pub const __IPHONE_6_0: u32 = 60000;
pub const __IPHONE_6_1: u32 = 60100;
pub const __IPHONE_7_0: u32 = 70000;
pub const __IPHONE_7_1: u32 = 70100;
pub const __IPHONE_8_0: u32 = 80000;
pub const __IPHONE_8_1: u32 = 80100;
pub const __IPHONE_8_2: u32 = 80200;
pub const __IPHONE_8_3: u32 = 80300;
pub const __IPHONE_8_4: u32 = 80400;
pub const __IPHONE_9_0: u32 = 90000;
pub const __IPHONE_9_1: u32 = 90100;
pub const __IPHONE_9_2: u32 = 90200;
pub const __IPHONE_9_3: u32 = 90300;
pub const __IPHONE_10_0: u32 = 100000;
pub const __IPHONE_10_1: u32 = 100100;
pub const __IPHONE_10_2: u32 = 100200;
pub const __IPHONE_10_3: u32 = 100300;
pub const __IPHONE_11_0: u32 = 110000;
pub const __IPHONE_11_1: u32 = 110100;
pub const __IPHONE_11_2: u32 = 110200;
pub const __IPHONE_11_3: u32 = 110300;
pub const __IPHONE_11_4: u32 = 110400;
pub const __IPHONE_12_0: u32 = 120000;
pub const __IPHONE_12_1: u32 = 120100;
pub const __IPHONE_12_2: u32 = 120200;
pub const __IPHONE_12_3: u32 = 120300;
pub const __IPHONE_12_4: u32 = 120400;
pub const __IPHONE_13_0: u32 = 130000;
pub const __IPHONE_13_1: u32 = 130100;
pub const __IPHONE_13_2: u32 = 130200;
pub const __IPHONE_13_3: u32 = 130300;
pub const __IPHONE_13_4: u32 = 130400;
pub const __IPHONE_13_5: u32 = 130500;
pub const __IPHONE_13_6: u32 = 130600;
pub const __IPHONE_13_7: u32 = 130700;
pub const __IPHONE_14_0: u32 = 140000;
pub const __IPHONE_14_1: u32 = 140100;
pub const __IPHONE_14_2: u32 = 140200;
pub const __IPHONE_14_3: u32 = 140300;
pub const __IPHONE_14_5: u32 = 140500;
pub const __IPHONE_14_4: u32 = 140400;
pub const __IPHONE_14_6: u32 = 140600;
pub const __IPHONE_14_7: u32 = 140700;
pub const __IPHONE_14_8: u32 = 140800;
pub const __IPHONE_15_0: u32 = 150000;
pub const __IPHONE_15_1: u32 = 150100;
pub const __IPHONE_15_2: u32 = 150200;
pub const __IPHONE_15_3: u32 = 150300;
pub const __IPHONE_15_4: u32 = 150400;
pub const __IPHONE_15_5: u32 = 150500;
pub const __IPHONE_15_6: u32 = 150600;
pub const __IPHONE_16_0: u32 = 160000;
pub const __IPHONE_16_1: u32 = 160100;
pub const __IPHONE_16_2: u32 = 160200;
pub const __IPHONE_16_3: u32 = 160300;
pub const __IPHONE_16_4: u32 = 160400;
pub const __IPHONE_16_5: u32 = 160500;
pub const __IPHONE_16_6: u32 = 160600;
pub const __IPHONE_16_7: u32 = 160700;
pub const __IPHONE_17_0: u32 = 170000;
pub const __IPHONE_17_1: u32 = 170100;
pub const __IPHONE_17_2: u32 = 170200;
pub const __WATCHOS_1_0: u32 = 10000;
pub const __WATCHOS_2_0: u32 = 20000;
pub const __WATCHOS_2_1: u32 = 20100;
pub const __WATCHOS_2_2: u32 = 20200;
pub const __WATCHOS_3_0: u32 = 30000;
pub const __WATCHOS_3_1: u32 = 30100;
pub const __WATCHOS_3_1_1: u32 = 30101;
pub const __WATCHOS_3_2: u32 = 30200;
pub const __WATCHOS_4_0: u32 = 40000;
pub const __WATCHOS_4_1: u32 = 40100;
pub const __WATCHOS_4_2: u32 = 40200;
pub const __WATCHOS_4_3: u32 = 40300;
pub const __WATCHOS_5_0: u32 = 50000;
pub const __WATCHOS_5_1: u32 = 50100;
pub const __WATCHOS_5_2: u32 = 50200;
pub const __WATCHOS_5_3: u32 = 50300;
pub const __WATCHOS_6_0: u32 = 60000;
pub const __WATCHOS_6_1: u32 = 60100;
pub const __WATCHOS_6_2: u32 = 60200;
pub const __WATCHOS_7_0: u32 = 70000;
pub const __WATCHOS_7_1: u32 = 70100;
pub const __WATCHOS_7_2: u32 = 70200;
pub const __WATCHOS_7_3: u32 = 70300;
pub const __WATCHOS_7_4: u32 = 70400;
pub const __WATCHOS_7_5: u32 = 70500;
pub const __WATCHOS_7_6: u32 = 70600;
pub const __WATCHOS_8_0: u32 = 80000;
pub const __WATCHOS_8_1: u32 = 80100;
pub const __WATCHOS_8_3: u32 = 80300;
pub const __WATCHOS_8_4: u32 = 80400;
pub const __WATCHOS_8_5: u32 = 80500;
pub const __WATCHOS_8_6: u32 = 80600;
pub const __WATCHOS_8_7: u32 = 80700;
pub const __WATCHOS_9_0: u32 = 90000;
pub const __WATCHOS_9_1: u32 = 90100;
pub const __WATCHOS_9_2: u32 = 90200;
pub const __WATCHOS_9_3: u32 = 90300;
pub const __WATCHOS_9_4: u32 = 90400;
pub const __WATCHOS_9_5: u32 = 90500;
pub const __WATCHOS_9_6: u32 = 90600;
pub const __WATCHOS_10_0: u32 = 100000;
pub const __WATCHOS_10_1: u32 = 100100;
pub const __WATCHOS_10_2: u32 = 100200;
pub const __TVOS_9_0: u32 = 90000;
pub const __TVOS_9_1: u32 = 90100;
pub const __TVOS_9_2: u32 = 90200;
pub const __TVOS_10_0: u32 = 100000;
pub const __TVOS_10_0_1: u32 = 100001;
pub const __TVOS_10_1: u32 = 100100;
pub const __TVOS_10_2: u32 = 100200;
pub const __TVOS_11_0: u32 = 110000;
pub const __TVOS_11_1: u32 = 110100;
pub const __TVOS_11_2: u32 = 110200;
pub const __TVOS_11_3: u32 = 110300;
pub const __TVOS_11_4: u32 = 110400;
pub const __TVOS_12_0: u32 = 120000;
pub const __TVOS_12_1: u32 = 120100;
pub const __TVOS_12_2: u32 = 120200;
pub const __TVOS_12_3: u32 = 120300;
pub const __TVOS_12_4: u32 = 120400;
pub const __TVOS_13_0: u32 = 130000;
pub const __TVOS_13_2: u32 = 130200;
pub const __TVOS_13_3: u32 = 130300;
pub const __TVOS_13_4: u32 = 130400;
pub const __TVOS_14_0: u32 = 140000;
pub const __TVOS_14_1: u32 = 140100;
pub const __TVOS_14_2: u32 = 140200;
pub const __TVOS_14_3: u32 = 140300;
pub const __TVOS_14_5: u32 = 140500;
pub const __TVOS_14_6: u32 = 140600;
pub const __TVOS_14_7: u32 = 140700;
pub const __TVOS_15_0: u32 = 150000;
pub const __TVOS_15_1: u32 = 150100;
pub const __TVOS_15_2: u32 = 150200;
pub const __TVOS_15_3: u32 = 150300;
pub const __TVOS_15_4: u32 = 150400;
pub const __TVOS_15_5: u32 = 150500;
pub const __TVOS_15_6: u32 = 150600;
pub const __TVOS_16_0: u32 = 160000;
pub const __TVOS_16_1: u32 = 160100;
pub const __TVOS_16_2: u32 = 160200;
pub const __TVOS_16_3: u32 = 160300;
pub const __TVOS_16_4: u32 = 160400;
pub const __TVOS_16_5: u32 = 160500;
pub const __TVOS_16_6: u32 = 160600;
pub const __TVOS_17_0: u32 = 170000;
pub const __TVOS_17_1: u32 = 170100;
pub const __TVOS_17_2: u32 = 170200;
pub const __BRIDGEOS_2_0: u32 = 20000;
pub const __BRIDGEOS_3_0: u32 = 30000;
pub const __BRIDGEOS_3_1: u32 = 30100;
pub const __BRIDGEOS_3_4: u32 = 30400;
pub const __BRIDGEOS_4_0: u32 = 40000;
pub const __BRIDGEOS_4_1: u32 = 40100;
pub const __BRIDGEOS_5_0: u32 = 50000;
pub const __BRIDGEOS_5_1: u32 = 50100;
pub const __BRIDGEOS_5_3: u32 = 50300;
pub const __BRIDGEOS_6_0: u32 = 60000;
pub const __BRIDGEOS_6_2: u32 = 60200;
pub const __BRIDGEOS_6_4: u32 = 60400;
pub const __BRIDGEOS_6_5: u32 = 60500;
pub const __BRIDGEOS_6_6: u32 = 60600;
pub const __BRIDGEOS_7_0: u32 = 70000;
pub const __BRIDGEOS_7_1: u32 = 70100;
pub const __BRIDGEOS_7_2: u32 = 70200;
pub const __BRIDGEOS_7_3: u32 = 70300;
pub const __BRIDGEOS_7_4: u32 = 70400;
pub const __BRIDGEOS_7_6: u32 = 70600;
pub const __BRIDGEOS_8_0: u32 = 80000;
pub const __BRIDGEOS_8_1: u32 = 80100;
pub const __BRIDGEOS_8_2: u32 = 80200;
pub const __DRIVERKIT_19_0: u32 = 190000;
pub const __DRIVERKIT_20_0: u32 = 200000;
pub const __DRIVERKIT_21_0: u32 = 210000;
pub const __DRIVERKIT_22_0: u32 = 220000;
pub const __DRIVERKIT_22_4: u32 = 220400;
pub const __DRIVERKIT_22_5: u32 = 220500;
pub const __DRIVERKIT_22_6: u32 = 220600;
pub const __DRIVERKIT_23_0: u32 = 230000;
pub const __DRIVERKIT_23_1: u32 = 230100;
pub const __DRIVERKIT_23_2: u32 = 230200;
pub const __VISIONOS_1_0: u32 = 10000;
pub const MAC_OS_X_VERSION_10_0: u32 = 1000;
pub const MAC_OS_X_VERSION_10_1: u32 = 1010;
pub const MAC_OS_X_VERSION_10_2: u32 = 1020;
pub const MAC_OS_X_VERSION_10_3: u32 = 1030;
pub const MAC_OS_X_VERSION_10_4: u32 = 1040;
pub const MAC_OS_X_VERSION_10_5: u32 = 1050;
pub const MAC_OS_X_VERSION_10_6: u32 = 1060;
pub const MAC_OS_X_VERSION_10_7: u32 = 1070;
pub const MAC_OS_X_VERSION_10_8: u32 = 1080;
pub const MAC_OS_X_VERSION_10_9: u32 = 1090;
pub const MAC_OS_X_VERSION_10_10: u32 = 101000;
pub const MAC_OS_X_VERSION_10_10_2: u32 = 101002;
pub const MAC_OS_X_VERSION_10_10_3: u32 = 101003;
pub const MAC_OS_X_VERSION_10_11: u32 = 101100;
pub const MAC_OS_X_VERSION_10_11_2: u32 = 101102;
pub const MAC_OS_X_VERSION_10_11_3: u32 = 101103;
pub const MAC_OS_X_VERSION_10_11_4: u32 = 101104;
pub const MAC_OS_X_VERSION_10_12: u32 = 101200;
pub const MAC_OS_X_VERSION_10_12_1: u32 = 101201;
pub const MAC_OS_X_VERSION_10_12_2: u32 = 101202;
pub const MAC_OS_X_VERSION_10_12_4: u32 = 101204;
pub const MAC_OS_X_VERSION_10_13: u32 = 101300;
pub const MAC_OS_X_VERSION_10_13_1: u32 = 101301;
pub const MAC_OS_X_VERSION_10_13_2: u32 = 101302;
pub const MAC_OS_X_VERSION_10_13_4: u32 = 101304;
pub const MAC_OS_X_VERSION_10_14: u32 = 101400;
pub const MAC_OS_X_VERSION_10_14_1: u32 = 101401;
pub const MAC_OS_X_VERSION_10_14_4: u32 = 101404;
pub const MAC_OS_X_VERSION_10_14_5: u32 = 101405;
pub const MAC_OS_X_VERSION_10_14_6: u32 = 101406;
pub const MAC_OS_X_VERSION_10_15: u32 = 101500;
pub const MAC_OS_X_VERSION_10_15_1: u32 = 101501;
pub const MAC_OS_X_VERSION_10_15_4: u32 = 101504;
pub const MAC_OS_X_VERSION_10_16: u32 = 101600;
pub const MAC_OS_VERSION_11_0: u32 = 110000;
pub const MAC_OS_VERSION_11_1: u32 = 110100;
pub const MAC_OS_VERSION_11_3: u32 = 110300;
pub const MAC_OS_VERSION_11_4: u32 = 110400;
pub const MAC_OS_VERSION_11_5: u32 = 110500;
pub const MAC_OS_VERSION_11_6: u32 = 110600;
pub const MAC_OS_VERSION_12_0: u32 = 120000;
pub const MAC_OS_VERSION_12_1: u32 = 120100;
pub const MAC_OS_VERSION_12_2: u32 = 120200;
pub const MAC_OS_VERSION_12_3: u32 = 120300;
pub const MAC_OS_VERSION_12_4: u32 = 120400;
pub const MAC_OS_VERSION_12_5: u32 = 120500;
pub const MAC_OS_VERSION_12_6: u32 = 120600;
pub const MAC_OS_VERSION_12_7: u32 = 120700;
pub const MAC_OS_VERSION_13_0: u32 = 130000;
pub const MAC_OS_VERSION_13_1: u32 = 130100;
pub const MAC_OS_VERSION_13_2: u32 = 130200;
pub const MAC_OS_VERSION_13_3: u32 = 130300;
pub const MAC_OS_VERSION_13_4: u32 = 130400;
pub const MAC_OS_VERSION_13_5: u32 = 130500;
pub const MAC_OS_VERSION_13_6: u32 = 130600;
pub const MAC_OS_VERSION_14_0: u32 = 140000;
pub const MAC_OS_VERSION_14_1: u32 = 140100;
pub const MAC_OS_VERSION_14_2: u32 = 140200;
pub const __MAC_OS_X_VERSION_MAX_ALLOWED: u32 = 140200;
pub const __ENABLE_LEGACY_MAC_AVAILABILITY: u32 = 1;
pub const __DARWIN_FD_SETSIZE: u32 = 1024;
pub const __DARWIN_NBBY: u32 = 8;
pub const NBBY: u32 = 8;
pub const FD_SETSIZE: u32 = 1024;
pub const ARG_MAX: u32 = 1048576;
pub const CHILD_MAX: u32 = 266;
pub const GID_MAX: u32 = 2147483647;
pub const LINK_MAX: u32 = 32767;
pub const MAX_CANON: u32 = 1024;
pub const MAX_INPUT: u32 = 1024;
pub const NAME_MAX: u32 = 255;
pub const NGROUPS_MAX: u32 = 16;
pub const UID_MAX: u32 = 2147483647;
pub const OPEN_MAX: u32 = 10240;
pub const PATH_MAX: u32 = 1024;
pub const PIPE_BUF: u32 = 512;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const CHARCLASS_NAME_MAX: u32 = 14;
pub const COLL_WEIGHTS_MAX: u32 = 2;
pub const EQUIV_CLASS_MAX: u32 = 2;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 255;
pub const NZERO: u32 = 20;
pub const MAXCOMLEN: u32 = 16;
pub const MAXINTERP: u32 = 64;
pub const MAXLOGNAME: u32 = 255;
pub const MAXUPRC: u32 = 266;
pub const NCARGS: u32 = 1048576;
pub const NGROUPS: u32 = 16;
pub const NOFILE: u32 = 256;
pub const NOGROUP: u32 = 65535;
pub const MAXHOSTNAMELEN: u32 = 256;
pub const MAXDOMNAMELEN: u32 = 256;
pub const NBPG: u32 = 4096;
pub const PGOFSET: u32 = 4095;
pub const PGSHIFT: u32 = 12;
pub const DEV_BSIZE: u32 = 512;
pub const DEV_BSHIFT: u32 = 9;
pub const BLKDEV_IOSIZE: u32 = 2048;
pub const MAXPHYS: u32 = 131072;
pub const CLSIZE: u32 = 1;
pub const CLSIZELOG2: u32 = 0;
pub const MSIZESHIFT: u32 = 8;
pub const MSIZE: u32 = 256;
pub const MCLSHIFT: u32 = 11;
pub const MCLBYTES: u32 = 2048;
pub const MBIGCLSHIFT: u32 = 12;
pub const MBIGCLBYTES: u32 = 4096;
pub const M16KCLSHIFT: u32 = 14;
pub const M16KCLBYTES: u32 = 16384;
pub const MCLOFSET: u32 = 2047;
pub const NMBCLUSTERS: u32 = 512;
pub const __DARWIN_CLK_TCK: u32 = 100;
pub const CHAR_BIT: u32 = 8;
pub const MB_LEN_MAX: u32 = 6;
pub const CLK_TCK: u32 = 100;
pub const SCHAR_MAX: u32 = 127;
pub const SCHAR_MIN: i32 = -128;
pub const UCHAR_MAX: u32 = 255;
pub const CHAR_MAX: u32 = 127;
pub const CHAR_MIN: i32 = -128;
pub const USHRT_MAX: u32 = 65535;
pub const SHRT_MAX: u32 = 32767;
pub const SHRT_MIN: i32 = -32768;
pub const UINT_MAX: u32 = 4294967295;
pub const INT_MAX: u32 = 2147483647;
pub const INT_MIN: i32 = -2147483648;
pub const ULONG_MAX: i32 = -1;
pub const LONG_MAX: u64 = 9223372036854775807;
pub const LONG_MIN: i64 = -9223372036854775808;
pub const ULLONG_MAX: i32 = -1;
pub const LLONG_MAX: u64 = 9223372036854775807;
pub const LLONG_MIN: i64 = -9223372036854775808;
pub const LONG_BIT: u32 = 64;
pub const SSIZE_MAX: u64 = 9223372036854775807;
pub const WORD_BIT: u32 = 32;
pub const SIZE_T_MAX: i32 = -1;
pub const UQUAD_MAX: i32 = -1;
pub const QUAD_MAX: u64 = 9223372036854775807;
pub const QUAD_MIN: i64 = -9223372036854775808;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_EQUIV_CLASS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_KEYS_MAX: u32 = 512;
pub const PTHREAD_STACK_MIN: u32 = 8192;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_SS_REPL_MAX: u32 = 4;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TRACE_EVENT_NAME_MAX: u32 = 30;
pub const _POSIX_TRACE_NAME_MAX: u32 = 8;
pub const _POSIX_TRACE_SYS_MAX: u32 = 8;
pub const _POSIX_TRACE_USER_EVENT_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const OFF_MIN: i64 = -9223372036854775808;
pub const OFF_MAX: u64 = 9223372036854775807;
pub const PASS_MAX: u32 = 128;
pub const NL_ARGMAX: u32 = 9;
pub const NL_LANGMAX: u32 = 14;
pub const NL_MSGMAX: u32 = 32767;
pub const NL_NMAX: u32 = 1;
pub const NL_SETMAX: u32 = 255;
pub const NL_TEXTMAX: u32 = 2048;
pub const _XOPEN_IOV_MAX: u32 = 16;
pub const IOV_MAX: u32 = 1024;
pub const _XOPEN_NAME_MAX: u32 = 255;
pub const _XOPEN_PATH_MAX: u32 = 1024;
pub const __DARWIN_NSIG: u32 = 32;
pub const NSIG: u32 = 32;
pub const _I386_SIGNAL_H_: u32 = 1;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGEMT: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGBUS: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGSYS: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGURG: u32 = 16;
pub const SIGSTOP: u32 = 17;
pub const SIGTSTP: u32 = 18;
pub const SIGCONT: u32 = 19;
pub const SIGCHLD: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGIO: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGINFO: u32 = 29;
pub const SIGUSR1: u32 = 30;
pub const SIGUSR2: u32 = 31;
pub const FP_PREC_24B: u32 = 0;
pub const FP_PREC_53B: u32 = 2;
pub const FP_PREC_64B: u32 = 3;
pub const FP_RND_NEAR: u32 = 0;
pub const FP_RND_DOWN: u32 = 1;
pub const FP_RND_UP: u32 = 2;
pub const FP_CHOP: u32 = 3;
pub const FP_STATE_BYTES: u32 = 512;
pub const _X86_INSTRUCTION_STATE_MAX_INSN_BYTES: u32 = 2380;
pub const _X86_INSTRUCTION_STATE_CACHELINE_SIZE: u32 = 64;
pub const __LASTBRANCH_MAX: u32 = 32;
pub const SIGEV_NONE: u32 = 0;
pub const SIGEV_SIGNAL: u32 = 1;
pub const SIGEV_THREAD: u32 = 3;
pub const ILL_NOOP: u32 = 0;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLTRP: u32 = 2;
pub const ILL_PRVOPC: u32 = 3;
pub const ILL_ILLOPN: u32 = 4;
pub const ILL_ILLADR: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const FPE_NOOP: u32 = 0;
pub const FPE_FLTDIV: u32 = 1;
pub const FPE_FLTOVF: u32 = 2;
pub const FPE_FLTUND: u32 = 3;
pub const FPE_FLTRES: u32 = 4;
pub const FPE_FLTINV: u32 = 5;
pub const FPE_FLTSUB: u32 = 6;
pub const FPE_INTDIV: u32 = 7;
pub const FPE_INTOVF: u32 = 8;
pub const SEGV_NOOP: u32 = 0;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const BUS_NOOP: u32 = 0;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const CLD_NOOP: u32 = 0;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const SA_ONSTACK: u32 = 1;
pub const SA_RESTART: u32 = 2;
pub const SA_RESETHAND: u32 = 4;
pub const SA_NOCLDSTOP: u32 = 8;
pub const SA_NODEFER: u32 = 16;
pub const SA_NOCLDWAIT: u32 = 32;
pub const SA_SIGINFO: u32 = 64;
pub const SA_USERTRAMP: u32 = 256;
pub const SA_64REGSET: u32 = 512;
pub const SA_USERSPACE_MASK: u32 = 127;
pub const SIG_BLOCK: u32 = 1;
pub const SIG_UNBLOCK: u32 = 2;
pub const SIG_SETMASK: u32 = 3;
pub const SI_USER: u32 = 65537;
pub const SI_QUEUE: u32 = 65538;
pub const SI_TIMER: u32 = 65539;
pub const SI_ASYNCIO: u32 = 65540;
pub const SI_MESGQ: u32 = 65541;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 4;
pub const MINSIGSTKSZ: u32 = 32768;
pub const SIGSTKSZ: u32 = 131072;
pub const SV_ONSTACK: u32 = 1;
pub const SV_INTERRUPT: u32 = 2;
pub const SV_RESETHAND: u32 = 4;
pub const SV_NODEFER: u32 = 16;
pub const SV_NOCLDSTOP: u32 = 8;
pub const SV_SIGINFO: u32 = 64;
pub const PSWP: u32 = 0;
pub const PVM: u32 = 4;
pub const PINOD: u32 = 8;
pub const PRIBIO: u32 = 16;
pub const PVFS: u32 = 20;
pub const PZERO: u32 = 22;
pub const PSOCK: u32 = 24;
pub const PWAIT: u32 = 32;
pub const PLOCK: u32 = 36;
pub const PPAUSE: u32 = 40;
pub const PUSER: u32 = 50;
pub const MAXPRI: u32 = 127;
pub const PRIMASK: u32 = 255;
pub const PCATCH: u32 = 256;
pub const PTTYBLOCK: u32 = 512;
pub const PDROP: u32 = 1024;
pub const PSPIN: u32 = 2048;
pub const CMASK: u32 = 18;
pub const CLBYTES: u32 = 4096;
pub const CLOFSET: u32 = 4095;
pub const CLOFF: u32 = 4095;
pub const CLSHIFT: u32 = 12;
pub const CBLOCK: u32 = 64;
pub const CBQSIZE: u32 = 8;
pub const CROUND: u32 = 63;
pub const MAXBSIZE: u32 = 1048576;
pub const MAXPHYSIO: u32 = 131072;
pub const MAXFRAG: u32 = 8;
pub const MAXPHYSIO_WIRED: u32 = 16777216;
pub const MAXPATHLEN: u32 = 1024;
pub const MAXSYMLINKS: u32 = 32;
pub const FSHIFT: u32 = 11;
pub const FSCALE: u32 = 2048;
pub const SPLAY_NEGINF: i32 = -1;
pub const SPLAY_INF: u32 = 1;
pub const RB_BLACK: u32 = 0;
pub const RB_RED: u32 = 1;
pub const RB_NEGINF: i32 = -1;
pub const RB_INF: u32 = 1;
pub const RNF_NORMAL: u32 = 1;
pub const RNF_ROOT: u32 = 2;
pub const RNF_ACTIVE: u32 = 4;
pub const __WORDSIZE: u32 = 64;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const INT64_MAX: u64 = 9223372036854775807;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT64_MIN: i64 = -9223372036854775808;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const UINT64_MAX: i32 = -1;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST64_MIN: i64 = -9223372036854775808;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const INT_LEAST64_MAX: u64 = 9223372036854775807;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const UINT_LEAST64_MAX: i32 = -1;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i32 = -32768;
pub const INT_FAST32_MIN: i32 = -2147483648;
pub const INT_FAST64_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u32 = 32767;
pub const INT_FAST32_MAX: u32 = 2147483647;
pub const INT_FAST64_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: u32 = 65535;
pub const UINT_FAST32_MAX: u32 = 4294967295;
pub const UINT_FAST64_MAX: i32 = -1;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const UINTPTR_MAX: i32 = -1;
pub const SIZE_MAX: i32 = -1;
pub const RSIZE_MAX: i32 = -1;
pub const WINT_MIN: i32 = -2147483648;
pub const WINT_MAX: u32 = 2147483647;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const KEV_INET_SUBCLASS: u32 = 1;
pub const KEV_INET_NEW_ADDR: u32 = 1;
pub const KEV_INET_CHANGED_ADDR: u32 = 2;
pub const KEV_INET_ADDR_DELETED: u32 = 3;
pub const KEV_INET_SIFDSTADDR: u32 = 4;
pub const KEV_INET_SIFBRDADDR: u32 = 5;
pub const KEV_INET_SIFNETMASK: u32 = 6;
pub const KEV_INET_ARPCOLLISION: u32 = 7;
pub const KEV_INET_PORTINUSE: u32 = 8;
pub const KEV_INET_ARPRTRFAILURE: u32 = 9;
pub const KEV_INET_ARPRTRALIVE: u32 = 10;
pub const KEV_DL_SUBCLASS: u32 = 2;
pub const KEV_DL_SIFFLAGS: u32 = 1;
pub const KEV_DL_SIFMETRICS: u32 = 2;
pub const KEV_DL_SIFMTU: u32 = 3;
pub const KEV_DL_SIFPHYS: u32 = 4;
pub const KEV_DL_SIFMEDIA: u32 = 5;
pub const KEV_DL_SIFGENERIC: u32 = 6;
pub const KEV_DL_ADDMULTI: u32 = 7;
pub const KEV_DL_DELMULTI: u32 = 8;
pub const KEV_DL_IF_ATTACHED: u32 = 9;
pub const KEV_DL_IF_DETACHING: u32 = 10;
pub const KEV_DL_IF_DETACHED: u32 = 11;
pub const KEV_DL_LINK_OFF: u32 = 12;
pub const KEV_DL_LINK_ON: u32 = 13;
pub const KEV_DL_PROTO_ATTACHED: u32 = 14;
pub const KEV_DL_PROTO_DETACHED: u32 = 15;
pub const KEV_DL_LINK_ADDRESS_CHANGED: u32 = 16;
pub const KEV_DL_WAKEFLAGS_CHANGED: u32 = 17;
pub const KEV_DL_IF_IDLE_ROUTE_REFCNT: u32 = 18;
pub const KEV_DL_IFCAP_CHANGED: u32 = 19;
pub const KEV_DL_LINK_QUALITY_METRIC_CHANGED: u32 = 20;
pub const KEV_DL_NODE_PRESENCE: u32 = 21;
pub const KEV_DL_NODE_ABSENCE: u32 = 22;
pub const KEV_DL_MASTER_ELECTED: u32 = 23;
pub const KEV_DL_ISSUES: u32 = 24;
pub const KEV_DL_IFDELEGATE_CHANGED: u32 = 25;
pub const KEV_DL_AWDL_RESTRICTED: u32 = 26;
pub const KEV_DL_AWDL_UNRESTRICTED: u32 = 27;
pub const KEV_DL_RRC_STATE_CHANGED: u32 = 28;
pub const KEV_DL_QOS_MODE_CHANGED: u32 = 29;
pub const KEV_DL_LOW_POWER_MODE_CHANGED: u32 = 30;
pub const KEV_NETPOLICY_SUBCLASS: u32 = 3;
pub const KEV_NETPOLICY_IFDENIED: u32 = 1;
pub const KEV_NETPOLICY_IFFAILED: u32 = 2;
pub const KEV_NETPOLICY_NETDENIED: u32 = 3;
pub const NETPOLICY_NETWORKTYPE_LOCAL: u32 = 1;
pub const KEV_SOCKET_SUBCLASS: u32 = 4;
pub const KEV_SOCKET_CLOSED: u32 = 1;
pub const KEV_INET6_SUBCLASS: u32 = 6;
pub const KEV_INET6_NEW_USER_ADDR: u32 = 1;
pub const KEV_INET6_CHANGED_ADDR: u32 = 2;
pub const KEV_INET6_ADDR_DELETED: u32 = 3;
pub const KEV_INET6_NEW_LL_ADDR: u32 = 4;
pub const KEV_INET6_NEW_RTADV_ADDR: u32 = 5;
pub const KEV_INET6_DEFROUTER: u32 = 6;
pub const KEV_INET6_REQUEST_NAT64_PREFIX: u32 = 7;
pub const KEV_ND6_SUBCLASS: u32 = 7;
pub const KEV_ND6_RA: u32 = 1;
pub const KEV_ND6_NDFAILURE: u32 = 2;
pub const KEV_ND6_NDALIVE: u32 = 3;
pub const KEV_ND6_DAD_FAILURE: u32 = 4;
pub const KEV_ND6_DAD_SUCCESS: u32 = 5;
pub const KEV_ND6_ADDR_DETACHED: u32 = 6;
pub const KEV_ND6_ADDR_DEPRECATED: u32 = 7;
pub const KEV_ND6_ADDR_EXPIRED: u32 = 8;
pub const KEV_ND6_RTR_EXPIRED: u32 = 9;
pub const KEV_ND6_PFX_EXPIRED: u32 = 10;
pub const KEV_NECP_SUBCLASS: u32 = 8;
pub const KEV_NECP_POLICIES_CHANGED: u32 = 1;
pub const KEV_NETAGENT_SUBCLASS: u32 = 9;
pub const KEV_NETAGENT_REGISTERED: u32 = 1;
pub const KEV_NETAGENT_UNREGISTERED: u32 = 2;
pub const KEV_NETAGENT_UPDATED: u32 = 3;
pub const KEV_NETAGENT_UPDATED_INTERFACES: u32 = 4;
pub const KEV_LOG_SUBCLASS: u32 = 10;
pub const IPFWLOGEVENT: u32 = 0;
pub const KEV_NETEVENT_SUBCLASS: u32 = 11;
pub const KEV_NETEVENT_APNFALLBACK: u32 = 1;
pub const KEV_NETEVENT_CLAT46_EVENT: u32 = 2;
pub const KEV_MPTCP_SUBCLASS: u32 = 12;
pub const KEV_MPTCP_CELLUSE: u32 = 1;
pub const KEV_IPSEC_SUBCLASS: u32 = 13;
pub const KEV_IPSEC_WAKE_PACKET: u32 = 1;
pub const SOCK_STREAM: u32 = 1;
pub const SOCK_DGRAM: u32 = 2;
pub const SOCK_RAW: u32 = 3;
pub const SOCK_RDM: u32 = 4;
pub const SOCK_SEQPACKET: u32 = 5;
pub const SO_DEBUG: u32 = 1;
pub const SO_ACCEPTCONN: u32 = 2;
pub const SO_REUSEADDR: u32 = 4;
pub const SO_KEEPALIVE: u32 = 8;
pub const SO_DONTROUTE: u32 = 16;
pub const SO_BROADCAST: u32 = 32;
pub const SO_USELOOPBACK: u32 = 64;
pub const SO_LINGER: u32 = 128;
pub const SO_OOBINLINE: u32 = 256;
pub const SO_REUSEPORT: u32 = 512;
pub const SO_TIMESTAMP: u32 = 1024;
pub const SO_TIMESTAMP_MONOTONIC: u32 = 2048;
pub const SO_DONTTRUNC: u32 = 8192;
pub const SO_WANTMORE: u32 = 16384;
pub const SO_WANTOOBFLAG: u32 = 32768;
pub const SO_NOWAKEFROMSLEEP: u32 = 65536;
pub const SO_NOAPNFALLBK: u32 = 131072;
pub const SO_TIMESTAMP_CONTINUOUS: u32 = 262144;
pub const SO_SNDBUF: u32 = 4097;
pub const SO_RCVBUF: u32 = 4098;
pub const SO_SNDLOWAT: u32 = 4099;
pub const SO_RCVLOWAT: u32 = 4100;
pub const SO_SNDTIMEO: u32 = 4101;
pub const SO_RCVTIMEO: u32 = 4102;
pub const SO_ERROR: u32 = 4103;
pub const SO_TYPE: u32 = 4104;
pub const SO_LABEL: u32 = 4112;
pub const SO_PEERLABEL: u32 = 4113;
pub const SO_NREAD: u32 = 4128;
pub const SO_NKE: u32 = 4129;
pub const SO_NOSIGPIPE: u32 = 4130;
pub const SO_NOADDRERR: u32 = 4131;
pub const SO_NWRITE: u32 = 4132;
pub const SO_REUSESHAREUID: u32 = 4133;
pub const SO_NOTIFYCONFLICT: u32 = 4134;
pub const SO_UPCALLCLOSEWAIT: u32 = 4135;
pub const SO_LINGER_SEC: u32 = 4224;
pub const SO_RESTRICTIONS: u32 = 4225;
pub const SO_RESTRICT_DENY_IN: u32 = 1;
pub const SO_RESTRICT_DENY_OUT: u32 = 2;
pub const SO_RESTRICT_DENY_CELLULAR: u32 = 4;
pub const SO_RESTRICT_DENY_EXPENSIVE: u32 = 8;
pub const SO_RESTRICT_DENY_CONSTRAINED: u32 = 16;
pub const SO_RANDOMPORT: u32 = 4226;
pub const SO_NP_EXTENSIONS: u32 = 4227;
pub const SO_EXECPATH: u32 = 4229;
pub const SO_TRAFFIC_CLASS: u32 = 4230;
pub const SO_TC_BK_SYS: u32 = 100;
pub const SO_TC_BK: u32 = 200;
pub const SO_TC_BE: u32 = 0;
pub const SO_TC_RD: u32 = 300;
pub const SO_TC_OAM: u32 = 400;
pub const SO_TC_AV: u32 = 500;
pub const SO_TC_RV: u32 = 600;
pub const SO_TC_VI: u32 = 700;
pub const SO_TC_VO: u32 = 800;
pub const SO_TC_CTL: u32 = 900;
pub const SO_TC_MAX: u32 = 10;
pub const TRAFFIC_MGT_SO_BACKGROUND: u32 = 1;
pub const TRAFFIC_MGT_TCP_RECVBG: u32 = 2;
pub const SO_RECV_TRAFFIC_CLASS: u32 = 4231;
pub const SO_TRAFFIC_CLASS_DBG: u32 = 4232;
pub const SO_OPTION_UNUSED_0: u32 = 4233;
pub const SO_PRIVILEGED_TRAFFIC_CLASS: u32 = 4240;
pub const SO_DEFUNCTIT: u32 = 4241;
pub const SO_DEFUNCTOK: u32 = 4352;
pub const SO_ISDEFUNCT: u32 = 4353;
pub const SO_OPPORTUNISTIC: u32 = 4354;
pub const SO_FLUSH: u32 = 4355;
pub const SO_TC_ALL: i32 = -1;
pub const SO_RECV_ANYIF: u32 = 4356;
pub const SO_TRAFFIC_MGT_BACKGROUND: u32 = 4357;
pub const SO_FLOW_DIVERT_TOKEN: u32 = 4358;
pub const SO_DELEGATED: u32 = 4359;
pub const SO_DELEGATED_UUID: u32 = 4360;
pub const SO_NECP_ATTRIBUTES: u32 = 4361;
pub const SO_CFIL_SOCK_ID: u32 = 4368;
pub const SO_NECP_CLIENTUUID: u32 = 4369;
pub const SO_NUMRCVPKT: u32 = 4370;
pub const SO_AWDL_UNRESTRICTED: u32 = 4371;
pub const SO_EXTENDED_BK_IDLE: u32 = 4372;
pub const SO_MARK_CELLFALLBACK: u32 = 4373;
pub const SO_NET_SERVICE_TYPE: u32 = 4374;
pub const SO_QOSMARKING_POLICY_OVERRIDE: u32 = 4375;
pub const SO_INTCOPROC_ALLOW: u32 = 4376;
pub const SO_NETSVC_MARKING_LEVEL: u32 = 4377;
pub const SO_NECP_LISTENUUID: u32 = 4384;
pub const SO_MPKL_SEND_INFO: u32 = 4386;
pub const SO_STATISTICS_EVENT: u32 = 4387;
pub const SO_WANT_KEV_SOCKET_CLOSED: u32 = 4388;
pub const NET_SERVICE_TYPE_BE: u32 = 0;
pub const NET_SERVICE_TYPE_BK: u32 = 1;
pub const NET_SERVICE_TYPE_SIG: u32 = 2;
pub const NET_SERVICE_TYPE_VI: u32 = 3;
pub const NET_SERVICE_TYPE_VO: u32 = 4;
pub const NET_SERVICE_TYPE_RV: u32 = 5;
pub const NET_SERVICE_TYPE_AV: u32 = 6;
pub const NET_SERVICE_TYPE_OAM: u32 = 7;
pub const NET_SERVICE_TYPE_RD: u32 = 8;
pub const _NET_SERVICE_TYPE_COUNT: u32 = 9;
pub const SO_TC_NET_SERVICE_OFFSET: u32 = 10000;
pub const SO_TC_NETSVC_SIG: u32 = 10002;
pub const NETSVC_MRKNG_UNKNOWN: u32 = 0;
pub const NETSVC_MRKNG_LVL_L2: u32 = 1;
pub const NETSVC_MRKNG_LVL_L3L2_ALL: u32 = 2;
pub const NETSVC_MRKNG_LVL_L3L2_BK: u32 = 3;
pub const SAE_ASSOCID_ANY: u32 = 0;
pub const SAE_CONNID_ANY: u32 = 0;
pub const CONNECT_RESUME_ON_READ_WRITE: u32 = 1;
pub const CONNECT_DATA_IDEMPOTENT: u32 = 2;
pub const CONNECT_DATA_AUTHENTICATED: u32 = 4;
pub const SONPX_SETOPTSHUT: u32 = 1;
pub const SOL_SOCKET: u32 = 65535;
pub const AF_UNSPEC: u32 = 0;
pub const AF_UNIX: u32 = 1;
pub const AF_LOCAL: u32 = 1;
pub const AF_INET: u32 = 2;
pub const AF_IMPLINK: u32 = 3;
pub const AF_PUP: u32 = 4;
pub const AF_CHAOS: u32 = 5;
pub const AF_NS: u32 = 6;
pub const AF_ISO: u32 = 7;
pub const AF_OSI: u32 = 7;
pub const AF_ECMA: u32 = 8;
pub const AF_DATAKIT: u32 = 9;
pub const AF_CCITT: u32 = 10;
pub const AF_SNA: u32 = 11;
pub const AF_DECnet: u32 = 12;
pub const AF_DLI: u32 = 13;
pub const AF_LAT: u32 = 14;
pub const AF_HYLINK: u32 = 15;
pub const AF_APPLETALK: u32 = 16;
pub const AF_ROUTE: u32 = 17;
pub const AF_LINK: u32 = 18;
pub const pseudo_AF_XTP: u32 = 19;
pub const AF_COIP: u32 = 20;
pub const AF_CNT: u32 = 21;
pub const pseudo_AF_RTIP: u32 = 22;
pub const AF_IPX: u32 = 23;
pub const AF_SIP: u32 = 24;
pub const pseudo_AF_PIP: u32 = 25;
pub const AF_NDRV: u32 = 27;
pub const AF_ISDN: u32 = 28;
pub const AF_E164: u32 = 28;
pub const pseudo_AF_KEY: u32 = 29;
pub const AF_INET6: u32 = 30;
pub const AF_NATM: u32 = 31;
pub const AF_SYSTEM: u32 = 32;
pub const AF_NETBIOS: u32 = 33;
pub const AF_PPP: u32 = 34;
pub const pseudo_AF_HDRCMPLT: u32 = 35;
pub const AF_AFP: u32 = 36;
pub const AF_IEEE80211: u32 = 37;
pub const AF_UTUN: u32 = 38;
pub const AF_MULTIPATH: u32 = 39;
pub const AF_VSOCK: u32 = 40;
pub const AF_MAX: u32 = 41;
pub const SOCK_MAXADDRLEN: u32 = 255;
pub const _SS_MAXSIZE: u32 = 128;
pub const PF_UNSPEC: u32 = 0;
pub const PF_LOCAL: u32 = 1;
pub const PF_UNIX: u32 = 1;
pub const PF_INET: u32 = 2;
pub const PF_IMPLINK: u32 = 3;
pub const PF_PUP: u32 = 4;
pub const PF_CHAOS: u32 = 5;
pub const PF_NS: u32 = 6;
pub const PF_ISO: u32 = 7;
pub const PF_OSI: u32 = 7;
pub const PF_ECMA: u32 = 8;
pub const PF_DATAKIT: u32 = 9;
pub const PF_CCITT: u32 = 10;
pub const PF_SNA: u32 = 11;
pub const PF_DECnet: u32 = 12;
pub const PF_DLI: u32 = 13;
pub const PF_LAT: u32 = 14;
pub const PF_HYLINK: u32 = 15;
pub const PF_APPLETALK: u32 = 16;
pub const PF_ROUTE: u32 = 17;
pub const PF_LINK: u32 = 18;
pub const PF_XTP: u32 = 19;
pub const PF_COIP: u32 = 20;
pub const PF_CNT: u32 = 21;
pub const PF_SIP: u32 = 24;
pub const PF_IPX: u32 = 23;
pub const PF_RTIP: u32 = 22;
pub const PF_PIP: u32 = 25;
pub const PF_NDRV: u32 = 27;
pub const PF_ISDN: u32 = 28;
pub const PF_KEY: u32 = 29;
pub const PF_INET6: u32 = 30;
pub const PF_NATM: u32 = 31;
pub const PF_SYSTEM: u32 = 32;
pub const PF_NETBIOS: u32 = 33;
pub const PF_PPP: u32 = 34;
pub const PF_AFP: u32 = 36;
pub const PF_UTUN: u32 = 38;
pub const PF_MULTIPATH: u32 = 39;
pub const PF_VSOCK: u32 = 40;
pub const PF_MAX: u32 = 41;
pub const NET_MAXID: u32 = 41;
pub const NET_RT_DUMP: u32 = 1;
pub const NET_RT_FLAGS: u32 = 2;
pub const NET_RT_IFLIST: u32 = 3;
pub const NET_RT_STAT: u32 = 4;
pub const NET_RT_TRASH: u32 = 5;
pub const NET_RT_IFLIST2: u32 = 6;
pub const NET_RT_DUMP2: u32 = 7;
pub const NET_RT_DUMPX: u32 = 8;
pub const NET_RT_DUMPX_FLAGS: u32 = 9;
pub const NET_RT_FLAGS_PRIV: u32 = 10;
pub const NET_RT_MAXID: u32 = 11;
pub const SO_STATISTICS_EVENT_ENTER_CELLFALLBACK: u32 = 1;
pub const SO_STATISTICS_EVENT_EXIT_CELLFALLBACK: u32 = 2;
pub const SO_STATISTICS_EVENT_RESERVED_1: u32 = 4;
pub const SO_STATISTICS_EVENT_RESERVED_2: u32 = 8;
pub const SOMAXCONN: u32 = 128;
pub const MSG_OOB: u32 = 1;
pub const MSG_PEEK: u32 = 2;
pub const MSG_DONTROUTE: u32 = 4;
pub const MSG_EOR: u32 = 8;
pub const MSG_TRUNC: u32 = 16;
pub const MSG_CTRUNC: u32 = 32;
pub const MSG_WAITALL: u32 = 64;
pub const MSG_DONTWAIT: u32 = 128;
pub const MSG_EOF: u32 = 256;
pub const MSG_WAITSTREAM: u32 = 512;
pub const MSG_FLUSH: u32 = 1024;
pub const MSG_HOLD: u32 = 2048;
pub const MSG_SEND: u32 = 4096;
pub const MSG_HAVEMORE: u32 = 8192;
pub const MSG_RCVMORE: u32 = 16384;
pub const MSG_NEEDSA: u32 = 65536;
pub const MSG_NOSIGNAL: u32 = 524288;
pub const SCM_RIGHTS: u32 = 1;
pub const SCM_TIMESTAMP: u32 = 2;
pub const SCM_CREDS: u32 = 3;
pub const SCM_TIMESTAMP_MONOTONIC: u32 = 4;
pub const SCM_TIMESTAMP_CONTINUOUS: u32 = 7;
pub const SCM_MPKL_SEND_INFO: u32 = 8;
pub const SCM_MPKL_RECV_INFO: u32 = 9;
pub const SHUT_RD: u32 = 0;
pub const SHUT_WR: u32 = 1;
pub const SHUT_RDWR: u32 = 2;
pub const CIF_CONNECTING: u32 = 1;
pub const CIF_CONNECTED: u32 = 2;
pub const CIF_DISCONNECTING: u32 = 4;
pub const CIF_DISCONNECTED: u32 = 8;
pub const CIF_BOUND_IF: u32 = 16;
pub const CIF_BOUND_IP: u32 = 32;
pub const CIF_BOUND_PORT: u32 = 64;
pub const CIF_PREFERRED: u32 = 128;
pub const CIF_MP_CAPABLE: u32 = 256;
pub const CIF_MP_READY: u32 = 512;
pub const CIF_MP_DEGRADED: u32 = 1024;
pub const CIF_MP_ACTIVE: u32 = 2048;
pub const CIAUX_TCP: u32 = 1;
pub const CIAUX_MPTCP: u32 = 2;
pub const IPPROTO_IP: u32 = 0;
pub const IPPROTO_HOPOPTS: u32 = 0;
pub const IPPROTO_ICMP: u32 = 1;
pub const IPPROTO_IGMP: u32 = 2;
pub const IPPROTO_GGP: u32 = 3;
pub const IPPROTO_IPV4: u32 = 4;
pub const IPPROTO_IPIP: u32 = 4;
pub const IPPROTO_TCP: u32 = 6;
pub const IPPROTO_ST: u32 = 7;
pub const IPPROTO_EGP: u32 = 8;
pub const IPPROTO_PIGP: u32 = 9;
pub const IPPROTO_RCCMON: u32 = 10;
pub const IPPROTO_NVPII: u32 = 11;
pub const IPPROTO_PUP: u32 = 12;
pub const IPPROTO_ARGUS: u32 = 13;
pub const IPPROTO_EMCON: u32 = 14;
pub const IPPROTO_XNET: u32 = 15;
pub const IPPROTO_CHAOS: u32 = 16;
pub const IPPROTO_UDP: u32 = 17;
pub const IPPROTO_MUX: u32 = 18;
pub const IPPROTO_MEAS: u32 = 19;
pub const IPPROTO_HMP: u32 = 20;
pub const IPPROTO_PRM: u32 = 21;
pub const IPPROTO_IDP: u32 = 22;
pub const IPPROTO_TRUNK1: u32 = 23;
pub const IPPROTO_TRUNK2: u32 = 24;
pub const IPPROTO_LEAF1: u32 = 25;
pub const IPPROTO_LEAF2: u32 = 26;
pub const IPPROTO_RDP: u32 = 27;
pub const IPPROTO_IRTP: u32 = 28;
pub const IPPROTO_TP: u32 = 29;
pub const IPPROTO_BLT: u32 = 30;
pub const IPPROTO_NSP: u32 = 31;
pub const IPPROTO_INP: u32 = 32;
pub const IPPROTO_SEP: u32 = 33;
pub const IPPROTO_3PC: u32 = 34;
pub const IPPROTO_IDPR: u32 = 35;
pub const IPPROTO_XTP: u32 = 36;
pub const IPPROTO_DDP: u32 = 37;
pub const IPPROTO_CMTP: u32 = 38;
pub const IPPROTO_TPXX: u32 = 39;
pub const IPPROTO_IL: u32 = 40;
pub const IPPROTO_IPV6: u32 = 41;
pub const IPPROTO_SDRP: u32 = 42;
pub const IPPROTO_ROUTING: u32 = 43;
pub const IPPROTO_FRAGMENT: u32 = 44;
pub const IPPROTO_IDRP: u32 = 45;
pub const IPPROTO_RSVP: u32 = 46;
pub const IPPROTO_GRE: u32 = 47;
pub const IPPROTO_MHRP: u32 = 48;
pub const IPPROTO_BHA: u32 = 49;
pub const IPPROTO_ESP: u32 = 50;
pub const IPPROTO_AH: u32 = 51;
pub const IPPROTO_INLSP: u32 = 52;
pub const IPPROTO_SWIPE: u32 = 53;
pub const IPPROTO_NHRP: u32 = 54;
pub const IPPROTO_ICMPV6: u32 = 58;
pub const IPPROTO_NONE: u32 = 59;
pub const IPPROTO_DSTOPTS: u32 = 60;
pub const IPPROTO_AHIP: u32 = 61;
pub const IPPROTO_CFTP: u32 = 62;
pub const IPPROTO_HELLO: u32 = 63;
pub const IPPROTO_SATEXPAK: u32 = 64;
pub const IPPROTO_KRYPTOLAN: u32 = 65;
pub const IPPROTO_RVD: u32 = 66;
pub const IPPROTO_IPPC: u32 = 67;
pub const IPPROTO_ADFS: u32 = 68;
pub const IPPROTO_SATMON: u32 = 69;
pub const IPPROTO_VISA: u32 = 70;
pub const IPPROTO_IPCV: u32 = 71;
pub const IPPROTO_CPNX: u32 = 72;
pub const IPPROTO_CPHB: u32 = 73;
pub const IPPROTO_WSN: u32 = 74;
pub const IPPROTO_PVP: u32 = 75;
pub const IPPROTO_BRSATMON: u32 = 76;
pub const IPPROTO_ND: u32 = 77;
pub const IPPROTO_WBMON: u32 = 78;
pub const IPPROTO_WBEXPAK: u32 = 79;
pub const IPPROTO_EON: u32 = 80;
pub const IPPROTO_VMTP: u32 = 81;
pub const IPPROTO_SVMTP: u32 = 82;
pub const IPPROTO_VINES: u32 = 83;
pub const IPPROTO_TTP: u32 = 84;
pub const IPPROTO_IGP: u32 = 85;
pub const IPPROTO_DGP: u32 = 86;
pub const IPPROTO_TCF: u32 = 87;
pub const IPPROTO_IGRP: u32 = 88;
pub const IPPROTO_OSPFIGP: u32 = 89;
pub const IPPROTO_SRPC: u32 = 90;
pub const IPPROTO_LARP: u32 = 91;
pub const IPPROTO_MTP: u32 = 92;
pub const IPPROTO_AX25: u32 = 93;
pub const IPPROTO_IPEIP: u32 = 94;
pub const IPPROTO_MICP: u32 = 95;
pub const IPPROTO_SCCSP: u32 = 96;
pub const IPPROTO_ETHERIP: u32 = 97;
pub const IPPROTO_ENCAP: u32 = 98;
pub const IPPROTO_APES: u32 = 99;
pub const IPPROTO_GMTP: u32 = 100;
pub const IPPROTO_PIM: u32 = 103;
pub const IPPROTO_IPCOMP: u32 = 108;
pub const IPPROTO_PGM: u32 = 113;
pub const IPPROTO_SCTP: u32 = 132;
pub const IPPROTO_QUIC: u32 = 253;
pub const IPPROTO_DIVERT: u32 = 254;
pub const IPPROTO_RAW: u32 = 255;
pub const IPPROTO_MAX: u32 = 256;
pub const IPPROTO_DONE: u32 = 257;
pub const __DARWIN_IPPORT_RESERVED: u32 = 1024;
pub const IPPORT_RESERVED: u32 = 1024;
pub const IPPORT_USERRESERVED: u32 = 5000;
pub const IPPORT_HIFIRSTAUTO: u32 = 49152;
pub const IPPORT_HILASTAUTO: u32 = 65535;
pub const IPPORT_RESERVEDSTART: u32 = 600;
pub const IN_CLASSA_NET: u32 = 4278190080;
pub const IN_CLASSA_NSHIFT: u32 = 24;
pub const IN_CLASSA_HOST: u32 = 16777215;
pub const IN_CLASSA_MAX: u32 = 128;
pub const IN_CLASSB_NET: u32 = 4294901760;
pub const IN_CLASSB_NSHIFT: u32 = 16;
pub const IN_CLASSB_HOST: u32 = 65535;
pub const IN_CLASSB_MAX: u32 = 65536;
pub const IN_CLASSC_NET: u32 = 4294967040;
pub const IN_CLASSC_NSHIFT: u32 = 8;
pub const IN_CLASSC_HOST: u32 = 255;
pub const IN_CLASSD_NET: u32 = 4026531840;
pub const IN_CLASSD_NSHIFT: u32 = 28;
pub const IN_CLASSD_HOST: u32 = 268435455;
pub const INADDR_NONE: u32 = 4294967295;
pub const IN_LOOPBACKNET: u32 = 127;
pub const INET_ADDRSTRLEN: u32 = 16;
pub const IP_OPTIONS: u32 = 1;
pub const IP_HDRINCL: u32 = 2;
pub const IP_TOS: u32 = 3;
pub const IP_TTL: u32 = 4;
pub const IP_RECVOPTS: u32 = 5;
pub const IP_RECVRETOPTS: u32 = 6;
pub const IP_RECVDSTADDR: u32 = 7;
pub const IP_RETOPTS: u32 = 8;
pub const IP_MULTICAST_IF: u32 = 9;
pub const IP_MULTICAST_TTL: u32 = 10;
pub const IP_MULTICAST_LOOP: u32 = 11;
pub const IP_ADD_MEMBERSHIP: u32 = 12;
pub const IP_DROP_MEMBERSHIP: u32 = 13;
pub const IP_MULTICAST_VIF: u32 = 14;
pub const IP_RSVP_ON: u32 = 15;
pub const IP_RSVP_OFF: u32 = 16;
pub const IP_RSVP_VIF_ON: u32 = 17;
pub const IP_RSVP_VIF_OFF: u32 = 18;
pub const IP_PORTRANGE: u32 = 19;
pub const IP_RECVIF: u32 = 20;
pub const IP_IPSEC_POLICY: u32 = 21;
pub const IP_FAITH: u32 = 22;
pub const IP_STRIPHDR: u32 = 23;
pub const IP_RECVTTL: u32 = 24;
pub const IP_BOUND_IF: u32 = 25;
pub const IP_PKTINFO: u32 = 26;
pub const IP_RECVPKTINFO: u32 = 26;
pub const IP_RECVTOS: u32 = 27;
pub const IP_DONTFRAG: u32 = 28;
pub const IP_FW_ADD: u32 = 40;
pub const IP_FW_DEL: u32 = 41;
pub const IP_FW_FLUSH: u32 = 42;
pub const IP_FW_ZERO: u32 = 43;
pub const IP_FW_GET: u32 = 44;
pub const IP_FW_RESETLOG: u32 = 45;
pub const IP_OLD_FW_ADD: u32 = 50;
pub const IP_OLD_FW_DEL: u32 = 51;
pub const IP_OLD_FW_FLUSH: u32 = 52;
pub const IP_OLD_FW_ZERO: u32 = 53;
pub const IP_OLD_FW_GET: u32 = 54;
pub const IP_NAT__XXX: u32 = 55;
pub const IP_OLD_FW_RESETLOG: u32 = 56;
pub const IP_DUMMYNET_CONFIGURE: u32 = 60;
pub const IP_DUMMYNET_DEL: u32 = 61;
pub const IP_DUMMYNET_FLUSH: u32 = 62;
pub const IP_DUMMYNET_GET: u32 = 64;
pub const IP_TRAFFIC_MGT_BACKGROUND: u32 = 65;
pub const IP_MULTICAST_IFINDEX: u32 = 66;
pub const IP_ADD_SOURCE_MEMBERSHIP: u32 = 70;
pub const IP_DROP_SOURCE_MEMBERSHIP: u32 = 71;
pub const IP_BLOCK_SOURCE: u32 = 72;
pub const IP_UNBLOCK_SOURCE: u32 = 73;
pub const IP_MSFILTER: u32 = 74;
pub const MCAST_JOIN_GROUP: u32 = 80;
pub const MCAST_LEAVE_GROUP: u32 = 81;
pub const MCAST_JOIN_SOURCE_GROUP: u32 = 82;
pub const MCAST_LEAVE_SOURCE_GROUP: u32 = 83;
pub const MCAST_BLOCK_SOURCE: u32 = 84;
pub const MCAST_UNBLOCK_SOURCE: u32 = 85;
pub const IP_NO_IFT_CELLULAR: u32 = 6969;
pub const IP_NO_IFT_PDP: u32 = 6969;
pub const IP_OUT_IF: u32 = 9696;
pub const IP_DEFAULT_MULTICAST_TTL: u32 = 1;
pub const IP_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IP_MIN_MEMBERSHIPS: u32 = 31;
pub const IP_MAX_MEMBERSHIPS: u32 = 4095;
pub const IP_MAX_GROUP_SRC_FILTER: u32 = 512;
pub const IP_MAX_SOCK_SRC_FILTER: u32 = 128;
pub const IP_MAX_SOCK_MUTE_FILTER: u32 = 128;
pub const MCAST_UNDEFINED: u32 = 0;
pub const MCAST_INCLUDE: u32 = 1;
pub const MCAST_EXCLUDE: u32 = 2;
pub const IP_PORTRANGE_DEFAULT: u32 = 0;
pub const IP_PORTRANGE_HIGH: u32 = 1;
pub const IP_PORTRANGE_LOW: u32 = 2;
pub const IPPROTO_MAXID: u32 = 52;
pub const IPCTL_FORWARDING: u32 = 1;
pub const IPCTL_SENDREDIRECTS: u32 = 2;
pub const IPCTL_DEFTTL: u32 = 3;
pub const IPCTL_RTEXPIRE: u32 = 5;
pub const IPCTL_RTMINEXPIRE: u32 = 6;
pub const IPCTL_RTMAXCACHE: u32 = 7;
pub const IPCTL_SOURCEROUTE: u32 = 8;
pub const IPCTL_DIRECTEDBROADCAST: u32 = 9;
pub const IPCTL_INTRQMAXLEN: u32 = 10;
pub const IPCTL_INTRQDROPS: u32 = 11;
pub const IPCTL_STATS: u32 = 12;
pub const IPCTL_ACCEPTSOURCEROUTE: u32 = 13;
pub const IPCTL_FASTFORWARDING: u32 = 14;
pub const IPCTL_KEEPFAITH: u32 = 15;
pub const IPCTL_GIF_TTL: u32 = 16;
pub const IPCTL_MAXID: u32 = 17;
pub const __KAME_VERSION: &[u8; 18] = b"2009/apple-darwin\0";
pub const IPV6PORT_RESERVED: u32 = 1024;
pub const IPV6PORT_ANONMIN: u32 = 49152;
pub const IPV6PORT_ANONMAX: u32 = 65535;
pub const IPV6PORT_RESERVEDMIN: u32 = 600;
pub const IPV6PORT_RESERVEDMAX: u32 = 1023;
pub const INET6_ADDRSTRLEN: u32 = 46;
pub const __IPV6_ADDR_SCOPE_NODELOCAL: u32 = 1;
pub const __IPV6_ADDR_SCOPE_INTFACELOCAL: u32 = 1;
pub const __IPV6_ADDR_SCOPE_LINKLOCAL: u32 = 2;
pub const __IPV6_ADDR_SCOPE_SITELOCAL: u32 = 5;
pub const __IPV6_ADDR_SCOPE_ORGLOCAL: u32 = 8;
pub const __IPV6_ADDR_SCOPE_GLOBAL: u32 = 14;
pub const IPV6_ADDR_MC_FLAGS_TRANSIENT: u32 = 16;
pub const IPV6_ADDR_MC_FLAGS_PREFIX: u32 = 32;
pub const IPV6_ADDR_MC_FLAGS_UNICAST_BASED: u32 = 48;
pub const IPV6_SOCKOPT_RESERVED1: u32 = 3;
pub const IPV6_UNICAST_HOPS: u32 = 4;
pub const IPV6_MULTICAST_IF: u32 = 9;
pub const IPV6_MULTICAST_HOPS: u32 = 10;
pub const IPV6_MULTICAST_LOOP: u32 = 11;
pub const IPV6_JOIN_GROUP: u32 = 12;
pub const IPV6_LEAVE_GROUP: u32 = 13;
pub const IPV6_PORTRANGE: u32 = 14;
pub const ICMP6_FILTER: u32 = 18;
pub const IPV6_2292PKTINFO: u32 = 19;
pub const IPV6_2292HOPLIMIT: u32 = 20;
pub const IPV6_2292NEXTHOP: u32 = 21;
pub const IPV6_2292HOPOPTS: u32 = 22;
pub const IPV6_2292DSTOPTS: u32 = 23;
pub const IPV6_2292RTHDR: u32 = 24;
pub const IPV6_2292PKTOPTIONS: u32 = 25;
pub const IPV6_CHECKSUM: u32 = 26;
pub const IPV6_V6ONLY: u32 = 27;
pub const IPV6_BINDV6ONLY: u32 = 27;
pub const IPV6_IPSEC_POLICY: u32 = 28;
pub const IPV6_FAITH: u32 = 29;
pub const IPV6_FW_ADD: u32 = 30;
pub const IPV6_FW_DEL: u32 = 31;
pub const IPV6_FW_FLUSH: u32 = 32;
pub const IPV6_FW_ZERO: u32 = 33;
pub const IPV6_FW_GET: u32 = 34;
pub const IPV6_RECVTCLASS: u32 = 35;
pub const IPV6_TCLASS: u32 = 36;
pub const IPV6_BOUND_IF: u32 = 125;
pub const IPV6_NO_IFT_CELLULAR: u32 = 6969;
pub const IPV6_OUT_IF: u32 = 9696;
pub const IPV6_RTHDR_LOOSE: u32 = 0;
pub const IPV6_RTHDR_STRICT: u32 = 1;
pub const IPV6_RTHDR_TYPE_0: u32 = 0;
pub const IPV6_DEFAULT_MULTICAST_HOPS: u32 = 1;
pub const IPV6_DEFAULT_MULTICAST_LOOP: u32 = 1;
pub const IPV6_MIN_MEMBERSHIPS: u32 = 31;
pub const IPV6_MAX_MEMBERSHIPS: u32 = 4095;
pub const IPV6_MAX_GROUP_SRC_FILTER: u32 = 512;
pub const IPV6_MAX_SOCK_SRC_FILTER: u32 = 128;
pub const IPV6_PORTRANGE_DEFAULT: u32 = 0;
pub const IPV6_PORTRANGE_HIGH: u32 = 1;
pub const IPV6_PORTRANGE_LOW: u32 = 2;
pub const IPV6PROTO_MAXID: u32 = 104;
pub const IPV6CTL_FORWARDING: u32 = 1;
pub const IPV6CTL_SENDREDIRECTS: u32 = 2;
pub const IPV6CTL_DEFHLIM: u32 = 3;
pub const IPV6CTL_FORWSRCRT: u32 = 5;
pub const IPV6CTL_STATS: u32 = 6;
pub const IPV6CTL_MRTSTATS: u32 = 7;
pub const IPV6CTL_MRTPROTO: u32 = 8;
pub const IPV6CTL_MAXFRAGPACKETS: u32 = 9;
pub const IPV6CTL_SOURCECHECK: u32 = 10;
pub const IPV6CTL_SOURCECHECK_LOGINT: u32 = 11;
pub const IPV6CTL_ACCEPT_RTADV: u32 = 12;
pub const IPV6CTL_KEEPFAITH: u32 = 13;
pub const IPV6CTL_LOG_INTERVAL: u32 = 14;
pub const IPV6CTL_HDRNESTLIMIT: u32 = 15;
pub const IPV6CTL_DAD_COUNT: u32 = 16;
pub const IPV6CTL_AUTO_FLOWLABEL: u32 = 17;
pub const IPV6CTL_DEFMCASTHLIM: u32 = 18;
pub const IPV6CTL_GIF_HLIM: u32 = 19;
pub const IPV6CTL_KAME_VERSION: u32 = 20;
pub const IPV6CTL_USE_DEPRECATED: u32 = 21;
pub const IPV6CTL_RR_PRUNE: u32 = 22;
pub const IPV6CTL_V6ONLY: u32 = 24;
pub const IPV6CTL_RTEXPIRE: u32 = 25;
pub const IPV6CTL_RTMINEXPIRE: u32 = 26;
pub const IPV6CTL_RTMAXCACHE: u32 = 27;
pub const IPV6CTL_USETEMPADDR: u32 = 32;
pub const IPV6CTL_TEMPPLTIME: u32 = 33;
pub const IPV6CTL_TEMPVLTIME: u32 = 34;
pub const IPV6CTL_AUTO_LINKLOCAL: u32 = 35;
pub const IPV6CTL_RIP6STATS: u32 = 36;
pub const IPV6CTL_PREFER_TEMPADDR: u32 = 37;
pub const IPV6CTL_ADDRCTLPOLICY: u32 = 38;
pub const IPV6CTL_USE_DEFAULTZONE: u32 = 39;
pub const IPV6CTL_MAXFRAGS: u32 = 41;
pub const IPV6CTL_MCAST_PMTU: u32 = 44;
pub const IPV6CTL_NEIGHBORGCTHRESH: u32 = 46;
pub const IPV6CTL_MAXIFPREFIXES: u32 = 47;
pub const IPV6CTL_MAXIFDEFROUTERS: u32 = 48;
pub const IPV6CTL_MAXDYNROUTES: u32 = 49;
pub const ICMPV6CTL_ND6_ONLINKNSRFC4861: u32 = 50;
pub const IPV6CTL_ULA_USETEMPADDR: u32 = 51;
pub const IPV6CTL_MAXID: u32 = 51;
pub const _DSCP_DF: u32 = 0;
pub const _DSCP_CS0: u32 = 0;
pub const _DSCP_CS1: u32 = 8;
pub const _DSCP_CS2: u32 = 16;
pub const _DSCP_CS3: u32 = 24;
pub const _DSCP_CS4: u32 = 32;
pub const _DSCP_CS5: u32 = 40;
pub const _DSCP_CS6: u32 = 48;
pub const _DSCP_CS7: u32 = 56;
pub const _DSCP_EF: u32 = 46;
pub const _DSCP_VA: u32 = 44;
pub const _DSCP_AF11: u32 = 10;
pub const _DSCP_AF12: u32 = 12;
pub const _DSCP_AF13: u32 = 14;
pub const _DSCP_AF21: u32 = 18;
pub const _DSCP_AF22: u32 = 20;
pub const _DSCP_AF23: u32 = 22;
pub const _DSCP_AF31: u32 = 26;
pub const _DSCP_AF32: u32 = 28;
pub const _DSCP_AF33: u32 = 30;
pub const _DSCP_AF41: u32 = 34;
pub const _DSCP_AF42: u32 = 36;
pub const _DSCP_AF43: u32 = 38;
pub const _DSCP_52: u32 = 52;
pub const _MAX_DSCP: u32 = 63;
pub const ITIMER_REAL: u32 = 0;
pub const ITIMER_VIRTUAL: u32 = 1;
pub const ITIMER_PROF: u32 = 2;
pub const DST_NONE: u32 = 0;
pub const DST_USA: u32 = 1;
pub const DST_AUST: u32 = 2;
pub const DST_WET: u32 = 3;
pub const DST_MET: u32 = 4;
pub const DST_EET: u32 = 5;
pub const DST_CAN: u32 = 6;
pub const __DARWIN_WCHAR_MIN: i32 = -2147483648;
pub const _FORTIFY_SOURCE: u32 = 2;
pub const TIME_UTC: u32 = 1;
pub const RTM_RTTUNIT: u32 = 1000000;
pub const RTF_UP: u32 = 1;
pub const RTF_GATEWAY: u32 = 2;
pub const RTF_HOST: u32 = 4;
pub const RTF_REJECT: u32 = 8;
pub const RTF_DYNAMIC: u32 = 16;
pub const RTF_MODIFIED: u32 = 32;
pub const RTF_DONE: u32 = 64;
pub const RTF_DELCLONE: u32 = 128;
pub const RTF_CLONING: u32 = 256;
pub const RTF_XRESOLVE: u32 = 512;
pub const RTF_LLINFO: u32 = 1024;
pub const RTF_LLDATA: u32 = 1024;
pub const RTF_STATIC: u32 = 2048;
pub const RTF_BLACKHOLE: u32 = 4096;
pub const RTF_NOIFREF: u32 = 8192;
pub const RTF_PROTO2: u32 = 16384;
pub const RTF_PROTO1: u32 = 32768;
pub const RTF_PRCLONING: u32 = 65536;
pub const RTF_WASCLONED: u32 = 131072;
pub const RTF_PROTO3: u32 = 262144;
pub const RTF_PINNED: u32 = 1048576;
pub const RTF_LOCAL: u32 = 2097152;
pub const RTF_BROADCAST: u32 = 4194304;
pub const RTF_MULTICAST: u32 = 8388608;
pub const RTF_IFSCOPE: u32 = 16777216;
pub const RTF_CONDEMNED: u32 = 33554432;
pub const RTF_IFREF: u32 = 67108864;
pub const RTF_PROXY: u32 = 134217728;
pub const RTF_ROUTER: u32 = 268435456;
pub const RTF_DEAD: u32 = 536870912;
pub const RTF_GLOBAL: u32 = 1073741824;
pub const RTPRF_OURS: u32 = 262144;
pub const RTF_BITS : & [u8 ; 223] = b"\x10\x01UP\x02GATEWAY\x03HOST\x04REJECT\x05DYNAMIC\x06MODIFIED\x07DONE\x08DELCLONE\tCLONING\nXRESOLVE\x0BLLINFO\x0CSTATIC\rBLACKHOLE\x0ENOIFREF\x0FPROTO2\x10PROTO1\x11PRCLONING\x12WASCLONED\x13PROTO3\x15PINNED\x16LOCAL\x17BROADCAST\x18MULTICAST\x19IFSCOPE\x1ACONDEMNED\x1BIFREF\x1CPROXY\x1DROUTER\x1FGLOBAL\0" ;
pub const RTM_VERSION: u32 = 5;
pub const RTM_ADD: u32 = 1;
pub const RTM_DELETE: u32 = 2;
pub const RTM_CHANGE: u32 = 3;
pub const RTM_GET: u32 = 4;
pub const RTM_LOSING: u32 = 5;
pub const RTM_REDIRECT: u32 = 6;
pub const RTM_MISS: u32 = 7;
pub const RTM_LOCK: u32 = 8;
pub const RTM_OLDADD: u32 = 9;
pub const RTM_OLDDEL: u32 = 10;
pub const RTM_RESOLVE: u32 = 11;
pub const RTM_NEWADDR: u32 = 12;
pub const RTM_DELADDR: u32 = 13;
pub const RTM_IFINFO: u32 = 14;
pub const RTM_NEWMADDR: u32 = 15;
pub const RTM_DELMADDR: u32 = 16;
pub const RTM_GET_SILENT: u32 = 17;
pub const RTM_IFINFO2: u32 = 18;
pub const RTM_NEWMADDR2: u32 = 19;
pub const RTM_GET2: u32 = 20;
pub const RTM_GET_EXT: u32 = 21;
pub const RTV_MTU: u32 = 1;
pub const RTV_HOPCOUNT: u32 = 2;
pub const RTV_EXPIRE: u32 = 4;
pub const RTV_RPIPE: u32 = 8;
pub const RTV_SPIPE: u32 = 16;
pub const RTV_SSTHRESH: u32 = 32;
pub const RTV_RTT: u32 = 64;
pub const RTV_RTTVAR: u32 = 128;
pub const RTV_REFRESH_HOST: u32 = 256;
pub const RTA_DST: u32 = 1;
pub const RTA_GATEWAY: u32 = 2;
pub const RTA_NETMASK: u32 = 4;
pub const RTA_GENMASK: u32 = 8;
pub const RTA_IFP: u32 = 16;
pub const RTA_IFA: u32 = 32;
pub const RTA_AUTHOR: u32 = 64;
pub const RTA_BRD: u32 = 128;
pub const RTAX_DST: u32 = 0;
pub const RTAX_GATEWAY: u32 = 1;
pub const RTAX_NETMASK: u32 = 2;
pub const RTAX_GENMASK: u32 = 3;
pub const RTAX_IFP: u32 = 4;
pub const RTAX_IFA: u32 = 5;
pub const RTAX_AUTHOR: u32 = 6;
pub const RTAX_BRD: u32 = 7;
pub const RTAX_MAX: u32 = 8;
pub const IFSCOPE_NONE: u32 = 0;
pub const APPLE_IF_FAM_LOOPBACK: u32 = 1;
pub const APPLE_IF_FAM_ETHERNET: u32 = 2;
pub const APPLE_IF_FAM_SLIP: u32 = 3;
pub const APPLE_IF_FAM_TUN: u32 = 4;
pub const APPLE_IF_FAM_VLAN: u32 = 5;
pub const APPLE_IF_FAM_PPP: u32 = 6;
pub const APPLE_IF_FAM_PVC: u32 = 7;
pub const APPLE_IF_FAM_DISC: u32 = 8;
pub const APPLE_IF_FAM_MDECAP: u32 = 9;
pub const APPLE_IF_FAM_GIF: u32 = 10;
pub const APPLE_IF_FAM_FAITH: u32 = 11;
pub const APPLE_IF_FAM_STF: u32 = 12;
pub const APPLE_IF_FAM_FIREWIRE: u32 = 13;
pub const APPLE_IF_FAM_BOND: u32 = 14;
pub const APPLE_IF_FAM_CELLULAR: u32 = 15;
pub const APPLE_IF_FAM_6LOWPAN: u32 = 16;
pub const APPLE_IF_FAM_UTUN: u32 = 17;
pub const APPLE_IF_FAM_IPSEC: u32 = 18;
pub const IF_MINMTU: u32 = 72;
pub const IF_MAXMTU: u32 = 65535;
pub const IFNAMSIZ: u32 = 16;
pub const IF_NETEM_PARAMS_PSCALE: u32 = 100000;
pub const IF_VAR_H_HAS_IFNET_STATS_PER_FLOW: u32 = 1;
pub const IF_CELLULAR_STATUS_REPORT_VERSION_1: u32 = 1;
pub const IF_WIFI_STATUS_REPORT_VERSION_1: u32 = 1;
pub const IF_CELLULAR_STATUS_REPORT_CURRENT_VERSION: u32 = 1;
pub const IF_WIFI_STATUS_REPORT_CURRENT_VERSION: u32 = 1;
pub const IF_CELL_LINK_QUALITY_METRIC_VALID: u32 = 1;
pub const IF_CELL_UL_EFFECTIVE_BANDWIDTH_VALID: u32 = 2;
pub const IF_CELL_UL_MAX_BANDWIDTH_VALID: u32 = 4;
pub const IF_CELL_UL_MIN_LATENCY_VALID: u32 = 8;
pub const IF_CELL_UL_EFFECTIVE_LATENCY_VALID: u32 = 16;
pub const IF_CELL_UL_MAX_LATENCY_VALID: u32 = 32;
pub const IF_CELL_UL_RETXT_LEVEL_VALID: u32 = 64;
pub const IF_CELL_UL_BYTES_LOST_VALID: u32 = 128;
pub const IF_CELL_UL_MIN_QUEUE_SIZE_VALID: u32 = 256;
pub const IF_CELL_UL_AVG_QUEUE_SIZE_VALID: u32 = 512;
pub const IF_CELL_UL_MAX_QUEUE_SIZE_VALID: u32 = 1024;
pub const IF_CELL_DL_EFFECTIVE_BANDWIDTH_VALID: u32 = 2048;
pub const IF_CELL_DL_MAX_BANDWIDTH_VALID: u32 = 4096;
pub const IF_CELL_CONFIG_INACTIVITY_TIME_VALID: u32 = 8192;
pub const IF_CELL_CONFIG_BACKOFF_TIME_VALID: u32 = 16384;
pub const IF_CELL_UL_MSS_RECOMMENDED_VALID: u32 = 32768;
pub const IF_CELL_UL_RETXT_LEVEL_NONE: u32 = 1;
pub const IF_CELL_UL_RETXT_LEVEL_LOW: u32 = 2;
pub const IF_CELL_UL_RETXT_LEVEL_MEDIUM: u32 = 3;
pub const IF_CELL_UL_RETXT_LEVEL_HIGH: u32 = 4;
pub const IF_CELL_UL_MSS_RECOMMENDED_NONE: u32 = 0;
pub const IF_CELL_UL_MSS_RECOMMENDED_MEDIUM: u32 = 1;
pub const IF_CELL_UL_MSS_RECOMMENDED_LOW: u32 = 2;
pub const IF_WIFI_LINK_QUALITY_METRIC_VALID: u32 = 1;
pub const IF_WIFI_UL_EFFECTIVE_BANDWIDTH_VALID: u32 = 2;
pub const IF_WIFI_UL_MAX_BANDWIDTH_VALID: u32 = 4;
pub const IF_WIFI_UL_MIN_LATENCY_VALID: u32 = 8;
pub const IF_WIFI_UL_EFFECTIVE_LATENCY_VALID: u32 = 16;
pub const IF_WIFI_UL_MAX_LATENCY_VALID: u32 = 32;
pub const IF_WIFI_UL_RETXT_LEVEL_VALID: u32 = 64;
pub const IF_WIFI_UL_ERROR_RATE_VALID: u32 = 128;
pub const IF_WIFI_UL_BYTES_LOST_VALID: u32 = 256;
pub const IF_WIFI_DL_EFFECTIVE_BANDWIDTH_VALID: u32 = 512;
pub const IF_WIFI_DL_MAX_BANDWIDTH_VALID: u32 = 1024;
pub const IF_WIFI_DL_MIN_LATENCY_VALID: u32 = 2048;
pub const IF_WIFI_DL_EFFECTIVE_LATENCY_VALID: u32 = 4096;
pub const IF_WIFI_DL_MAX_LATENCY_VALID: u32 = 8192;
pub const IF_WIFI_DL_ERROR_RATE_VALID: u32 = 16384;
pub const IF_WIFI_CONFIG_FREQUENCY_VALID: u32 = 32768;
pub const IF_WIFI_CONFIG_MULTICAST_RATE_VALID: u32 = 65536;
pub const IF_WIFI_CONFIG_SCAN_COUNT_VALID: u32 = 131072;
pub const IF_WIFI_CONFIG_SCAN_DURATION_VALID: u32 = 262144;
pub const IF_WIFI_UL_RETXT_LEVEL_NONE: u32 = 1;
pub const IF_WIFI_UL_RETXT_LEVEL_LOW: u32 = 2;
pub const IF_WIFI_UL_RETXT_LEVEL_MEDIUM: u32 = 3;
pub const IF_WIFI_UL_RETXT_LEVEL_HIGH: u32 = 4;
pub const IF_WIFI_CONFIG_FREQUENCY_2_4_GHZ: u32 = 1;
pub const IF_WIFI_CONFIG_FREQUENCY_5_0_GHZ: u32 = 2;
pub const IF_INTERFACE_STATE_RRC_STATE_VALID: u32 = 1;
pub const IF_INTERFACE_STATE_LQM_STATE_VALID: u32 = 2;
pub const IF_INTERFACE_STATE_INTERFACE_AVAILABILITY_VALID: u32 = 4;
pub const IF_INTERFACE_STATE_RRC_STATE_IDLE: u32 = 0;
pub const IF_INTERFACE_STATE_RRC_STATE_CONNECTED: u32 = 1;
pub const IF_INTERFACE_STATE_INTERFACE_AVAILABLE: u32 = 0;
pub const IF_INTERFACE_STATE_INTERFACE_UNAVAILABLE: u32 = 1;
pub const IF_INTERFACE_ADVISORY_VERSION_1: u32 = 1;
pub const IF_INTERFACE_ADVISORY_VERSION_CURRENT: u32 = 1;
pub const IF_INTERFACE_ADVISORY_DIRECTION_TX: u32 = 1;
pub const IF_INTERFACE_ADVISORY_DIRECTION_RX: u32 = 2;
pub const IF_INTERFACE_ADVISORY_RATE_SUGGESTION_RAMP_UP: u32 = 2147483647;
pub const IF_INTERFACE_ADVISORY_RATE_SUGGESTION_RAMP_DOWN: i32 = -2147483648;
pub const IF_INTERFACE_ADVISORY_RATE_SUGGESTION_RAMP_NEUTRAL: u32 = 0;
pub const IF_HWASSIST_CSUM_IP: u32 = 1;
pub const IF_HWASSIST_CSUM_TCP: u32 = 2;
pub const IF_HWASSIST_CSUM_UDP: u32 = 4;
pub const IF_HWASSIST_CSUM_IP_FRAGS: u32 = 8;
pub const IF_HWASSIST_CSUM_FRAGMENT: u32 = 16;
pub const IF_HWASSIST_CSUM_TCPIPV6: u32 = 32;
pub const IF_HWASSIST_CSUM_UDPIPV6: u32 = 64;
pub const IF_HWASSIST_CSUM_FRAGMENT_IPV6: u32 = 128;
pub const IF_HWASSIST_CSUM_PARTIAL: u32 = 4096;
pub const IF_HWASSIST_CSUM_ZERO_INVERT: u32 = 8192;
pub const IF_HWASSIST_CSUM_MASK: u32 = 65535;
pub const IF_HWASSIST_VLAN_TAGGING: u32 = 65536;
pub const IF_HWASSIST_VLAN_MTU: u32 = 131072;
pub const IF_HWASSIST_TSO_V4: u32 = 2097152;
pub const IF_HWASSIST_TSO_V6: u32 = 4194304;
pub const IFXNAMSIZ: u32 = 24;
pub const IFNET_NETWORK_ID_LEN: u32 = 32;
pub const PF_MD5_DIGEST_LENGTH: u32 = 16;
pub const PF_GRE_PPTP_VARIANT: u32 = 1;
pub const PFTM_TCP_FIRST_PACKET_VAL: u32 = 120;
pub const PFTM_TCP_OPENING_VAL: u32 = 30;
pub const PFTM_TCP_ESTABLISHED_VAL: u32 = 86400;
pub const PFTM_TCP_CLOSING_VAL: u32 = 900;
pub const PFTM_TCP_FIN_WAIT_VAL: u32 = 45;
pub const PFTM_TCP_CLOSED_VAL: u32 = 90;
pub const PFTM_UDP_FIRST_PACKET_VAL: u32 = 60;
pub const PFTM_UDP_SINGLE_VAL: u32 = 30;
pub const PFTM_UDP_MULTIPLE_VAL: u32 = 60;
pub const PFTM_ICMP_FIRST_PACKET_VAL: u32 = 20;
pub const PFTM_ICMP_ERROR_REPLY_VAL: u32 = 10;
pub const PFTM_GREv1_FIRST_PACKET_VAL: u32 = 120;
pub const PFTM_GREv1_INITIATING_VAL: u32 = 30;
pub const PFTM_GREv1_ESTABLISHED_VAL: u32 = 1800;
pub const PFTM_ESP_FIRST_PACKET_VAL: u32 = 120;
pub const PFTM_ESP_INITIATING_VAL: u32 = 30;
pub const PFTM_ESP_ESTABLISHED_VAL: u32 = 900;
pub const PFTM_OTHER_FIRST_PACKET_VAL: u32 = 60;
pub const PFTM_OTHER_SINGLE_VAL: u32 = 30;
pub const PFTM_OTHER_MULTIPLE_VAL: u32 = 60;
pub const PFTM_FRAG_VAL: u32 = 30;
pub const PFTM_INTERVAL_VAL: u32 = 10;
pub const PFTM_SRC_NODE_VAL: u32 = 0;
pub const PFTM_TS_DIFF_VAL: u32 = 30;
pub const PF_POOL_IDMASK: u32 = 15;
pub const PF_POOL_TYPEMASK: u32 = 15;
pub const PF_POOL_STICKYADDR: u32 = 32;
pub const PF_WSCALE_FLAG: u32 = 128;
pub const PF_WSCALE_MASK: u32 = 15;
pub const PF_LOG: u32 = 1;
pub const PF_LOG_ALL: u32 = 2;
pub const PF_LOG_SOCKET_LOOKUP: u32 = 4;
pub const PF_TABLE_NAME_SIZE: u32 = 32;
pub const PFI_AFLAG_NETWORK: u32 = 1;
pub const PFI_AFLAG_BROADCAST: u32 = 2;
pub const PFI_AFLAG_PEER: u32 = 4;
pub const PFI_AFLAG_MODEMASK: u32 = 7;
pub const PFI_AFLAG_NOALIAS: u32 = 8;
pub const RTLABEL_LEN: u32 = 32;
pub const PF_OSFP_EXPANDED: u32 = 1;
pub const PF_OSFP_GENERIC: u32 = 2;
pub const PF_OSFP_NODETAIL: u32 = 4;
pub const PF_OSFP_LEN: u32 = 32;
pub const _FP_RESERVED_BIT: u32 = 1;
pub const _FP_UNUSED_BITS: u32 = 1;
pub const _FP_CLASS_BITS: u32 = 10;
pub const _FP_VERSION_BITS: u32 = 10;
pub const _FP_SUBTYPE_BITS: u32 = 10;
pub const PF_OSFP_WSIZE_MOD: u32 = 1;
pub const PF_OSFP_WSIZE_DC: u32 = 2;
pub const PF_OSFP_WSIZE_MSS: u32 = 4;
pub const PF_OSFP_WSIZE_MTU: u32 = 8;
pub const PF_OSFP_PSIZE_MOD: u32 = 16;
pub const PF_OSFP_PSIZE_DC: u32 = 32;
pub const PF_OSFP_WSCALE: u32 = 64;
pub const PF_OSFP_WSCALE_MOD: u32 = 128;
pub const PF_OSFP_WSCALE_DC: u32 = 256;
pub const PF_OSFP_MSS: u32 = 512;
pub const PF_OSFP_MSS_MOD: u32 = 1024;
pub const PF_OSFP_MSS_DC: u32 = 2048;
pub const PF_OSFP_DF: u32 = 4096;
pub const PF_OSFP_TS0: u32 = 8192;
pub const PF_OSFP_INET6: u32 = 16384;
pub const PF_OSFP_MAXTTL_OFFSET: u32 = 40;
pub const PF_OSFP_TCPOPT_NOP: u32 = 0;
pub const PF_OSFP_TCPOPT_WSCALE: u32 = 1;
pub const PF_OSFP_TCPOPT_MSS: u32 = 2;
pub const PF_OSFP_TCPOPT_SACK: u32 = 3;
pub const PF_OSFP_TCPOPT_TS: u32 = 4;
pub const PF_OSFP_TCPOPT_BITS: u32 = 3;
pub const PF_ANCHOR_NAME_SIZE: u32 = 64;
pub const PF_SKIP_IFP: u32 = 0;
pub const PF_SKIP_DIR: u32 = 1;
pub const PF_SKIP_AF: u32 = 2;
pub const PF_SKIP_PROTO: u32 = 3;
pub const PF_SKIP_SRC_ADDR: u32 = 4;
pub const PF_SKIP_SRC_PORT: u32 = 5;
pub const PF_SKIP_DST_ADDR: u32 = 6;
pub const PF_SKIP_DST_PORT: u32 = 7;
pub const PF_SKIP_COUNT: u32 = 8;
pub const PF_RULE_LABEL_SIZE: u32 = 64;
pub const PF_QNAME_SIZE: u32 = 64;
pub const PF_TAG_NAME_SIZE: u32 = 64;
pub const PF_OWNER_NAME_SIZE: u32 = 64;
pub const PF_STATE_NORMAL: u32 = 1;
pub const PF_STATE_MODULATE: u32 = 2;
pub const PF_STATE_SYNPROXY: u32 = 3;
pub const SCIDX_MASK: u32 = 15;
pub const SC_BE: u32 = 16;
pub const SC_BK_SYS: u32 = 17;
pub const SC_BK: u32 = 18;
pub const SC_RD: u32 = 19;
pub const SC_OAM: u32 = 20;
pub const SC_AV: u32 = 21;
pub const SC_RV: u32 = 22;
pub const SC_VI: u32 = 23;
pub const SC_SIG: u32 = 23;
pub const SC_VO: u32 = 24;
pub const SC_CTL: u32 = 25;
pub const DSCP_MASK: u32 = 252;
pub const DSCP_CUMASK: u32 = 3;
pub const DSCP_EF: u32 = 184;
pub const DSCP_AF11: u32 = 40;
pub const DSCP_AF12: u32 = 48;
pub const DSCP_AF13: u32 = 56;
pub const DSCP_AF21: u32 = 72;
pub const DSCP_AF22: u32 = 80;
pub const DSCP_AF23: u32 = 88;
pub const DSCP_AF31: u32 = 104;
pub const DSCP_AF32: u32 = 112;
pub const DSCP_AF33: u32 = 120;
pub const DSCP_AF41: u32 = 136;
pub const DSCP_AF42: u32 = 144;
pub const DSCP_AF43: u32 = 152;
pub const AF_CLASSMASK: u32 = 224;
pub const AF_DROPPRECMASK: u32 = 24;
pub const PF_FLUSH: u32 = 1;
pub const PF_FLUSH_GLOBAL: u32 = 2;
pub const PFDEV_PF: u32 = 0;
pub const PFDEV_PFM: u32 = 1;
pub const PFDEV_MAX: u32 = 2;
pub const PFRULE_DROP: u32 = 0;
pub const PFRULE_RETURNRST: u32 = 1;
pub const PFRULE_FRAGMENT: u32 = 2;
pub const PFRULE_RETURNICMP: u32 = 4;
pub const PFRULE_RETURN: u32 = 8;
pub const PFRULE_NOSYNC: u32 = 16;
pub const PFRULE_SRCTRACK: u32 = 32;
pub const PFRULE_RULESRCTRACK: u32 = 64;
pub const PFRULE_NODF: u32 = 256;
pub const PFRULE_FRAGCROP: u32 = 512;
pub const PFRULE_FRAGDROP: u32 = 1024;
pub const PFRULE_RANDOMID: u32 = 2048;
pub const PFRULE_REASSEMBLE_TCP: u32 = 4096;
pub const PFRULE_TOS: u32 = 8192;
pub const PFRULE_DSCP: u32 = 16384;
pub const PFRULE_SC: u32 = 32768;
pub const PFRULE_IFBOUND: u32 = 65536;
pub const PFRULE_PFM: u32 = 131072;
pub const PFSTATE_HIWAT: u32 = 10000;
pub const PFSTATE_ADAPT_START: u32 = 6000;
pub const PFSTATE_ADAPT_END: u32 = 12000;
pub const PFAPPSTATE_HIWAT: u32 = 10000;
pub const PF_TAG_NAME_SYSTEM_SERVICE: &[u8; 32] = b"com.apple.pf.system_service_tag\0";
pub const PF_TAG_NAME_STACK_DROP: &[u8; 28] = b"com.apple.pf.stack_drop_tag\0";
pub const PF_THRESHOLD_MULT: u32 = 1000;
pub const PF_THRESHOLD_MAX: u32 = 4294967;
pub const PFSNODE_HIWAT: u32 = 10000;
pub const PFSTATE_NOSYNC: u32 = 1;
pub const PFSTATE_FROMSYNC: u32 = 2;
pub const PFSTATE_STALE: u32 = 4;
pub const PFSYNC_SCRUB_FLAG_VALID: u32 = 1;
pub const PFSYNC_FLAG_COMPRESS: u32 = 1;
pub const PFSYNC_FLAG_STALE: u32 = 2;
pub const PFSYNC_FLAG_SRCNODE: u32 = 4;
pub const PFSYNC_FLAG_NATSRCNODE: u32 = 8;
pub const PF_RESERVED_ANCHOR: &[u8; 4] = b"_pf\0";
pub const PFR_TFLAG_PERSIST: u32 = 1;
pub const PFR_TFLAG_CONST: u32 = 2;
pub const PFR_TFLAG_ACTIVE: u32 = 4;
pub const PFR_TFLAG_INACTIVE: u32 = 8;
pub const PFR_TFLAG_REFERENCED: u32 = 16;
pub const PFR_TFLAG_REFDANCHOR: u32 = 32;
pub const PFR_TFLAG_USRMASK: u32 = 3;
pub const PFR_TFLAG_SETMASK: u32 = 60;
pub const PFR_TFLAG_ALLMASK: u32 = 63;
pub const PFI_IFLAG_SKIP: u32 = 256;
pub const PF_DPORT_RANGE: u32 = 1;
pub const PF_RPORT_RANGE: u32 = 2;
pub const PFRES_MATCH: u32 = 0;
pub const PFRES_BADOFF: u32 = 1;
pub const PFRES_FRAG: u32 = 2;
pub const PFRES_SHORT: u32 = 3;
pub const PFRES_NORM: u32 = 4;
pub const PFRES_MEMORY: u32 = 5;
pub const PFRES_TS: u32 = 6;
pub const PFRES_CONGEST: u32 = 7;
pub const PFRES_IPOPTIONS: u32 = 8;
pub const PFRES_PROTCKSUM: u32 = 9;
pub const PFRES_BADSTATE: u32 = 10;
pub const PFRES_STATEINS: u32 = 11;
pub const PFRES_MAXSTATES: u32 = 12;
pub const PFRES_SRCLIMIT: u32 = 13;
pub const PFRES_SYNPROXY: u32 = 14;
pub const PFRES_DUMMYNET: u32 = 15;
pub const PFRES_MAX: u32 = 16;
pub const LCNT_STATES: u32 = 0;
pub const LCNT_SRCSTATES: u32 = 1;
pub const LCNT_SRCNODES: u32 = 2;
pub const LCNT_SRCCONN: u32 = 3;
pub const LCNT_SRCCONNRATE: u32 = 4;
pub const LCNT_OVERLOAD_TABLE: u32 = 5;
pub const LCNT_OVERLOAD_FLUSH: u32 = 6;
pub const LCNT_MAX: u32 = 7;
pub const PFUDPS_NO_TRAFFIC: u32 = 0;
pub const PFUDPS_SINGLE: u32 = 1;
pub const PFUDPS_MULTIPLE: u32 = 2;
pub const PFUDPS_NSTATES: u32 = 3;
pub const PFGRE1S_NO_TRAFFIC: u32 = 0;
pub const PFGRE1S_INITIATING: u32 = 1;
pub const PFGRE1S_ESTABLISHED: u32 = 2;
pub const PFGRE1S_NSTATES: u32 = 3;
pub const PFESPS_NO_TRAFFIC: u32 = 0;
pub const PFESPS_INITIATING: u32 = 1;
pub const PFESPS_ESTABLISHED: u32 = 2;
pub const PFESPS_NSTATES: u32 = 3;
pub const PFOTHERS_NO_TRAFFIC: u32 = 0;
pub const PFOTHERS_SINGLE: u32 = 1;
pub const PFOTHERS_MULTIPLE: u32 = 2;
pub const PFOTHERS_NSTATES: u32 = 3;
pub const FCNT_STATE_SEARCH: u32 = 0;
pub const FCNT_STATE_INSERT: u32 = 1;
pub const FCNT_STATE_REMOVALS: u32 = 2;
pub const FCNT_MAX: u32 = 3;
pub const SCNT_SRC_NODE_SEARCH: u32 = 0;
pub const SCNT_SRC_NODE_INSERT: u32 = 1;
pub const SCNT_SRC_NODE_REMOVALS: u32 = 2;
pub const SCNT_MAX: u32 = 3;
pub const PF_ALTQ_BW_ABSOLUTE: u32 = 1;
pub const PF_ALTQ_BW_PERCENT: u32 = 2;
pub const PF_ALTQF_TBR: u32 = 1;
pub const PF_ALTQ_QRF_WEIGHT: u32 = 1;
pub const PFFRAG_FRENT_HIWAT: u32 = 5000;
pub const PFFRAG_FRAG_HIWAT: u32 = 1000;
pub const PFFRAG_FRCENT_HIWAT: u32 = 50000;
pub const PFFRAG_FRCACHE_HIWAT: u32 = 10000;
pub const PFR_KTABLE_HIWAT: u32 = 1000;
pub const PFR_KENTRY_HIWAT: u32 = 200000;
pub const PFR_KENTRY_HIWAT_SMALL: u32 = 100000;
pub const PFTOK_PROCNAME_LEN: u32 = 64;
pub const PFR_FLAG_ATOMIC: u32 = 1;
pub const PFR_FLAG_DUMMY: u32 = 2;
pub const PFR_FLAG_FEEDBACK: u32 = 4;
pub const PFR_FLAG_CLSTATS: u32 = 8;
pub const PFR_FLAG_ADDRSTOO: u32 = 16;
pub const PFR_FLAG_REPLACE: u32 = 32;
pub const PFR_FLAG_ALLRSETS: u32 = 64;
pub const PFR_FLAG_ALLMASK: u32 = 127;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
pub type __darwin_intptr_t = ::std::os::raw::c_long;
pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_ct_rune_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t {
    pub __mbstate8: [::std::os::raw::c_char; 128usize],
    pub _mbstateL: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    const UNINIT: ::std::mem::MaybeUninit<__mbstate_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        128usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__mbstate8) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__mbstate8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._mbstateL) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(_mbstateL)
        )
    );
}
pub type __darwin_mbstate_t = __mbstate_t;
pub type __darwin_ptrdiff_t = ::std::os::raw::c_long;
pub type __darwin_size_t = ::std::os::raw::c_ulong;
pub type __darwin_va_list = __builtin_va_list;
pub type __darwin_wchar_t = ::std::os::raw::c_int;
pub type __darwin_rune_t = __darwin_wchar_t;
pub type __darwin_wint_t = ::std::os::raw::c_int;
pub type __darwin_clock_t = ::std::os::raw::c_ulong;
pub type __darwin_socklen_t = __uint32_t;
pub type __darwin_ssize_t = ::std::os::raw::c_long;
pub type __darwin_time_t = ::std::os::raw::c_long;
pub type __darwin_blkcnt_t = __int64_t;
pub type __darwin_blksize_t = __int32_t;
pub type __darwin_dev_t = __int32_t;
pub type __darwin_fsblkcnt_t = ::std::os::raw::c_uint;
pub type __darwin_fsfilcnt_t = ::std::os::raw::c_uint;
pub type __darwin_gid_t = __uint32_t;
pub type __darwin_id_t = __uint32_t;
pub type __darwin_ino64_t = __uint64_t;
pub type __darwin_ino_t = __darwin_ino64_t;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type __darwin_mode_t = __uint16_t;
pub type __darwin_off_t = __int64_t;
pub type __darwin_pid_t = __int32_t;
pub type __darwin_sigset_t = __uint32_t;
pub type __darwin_suseconds_t = __int32_t;
pub type __darwin_uid_t = __uint32_t;
pub type __darwin_useconds_t = __uint32_t;
pub type __darwin_uuid_t = [::std::os::raw::c_uchar; 16usize];
pub type __darwin_uuid_string_t = [::std::os::raw::c_char; 37usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_pthread_handler_rec {
    pub __routine: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __arg: *mut ::std::os::raw::c_void,
    pub __next: *mut __darwin_pthread_handler_rec,
}
#[test]
fn bindgen_test_layout___darwin_pthread_handler_rec() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_pthread_handler_rec> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_pthread_handler_rec>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_pthread_handler_rec>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__routine) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__routine)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__arg) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__arg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__next) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__next)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_attr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_attr_t() {
    const UNINIT: ::std::mem::MaybeUninit<_opaque_pthread_attr_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_attr_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_cond_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 40usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_cond_t() {
    const UNINIT: ::std::mem::MaybeUninit<_opaque_pthread_cond_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_condattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_condattr_t() {
    const UNINIT: ::std::mem::MaybeUninit<_opaque_pthread_condattr_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_condattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_condattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutex_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutex_t() {
    const UNINIT: ::std::mem::MaybeUninit<_opaque_pthread_mutex_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutex_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutexattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutexattr_t() {
    const UNINIT: ::std::mem::MaybeUninit<_opaque_pthread_mutexattr_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutexattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutexattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_once_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_once_t() {
    const UNINIT: ::std::mem::MaybeUninit<_opaque_pthread_once_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_once_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_once_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlock_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 192usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlock_t() {
    const UNINIT: ::std::mem::MaybeUninit<_opaque_pthread_rwlock_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlock_t>(),
        200usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlockattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlockattr_t() {
    const UNINIT: ::std::mem::MaybeUninit<_opaque_pthread_rwlockattr_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlockattr_t>(),
        24usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_t {
    pub __sig: ::std::os::raw::c_long,
    pub __cleanup_stack: *mut __darwin_pthread_handler_rec,
    pub __opaque: [::std::os::raw::c_char; 8176usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_t() {
    const UNINIT: ::std::mem::MaybeUninit<_opaque_pthread_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_t>(),
        8192usize,
        concat!("Size of: ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__cleanup_stack) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__cleanup_stack)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__opaque)
        )
    );
}
pub type __darwin_pthread_attr_t = _opaque_pthread_attr_t;
pub type __darwin_pthread_cond_t = _opaque_pthread_cond_t;
pub type __darwin_pthread_condattr_t = _opaque_pthread_condattr_t;
pub type __darwin_pthread_key_t = ::std::os::raw::c_ulong;
pub type __darwin_pthread_mutex_t = _opaque_pthread_mutex_t;
pub type __darwin_pthread_mutexattr_t = _opaque_pthread_mutexattr_t;
pub type __darwin_pthread_once_t = _opaque_pthread_once_t;
pub type __darwin_pthread_rwlock_t = _opaque_pthread_rwlock_t;
pub type __darwin_pthread_rwlockattr_t = _opaque_pthread_rwlockattr_t;
pub type __darwin_pthread_t = *mut _opaque_pthread_t;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulonglong;
pub type register_t = i64;
pub type user_addr_t = u_int64_t;
pub type user_size_t = u_int64_t;
pub type user_ssize_t = i64;
pub type user_long_t = i64;
pub type user_ulong_t = u_int64_t;
pub type user_time_t = i64;
pub type user_off_t = i64;
pub type syscall_arg_t = u_int64_t;
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_quad_t = u_int64_t;
pub type quad_t = i64;
pub type qaddr_t = *mut quad_t;
pub type caddr_t = *mut ::std::os::raw::c_char;
pub type daddr_t = i32;
pub type dev_t = __darwin_dev_t;
pub type fixpt_t = u_int32_t;
pub type blkcnt_t = __darwin_blkcnt_t;
pub type blksize_t = __darwin_blksize_t;
pub type gid_t = __darwin_gid_t;
pub type in_addr_t = __uint32_t;
pub type in_port_t = __uint16_t;
pub type ino_t = __darwin_ino_t;
pub type ino64_t = __darwin_ino64_t;
pub type key_t = __int32_t;
pub type mode_t = __darwin_mode_t;
pub type nlink_t = __uint16_t;
pub type id_t = __darwin_id_t;
pub type pid_t = __darwin_pid_t;
pub type off_t = __darwin_off_t;
pub type segsz_t = i32;
pub type swblk_t = i32;
pub type uid_t = __darwin_uid_t;
pub type clock_t = __darwin_clock_t;
pub type time_t = __darwin_time_t;
pub type useconds_t = __darwin_useconds_t;
pub type suseconds_t = __darwin_suseconds_t;
pub type rsize_t = __darwin_size_t;
pub type errno_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub fds_bits: [__int32_t; 32usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    const UNINIT: ::std::mem::MaybeUninit<fd_set> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        4usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fds_bits) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(fd_set), "::", stringify!(fds_bits))
    );
}
extern "C" {
    pub fn __darwin_check_fd_set_overflow(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type fd_mask = __int32_t;
pub type pthread_attr_t = __darwin_pthread_attr_t;
pub type pthread_cond_t = __darwin_pthread_cond_t;
pub type pthread_condattr_t = __darwin_pthread_condattr_t;
pub type pthread_mutex_t = __darwin_pthread_mutex_t;
pub type pthread_mutexattr_t = __darwin_pthread_mutexattr_t;
pub type pthread_once_t = __darwin_pthread_once_t;
pub type pthread_rwlock_t = __darwin_pthread_rwlock_t;
pub type pthread_rwlockattr_t = __darwin_pthread_rwlockattr_t;
pub type pthread_t = __darwin_pthread_t;
pub type pthread_key_t = __darwin_pthread_key_t;
pub type fsblkcnt_t = __darwin_fsblkcnt_t;
pub type fsfilcnt_t = __darwin_fsfilcnt_t;
pub type sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_thread_state {
    pub __eax: ::std::os::raw::c_uint,
    pub __ebx: ::std::os::raw::c_uint,
    pub __ecx: ::std::os::raw::c_uint,
    pub __edx: ::std::os::raw::c_uint,
    pub __edi: ::std::os::raw::c_uint,
    pub __esi: ::std::os::raw::c_uint,
    pub __ebp: ::std::os::raw::c_uint,
    pub __esp: ::std::os::raw::c_uint,
    pub __ss: ::std::os::raw::c_uint,
    pub __eflags: ::std::os::raw::c_uint,
    pub __eip: ::std::os::raw::c_uint,
    pub __cs: ::std::os::raw::c_uint,
    pub __ds: ::std::os::raw::c_uint,
    pub __es: ::std::os::raw::c_uint,
    pub __fs: ::std::os::raw::c_uint,
    pub __gs: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_i386_thread_state() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_i386_thread_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_thread_state>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_thread_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__eax) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eax)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ebx) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ecx) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ecx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__edx) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__edi) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__esi) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ebp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__esp) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__eflags) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eflags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__eip) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__cs) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ds) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__es) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fs) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__gs) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_control {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout___darwin_fp_control() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_control>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_control))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_control>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_control))
    );
}
impl __darwin_fp_control {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __pc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u16) }
    }

    #[inline]
    pub fn set___pc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }

    #[inline]
    pub fn __rc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 2u8) as u16) }
    }

    #[inline]
    pub fn set___rc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 2u8, val as u64)
        }
    }

    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __pc: ::std::os::raw::c_ushort,
        __rc: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let __pc: u16 = unsafe { ::std::mem::transmute(__pc) };
            __pc as u64
        });
        __bindgen_bitfield_unit.set(10usize, 2u8, {
            let __rc: u16 = unsafe { ::std::mem::transmute(__rc) };
            __rc as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_control_t = __darwin_fp_control;
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_status {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout___darwin_fp_status() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_status>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_status))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_status>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_status))
    );
}
impl __darwin_fp_status {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __stkflt(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___stkflt(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __errsumm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___errsumm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __c0(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___c0(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __c1(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___c1(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __c2(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___c2(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __tos(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 3u8) as u16) }
    }

    #[inline]
    pub fn set___tos(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 3u8, val as u64)
        }
    }

    #[inline]
    pub fn __c3(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___c3(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __busy(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set___busy(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __stkflt: ::std::os::raw::c_ushort,
        __errsumm: ::std::os::raw::c_ushort,
        __c0: ::std::os::raw::c_ushort,
        __c1: ::std::os::raw::c_ushort,
        __c2: ::std::os::raw::c_ushort,
        __tos: ::std::os::raw::c_ushort,
        __c3: ::std::os::raw::c_ushort,
        __busy: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let __stkflt: u16 = unsafe { ::std::mem::transmute(__stkflt) };
            __stkflt as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __errsumm: u16 = unsafe { ::std::mem::transmute(__errsumm) };
            __errsumm as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let __c0: u16 = unsafe { ::std::mem::transmute(__c0) };
            __c0 as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let __c1: u16 = unsafe { ::std::mem::transmute(__c1) };
            __c1 as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let __c2: u16 = unsafe { ::std::mem::transmute(__c2) };
            __c2 as u64
        });
        __bindgen_bitfield_unit.set(11usize, 3u8, {
            let __tos: u16 = unsafe { ::std::mem::transmute(__tos) };
            __tos as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let __c3: u16 = unsafe { ::std::mem::transmute(__c3) };
            __c3 as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let __busy: u16 = unsafe { ::std::mem::transmute(__busy) };
            __busy as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_status_t = __darwin_fp_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mmst_reg {
    pub __mmst_reg: [::std::os::raw::c_char; 10usize],
    pub __mmst_rsrv: [::std::os::raw::c_char; 6usize],
}
#[test]
fn bindgen_test_layout___darwin_mmst_reg() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_mmst_reg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_mmst_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mmst_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__mmst_reg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_reg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__mmst_rsrv) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_rsrv)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_xmm_reg {
    pub __xmm_reg: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_xmm_reg() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_xmm_reg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_xmm_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_xmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__xmm_reg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_xmm_reg),
            "::",
            stringify!(__xmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ymm_reg {
    pub __ymm_reg: [::std::os::raw::c_char; 32usize],
}
#[test]
fn bindgen_test_layout___darwin_ymm_reg() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_ymm_reg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_ymm_reg>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ymm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ymm_reg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ymm_reg),
            "::",
            stringify!(__ymm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_zmm_reg {
    pub __zmm_reg: [::std::os::raw::c_char; 64usize],
}
#[test]
fn bindgen_test_layout___darwin_zmm_reg() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_zmm_reg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_zmm_reg>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_zmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__zmm_reg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_zmm_reg),
            "::",
            stringify!(__zmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_opmask_reg {
    pub __opmask_reg: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout___darwin_opmask_reg() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_opmask_reg> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_opmask_reg>(),
        8usize,
        concat!("Size of: ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_opmask_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__opmask_reg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_opmask_reg),
            "::",
            stringify!(__opmask_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_float_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_i386_float_state() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_i386_float_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_float_state>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_float_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_reserved) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fcw) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fsw) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ftw) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv1) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fop) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ip) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_cs) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv2) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_dp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ds) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv3) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_mxcsr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_mxcsrmask) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm0) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm1) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm2) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm3) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm4) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm5) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm6) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm7) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm0) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm1) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm2) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm3) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm4) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm5) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm6) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm7) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv4) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_reserved1) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx_state() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_i386_avx_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx_state>(),
        716usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_reserved) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fcw) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fsw) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ftw) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv1) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fop) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ip) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_cs) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv2) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_dp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ds) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv3) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_mxcsr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_mxcsrmask) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm0) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm1) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm2) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm3) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm4) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm5) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm6) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm7) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm0) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm1) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm2) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm3) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm4) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm5) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm6) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm7) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv4) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_reserved1) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__avx_reserved1) as usize - ptr as usize },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh0) as usize - ptr as usize },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh1) as usize - ptr as usize },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh2) as usize - ptr as usize },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh3) as usize - ptr as usize },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh4) as usize - ptr as usize },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh5) as usize - ptr as usize },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh6) as usize - ptr as usize },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh7) as usize - ptr as usize },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx512_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx512_state() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_i386_avx512_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx512_state>(),
        1036usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx512_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_reserved) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fcw) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fsw) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ftw) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv1) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fop) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ip) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_cs) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv2) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_dp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ds) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv3) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_mxcsr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_mxcsrmask) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm0) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm1) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm2) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm3) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm4) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm5) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm6) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm7) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm0) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm1) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm2) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm3) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm4) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm5) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm6) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm7) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv4) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_reserved1) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__avx_reserved1) as usize - ptr as usize },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh0) as usize - ptr as usize },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh1) as usize - ptr as usize },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh2) as usize - ptr as usize },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh3) as usize - ptr as usize },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh4) as usize - ptr as usize },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh5) as usize - ptr as usize },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh6) as usize - ptr as usize },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh7) as usize - ptr as usize },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k0) as usize - ptr as usize },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k1) as usize - ptr as usize },
        724usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k2) as usize - ptr as usize },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k3) as usize - ptr as usize },
        740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k4) as usize - ptr as usize },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k5) as usize - ptr as usize },
        756usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k6) as usize - ptr as usize },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k7) as usize - ptr as usize },
        772usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh0) as usize - ptr as usize },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh1) as usize - ptr as usize },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh2) as usize - ptr as usize },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh3) as usize - ptr as usize },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh4) as usize - ptr as usize },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh5) as usize - ptr as usize },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh6) as usize - ptr as usize },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh7) as usize - ptr as usize },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_exception_state {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_i386_exception_state() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_i386_exception_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_exception_state>(),
        12usize,
        concat!("Size of: ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_exception_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__trapno) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__cpu) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__err) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__faultvaddr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state32 {
    pub __dr0: ::std::os::raw::c_uint,
    pub __dr1: ::std::os::raw::c_uint,
    pub __dr2: ::std::os::raw::c_uint,
    pub __dr3: ::std::os::raw::c_uint,
    pub __dr4: ::std::os::raw::c_uint,
    pub __dr5: ::std::os::raw::c_uint,
    pub __dr6: ::std::os::raw::c_uint,
    pub __dr7: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state32() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_x86_debug_state32> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state32>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr0) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr1) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr2) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr3) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr4) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr5) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr6) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr7) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __x86_instruction_state {
    pub __insn_stream_valid_bytes: ::std::os::raw::c_int,
    pub __insn_offset: ::std::os::raw::c_int,
    pub __out_of_synch: ::std::os::raw::c_int,
    pub __insn_bytes: [__uint8_t; 2380usize],
    pub __insn_cacheline: [__uint8_t; 64usize],
}
#[test]
fn bindgen_test_layout___x86_instruction_state() {
    const UNINIT: ::std::mem::MaybeUninit<__x86_instruction_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__x86_instruction_state>(),
        2456usize,
        concat!("Size of: ", stringify!(__x86_instruction_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__x86_instruction_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__x86_instruction_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__insn_stream_valid_bytes) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_stream_valid_bytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__insn_offset) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__out_of_synch) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__out_of_synch)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__insn_bytes) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_bytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__insn_cacheline) as usize - ptr as usize },
        2392usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_cacheline)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __last_branch_record {
    pub __from_ip: __uint64_t,
    pub __to_ip: __uint64_t,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __bindgen_padding_0: u32,
}
#[test]
fn bindgen_test_layout___last_branch_record() {
    const UNINIT: ::std::mem::MaybeUninit<__last_branch_record> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__last_branch_record>(),
        24usize,
        concat!("Size of: ", stringify!(__last_branch_record))
    );
    assert_eq!(
        ::std::mem::align_of::<__last_branch_record>(),
        8usize,
        concat!("Alignment of ", stringify!(__last_branch_record))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__from_ip) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_record),
            "::",
            stringify!(__from_ip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__to_ip) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_record),
            "::",
            stringify!(__to_ip)
        )
    );
}
impl __last_branch_record {
    #[inline]
    pub fn __mispredict(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }

    #[inline]
    pub fn set___mispredict(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __tsx_abort(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }

    #[inline]
    pub fn set___tsx_abort(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __in_tsx(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }

    #[inline]
    pub fn set___in_tsx(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __cycle_count(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 16u8) as u32) }
    }

    #[inline]
    pub fn set___cycle_count(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 16u8, val as u64)
        }
    }

    #[inline]
    pub fn __reserved(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 13u8) as u32) }
    }

    #[inline]
    pub fn set___reserved(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 13u8, val as u64)
        }
    }

    #[inline]
    pub fn new_bitfield_1(
        __mispredict: __uint32_t,
        __tsx_abort: __uint32_t,
        __in_tsx: __uint32_t,
        __cycle_count: __uint32_t,
        __reserved: __uint32_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __mispredict: u32 = unsafe { ::std::mem::transmute(__mispredict) };
            __mispredict as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __tsx_abort: u32 = unsafe { ::std::mem::transmute(__tsx_abort) };
            __tsx_abort as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __in_tsx: u32 = unsafe { ::std::mem::transmute(__in_tsx) };
            __in_tsx as u64
        });
        __bindgen_bitfield_unit.set(3usize, 16u8, {
            let __cycle_count: u32 = unsafe { ::std::mem::transmute(__cycle_count) };
            __cycle_count as u64
        });
        __bindgen_bitfield_unit.set(19usize, 13u8, {
            let __reserved: u32 = unsafe { ::std::mem::transmute(__reserved) };
            __reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __last_branch_state {
    pub __lbr_count: ::std::os::raw::c_int,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __lbrs: [__last_branch_record; 32usize],
}
#[test]
fn bindgen_test_layout___last_branch_state() {
    const UNINIT: ::std::mem::MaybeUninit<__last_branch_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__last_branch_state>(),
        776usize,
        concat!("Size of: ", stringify!(__last_branch_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__last_branch_state>(),
        8usize,
        concat!("Alignment of ", stringify!(__last_branch_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__lbr_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_state),
            "::",
            stringify!(__lbr_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__lbrs) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_state),
            "::",
            stringify!(__lbrs)
        )
    );
}
impl __last_branch_state {
    #[inline]
    pub fn __lbr_supported_tsx(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }

    #[inline]
    pub fn set___lbr_supported_tsx(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __lbr_supported_cycle_count(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }

    #[inline]
    pub fn set___lbr_supported_cycle_count(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn __reserved(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }

    #[inline]
    pub fn set___reserved(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }

    #[inline]
    pub fn new_bitfield_1(
        __lbr_supported_tsx: __uint32_t,
        __lbr_supported_cycle_count: __uint32_t,
        __reserved: __uint32_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __lbr_supported_tsx: u32 = unsafe { ::std::mem::transmute(__lbr_supported_tsx) };
            __lbr_supported_tsx as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __lbr_supported_cycle_count: u32 = unsafe { ::std::mem::transmute(__lbr_supported_cycle_count) };
            __lbr_supported_cycle_count as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let __reserved: u32 = unsafe { ::std::mem::transmute(__reserved) };
            __reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __x86_pagein_state {
    pub __pagein_error: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___x86_pagein_state() {
    const UNINIT: ::std::mem::MaybeUninit<__x86_pagein_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__x86_pagein_state>(),
        4usize,
        concat!("Size of: ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__x86_pagein_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__pagein_error) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_pagein_state),
            "::",
            stringify!(__pagein_error)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_state64 {
    pub __rax: __uint64_t,
    pub __rbx: __uint64_t,
    pub __rcx: __uint64_t,
    pub __rdx: __uint64_t,
    pub __rdi: __uint64_t,
    pub __rsi: __uint64_t,
    pub __rbp: __uint64_t,
    pub __rsp: __uint64_t,
    pub __r8: __uint64_t,
    pub __r9: __uint64_t,
    pub __r10: __uint64_t,
    pub __r11: __uint64_t,
    pub __r12: __uint64_t,
    pub __r13: __uint64_t,
    pub __r14: __uint64_t,
    pub __r15: __uint64_t,
    pub __rip: __uint64_t,
    pub __rflags: __uint64_t,
    pub __cs: __uint64_t,
    pub __fs: __uint64_t,
    pub __gs: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_state64() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_x86_thread_state64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_state64>(),
        168usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__rax) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rax)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__rbx) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__rcx) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rcx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__rdx) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__rdi) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__rsi) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__rbp) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__rsp) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__r8) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__r9) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r9)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__r10) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r10)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__r11) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r11)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__r12) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r12)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__r13) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r13)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__r14) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r14)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__r15) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r15)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__rip) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__rflags) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rflags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__cs) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fs) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__gs) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_full_state64 {
    pub __ss64: __darwin_x86_thread_state64,
    pub __ds: __uint64_t,
    pub __es: __uint64_t,
    pub __ss: __uint64_t,
    pub __gsbase: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_full_state64() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_x86_thread_full_state64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_full_state64>(),
        200usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_full_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_full_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_thread_full_state64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss64) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss64)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ds) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__es) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__gsbase) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__gsbase)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_float_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_x86_float_state64() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_x86_float_state64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_float_state64>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_float_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_reserved) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fcw) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fsw) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ftw) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv1) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fop) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ip) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_cs) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv2) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_dp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ds) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv3) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_mxcsr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_mxcsrmask) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm0) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm1) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm2) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm3) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm4) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm5) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm6) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm7) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm0) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm1) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm2) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm3) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm4) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm5) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm6) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm7) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm8) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm9) as usize - ptr as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm10) as usize - ptr as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm11) as usize - ptr as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm12) as usize - ptr as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm13) as usize - ptr as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm14) as usize - ptr as usize },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm15) as usize - ptr as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv4) as usize - ptr as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_reserved1) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx_state64() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_x86_avx_state64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx_state64>(),
        844usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_reserved) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fcw) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fsw) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ftw) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv1) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fop) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ip) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_cs) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv2) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_dp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ds) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv3) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_mxcsr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_mxcsrmask) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm0) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm1) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm2) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm3) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm4) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm5) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm6) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm7) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm0) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm1) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm2) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm3) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm4) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm5) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm6) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm7) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm8) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm9) as usize - ptr as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm10) as usize - ptr as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm11) as usize - ptr as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm12) as usize - ptr as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm13) as usize - ptr as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm14) as usize - ptr as usize },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm15) as usize - ptr as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv4) as usize - ptr as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_reserved1) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__avx_reserved1) as usize - ptr as usize },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh0) as usize - ptr as usize },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh1) as usize - ptr as usize },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh2) as usize - ptr as usize },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh3) as usize - ptr as usize },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh4) as usize - ptr as usize },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh5) as usize - ptr as usize },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh6) as usize - ptr as usize },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh7) as usize - ptr as usize },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh8) as usize - ptr as usize },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh9) as usize - ptr as usize },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh10) as usize - ptr as usize },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh11) as usize - ptr as usize },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh12) as usize - ptr as usize },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh13) as usize - ptr as usize },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh14) as usize - ptr as usize },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh15) as usize - ptr as usize },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx512_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
    pub __fpu_zmmh8: __darwin_ymm_reg,
    pub __fpu_zmmh9: __darwin_ymm_reg,
    pub __fpu_zmmh10: __darwin_ymm_reg,
    pub __fpu_zmmh11: __darwin_ymm_reg,
    pub __fpu_zmmh12: __darwin_ymm_reg,
    pub __fpu_zmmh13: __darwin_ymm_reg,
    pub __fpu_zmmh14: __darwin_ymm_reg,
    pub __fpu_zmmh15: __darwin_ymm_reg,
    pub __fpu_zmm16: __darwin_zmm_reg,
    pub __fpu_zmm17: __darwin_zmm_reg,
    pub __fpu_zmm18: __darwin_zmm_reg,
    pub __fpu_zmm19: __darwin_zmm_reg,
    pub __fpu_zmm20: __darwin_zmm_reg,
    pub __fpu_zmm21: __darwin_zmm_reg,
    pub __fpu_zmm22: __darwin_zmm_reg,
    pub __fpu_zmm23: __darwin_zmm_reg,
    pub __fpu_zmm24: __darwin_zmm_reg,
    pub __fpu_zmm25: __darwin_zmm_reg,
    pub __fpu_zmm26: __darwin_zmm_reg,
    pub __fpu_zmm27: __darwin_zmm_reg,
    pub __fpu_zmm28: __darwin_zmm_reg,
    pub __fpu_zmm29: __darwin_zmm_reg,
    pub __fpu_zmm30: __darwin_zmm_reg,
    pub __fpu_zmm31: __darwin_zmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx512_state64() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_x86_avx512_state64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx512_state64>(),
        2444usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx512_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_reserved) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fcw) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fsw) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ftw) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv1) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_fop) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ip) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_cs) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv2) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_dp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ds) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv3) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_mxcsr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_mxcsrmask) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm0) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm1) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm2) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm3) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm4) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm5) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm6) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_stmm7) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm0) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm1) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm2) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm3) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm4) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm5) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm6) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm7) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm8) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm9) as usize - ptr as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm10) as usize - ptr as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm11) as usize - ptr as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm12) as usize - ptr as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm13) as usize - ptr as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm14) as usize - ptr as usize },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_xmm15) as usize - ptr as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_rsrv4) as usize - ptr as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_reserved1) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__avx_reserved1) as usize - ptr as usize },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh0) as usize - ptr as usize },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh1) as usize - ptr as usize },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh2) as usize - ptr as usize },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh3) as usize - ptr as usize },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh4) as usize - ptr as usize },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh5) as usize - ptr as usize },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh6) as usize - ptr as usize },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh7) as usize - ptr as usize },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh8) as usize - ptr as usize },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh9) as usize - ptr as usize },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh10) as usize - ptr as usize },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh11) as usize - ptr as usize },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh12) as usize - ptr as usize },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh13) as usize - ptr as usize },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh14) as usize - ptr as usize },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_ymmh15) as usize - ptr as usize },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k0) as usize - ptr as usize },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k1) as usize - ptr as usize },
        852usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k2) as usize - ptr as usize },
        860usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k3) as usize - ptr as usize },
        868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k4) as usize - ptr as usize },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k5) as usize - ptr as usize },
        884usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k6) as usize - ptr as usize },
        892usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_k7) as usize - ptr as usize },
        900usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh0) as usize - ptr as usize },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh1) as usize - ptr as usize },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh2) as usize - ptr as usize },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh3) as usize - ptr as usize },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh4) as usize - ptr as usize },
        1036usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh5) as usize - ptr as usize },
        1068usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh6) as usize - ptr as usize },
        1100usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh7) as usize - ptr as usize },
        1132usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh8) as usize - ptr as usize },
        1164usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh9) as usize - ptr as usize },
        1196usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh9)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh10) as usize - ptr as usize },
        1228usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh10)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh11) as usize - ptr as usize },
        1260usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh11)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh12) as usize - ptr as usize },
        1292usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh12)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh13) as usize - ptr as usize },
        1324usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh13)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh14) as usize - ptr as usize },
        1356usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh14)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmmh15) as usize - ptr as usize },
        1388usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh15)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm16) as usize - ptr as usize },
        1420usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm17) as usize - ptr as usize },
        1484usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm17)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm18) as usize - ptr as usize },
        1548usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm18)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm19) as usize - ptr as usize },
        1612usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm19)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm20) as usize - ptr as usize },
        1676usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm20)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm21) as usize - ptr as usize },
        1740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm21)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm22) as usize - ptr as usize },
        1804usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm22)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm23) as usize - ptr as usize },
        1868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm23)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm24) as usize - ptr as usize },
        1932usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm24)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm25) as usize - ptr as usize },
        1996usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm25)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm26) as usize - ptr as usize },
        2060usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm26)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm27) as usize - ptr as usize },
        2124usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm27)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm28) as usize - ptr as usize },
        2188usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm28)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm29) as usize - ptr as usize },
        2252usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm29)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm30) as usize - ptr as usize },
        2316usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm30)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fpu_zmm31) as usize - ptr as usize },
        2380usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm31)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_exception_state64 {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_exception_state64() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_x86_exception_state64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_exception_state64>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_exception_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__trapno) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__cpu) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__err) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__faultvaddr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state64 {
    pub __dr0: __uint64_t,
    pub __dr1: __uint64_t,
    pub __dr2: __uint64_t,
    pub __dr3: __uint64_t,
    pub __dr4: __uint64_t,
    pub __dr5: __uint64_t,
    pub __dr6: __uint64_t,
    pub __dr7: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state64() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_x86_debug_state64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state64>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr0) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr1) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr2) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr3) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr4) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr5) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr6) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__dr7) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_cpmu_state64 {
    pub __ctrs: [__uint64_t; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_x86_cpmu_state64() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_x86_cpmu_state64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_cpmu_state64>(),
        128usize,
        concat!("Size of: ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_cpmu_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ctrs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_cpmu_state64),
            "::",
            stringify!(__ctrs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_float_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext32() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_mcontext32> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext32>(),
        600usize,
        concat!("Size of: ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__es) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fs) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx32() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_mcontext_avx32> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx32>(),
        792usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__es) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fs) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx512_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_32() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_mcontext_avx512_32> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_32>(),
        1112usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__es) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fs) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_mcontext64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64>(),
        712usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__es) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fs) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64_full() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_mcontext64_full> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64_full>(),
        744usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__es) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fs) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_mcontext_avx64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64>(),
        1032usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__es) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fs) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64_full() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_mcontext_avx64_full> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64_full>(),
        1064usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__es) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fs) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_mcontext_avx512_64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64>(),
        2632usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__es) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fs) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__fs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64_full() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_mcontext_avx512_64_full> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64_full>(),
        2664usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_64_full))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__es) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__fs) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__fs)
        )
    );
}
pub type mcontext_t = *mut __darwin_mcontext64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: __darwin_size_t,
    pub ss_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_sigaltstack() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_sigaltstack> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_sigaltstack>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_sigaltstack>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ss_sp) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ss_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ss_flags) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_flags)
        )
    );
}
pub type stack_t = __darwin_sigaltstack;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ucontext {
    pub uc_onstack: ::std::os::raw::c_int,
    pub uc_sigmask: __darwin_sigset_t,
    pub uc_stack: __darwin_sigaltstack,
    pub uc_link: *mut __darwin_ucontext,
    pub uc_mcsize: __darwin_size_t,
    pub uc_mcontext: *mut __darwin_mcontext64,
}
#[test]
fn bindgen_test_layout___darwin_ucontext() {
    const UNINIT: ::std::mem::MaybeUninit<__darwin_ucontext> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__darwin_ucontext>(),
        56usize,
        concat!("Size of: ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ucontext>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uc_onstack) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_onstack)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uc_sigmask) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_sigmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uc_stack) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_stack)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uc_link) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_link)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uc_mcsize) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcsize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uc_mcontext) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcontext)
        )
    );
}
pub type ucontext_t = __darwin_ucontext;
pub type sigset_t = __darwin_sigset_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_sigval() {
    const UNINIT: ::std::mem::MaybeUninit<sigval> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigval>(),
        8usize,
        concat!("Size of: ", stringify!(sigval))
    );
    assert_eq!(
        ::std::mem::align_of::<sigval>(),
        8usize,
        concat!("Alignment of ", stringify!(sigval))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sival_int) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sigval), "::", stringify!(sival_int))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sival_ptr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sigval), "::", stringify!(sival_ptr))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_notify: ::std::os::raw::c_int,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_value: sigval,
    pub sigev_notify_function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval)>,
    pub sigev_notify_attributes: *mut pthread_attr_t,
}
#[test]
fn bindgen_test_layout_sigevent() {
    const UNINIT: ::std::mem::MaybeUninit<sigevent> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigevent>(),
        32usize,
        concat!("Size of: ", stringify!(sigevent))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent>(),
        8usize,
        concat!("Alignment of ", stringify!(sigevent))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sigev_notify) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sigev_signo) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(sigevent), "::", stringify!(sigev_signo))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sigev_value) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(sigevent), "::", stringify!(sigev_value))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sigev_notify_function) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_function)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sigev_notify_attributes) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_attributes)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __siginfo {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub si_pid: pid_t,
    pub si_uid: uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_value: sigval,
    pub si_band: ::std::os::raw::c_long,
    pub __pad: [::std::os::raw::c_ulong; 7usize],
}
#[test]
fn bindgen_test_layout___siginfo() {
    const UNINIT: ::std::mem::MaybeUninit<__siginfo> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__siginfo>(),
        104usize,
        concat!("Size of: ", stringify!(__siginfo))
    );
    assert_eq!(
        ::std::mem::align_of::<__siginfo>(),
        8usize,
        concat!("Alignment of ", stringify!(__siginfo))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).si_signo) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(__siginfo), "::", stringify!(si_signo))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).si_errno) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(__siginfo), "::", stringify!(si_errno))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).si_code) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(__siginfo), "::", stringify!(si_code))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).si_pid) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(__siginfo), "::", stringify!(si_pid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).si_uid) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(__siginfo), "::", stringify!(si_uid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).si_status) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(__siginfo), "::", stringify!(si_status))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).si_addr) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(__siginfo), "::", stringify!(si_addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).si_value) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(__siginfo), "::", stringify!(si_value))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).si_band) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(__siginfo), "::", stringify!(si_band))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__pad) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(__siginfo), "::", stringify!(__pad))
    );
}
pub type siginfo_t = __siginfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sigaction_u {
    pub __sa_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub __sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(arg1: ::std::os::raw::c_int, arg2: *mut __siginfo, arg3: *mut ::std::os::raw::c_void),
    >,
}
#[test]
fn bindgen_test_layout___sigaction_u() {
    const UNINIT: ::std::mem::MaybeUninit<__sigaction_u> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sigaction_u>(),
        8usize,
        concat!("Size of: ", stringify!(__sigaction_u))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction_u>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction_u))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__sa_handler) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_handler)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__sa_sigaction) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_sigaction)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_tramp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
            arg4: *mut siginfo_t,
            arg5: *mut ::std::os::raw::c_void,
        ),
    >,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sigaction() {
    const UNINIT: ::std::mem::MaybeUninit<__sigaction> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__sigaction>(),
        24usize,
        concat!("Size of: ", stringify!(__sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__sigaction_u) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_tramp) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(__sigaction), "::", stringify!(sa_tramp))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_mask) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(__sigaction), "::", stringify!(sa_mask))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_flags) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(__sigaction), "::", stringify!(sa_flags))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigaction() {
    const UNINIT: ::std::mem::MaybeUninit<sigaction> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigaction>(),
        16usize,
        concat!("Size of: ", stringify!(sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__sigaction_u) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_mask) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(sigaction), "::", stringify!(sa_mask))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_flags) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(sigaction), "::", stringify!(sa_flags))
    );
}
pub type sig_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigvec {
    pub sv_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub sv_mask: ::std::os::raw::c_int,
    pub sv_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigvec() {
    const UNINIT: ::std::mem::MaybeUninit<sigvec> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigvec>(),
        16usize,
        concat!("Size of: ", stringify!(sigvec))
    );
    assert_eq!(
        ::std::mem::align_of::<sigvec>(),
        8usize,
        concat!("Alignment of ", stringify!(sigvec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sv_handler) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sigvec), "::", stringify!(sv_handler))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sv_mask) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(sigvec), "::", stringify!(sv_mask))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sv_flags) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(sigvec), "::", stringify!(sv_flags))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_char,
    pub ss_onstack: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigstack() {
    const UNINIT: ::std::mem::MaybeUninit<sigstack> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sigstack>(),
        16usize,
        concat!("Size of: ", stringify!(sigstack))
    );
    assert_eq!(
        ::std::mem::align_of::<sigstack>(),
        8usize,
        concat!("Alignment of ", stringify!(sigstack))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ss_sp) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sigstack), "::", stringify!(ss_sp))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ss_onstack) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(sigstack), "::", stringify!(ss_onstack))
    );
}
extern "C" {
    pub fn signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct radix_node {
    pub rn_mklist: *mut radix_mask,
    pub rn_parent: *mut radix_node,
    pub rn_bit: ::std::os::raw::c_short,
    pub rn_bmask: ::std::os::raw::c_char,
    pub rn_flags: u_char,
    pub rn_u: radix_node__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union radix_node__bindgen_ty_1 {
    pub rn_leaf: radix_node__bindgen_ty_1__bindgen_ty_1,
    pub rn_node: radix_node__bindgen_ty_1__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct radix_node__bindgen_ty_1__bindgen_ty_1 {
    pub rn_Key: caddr_t,
    pub rn_Mask: caddr_t,
    pub rn_Dupedkey: *mut radix_node,
}
#[test]
fn bindgen_test_layout_radix_node__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<radix_node__bindgen_ty_1__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<radix_node__bindgen_ty_1__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(radix_node__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<radix_node__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(radix_node__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_Key) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(rn_Key)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_Mask) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(rn_Mask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_Dupedkey) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(rn_Dupedkey)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct radix_node__bindgen_ty_1__bindgen_ty_2 {
    pub rn_Off: ::std::os::raw::c_int,
    pub rn_L: *mut radix_node,
    pub rn_R: *mut radix_node,
}
#[test]
fn bindgen_test_layout_radix_node__bindgen_ty_1__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<radix_node__bindgen_ty_1__bindgen_ty_2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<radix_node__bindgen_ty_1__bindgen_ty_2>(),
        24usize,
        concat!("Size of: ", stringify!(radix_node__bindgen_ty_1__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<radix_node__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(radix_node__bindgen_ty_1__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_Off) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(rn_Off)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_L) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(rn_L)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_R) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(rn_R)
        )
    );
}
#[test]
fn bindgen_test_layout_radix_node__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<radix_node__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<radix_node__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(radix_node__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<radix_node__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(radix_node__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_leaf) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node__bindgen_ty_1),
            "::",
            stringify!(rn_leaf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_node) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node__bindgen_ty_1),
            "::",
            stringify!(rn_node)
        )
    );
}
#[test]
fn bindgen_test_layout_radix_node() {
    const UNINIT: ::std::mem::MaybeUninit<radix_node> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<radix_node>(),
        48usize,
        concat!("Size of: ", stringify!(radix_node))
    );
    assert_eq!(
        ::std::mem::align_of::<radix_node>(),
        8usize,
        concat!("Alignment of ", stringify!(radix_node))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_mklist) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(radix_node), "::", stringify!(rn_mklist))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_parent) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(radix_node), "::", stringify!(rn_parent))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_bit) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(radix_node), "::", stringify!(rn_bit))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_bmask) as usize - ptr as usize },
        18usize,
        concat!("Offset of field: ", stringify!(radix_node), "::", stringify!(rn_bmask))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_flags) as usize - ptr as usize },
        19usize,
        concat!("Offset of field: ", stringify!(radix_node), "::", stringify!(rn_flags))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rn_u) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(radix_node), "::", stringify!(rn_u))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct radix_mask {
    pub rm_bit: ::std::os::raw::c_short,
    pub rm_unused: ::std::os::raw::c_char,
    pub rm_flags: u_char,
    pub rm_mklist: *mut radix_mask,
    pub rm_rmu: radix_mask__bindgen_ty_1,
    pub rm_refs: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union radix_mask__bindgen_ty_1 {
    pub rmu_mask: caddr_t,
    pub rmu_leaf: *mut radix_node,
}
#[test]
fn bindgen_test_layout_radix_mask__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<radix_mask__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<radix_mask__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(radix_mask__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<radix_mask__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(radix_mask__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmu_mask) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_mask__bindgen_ty_1),
            "::",
            stringify!(rmu_mask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmu_leaf) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_mask__bindgen_ty_1),
            "::",
            stringify!(rmu_leaf)
        )
    );
}
#[test]
fn bindgen_test_layout_radix_mask() {
    const UNINIT: ::std::mem::MaybeUninit<radix_mask> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<radix_mask>(),
        32usize,
        concat!("Size of: ", stringify!(radix_mask))
    );
    assert_eq!(
        ::std::mem::align_of::<radix_mask>(),
        8usize,
        concat!("Alignment of ", stringify!(radix_mask))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rm_bit) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(radix_mask), "::", stringify!(rm_bit))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rm_unused) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(radix_mask), "::", stringify!(rm_unused))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rm_flags) as usize - ptr as usize },
        3usize,
        concat!("Offset of field: ", stringify!(radix_mask), "::", stringify!(rm_flags))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rm_mklist) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(radix_mask), "::", stringify!(rm_mklist))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rm_rmu) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(radix_mask), "::", stringify!(rm_rmu))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rm_refs) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(radix_mask), "::", stringify!(rm_refs))
    );
}
pub type walktree_f_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut radix_node, arg2: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
>;
pub type rn_matchf_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut radix_node, arg2: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct radix_node_head {
    pub rnh_treetop: *mut radix_node,
    pub rnh_addrsize: ::std::os::raw::c_int,
    pub rnh_pktsize: ::std::os::raw::c_int,
    pub rnh_addaddr: ::std::option::Option<
        unsafe extern "C" fn(
            v: *mut ::std::os::raw::c_void,
            mask: *mut ::std::os::raw::c_void,
            head: *mut radix_node_head,
            nodes: *mut radix_node,
        ) -> *mut radix_node,
    >,
    pub rnh_addpkt: ::std::option::Option<
        unsafe extern "C" fn(
            v: *mut ::std::os::raw::c_void,
            mask: *mut ::std::os::raw::c_void,
            head: *mut radix_node_head,
            nodes: *mut radix_node,
        ) -> *mut radix_node,
    >,
    pub rnh_deladdr: ::std::option::Option<
        unsafe extern "C" fn(
            v: *mut ::std::os::raw::c_void,
            mask: *mut ::std::os::raw::c_void,
            head: *mut radix_node_head,
        ) -> *mut radix_node,
    >,
    pub rnh_delpkt: ::std::option::Option<
        unsafe extern "C" fn(
            v: *mut ::std::os::raw::c_void,
            mask: *mut ::std::os::raw::c_void,
            head: *mut radix_node_head,
        ) -> *mut radix_node,
    >,
    pub rnh_matchaddr: ::std::option::Option<
        unsafe extern "C" fn(v: *mut ::std::os::raw::c_void, head: *mut radix_node_head) -> *mut radix_node,
    >,
    pub rnh_matchaddr_args: ::std::option::Option<
        unsafe extern "C" fn(
            v: *mut ::std::os::raw::c_void,
            head: *mut radix_node_head,
            f: rn_matchf_t,
            w: *mut ::std::os::raw::c_void,
        ) -> *mut radix_node,
    >,
    pub rnh_lookup: ::std::option::Option<
        unsafe extern "C" fn(
            v: *mut ::std::os::raw::c_void,
            mask: *mut ::std::os::raw::c_void,
            head: *mut radix_node_head,
        ) -> *mut radix_node,
    >,
    pub rnh_lookup_args: ::std::option::Option<
        unsafe extern "C" fn(
            v: *mut ::std::os::raw::c_void,
            mask: *mut ::std::os::raw::c_void,
            head: *mut radix_node_head,
            f: rn_matchf_t,
            arg1: *mut ::std::os::raw::c_void,
        ) -> *mut radix_node,
    >,
    pub rnh_matchpkt: ::std::option::Option<
        unsafe extern "C" fn(v: *mut ::std::os::raw::c_void, head: *mut radix_node_head) -> *mut radix_node,
    >,
    pub rnh_walktree: ::std::option::Option<
        unsafe extern "C" fn(
            head: *mut radix_node_head,
            f: walktree_f_t,
            w: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub rnh_walktree_from: ::std::option::Option<
        unsafe extern "C" fn(
            head: *mut radix_node_head,
            a: *mut ::std::os::raw::c_void,
            m: *mut ::std::os::raw::c_void,
            f: walktree_f_t,
            w: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub rnh_close: ::std::option::Option<unsafe extern "C" fn(rn: *mut radix_node, head: *mut radix_node_head)>,
    pub rnh_nodes: [radix_node; 3usize],
    pub rnh_cnt: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_radix_node_head() {
    const UNINIT: ::std::mem::MaybeUninit<radix_node_head> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<radix_node_head>(),
        264usize,
        concat!("Size of: ", stringify!(radix_node_head))
    );
    assert_eq!(
        ::std::mem::align_of::<radix_node_head>(),
        8usize,
        concat!("Alignment of ", stringify!(radix_node_head))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_treetop) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_treetop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_addrsize) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_addrsize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_pktsize) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_pktsize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_addaddr) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_addaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_addpkt) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_addpkt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_deladdr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_deladdr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_delpkt) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_delpkt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_matchaddr) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_matchaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_matchaddr_args) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_matchaddr_args)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_lookup) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_lookup)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_lookup_args) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_lookup_args)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_matchpkt) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_matchpkt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_walktree) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_walktree)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_walktree_from) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_walktree_from)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_close) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_close)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_nodes) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_nodes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rnh_cnt) as usize - ptr as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(radix_node_head),
            "::",
            stringify!(rnh_cnt)
        )
    );
}
extern "C" {
    pub fn rn_init();
}
extern "C" {
    pub fn rn_inithead(arg1: *mut *mut ::std::os::raw::c_void, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rn_refines(arg1: *mut ::std::os::raw::c_void, arg2: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rn_addmask(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> *mut radix_node;
}
extern "C" {
    pub fn rn_addroute(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut radix_node_head,
        arg4: *mut radix_node,
    ) -> *mut radix_node;
}
extern "C" {
    pub fn rn_delete(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
        arg3: *mut radix_node_head,
    ) -> *mut radix_node;
}
extern "C" {
    pub fn rn_lookup(
        v_arg: *mut ::std::os::raw::c_void,
        m_arg: *mut ::std::os::raw::c_void,
        head: *mut radix_node_head,
    ) -> *mut radix_node;
}
extern "C" {
    pub fn rn_lookup_args(
        v_arg: *mut ::std::os::raw::c_void,
        m_arg: *mut ::std::os::raw::c_void,
        head: *mut radix_node_head,
        arg1: rn_matchf_t,
        arg2: *mut ::std::os::raw::c_void,
    ) -> *mut radix_node;
}
extern "C" {
    pub fn rn_match(arg1: *mut ::std::os::raw::c_void, arg2: *mut radix_node_head) -> *mut radix_node;
}
extern "C" {
    pub fn rn_match_args(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *mut radix_node_head,
        arg3: rn_matchf_t,
        arg4: *mut ::std::os::raw::c_void,
    ) -> *mut radix_node;
}
pub type int_least8_t = i8;
pub type int_least16_t = i16;
pub type int_least32_t = i32;
pub type int_least64_t = i64;
pub type uint_least8_t = u8;
pub type uint_least16_t = u16;
pub type uint_least32_t = u32;
pub type uint_least64_t = u64;
pub type int_fast8_t = i8;
pub type int_fast16_t = i16;
pub type int_fast32_t = i32;
pub type int_fast64_t = i64;
pub type uint_fast8_t = u8;
pub type uint_fast16_t = u16;
pub type uint_fast32_t = u32;
pub type uint_fast64_t = u64;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
pub type uuid_t = __darwin_uuid_t;
pub type uuid_string_t = __darwin_uuid_string_t;
extern "C" {
    pub static UUID_NULL: uuid_t;
}
extern "C" {
    pub fn uuid_clear(uu: *mut ::std::os::raw::c_uchar);
}
extern "C" {
    pub fn uuid_compare(uu1: *mut ::std::os::raw::c_uchar, uu2: *mut ::std::os::raw::c_uchar) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn uuid_copy(dst: *mut ::std::os::raw::c_uchar, src: *mut ::std::os::raw::c_uchar);
}
extern "C" {
    pub fn uuid_generate(out: *mut ::std::os::raw::c_uchar);
}
extern "C" {
    pub fn uuid_generate_random(out: *mut ::std::os::raw::c_uchar);
}
extern "C" {
    pub fn uuid_generate_time(out: *mut ::std::os::raw::c_uchar);
}
extern "C" {
    pub fn uuid_generate_early_random(out: *mut ::std::os::raw::c_uchar);
}
extern "C" {
    pub fn uuid_is_null(uu: *mut ::std::os::raw::c_uchar) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn uuid_parse(in_: *mut ::std::os::raw::c_char, uu: *mut ::std::os::raw::c_uchar) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn uuid_unparse(uu: *mut ::std::os::raw::c_uchar, out: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn uuid_unparse_lower(uu: *mut ::std::os::raw::c_uchar, out: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn uuid_unparse_upper(uu: *mut ::std::os::raw::c_uchar, out: *mut ::std::os::raw::c_char);
}
pub type sa_family_t = __uint8_t;
pub type socklen_t = __darwin_socklen_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct iovec {
    pub iov_base: *mut ::std::os::raw::c_void,
    pub iov_len: usize,
}
#[test]
fn bindgen_test_layout_iovec() {
    const UNINIT: ::std::mem::MaybeUninit<iovec> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<iovec>(),
        16usize,
        concat!("Size of: ", stringify!(iovec))
    );
    assert_eq!(
        ::std::mem::align_of::<iovec>(),
        8usize,
        concat!("Alignment of ", stringify!(iovec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).iov_base) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(iovec), "::", stringify!(iov_base))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).iov_len) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(iovec), "::", stringify!(iov_len))
    );
}
extern "C" {
    pub static sotc_by_netservicetype: [::std::os::raw::c_int; 9usize];
}
pub type sae_associd_t = __uint32_t;
pub type sae_connid_t = __uint32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sa_endpoints {
    pub sae_srcif: ::std::os::raw::c_uint,
    pub sae_srcaddr: *const sockaddr,
    pub sae_srcaddrlen: socklen_t,
    pub sae_dstaddr: *const sockaddr,
    pub sae_dstaddrlen: socklen_t,
}
#[test]
fn bindgen_test_layout_sa_endpoints() {
    const UNINIT: ::std::mem::MaybeUninit<sa_endpoints> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sa_endpoints>(),
        40usize,
        concat!("Size of: ", stringify!(sa_endpoints))
    );
    assert_eq!(
        ::std::mem::align_of::<sa_endpoints>(),
        8usize,
        concat!("Alignment of ", stringify!(sa_endpoints))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sae_srcif) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sa_endpoints),
            "::",
            stringify!(sae_srcif)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sae_srcaddr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sa_endpoints),
            "::",
            stringify!(sae_srcaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sae_srcaddrlen) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sa_endpoints),
            "::",
            stringify!(sae_srcaddrlen)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sae_dstaddr) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sa_endpoints),
            "::",
            stringify!(sae_dstaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sae_dstaddrlen) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sa_endpoints),
            "::",
            stringify!(sae_dstaddrlen)
        )
    );
}
pub type sa_endpoints_t = sa_endpoints;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct linger {
    pub l_onoff: ::std::os::raw::c_int,
    pub l_linger: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_linger() {
    const UNINIT: ::std::mem::MaybeUninit<linger> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<linger>(),
        8usize,
        concat!("Size of: ", stringify!(linger))
    );
    assert_eq!(
        ::std::mem::align_of::<linger>(),
        4usize,
        concat!("Alignment of ", stringify!(linger))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).l_onoff) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(linger), "::", stringify!(l_onoff))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).l_linger) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(linger), "::", stringify!(l_linger))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct so_np_extensions {
    pub npx_flags: u_int32_t,
    pub npx_mask: u_int32_t,
}
#[test]
fn bindgen_test_layout_so_np_extensions() {
    const UNINIT: ::std::mem::MaybeUninit<so_np_extensions> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<so_np_extensions>(),
        8usize,
        concat!("Size of: ", stringify!(so_np_extensions))
    );
    assert_eq!(
        ::std::mem::align_of::<so_np_extensions>(),
        4usize,
        concat!("Alignment of ", stringify!(so_np_extensions))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).npx_flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(so_np_extensions),
            "::",
            stringify!(npx_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).npx_mask) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(so_np_extensions),
            "::",
            stringify!(npx_mask)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr {
    pub sa_len: __uint8_t,
    pub sa_family: sa_family_t,
    pub sa_data: [::std::os::raw::c_char; 14usize],
}
#[test]
fn bindgen_test_layout_sockaddr() {
    const UNINIT: ::std::mem::MaybeUninit<sockaddr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sockaddr>(),
        16usize,
        concat!("Size of: ", stringify!(sockaddr))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr>(),
        1usize,
        concat!("Alignment of ", stringify!(sockaddr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_len) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sockaddr), "::", stringify!(sa_len))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_family) as usize - ptr as usize },
        1usize,
        concat!("Offset of field: ", stringify!(sockaddr), "::", stringify!(sa_family))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa_data) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(sockaddr), "::", stringify!(sa_data))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockproto {
    pub sp_family: __uint16_t,
    pub sp_protocol: __uint16_t,
}
#[test]
fn bindgen_test_layout_sockproto() {
    const UNINIT: ::std::mem::MaybeUninit<sockproto> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sockproto>(),
        4usize,
        concat!("Size of: ", stringify!(sockproto))
    );
    assert_eq!(
        ::std::mem::align_of::<sockproto>(),
        2usize,
        concat!("Alignment of ", stringify!(sockproto))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sp_family) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sockproto), "::", stringify!(sp_family))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sp_protocol) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockproto),
            "::",
            stringify!(sp_protocol)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_storage {
    pub ss_len: __uint8_t,
    pub ss_family: sa_family_t,
    pub __ss_pad1: [::std::os::raw::c_char; 6usize],
    pub __ss_align: __int64_t,
    pub __ss_pad2: [::std::os::raw::c_char; 112usize],
}
#[test]
fn bindgen_test_layout_sockaddr_storage() {
    const UNINIT: ::std::mem::MaybeUninit<sockaddr_storage> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sockaddr_storage>(),
        128usize,
        concat!("Size of: ", stringify!(sockaddr_storage))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_storage>(),
        8usize,
        concat!("Alignment of ", stringify!(sockaddr_storage))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ss_len) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(ss_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ss_family) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(ss_family)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss_pad1) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(__ss_pad1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss_align) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(__ss_align)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__ss_pad2) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(__ss_pad2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct msghdr {
    pub msg_name: *mut ::std::os::raw::c_void,
    pub msg_namelen: socklen_t,
    pub msg_iov: *mut iovec,
    pub msg_iovlen: ::std::os::raw::c_int,
    pub msg_control: *mut ::std::os::raw::c_void,
    pub msg_controllen: socklen_t,
    pub msg_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_msghdr() {
    const UNINIT: ::std::mem::MaybeUninit<msghdr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<msghdr>(),
        48usize,
        concat!("Size of: ", stringify!(msghdr))
    );
    assert_eq!(
        ::std::mem::align_of::<msghdr>(),
        8usize,
        concat!("Alignment of ", stringify!(msghdr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_name) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(msghdr), "::", stringify!(msg_name))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_namelen) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(msghdr), "::", stringify!(msg_namelen))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_iov) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(msghdr), "::", stringify!(msg_iov))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_iovlen) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(msghdr), "::", stringify!(msg_iovlen))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_control) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(msghdr), "::", stringify!(msg_control))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_controllen) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_controllen)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_flags) as usize - ptr as usize },
        44usize,
        concat!("Offset of field: ", stringify!(msghdr), "::", stringify!(msg_flags))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct msghdr_x {
    pub msg_name: *mut ::std::os::raw::c_void,
    pub msg_namelen: socklen_t,
    pub msg_iov: *mut iovec,
    pub msg_iovlen: ::std::os::raw::c_int,
    pub msg_control: *mut ::std::os::raw::c_void,
    pub msg_controllen: socklen_t,
    pub msg_flags: ::std::os::raw::c_int,
    pub msg_datalen: usize,
}
#[test]
fn bindgen_test_layout_msghdr_x() {
    const UNINIT: ::std::mem::MaybeUninit<msghdr_x> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<msghdr_x>(),
        56usize,
        concat!("Size of: ", stringify!(msghdr_x))
    );
    assert_eq!(
        ::std::mem::align_of::<msghdr_x>(),
        8usize,
        concat!("Alignment of ", stringify!(msghdr_x))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_name) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(msghdr_x), "::", stringify!(msg_name))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_namelen) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(msghdr_x), "::", stringify!(msg_namelen))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_iov) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(msghdr_x), "::", stringify!(msg_iov))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_iovlen) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(msghdr_x), "::", stringify!(msg_iovlen))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_control) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(msghdr_x), "::", stringify!(msg_control))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_controllen) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(msghdr_x),
            "::",
            stringify!(msg_controllen)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_flags) as usize - ptr as usize },
        44usize,
        concat!("Offset of field: ", stringify!(msghdr_x), "::", stringify!(msg_flags))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msg_datalen) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(msghdr_x), "::", stringify!(msg_datalen))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cmsghdr {
    pub cmsg_len: socklen_t,
    pub cmsg_level: ::std::os::raw::c_int,
    pub cmsg_type: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_cmsghdr() {
    const UNINIT: ::std::mem::MaybeUninit<cmsghdr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<cmsghdr>(),
        12usize,
        concat!("Size of: ", stringify!(cmsghdr))
    );
    assert_eq!(
        ::std::mem::align_of::<cmsghdr>(),
        4usize,
        concat!("Alignment of ", stringify!(cmsghdr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cmsg_len) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(cmsghdr), "::", stringify!(cmsg_len))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cmsg_level) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(cmsghdr), "::", stringify!(cmsg_level))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cmsg_type) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(cmsghdr), "::", stringify!(cmsg_type))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sf_hdtr {
    pub headers: *mut iovec,
    pub hdr_cnt: ::std::os::raw::c_int,
    pub trailers: *mut iovec,
    pub trl_cnt: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sf_hdtr() {
    const UNINIT: ::std::mem::MaybeUninit<sf_hdtr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sf_hdtr>(),
        32usize,
        concat!("Size of: ", stringify!(sf_hdtr))
    );
    assert_eq!(
        ::std::mem::align_of::<sf_hdtr>(),
        8usize,
        concat!("Alignment of ", stringify!(sf_hdtr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).headers) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sf_hdtr), "::", stringify!(headers))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hdr_cnt) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(sf_hdtr), "::", stringify!(hdr_cnt))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trailers) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(sf_hdtr), "::", stringify!(trailers))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trl_cnt) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(sf_hdtr), "::", stringify!(trl_cnt))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct so_aidreq {
    pub sar_cnt: __uint32_t,
    pub sar_aidp: *mut sae_associd_t,
}
#[test]
fn bindgen_test_layout_so_aidreq() {
    const UNINIT: ::std::mem::MaybeUninit<so_aidreq> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<so_aidreq>(),
        16usize,
        concat!("Size of: ", stringify!(so_aidreq))
    );
    assert_eq!(
        ::std::mem::align_of::<so_aidreq>(),
        8usize,
        concat!("Alignment of ", stringify!(so_aidreq))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sar_cnt) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(so_aidreq), "::", stringify!(sar_cnt))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sar_aidp) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(so_aidreq), "::", stringify!(sar_aidp))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct so_cidreq {
    pub scr_aid: sae_associd_t,
    pub scr_cnt: __uint32_t,
    pub scr_cidp: *mut sae_connid_t,
}
#[test]
fn bindgen_test_layout_so_cidreq() {
    const UNINIT: ::std::mem::MaybeUninit<so_cidreq> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<so_cidreq>(),
        16usize,
        concat!("Size of: ", stringify!(so_cidreq))
    );
    assert_eq!(
        ::std::mem::align_of::<so_cidreq>(),
        8usize,
        concat!("Alignment of ", stringify!(so_cidreq))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scr_aid) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(so_cidreq), "::", stringify!(scr_aid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scr_cnt) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(so_cidreq), "::", stringify!(scr_cnt))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scr_cidp) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(so_cidreq), "::", stringify!(scr_cidp))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct so_cinforeq {
    pub scir_cid: sae_connid_t,
    pub scir_flags: __uint32_t,
    pub scir_ifindex: __uint32_t,
    pub scir_error: __int32_t,
    pub scir_src: *mut sockaddr,
    pub scir_src_len: socklen_t,
    pub scir_dst: *mut sockaddr,
    pub scir_dst_len: socklen_t,
    pub scir_aux_type: __uint32_t,
    pub scir_aux_data: *mut ::std::os::raw::c_void,
    pub scir_aux_len: __uint32_t,
}
#[test]
fn bindgen_test_layout_so_cinforeq() {
    const UNINIT: ::std::mem::MaybeUninit<so_cinforeq> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<so_cinforeq>(),
        64usize,
        concat!("Size of: ", stringify!(so_cinforeq))
    );
    assert_eq!(
        ::std::mem::align_of::<so_cinforeq>(),
        8usize,
        concat!("Alignment of ", stringify!(so_cinforeq))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scir_cid) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(so_cinforeq), "::", stringify!(scir_cid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scir_flags) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(so_cinforeq),
            "::",
            stringify!(scir_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scir_ifindex) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(so_cinforeq),
            "::",
            stringify!(scir_ifindex)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scir_error) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(so_cinforeq),
            "::",
            stringify!(scir_error)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scir_src) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(so_cinforeq), "::", stringify!(scir_src))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scir_src_len) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(so_cinforeq),
            "::",
            stringify!(scir_src_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scir_dst) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(so_cinforeq), "::", stringify!(scir_dst))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scir_dst_len) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(so_cinforeq),
            "::",
            stringify!(scir_dst_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scir_aux_type) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(so_cinforeq),
            "::",
            stringify!(scir_aux_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scir_aux_data) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(so_cinforeq),
            "::",
            stringify!(scir_aux_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scir_aux_len) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(so_cinforeq),
            "::",
            stringify!(scir_aux_len)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct so_cordreq {
    pub sco_cid: sae_connid_t,
    pub sco_rank: __uint32_t,
}
#[test]
fn bindgen_test_layout_so_cordreq() {
    const UNINIT: ::std::mem::MaybeUninit<so_cordreq> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<so_cordreq>(),
        8usize,
        concat!("Size of: ", stringify!(so_cordreq))
    );
    assert_eq!(
        ::std::mem::align_of::<so_cordreq>(),
        4usize,
        concat!("Alignment of ", stringify!(so_cordreq))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sco_cid) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(so_cordreq), "::", stringify!(sco_cid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sco_rank) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(so_cordreq), "::", stringify!(sco_rank))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct netpolicy_event_data {
    pub eupid: __uint64_t,
    pub epid: __uint64_t,
    pub euuid: uuid_t,
}
#[test]
fn bindgen_test_layout_netpolicy_event_data() {
    const UNINIT: ::std::mem::MaybeUninit<netpolicy_event_data> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<netpolicy_event_data>(),
        32usize,
        concat!("Size of: ", stringify!(netpolicy_event_data))
    );
    assert_eq!(
        ::std::mem::align_of::<netpolicy_event_data>(),
        8usize,
        concat!("Alignment of ", stringify!(netpolicy_event_data))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eupid) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(netpolicy_event_data),
            "::",
            stringify!(eupid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).epid) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(netpolicy_event_data),
            "::",
            stringify!(epid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).euuid) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(netpolicy_event_data),
            "::",
            stringify!(euuid)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kev_netpolicy_ifdenied {
    pub ev_data: netpolicy_event_data,
    pub ev_if_functional_type: __uint32_t,
}
#[test]
fn bindgen_test_layout_kev_netpolicy_ifdenied() {
    const UNINIT: ::std::mem::MaybeUninit<kev_netpolicy_ifdenied> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kev_netpolicy_ifdenied>(),
        40usize,
        concat!("Size of: ", stringify!(kev_netpolicy_ifdenied))
    );
    assert_eq!(
        ::std::mem::align_of::<kev_netpolicy_ifdenied>(),
        8usize,
        concat!("Alignment of ", stringify!(kev_netpolicy_ifdenied))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ev_data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kev_netpolicy_ifdenied),
            "::",
            stringify!(ev_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ev_if_functional_type) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kev_netpolicy_ifdenied),
            "::",
            stringify!(ev_if_functional_type)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kev_netpolicy_netdenied {
    pub ev_data: netpolicy_event_data,
    pub ev_network_type: __uint32_t,
}
#[test]
fn bindgen_test_layout_kev_netpolicy_netdenied() {
    const UNINIT: ::std::mem::MaybeUninit<kev_netpolicy_netdenied> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kev_netpolicy_netdenied>(),
        40usize,
        concat!("Size of: ", stringify!(kev_netpolicy_netdenied))
    );
    assert_eq!(
        ::std::mem::align_of::<kev_netpolicy_netdenied>(),
        8usize,
        concat!("Alignment of ", stringify!(kev_netpolicy_netdenied))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ev_data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kev_netpolicy_netdenied),
            "::",
            stringify!(ev_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ev_network_type) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kev_netpolicy_netdenied),
            "::",
            stringify!(ev_network_type)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct netsvctype_dscp_map {
    pub netsvctype: ::std::os::raw::c_int,
    pub dscp: u_int8_t,
}
#[test]
fn bindgen_test_layout_netsvctype_dscp_map() {
    const UNINIT: ::std::mem::MaybeUninit<netsvctype_dscp_map> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<netsvctype_dscp_map>(),
        8usize,
        concat!("Size of: ", stringify!(netsvctype_dscp_map))
    );
    assert_eq!(
        ::std::mem::align_of::<netsvctype_dscp_map>(),
        4usize,
        concat!("Alignment of ", stringify!(netsvctype_dscp_map))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).netsvctype) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(netsvctype_dscp_map),
            "::",
            stringify!(netsvctype)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dscp) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(netsvctype_dscp_map),
            "::",
            stringify!(dscp)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct so_mpkl_send_info {
    pub mpkl_uuid: uuid_t,
    pub mpkl_proto: __uint8_t,
}
#[test]
fn bindgen_test_layout_so_mpkl_send_info() {
    const UNINIT: ::std::mem::MaybeUninit<so_mpkl_send_info> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<so_mpkl_send_info>(),
        17usize,
        concat!("Size of: ", stringify!(so_mpkl_send_info))
    );
    assert_eq!(
        ::std::mem::align_of::<so_mpkl_send_info>(),
        1usize,
        concat!("Alignment of ", stringify!(so_mpkl_send_info))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mpkl_uuid) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(so_mpkl_send_info),
            "::",
            stringify!(mpkl_uuid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mpkl_proto) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(so_mpkl_send_info),
            "::",
            stringify!(mpkl_proto)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct so_mpkl_recv_info {
    pub mpkl_seq: __uint32_t,
    pub mpkl_proto: __uint8_t,
}
#[test]
fn bindgen_test_layout_so_mpkl_recv_info() {
    const UNINIT: ::std::mem::MaybeUninit<so_mpkl_recv_info> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<so_mpkl_recv_info>(),
        8usize,
        concat!("Size of: ", stringify!(so_mpkl_recv_info))
    );
    assert_eq!(
        ::std::mem::align_of::<so_mpkl_recv_info>(),
        4usize,
        concat!("Alignment of ", stringify!(so_mpkl_recv_info))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mpkl_seq) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(so_mpkl_recv_info),
            "::",
            stringify!(mpkl_seq)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mpkl_proto) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(so_mpkl_recv_info),
            "::",
            stringify!(mpkl_proto)
        )
    );
}
extern "C" {
    pub fn peeloff(s: ::std::os::raw::c_int, arg1: sae_associd_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn socket_delegate(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: pid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn recvmsg_x(
        s: ::std::os::raw::c_int,
        msgp: *const msghdr_x,
        cnt: u_int,
        flags: ::std::os::raw::c_int,
    ) -> isize;
}
extern "C" {
    pub fn sendmsg_x(
        s: ::std::os::raw::c_int,
        msgp: *const msghdr_x,
        cnt: u_int,
        flags: ::std::os::raw::c_int,
    ) -> isize;
}
extern "C" {
    #[link_name = "\u{1}_accept$UNIX2003"]
    pub fn accept(arg1: ::std::os::raw::c_int, arg2: *mut sockaddr, arg3: *mut socklen_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_bind$UNIX2003"]
    pub fn bind(arg1: ::std::os::raw::c_int, arg2: *const sockaddr, arg3: socklen_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_connect$UNIX2003"]
    pub fn connect(arg1: ::std::os::raw::c_int, arg2: *const sockaddr, arg3: socklen_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_getpeername$UNIX2003"]
    pub fn getpeername(arg1: ::std::os::raw::c_int, arg2: *mut sockaddr, arg3: *mut socklen_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_getsockname$UNIX2003"]
    pub fn getsockname(arg1: ::std::os::raw::c_int, arg2: *mut sockaddr, arg3: *mut socklen_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsockopt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_void,
        arg5: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_listen$UNIX2003"]
    pub fn listen(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_recv$UNIX2003"]
    pub fn recv(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
    ) -> isize;
}
extern "C" {
    #[link_name = "\u{1}_recvfrom$UNIX2003"]
    pub fn recvfrom(
        arg1: ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
        arg5: *mut sockaddr,
        arg6: *mut socklen_t,
    ) -> isize;
}
extern "C" {
    #[link_name = "\u{1}_recvmsg$UNIX2003"]
    pub fn recvmsg(arg1: ::std::os::raw::c_int, arg2: *mut msghdr, arg3: ::std::os::raw::c_int) -> isize;
}
extern "C" {
    #[link_name = "\u{1}_send$UNIX2003"]
    pub fn send(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
    ) -> isize;
}
extern "C" {
    #[link_name = "\u{1}_sendmsg$UNIX2003"]
    pub fn sendmsg(arg1: ::std::os::raw::c_int, arg2: *const msghdr, arg3: ::std::os::raw::c_int) -> isize;
}
extern "C" {
    #[link_name = "\u{1}_sendto$UNIX2003"]
    pub fn sendto(
        arg1: ::std::os::raw::c_int,
        arg2: *const ::std::os::raw::c_void,
        arg3: usize,
        arg4: ::std::os::raw::c_int,
        arg5: *const sockaddr,
        arg6: socklen_t,
    ) -> isize;
}
extern "C" {
    pub fn setsockopt(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_void,
        arg5: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn shutdown(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sockatmark(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn socket(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_socketpair$UNIX2003"]
    pub fn socketpair(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sendfile(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: off_t,
        arg4: *mut off_t,
        arg5: *mut sf_hdtr,
        arg6: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pfctlinput(arg1: ::std::os::raw::c_int, arg2: *mut sockaddr);
}
extern "C" {
    pub fn connectx(
        arg1: ::std::os::raw::c_int,
        arg2: *const sa_endpoints_t,
        arg3: sae_associd_t,
        arg4: ::std::os::raw::c_uint,
        arg5: *const iovec,
        arg6: ::std::os::raw::c_uint,
        arg7: *mut usize,
        arg8: *mut sae_connid_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn disconnectx(arg1: ::std::os::raw::c_int, arg2: sae_associd_t, arg3: sae_connid_t) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_addr {
    pub s_addr: in_addr_t,
}
#[test]
fn bindgen_test_layout_in_addr() {
    const UNINIT: ::std::mem::MaybeUninit<in_addr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<in_addr>(),
        4usize,
        concat!("Size of: ", stringify!(in_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<in_addr>(),
        4usize,
        concat!("Alignment of ", stringify!(in_addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s_addr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(in_addr), "::", stringify!(s_addr))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_in {
    pub sin_len: __uint8_t,
    pub sin_family: sa_family_t,
    pub sin_port: in_port_t,
    pub sin_addr: in_addr,
    pub sin_zero: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout_sockaddr_in() {
    const UNINIT: ::std::mem::MaybeUninit<sockaddr_in> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sockaddr_in>(),
        16usize,
        concat!("Size of: ", stringify!(sockaddr_in))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_in>(),
        4usize,
        concat!("Alignment of ", stringify!(sockaddr_in))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin_len) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sockaddr_in), "::", stringify!(sin_len))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin_family) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in),
            "::",
            stringify!(sin_family)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin_port) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(sockaddr_in), "::", stringify!(sin_port))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin_addr) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(sockaddr_in), "::", stringify!(sin_addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin_zero) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(sockaddr_in), "::", stringify!(sin_zero))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_inifscope {
    pub sin_len: __uint8_t,
    pub sin_family: sa_family_t,
    pub sin_port: in_port_t,
    pub sin_addr: in_addr,
    pub un: sockaddr_inifscope__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sockaddr_inifscope__bindgen_ty_1 {
    pub sin_zero: [::std::os::raw::c_char; 8usize],
    pub _in_index: sockaddr_inifscope__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_inifscope__bindgen_ty_1__bindgen_ty_1 {
    pub ifscope: __uint32_t,
}
#[test]
fn bindgen_test_layout_sockaddr_inifscope__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<sockaddr_inifscope__bindgen_ty_1__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sockaddr_inifscope__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(sockaddr_inifscope__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_inifscope__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(sockaddr_inifscope__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifscope) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_inifscope__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ifscope)
        )
    );
}
#[test]
fn bindgen_test_layout_sockaddr_inifscope__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<sockaddr_inifscope__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sockaddr_inifscope__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(sockaddr_inifscope__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_inifscope__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(sockaddr_inifscope__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin_zero) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_inifscope__bindgen_ty_1),
            "::",
            stringify!(sin_zero)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._in_index) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_inifscope__bindgen_ty_1),
            "::",
            stringify!(_in_index)
        )
    );
}
#[test]
fn bindgen_test_layout_sockaddr_inifscope() {
    const UNINIT: ::std::mem::MaybeUninit<sockaddr_inifscope> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sockaddr_inifscope>(),
        16usize,
        concat!("Size of: ", stringify!(sockaddr_inifscope))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_inifscope>(),
        4usize,
        concat!("Alignment of ", stringify!(sockaddr_inifscope))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin_len) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_inifscope),
            "::",
            stringify!(sin_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin_family) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_inifscope),
            "::",
            stringify!(sin_family)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin_port) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_inifscope),
            "::",
            stringify!(sin_port)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin_addr) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_inifscope),
            "::",
            stringify!(sin_addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).un) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_inifscope),
            "::",
            stringify!(un)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_opts {
    pub ip_dst: in_addr,
    pub ip_opts: [::std::os::raw::c_char; 40usize],
}
#[test]
fn bindgen_test_layout_ip_opts() {
    const UNINIT: ::std::mem::MaybeUninit<ip_opts> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ip_opts>(),
        44usize,
        concat!("Size of: ", stringify!(ip_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<ip_opts>(),
        4usize,
        concat!("Alignment of ", stringify!(ip_opts))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ip_dst) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(ip_opts), "::", stringify!(ip_dst))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ip_opts) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(ip_opts), "::", stringify!(ip_opts))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_mreq {
    pub imr_multiaddr: in_addr,
    pub imr_interface: in_addr,
}
#[test]
fn bindgen_test_layout_ip_mreq() {
    const UNINIT: ::std::mem::MaybeUninit<ip_mreq> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ip_mreq>(),
        8usize,
        concat!("Size of: ", stringify!(ip_mreq))
    );
    assert_eq!(
        ::std::mem::align_of::<ip_mreq>(),
        4usize,
        concat!("Alignment of ", stringify!(ip_mreq))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).imr_multiaddr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreq),
            "::",
            stringify!(imr_multiaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).imr_interface) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreq),
            "::",
            stringify!(imr_interface)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_mreqn {
    pub imr_multiaddr: in_addr,
    pub imr_address: in_addr,
    pub imr_ifindex: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_ip_mreqn() {
    const UNINIT: ::std::mem::MaybeUninit<ip_mreqn> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ip_mreqn>(),
        12usize,
        concat!("Size of: ", stringify!(ip_mreqn))
    );
    assert_eq!(
        ::std::mem::align_of::<ip_mreqn>(),
        4usize,
        concat!("Alignment of ", stringify!(ip_mreqn))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).imr_multiaddr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreqn),
            "::",
            stringify!(imr_multiaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).imr_address) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(ip_mreqn), "::", stringify!(imr_address))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).imr_ifindex) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(ip_mreqn), "::", stringify!(imr_ifindex))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ip_mreq_source {
    pub imr_multiaddr: in_addr,
    pub imr_sourceaddr: in_addr,
    pub imr_interface: in_addr,
}
#[test]
fn bindgen_test_layout_ip_mreq_source() {
    const UNINIT: ::std::mem::MaybeUninit<ip_mreq_source> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ip_mreq_source>(),
        12usize,
        concat!("Size of: ", stringify!(ip_mreq_source))
    );
    assert_eq!(
        ::std::mem::align_of::<ip_mreq_source>(),
        4usize,
        concat!("Alignment of ", stringify!(ip_mreq_source))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).imr_multiaddr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreq_source),
            "::",
            stringify!(imr_multiaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).imr_sourceaddr) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreq_source),
            "::",
            stringify!(imr_sourceaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).imr_interface) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ip_mreq_source),
            "::",
            stringify!(imr_interface)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct group_req {
    pub gr_interface: u32,
    pub gr_group: sockaddr_storage,
}
#[test]
fn bindgen_test_layout_group_req() {
    const UNINIT: ::std::mem::MaybeUninit<group_req> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<group_req>(),
        132usize,
        concat!("Size of: ", stringify!(group_req))
    );
    assert_eq!(
        ::std::mem::align_of::<group_req>(),
        4usize,
        concat!("Alignment of ", stringify!(group_req))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gr_interface) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(group_req),
            "::",
            stringify!(gr_interface)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gr_group) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(group_req), "::", stringify!(gr_group))
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct group_source_req {
    pub gsr_interface: u32,
    pub gsr_group: sockaddr_storage,
    pub gsr_source: sockaddr_storage,
}
#[test]
fn bindgen_test_layout_group_source_req() {
    const UNINIT: ::std::mem::MaybeUninit<group_source_req> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<group_source_req>(),
        260usize,
        concat!("Size of: ", stringify!(group_source_req))
    );
    assert_eq!(
        ::std::mem::align_of::<group_source_req>(),
        4usize,
        concat!("Alignment of ", stringify!(group_source_req))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gsr_interface) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(group_source_req),
            "::",
            stringify!(gsr_interface)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gsr_group) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(group_source_req),
            "::",
            stringify!(gsr_group)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gsr_source) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(group_source_req),
            "::",
            stringify!(gsr_source)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __msfilterreq {
    pub msfr_ifindex: u32,
    pub msfr_fmode: u32,
    pub msfr_nsrcs: u32,
    pub __msfr_align: u32,
    pub msfr_group: sockaddr_storage,
    pub msfr_srcs: *mut sockaddr_storage,
}
#[test]
fn bindgen_test_layout___msfilterreq() {
    const UNINIT: ::std::mem::MaybeUninit<__msfilterreq> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__msfilterreq>(),
        152usize,
        concat!("Size of: ", stringify!(__msfilterreq))
    );
    assert_eq!(
        ::std::mem::align_of::<__msfilterreq>(),
        4usize,
        concat!("Alignment of ", stringify!(__msfilterreq))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msfr_ifindex) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__msfilterreq),
            "::",
            stringify!(msfr_ifindex)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msfr_fmode) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__msfilterreq),
            "::",
            stringify!(msfr_fmode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msfr_nsrcs) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__msfilterreq),
            "::",
            stringify!(msfr_nsrcs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__msfr_align) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__msfilterreq),
            "::",
            stringify!(__msfr_align)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msfr_group) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__msfilterreq),
            "::",
            stringify!(msfr_group)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).msfr_srcs) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__msfilterreq),
            "::",
            stringify!(msfr_srcs)
        )
    );
}
extern "C" {
    pub fn setipv4sourcefilter(
        arg1: ::std::os::raw::c_int,
        arg2: in_addr,
        arg3: in_addr,
        arg4: u32,
        arg5: u32,
        arg6: *mut in_addr,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getipv4sourcefilter(
        arg1: ::std::os::raw::c_int,
        arg2: in_addr,
        arg3: in_addr,
        arg4: *mut u32,
        arg5: *mut u32,
        arg6: *mut in_addr,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setsourcefilter(
        arg1: ::std::os::raw::c_int,
        arg2: u32,
        arg3: *mut sockaddr,
        arg4: socklen_t,
        arg5: u32,
        arg6: u32,
        arg7: *mut sockaddr_storage,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsourcefilter(
        arg1: ::std::os::raw::c_int,
        arg2: u32,
        arg3: *mut sockaddr,
        arg4: socklen_t,
        arg5: *mut u32,
        arg6: *mut u32,
        arg7: *mut sockaddr_storage,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_pktinfo {
    pub ipi_ifindex: ::std::os::raw::c_uint,
    pub ipi_spec_dst: in_addr,
    pub ipi_addr: in_addr,
}
#[test]
fn bindgen_test_layout_in_pktinfo() {
    const UNINIT: ::std::mem::MaybeUninit<in_pktinfo> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<in_pktinfo>(),
        12usize,
        concat!("Size of: ", stringify!(in_pktinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<in_pktinfo>(),
        4usize,
        concat!("Alignment of ", stringify!(in_pktinfo))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ipi_ifindex) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in_pktinfo),
            "::",
            stringify!(ipi_ifindex)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ipi_spec_dst) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(in_pktinfo),
            "::",
            stringify!(ipi_spec_dst)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ipi_addr) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(in_pktinfo), "::", stringify!(ipi_addr))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_addr {
    pub __u6_addr: in6_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in6_addr__bindgen_ty_1 {
    pub __u6_addr8: [__uint8_t; 16usize],
    pub __u6_addr16: [__uint16_t; 8usize],
    pub __u6_addr32: [__uint32_t; 4usize],
}
#[test]
fn bindgen_test_layout_in6_addr__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<in6_addr__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<in6_addr__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(in6_addr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<in6_addr__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(in6_addr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__u6_addr8) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in6_addr__bindgen_ty_1),
            "::",
            stringify!(__u6_addr8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__u6_addr16) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in6_addr__bindgen_ty_1),
            "::",
            stringify!(__u6_addr16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__u6_addr32) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in6_addr__bindgen_ty_1),
            "::",
            stringify!(__u6_addr32)
        )
    );
}
#[test]
fn bindgen_test_layout_in6_addr() {
    const UNINIT: ::std::mem::MaybeUninit<in6_addr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<in6_addr>(),
        16usize,
        concat!("Size of: ", stringify!(in6_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<in6_addr>(),
        4usize,
        concat!("Alignment of ", stringify!(in6_addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__u6_addr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(in6_addr), "::", stringify!(__u6_addr))
    );
}
pub type in6_addr_t = in6_addr;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_in6 {
    pub sin6_len: __uint8_t,
    pub sin6_family: sa_family_t,
    pub sin6_port: in_port_t,
    pub sin6_flowinfo: __uint32_t,
    pub sin6_addr: in6_addr,
    pub sin6_scope_id: __uint32_t,
}
#[test]
fn bindgen_test_layout_sockaddr_in6() {
    const UNINIT: ::std::mem::MaybeUninit<sockaddr_in6> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sockaddr_in6>(),
        28usize,
        concat!("Size of: ", stringify!(sockaddr_in6))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_in6>(),
        4usize,
        concat!("Alignment of ", stringify!(sockaddr_in6))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin6_len) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin6_family) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_family)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin6_port) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_port)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin6_flowinfo) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_flowinfo)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin6_addr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin6_scope_id) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sockaddr_in6),
            "::",
            stringify!(sin6_scope_id)
        )
    );
}
extern "C" {
    pub static in6addr_any: in6_addr;
}
extern "C" {
    pub static in6addr_loopback: in6_addr;
}
extern "C" {
    pub static in6addr_nodelocal_allnodes: in6_addr;
}
extern "C" {
    pub static in6addr_linklocal_allnodes: in6_addr;
}
extern "C" {
    pub static in6addr_linklocal_allrouters: in6_addr;
}
extern "C" {
    pub static in6addr_linklocal_allv2routers: in6_addr;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct route_in6_old {
    pub ro_rt: *mut ::std::os::raw::c_void,
    pub ro_flags: u32,
    pub ro_dst: sockaddr_in6,
}
#[test]
fn bindgen_test_layout_route_in6_old() {
    const UNINIT: ::std::mem::MaybeUninit<route_in6_old> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<route_in6_old>(),
        40usize,
        concat!("Size of: ", stringify!(route_in6_old))
    );
    assert_eq!(
        ::std::mem::align_of::<route_in6_old>(),
        8usize,
        concat!("Alignment of ", stringify!(route_in6_old))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ro_rt) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(route_in6_old), "::", stringify!(ro_rt))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ro_flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(route_in6_old),
            "::",
            stringify!(ro_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ro_dst) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(route_in6_old), "::", stringify!(ro_dst))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ipv6_mreq {
    pub ipv6mr_multiaddr: in6_addr,
    pub ipv6mr_interface: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_ipv6_mreq() {
    const UNINIT: ::std::mem::MaybeUninit<ipv6_mreq> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ipv6_mreq>(),
        20usize,
        concat!("Size of: ", stringify!(ipv6_mreq))
    );
    assert_eq!(
        ::std::mem::align_of::<ipv6_mreq>(),
        4usize,
        concat!("Alignment of ", stringify!(ipv6_mreq))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ipv6mr_multiaddr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ipv6_mreq),
            "::",
            stringify!(ipv6mr_multiaddr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ipv6mr_interface) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ipv6_mreq),
            "::",
            stringify!(ipv6mr_interface)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_pktinfo {
    pub ipi6_addr: in6_addr,
    pub ipi6_ifindex: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_in6_pktinfo() {
    const UNINIT: ::std::mem::MaybeUninit<in6_pktinfo> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<in6_pktinfo>(),
        20usize,
        concat!("Size of: ", stringify!(in6_pktinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<in6_pktinfo>(),
        4usize,
        concat!("Alignment of ", stringify!(in6_pktinfo))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ipi6_addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(in6_pktinfo),
            "::",
            stringify!(ipi6_addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ipi6_ifindex) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(in6_pktinfo),
            "::",
            stringify!(ipi6_ifindex)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ip6_mtuinfo {
    pub ip6m_addr: sockaddr_in6,
    pub ip6m_mtu: u32,
}
#[test]
fn bindgen_test_layout_ip6_mtuinfo() {
    const UNINIT: ::std::mem::MaybeUninit<ip6_mtuinfo> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ip6_mtuinfo>(),
        32usize,
        concat!("Size of: ", stringify!(ip6_mtuinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<ip6_mtuinfo>(),
        4usize,
        concat!("Alignment of ", stringify!(ip6_mtuinfo))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ip6m_addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ip6_mtuinfo),
            "::",
            stringify!(ip6m_addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ip6m_mtu) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(ip6_mtuinfo), "::", stringify!(ip6m_mtu))
    );
}
pub const in6_clat46_evhdlr_code_t_IN6_CLAT46_EVENT_V4_FLOW: in6_clat46_evhdlr_code_t = 0;
pub const in6_clat46_evhdlr_code_t_IN6_CLAT46_EVENT_V6_ADDR_CONFFAIL: in6_clat46_evhdlr_code_t = 1;
pub type in6_clat46_evhdlr_code_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kev_netevent_clat46_data {
    pub clat46_event_code: in6_clat46_evhdlr_code_t,
    pub epid: pid_t,
    pub euuid: uuid_t,
}
#[test]
fn bindgen_test_layout_kev_netevent_clat46_data() {
    const UNINIT: ::std::mem::MaybeUninit<kev_netevent_clat46_data> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kev_netevent_clat46_data>(),
        24usize,
        concat!("Size of: ", stringify!(kev_netevent_clat46_data))
    );
    assert_eq!(
        ::std::mem::align_of::<kev_netevent_clat46_data>(),
        4usize,
        concat!("Alignment of ", stringify!(kev_netevent_clat46_data))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clat46_event_code) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kev_netevent_clat46_data),
            "::",
            stringify!(clat46_event_code)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).epid) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kev_netevent_clat46_data),
            "::",
            stringify!(epid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).euuid) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kev_netevent_clat46_data),
            "::",
            stringify!(euuid)
        )
    );
}
extern "C" {
    pub fn inet6_option_space(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_option_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *mut *mut cmsghdr,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_option_append(
        arg1: *mut cmsghdr,
        arg2: *const __uint8_t,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_option_alloc(
        arg1: *mut cmsghdr,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> *mut __uint8_t;
}
extern "C" {
    pub fn inet6_option_next(arg1: *const cmsghdr, arg2: *mut *mut __uint8_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_option_find(
        arg1: *const cmsghdr,
        arg2: *mut *mut __uint8_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_rthdr_space(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> usize;
}
extern "C" {
    pub fn inet6_rthdr_init(arg1: *mut ::std::os::raw::c_void, arg2: ::std::os::raw::c_int) -> *mut cmsghdr;
}
extern "C" {
    pub fn inet6_rthdr_add(
        arg1: *mut cmsghdr,
        arg2: *const in6_addr,
        arg3: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_rthdr_lasthop(arg1: *mut cmsghdr, arg2: ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_rthdr_segments(arg1: *const cmsghdr) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_rthdr_getaddr(arg1: *mut cmsghdr, arg2: ::std::os::raw::c_int) -> *mut in6_addr;
}
extern "C" {
    pub fn inet6_rthdr_getflags(arg1: *const cmsghdr, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_opt_init(arg1: *mut ::std::os::raw::c_void, arg2: socklen_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_opt_append(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: __uint8_t,
        arg5: socklen_t,
        arg6: __uint8_t,
        arg7: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_opt_finish(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_opt_set_val(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_void,
        arg4: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_opt_next(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: *mut __uint8_t,
        arg5: *mut socklen_t,
        arg6: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_opt_find(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: __uint8_t,
        arg5: *mut socklen_t,
        arg6: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_opt_get_val(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_void,
        arg4: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_rth_space(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> socklen_t;
}
extern "C" {
    pub fn inet6_rth_init(
        arg1: *mut ::std::os::raw::c_void,
        arg2: socklen_t,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn inet6_rth_add(arg1: *mut ::std::os::raw::c_void, arg2: *const in6_addr) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_rth_reverse(
        arg1: *const ::std::os::raw::c_void,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_rth_segments(arg1: *const ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn inet6_rth_getaddr(arg1: *const ::std::os::raw::c_void, arg2: ::std::os::raw::c_int) -> *mut in6_addr;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sockaddr_in_4_6 {
    pub sa: sockaddr,
    pub sin: sockaddr_in,
    pub sin6: sockaddr_in6,
}
#[test]
fn bindgen_test_layout_sockaddr_in_4_6() {
    const UNINIT: ::std::mem::MaybeUninit<sockaddr_in_4_6> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sockaddr_in_4_6>(),
        28usize,
        concat!("Size of: ", stringify!(sockaddr_in_4_6))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_in_4_6>(),
        4usize,
        concat!("Alignment of ", stringify!(sockaddr_in_4_6))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sockaddr_in_4_6), "::", stringify!(sa))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sockaddr_in_4_6), "::", stringify!(sin))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin6) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sockaddr_in_4_6), "::", stringify!(sin6))
    );
}
extern "C" {
    pub fn bindresvport(arg1: ::std::os::raw::c_int, arg2: *mut sockaddr_in) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bindresvport_sa(arg1: ::std::os::raw::c_int, arg2: *mut sockaddr) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __darwin_time_t,
    pub tv_nsec: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_timespec() {
    const UNINIT: ::std::mem::MaybeUninit<timespec> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_sec) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(timespec), "::", stringify!(tv_sec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_nsec) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(timespec), "::", stringify!(tv_nsec))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __darwin_time_t,
    pub tv_usec: __darwin_suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    const UNINIT: ::std::mem::MaybeUninit<timeval> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_sec) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(timeval), "::", stringify!(tv_sec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_usec) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(timeval), "::", stringify!(tv_usec))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval64 {
    pub tv_sec: __int64_t,
    pub tv_usec: __int64_t,
}
#[test]
fn bindgen_test_layout_timeval64() {
    const UNINIT: ::std::mem::MaybeUninit<timeval64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<timeval64>(),
        16usize,
        concat!("Size of: ", stringify!(timeval64))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval64>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_sec) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(timeval64), "::", stringify!(tv_sec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_usec) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(timeval64), "::", stringify!(tv_usec))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimerval {
    pub it_interval: timeval,
    pub it_value: timeval,
}
#[test]
fn bindgen_test_layout_itimerval() {
    const UNINIT: ::std::mem::MaybeUninit<itimerval> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<itimerval>(),
        32usize,
        concat!("Size of: ", stringify!(itimerval))
    );
    assert_eq!(
        ::std::mem::align_of::<itimerval>(),
        8usize,
        concat!("Alignment of ", stringify!(itimerval))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).it_interval) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(itimerval),
            "::",
            stringify!(it_interval)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).it_value) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(itimerval), "::", stringify!(it_value))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timezone {
    pub tz_minuteswest: ::std::os::raw::c_int,
    pub tz_dsttime: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_timezone() {
    const UNINIT: ::std::mem::MaybeUninit<timezone> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<timezone>(),
        8usize,
        concat!("Size of: ", stringify!(timezone))
    );
    assert_eq!(
        ::std::mem::align_of::<timezone>(),
        4usize,
        concat!("Alignment of ", stringify!(timezone))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tz_minuteswest) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timezone),
            "::",
            stringify!(tz_minuteswest)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tz_dsttime) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(timezone), "::", stringify!(tz_dsttime))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct clockinfo {
    pub hz: ::std::os::raw::c_int,
    pub tick: ::std::os::raw::c_int,
    pub tickadj: ::std::os::raw::c_int,
    pub stathz: ::std::os::raw::c_int,
    pub profhz: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_clockinfo() {
    const UNINIT: ::std::mem::MaybeUninit<clockinfo> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<clockinfo>(),
        20usize,
        concat!("Size of: ", stringify!(clockinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<clockinfo>(),
        4usize,
        concat!("Alignment of ", stringify!(clockinfo))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hz) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(clockinfo), "::", stringify!(hz))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tick) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(clockinfo), "::", stringify!(tick))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tickadj) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(clockinfo), "::", stringify!(tickadj))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stathz) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(clockinfo), "::", stringify!(stathz))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).profhz) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(clockinfo), "::", stringify!(profhz))
    );
}
pub type __darwin_nl_item = ::std::os::raw::c_int;
pub type __darwin_wctrans_t = ::std::os::raw::c_int;
pub type __darwin_wctype_t = __uint32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tm {
    pub tm_sec: ::std::os::raw::c_int,
    pub tm_min: ::std::os::raw::c_int,
    pub tm_hour: ::std::os::raw::c_int,
    pub tm_mday: ::std::os::raw::c_int,
    pub tm_mon: ::std::os::raw::c_int,
    pub tm_year: ::std::os::raw::c_int,
    pub tm_wday: ::std::os::raw::c_int,
    pub tm_yday: ::std::os::raw::c_int,
    pub tm_isdst: ::std::os::raw::c_int,
    pub tm_gmtoff: ::std::os::raw::c_long,
    pub tm_zone: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_tm() {
    const UNINIT: ::std::mem::MaybeUninit<tm> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<tm>(),
        56usize,
        concat!("Size of: ", stringify!(tm))
    );
    assert_eq!(
        ::std::mem::align_of::<tm>(),
        8usize,
        concat!("Alignment of ", stringify!(tm))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_sec) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(tm), "::", stringify!(tm_sec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_min) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(tm), "::", stringify!(tm_min))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_hour) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(tm), "::", stringify!(tm_hour))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_mday) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(tm), "::", stringify!(tm_mday))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_mon) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(tm), "::", stringify!(tm_mon))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_year) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(tm), "::", stringify!(tm_year))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_wday) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(tm), "::", stringify!(tm_wday))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_yday) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(tm), "::", stringify!(tm_yday))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_isdst) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(tm), "::", stringify!(tm_isdst))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_gmtoff) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(tm), "::", stringify!(tm_gmtoff))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tm_zone) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(tm), "::", stringify!(tm_zone))
    );
}
extern "C" {
    pub static mut tzname: [*mut ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut getdate_err: ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_timezone$UNIX2003"]
    pub static mut timezone: ::std::os::raw::c_long;
}
extern "C" {
    pub static mut daylight: ::std::os::raw::c_int;
}
extern "C" {
    pub fn asctime(arg1: *const tm) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}_clock$UNIX2003"]
    pub fn clock() -> clock_t;
}
extern "C" {
    pub fn ctime(arg1: *const time_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn difftime(arg1: time_t, arg2: time_t) -> f64;
}
extern "C" {
    pub fn getdate(arg1: *const ::std::os::raw::c_char) -> *mut tm;
}
extern "C" {
    pub fn gmtime(arg1: *const time_t) -> *mut tm;
}
extern "C" {
    pub fn localtime(arg1: *const time_t) -> *mut tm;
}
extern "C" {
    #[link_name = "\u{1}_mktime$UNIX2003"]
    pub fn mktime(arg1: *mut tm) -> time_t;
}
extern "C" {
    #[link_name = "\u{1}_strftime$UNIX2003"]
    pub fn strftime(
        arg1: *mut ::std::os::raw::c_char,
        arg2: usize,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const tm,
    ) -> usize;
}
extern "C" {
    #[link_name = "\u{1}_strptime$UNIX2003"]
    pub fn strptime(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut tm,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn time(arg1: *mut time_t) -> time_t;
}
extern "C" {
    pub fn tzset();
}
extern "C" {
    pub fn asctime_r(arg1: *const tm, arg2: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ctime_r(arg1: *const time_t, arg2: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gmtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn localtime_r(arg1: *const time_t, arg2: *mut tm) -> *mut tm;
}
extern "C" {
    pub fn posix2time(arg1: time_t) -> time_t;
}
extern "C" {
    pub fn tzsetwall();
}
extern "C" {
    pub fn time2posix(arg1: time_t) -> time_t;
}
extern "C" {
    pub fn timelocal(arg1: *mut tm) -> time_t;
}
extern "C" {
    pub fn timegm(arg1: *mut tm) -> time_t;
}
extern "C" {
    #[link_name = "\u{1}_nanosleep$UNIX2003"]
    pub fn nanosleep(__rqtp: *const timespec, __rmtp: *mut timespec) -> ::std::os::raw::c_int;
}
pub const clockid_t__CLOCK_REALTIME: clockid_t = 0;
pub const clockid_t__CLOCK_MONOTONIC: clockid_t = 6;
pub const clockid_t__CLOCK_MONOTONIC_RAW: clockid_t = 4;
pub const clockid_t__CLOCK_MONOTONIC_RAW_APPROX: clockid_t = 5;
pub const clockid_t__CLOCK_UPTIME_RAW: clockid_t = 8;
pub const clockid_t__CLOCK_UPTIME_RAW_APPROX: clockid_t = 9;
pub const clockid_t__CLOCK_PROCESS_CPUTIME_ID: clockid_t = 12;
pub const clockid_t__CLOCK_THREAD_CPUTIME_ID: clockid_t = 16;
pub type clockid_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn clock_getres(__clock_id: clockid_t, __res: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime(__clock_id: clockid_t, __tp: *mut timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clock_gettime_nsec_np(__clock_id: clockid_t) -> __uint64_t;
}
extern "C" {
    pub fn clock_settime(__clock_id: clockid_t, __tp: *const timespec) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn timespec_get(ts: *mut timespec, base: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn adjtime(arg1: *const timeval, arg2: *mut timeval) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn futimes(arg1: ::std::os::raw::c_int, arg2: *const timeval) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn lutimes(arg1: *const ::std::os::raw::c_char, arg2: *const timeval) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn settimeofday(arg1: *const timeval, arg2: *const timezone) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getitimer(arg1: ::std::os::raw::c_int, arg2: *mut itimerval) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gettimeofday(arg1: *mut timeval, arg2: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_select$1050"]
    pub fn select(
        arg1: ::std::os::raw::c_int,
        arg2: *mut fd_set,
        arg3: *mut fd_set,
        arg4: *mut fd_set,
        arg5: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setitimer(
        arg1: ::std::os::raw::c_int,
        arg2: *const itimerval,
        arg3: *mut itimerval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn utimes(arg1: *const ::std::os::raw::c_char, arg2: *const timeval) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rt_metrics {
    pub rmx_locks: u_int32_t,
    pub rmx_mtu: u_int32_t,
    pub rmx_hopcount: u_int32_t,
    pub rmx_expire: i32,
    pub rmx_recvpipe: u_int32_t,
    pub rmx_sendpipe: u_int32_t,
    pub rmx_ssthresh: u_int32_t,
    pub rmx_rtt: u_int32_t,
    pub rmx_rttvar: u_int32_t,
    pub rmx_pksent: u_int32_t,
    pub rmx_state: u_int32_t,
    pub rmx_filler: [u_int32_t; 3usize],
}
#[test]
fn bindgen_test_layout_rt_metrics() {
    const UNINIT: ::std::mem::MaybeUninit<rt_metrics> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rt_metrics>(),
        56usize,
        concat!("Size of: ", stringify!(rt_metrics))
    );
    assert_eq!(
        ::std::mem::align_of::<rt_metrics>(),
        4usize,
        concat!("Alignment of ", stringify!(rt_metrics))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmx_locks) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(rt_metrics), "::", stringify!(rmx_locks))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmx_mtu) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(rt_metrics), "::", stringify!(rmx_mtu))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmx_hopcount) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_metrics),
            "::",
            stringify!(rmx_hopcount)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmx_expire) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_metrics),
            "::",
            stringify!(rmx_expire)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmx_recvpipe) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_metrics),
            "::",
            stringify!(rmx_recvpipe)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmx_sendpipe) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_metrics),
            "::",
            stringify!(rmx_sendpipe)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmx_ssthresh) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_metrics),
            "::",
            stringify!(rmx_ssthresh)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmx_rtt) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(rt_metrics), "::", stringify!(rmx_rtt))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmx_rttvar) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_metrics),
            "::",
            stringify!(rmx_rttvar)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmx_pksent) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_metrics),
            "::",
            stringify!(rmx_pksent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmx_state) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(rt_metrics), "::", stringify!(rmx_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rmx_filler) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_metrics),
            "::",
            stringify!(rmx_filler)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct route_old {
    pub ro_rt: *mut ::std::os::raw::c_void,
    pub ro_flags: u32,
    pub ro_dst: sockaddr,
}
#[test]
fn bindgen_test_layout_route_old() {
    const UNINIT: ::std::mem::MaybeUninit<route_old> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<route_old>(),
        32usize,
        concat!("Size of: ", stringify!(route_old))
    );
    assert_eq!(
        ::std::mem::align_of::<route_old>(),
        8usize,
        concat!("Alignment of ", stringify!(route_old))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ro_rt) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(route_old), "::", stringify!(ro_rt))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ro_flags) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(route_old), "::", stringify!(ro_flags))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ro_dst) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(route_old), "::", stringify!(ro_dst))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rtstat {
    pub rts_badredirect: ::std::os::raw::c_short,
    pub rts_dynamic: ::std::os::raw::c_short,
    pub rts_newgateway: ::std::os::raw::c_short,
    pub rts_unreach: ::std::os::raw::c_short,
    pub rts_wildcard: ::std::os::raw::c_short,
    pub rts_badrtgwroute: ::std::os::raw::c_short,
}
#[test]
fn bindgen_test_layout_rtstat() {
    const UNINIT: ::std::mem::MaybeUninit<rtstat> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rtstat>(),
        12usize,
        concat!("Size of: ", stringify!(rtstat))
    );
    assert_eq!(
        ::std::mem::align_of::<rtstat>(),
        2usize,
        concat!("Alignment of ", stringify!(rtstat))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rts_badredirect) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rtstat),
            "::",
            stringify!(rts_badredirect)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rts_dynamic) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(rtstat), "::", stringify!(rts_dynamic))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rts_newgateway) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rtstat),
            "::",
            stringify!(rts_newgateway)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rts_unreach) as usize - ptr as usize },
        6usize,
        concat!("Offset of field: ", stringify!(rtstat), "::", stringify!(rts_unreach))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rts_wildcard) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(rtstat), "::", stringify!(rts_wildcard))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rts_badrtgwroute) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(rtstat),
            "::",
            stringify!(rts_badrtgwroute)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rt_msghdr {
    pub rtm_msglen: u_short,
    pub rtm_version: u_char,
    pub rtm_type: u_char,
    pub rtm_index: u_short,
    pub rtm_flags: ::std::os::raw::c_int,
    pub rtm_addrs: ::std::os::raw::c_int,
    pub rtm_pid: pid_t,
    pub rtm_seq: ::std::os::raw::c_int,
    pub rtm_errno: ::std::os::raw::c_int,
    pub rtm_use: ::std::os::raw::c_int,
    pub rtm_inits: u_int32_t,
    pub rtm_rmx: rt_metrics,
}
#[test]
fn bindgen_test_layout_rt_msghdr() {
    const UNINIT: ::std::mem::MaybeUninit<rt_msghdr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rt_msghdr>(),
        92usize,
        concat!("Size of: ", stringify!(rt_msghdr))
    );
    assert_eq!(
        ::std::mem::align_of::<rt_msghdr>(),
        4usize,
        concat!("Alignment of ", stringify!(rt_msghdr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_msglen) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(rt_msghdr), "::", stringify!(rtm_msglen))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_version) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr),
            "::",
            stringify!(rtm_version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_type) as usize - ptr as usize },
        3usize,
        concat!("Offset of field: ", stringify!(rt_msghdr), "::", stringify!(rtm_type))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_index) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(rt_msghdr), "::", stringify!(rtm_index))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_flags) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(rt_msghdr), "::", stringify!(rtm_flags))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_addrs) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(rt_msghdr), "::", stringify!(rtm_addrs))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_pid) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(rt_msghdr), "::", stringify!(rtm_pid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_seq) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(rt_msghdr), "::", stringify!(rtm_seq))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_errno) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(rt_msghdr), "::", stringify!(rtm_errno))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_use) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(rt_msghdr), "::", stringify!(rtm_use))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_inits) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(rt_msghdr), "::", stringify!(rtm_inits))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_rmx) as usize - ptr as usize },
        36usize,
        concat!("Offset of field: ", stringify!(rt_msghdr), "::", stringify!(rtm_rmx))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rt_msghdr2 {
    pub rtm_msglen: u_short,
    pub rtm_version: u_char,
    pub rtm_type: u_char,
    pub rtm_index: u_short,
    pub rtm_flags: ::std::os::raw::c_int,
    pub rtm_addrs: ::std::os::raw::c_int,
    pub rtm_refcnt: i32,
    pub rtm_parentflags: ::std::os::raw::c_int,
    pub rtm_reserved: ::std::os::raw::c_int,
    pub rtm_use: ::std::os::raw::c_int,
    pub rtm_inits: u_int32_t,
    pub rtm_rmx: rt_metrics,
}
#[test]
fn bindgen_test_layout_rt_msghdr2() {
    const UNINIT: ::std::mem::MaybeUninit<rt_msghdr2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rt_msghdr2>(),
        92usize,
        concat!("Size of: ", stringify!(rt_msghdr2))
    );
    assert_eq!(
        ::std::mem::align_of::<rt_msghdr2>(),
        4usize,
        concat!("Alignment of ", stringify!(rt_msghdr2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_msglen) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr2),
            "::",
            stringify!(rtm_msglen)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_version) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr2),
            "::",
            stringify!(rtm_version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_type) as usize - ptr as usize },
        3usize,
        concat!("Offset of field: ", stringify!(rt_msghdr2), "::", stringify!(rtm_type))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_index) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(rt_msghdr2), "::", stringify!(rtm_index))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_flags) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(rt_msghdr2), "::", stringify!(rtm_flags))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_addrs) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(rt_msghdr2), "::", stringify!(rtm_addrs))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_refcnt) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr2),
            "::",
            stringify!(rtm_refcnt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_parentflags) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr2),
            "::",
            stringify!(rtm_parentflags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_reserved) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr2),
            "::",
            stringify!(rtm_reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_use) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(rt_msghdr2), "::", stringify!(rtm_use))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_inits) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(rt_msghdr2), "::", stringify!(rtm_inits))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_rmx) as usize - ptr as usize },
        36usize,
        concat!("Offset of field: ", stringify!(rt_msghdr2), "::", stringify!(rtm_rmx))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kev_netevent_apnfallbk_data {
    pub epid: pid_t,
    pub euuid: uuid_t,
}
#[test]
fn bindgen_test_layout_kev_netevent_apnfallbk_data() {
    const UNINIT: ::std::mem::MaybeUninit<kev_netevent_apnfallbk_data> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<kev_netevent_apnfallbk_data>(),
        20usize,
        concat!("Size of: ", stringify!(kev_netevent_apnfallbk_data))
    );
    assert_eq!(
        ::std::mem::align_of::<kev_netevent_apnfallbk_data>(),
        4usize,
        concat!("Alignment of ", stringify!(kev_netevent_apnfallbk_data))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).epid) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kev_netevent_apnfallbk_data),
            "::",
            stringify!(epid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).euuid) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kev_netevent_apnfallbk_data),
            "::",
            stringify!(euuid)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rt_reach_info {
    pub ri_refcnt: u_int32_t,
    pub ri_probes: u_int32_t,
    pub ri_snd_expire: u_int64_t,
    pub ri_rcv_expire: u_int64_t,
    pub ri_rssi: i32,
    pub ri_lqm: i32,
    pub ri_npm: i32,
}
#[test]
fn bindgen_test_layout_rt_reach_info() {
    const UNINIT: ::std::mem::MaybeUninit<rt_reach_info> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rt_reach_info>(),
        40usize,
        concat!("Size of: ", stringify!(rt_reach_info))
    );
    assert_eq!(
        ::std::mem::align_of::<rt_reach_info>(),
        8usize,
        concat!("Alignment of ", stringify!(rt_reach_info))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ri_refcnt) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_reach_info),
            "::",
            stringify!(ri_refcnt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ri_probes) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_reach_info),
            "::",
            stringify!(ri_probes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ri_snd_expire) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_reach_info),
            "::",
            stringify!(ri_snd_expire)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ri_rcv_expire) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_reach_info),
            "::",
            stringify!(ri_rcv_expire)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ri_rssi) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_reach_info),
            "::",
            stringify!(ri_rssi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ri_lqm) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(rt_reach_info), "::", stringify!(ri_lqm))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ri_npm) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(rt_reach_info), "::", stringify!(ri_npm))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rt_msghdr_ext {
    pub rtm_msglen: u_short,
    pub rtm_version: u_char,
    pub rtm_type: u_char,
    pub rtm_index: u_int32_t,
    pub rtm_flags: u_int32_t,
    pub rtm_reserved: u_int32_t,
    pub rtm_addrs: u_int32_t,
    pub rtm_pid: pid_t,
    pub rtm_seq: ::std::os::raw::c_int,
    pub rtm_errno: ::std::os::raw::c_int,
    pub rtm_use: u_int32_t,
    pub rtm_inits: u_int32_t,
    pub rtm_rmx: rt_metrics,
    pub rtm_ri: rt_reach_info,
}
#[test]
fn bindgen_test_layout_rt_msghdr_ext() {
    const UNINIT: ::std::mem::MaybeUninit<rt_msghdr_ext> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rt_msghdr_ext>(),
        136usize,
        concat!("Size of: ", stringify!(rt_msghdr_ext))
    );
    assert_eq!(
        ::std::mem::align_of::<rt_msghdr_ext>(),
        8usize,
        concat!("Alignment of ", stringify!(rt_msghdr_ext))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_msglen) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr_ext),
            "::",
            stringify!(rtm_msglen)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_version) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr_ext),
            "::",
            stringify!(rtm_version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_type) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr_ext),
            "::",
            stringify!(rtm_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_index) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr_ext),
            "::",
            stringify!(rtm_index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_flags) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr_ext),
            "::",
            stringify!(rtm_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_reserved) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr_ext),
            "::",
            stringify!(rtm_reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_addrs) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr_ext),
            "::",
            stringify!(rtm_addrs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_pid) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr_ext),
            "::",
            stringify!(rtm_pid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_seq) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr_ext),
            "::",
            stringify!(rtm_seq)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_errno) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr_ext),
            "::",
            stringify!(rtm_errno)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_use) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr_ext),
            "::",
            stringify!(rtm_use)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_inits) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr_ext),
            "::",
            stringify!(rtm_inits)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_rmx) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_msghdr_ext),
            "::",
            stringify!(rtm_rmx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtm_ri) as usize - ptr as usize },
        96usize,
        concat!("Offset of field: ", stringify!(rt_msghdr_ext), "::", stringify!(rtm_ri))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rt_addrinfo {
    pub rti_addrs: ::std::os::raw::c_int,
    pub rti_info: [*mut sockaddr; 8usize],
}
#[test]
fn bindgen_test_layout_rt_addrinfo() {
    const UNINIT: ::std::mem::MaybeUninit<rt_addrinfo> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rt_addrinfo>(),
        72usize,
        concat!("Size of: ", stringify!(rt_addrinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<rt_addrinfo>(),
        8usize,
        concat!("Alignment of ", stringify!(rt_addrinfo))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rti_addrs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rt_addrinfo),
            "::",
            stringify!(rti_addrs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rti_info) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(rt_addrinfo), "::", stringify!(rti_info))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct net_event_data {
    pub if_family: u_int32_t,
    pub if_unit: u_int32_t,
    pub if_name: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout_net_event_data() {
    const UNINIT: ::std::mem::MaybeUninit<net_event_data> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<net_event_data>(),
        24usize,
        concat!("Size of: ", stringify!(net_event_data))
    );
    assert_eq!(
        ::std::mem::align_of::<net_event_data>(),
        4usize,
        concat!("Alignment of ", stringify!(net_event_data))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).if_family) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(net_event_data),
            "::",
            stringify!(if_family)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).if_unit) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(net_event_data),
            "::",
            stringify!(if_unit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).if_name) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(net_event_data),
            "::",
            stringify!(if_name)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval32 {
    pub tv_sec: __int32_t,
    pub tv_usec: __int32_t,
}
#[test]
fn bindgen_test_layout_timeval32() {
    const UNINIT: ::std::mem::MaybeUninit<timeval32> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<timeval32>(),
        8usize,
        concat!("Size of: ", stringify!(timeval32))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval32>(),
        4usize,
        concat!("Alignment of ", stringify!(timeval32))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_sec) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(timeval32), "::", stringify!(tv_sec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tv_usec) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(timeval32), "::", stringify!(tv_usec))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_data {
    pub ifi_type: u_char,
    pub ifi_typelen: u_char,
    pub ifi_physical: u_char,
    pub ifi_addrlen: u_char,
    pub ifi_hdrlen: u_char,
    pub ifi_recvquota: u_char,
    pub ifi_xmitquota: u_char,
    pub ifi_unused1: u_char,
    pub ifi_mtu: u_int32_t,
    pub ifi_metric: u_int32_t,
    pub ifi_baudrate: u_int32_t,
    pub ifi_ipackets: u_int32_t,
    pub ifi_ierrors: u_int32_t,
    pub ifi_opackets: u_int32_t,
    pub ifi_oerrors: u_int32_t,
    pub ifi_collisions: u_int32_t,
    pub ifi_ibytes: u_int32_t,
    pub ifi_obytes: u_int32_t,
    pub ifi_imcasts: u_int32_t,
    pub ifi_omcasts: u_int32_t,
    pub ifi_iqdrops: u_int32_t,
    pub ifi_noproto: u_int32_t,
    pub ifi_recvtiming: u_int32_t,
    pub ifi_xmittiming: u_int32_t,
    pub ifi_lastchange: timeval32,
    pub ifi_unused2: u_int32_t,
    pub ifi_hwassist: u_int32_t,
    pub ifi_reserved1: u_int32_t,
    pub ifi_reserved2: u_int32_t,
}
#[test]
fn bindgen_test_layout_if_data() {
    const UNINIT: ::std::mem::MaybeUninit<if_data> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_data>(),
        96usize,
        concat!("Size of: ", stringify!(if_data))
    );
    assert_eq!(
        ::std::mem::align_of::<if_data>(),
        4usize,
        concat!("Alignment of ", stringify!(if_data))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_type) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_type))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_typelen) as usize - ptr as usize },
        1usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_typelen))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_physical) as usize - ptr as usize },
        2usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_physical))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_addrlen) as usize - ptr as usize },
        3usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_addrlen))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_hdrlen) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_hdrlen))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_recvquota) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data),
            "::",
            stringify!(ifi_recvquota)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_xmitquota) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data),
            "::",
            stringify!(ifi_xmitquota)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_unused1) as usize - ptr as usize },
        7usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_unused1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_mtu) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_mtu))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_metric) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_metric))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_baudrate) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_baudrate))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ipackets) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_ipackets))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ierrors) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_ierrors))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_opackets) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_opackets))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_oerrors) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_oerrors))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_collisions) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data),
            "::",
            stringify!(ifi_collisions)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ibytes) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_ibytes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_obytes) as usize - ptr as usize },
        44usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_obytes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_imcasts) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_imcasts))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_omcasts) as usize - ptr as usize },
        52usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_omcasts))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_iqdrops) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_iqdrops))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_noproto) as usize - ptr as usize },
        60usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_noproto))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_recvtiming) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data),
            "::",
            stringify!(ifi_recvtiming)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_xmittiming) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data),
            "::",
            stringify!(ifi_xmittiming)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_lastchange) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data),
            "::",
            stringify!(ifi_lastchange)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_unused2) as usize - ptr as usize },
        80usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_unused2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_hwassist) as usize - ptr as usize },
        84usize,
        concat!("Offset of field: ", stringify!(if_data), "::", stringify!(ifi_hwassist))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_reserved1) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data),
            "::",
            stringify!(ifi_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_reserved2) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data),
            "::",
            stringify!(ifi_reserved2)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_data64 {
    pub ifi_type: u_char,
    pub ifi_typelen: u_char,
    pub ifi_physical: u_char,
    pub ifi_addrlen: u_char,
    pub ifi_hdrlen: u_char,
    pub ifi_recvquota: u_char,
    pub ifi_xmitquota: u_char,
    pub ifi_unused1: u_char,
    pub ifi_mtu: u_int32_t,
    pub ifi_metric: u_int32_t,
    pub ifi_baudrate: u_int64_t,
    pub ifi_ipackets: u_int64_t,
    pub ifi_ierrors: u_int64_t,
    pub ifi_opackets: u_int64_t,
    pub ifi_oerrors: u_int64_t,
    pub ifi_collisions: u_int64_t,
    pub ifi_ibytes: u_int64_t,
    pub ifi_obytes: u_int64_t,
    pub ifi_imcasts: u_int64_t,
    pub ifi_omcasts: u_int64_t,
    pub ifi_iqdrops: u_int64_t,
    pub ifi_noproto: u_int64_t,
    pub ifi_recvtiming: u_int32_t,
    pub ifi_xmittiming: u_int32_t,
    pub ifi_lastchange: timeval32,
}
#[test]
fn bindgen_test_layout_if_data64() {
    const UNINIT: ::std::mem::MaybeUninit<if_data64> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_data64>(),
        128usize,
        concat!("Size of: ", stringify!(if_data64))
    );
    assert_eq!(
        ::std::mem::align_of::<if_data64>(),
        4usize,
        concat!("Alignment of ", stringify!(if_data64))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_type) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(if_data64), "::", stringify!(ifi_type))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_typelen) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_typelen)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_physical) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_physical)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_addrlen) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_addrlen)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_hdrlen) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(if_data64), "::", stringify!(ifi_hdrlen))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_recvquota) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_recvquota)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_xmitquota) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_xmitquota)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_unused1) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_unused1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_mtu) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(if_data64), "::", stringify!(ifi_mtu))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_metric) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(if_data64), "::", stringify!(ifi_metric))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_baudrate) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_baudrate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ipackets) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_ipackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ierrors) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_ierrors)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_opackets) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_opackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_oerrors) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_oerrors)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_collisions) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_collisions)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ibytes) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(if_data64), "::", stringify!(ifi_ibytes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_obytes) as usize - ptr as usize },
        72usize,
        concat!("Offset of field: ", stringify!(if_data64), "::", stringify!(ifi_obytes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_imcasts) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_imcasts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_omcasts) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_omcasts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_iqdrops) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_iqdrops)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_noproto) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_noproto)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_recvtiming) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_recvtiming)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_xmittiming) as usize - ptr as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_xmittiming)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_lastchange) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data64),
            "::",
            stringify!(ifi_lastchange)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_traffic_class {
    pub ifi_ibepackets: u_int64_t,
    pub ifi_ibebytes: u_int64_t,
    pub ifi_obepackets: u_int64_t,
    pub ifi_obebytes: u_int64_t,
    pub ifi_ibkpackets: u_int64_t,
    pub ifi_ibkbytes: u_int64_t,
    pub ifi_obkpackets: u_int64_t,
    pub ifi_obkbytes: u_int64_t,
    pub ifi_ivipackets: u_int64_t,
    pub ifi_ivibytes: u_int64_t,
    pub ifi_ovipackets: u_int64_t,
    pub ifi_ovibytes: u_int64_t,
    pub ifi_ivopackets: u_int64_t,
    pub ifi_ivobytes: u_int64_t,
    pub ifi_ovopackets: u_int64_t,
    pub ifi_ovobytes: u_int64_t,
    pub ifi_ipvpackets: u_int64_t,
    pub ifi_ipvbytes: u_int64_t,
    pub ifi_opvpackets: u_int64_t,
    pub ifi_opvbytes: u_int64_t,
}
#[test]
fn bindgen_test_layout_if_traffic_class() {
    const UNINIT: ::std::mem::MaybeUninit<if_traffic_class> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_traffic_class>(),
        160usize,
        concat!("Size of: ", stringify!(if_traffic_class))
    );
    assert_eq!(
        ::std::mem::align_of::<if_traffic_class>(),
        4usize,
        concat!("Alignment of ", stringify!(if_traffic_class))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ibepackets) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ibepackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ibebytes) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ibebytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_obepackets) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_obepackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_obebytes) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_obebytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ibkpackets) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ibkpackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ibkbytes) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ibkbytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_obkpackets) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_obkpackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_obkbytes) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_obkbytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ivipackets) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ivipackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ivibytes) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ivibytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ovipackets) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ovipackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ovibytes) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ovibytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ivopackets) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ivopackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ivobytes) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ivobytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ovopackets) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ovopackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ovobytes) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ovobytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ipvpackets) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ipvpackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_ipvbytes) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_ipvbytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_opvpackets) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_opvpackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_opvbytes) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(if_traffic_class),
            "::",
            stringify!(ifi_opvbytes)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_data_extended {
    pub ifi_alignerrs: u_int64_t,
    pub ifi_dt_bytes: u_int64_t,
    pub ifi_fpackets: u_int64_t,
    pub ifi_fbytes: u_int64_t,
    pub reserved: [u_int64_t; 12usize],
}
#[test]
fn bindgen_test_layout_if_data_extended() {
    const UNINIT: ::std::mem::MaybeUninit<if_data_extended> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_data_extended>(),
        128usize,
        concat!("Size of: ", stringify!(if_data_extended))
    );
    assert_eq!(
        ::std::mem::align_of::<if_data_extended>(),
        4usize,
        concat!("Alignment of ", stringify!(if_data_extended))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_alignerrs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data_extended),
            "::",
            stringify!(ifi_alignerrs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_dt_bytes) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data_extended),
            "::",
            stringify!(ifi_dt_bytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_fpackets) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data_extended),
            "::",
            stringify!(ifi_fpackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_fbytes) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data_extended),
            "::",
            stringify!(ifi_fbytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(if_data_extended),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_packet_stats {
    pub ifi_tcp_badformat: u_int64_t,
    pub ifi_tcp_unspecv6: u_int64_t,
    pub ifi_tcp_synfin: u_int64_t,
    pub ifi_tcp_badformatipsec: u_int64_t,
    pub ifi_tcp_noconnnolist: u_int64_t,
    pub ifi_tcp_noconnlist: u_int64_t,
    pub ifi_tcp_listbadsyn: u_int64_t,
    pub ifi_tcp_icmp6unreach: u_int64_t,
    pub ifi_tcp_deprecate6: u_int64_t,
    pub ifi_tcp_rstinsynrcv: u_int64_t,
    pub ifi_tcp_ooopacket: u_int64_t,
    pub ifi_tcp_dospacket: u_int64_t,
    pub ifi_tcp_cleanup: u_int64_t,
    pub ifi_tcp_synwindow: u_int64_t,
    pub reserved: [u_int64_t; 6usize],
    pub ifi_udp_port_unreach: u_int64_t,
    pub ifi_udp_faithprefix: u_int64_t,
    pub ifi_udp_port0: u_int64_t,
    pub ifi_udp_badlength: u_int64_t,
    pub ifi_udp_badchksum: u_int64_t,
    pub ifi_udp_badmcast: u_int64_t,
    pub ifi_udp_cleanup: u_int64_t,
    pub ifi_udp_badipsec: u_int64_t,
    pub _reserved: [u_int64_t; 4usize],
}
#[test]
fn bindgen_test_layout_if_packet_stats() {
    const UNINIT: ::std::mem::MaybeUninit<if_packet_stats> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_packet_stats>(),
        256usize,
        concat!("Size of: ", stringify!(if_packet_stats))
    );
    assert_eq!(
        ::std::mem::align_of::<if_packet_stats>(),
        4usize,
        concat!("Alignment of ", stringify!(if_packet_stats))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_badformat) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_badformat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_unspecv6) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_unspecv6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_synfin) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_synfin)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_badformatipsec) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_badformatipsec)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_noconnnolist) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_noconnnolist)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_noconnlist) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_noconnlist)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_listbadsyn) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_listbadsyn)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_icmp6unreach) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_icmp6unreach)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_deprecate6) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_deprecate6)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_rstinsynrcv) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_rstinsynrcv)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_ooopacket) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_ooopacket)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_dospacket) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_dospacket)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_cleanup) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_cleanup)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_tcp_synwindow) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_tcp_synwindow)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_udp_port_unreach) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_udp_port_unreach)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_udp_faithprefix) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_udp_faithprefix)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_udp_port0) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_udp_port0)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_udp_badlength) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_udp_badlength)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_udp_badchksum) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_udp_badchksum)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_udp_badmcast) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_udp_badmcast)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_udp_cleanup) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_udp_cleanup)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_udp_badipsec) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(ifi_udp_badipsec)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._reserved) as usize - ptr as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(if_packet_stats),
            "::",
            stringify!(_reserved)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_description {
    pub ifd_maxlen: u_int32_t,
    pub ifd_len: u_int32_t,
    pub ifd_desc: *mut u_int8_t,
}
#[test]
fn bindgen_test_layout_if_description() {
    const UNINIT: ::std::mem::MaybeUninit<if_description> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_description>(),
        16usize,
        concat!("Size of: ", stringify!(if_description))
    );
    assert_eq!(
        ::std::mem::align_of::<if_description>(),
        4usize,
        concat!("Alignment of ", stringify!(if_description))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifd_maxlen) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_description),
            "::",
            stringify!(ifd_maxlen)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifd_len) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(if_description),
            "::",
            stringify!(ifd_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifd_desc) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(if_description),
            "::",
            stringify!(ifd_desc)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_bandwidths {
    pub eff_bw: u64,
    pub max_bw: u64,
}
#[test]
fn bindgen_test_layout_if_bandwidths() {
    const UNINIT: ::std::mem::MaybeUninit<if_bandwidths> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_bandwidths>(),
        16usize,
        concat!("Size of: ", stringify!(if_bandwidths))
    );
    assert_eq!(
        ::std::mem::align_of::<if_bandwidths>(),
        4usize,
        concat!("Alignment of ", stringify!(if_bandwidths))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eff_bw) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(if_bandwidths), "::", stringify!(eff_bw))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_bw) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(if_bandwidths), "::", stringify!(max_bw))
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_latencies {
    pub eff_lt: u_int64_t,
    pub max_lt: u_int64_t,
}
#[test]
fn bindgen_test_layout_if_latencies() {
    const UNINIT: ::std::mem::MaybeUninit<if_latencies> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_latencies>(),
        16usize,
        concat!("Size of: ", stringify!(if_latencies))
    );
    assert_eq!(
        ::std::mem::align_of::<if_latencies>(),
        4usize,
        concat!("Alignment of ", stringify!(if_latencies))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eff_lt) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(if_latencies), "::", stringify!(eff_lt))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_lt) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(if_latencies), "::", stringify!(max_lt))
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_netem_params {
    pub ifnetem_bandwidth_bps: u64,
    pub ifnetem_latency_ms: u32,
    pub ifnetem_jitter_ms: u32,
    pub ifnetem_corruption_p: u32,
    pub ifnetem_duplication_p: u32,
    pub ifnetem_loss_p_gr_gl: u32,
    pub ifnetem_loss_p_gr_bl: u32,
    pub ifnetem_loss_p_bl_br: u32,
    pub ifnetem_loss_p_bl_gr: u32,
    pub ifnetem_loss_p_br_bl: u32,
    pub ifnetem_reordering_p: u32,
}
#[test]
fn bindgen_test_layout_if_netem_params() {
    const UNINIT: ::std::mem::MaybeUninit<if_netem_params> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_netem_params>(),
        48usize,
        concat!("Size of: ", stringify!(if_netem_params))
    );
    assert_eq!(
        ::std::mem::align_of::<if_netem_params>(),
        4usize,
        concat!("Alignment of ", stringify!(if_netem_params))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifnetem_bandwidth_bps) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netem_params),
            "::",
            stringify!(ifnetem_bandwidth_bps)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifnetem_latency_ms) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netem_params),
            "::",
            stringify!(ifnetem_latency_ms)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifnetem_jitter_ms) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netem_params),
            "::",
            stringify!(ifnetem_jitter_ms)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifnetem_corruption_p) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netem_params),
            "::",
            stringify!(ifnetem_corruption_p)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifnetem_duplication_p) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netem_params),
            "::",
            stringify!(ifnetem_duplication_p)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifnetem_loss_p_gr_gl) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netem_params),
            "::",
            stringify!(ifnetem_loss_p_gr_gl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifnetem_loss_p_gr_bl) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netem_params),
            "::",
            stringify!(ifnetem_loss_p_gr_bl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifnetem_loss_p_bl_br) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netem_params),
            "::",
            stringify!(ifnetem_loss_p_bl_br)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifnetem_loss_p_bl_gr) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netem_params),
            "::",
            stringify!(ifnetem_loss_p_bl_gr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifnetem_loss_p_br_bl) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netem_params),
            "::",
            stringify!(ifnetem_loss_p_br_bl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifnetem_reordering_p) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netem_params),
            "::",
            stringify!(ifnetem_reordering_p)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_rxpoll_stats {
    pub ifi_poll_off_req: u_int32_t,
    pub ifi_poll_off_err: u_int32_t,
    pub ifi_poll_on_req: u_int32_t,
    pub ifi_poll_on_err: u_int32_t,
    pub ifi_poll_wakeups_avg: u_int32_t,
    pub ifi_poll_wakeups_lowat: u_int32_t,
    pub ifi_poll_wakeups_hiwat: u_int32_t,
    pub ifi_poll_packets: u_int64_t,
    pub ifi_poll_packets_avg: u_int32_t,
    pub ifi_poll_packets_min: u_int32_t,
    pub ifi_poll_packets_max: u_int32_t,
    pub ifi_poll_packets_lowat: u_int32_t,
    pub ifi_poll_packets_hiwat: u_int32_t,
    pub ifi_poll_bytes: u_int64_t,
    pub ifi_poll_bytes_avg: u_int32_t,
    pub ifi_poll_bytes_min: u_int32_t,
    pub ifi_poll_bytes_max: u_int32_t,
    pub ifi_poll_bytes_lowat: u_int32_t,
    pub ifi_poll_bytes_hiwat: u_int32_t,
    pub ifi_poll_packets_limit: u_int32_t,
    pub ifi_poll_interval_time: u_int64_t,
}
#[test]
fn bindgen_test_layout_if_rxpoll_stats() {
    const UNINIT: ::std::mem::MaybeUninit<if_rxpoll_stats> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_rxpoll_stats>(),
        96usize,
        concat!("Size of: ", stringify!(if_rxpoll_stats))
    );
    assert_eq!(
        ::std::mem::align_of::<if_rxpoll_stats>(),
        4usize,
        concat!("Alignment of ", stringify!(if_rxpoll_stats))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_off_req) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_off_req)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_off_err) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_off_err)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_on_req) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_on_req)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_on_err) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_on_err)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_wakeups_avg) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_wakeups_avg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_wakeups_lowat) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_wakeups_lowat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_wakeups_hiwat) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_wakeups_hiwat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_packets) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_packets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_packets_avg) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_packets_avg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_packets_min) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_packets_min)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_packets_max) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_packets_max)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_packets_lowat) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_packets_lowat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_packets_hiwat) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_packets_hiwat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_bytes) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_bytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_bytes_avg) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_bytes_avg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_bytes_min) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_bytes_min)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_bytes_max) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_bytes_max)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_bytes_lowat) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_bytes_lowat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_bytes_hiwat) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_bytes_hiwat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_packets_limit) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_packets_limit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifi_poll_interval_time) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(if_rxpoll_stats),
            "::",
            stringify!(ifi_poll_interval_time)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_netif_stats {
    pub ifn_rx_mit_interval: u_int64_t,
    pub ifn_rx_mit_mode: u_int32_t,
    pub ifn_rx_mit_packets_avg: u_int32_t,
    pub ifn_rx_mit_packets_min: u_int32_t,
    pub ifn_rx_mit_packets_max: u_int32_t,
    pub ifn_rx_mit_bytes_avg: u_int32_t,
    pub ifn_rx_mit_bytes_min: u_int32_t,
    pub ifn_rx_mit_bytes_max: u_int32_t,
    pub ifn_rx_mit_cfg_idx: u_int32_t,
    pub ifn_rx_mit_cfg_packets_lowat: u_int32_t,
    pub ifn_rx_mit_cfg_packets_hiwat: u_int32_t,
    pub ifn_rx_mit_cfg_bytes_lowat: u_int32_t,
    pub ifn_rx_mit_cfg_bytes_hiwat: u_int32_t,
    pub ifn_rx_mit_cfg_interval: u_int32_t,
}
#[test]
fn bindgen_test_layout_if_netif_stats() {
    const UNINIT: ::std::mem::MaybeUninit<if_netif_stats> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_netif_stats>(),
        60usize,
        concat!("Size of: ", stringify!(if_netif_stats))
    );
    assert_eq!(
        ::std::mem::align_of::<if_netif_stats>(),
        4usize,
        concat!("Alignment of ", stringify!(if_netif_stats))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_interval) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_interval)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_mode) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_packets_avg) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_packets_avg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_packets_min) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_packets_min)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_packets_max) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_packets_max)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_bytes_avg) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_bytes_avg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_bytes_min) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_bytes_min)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_bytes_max) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_bytes_max)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_cfg_idx) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_cfg_idx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_cfg_packets_lowat) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_cfg_packets_lowat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_cfg_packets_hiwat) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_cfg_packets_hiwat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_cfg_bytes_lowat) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_cfg_bytes_lowat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_cfg_bytes_hiwat) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_cfg_bytes_hiwat)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifn_rx_mit_cfg_interval) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(if_netif_stats),
            "::",
            stringify!(ifn_rx_mit_cfg_interval)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_tcp_ecn_perf_stat {
    pub total_txpkts: u_int64_t,
    pub total_rxmitpkts: u_int64_t,
    pub total_rxpkts: u_int64_t,
    pub total_oopkts: u_int64_t,
    pub total_reorderpkts: u_int64_t,
    pub rtt_avg: u_int64_t,
    pub rtt_var: u_int64_t,
    pub sack_episodes: u_int64_t,
    pub rxmit_drop: u_int64_t,
    pub rst_drop: u_int64_t,
    pub oo_percent: u_int64_t,
    pub reorder_percent: u_int64_t,
    pub rxmit_percent: u_int64_t,
}
#[test]
fn bindgen_test_layout_if_tcp_ecn_perf_stat() {
    const UNINIT: ::std::mem::MaybeUninit<if_tcp_ecn_perf_stat> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_tcp_ecn_perf_stat>(),
        104usize,
        concat!("Size of: ", stringify!(if_tcp_ecn_perf_stat))
    );
    assert_eq!(
        ::std::mem::align_of::<if_tcp_ecn_perf_stat>(),
        4usize,
        concat!("Alignment of ", stringify!(if_tcp_ecn_perf_stat))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).total_txpkts) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_perf_stat),
            "::",
            stringify!(total_txpkts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).total_rxmitpkts) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_perf_stat),
            "::",
            stringify!(total_rxmitpkts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).total_rxpkts) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_perf_stat),
            "::",
            stringify!(total_rxpkts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).total_oopkts) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_perf_stat),
            "::",
            stringify!(total_oopkts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).total_reorderpkts) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_perf_stat),
            "::",
            stringify!(total_reorderpkts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtt_avg) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_perf_stat),
            "::",
            stringify!(rtt_avg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtt_var) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_perf_stat),
            "::",
            stringify!(rtt_var)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sack_episodes) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_perf_stat),
            "::",
            stringify!(sack_episodes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rxmit_drop) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_perf_stat),
            "::",
            stringify!(rxmit_drop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rst_drop) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_perf_stat),
            "::",
            stringify!(rst_drop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).oo_percent) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_perf_stat),
            "::",
            stringify!(oo_percent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reorder_percent) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_perf_stat),
            "::",
            stringify!(reorder_percent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rxmit_percent) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_perf_stat),
            "::",
            stringify!(rxmit_percent)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_tcp_ecn_stat {
    pub timestamp: u_int64_t,
    pub ecn_client_setup: u_int64_t,
    pub ecn_server_setup: u_int64_t,
    pub ecn_client_success: u_int64_t,
    pub ecn_server_success: u_int64_t,
    pub ecn_peer_nosupport: u_int64_t,
    pub ecn_syn_lost: u_int64_t,
    pub ecn_synack_lost: u_int64_t,
    pub ecn_recv_ce: u_int64_t,
    pub ecn_recv_ece: u_int64_t,
    pub ecn_conn_recv_ce: u_int64_t,
    pub ecn_conn_recv_ece: u_int64_t,
    pub ecn_conn_plnoce: u_int64_t,
    pub ecn_conn_plce: u_int64_t,
    pub ecn_conn_noplce: u_int64_t,
    pub ecn_fallback_synloss: u_int64_t,
    pub ecn_fallback_reorder: u_int64_t,
    pub ecn_fallback_ce: u_int64_t,
    pub ecn_off_conn: u_int64_t,
    pub ecn_total_conn: u_int64_t,
    pub ecn_fallback_droprst: u_int64_t,
    pub ecn_fallback_droprxmt: u_int64_t,
    pub ecn_fallback_synrst: u_int64_t,
    pub ecn_on: if_tcp_ecn_perf_stat,
    pub ecn_off: if_tcp_ecn_perf_stat,
}
#[test]
fn bindgen_test_layout_if_tcp_ecn_stat() {
    const UNINIT: ::std::mem::MaybeUninit<if_tcp_ecn_stat> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_tcp_ecn_stat>(),
        392usize,
        concat!("Size of: ", stringify!(if_tcp_ecn_stat))
    );
    assert_eq!(
        ::std::mem::align_of::<if_tcp_ecn_stat>(),
        4usize,
        concat!("Alignment of ", stringify!(if_tcp_ecn_stat))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timestamp) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(timestamp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_client_setup) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_client_setup)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_server_setup) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_server_setup)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_client_success) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_client_success)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_server_success) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_server_success)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_peer_nosupport) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_peer_nosupport)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_syn_lost) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_syn_lost)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_synack_lost) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_synack_lost)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_recv_ce) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_recv_ce)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_recv_ece) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_recv_ece)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_conn_recv_ce) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_conn_recv_ce)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_conn_recv_ece) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_conn_recv_ece)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_conn_plnoce) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_conn_plnoce)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_conn_plce) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_conn_plce)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_conn_noplce) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_conn_noplce)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_fallback_synloss) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_fallback_synloss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_fallback_reorder) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_fallback_reorder)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_fallback_ce) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_fallback_ce)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_off_conn) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_off_conn)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_total_conn) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_total_conn)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_fallback_droprst) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_fallback_droprst)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_fallback_droprxmt) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_fallback_droprxmt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_fallback_synrst) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_fallback_synrst)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_on) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_on)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_off) as usize - ptr as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(if_tcp_ecn_stat),
            "::",
            stringify!(ecn_off)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct if_lim_perf_stat {
    pub lim_dl_max_bandwidth: u_int64_t,
    pub lim_ul_max_bandwidth: u_int64_t,
    pub lim_total_txpkts: u_int64_t,
    pub lim_total_rxpkts: u_int64_t,
    pub lim_total_retxpkts: u_int64_t,
    pub lim_packet_loss_percent: u_int64_t,
    pub lim_total_oopkts: u_int64_t,
    pub lim_packet_ooo_percent: u_int64_t,
    pub lim_rtt_variance: u_int64_t,
    pub lim_rtt_average: u_int64_t,
    pub lim_rtt_min: u_int64_t,
    pub lim_conn_timeouts: u_int64_t,
    pub lim_conn_attempts: u_int64_t,
    pub lim_conn_timeout_percent: u_int64_t,
    pub lim_bk_txpkts: u_int64_t,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_if_lim_perf_stat() {
    const UNINIT: ::std::mem::MaybeUninit<if_lim_perf_stat> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_lim_perf_stat>(),
        124usize,
        concat!("Size of: ", stringify!(if_lim_perf_stat))
    );
    assert_eq!(
        ::std::mem::align_of::<if_lim_perf_stat>(),
        4usize,
        concat!("Alignment of ", stringify!(if_lim_perf_stat))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_dl_max_bandwidth) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_dl_max_bandwidth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_ul_max_bandwidth) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_ul_max_bandwidth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_total_txpkts) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_total_txpkts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_total_rxpkts) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_total_rxpkts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_total_retxpkts) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_total_retxpkts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_packet_loss_percent) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_packet_loss_percent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_total_oopkts) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_total_oopkts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_packet_ooo_percent) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_packet_ooo_percent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_rtt_variance) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_rtt_variance)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_rtt_average) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_rtt_average)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_rtt_min) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_rtt_min)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_conn_timeouts) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_conn_timeouts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_conn_attempts) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_conn_attempts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_conn_timeout_percent) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_conn_timeout_percent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lim_bk_txpkts) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(if_lim_perf_stat),
            "::",
            stringify!(lim_bk_txpkts)
        )
    );
}
impl if_lim_perf_stat {
    #[inline]
    pub fn lim_dl_detected(&self) -> u_int64_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u64) }
    }

    #[inline]
    pub fn set_lim_dl_detected(&mut self, val: u_int64_t) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn lim_ul_detected(&self) -> u_int64_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u64) }
    }

    #[inline]
    pub fn set_lim_ul_detected(&mut self, val: u_int64_t) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn new_bitfield_1(
        lim_dl_detected: u_int64_t,
        lim_ul_detected: u_int64_t,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let lim_dl_detected: u64 = unsafe { ::std::mem::transmute(lim_dl_detected) };
            lim_dl_detected as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let lim_ul_detected: u64 = unsafe { ::std::mem::transmute(lim_ul_detected) };
            lim_ul_detected as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct ifnet_stats_per_flow {
    pub bk_txpackets: u_int64_t,
    pub txpackets: u_int64_t,
    pub rxpackets: u_int64_t,
    pub txretransmitbytes: u_int32_t,
    pub rxoutoforderbytes: u_int32_t,
    pub rxmitpkts: u_int32_t,
    pub rcvoopack: u_int32_t,
    pub pawsdrop: u_int32_t,
    pub sack_recovery_episodes: u_int32_t,
    pub reordered_pkts: u_int32_t,
    pub dsack_sent: u_int32_t,
    pub dsack_recvd: u_int32_t,
    pub srtt: u_int32_t,
    pub rttupdated: u_int32_t,
    pub rttvar: u_int32_t,
    pub rttmin: u_int32_t,
    pub bw_sndbw_max: u_int32_t,
    pub bw_rcvbw_max: u_int32_t,
    pub ecn_recv_ece: u_int32_t,
    pub ecn_recv_ce: u_int32_t,
    pub ecn_flags: u_int16_t,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout_ifnet_stats_per_flow() {
    const UNINIT: ::std::mem::MaybeUninit<ifnet_stats_per_flow> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ifnet_stats_per_flow>(),
        96usize,
        concat!("Size of: ", stringify!(ifnet_stats_per_flow))
    );
    assert_eq!(
        ::std::mem::align_of::<ifnet_stats_per_flow>(),
        4usize,
        concat!("Alignment of ", stringify!(ifnet_stats_per_flow))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bk_txpackets) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(bk_txpackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).txpackets) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(txpackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rxpackets) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(rxpackets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).txretransmitbytes) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(txretransmitbytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rxoutoforderbytes) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(rxoutoforderbytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rxmitpkts) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(rxmitpkts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rcvoopack) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(rcvoopack)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pawsdrop) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(pawsdrop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sack_recovery_episodes) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(sack_recovery_episodes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reordered_pkts) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(reordered_pkts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dsack_sent) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(dsack_sent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dsack_recvd) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(dsack_recvd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).srtt) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(srtt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rttupdated) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(rttupdated)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rttvar) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(rttvar)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rttmin) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(rttmin)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bw_sndbw_max) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(bw_sndbw_max)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bw_rcvbw_max) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(bw_rcvbw_max)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_recv_ece) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(ecn_recv_ece)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_recv_ce) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(ecn_recv_ce)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ecn_flags) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_stats_per_flow),
            "::",
            stringify!(ecn_flags)
        )
    );
}
impl ifnet_stats_per_flow {
    #[inline]
    pub fn ipv4(&self) -> u_int16_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set_ipv4(&mut self, val: u_int16_t) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn local(&self) -> u_int16_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set_local(&mut self, val: u_int16_t) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn connreset(&self) -> u_int16_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set_connreset(&mut self, val: u_int16_t) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn conntimeout(&self) -> u_int16_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set_conntimeout(&mut self, val: u_int16_t) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn rxmit_drop(&self) -> u_int16_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set_rxmit_drop(&mut self, val: u_int16_t) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn ecn_fallback_synloss(&self) -> u_int16_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set_ecn_fallback_synloss(&mut self, val: u_int16_t) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn ecn_fallback_droprst(&self) -> u_int16_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set_ecn_fallback_droprst(&mut self, val: u_int16_t) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn ecn_fallback_droprxmt(&self) -> u_int16_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set_ecn_fallback_droprxmt(&mut self, val: u_int16_t) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn ecn_fallback_ce(&self) -> u_int16_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set_ecn_fallback_ce(&mut self, val: u_int16_t) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn ecn_fallback_reorder(&self) -> u_int16_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u16) }
    }

    #[inline]
    pub fn set_ecn_fallback_reorder(&mut self, val: u_int16_t) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }

    #[inline]
    pub fn new_bitfield_1(
        ipv4: u_int16_t,
        local: u_int16_t,
        connreset: u_int16_t,
        conntimeout: u_int16_t,
        rxmit_drop: u_int16_t,
        ecn_fallback_synloss: u_int16_t,
        ecn_fallback_droprst: u_int16_t,
        ecn_fallback_droprxmt: u_int16_t,
        ecn_fallback_ce: u_int16_t,
        ecn_fallback_reorder: u_int16_t,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let ipv4: u16 = unsafe { ::std::mem::transmute(ipv4) };
            ipv4 as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let local: u16 = unsafe { ::std::mem::transmute(local) };
            local as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let connreset: u16 = unsafe { ::std::mem::transmute(connreset) };
            connreset as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let conntimeout: u16 = unsafe { ::std::mem::transmute(conntimeout) };
            conntimeout as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let rxmit_drop: u16 = unsafe { ::std::mem::transmute(rxmit_drop) };
            rxmit_drop as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let ecn_fallback_synloss: u16 = unsafe { ::std::mem::transmute(ecn_fallback_synloss) };
            ecn_fallback_synloss as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let ecn_fallback_droprst: u16 = unsafe { ::std::mem::transmute(ecn_fallback_droprst) };
            ecn_fallback_droprst as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let ecn_fallback_droprxmt: u16 = unsafe { ::std::mem::transmute(ecn_fallback_droprxmt) };
            ecn_fallback_droprxmt as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let ecn_fallback_ce: u16 = unsafe { ::std::mem::transmute(ecn_fallback_ce) };
            ecn_fallback_ce as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let ecn_fallback_reorder: u16 = unsafe { ::std::mem::transmute(ecn_fallback_reorder) };
            ecn_fallback_reorder as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct if_cellular_status_v1 {
    pub valid_bitmask: u_int32_t,
    pub link_quality_metric: u_int32_t,
    pub ul_effective_bandwidth: u_int32_t,
    pub ul_max_bandwidth: u_int32_t,
    pub ul_min_latency: u_int32_t,
    pub ul_effective_latency: u_int32_t,
    pub ul_max_latency: u_int32_t,
    pub ul_retxt_level: u_int32_t,
    pub ul_bytes_lost: u_int32_t,
    pub ul_min_queue_size: u_int32_t,
    pub ul_avg_queue_size: u_int32_t,
    pub ul_max_queue_size: u_int32_t,
    pub dl_effective_bandwidth: u_int32_t,
    pub dl_max_bandwidth: u_int32_t,
    pub config_inactivity_time: u_int32_t,
    pub config_backoff_time: u_int32_t,
    pub mss_recommended: u_int16_t,
    pub reserved_1: u_int16_t,
    pub reserved_2: u_int32_t,
    pub reserved_3: u_int64_t,
    pub reserved_4: u_int64_t,
    pub reserved_5: u_int64_t,
    pub reserved_6: u_int64_t,
}
#[test]
fn bindgen_test_layout_if_cellular_status_v1() {
    const UNINIT: ::std::mem::MaybeUninit<if_cellular_status_v1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_cellular_status_v1>(),
        104usize,
        concat!("Size of: ", stringify!(if_cellular_status_v1))
    );
    assert_eq!(
        ::std::mem::align_of::<if_cellular_status_v1>(),
        1usize,
        concat!("Alignment of ", stringify!(if_cellular_status_v1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).valid_bitmask) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(valid_bitmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).link_quality_metric) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(link_quality_metric)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_effective_bandwidth) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(ul_effective_bandwidth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_max_bandwidth) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(ul_max_bandwidth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_min_latency) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(ul_min_latency)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_effective_latency) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(ul_effective_latency)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_max_latency) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(ul_max_latency)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_retxt_level) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(ul_retxt_level)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_bytes_lost) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(ul_bytes_lost)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_min_queue_size) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(ul_min_queue_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_avg_queue_size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(ul_avg_queue_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_max_queue_size) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(ul_max_queue_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dl_effective_bandwidth) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(dl_effective_bandwidth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dl_max_bandwidth) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(dl_max_bandwidth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).config_inactivity_time) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(config_inactivity_time)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).config_backoff_time) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(config_backoff_time)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mss_recommended) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(mss_recommended)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_1) as usize - ptr as usize },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(reserved_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_2) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(reserved_2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_3) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(reserved_3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_4) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(reserved_4)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_5) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(reserved_5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_6) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status_v1),
            "::",
            stringify!(reserved_6)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct if_cellular_status {
    pub if_cell_u: if_cellular_status__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union if_cellular_status__bindgen_ty_1 {
    pub if_status_v1: if_cellular_status_v1,
}
#[test]
fn bindgen_test_layout_if_cellular_status__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<if_cellular_status__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_cellular_status__bindgen_ty_1>(),
        104usize,
        concat!("Size of: ", stringify!(if_cellular_status__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<if_cellular_status__bindgen_ty_1>(),
        1usize,
        concat!("Alignment of ", stringify!(if_cellular_status__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).if_status_v1) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status__bindgen_ty_1),
            "::",
            stringify!(if_status_v1)
        )
    );
}
#[test]
fn bindgen_test_layout_if_cellular_status() {
    const UNINIT: ::std::mem::MaybeUninit<if_cellular_status> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_cellular_status>(),
        104usize,
        concat!("Size of: ", stringify!(if_cellular_status))
    );
    assert_eq!(
        ::std::mem::align_of::<if_cellular_status>(),
        1usize,
        concat!("Alignment of ", stringify!(if_cellular_status))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).if_cell_u) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_cellular_status),
            "::",
            stringify!(if_cell_u)
        )
    );
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct if_wifi_status_v1 {
    pub valid_bitmask: u_int32_t,
    pub link_quality_metric: u_int32_t,
    pub ul_effective_bandwidth: u_int32_t,
    pub ul_max_bandwidth: u_int32_t,
    pub ul_min_latency: u_int32_t,
    pub ul_effective_latency: u_int32_t,
    pub ul_max_latency: u_int32_t,
    pub ul_retxt_level: u_int32_t,
    pub ul_bytes_lost: u_int32_t,
    pub ul_error_rate: u_int32_t,
    pub dl_effective_bandwidth: u_int32_t,
    pub dl_max_bandwidth: u_int32_t,
    pub dl_min_latency: u_int32_t,
    pub dl_effective_latency: u_int32_t,
    pub dl_max_latency: u_int32_t,
    pub dl_error_rate: u_int32_t,
    pub config_frequency: u_int32_t,
    pub config_multicast_rate: u_int32_t,
    pub scan_count: u_int32_t,
    pub scan_duration: u_int32_t,
    pub reserved_1: u_int64_t,
    pub reserved_2: u_int64_t,
    pub reserved_3: u_int64_t,
    pub reserved_4: u_int64_t,
}
#[test]
fn bindgen_test_layout_if_wifi_status_v1() {
    const UNINIT: ::std::mem::MaybeUninit<if_wifi_status_v1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_wifi_status_v1>(),
        112usize,
        concat!("Size of: ", stringify!(if_wifi_status_v1))
    );
    assert_eq!(
        ::std::mem::align_of::<if_wifi_status_v1>(),
        1usize,
        concat!("Alignment of ", stringify!(if_wifi_status_v1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).valid_bitmask) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(valid_bitmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).link_quality_metric) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(link_quality_metric)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_effective_bandwidth) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(ul_effective_bandwidth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_max_bandwidth) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(ul_max_bandwidth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_min_latency) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(ul_min_latency)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_effective_latency) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(ul_effective_latency)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_max_latency) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(ul_max_latency)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_retxt_level) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(ul_retxt_level)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_bytes_lost) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(ul_bytes_lost)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ul_error_rate) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(ul_error_rate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dl_effective_bandwidth) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(dl_effective_bandwidth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dl_max_bandwidth) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(dl_max_bandwidth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dl_min_latency) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(dl_min_latency)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dl_effective_latency) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(dl_effective_latency)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dl_max_latency) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(dl_max_latency)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dl_error_rate) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(dl_error_rate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).config_frequency) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(config_frequency)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).config_multicast_rate) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(config_multicast_rate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scan_count) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(scan_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scan_duration) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(scan_duration)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_1) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(reserved_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_2) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(reserved_2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_3) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(reserved_3)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_4) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status_v1),
            "::",
            stringify!(reserved_4)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct if_wifi_status {
    pub if_wifi_u: if_wifi_status__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union if_wifi_status__bindgen_ty_1 {
    pub if_status_v1: if_wifi_status_v1,
}
#[test]
fn bindgen_test_layout_if_wifi_status__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<if_wifi_status__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_wifi_status__bindgen_ty_1>(),
        112usize,
        concat!("Size of: ", stringify!(if_wifi_status__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<if_wifi_status__bindgen_ty_1>(),
        1usize,
        concat!("Alignment of ", stringify!(if_wifi_status__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).if_status_v1) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status__bindgen_ty_1),
            "::",
            stringify!(if_status_v1)
        )
    );
}
#[test]
fn bindgen_test_layout_if_wifi_status() {
    const UNINIT: ::std::mem::MaybeUninit<if_wifi_status> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_wifi_status>(),
        112usize,
        concat!("Size of: ", stringify!(if_wifi_status))
    );
    assert_eq!(
        ::std::mem::align_of::<if_wifi_status>(),
        1usize,
        concat!("Alignment of ", stringify!(if_wifi_status))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).if_wifi_u) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_wifi_status),
            "::",
            stringify!(if_wifi_u)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct if_link_status {
    pub ifsr_version: u_int32_t,
    pub ifsr_len: u_int32_t,
    pub ifsr_u: if_link_status__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union if_link_status__bindgen_ty_1 {
    pub ifsr_cell: if_cellular_status,
    pub ifsr_wifi: if_wifi_status,
}
#[test]
fn bindgen_test_layout_if_link_status__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<if_link_status__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_link_status__bindgen_ty_1>(),
        112usize,
        concat!("Size of: ", stringify!(if_link_status__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<if_link_status__bindgen_ty_1>(),
        1usize,
        concat!("Alignment of ", stringify!(if_link_status__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifsr_cell) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_link_status__bindgen_ty_1),
            "::",
            stringify!(ifsr_cell)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifsr_wifi) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_link_status__bindgen_ty_1),
            "::",
            stringify!(ifsr_wifi)
        )
    );
}
#[test]
fn bindgen_test_layout_if_link_status() {
    const UNINIT: ::std::mem::MaybeUninit<if_link_status> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_link_status>(),
        120usize,
        concat!("Size of: ", stringify!(if_link_status))
    );
    assert_eq!(
        ::std::mem::align_of::<if_link_status>(),
        4usize,
        concat!("Alignment of ", stringify!(if_link_status))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifsr_version) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_link_status),
            "::",
            stringify!(ifsr_version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifsr_len) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(if_link_status),
            "::",
            stringify!(ifsr_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifsr_u) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(if_link_status),
            "::",
            stringify!(ifsr_u)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct if_interface_state {
    pub valid_bitmask: u_int8_t,
    pub rrc_state: u_int8_t,
    pub lqm_state: i8,
    pub interface_availability: u_int8_t,
}
#[test]
fn bindgen_test_layout_if_interface_state() {
    const UNINIT: ::std::mem::MaybeUninit<if_interface_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<if_interface_state>(),
        4usize,
        concat!("Size of: ", stringify!(if_interface_state))
    );
    assert_eq!(
        ::std::mem::align_of::<if_interface_state>(),
        1usize,
        concat!("Alignment of ", stringify!(if_interface_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).valid_bitmask) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(if_interface_state),
            "::",
            stringify!(valid_bitmask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rrc_state) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(if_interface_state),
            "::",
            stringify!(rrc_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lqm_state) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(if_interface_state),
            "::",
            stringify!(lqm_state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).interface_availability) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(if_interface_state),
            "::",
            stringify!(interface_availability)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct chain_len_stats {
    pub cls_one: u64,
    pub cls_two: u64,
    pub cls_three: u64,
    pub cls_four: u64,
    pub cls_five_or_more: u64,
}
#[test]
fn bindgen_test_layout_chain_len_stats() {
    const UNINIT: ::std::mem::MaybeUninit<chain_len_stats> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<chain_len_stats>(),
        40usize,
        concat!("Size of: ", stringify!(chain_len_stats))
    );
    assert_eq!(
        ::std::mem::align_of::<chain_len_stats>(),
        8usize,
        concat!("Alignment of ", stringify!(chain_len_stats))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cls_one) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(chain_len_stats),
            "::",
            stringify!(cls_one)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cls_two) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(chain_len_stats),
            "::",
            stringify!(cls_two)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cls_three) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(chain_len_stats),
            "::",
            stringify!(cls_three)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cls_four) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(chain_len_stats),
            "::",
            stringify!(cls_four)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cls_five_or_more) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(chain_len_stats),
            "::",
            stringify!(cls_five_or_more)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifnet_interface_advisory {
    pub version: u8,
    pub direction: u8,
    pub _reserved: u16,
    pub rate_trend_suggestion: i32,
    pub timestamp: u64,
    pub max_bandwidth: u64,
    pub total_byte_count: u64,
    pub average_throughput: u64,
    pub flushable_queue_size: u32,
    pub non_flushable_queue_size: u32,
    pub average_delay: u32,
}
#[test]
fn bindgen_test_layout_ifnet_interface_advisory() {
    const UNINIT: ::std::mem::MaybeUninit<ifnet_interface_advisory> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ifnet_interface_advisory>(),
        56usize,
        concat!("Size of: ", stringify!(ifnet_interface_advisory))
    );
    assert_eq!(
        ::std::mem::align_of::<ifnet_interface_advisory>(),
        8usize,
        concat!("Alignment of ", stringify!(ifnet_interface_advisory))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_interface_advisory),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).direction) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_interface_advisory),
            "::",
            stringify!(direction)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._reserved) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_interface_advisory),
            "::",
            stringify!(_reserved)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rate_trend_suggestion) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_interface_advisory),
            "::",
            stringify!(rate_trend_suggestion)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timestamp) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_interface_advisory),
            "::",
            stringify!(timestamp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_bandwidth) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_interface_advisory),
            "::",
            stringify!(max_bandwidth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).total_byte_count) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_interface_advisory),
            "::",
            stringify!(total_byte_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).average_throughput) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_interface_advisory),
            "::",
            stringify!(average_throughput)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flushable_queue_size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_interface_advisory),
            "::",
            stringify!(flushable_queue_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).non_flushable_queue_size) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_interface_advisory),
            "::",
            stringify!(non_flushable_queue_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).average_delay) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ifnet_interface_advisory),
            "::",
            stringify!(average_delay)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ifqueue {
    pub ifq_head: *mut ::std::os::raw::c_void,
    pub ifq_tail: *mut ::std::os::raw::c_void,
    pub ifq_len: ::std::os::raw::c_int,
    pub ifq_maxlen: ::std::os::raw::c_int,
    pub ifq_drops: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_ifqueue() {
    const UNINIT: ::std::mem::MaybeUninit<ifqueue> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ifqueue>(),
        32usize,
        concat!("Size of: ", stringify!(ifqueue))
    );
    assert_eq!(
        ::std::mem::align_of::<ifqueue>(),
        8usize,
        concat!("Alignment of ", stringify!(ifqueue))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifq_head) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(ifqueue), "::", stringify!(ifq_head))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifq_tail) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(ifqueue), "::", stringify!(ifq_tail))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifq_len) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(ifqueue), "::", stringify!(ifq_len))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifq_maxlen) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(ifqueue), "::", stringify!(ifq_maxlen))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifq_drops) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(ifqueue), "::", stringify!(ifq_drops))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sockaddr_union {
    pub sa: sockaddr,
    pub sin: sockaddr_in,
    pub sin6: sockaddr_in6,
}
#[test]
fn bindgen_test_layout_sockaddr_union() {
    const UNINIT: ::std::mem::MaybeUninit<sockaddr_union> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sockaddr_union>(),
        28usize,
        concat!("Size of: ", stringify!(sockaddr_union))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_union>(),
        4usize,
        concat!("Alignment of ", stringify!(sockaddr_union))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sa) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sockaddr_union), "::", stringify!(sa))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sockaddr_union), "::", stringify!(sin))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sin6) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(sockaddr_union), "::", stringify!(sin6))
    );
}
pub const PF_INOUT: _bindgen_ty_1 = 0;
pub const PF_IN: _bindgen_ty_1 = 1;
pub const PF_OUT: _bindgen_ty_1 = 2;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
pub const PF_PASS: _bindgen_ty_2 = 0;
pub const PF_DROP: _bindgen_ty_2 = 1;
pub const PF_SCRUB: _bindgen_ty_2 = 2;
pub const PF_NOSCRUB: _bindgen_ty_2 = 3;
pub const PF_NAT: _bindgen_ty_2 = 4;
pub const PF_NONAT: _bindgen_ty_2 = 5;
pub const PF_BINAT: _bindgen_ty_2 = 6;
pub const PF_NOBINAT: _bindgen_ty_2 = 7;
pub const PF_RDR: _bindgen_ty_2 = 8;
pub const PF_NORDR: _bindgen_ty_2 = 9;
pub const PF_SYNPROXY_DROP: _bindgen_ty_2 = 10;
pub const PF_DUMMYNET: _bindgen_ty_2 = 11;
pub const PF_NODUMMYNET: _bindgen_ty_2 = 12;
pub const PF_NAT64: _bindgen_ty_2 = 13;
pub const PF_NONAT64: _bindgen_ty_2 = 14;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
pub const PF_RULESET_SCRUB: _bindgen_ty_3 = 0;
pub const PF_RULESET_FILTER: _bindgen_ty_3 = 1;
pub const PF_RULESET_NAT: _bindgen_ty_3 = 2;
pub const PF_RULESET_BINAT: _bindgen_ty_3 = 3;
pub const PF_RULESET_RDR: _bindgen_ty_3 = 4;
pub const PF_RULESET_DUMMYNET: _bindgen_ty_3 = 5;
pub const PF_RULESET_MAX: _bindgen_ty_3 = 6;
pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
pub const PF_OP_NONE: _bindgen_ty_4 = 0;
pub const PF_OP_IRG: _bindgen_ty_4 = 1;
pub const PF_OP_EQ: _bindgen_ty_4 = 2;
pub const PF_OP_NE: _bindgen_ty_4 = 3;
pub const PF_OP_LT: _bindgen_ty_4 = 4;
pub const PF_OP_LE: _bindgen_ty_4 = 5;
pub const PF_OP_GT: _bindgen_ty_4 = 6;
pub const PF_OP_GE: _bindgen_ty_4 = 7;
pub const PF_OP_XRG: _bindgen_ty_4 = 8;
pub const PF_OP_RRG: _bindgen_ty_4 = 9;
pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
pub const PF_DEBUG_NONE: _bindgen_ty_5 = 0;
pub const PF_DEBUG_URGENT: _bindgen_ty_5 = 1;
pub const PF_DEBUG_MISC: _bindgen_ty_5 = 2;
pub const PF_DEBUG_NOISY: _bindgen_ty_5 = 3;
pub type _bindgen_ty_5 = ::std::os::raw::c_uint;
pub const PF_CHANGE_NONE: _bindgen_ty_6 = 0;
pub const PF_CHANGE_ADD_HEAD: _bindgen_ty_6 = 1;
pub const PF_CHANGE_ADD_TAIL: _bindgen_ty_6 = 2;
pub const PF_CHANGE_ADD_BEFORE: _bindgen_ty_6 = 3;
pub const PF_CHANGE_ADD_AFTER: _bindgen_ty_6 = 4;
pub const PF_CHANGE_REMOVE: _bindgen_ty_6 = 5;
pub const PF_CHANGE_GET_TICKET: _bindgen_ty_6 = 6;
pub type _bindgen_ty_6 = ::std::os::raw::c_uint;
pub const PF_GET_NONE: _bindgen_ty_7 = 0;
pub const PF_GET_CLR_CNTR: _bindgen_ty_7 = 1;
pub type _bindgen_ty_7 = ::std::os::raw::c_uint;
pub const PFTM_TCP_FIRST_PACKET: _bindgen_ty_8 = 0;
pub const PFTM_TCP_OPENING: _bindgen_ty_8 = 1;
pub const PFTM_TCP_ESTABLISHED: _bindgen_ty_8 = 2;
pub const PFTM_TCP_CLOSING: _bindgen_ty_8 = 3;
pub const PFTM_TCP_FIN_WAIT: _bindgen_ty_8 = 4;
pub const PFTM_TCP_CLOSED: _bindgen_ty_8 = 5;
pub const PFTM_UDP_FIRST_PACKET: _bindgen_ty_8 = 6;
pub const PFTM_UDP_SINGLE: _bindgen_ty_8 = 7;
pub const PFTM_UDP_MULTIPLE: _bindgen_ty_8 = 8;
pub const PFTM_ICMP_FIRST_PACKET: _bindgen_ty_8 = 9;
pub const PFTM_ICMP_ERROR_REPLY: _bindgen_ty_8 = 10;
pub const PFTM_GREv1_FIRST_PACKET: _bindgen_ty_8 = 11;
pub const PFTM_GREv1_INITIATING: _bindgen_ty_8 = 12;
pub const PFTM_GREv1_ESTABLISHED: _bindgen_ty_8 = 13;
pub const PFTM_ESP_FIRST_PACKET: _bindgen_ty_8 = 14;
pub const PFTM_ESP_INITIATING: _bindgen_ty_8 = 15;
pub const PFTM_ESP_ESTABLISHED: _bindgen_ty_8 = 16;
pub const PFTM_OTHER_FIRST_PACKET: _bindgen_ty_8 = 17;
pub const PFTM_OTHER_SINGLE: _bindgen_ty_8 = 18;
pub const PFTM_OTHER_MULTIPLE: _bindgen_ty_8 = 19;
pub const PFTM_FRAG: _bindgen_ty_8 = 20;
pub const PFTM_INTERVAL: _bindgen_ty_8 = 21;
pub const PFTM_ADAPTIVE_START: _bindgen_ty_8 = 22;
pub const PFTM_ADAPTIVE_END: _bindgen_ty_8 = 23;
pub const PFTM_SRC_NODE: _bindgen_ty_8 = 24;
pub const PFTM_TS_DIFF: _bindgen_ty_8 = 25;
pub const PFTM_MAX: _bindgen_ty_8 = 26;
pub const PFTM_PURGE: _bindgen_ty_8 = 27;
pub const PFTM_UNLINKED: _bindgen_ty_8 = 28;
pub type _bindgen_ty_8 = ::std::os::raw::c_uint;
pub const PF_NOPFROUTE: _bindgen_ty_9 = 0;
pub const PF_FASTROUTE: _bindgen_ty_9 = 1;
pub const PF_ROUTETO: _bindgen_ty_9 = 2;
pub const PF_DUPTO: _bindgen_ty_9 = 3;
pub const PF_REPLYTO: _bindgen_ty_9 = 4;
pub type _bindgen_ty_9 = ::std::os::raw::c_uint;
pub const PF_LIMIT_STATES: _bindgen_ty_10 = 0;
pub const PF_LIMIT_APP_STATES: _bindgen_ty_10 = 1;
pub const PF_LIMIT_SRC_NODES: _bindgen_ty_10 = 2;
pub const PF_LIMIT_FRAGS: _bindgen_ty_10 = 3;
pub const PF_LIMIT_TABLES: _bindgen_ty_10 = 4;
pub const PF_LIMIT_TABLE_ENTRIES: _bindgen_ty_10 = 5;
pub const PF_LIMIT_MAX: _bindgen_ty_10 = 6;
pub type _bindgen_ty_10 = ::std::os::raw::c_uint;
pub const PF_POOL_NONE: _bindgen_ty_11 = 0;
pub const PF_POOL_BITMASK: _bindgen_ty_11 = 1;
pub const PF_POOL_RANDOM: _bindgen_ty_11 = 2;
pub const PF_POOL_SRCHASH: _bindgen_ty_11 = 3;
pub const PF_POOL_ROUNDROBIN: _bindgen_ty_11 = 4;
pub type _bindgen_ty_11 = ::std::os::raw::c_uint;
pub const PF_ADDR_ADDRMASK: _bindgen_ty_12 = 0;
pub const PF_ADDR_NOROUTE: _bindgen_ty_12 = 1;
pub const PF_ADDR_DYNIFTL: _bindgen_ty_12 = 2;
pub const PF_ADDR_TABLE: _bindgen_ty_12 = 3;
pub const PF_ADDR_RTLABEL: _bindgen_ty_12 = 4;
pub const PF_ADDR_URPFFAILED: _bindgen_ty_12 = 5;
pub const PF_ADDR_RANGE: _bindgen_ty_12 = 6;
pub type _bindgen_ty_12 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pf_addr {
    pub pfa: pf_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pf_addr__bindgen_ty_1 {
    pub _v4addr: in_addr,
    pub _v6addr: in6_addr,
    pub _addr8: [u_int8_t; 16usize],
    pub _addr16: [u_int16_t; 8usize],
    pub _addr32: [u_int32_t; 4usize],
}
#[test]
fn bindgen_test_layout_pf_addr__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_addr__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_addr__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(pf_addr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_addr__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_addr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._v4addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr__bindgen_ty_1),
            "::",
            stringify!(_v4addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._v6addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr__bindgen_ty_1),
            "::",
            stringify!(_v6addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._addr8) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr__bindgen_ty_1),
            "::",
            stringify!(_addr8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._addr16) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr__bindgen_ty_1),
            "::",
            stringify!(_addr16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._addr32) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr__bindgen_ty_1),
            "::",
            stringify!(_addr32)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_addr() {
    const UNINIT: ::std::mem::MaybeUninit<pf_addr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_addr>(),
        16usize,
        concat!("Size of: ", stringify!(pf_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_addr>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfa) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_addr), "::", stringify!(pfa))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pf_addr_wrap {
    pub v: pf_addr_wrap__bindgen_ty_1,
    pub p: pf_addr_wrap__bindgen_ty_2,
    pub type_: u_int8_t,
    pub iflags: u_int8_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pf_addr_wrap__bindgen_ty_1 {
    pub a: pf_addr_wrap__bindgen_ty_1__bindgen_ty_1,
    pub ifname: [::std::os::raw::c_char; 16usize],
    pub tblname: [::std::os::raw::c_char; 32usize],
    pub rtlabelname: [::std::os::raw::c_char; 32usize],
    pub rtlabel: u_int32_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pf_addr_wrap__bindgen_ty_1__bindgen_ty_1 {
    pub addr: pf_addr,
    pub mask: pf_addr,
}
#[test]
fn bindgen_test_layout_pf_addr_wrap__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_addr_wrap__bindgen_ty_1__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_addr_wrap__bindgen_ty_1__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(pf_addr_wrap__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_addr_wrap__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_addr_wrap__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr_wrap__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mask) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr_wrap__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(mask)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_addr_wrap__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_addr_wrap__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_addr_wrap__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(pf_addr_wrap__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_addr_wrap__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_addr_wrap__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).a) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr_wrap__bindgen_ty_1),
            "::",
            stringify!(a)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifname) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr_wrap__bindgen_ty_1),
            "::",
            stringify!(ifname)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tblname) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr_wrap__bindgen_ty_1),
            "::",
            stringify!(tblname)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtlabelname) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr_wrap__bindgen_ty_1),
            "::",
            stringify!(rtlabelname)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtlabel) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr_wrap__bindgen_ty_1),
            "::",
            stringify!(rtlabel)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pf_addr_wrap__bindgen_ty_2 {
    pub dyn_: *mut ::std::os::raw::c_void,
    pub tbl: *mut ::std::os::raw::c_void,
    pub dyncnt: ::std::os::raw::c_int,
    pub tblcnt: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pf_addr_wrap__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<pf_addr_wrap__bindgen_ty_2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_addr_wrap__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(pf_addr_wrap__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_addr_wrap__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_addr_wrap__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dyn_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr_wrap__bindgen_ty_2),
            "::",
            stringify!(dyn_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tbl) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr_wrap__bindgen_ty_2),
            "::",
            stringify!(tbl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dyncnt) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr_wrap__bindgen_ty_2),
            "::",
            stringify!(dyncnt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tblcnt) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_addr_wrap__bindgen_ty_2),
            "::",
            stringify!(tblcnt)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_addr_wrap() {
    const UNINIT: ::std::mem::MaybeUninit<pf_addr_wrap> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_addr_wrap>(),
        48usize,
        concat!("Size of: ", stringify!(pf_addr_wrap))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_addr_wrap>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_addr_wrap))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_addr_wrap), "::", stringify!(v))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).p) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(pf_addr_wrap), "::", stringify!(p))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(pf_addr_wrap), "::", stringify!(type_))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).iflags) as usize - ptr as usize },
        41usize,
        concat!("Offset of field: ", stringify!(pf_addr_wrap), "::", stringify!(iflags))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_port_range {
    pub port: [u_int16_t; 2usize],
    pub op: u_int8_t,
}
#[test]
fn bindgen_test_layout_pf_port_range() {
    const UNINIT: ::std::mem::MaybeUninit<pf_port_range> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_port_range>(),
        6usize,
        concat!("Size of: ", stringify!(pf_port_range))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_port_range>(),
        2usize,
        concat!("Alignment of ", stringify!(pf_port_range))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_port_range), "::", stringify!(port))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).op) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(pf_port_range), "::", stringify!(op))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pf_rule_xport {
    pub range: pf_port_range,
    pub call_id: u_int16_t,
    pub spi: u_int32_t,
}
#[test]
fn bindgen_test_layout_pf_rule_xport() {
    const UNINIT: ::std::mem::MaybeUninit<pf_rule_xport> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_rule_xport>(),
        8usize,
        concat!("Size of: ", stringify!(pf_rule_xport))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_rule_xport>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_rule_xport))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).range) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_rule_xport), "::", stringify!(range))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).call_id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule_xport),
            "::",
            stringify!(call_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).spi) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_rule_xport), "::", stringify!(spi))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_rule_uid {
    pub uid: [uid_t; 2usize],
    pub op: u_int8_t,
    pub _pad: [u_int8_t; 3usize],
}
#[test]
fn bindgen_test_layout_pf_rule_uid() {
    const UNINIT: ::std::mem::MaybeUninit<pf_rule_uid> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_rule_uid>(),
        12usize,
        concat!("Size of: ", stringify!(pf_rule_uid))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_rule_uid>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_rule_uid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uid) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_rule_uid), "::", stringify!(uid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).op) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(pf_rule_uid), "::", stringify!(op))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._pad) as usize - ptr as usize },
        9usize,
        concat!("Offset of field: ", stringify!(pf_rule_uid), "::", stringify!(_pad))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_rule_gid {
    pub gid: [uid_t; 2usize],
    pub op: u_int8_t,
    pub _pad: [u_int8_t; 3usize],
}
#[test]
fn bindgen_test_layout_pf_rule_gid() {
    const UNINIT: ::std::mem::MaybeUninit<pf_rule_gid> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_rule_gid>(),
        12usize,
        concat!("Size of: ", stringify!(pf_rule_gid))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_rule_gid>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_rule_gid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gid) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_rule_gid), "::", stringify!(gid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).op) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(pf_rule_gid), "::", stringify!(op))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._pad) as usize - ptr as usize },
        9usize,
        concat!("Offset of field: ", stringify!(pf_rule_gid), "::", stringify!(_pad))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pf_rule_addr {
    pub addr: pf_addr_wrap,
    pub xport: pf_rule_xport,
    pub neg: u_int8_t,
}
#[test]
fn bindgen_test_layout_pf_rule_addr() {
    const UNINIT: ::std::mem::MaybeUninit<pf_rule_addr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_rule_addr>(),
        64usize,
        concat!("Size of: ", stringify!(pf_rule_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_rule_addr>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_rule_addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_rule_addr), "::", stringify!(addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xport) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(pf_rule_addr), "::", stringify!(xport))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).neg) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(pf_rule_addr), "::", stringify!(neg))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pf_pooladdr {
    pub addr: pf_addr_wrap,
    pub entries: pf_pooladdr__bindgen_ty_1,
    pub ifname: [::std::os::raw::c_char; 16usize],
    pub kif: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_pooladdr__bindgen_ty_1 {
    pub tqe_next: *mut pf_pooladdr,
    pub tqe_prev: *mut *mut pf_pooladdr,
}
#[test]
fn bindgen_test_layout_pf_pooladdr__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_pooladdr__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_pooladdr__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(pf_pooladdr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_pooladdr__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_pooladdr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_pooladdr__bindgen_ty_1),
            "::",
            stringify!(tqe_next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_prev) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_pooladdr__bindgen_ty_1),
            "::",
            stringify!(tqe_prev)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_pooladdr() {
    const UNINIT: ::std::mem::MaybeUninit<pf_pooladdr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_pooladdr>(),
        88usize,
        concat!("Size of: ", stringify!(pf_pooladdr))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_pooladdr>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_pooladdr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_pooladdr), "::", stringify!(addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(pf_pooladdr), "::", stringify!(entries))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifname) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(pf_pooladdr), "::", stringify!(ifname))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kif) as usize - ptr as usize },
        80usize,
        concat!("Offset of field: ", stringify!(pf_pooladdr), "::", stringify!(kif))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_palist {
    pub tqh_first: *mut pf_pooladdr,
    pub tqh_last: *mut *mut pf_pooladdr,
}
#[test]
fn bindgen_test_layout_pf_palist() {
    const UNINIT: ::std::mem::MaybeUninit<pf_palist> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_palist>(),
        16usize,
        concat!("Size of: ", stringify!(pf_palist))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_palist>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_palist))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqh_first) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_palist), "::", stringify!(tqh_first))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqh_last) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(pf_palist), "::", stringify!(tqh_last))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pf_poolhashkey {
    pub pfk: pf_poolhashkey__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pf_poolhashkey__bindgen_ty_1 {
    pub key8: [u_int8_t; 16usize],
    pub key16: [u_int16_t; 8usize],
    pub key32: [u_int32_t; 4usize],
}
#[test]
fn bindgen_test_layout_pf_poolhashkey__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_poolhashkey__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_poolhashkey__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(pf_poolhashkey__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_poolhashkey__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_poolhashkey__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key8) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_poolhashkey__bindgen_ty_1),
            "::",
            stringify!(key8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key16) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_poolhashkey__bindgen_ty_1),
            "::",
            stringify!(key16)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key32) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_poolhashkey__bindgen_ty_1),
            "::",
            stringify!(key32)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_poolhashkey() {
    const UNINIT: ::std::mem::MaybeUninit<pf_poolhashkey> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_poolhashkey>(),
        16usize,
        concat!("Size of: ", stringify!(pf_poolhashkey))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_poolhashkey>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_poolhashkey))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfk) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_poolhashkey), "::", stringify!(pfk))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pf_pool {
    pub list: pf_palist,
    pub cur: *mut ::std::os::raw::c_void,
    pub key: pf_poolhashkey,
    pub counter: pf_addr,
    pub tblidx: ::std::os::raw::c_int,
    pub proxy_port: [u_int16_t; 2usize],
    pub port_op: u_int8_t,
    pub opts: u_int8_t,
    pub af: sa_family_t,
}
#[test]
fn bindgen_test_layout_pf_pool() {
    const UNINIT: ::std::mem::MaybeUninit<pf_pool> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_pool>(),
        72usize,
        concat!("Size of: ", stringify!(pf_pool))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_pool>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_pool))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).list) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_pool), "::", stringify!(list))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cur) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(pf_pool), "::", stringify!(cur))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(pf_pool), "::", stringify!(key))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).counter) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(pf_pool), "::", stringify!(counter))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tblidx) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(pf_pool), "::", stringify!(tblidx))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).proxy_port) as usize - ptr as usize },
        60usize,
        concat!("Offset of field: ", stringify!(pf_pool), "::", stringify!(proxy_port))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).port_op) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(pf_pool), "::", stringify!(port_op))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).opts) as usize - ptr as usize },
        65usize,
        concat!("Offset of field: ", stringify!(pf_pool), "::", stringify!(opts))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).af) as usize - ptr as usize },
        66usize,
        concat!("Offset of field: ", stringify!(pf_pool), "::", stringify!(af))
    );
}
pub type pf_osfp_t = u_int32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_osfp_entry {
    pub fp_entry: pf_osfp_entry__bindgen_ty_1,
    pub fp_os: pf_osfp_t,
    pub fp_enflags: ::std::os::raw::c_int,
    pub fp_class_nm: [::std::os::raw::c_char; 32usize],
    pub fp_version_nm: [::std::os::raw::c_char; 32usize],
    pub fp_subtype_nm: [::std::os::raw::c_char; 32usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_osfp_entry__bindgen_ty_1 {
    pub sle_next: *mut pf_osfp_entry,
}
#[test]
fn bindgen_test_layout_pf_osfp_entry__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_osfp_entry__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_osfp_entry__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(pf_osfp_entry__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_osfp_entry__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_osfp_entry__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sle_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_osfp_entry__bindgen_ty_1),
            "::",
            stringify!(sle_next)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_osfp_entry() {
    const UNINIT: ::std::mem::MaybeUninit<pf_osfp_entry> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_osfp_entry>(),
        112usize,
        concat!("Size of: ", stringify!(pf_osfp_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_osfp_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_osfp_entry))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_entry) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_osfp_entry),
            "::",
            stringify!(fp_entry)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_os) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(pf_osfp_entry), "::", stringify!(fp_os))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_enflags) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_osfp_entry),
            "::",
            stringify!(fp_enflags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_class_nm) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_osfp_entry),
            "::",
            stringify!(fp_class_nm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_version_nm) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_osfp_entry),
            "::",
            stringify!(fp_version_nm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_subtype_nm) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_osfp_entry),
            "::",
            stringify!(fp_subtype_nm)
        )
    );
}
pub type pf_tcpopts_t = u_int64_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_os_fingerprint {
    pub fp_oses: pf_os_fingerprint_pf_osfp_enlist,
    pub fp_tcpopts: pf_tcpopts_t,
    pub fp_wsize: u_int16_t,
    pub fp_psize: u_int16_t,
    pub fp_mss: u_int16_t,
    pub fp_flags: u_int16_t,
    pub fp_optcnt: u_int8_t,
    pub fp_wscale: u_int8_t,
    pub fp_ttl: u_int8_t,
    pub fp_next: pf_os_fingerprint__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_os_fingerprint_pf_osfp_enlist {
    pub slh_first: *mut pf_osfp_entry,
}
#[test]
fn bindgen_test_layout_pf_os_fingerprint_pf_osfp_enlist() {
    const UNINIT: ::std::mem::MaybeUninit<pf_os_fingerprint_pf_osfp_enlist> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_os_fingerprint_pf_osfp_enlist>(),
        8usize,
        concat!("Size of: ", stringify!(pf_os_fingerprint_pf_osfp_enlist))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_os_fingerprint_pf_osfp_enlist>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_os_fingerprint_pf_osfp_enlist))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).slh_first) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_os_fingerprint_pf_osfp_enlist),
            "::",
            stringify!(slh_first)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_os_fingerprint__bindgen_ty_1 {
    pub sle_next: *mut pf_os_fingerprint,
}
#[test]
fn bindgen_test_layout_pf_os_fingerprint__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_os_fingerprint__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_os_fingerprint__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(pf_os_fingerprint__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_os_fingerprint__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_os_fingerprint__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sle_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_os_fingerprint__bindgen_ty_1),
            "::",
            stringify!(sle_next)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_os_fingerprint() {
    const UNINIT: ::std::mem::MaybeUninit<pf_os_fingerprint> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_os_fingerprint>(),
        40usize,
        concat!("Size of: ", stringify!(pf_os_fingerprint))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_os_fingerprint>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_os_fingerprint))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_oses) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_os_fingerprint),
            "::",
            stringify!(fp_oses)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_tcpopts) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_os_fingerprint),
            "::",
            stringify!(fp_tcpopts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_wsize) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_os_fingerprint),
            "::",
            stringify!(fp_wsize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_psize) as usize - ptr as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_os_fingerprint),
            "::",
            stringify!(fp_psize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_mss) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_os_fingerprint),
            "::",
            stringify!(fp_mss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_flags) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_os_fingerprint),
            "::",
            stringify!(fp_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_optcnt) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_os_fingerprint),
            "::",
            stringify!(fp_optcnt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_wscale) as usize - ptr as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_os_fingerprint),
            "::",
            stringify!(fp_wscale)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_ttl) as usize - ptr as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_os_fingerprint),
            "::",
            stringify!(fp_ttl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_next) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_os_fingerprint),
            "::",
            stringify!(fp_next)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_osfp_ioctl {
    pub fp_os: pf_osfp_entry,
    pub fp_tcpopts: pf_tcpopts_t,
    pub fp_wsize: u_int16_t,
    pub fp_psize: u_int16_t,
    pub fp_mss: u_int16_t,
    pub fp_flags: u_int16_t,
    pub fp_optcnt: u_int8_t,
    pub fp_wscale: u_int8_t,
    pub fp_ttl: u_int8_t,
    pub fp_getnum: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pf_osfp_ioctl() {
    const UNINIT: ::std::mem::MaybeUninit<pf_osfp_ioctl> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_osfp_ioctl>(),
        136usize,
        concat!("Size of: ", stringify!(pf_osfp_ioctl))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_osfp_ioctl>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_osfp_ioctl))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_os) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_osfp_ioctl), "::", stringify!(fp_os))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_tcpopts) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_osfp_ioctl),
            "::",
            stringify!(fp_tcpopts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_wsize) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_osfp_ioctl),
            "::",
            stringify!(fp_wsize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_psize) as usize - ptr as usize },
        122usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_osfp_ioctl),
            "::",
            stringify!(fp_psize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_mss) as usize - ptr as usize },
        124usize,
        concat!("Offset of field: ", stringify!(pf_osfp_ioctl), "::", stringify!(fp_mss))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_flags) as usize - ptr as usize },
        126usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_osfp_ioctl),
            "::",
            stringify!(fp_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_optcnt) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_osfp_ioctl),
            "::",
            stringify!(fp_optcnt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_wscale) as usize - ptr as usize },
        129usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_osfp_ioctl),
            "::",
            stringify!(fp_wscale)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_ttl) as usize - ptr as usize },
        130usize,
        concat!("Offset of field: ", stringify!(pf_osfp_ioctl), "::", stringify!(fp_ttl))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_getnum) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_osfp_ioctl),
            "::",
            stringify!(fp_getnum)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pf_rule_ptr {
    pub ptr: *mut pf_rule,
    pub nr: u_int32_t,
}
#[test]
fn bindgen_test_layout_pf_rule_ptr() {
    const UNINIT: ::std::mem::MaybeUninit<pf_rule_ptr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_rule_ptr>(),
        8usize,
        concat!("Size of: ", stringify!(pf_rule_ptr))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_rule_ptr>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_rule_ptr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_rule_ptr), "::", stringify!(ptr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_rule_ptr), "::", stringify!(nr))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pf_rule {
    pub src: pf_rule_addr,
    pub dst: pf_rule_addr,
    pub skip: [pf_rule_ptr; 8usize],
    pub label: [::std::os::raw::c_char; 64usize],
    pub ifname: [::std::os::raw::c_char; 16usize],
    pub qname: [::std::os::raw::c_char; 64usize],
    pub pqname: [::std::os::raw::c_char; 64usize],
    pub tagname: [::std::os::raw::c_char; 64usize],
    pub match_tagname: [::std::os::raw::c_char; 64usize],
    pub overload_tblname: [::std::os::raw::c_char; 32usize],
    pub entries: pf_rule__bindgen_ty_1,
    pub rpool: pf_pool,
    pub evaluations: u_int64_t,
    pub packets: [u_int64_t; 2usize],
    pub bytes: [u_int64_t; 2usize],
    pub ticket: u_int64_t,
    pub owner: [::std::os::raw::c_char; 64usize],
    pub priority: u_int32_t,
    pub kif: *mut ::std::os::raw::c_void,
    pub anchor: *mut pf_anchor,
    pub overload_tbl: *mut ::std::os::raw::c_void,
    pub os_fingerprint: pf_osfp_t,
    pub rtableid: ::std::os::raw::c_uint,
    pub timeout: [u_int32_t; 26usize],
    pub states: u_int32_t,
    pub max_states: u_int32_t,
    pub src_nodes: u_int32_t,
    pub max_src_nodes: u_int32_t,
    pub max_src_states: u_int32_t,
    pub max_src_conn: u_int32_t,
    pub max_src_conn_rate: pf_rule__bindgen_ty_2,
    pub qid: u_int32_t,
    pub pqid: u_int32_t,
    pub rt_listid: u_int32_t,
    pub nr: u_int32_t,
    pub prob: u_int32_t,
    pub cuid: uid_t,
    pub cpid: pid_t,
    pub return_icmp: u_int16_t,
    pub return_icmp6: u_int16_t,
    pub max_mss: u_int16_t,
    pub tag: u_int16_t,
    pub match_tag: u_int16_t,
    pub uid: pf_rule_uid,
    pub gid: pf_rule_gid,
    pub rule_flag: u_int32_t,
    pub action: u_int8_t,
    pub direction: u_int8_t,
    pub log: u_int8_t,
    pub logif: u_int8_t,
    pub quick: u_int8_t,
    pub ifnot: u_int8_t,
    pub match_tag_not: u_int8_t,
    pub natpass: u_int8_t,
    pub keep_state: u_int8_t,
    pub af: sa_family_t,
    pub proto: u_int8_t,
    pub type_: u_int8_t,
    pub code: u_int8_t,
    pub flags: u_int8_t,
    pub flagset: u_int8_t,
    pub min_ttl: u_int8_t,
    pub allow_opts: u_int8_t,
    pub rt: u_int8_t,
    pub return_ttl: u_int8_t,
    pub tos: u_int8_t,
    pub anchor_relative: u_int8_t,
    pub anchor_wildcard: u_int8_t,
    pub flush: u_int8_t,
    pub proto_variant: u_int8_t,
    pub extfilter: u_int8_t,
    pub extmap: u_int8_t,
    pub dnpipe: u_int32_t,
    pub dntype: u_int32_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_rule__bindgen_ty_1 {
    pub tqe_next: *mut pf_rule,
    pub tqe_prev: *mut *mut pf_rule,
}
#[test]
fn bindgen_test_layout_pf_rule__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_rule__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_rule__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(pf_rule__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_rule__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_rule__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule__bindgen_ty_1),
            "::",
            stringify!(tqe_next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_prev) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule__bindgen_ty_1),
            "::",
            stringify!(tqe_prev)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_rule__bindgen_ty_2 {
    pub limit: u_int32_t,
    pub seconds: u_int32_t,
}
#[test]
fn bindgen_test_layout_pf_rule__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<pf_rule__bindgen_ty_2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_rule__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(pf_rule__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_rule__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_rule__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).limit) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule__bindgen_ty_2),
            "::",
            stringify!(limit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seconds) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule__bindgen_ty_2),
            "::",
            stringify!(seconds)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_rule() {
    const UNINIT: ::std::mem::MaybeUninit<pf_rule> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_rule>(),
        1040usize,
        concat!("Size of: ", stringify!(pf_rule))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_rule>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_rule))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(src))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dst) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(dst))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).skip) as usize - ptr as usize },
        128usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(skip))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).label) as usize - ptr as usize },
        192usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(label))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifname) as usize - ptr as usize },
        256usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(ifname))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).qname) as usize - ptr as usize },
        272usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(qname))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pqname) as usize - ptr as usize },
        336usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(pqname))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tagname) as usize - ptr as usize },
        400usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(tagname))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).match_tagname) as usize - ptr as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule),
            "::",
            stringify!(match_tagname)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).overload_tblname) as usize - ptr as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule),
            "::",
            stringify!(overload_tblname)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        560usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(entries))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rpool) as usize - ptr as usize },
        576usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(rpool))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).evaluations) as usize - ptr as usize },
        648usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(evaluations))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).packets) as usize - ptr as usize },
        656usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(packets))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bytes) as usize - ptr as usize },
        672usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(bytes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ticket) as usize - ptr as usize },
        688usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(ticket))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).owner) as usize - ptr as usize },
        696usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(owner))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).priority) as usize - ptr as usize },
        760usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(priority))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kif) as usize - ptr as usize },
        768usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(kif))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).anchor) as usize - ptr as usize },
        776usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(anchor))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).overload_tbl) as usize - ptr as usize },
        784usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(overload_tbl))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).os_fingerprint) as usize - ptr as usize },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule),
            "::",
            stringify!(os_fingerprint)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtableid) as usize - ptr as usize },
        796usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(rtableid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timeout) as usize - ptr as usize },
        800usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(timeout))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).states) as usize - ptr as usize },
        904usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(states))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_states) as usize - ptr as usize },
        908usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(max_states))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src_nodes) as usize - ptr as usize },
        912usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(src_nodes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_src_nodes) as usize - ptr as usize },
        916usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule),
            "::",
            stringify!(max_src_nodes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_src_states) as usize - ptr as usize },
        920usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule),
            "::",
            stringify!(max_src_states)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_src_conn) as usize - ptr as usize },
        924usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(max_src_conn))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_src_conn_rate) as usize - ptr as usize },
        928usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule),
            "::",
            stringify!(max_src_conn_rate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).qid) as usize - ptr as usize },
        936usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(qid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pqid) as usize - ptr as usize },
        940usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(pqid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rt_listid) as usize - ptr as usize },
        944usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(rt_listid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        948usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(nr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).prob) as usize - ptr as usize },
        952usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(prob))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cuid) as usize - ptr as usize },
        956usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(cuid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cpid) as usize - ptr as usize },
        960usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(cpid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).return_icmp) as usize - ptr as usize },
        964usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(return_icmp))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).return_icmp6) as usize - ptr as usize },
        966usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(return_icmp6))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_mss) as usize - ptr as usize },
        968usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(max_mss))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tag) as usize - ptr as usize },
        970usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(tag))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).match_tag) as usize - ptr as usize },
        972usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(match_tag))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uid) as usize - ptr as usize },
        976usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(uid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gid) as usize - ptr as usize },
        988usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(gid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rule_flag) as usize - ptr as usize },
        1000usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(rule_flag))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).action) as usize - ptr as usize },
        1004usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(action))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).direction) as usize - ptr as usize },
        1005usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(direction))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).log) as usize - ptr as usize },
        1006usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(log))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).logif) as usize - ptr as usize },
        1007usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(logif))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).quick) as usize - ptr as usize },
        1008usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(quick))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifnot) as usize - ptr as usize },
        1009usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(ifnot))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).match_tag_not) as usize - ptr as usize },
        1010usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule),
            "::",
            stringify!(match_tag_not)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).natpass) as usize - ptr as usize },
        1011usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(natpass))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).keep_state) as usize - ptr as usize },
        1012usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(keep_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).af) as usize - ptr as usize },
        1013usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(af))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).proto) as usize - ptr as usize },
        1014usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(proto))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        1015usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(type_))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).code) as usize - ptr as usize },
        1016usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(code))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        1017usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(flags))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flagset) as usize - ptr as usize },
        1018usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(flagset))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).min_ttl) as usize - ptr as usize },
        1019usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(min_ttl))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).allow_opts) as usize - ptr as usize },
        1020usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(allow_opts))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rt) as usize - ptr as usize },
        1021usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(rt))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).return_ttl) as usize - ptr as usize },
        1022usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(return_ttl))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tos) as usize - ptr as usize },
        1023usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(tos))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).anchor_relative) as usize - ptr as usize },
        1024usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule),
            "::",
            stringify!(anchor_relative)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).anchor_wildcard) as usize - ptr as usize },
        1025usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule),
            "::",
            stringify!(anchor_wildcard)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flush) as usize - ptr as usize },
        1026usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(flush))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).proto_variant) as usize - ptr as usize },
        1027usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rule),
            "::",
            stringify!(proto_variant)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extfilter) as usize - ptr as usize },
        1028usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(extfilter))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extmap) as usize - ptr as usize },
        1029usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(extmap))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dnpipe) as usize - ptr as usize },
        1032usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(dnpipe))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dntype) as usize - ptr as usize },
        1036usize,
        concat!("Offset of field: ", stringify!(pf_rule), "::", stringify!(dntype))
    );
}
pub const pf_extmap_PF_EXTMAP_APD: pf_extmap = 1;
pub const pf_extmap_PF_EXTMAP_AD: pf_extmap = 2;
pub const pf_extmap_PF_EXTMAP_EI: pf_extmap = 3;
pub type pf_extmap = ::std::os::raw::c_uint;
pub const pf_extfilter_PF_EXTFILTER_APD: pf_extfilter = 1;
pub const pf_extfilter_PF_EXTFILTER_AD: pf_extfilter = 2;
pub const pf_extfilter_PF_EXTFILTER_EI: pf_extfilter = 3;
pub type pf_extfilter = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_threshold {
    pub limit: u_int32_t,
    pub seconds: u_int32_t,
    pub count: u_int32_t,
    pub last: u_int32_t,
}
#[test]
fn bindgen_test_layout_pf_threshold() {
    const UNINIT: ::std::mem::MaybeUninit<pf_threshold> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_threshold>(),
        16usize,
        concat!("Size of: ", stringify!(pf_threshold))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_threshold>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_threshold))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).limit) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_threshold), "::", stringify!(limit))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seconds) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(pf_threshold), "::", stringify!(seconds))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(pf_threshold), "::", stringify!(count))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(pf_threshold), "::", stringify!(last))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pf_src_node {
    pub entry: pf_src_node__bindgen_ty_1,
    pub addr: pf_addr,
    pub raddr: pf_addr,
    pub rule: pf_rule_ptr,
    pub kif: *mut ::std::os::raw::c_void,
    pub bytes: [u_int64_t; 2usize],
    pub packets: [u_int64_t; 2usize],
    pub states: u_int32_t,
    pub conn: u_int32_t,
    pub conn_rate: pf_threshold,
    pub creation: u_int64_t,
    pub expire: u_int64_t,
    pub af: sa_family_t,
    pub ruletype: u_int8_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_src_node__bindgen_ty_1 {
    pub rbe_left: *mut pf_src_node,
    pub rbe_right: *mut pf_src_node,
    pub rbe_parent: *mut pf_src_node,
}
#[test]
fn bindgen_test_layout_pf_src_node__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_src_node__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_src_node__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(pf_src_node__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_src_node__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_src_node__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rbe_left) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_src_node__bindgen_ty_1),
            "::",
            stringify!(rbe_left)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rbe_right) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_src_node__bindgen_ty_1),
            "::",
            stringify!(rbe_right)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rbe_parent) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_src_node__bindgen_ty_1),
            "::",
            stringify!(rbe_parent)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_src_node() {
    const UNINIT: ::std::mem::MaybeUninit<pf_src_node> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_src_node>(),
        152usize,
        concat!("Size of: ", stringify!(pf_src_node))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_src_node>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_src_node))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entry) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_src_node), "::", stringify!(entry))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(pf_src_node), "::", stringify!(addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).raddr) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(pf_src_node), "::", stringify!(raddr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rule) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(pf_src_node), "::", stringify!(rule))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kif) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(pf_src_node), "::", stringify!(kif))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bytes) as usize - ptr as usize },
        72usize,
        concat!("Offset of field: ", stringify!(pf_src_node), "::", stringify!(bytes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).packets) as usize - ptr as usize },
        88usize,
        concat!("Offset of field: ", stringify!(pf_src_node), "::", stringify!(packets))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).states) as usize - ptr as usize },
        104usize,
        concat!("Offset of field: ", stringify!(pf_src_node), "::", stringify!(states))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).conn) as usize - ptr as usize },
        108usize,
        concat!("Offset of field: ", stringify!(pf_src_node), "::", stringify!(conn))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).conn_rate) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_src_node),
            "::",
            stringify!(conn_rate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).creation) as usize - ptr as usize },
        128usize,
        concat!("Offset of field: ", stringify!(pf_src_node), "::", stringify!(creation))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).expire) as usize - ptr as usize },
        136usize,
        concat!("Offset of field: ", stringify!(pf_src_node), "::", stringify!(expire))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).af) as usize - ptr as usize },
        144usize,
        concat!("Offset of field: ", stringify!(pf_src_node), "::", stringify!(af))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ruletype) as usize - ptr as usize },
        145usize,
        concat!("Offset of field: ", stringify!(pf_src_node), "::", stringify!(ruletype))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pf_state_xport {
    pub port: u_int16_t,
    pub call_id: u_int16_t,
    pub spi: u_int32_t,
}
#[test]
fn bindgen_test_layout_pf_state_xport() {
    const UNINIT: ::std::mem::MaybeUninit<pf_state_xport> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_state_xport>(),
        4usize,
        concat!("Size of: ", stringify!(pf_state_xport))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_state_xport>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_state_xport))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_state_xport), "::", stringify!(port))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).call_id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_state_xport),
            "::",
            stringify!(call_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).spi) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_state_xport), "::", stringify!(spi))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pf_state_host {
    pub addr: pf_addr,
    pub xport: pf_state_xport,
}
#[test]
fn bindgen_test_layout_pf_state_host() {
    const UNINIT: ::std::mem::MaybeUninit<pf_state_host> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_state_host>(),
        20usize,
        concat!("Size of: ", stringify!(pf_state_host))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_state_host>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_state_host))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_state_host), "::", stringify!(addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xport) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(pf_state_host), "::", stringify!(xport))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hook_desc {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hook_desc_head {
    pub tqh_first: *mut hook_desc,
    pub tqh_last: *mut *mut hook_desc,
}
#[test]
fn bindgen_test_layout_hook_desc_head() {
    const UNINIT: ::std::mem::MaybeUninit<hook_desc_head> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<hook_desc_head>(),
        16usize,
        concat!("Size of: ", stringify!(hook_desc_head))
    );
    assert_eq!(
        ::std::mem::align_of::<hook_desc_head>(),
        8usize,
        concat!("Alignment of ", stringify!(hook_desc_head))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqh_first) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hook_desc_head),
            "::",
            stringify!(tqh_first)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqh_last) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hook_desc_head),
            "::",
            stringify!(tqh_last)
        )
    );
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct pfsync_state_scrub {
    pub pfss_flags: u_int16_t,
    pub pfss_ttl: u_int8_t,
    pub scrub_flag: u_int8_t,
    pub pfss_ts_mod: u_int32_t,
}
#[test]
fn bindgen_test_layout_pfsync_state_scrub() {
    const UNINIT: ::std::mem::MaybeUninit<pfsync_state_scrub> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfsync_state_scrub>(),
        8usize,
        concat!("Size of: ", stringify!(pfsync_state_scrub))
    );
    assert_eq!(
        ::std::mem::align_of::<pfsync_state_scrub>(),
        1usize,
        concat!("Alignment of ", stringify!(pfsync_state_scrub))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfss_flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_scrub),
            "::",
            stringify!(pfss_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfss_ttl) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_scrub),
            "::",
            stringify!(pfss_ttl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scrub_flag) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_scrub),
            "::",
            stringify!(scrub_flag)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfss_ts_mod) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_scrub),
            "::",
            stringify!(pfss_ts_mod)
        )
    );
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct pfsync_state_host {
    pub addr: pf_addr,
    pub xport: pf_state_xport,
    pub pad: [u_int16_t; 2usize],
}
#[test]
fn bindgen_test_layout_pfsync_state_host() {
    const UNINIT: ::std::mem::MaybeUninit<pfsync_state_host> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfsync_state_host>(),
        24usize,
        concat!("Size of: ", stringify!(pfsync_state_host))
    );
    assert_eq!(
        ::std::mem::align_of::<pfsync_state_host>(),
        1usize,
        concat!("Alignment of ", stringify!(pfsync_state_host))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_host),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xport) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_host),
            "::",
            stringify!(xport)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_host),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct pfsync_state_peer {
    pub scrub: pfsync_state_scrub,
    pub seqlo: u_int32_t,
    pub seqhi: u_int32_t,
    pub seqdiff: u_int32_t,
    pub max_win: u_int16_t,
    pub mss: u_int16_t,
    pub state: u_int8_t,
    pub wscale: u_int8_t,
    pub pad: [u_int8_t; 6usize],
}
#[test]
fn bindgen_test_layout_pfsync_state_peer() {
    const UNINIT: ::std::mem::MaybeUninit<pfsync_state_peer> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfsync_state_peer>(),
        32usize,
        concat!("Size of: ", stringify!(pfsync_state_peer))
    );
    assert_eq!(
        ::std::mem::align_of::<pfsync_state_peer>(),
        1usize,
        concat!("Alignment of ", stringify!(pfsync_state_peer))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scrub) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_peer),
            "::",
            stringify!(scrub)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seqlo) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_peer),
            "::",
            stringify!(seqlo)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seqhi) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_peer),
            "::",
            stringify!(seqhi)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seqdiff) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_peer),
            "::",
            stringify!(seqdiff)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_win) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_peer),
            "::",
            stringify!(max_win)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mss) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_peer),
            "::",
            stringify!(mss)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_peer),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wscale) as usize - ptr as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_peer),
            "::",
            stringify!(wscale)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pad) as usize - ptr as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state_peer),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct pfsync_state {
    pub id: [u_int32_t; 2usize],
    pub ifname: [::std::os::raw::c_char; 16usize],
    pub lan: pfsync_state_host,
    pub gwy: pfsync_state_host,
    pub ext_lan: pfsync_state_host,
    pub ext_gwy: pfsync_state_host,
    pub src: pfsync_state_peer,
    pub dst: pfsync_state_peer,
    pub rt_addr: pf_addr,
    pub unlink_hooks: hook_desc_head,
    pub rule: u_int32_t,
    pub anchor: u_int32_t,
    pub nat_rule: u_int32_t,
    pub creation: u_int64_t,
    pub expire: u_int64_t,
    pub packets: [[u_int32_t; 2usize]; 2usize],
    pub bytes: [[u_int32_t; 2usize]; 2usize],
    pub creatorid: u_int32_t,
    pub tag: u_int16_t,
    pub af_lan: sa_family_t,
    pub af_gwy: sa_family_t,
    pub proto: u_int8_t,
    pub direction: u_int8_t,
    pub log: u_int8_t,
    pub allow_opts: u_int8_t,
    pub timeout: u_int8_t,
    pub sync_flags: u_int8_t,
    pub updates: u_int8_t,
    pub proto_variant: u_int8_t,
    pub __pad: u_int8_t,
    pub flowhash: u_int32_t,
}
#[test]
fn bindgen_test_layout_pfsync_state() {
    const UNINIT: ::std::mem::MaybeUninit<pfsync_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfsync_state>(),
        297usize,
        concat!("Size of: ", stringify!(pfsync_state))
    );
    assert_eq!(
        ::std::mem::align_of::<pfsync_state>(),
        1usize,
        concat!("Alignment of ", stringify!(pfsync_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(id))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifname) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(ifname))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lan) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(lan))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gwy) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(gwy))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ext_lan) as usize - ptr as usize },
        72usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(ext_lan))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ext_gwy) as usize - ptr as usize },
        96usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(ext_gwy))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src) as usize - ptr as usize },
        120usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(src))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dst) as usize - ptr as usize },
        152usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(dst))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rt_addr) as usize - ptr as usize },
        184usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(rt_addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unlink_hooks) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state),
            "::",
            stringify!(unlink_hooks)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rule) as usize - ptr as usize },
        216usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(rule))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).anchor) as usize - ptr as usize },
        220usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(anchor))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nat_rule) as usize - ptr as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state),
            "::",
            stringify!(nat_rule)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).creation) as usize - ptr as usize },
        228usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state),
            "::",
            stringify!(creation)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).expire) as usize - ptr as usize },
        236usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(expire))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).packets) as usize - ptr as usize },
        244usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(packets))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bytes) as usize - ptr as usize },
        260usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(bytes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).creatorid) as usize - ptr as usize },
        276usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state),
            "::",
            stringify!(creatorid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tag) as usize - ptr as usize },
        280usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(tag))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).af_lan) as usize - ptr as usize },
        282usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(af_lan))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).af_gwy) as usize - ptr as usize },
        283usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(af_gwy))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).proto) as usize - ptr as usize },
        284usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(proto))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).direction) as usize - ptr as usize },
        285usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state),
            "::",
            stringify!(direction)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).log) as usize - ptr as usize },
        286usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(log))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).allow_opts) as usize - ptr as usize },
        287usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state),
            "::",
            stringify!(allow_opts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timeout) as usize - ptr as usize },
        288usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(timeout))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sync_flags) as usize - ptr as usize },
        289usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state),
            "::",
            stringify!(sync_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).updates) as usize - ptr as usize },
        290usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(updates))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).proto_variant) as usize - ptr as usize },
        291usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state),
            "::",
            stringify!(proto_variant)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__pad) as usize - ptr as usize },
        292usize,
        concat!("Offset of field: ", stringify!(pfsync_state), "::", stringify!(__pad))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flowhash) as usize - ptr as usize },
        293usize,
        concat!(
            "Offset of field: ",
            stringify!(pfsync_state),
            "::",
            stringify!(flowhash)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_rulequeue {
    pub tqh_first: *mut pf_rule,
    pub tqh_last: *mut *mut pf_rule,
}
#[test]
fn bindgen_test_layout_pf_rulequeue() {
    const UNINIT: ::std::mem::MaybeUninit<pf_rulequeue> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_rulequeue>(),
        16usize,
        concat!("Size of: ", stringify!(pf_rulequeue))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_rulequeue>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_rulequeue))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqh_first) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rulequeue),
            "::",
            stringify!(tqh_first)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqh_last) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_rulequeue),
            "::",
            stringify!(tqh_last)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_ruleset {
    pub rules: [pf_ruleset__bindgen_ty_1; 6usize],
    pub anchor: *mut pf_anchor,
    pub tticket: u_int32_t,
    pub tables: ::std::os::raw::c_int,
    pub topen: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_ruleset__bindgen_ty_1 {
    pub queues: [pf_rulequeue; 2usize],
    pub active: pf_ruleset__bindgen_ty_1__bindgen_ty_1,
    pub inactive: pf_ruleset__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_ruleset__bindgen_ty_1__bindgen_ty_1 {
    pub ptr: *mut pf_rulequeue,
    pub ptr_array: *mut *mut pf_rule,
    pub rcount: u_int32_t,
    pub ticket: u_int32_t,
    pub open: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pf_ruleset__bindgen_ty_1__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_ruleset__bindgen_ty_1__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_ruleset__bindgen_ty_1__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(pf_ruleset__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_ruleset__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_ruleset__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_ruleset__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ptr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptr_array) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_ruleset__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ptr_array)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rcount) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_ruleset__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(rcount)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ticket) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_ruleset__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(ticket)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).open) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_ruleset__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(open)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_ruleset__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_ruleset__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_ruleset__bindgen_ty_1>(),
        96usize,
        concat!("Size of: ", stringify!(pf_ruleset__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_ruleset__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_ruleset__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).queues) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_ruleset__bindgen_ty_1),
            "::",
            stringify!(queues)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).active) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_ruleset__bindgen_ty_1),
            "::",
            stringify!(active)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).inactive) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_ruleset__bindgen_ty_1),
            "::",
            stringify!(inactive)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_ruleset() {
    const UNINIT: ::std::mem::MaybeUninit<pf_ruleset> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_ruleset>(),
        600usize,
        concat!("Size of: ", stringify!(pf_ruleset))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_ruleset>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_ruleset))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rules) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_ruleset), "::", stringify!(rules))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).anchor) as usize - ptr as usize },
        576usize,
        concat!("Offset of field: ", stringify!(pf_ruleset), "::", stringify!(anchor))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tticket) as usize - ptr as usize },
        584usize,
        concat!("Offset of field: ", stringify!(pf_ruleset), "::", stringify!(tticket))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tables) as usize - ptr as usize },
        588usize,
        concat!("Offset of field: ", stringify!(pf_ruleset), "::", stringify!(tables))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).topen) as usize - ptr as usize },
        592usize,
        concat!("Offset of field: ", stringify!(pf_ruleset), "::", stringify!(topen))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_anchor_global {
    pub rbh_root: *mut pf_anchor,
}
#[test]
fn bindgen_test_layout_pf_anchor_global() {
    const UNINIT: ::std::mem::MaybeUninit<pf_anchor_global> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_anchor_global>(),
        8usize,
        concat!("Size of: ", stringify!(pf_anchor_global))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_anchor_global>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_anchor_global))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rbh_root) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_anchor_global),
            "::",
            stringify!(rbh_root)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_anchor_node {
    pub rbh_root: *mut pf_anchor,
}
#[test]
fn bindgen_test_layout_pf_anchor_node() {
    const UNINIT: ::std::mem::MaybeUninit<pf_anchor_node> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_anchor_node>(),
        8usize,
        concat!("Size of: ", stringify!(pf_anchor_node))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_anchor_node>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_anchor_node))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rbh_root) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_anchor_node),
            "::",
            stringify!(rbh_root)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_anchor {
    pub entry_global: pf_anchor__bindgen_ty_1,
    pub entry_node: pf_anchor__bindgen_ty_2,
    pub parent: *mut pf_anchor,
    pub children: pf_anchor_node,
    pub name: [::std::os::raw::c_char; 64usize],
    pub path: [::std::os::raw::c_char; 1024usize],
    pub ruleset: pf_ruleset,
    pub refcnt: ::std::os::raw::c_int,
    pub match_: ::std::os::raw::c_int,
    pub owner: [::std::os::raw::c_char; 64usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_anchor__bindgen_ty_1 {
    pub rbe_left: *mut pf_anchor,
    pub rbe_right: *mut pf_anchor,
    pub rbe_parent: *mut pf_anchor,
}
#[test]
fn bindgen_test_layout_pf_anchor__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_anchor__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_anchor__bindgen_ty_1>(),
        24usize,
        concat!("Size of: ", stringify!(pf_anchor__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_anchor__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_anchor__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rbe_left) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_anchor__bindgen_ty_1),
            "::",
            stringify!(rbe_left)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rbe_right) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_anchor__bindgen_ty_1),
            "::",
            stringify!(rbe_right)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rbe_parent) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_anchor__bindgen_ty_1),
            "::",
            stringify!(rbe_parent)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_anchor__bindgen_ty_2 {
    pub rbe_left: *mut pf_anchor,
    pub rbe_right: *mut pf_anchor,
    pub rbe_parent: *mut pf_anchor,
}
#[test]
fn bindgen_test_layout_pf_anchor__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<pf_anchor__bindgen_ty_2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_anchor__bindgen_ty_2>(),
        24usize,
        concat!("Size of: ", stringify!(pf_anchor__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_anchor__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_anchor__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rbe_left) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_anchor__bindgen_ty_2),
            "::",
            stringify!(rbe_left)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rbe_right) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_anchor__bindgen_ty_2),
            "::",
            stringify!(rbe_right)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rbe_parent) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_anchor__bindgen_ty_2),
            "::",
            stringify!(rbe_parent)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_anchor() {
    const UNINIT: ::std::mem::MaybeUninit<pf_anchor> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_anchor>(),
        1824usize,
        concat!("Size of: ", stringify!(pf_anchor))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_anchor>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_anchor))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entry_global) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_anchor),
            "::",
            stringify!(entry_global)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entry_node) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(pf_anchor), "::", stringify!(entry_node))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(pf_anchor), "::", stringify!(parent))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).children) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(pf_anchor), "::", stringify!(children))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(pf_anchor), "::", stringify!(name))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).path) as usize - ptr as usize },
        128usize,
        concat!("Offset of field: ", stringify!(pf_anchor), "::", stringify!(path))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ruleset) as usize - ptr as usize },
        1152usize,
        concat!("Offset of field: ", stringify!(pf_anchor), "::", stringify!(ruleset))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).refcnt) as usize - ptr as usize },
        1752usize,
        concat!("Offset of field: ", stringify!(pf_anchor), "::", stringify!(refcnt))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).match_) as usize - ptr as usize },
        1756usize,
        concat!("Offset of field: ", stringify!(pf_anchor), "::", stringify!(match_))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).owner) as usize - ptr as usize },
        1760usize,
        concat!("Offset of field: ", stringify!(pf_anchor), "::", stringify!(owner))
    );
}
extern "C" {
    pub fn pf_anchor_global_RB_INSERT_COLOR(arg1: *mut pf_anchor_global, arg2: *mut pf_anchor);
}
extern "C" {
    pub fn pf_anchor_global_RB_REMOVE_COLOR(arg1: *mut pf_anchor_global, arg2: *mut pf_anchor, arg3: *mut pf_anchor);
}
extern "C" {
    pub fn pf_anchor_global_RB_REMOVE(arg1: *mut pf_anchor_global, arg2: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_global_RB_INSERT(arg1: *mut pf_anchor_global, arg2: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_global_RB_FIND(arg1: *mut pf_anchor_global, arg2: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_global_RB_NFIND(arg1: *mut pf_anchor_global, arg2: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_global_RB_NEXT(arg1: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_global_RB_MINMAX(arg1: *mut pf_anchor_global, arg2: ::std::os::raw::c_int) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_global_RB_GETPARENT(arg1: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_global_RB_SETPARENT(arg1: *mut pf_anchor, arg2: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_global_RB_GETCOLOR(arg1: *mut pf_anchor) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pf_anchor_global_RB_SETCOLOR(arg1: *mut pf_anchor, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn pf_anchor_node_RB_INSERT_COLOR(arg1: *mut pf_anchor_node, arg2: *mut pf_anchor);
}
extern "C" {
    pub fn pf_anchor_node_RB_REMOVE_COLOR(arg1: *mut pf_anchor_node, arg2: *mut pf_anchor, arg3: *mut pf_anchor);
}
extern "C" {
    pub fn pf_anchor_node_RB_REMOVE(arg1: *mut pf_anchor_node, arg2: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_node_RB_INSERT(arg1: *mut pf_anchor_node, arg2: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_node_RB_FIND(arg1: *mut pf_anchor_node, arg2: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_node_RB_NFIND(arg1: *mut pf_anchor_node, arg2: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_node_RB_NEXT(arg1: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_node_RB_MINMAX(arg1: *mut pf_anchor_node, arg2: ::std::os::raw::c_int) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_node_RB_GETPARENT(arg1: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_node_RB_SETPARENT(arg1: *mut pf_anchor, arg2: *mut pf_anchor) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_anchor_node_RB_GETCOLOR(arg1: *mut pf_anchor) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pf_anchor_node_RB_SETCOLOR(arg1: *mut pf_anchor, arg2: ::std::os::raw::c_int);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfr_table {
    pub pfrt_anchor: [::std::os::raw::c_char; 1024usize],
    pub pfrt_name: [::std::os::raw::c_char; 32usize],
    pub pfrt_flags: u32,
    pub pfrt_fback: u8,
}
#[test]
fn bindgen_test_layout_pfr_table() {
    const UNINIT: ::std::mem::MaybeUninit<pfr_table> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfr_table>(),
        1064usize,
        concat!("Size of: ", stringify!(pfr_table))
    );
    assert_eq!(
        ::std::mem::align_of::<pfr_table>(),
        4usize,
        concat!("Alignment of ", stringify!(pfr_table))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrt_anchor) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfr_table),
            "::",
            stringify!(pfrt_anchor)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrt_name) as usize - ptr as usize },
        1024usize,
        concat!("Offset of field: ", stringify!(pfr_table), "::", stringify!(pfrt_name))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrt_flags) as usize - ptr as usize },
        1056usize,
        concat!("Offset of field: ", stringify!(pfr_table), "::", stringify!(pfrt_flags))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrt_fback) as usize - ptr as usize },
        1060usize,
        concat!("Offset of field: ", stringify!(pfr_table), "::", stringify!(pfrt_fback))
    );
}
pub const PFR_FB_NONE: _bindgen_ty_13 = 0;
pub const PFR_FB_MATCH: _bindgen_ty_13 = 1;
pub const PFR_FB_ADDED: _bindgen_ty_13 = 2;
pub const PFR_FB_DELETED: _bindgen_ty_13 = 3;
pub const PFR_FB_CHANGED: _bindgen_ty_13 = 4;
pub const PFR_FB_CLEARED: _bindgen_ty_13 = 5;
pub const PFR_FB_DUPLICATE: _bindgen_ty_13 = 6;
pub const PFR_FB_NOTMATCH: _bindgen_ty_13 = 7;
pub const PFR_FB_CONFLICT: _bindgen_ty_13 = 8;
pub const PFR_FB_MAX: _bindgen_ty_13 = 9;
pub type _bindgen_ty_13 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pfr_addr {
    pub pfra_u: pfr_addr__bindgen_ty_1,
    pub pfra_af: u8,
    pub pfra_net: u8,
    pub pfra_not: u8,
    pub pfra_fback: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pfr_addr__bindgen_ty_1 {
    pub _pfra_ip4addr: in_addr,
    pub _pfra_ip6addr: in6_addr,
}
#[test]
fn bindgen_test_layout_pfr_addr__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pfr_addr__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfr_addr__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(pfr_addr__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pfr_addr__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(pfr_addr__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._pfra_ip4addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfr_addr__bindgen_ty_1),
            "::",
            stringify!(_pfra_ip4addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._pfra_ip6addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfr_addr__bindgen_ty_1),
            "::",
            stringify!(_pfra_ip6addr)
        )
    );
}
#[test]
fn bindgen_test_layout_pfr_addr() {
    const UNINIT: ::std::mem::MaybeUninit<pfr_addr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfr_addr>(),
        20usize,
        concat!("Size of: ", stringify!(pfr_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<pfr_addr>(),
        4usize,
        concat!("Alignment of ", stringify!(pfr_addr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfra_u) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfr_addr), "::", stringify!(pfra_u))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfra_af) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(pfr_addr), "::", stringify!(pfra_af))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfra_net) as usize - ptr as usize },
        17usize,
        concat!("Offset of field: ", stringify!(pfr_addr), "::", stringify!(pfra_net))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfra_not) as usize - ptr as usize },
        18usize,
        concat!("Offset of field: ", stringify!(pfr_addr), "::", stringify!(pfra_not))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfra_fback) as usize - ptr as usize },
        19usize,
        concat!("Offset of field: ", stringify!(pfr_addr), "::", stringify!(pfra_fback))
    );
}
pub const PFR_DIR_IN: _bindgen_ty_14 = 0;
pub const PFR_DIR_OUT: _bindgen_ty_14 = 1;
pub const PFR_DIR_MAX: _bindgen_ty_14 = 2;
pub type _bindgen_ty_14 = ::std::os::raw::c_uint;
pub const PFR_OP_BLOCK: _bindgen_ty_15 = 0;
pub const PFR_OP_PASS: _bindgen_ty_15 = 1;
pub const PFR_OP_ADDR_MAX: _bindgen_ty_15 = 2;
pub const PFR_OP_TABLE_MAX: _bindgen_ty_15 = 3;
pub type _bindgen_ty_15 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pfr_astats {
    pub pfras_a: pfr_addr,
    pub pfras_packets: [[u64; 2usize]; 2usize],
    pub pfras_bytes: [[u64; 2usize]; 2usize],
    pub pfras_tzero: u64,
}
#[test]
fn bindgen_test_layout_pfr_astats() {
    const UNINIT: ::std::mem::MaybeUninit<pfr_astats> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfr_astats>(),
        96usize,
        concat!("Size of: ", stringify!(pfr_astats))
    );
    assert_eq!(
        ::std::mem::align_of::<pfr_astats>(),
        8usize,
        concat!("Alignment of ", stringify!(pfr_astats))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfras_a) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfr_astats), "::", stringify!(pfras_a))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfras_packets) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pfr_astats),
            "::",
            stringify!(pfras_packets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfras_bytes) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(pfr_astats),
            "::",
            stringify!(pfras_bytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfras_tzero) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(pfr_astats),
            "::",
            stringify!(pfras_tzero)
        )
    );
}
pub const PFR_REFCNT_RULE: _bindgen_ty_16 = 0;
pub const PFR_REFCNT_ANCHOR: _bindgen_ty_16 = 1;
pub const PFR_REFCNT_MAX: _bindgen_ty_16 = 2;
pub type _bindgen_ty_16 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfr_tstats {
    pub pfrts_t: pfr_table,
    pub pfrts_packets: [[u_int64_t; 3usize]; 2usize],
    pub pfrts_bytes: [[u_int64_t; 3usize]; 2usize],
    pub pfrts_match: u_int64_t,
    pub pfrts_nomatch: u_int64_t,
    pub pfrts_tzero: u_int64_t,
    pub pfrts_cnt: ::std::os::raw::c_int,
    pub pfrts_refcnt: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout_pfr_tstats() {
    const UNINIT: ::std::mem::MaybeUninit<pfr_tstats> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfr_tstats>(),
        1200usize,
        concat!("Size of: ", stringify!(pfr_tstats))
    );
    assert_eq!(
        ::std::mem::align_of::<pfr_tstats>(),
        8usize,
        concat!("Alignment of ", stringify!(pfr_tstats))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrts_t) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfr_tstats), "::", stringify!(pfrts_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrts_packets) as usize - ptr as usize },
        1064usize,
        concat!(
            "Offset of field: ",
            stringify!(pfr_tstats),
            "::",
            stringify!(pfrts_packets)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrts_bytes) as usize - ptr as usize },
        1112usize,
        concat!(
            "Offset of field: ",
            stringify!(pfr_tstats),
            "::",
            stringify!(pfrts_bytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrts_match) as usize - ptr as usize },
        1160usize,
        concat!(
            "Offset of field: ",
            stringify!(pfr_tstats),
            "::",
            stringify!(pfrts_match)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrts_nomatch) as usize - ptr as usize },
        1168usize,
        concat!(
            "Offset of field: ",
            stringify!(pfr_tstats),
            "::",
            stringify!(pfrts_nomatch)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrts_tzero) as usize - ptr as usize },
        1176usize,
        concat!(
            "Offset of field: ",
            stringify!(pfr_tstats),
            "::",
            stringify!(pfrts_tzero)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrts_cnt) as usize - ptr as usize },
        1184usize,
        concat!("Offset of field: ", stringify!(pfr_tstats), "::", stringify!(pfrts_cnt))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrts_refcnt) as usize - ptr as usize },
        1188usize,
        concat!(
            "Offset of field: ",
            stringify!(pfr_tstats),
            "::",
            stringify!(pfrts_refcnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfi_kif {
    pub pfik_name: [::std::os::raw::c_char; 16usize],
    pub pfik_packets: [[[u_int64_t; 2usize]; 2usize]; 2usize],
    pub pfik_bytes: [[[u_int64_t; 2usize]; 2usize]; 2usize],
    pub pfik_tzero: u_int64_t,
    pub pfik_flags: ::std::os::raw::c_int,
    pub pfik_states: ::std::os::raw::c_int,
    pub pfik_rules: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pfi_kif() {
    const UNINIT: ::std::mem::MaybeUninit<pfi_kif> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfi_kif>(),
        168usize,
        concat!("Size of: ", stringify!(pfi_kif))
    );
    assert_eq!(
        ::std::mem::align_of::<pfi_kif>(),
        8usize,
        concat!("Alignment of ", stringify!(pfi_kif))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfik_name) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfi_kif), "::", stringify!(pfik_name))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfik_packets) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(pfi_kif), "::", stringify!(pfik_packets))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfik_bytes) as usize - ptr as usize },
        80usize,
        concat!("Offset of field: ", stringify!(pfi_kif), "::", stringify!(pfik_bytes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfik_tzero) as usize - ptr as usize },
        144usize,
        concat!("Offset of field: ", stringify!(pfi_kif), "::", stringify!(pfik_tzero))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfik_flags) as usize - ptr as usize },
        152usize,
        concat!("Offset of field: ", stringify!(pfi_kif), "::", stringify!(pfik_flags))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfik_states) as usize - ptr as usize },
        156usize,
        concat!("Offset of field: ", stringify!(pfi_kif), "::", stringify!(pfik_states))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfik_rules) as usize - ptr as usize },
        160usize,
        concat!("Offset of field: ", stringify!(pfi_kif), "::", stringify!(pfik_rules))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_status {
    pub counters: [u_int64_t; 16usize],
    pub lcounters: [u_int64_t; 7usize],
    pub fcounters: [u_int64_t; 3usize],
    pub scounters: [u_int64_t; 3usize],
    pub pcounters: [[[u_int64_t; 3usize]; 2usize]; 2usize],
    pub bcounters: [[u_int64_t; 2usize]; 2usize],
    pub stateid: u_int64_t,
    pub running: u_int32_t,
    pub states: u_int32_t,
    pub src_nodes: u_int32_t,
    pub since: u_int64_t,
    pub debug: u_int32_t,
    pub hostid: u_int32_t,
    pub ifname: [::std::os::raw::c_char; 16usize],
    pub pf_chksum: [u_int8_t; 16usize],
}
#[test]
fn bindgen_test_layout_pf_status() {
    const UNINIT: ::std::mem::MaybeUninit<pf_status> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_status>(),
        432usize,
        concat!("Size of: ", stringify!(pf_status))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_status>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_status))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).counters) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(counters))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lcounters) as usize - ptr as usize },
        128usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(lcounters))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fcounters) as usize - ptr as usize },
        184usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(fcounters))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scounters) as usize - ptr as usize },
        208usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(scounters))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pcounters) as usize - ptr as usize },
        232usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(pcounters))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bcounters) as usize - ptr as usize },
        328usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(bcounters))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stateid) as usize - ptr as usize },
        360usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(stateid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).running) as usize - ptr as usize },
        368usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(running))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).states) as usize - ptr as usize },
        372usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(states))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).src_nodes) as usize - ptr as usize },
        376usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(src_nodes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).since) as usize - ptr as usize },
        384usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(since))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).debug) as usize - ptr as usize },
        392usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(debug))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hostid) as usize - ptr as usize },
        396usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(hostid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifname) as usize - ptr as usize },
        400usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(ifname))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pf_chksum) as usize - ptr as usize },
        416usize,
        concat!("Offset of field: ", stringify!(pf_status), "::", stringify!(pf_chksum))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cbq_opts {
    pub minburst: u_int32_t,
    pub maxburst: u_int32_t,
    pub pktsize: u_int32_t,
    pub maxpktsize: u_int32_t,
    pub ns_per_byte: u_int32_t,
    pub maxidle: u_int32_t,
    pub minidle: i32,
    pub offtime: u_int32_t,
    pub flags: u_int32_t,
}
#[test]
fn bindgen_test_layout_cbq_opts() {
    const UNINIT: ::std::mem::MaybeUninit<cbq_opts> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<cbq_opts>(),
        36usize,
        concat!("Size of: ", stringify!(cbq_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<cbq_opts>(),
        4usize,
        concat!("Alignment of ", stringify!(cbq_opts))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).minburst) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(cbq_opts), "::", stringify!(minburst))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).maxburst) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(cbq_opts), "::", stringify!(maxburst))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pktsize) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(cbq_opts), "::", stringify!(pktsize))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).maxpktsize) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(cbq_opts), "::", stringify!(maxpktsize))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ns_per_byte) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(cbq_opts), "::", stringify!(ns_per_byte))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).maxidle) as usize - ptr as usize },
        20usize,
        concat!("Offset of field: ", stringify!(cbq_opts), "::", stringify!(maxidle))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).minidle) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(cbq_opts), "::", stringify!(minidle))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offtime) as usize - ptr as usize },
        28usize,
        concat!("Offset of field: ", stringify!(cbq_opts), "::", stringify!(offtime))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(cbq_opts), "::", stringify!(flags))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct priq_opts {
    pub flags: u_int32_t,
}
#[test]
fn bindgen_test_layout_priq_opts() {
    const UNINIT: ::std::mem::MaybeUninit<priq_opts> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<priq_opts>(),
        4usize,
        concat!("Size of: ", stringify!(priq_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<priq_opts>(),
        4usize,
        concat!("Alignment of ", stringify!(priq_opts))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(priq_opts), "::", stringify!(flags))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hfsc_opts {
    pub rtsc_m1: u_int64_t,
    pub rtsc_d: u_int64_t,
    pub rtsc_m2: u_int64_t,
    pub rtsc_fl: u_int32_t,
    pub lssc_m1: u_int64_t,
    pub lssc_d: u_int64_t,
    pub lssc_m2: u_int64_t,
    pub lssc_fl: u_int32_t,
    pub ulsc_m1: u_int64_t,
    pub ulsc_d: u_int64_t,
    pub ulsc_m2: u_int64_t,
    pub ulsc_fl: u_int32_t,
    pub flags: u_int32_t,
}
#[test]
fn bindgen_test_layout_hfsc_opts() {
    const UNINIT: ::std::mem::MaybeUninit<hfsc_opts> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<hfsc_opts>(),
        96usize,
        concat!("Size of: ", stringify!(hfsc_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<hfsc_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(hfsc_opts))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtsc_m1) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(hfsc_opts), "::", stringify!(rtsc_m1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtsc_d) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(hfsc_opts), "::", stringify!(rtsc_d))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtsc_m2) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(hfsc_opts), "::", stringify!(rtsc_m2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rtsc_fl) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(hfsc_opts), "::", stringify!(rtsc_fl))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lssc_m1) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(hfsc_opts), "::", stringify!(lssc_m1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lssc_d) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(hfsc_opts), "::", stringify!(lssc_d))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lssc_m2) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(hfsc_opts), "::", stringify!(lssc_m2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lssc_fl) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(hfsc_opts), "::", stringify!(lssc_fl))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ulsc_m1) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(hfsc_opts), "::", stringify!(ulsc_m1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ulsc_d) as usize - ptr as usize },
        72usize,
        concat!("Offset of field: ", stringify!(hfsc_opts), "::", stringify!(ulsc_d))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ulsc_m2) as usize - ptr as usize },
        80usize,
        concat!("Offset of field: ", stringify!(hfsc_opts), "::", stringify!(ulsc_m2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ulsc_fl) as usize - ptr as usize },
        88usize,
        concat!("Offset of field: ", stringify!(hfsc_opts), "::", stringify!(ulsc_fl))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        92usize,
        concat!("Offset of field: ", stringify!(hfsc_opts), "::", stringify!(flags))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fairq_opts {
    pub nbuckets: u_int32_t,
    pub flags: u_int32_t,
    pub hogs_m1: u_int64_t,
    pub lssc_m1: u_int64_t,
    pub lssc_d: u_int64_t,
    pub lssc_m2: u_int64_t,
}
#[test]
fn bindgen_test_layout_fairq_opts() {
    const UNINIT: ::std::mem::MaybeUninit<fairq_opts> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<fairq_opts>(),
        40usize,
        concat!("Size of: ", stringify!(fairq_opts))
    );
    assert_eq!(
        ::std::mem::align_of::<fairq_opts>(),
        8usize,
        concat!("Alignment of ", stringify!(fairq_opts))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nbuckets) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(fairq_opts), "::", stringify!(nbuckets))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(fairq_opts), "::", stringify!(flags))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hogs_m1) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(fairq_opts), "::", stringify!(hogs_m1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lssc_m1) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(fairq_opts), "::", stringify!(lssc_m1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lssc_d) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(fairq_opts), "::", stringify!(lssc_d))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lssc_m2) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(fairq_opts), "::", stringify!(lssc_m2))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pf_altq {
    pub ifname: [::std::os::raw::c_char; 16usize],
    pub altq_disc: *mut ::std::os::raw::c_void,
    pub entries: pf_altq__bindgen_ty_1,
    pub aflags: u_int32_t,
    pub bwtype: u_int32_t,
    pub scheduler: u_int32_t,
    pub tbrsize: u_int32_t,
    pub ifbandwidth: u_int64_t,
    pub qname: [::std::os::raw::c_char; 64usize],
    pub parent: [::std::os::raw::c_char; 64usize],
    pub parent_qid: u_int32_t,
    pub qrflags: u_int32_t,
    pub __bindgen_anon_1: pf_altq__bindgen_ty_2,
    pub qlimit: u_int32_t,
    pub flags: u_int32_t,
    pub bandwidth: u_int64_t,
    pub pq_u: pf_altq__bindgen_ty_3,
    pub qid: u_int32_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_altq__bindgen_ty_1 {
    pub tqe_next: *mut pf_altq,
    pub tqe_prev: *mut *mut pf_altq,
}
#[test]
fn bindgen_test_layout_pf_altq__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_altq__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_altq__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(pf_altq__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_altq__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_altq__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_altq__bindgen_ty_1),
            "::",
            stringify!(tqe_next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_prev) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_altq__bindgen_ty_1),
            "::",
            stringify!(tqe_prev)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pf_altq__bindgen_ty_2 {
    pub priority: u_int32_t,
    pub weight: u_int32_t,
}
#[test]
fn bindgen_test_layout_pf_altq__bindgen_ty_2() {
    const UNINIT: ::std::mem::MaybeUninit<pf_altq__bindgen_ty_2> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_altq__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(pf_altq__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_altq__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(pf_altq__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).priority) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_altq__bindgen_ty_2),
            "::",
            stringify!(priority)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).weight) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_altq__bindgen_ty_2),
            "::",
            stringify!(weight)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pf_altq__bindgen_ty_3 {
    pub cbq_opts: cbq_opts,
    pub priq_opts: priq_opts,
    pub hfsc_opts: hfsc_opts,
    pub fairq_opts: fairq_opts,
}
#[test]
fn bindgen_test_layout_pf_altq__bindgen_ty_3() {
    const UNINIT: ::std::mem::MaybeUninit<pf_altq__bindgen_ty_3> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_altq__bindgen_ty_3>(),
        96usize,
        concat!("Size of: ", stringify!(pf_altq__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_altq__bindgen_ty_3>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_altq__bindgen_ty_3))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cbq_opts) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_altq__bindgen_ty_3),
            "::",
            stringify!(cbq_opts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).priq_opts) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_altq__bindgen_ty_3),
            "::",
            stringify!(priq_opts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hfsc_opts) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_altq__bindgen_ty_3),
            "::",
            stringify!(hfsc_opts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fairq_opts) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_altq__bindgen_ty_3),
            "::",
            stringify!(fairq_opts)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_altq() {
    const UNINIT: ::std::mem::MaybeUninit<pf_altq> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_altq>(),
        328usize,
        concat!("Size of: ", stringify!(pf_altq))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_altq>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_altq))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifname) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(ifname))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).altq_disc) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(altq_disc))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        24usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(entries))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).aflags) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(aflags))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bwtype) as usize - ptr as usize },
        44usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(bwtype))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scheduler) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(scheduler))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tbrsize) as usize - ptr as usize },
        52usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(tbrsize))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifbandwidth) as usize - ptr as usize },
        56usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(ifbandwidth))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).qname) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(qname))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent) as usize - ptr as usize },
        128usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(parent))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parent_qid) as usize - ptr as usize },
        192usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(parent_qid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).qrflags) as usize - ptr as usize },
        196usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(qrflags))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).qlimit) as usize - ptr as usize },
        204usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(qlimit))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        208usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(flags))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bandwidth) as usize - ptr as usize },
        216usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(bandwidth))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pq_u) as usize - ptr as usize },
        224usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(pq_u))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).qid) as usize - ptr as usize },
        320usize,
        concat!("Offset of field: ", stringify!(pf_altq), "::", stringify!(qid))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_tagname {
    pub entries: pf_tagname__bindgen_ty_1,
    pub name: [::std::os::raw::c_char; 64usize],
    pub tag: u_int16_t,
    pub ref_: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_tagname__bindgen_ty_1 {
    pub tqe_next: *mut pf_tagname,
    pub tqe_prev: *mut *mut pf_tagname,
}
#[test]
fn bindgen_test_layout_pf_tagname__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pf_tagname__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_tagname__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(pf_tagname__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_tagname__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_tagname__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_tagname__bindgen_ty_1),
            "::",
            stringify!(tqe_next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tqe_prev) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pf_tagname__bindgen_ty_1),
            "::",
            stringify!(tqe_prev)
        )
    );
}
#[test]
fn bindgen_test_layout_pf_tagname() {
    const UNINIT: ::std::mem::MaybeUninit<pf_tagname> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_tagname>(),
        88usize,
        concat!("Size of: ", stringify!(pf_tagname))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_tagname>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_tagname))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).entries) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_tagname), "::", stringify!(entries))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(pf_tagname), "::", stringify!(name))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tag) as usize - ptr as usize },
        80usize,
        concat!("Offset of field: ", stringify!(pf_tagname), "::", stringify!(tag))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ref_) as usize - ptr as usize },
        84usize,
        concat!("Offset of field: ", stringify!(pf_tagname), "::", stringify!(ref_))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pfioc_pooladdr {
    pub action: u_int32_t,
    pub ticket: u_int32_t,
    pub nr: u_int32_t,
    pub r_num: u_int32_t,
    pub r_action: u_int8_t,
    pub r_last: u_int8_t,
    pub af: u_int8_t,
    pub anchor: [::std::os::raw::c_char; 1024usize],
    pub addr: pf_pooladdr,
}
#[test]
fn bindgen_test_layout_pfioc_pooladdr() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_pooladdr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_pooladdr>(),
        1136usize,
        concat!("Size of: ", stringify!(pfioc_pooladdr))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_pooladdr>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_pooladdr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).action) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_pooladdr),
            "::",
            stringify!(action)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ticket) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_pooladdr),
            "::",
            stringify!(ticket)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(pfioc_pooladdr), "::", stringify!(nr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r_num) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(pfioc_pooladdr), "::", stringify!(r_num))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r_action) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_pooladdr),
            "::",
            stringify!(r_action)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r_last) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_pooladdr),
            "::",
            stringify!(r_last)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).af) as usize - ptr as usize },
        18usize,
        concat!("Offset of field: ", stringify!(pfioc_pooladdr), "::", stringify!(af))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).anchor) as usize - ptr as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_pooladdr),
            "::",
            stringify!(anchor)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        1048usize,
        concat!("Offset of field: ", stringify!(pfioc_pooladdr), "::", stringify!(addr))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pfioc_rule {
    pub action: u_int32_t,
    pub ticket: u_int32_t,
    pub pool_ticket: u_int32_t,
    pub nr: u_int32_t,
    pub anchor: [::std::os::raw::c_char; 1024usize],
    pub anchor_call: [::std::os::raw::c_char; 1024usize],
    pub rule: pf_rule,
}
#[test]
fn bindgen_test_layout_pfioc_rule() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_rule> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_rule>(),
        3104usize,
        concat!("Size of: ", stringify!(pfioc_rule))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_rule>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_rule))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).action) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfioc_rule), "::", stringify!(action))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ticket) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(pfioc_rule), "::", stringify!(ticket))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pool_ticket) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_rule),
            "::",
            stringify!(pool_ticket)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        12usize,
        concat!("Offset of field: ", stringify!(pfioc_rule), "::", stringify!(nr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).anchor) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(pfioc_rule), "::", stringify!(anchor))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).anchor_call) as usize - ptr as usize },
        1040usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_rule),
            "::",
            stringify!(anchor_call)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rule) as usize - ptr as usize },
        2064usize,
        concat!("Offset of field: ", stringify!(pfioc_rule), "::", stringify!(rule))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pfioc_natlook {
    pub saddr: pf_addr,
    pub daddr: pf_addr,
    pub rsaddr: pf_addr,
    pub rdaddr: pf_addr,
    pub sxport: pf_state_xport,
    pub dxport: pf_state_xport,
    pub rsxport: pf_state_xport,
    pub rdxport: pf_state_xport,
    pub af: sa_family_t,
    pub proto: u_int8_t,
    pub proto_variant: u_int8_t,
    pub direction: u_int8_t,
}
#[test]
fn bindgen_test_layout_pfioc_natlook() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_natlook> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_natlook>(),
        84usize,
        concat!("Size of: ", stringify!(pfioc_natlook))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_natlook>(),
        4usize,
        concat!("Alignment of ", stringify!(pfioc_natlook))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).saddr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfioc_natlook), "::", stringify!(saddr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).daddr) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(pfioc_natlook), "::", stringify!(daddr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rsaddr) as usize - ptr as usize },
        32usize,
        concat!("Offset of field: ", stringify!(pfioc_natlook), "::", stringify!(rsaddr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rdaddr) as usize - ptr as usize },
        48usize,
        concat!("Offset of field: ", stringify!(pfioc_natlook), "::", stringify!(rdaddr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sxport) as usize - ptr as usize },
        64usize,
        concat!("Offset of field: ", stringify!(pfioc_natlook), "::", stringify!(sxport))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dxport) as usize - ptr as usize },
        68usize,
        concat!("Offset of field: ", stringify!(pfioc_natlook), "::", stringify!(dxport))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rsxport) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_natlook),
            "::",
            stringify!(rsxport)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rdxport) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_natlook),
            "::",
            stringify!(rdxport)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).af) as usize - ptr as usize },
        80usize,
        concat!("Offset of field: ", stringify!(pfioc_natlook), "::", stringify!(af))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).proto) as usize - ptr as usize },
        81usize,
        concat!("Offset of field: ", stringify!(pfioc_natlook), "::", stringify!(proto))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).proto_variant) as usize - ptr as usize },
        82usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_natlook),
            "::",
            stringify!(proto_variant)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).direction) as usize - ptr as usize },
        83usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_natlook),
            "::",
            stringify!(direction)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pfioc_state {
    pub state: pfsync_state,
}
#[test]
fn bindgen_test_layout_pfioc_state() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_state> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_state>(),
        297usize,
        concat!("Size of: ", stringify!(pfioc_state))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_state>(),
        1usize,
        concat!("Alignment of ", stringify!(pfioc_state))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfioc_state), "::", stringify!(state))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pfioc_src_node_kill {
    pub psnk_af: sa_family_t,
    pub psnk_src: pf_rule_addr,
    pub psnk_dst: pf_rule_addr,
}
#[test]
fn bindgen_test_layout_pfioc_src_node_kill() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_src_node_kill> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_src_node_kill>(),
        136usize,
        concat!("Size of: ", stringify!(pfioc_src_node_kill))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_src_node_kill>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_src_node_kill))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psnk_af) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_src_node_kill),
            "::",
            stringify!(psnk_af)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psnk_src) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_src_node_kill),
            "::",
            stringify!(psnk_src)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psnk_dst) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_src_node_kill),
            "::",
            stringify!(psnk_dst)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pfioc_state_addr_kill {
    pub addr: pf_addr_wrap,
    pub reserved_: [u_int8_t; 3usize],
    pub neg: u_int8_t,
    pub xport: pf_rule_xport,
}
#[test]
fn bindgen_test_layout_pfioc_state_addr_kill() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_state_addr_kill> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_state_addr_kill>(),
        64usize,
        concat!("Size of: ", stringify!(pfioc_state_addr_kill))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_state_addr_kill>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_state_addr_kill))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_state_addr_kill),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved_) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_state_addr_kill),
            "::",
            stringify!(reserved_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).neg) as usize - ptr as usize },
        51usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_state_addr_kill),
            "::",
            stringify!(neg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xport) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_state_addr_kill),
            "::",
            stringify!(xport)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pfioc_state_kill {
    pub psk_af: sa_family_t,
    pub psk_proto: u_int8_t,
    pub psk_proto_variant: u_int8_t,
    pub _pad: u_int8_t,
    pub psk_src: pfioc_state_addr_kill,
    pub psk_dst: pfioc_state_addr_kill,
    pub psk_ifname: [::std::os::raw::c_char; 16usize],
    pub psk_ownername: [::std::os::raw::c_char; 64usize],
}
#[test]
fn bindgen_test_layout_pfioc_state_kill() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_state_kill> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_state_kill>(),
        216usize,
        concat!("Size of: ", stringify!(pfioc_state_kill))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_state_kill>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_state_kill))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psk_af) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_state_kill),
            "::",
            stringify!(psk_af)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psk_proto) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_state_kill),
            "::",
            stringify!(psk_proto)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psk_proto_variant) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_state_kill),
            "::",
            stringify!(psk_proto_variant)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._pad) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_state_kill),
            "::",
            stringify!(_pad)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psk_src) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_state_kill),
            "::",
            stringify!(psk_src)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psk_dst) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_state_kill),
            "::",
            stringify!(psk_dst)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psk_ifname) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_state_kill),
            "::",
            stringify!(psk_ifname)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psk_ownername) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_state_kill),
            "::",
            stringify!(psk_ownername)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pfioc_states {
    pub ps_len: ::std::os::raw::c_int,
    pub ps_u: pfioc_states__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pfioc_states__bindgen_ty_1 {
    pub psu_buf: caddr_t,
    pub psu_states: *mut pfsync_state,
}
#[test]
fn bindgen_test_layout_pfioc_states__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_states__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_states__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(pfioc_states__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_states__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_states__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psu_buf) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_states__bindgen_ty_1),
            "::",
            stringify!(psu_buf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psu_states) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_states__bindgen_ty_1),
            "::",
            stringify!(psu_states)
        )
    );
}
#[test]
fn bindgen_test_layout_pfioc_states() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_states> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_states>(),
        16usize,
        concat!("Size of: ", stringify!(pfioc_states))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_states>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_states))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ps_len) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfioc_states), "::", stringify!(ps_len))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ps_u) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(pfioc_states), "::", stringify!(ps_u))
    );
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct pfioc_token {
    pub token_value: u_int64_t,
    pub timestamp: u_int64_t,
    pub pid: pid_t,
    pub proc_name: [::std::os::raw::c_char; 64usize],
}
#[test]
fn bindgen_test_layout_pfioc_token() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_token> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_token>(),
        84usize,
        concat!("Size of: ", stringify!(pfioc_token))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_token>(),
        1usize,
        concat!("Alignment of ", stringify!(pfioc_token))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).token_value) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_token),
            "::",
            stringify!(token_value)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timestamp) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_token),
            "::",
            stringify!(timestamp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pid) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(pfioc_token), "::", stringify!(pid))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).proc_name) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_token),
            "::",
            stringify!(proc_name)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfioc_kernel_token {
    pub next: pfioc_kernel_token__bindgen_ty_1,
    pub token: pfioc_token,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfioc_kernel_token__bindgen_ty_1 {
    pub sle_next: *mut pfioc_kernel_token,
}
#[test]
fn bindgen_test_layout_pfioc_kernel_token__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_kernel_token__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_kernel_token__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(pfioc_kernel_token__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_kernel_token__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_kernel_token__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sle_next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_kernel_token__bindgen_ty_1),
            "::",
            stringify!(sle_next)
        )
    );
}
#[test]
fn bindgen_test_layout_pfioc_kernel_token() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_kernel_token> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_kernel_token>(),
        96usize,
        concat!("Size of: ", stringify!(pfioc_kernel_token))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_kernel_token>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_kernel_token))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_kernel_token),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).token) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_kernel_token),
            "::",
            stringify!(token)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfioc_remove_token {
    pub token_value: u_int64_t,
    pub refcount: u_int64_t,
}
#[test]
fn bindgen_test_layout_pfioc_remove_token() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_remove_token> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_remove_token>(),
        16usize,
        concat!("Size of: ", stringify!(pfioc_remove_token))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_remove_token>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_remove_token))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).token_value) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_remove_token),
            "::",
            stringify!(token_value)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).refcount) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_remove_token),
            "::",
            stringify!(refcount)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pfioc_tokens {
    pub size: ::std::os::raw::c_int,
    pub pgt_u: pfioc_tokens__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pfioc_tokens__bindgen_ty_1 {
    pub pgtu_buf: caddr_t,
    pub pgtu_tokens: *mut pfioc_token,
}
#[test]
fn bindgen_test_layout_pfioc_tokens__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_tokens__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_tokens__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(pfioc_tokens__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_tokens__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_tokens__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pgtu_buf) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_tokens__bindgen_ty_1),
            "::",
            stringify!(pgtu_buf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pgtu_tokens) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_tokens__bindgen_ty_1),
            "::",
            stringify!(pgtu_tokens)
        )
    );
}
#[test]
fn bindgen_test_layout_pfioc_tokens() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_tokens> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_tokens>(),
        16usize,
        concat!("Size of: ", stringify!(pfioc_tokens))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_tokens>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_tokens))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfioc_tokens), "::", stringify!(size))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pgt_u) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(pfioc_tokens), "::", stringify!(pgt_u))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pfioc_src_nodes {
    pub psn_len: ::std::os::raw::c_int,
    pub psn_u: pfioc_src_nodes__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pfioc_src_nodes__bindgen_ty_1 {
    pub psu_buf: caddr_t,
    pub psu_src_nodes: *mut pf_src_node,
}
#[test]
fn bindgen_test_layout_pfioc_src_nodes__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_src_nodes__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_src_nodes__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(pfioc_src_nodes__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_src_nodes__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_src_nodes__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psu_buf) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_src_nodes__bindgen_ty_1),
            "::",
            stringify!(psu_buf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psu_src_nodes) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_src_nodes__bindgen_ty_1),
            "::",
            stringify!(psu_src_nodes)
        )
    );
}
#[test]
fn bindgen_test_layout_pfioc_src_nodes() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_src_nodes> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_src_nodes>(),
        16usize,
        concat!("Size of: ", stringify!(pfioc_src_nodes))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_src_nodes>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_src_nodes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psn_len) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_src_nodes),
            "::",
            stringify!(psn_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).psn_u) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_src_nodes),
            "::",
            stringify!(psn_u)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfioc_if {
    pub ifname: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout_pfioc_if() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_if> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_if>(),
        16usize,
        concat!("Size of: ", stringify!(pfioc_if))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_if>(),
        1usize,
        concat!("Alignment of ", stringify!(pfioc_if))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifname) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfioc_if), "::", stringify!(ifname))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfioc_tm {
    pub timeout: ::std::os::raw::c_int,
    pub seconds: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pfioc_tm() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_tm> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_tm>(),
        8usize,
        concat!("Size of: ", stringify!(pfioc_tm))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_tm>(),
        4usize,
        concat!("Alignment of ", stringify!(pfioc_tm))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).timeout) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfioc_tm), "::", stringify!(timeout))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seconds) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(pfioc_tm), "::", stringify!(seconds))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfioc_limit {
    pub index: ::std::os::raw::c_int,
    pub limit: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pfioc_limit() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_limit> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_limit>(),
        8usize,
        concat!("Size of: ", stringify!(pfioc_limit))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_limit>(),
        4usize,
        concat!("Alignment of ", stringify!(pfioc_limit))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfioc_limit), "::", stringify!(index))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).limit) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(pfioc_limit), "::", stringify!(limit))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pfioc_altq {
    pub action: u_int32_t,
    pub ticket: u_int32_t,
    pub nr: u_int32_t,
    pub altq: pf_altq,
}
#[test]
fn bindgen_test_layout_pfioc_altq() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_altq> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_altq>(),
        344usize,
        concat!("Size of: ", stringify!(pfioc_altq))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_altq>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_altq))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).action) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfioc_altq), "::", stringify!(action))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ticket) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(pfioc_altq), "::", stringify!(ticket))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(pfioc_altq), "::", stringify!(nr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).altq) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(pfioc_altq), "::", stringify!(altq))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfioc_qstats {
    pub ticket: u_int32_t,
    pub nr: u_int32_t,
    pub buf: *mut ::std::os::raw::c_void,
    pub nbytes: ::std::os::raw::c_int,
    pub scheduler: u_int8_t,
}
#[test]
fn bindgen_test_layout_pfioc_qstats() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_qstats> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_qstats>(),
        24usize,
        concat!("Size of: ", stringify!(pfioc_qstats))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_qstats>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_qstats))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ticket) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfioc_qstats), "::", stringify!(ticket))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(pfioc_qstats), "::", stringify!(nr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buf) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(pfioc_qstats), "::", stringify!(buf))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nbytes) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(pfioc_qstats), "::", stringify!(nbytes))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scheduler) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_qstats),
            "::",
            stringify!(scheduler)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfioc_ruleset {
    pub nr: u_int32_t,
    pub path: [::std::os::raw::c_char; 1024usize],
    pub name: [::std::os::raw::c_char; 64usize],
}
#[test]
fn bindgen_test_layout_pfioc_ruleset() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_ruleset> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_ruleset>(),
        1092usize,
        concat!("Size of: ", stringify!(pfioc_ruleset))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_ruleset>(),
        4usize,
        concat!("Alignment of ", stringify!(pfioc_ruleset))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nr) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfioc_ruleset), "::", stringify!(nr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).path) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(pfioc_ruleset), "::", stringify!(path))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        1028usize,
        concat!("Offset of field: ", stringify!(pfioc_ruleset), "::", stringify!(name))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfioc_trans {
    pub size: ::std::os::raw::c_int,
    pub esize: ::std::os::raw::c_int,
    pub array: *mut pfioc_trans_pfioc_trans_e,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfioc_trans_pfioc_trans_e {
    pub rs_num: ::std::os::raw::c_int,
    pub anchor: [::std::os::raw::c_char; 1024usize],
    pub ticket: u_int32_t,
}
#[test]
fn bindgen_test_layout_pfioc_trans_pfioc_trans_e() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_trans_pfioc_trans_e> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_trans_pfioc_trans_e>(),
        1032usize,
        concat!("Size of: ", stringify!(pfioc_trans_pfioc_trans_e))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_trans_pfioc_trans_e>(),
        4usize,
        concat!("Alignment of ", stringify!(pfioc_trans_pfioc_trans_e))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rs_num) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_trans_pfioc_trans_e),
            "::",
            stringify!(rs_num)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).anchor) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_trans_pfioc_trans_e),
            "::",
            stringify!(anchor)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ticket) as usize - ptr as usize },
        1028usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_trans_pfioc_trans_e),
            "::",
            stringify!(ticket)
        )
    );
}
#[test]
fn bindgen_test_layout_pfioc_trans() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_trans> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_trans>(),
        16usize,
        concat!("Size of: ", stringify!(pfioc_trans))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_trans>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_trans))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pfioc_trans), "::", stringify!(size))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).esize) as usize - ptr as usize },
        4usize,
        concat!("Offset of field: ", stringify!(pfioc_trans), "::", stringify!(esize))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).array) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(pfioc_trans), "::", stringify!(array))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfioc_table {
    pub pfrio_table: pfr_table,
    pub pfrio_buffer: *mut ::std::os::raw::c_void,
    pub pfrio_esize: ::std::os::raw::c_int,
    pub pfrio_size: ::std::os::raw::c_int,
    pub pfrio_size2: ::std::os::raw::c_int,
    pub pfrio_nadd: ::std::os::raw::c_int,
    pub pfrio_ndel: ::std::os::raw::c_int,
    pub pfrio_nchange: ::std::os::raw::c_int,
    pub pfrio_flags: ::std::os::raw::c_int,
    pub pfrio_ticket: u_int32_t,
}
#[test]
fn bindgen_test_layout_pfioc_table() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_table> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_table>(),
        1104usize,
        concat!("Size of: ", stringify!(pfioc_table))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_table>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_table))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrio_table) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_table),
            "::",
            stringify!(pfrio_table)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrio_buffer) as usize - ptr as usize },
        1064usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_table),
            "::",
            stringify!(pfrio_buffer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrio_esize) as usize - ptr as usize },
        1072usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_table),
            "::",
            stringify!(pfrio_esize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrio_size) as usize - ptr as usize },
        1076usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_table),
            "::",
            stringify!(pfrio_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrio_size2) as usize - ptr as usize },
        1080usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_table),
            "::",
            stringify!(pfrio_size2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrio_nadd) as usize - ptr as usize },
        1084usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_table),
            "::",
            stringify!(pfrio_nadd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrio_ndel) as usize - ptr as usize },
        1088usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_table),
            "::",
            stringify!(pfrio_ndel)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrio_nchange) as usize - ptr as usize },
        1092usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_table),
            "::",
            stringify!(pfrio_nchange)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrio_flags) as usize - ptr as usize },
        1096usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_table),
            "::",
            stringify!(pfrio_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfrio_ticket) as usize - ptr as usize },
        1100usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_table),
            "::",
            stringify!(pfrio_ticket)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pfioc_iface {
    pub pfiio_name: [::std::os::raw::c_char; 16usize],
    pub pfiio_buffer: *mut ::std::os::raw::c_void,
    pub pfiio_esize: ::std::os::raw::c_int,
    pub pfiio_size: ::std::os::raw::c_int,
    pub pfiio_nzero: ::std::os::raw::c_int,
    pub pfiio_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pfioc_iface() {
    const UNINIT: ::std::mem::MaybeUninit<pfioc_iface> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pfioc_iface>(),
        40usize,
        concat!("Size of: ", stringify!(pfioc_iface))
    );
    assert_eq!(
        ::std::mem::align_of::<pfioc_iface>(),
        8usize,
        concat!("Alignment of ", stringify!(pfioc_iface))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfiio_name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_iface),
            "::",
            stringify!(pfiio_name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfiio_buffer) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_iface),
            "::",
            stringify!(pfiio_buffer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfiio_esize) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_iface),
            "::",
            stringify!(pfiio_esize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfiio_size) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_iface),
            "::",
            stringify!(pfiio_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfiio_nzero) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_iface),
            "::",
            stringify!(pfiio_nzero)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pfiio_flags) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(pfioc_iface),
            "::",
            stringify!(pfiio_flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pf_ifspeed {
    pub ifname: [::std::os::raw::c_char; 16usize],
    pub baudrate: u_int64_t,
}
#[test]
fn bindgen_test_layout_pf_ifspeed() {
    const UNINIT: ::std::mem::MaybeUninit<pf_ifspeed> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pf_ifspeed>(),
        24usize,
        concat!("Size of: ", stringify!(pf_ifspeed))
    );
    assert_eq!(
        ::std::mem::align_of::<pf_ifspeed>(),
        8usize,
        concat!("Alignment of ", stringify!(pf_ifspeed))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ifname) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(pf_ifspeed), "::", stringify!(ifname))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).baudrate) as usize - ptr as usize },
        16usize,
        concat!("Offset of field: ", stringify!(pf_ifspeed), "::", stringify!(baudrate))
    );
}
extern "C" {
    pub static mut pf_anchors: pf_anchor_global;
}
extern "C" {
    pub static mut pf_main_anchor: pf_anchor;
}
extern "C" {
    pub fn pf_get_ruleset_number(arg1: u_int8_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pf_init_ruleset(arg1: *mut pf_ruleset);
}
extern "C" {
    pub fn pf_anchor_setup(
        arg1: *mut pf_rule,
        arg2: *const pf_ruleset,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pf_anchor_copyout(
        arg1: *const pf_ruleset,
        arg2: *const pf_rule,
        arg3: *mut pfioc_rule,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pf_anchor_remove(arg1: *mut pf_rule);
}
extern "C" {
    pub fn pf_remove_if_empty_ruleset(arg1: *mut pf_ruleset);
}
extern "C" {
    pub fn pf_find_anchor(arg1: *const ::std::os::raw::c_char) -> *mut pf_anchor;
}
extern "C" {
    pub fn pf_find_ruleset(arg1: *const ::std::os::raw::c_char) -> *mut pf_ruleset;
}
extern "C" {
    pub fn pf_find_ruleset_with_owner(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut pf_ruleset;
}
extern "C" {
    pub fn pf_find_or_create_ruleset(arg1: *const ::std::os::raw::c_char) -> *mut pf_ruleset;
}
extern "C" {
    pub fn pf_rs_initialize();
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___va_list_tag() {
    const UNINIT: ::std::mem::MaybeUninit<__va_list_tag> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__va_list_tag>(),
        24usize,
        concat!("Size of: ", stringify!(__va_list_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__va_list_tag))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gp_offset) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(gp_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_offset) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(fp_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).overflow_arg_area) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(overflow_arg_area)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reg_save_area) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(reg_save_area)
        )
    );
}
