---
layout: post
title: 'New font configuration API and native tabs'
date: 2023-08-29 17:53
description: 'Rio terminal release: New font configuration API, native tabs, kitty keyboard protocol and other stuff.'
categories: windows macos linux webassembly
---

This post also includes changes from v0.0.16 and v0.0.17.

## Highlights

- New font configuration API.
- Native Tabs for MacOS.

## Breaking change: New font API

If you don't use Rio default font configuration you will be affected by this change.

A new API has been introduced to select fonts, now you can configure even different font families for "regular", "bold", "italic" and "bold-italic".

```toml
[fonts]
size = 18

[fonts.regular]
family = "cascadiamono"
style = "normal"
weight = 400

[fonts.bold]
family = "cascadiamono"
style = "normal"
weight = 800

[fonts.italic]
family = "cascadiamono"
style = "italic"
weight = 400

[fonts.bold-italic]
family = "cascadiamono"
style = "italic"
weight = 800
```

## Native Tabs (macOs only)

Native tabs have arrived for MacOS users.

![native tab example](/assets/posts/0.0.17/demo-native-tabs.png)

To configure it you will need to update the configuration file and set navigation mode as "NativeTab":

```toml
[navigation]
mode = "NativeTab"
```

## Changelog of v0.0.17 along with v0.0.16

- Configuration "font" does not work anymore, a new configuration API of font selection has been introduced.
- Action "TabSwitchNext" and "TabSwitchPrev" has been renamed to "SelectNextTab" and "SelectPrevTab".
- Support to "NativeTab" (MacOS only).
- Support for kitty's keyboard protocol ("CSI u"). Ref: https://sw.kovidgoyal.net/kitty/keyboard-protocol/
- Added new actions for tab selection: "SelectTab1", "SelectTab2", "SelectTab3", "SelectTab4", "SelectTab5", "SelectTab6", "SelectTab7", "SelectTab8", "SelectTab9", "SelectLastTab".
- Support lowercased action and fix overwrite for actions in custom key bindings.
- Added action "Minimize" for minimize Rio terminal window.
- Added action "ClearHistory" for clear terminal saved history.
- Added action "ReceiveChar" for custom key bindings.
- New default key bindings for Linux and Windows so that conflicts with readline key bindings are removed.
- Winit Version 0.29.1-beta.
- Allow paste with the middle mouse of the button (fixes https://github.com/raphamorim/rio/issues/123).
- Support startup notify protocol to raise initial window on Wayland/X11.
- Fix Double-tap by touchpad on the titlebar doesn't maximize/unmaximize the window in GNOME 44, Wayland.
- Fix tab/breadcrumb bug introduced in 0.0.15
- Introduce new configuration property: "navigation.macos-hide-window-button".
