<!-- NOTE! This file is auto-generated -->

# List of supported units

See also: [Unit notation](./unit-notation.md).

All SI-accepted units support [metric prefixes](https://en.wikipedia.org/wiki/Metric_prefix) (`mm`, `cm`, `km`, ... or `millimeter`, `centimeter`, `kilometer`, ...)
and — where sensible — units allow for [binary prefixes](https://en.wikipedia.org/wiki/Binary_prefix) (`MiB`, `GiB`, ... or `mebibyte`, `gibibyte`, ...).

| Dimension | Unit name | Identifier(s) |
| --- | --- | --- |
| `AbsorbedDose` | [Gray](https://en.wikipedia.org/wiki/Gray_(unit)) | `gray`, `grays`, `Gy` |
| `Activity` | [Becquerel](https://en.wikipedia.org/wiki/Becquerel) | `becquerel`, `becquerels`, `Bq` |
| `AmountOfSubstance` | [Mole](https://en.wikipedia.org/wiki/Mole_(unit)) | `mol`, `mole`, `moles` |
| `Angle` | [Minute of arc](https://en.wikipedia.org/wiki/Minute_and_second_of_arc) | `arcmin`, `arcminute`, `arcminutes`, `′` |
| `Angle` | [Second of arc](https://en.wikipedia.org/wiki/Minute_and_second_of_arc) | `arcsec`, `arcsecond`, `arcseconds`, `″` |
| `Angle` | [Degree](https://en.wikipedia.org/wiki/Degree_(angle)) | `deg`, `degree`, `degrees`, `°` |
| `Angle` | [Gradian](https://en.wikipedia.org/wiki/Gradian) | `gon`, `gons`, `grad`, `grade`, `grades`, `gradian`, `gradians`, `grads` |
| `Angle` | [Radian](https://en.wikipedia.org/wiki/Radian) | `rad`, `radian`, `radians` |
| `Angle` | [Revolution](https://en.wikipedia.org/wiki/Revolution_(unit)) | `rev`, `revolution`, `revolutions` |
| `Angle` | [Turn](https://en.wikipedia.org/wiki/Turn_(geometry)) | `turn`, `turns` |
| `Area` | [Acre](https://en.wikipedia.org/wiki/Acre) | `acre`, `acres` |
| `Area` | [Are](https://en.wikipedia.org/wiki/Are_(unit)) | `are` |
| `Area` | [Barn](https://en.wikipedia.org/wiki/Barn_(unit)) | `barn`, `barns` |
| `Area` | [Football field](https://en.wikipedia.org/wiki/Football_pitch) | `footballfield` |
| `Area` | [Hectare](https://en.wikipedia.org/wiki/Hectare) | `ha`, `hectare`, `hectares` |
| `Beat` | [Beat](https://en.wikipedia.org/wiki/Beat_(music)) | `beat`, `beats` |
| `Beat / Time` | [Beats per minute](https://en.wikipedia.org/wiki/Tempo) | `bpm`, `BPM` |
| `Capacitance` | [Farad](https://en.wikipedia.org/wiki/Farad) | `F`, `farad`, `farads` |
| `CatalyticActivity` | [Katal](https://en.wikipedia.org/wiki/Katal) | `kat`, `katal`, `katals` |
| `Current` | [Ampere](https://en.wikipedia.org/wiki/Ampere) | `A`, `ampere`, `amperes` |
| `DataRate` | [Bits per second](https://en.wikipedia.org/wiki/Bit_per_second) | `bps` |
| `DigitalInformation` | [Bit](https://en.wikipedia.org/wiki/Bit) | `bit`, `bits` |
| `DigitalInformation` | [Byte](https://en.wikipedia.org/wiki/Byte) | `B`, `byte`, `Byte`, `bytes`, `Bytes`, `octet`, `Octet`, `octets`, `Octets` |
| `Dot` | [Dot](https://en.wikipedia.org/wiki/Dots_per_inch) | `dot`, `dots` |
| `Dot / Length` | [Dots per inch](https://en.wikipedia.org/wiki/Dots_per_inch) | `dpi` |
| `DynamicViscosity` | [Poise](https://en.wikipedia.org/wiki/Poise_(unit)) | `poise` |
| `ElectricCharge` | [Ampere-hour](https://en.wikipedia.org/wiki/Ampere_hour) | `Ah`, `amperehour` |
| `ElectricCharge` | [Coulomb](https://en.wikipedia.org/wiki/Coulomb) | `C`, `coulomb`, `coulombs` |
| `ElectricConductance` | [Siemens](https://en.wikipedia.org/wiki/Siemens_(unit)) | `S`, `siemens` |
| `ElectricResistance` | [Ohm](https://en.wikipedia.org/wiki/Ohm) | `ohm`, `ohms`, `Ω`, `Ω` |
| `Energy` | [British thermal unit](https://en.wikipedia.org/wiki/British_thermal_unit) | `BTU`, `Btu` |
| `Energy` | [Calorie](https://en.wikipedia.org/wiki/Calorie) | `cal`, `calorie`, `calories` |
| `Energy` | [Electron volt](https://en.wikipedia.org/wiki/Electronvolt) | `electronvolt`, `electronvolts`, `eV` |
| `Energy` | [Erg](https://en.wikipedia.org/wiki/Erg) | `erg`, `ergs` |
| `Energy` | [Hartree](https://en.wikipedia.org/wiki/Hartree) | `hartree`, `hartrees` |
| `Energy` | [Joule](https://en.wikipedia.org/wiki/Joule) | `J`, `joule`, `joules` |
| `Energy` | [Planck energy](https://en.wikipedia.org/wiki/Planck_energy) | `planck_energy` |
| `Energy` | [Rydberg unit of energy](https://en.wikipedia.org/wiki/Rydberg_constant) | `Ry` |
| `Energy` | [Therm](https://en.wikipedia.org/wiki/Therm) | `therm`, `therms` |
| `Energy` | [Thermie](https://en.wikipedia.org/wiki/Thermie) | `thermie`, `thermies` |
| `Energy` | [Watt-hour](https://en.wikipedia.org/wiki/Watt_hour) | `watthour`, `Wh` |
| `EquivalentDose` | [Sievert](https://en.wikipedia.org/wiki/Sievert) | `sievert`, `sieverts`, `Sv` |
| `Force` | [Dyne](https://en.wikipedia.org/wiki/Dyne) | `dyn`, `dyne` |
| `Force` | [Kilogram-force](https://en.wikipedia.org/wiki/Kilogram-force) | `kgf`, `kilogram_force` |
| `Force` | [Newton](https://en.wikipedia.org/wiki/Newton_(unit)) | `N`, `newton`, `newtons` |
| `Force` | [Ounce-force](https://en.wikipedia.org/wiki/Ounce-force) | `ounce_force`, `ozf` |
| `Force` | [Pound-force](https://en.wikipedia.org/wiki/Pound_(force)) | `lbf`, `pound_force` |
| `Force / Volume` | [Mercury](https://en.wikipedia.org/wiki/Mercury_(element)) | `Hg` |
| `Frame` | [Frame](https://en.wikipedia.org/wiki/Frame_rate) | `frame`, `frames` |
| `Frame / Time` | [Frames per second](https://en.wikipedia.org/wiki/Frame_rate) | `fps` |
| `Frequency` | [Hertz](https://en.wikipedia.org/wiki/Hertz) | `hertz`, `Hz` |
| `Frequency` | [Revolutions per minute](https://en.wikipedia.org/wiki/Revolutions_per_minute) | `rpm`, `RPM` |
| `Illuminance` | [Foot-candle](https://en.wikipedia.org/wiki/Foot-candle) | `fc`, `footcandle`, `footcandles` |
| `Illuminance` | [Lux](https://en.wikipedia.org/wiki/Lux) | `lux`, `lx` |
| `Inductance` | [Henry](https://en.wikipedia.org/wiki/Henry_(unit)) | `H`, `henries`, `henry`, `henrys` |
| `KinematicViscosity` | [Stokes](https://en.wikipedia.org/wiki/Stokes_(unit)) | `St`, `stokes` |
| `Length` | [Ångström](https://en.wikipedia.org/wiki/Angstrom) | `angstrom`, `angstroms`, `Å`, `Å` |
| `Length` | [Astronomical unit](https://en.wikipedia.org/wiki/Astronomical_unit) | `astronomicalunit`, `astronomicalunits`, `au`, `AU` |
| `Length` | [Bohr](https://en.wikipedia.org/wiki/Hartree_atomic_units) | `bohr` |
| `Length` | [Earth radius](https://en.wikipedia.org/wiki/Earth) | `earth_radius` |
| `Length` | [Fathom](https://en.wikipedia.org/wiki/Fathom) | `fathom`, `fathoms` |
| `Length` | [Fermi](https://en.wikipedia.org/wiki/Femtometre) | `fermi` |
| `Length` | [Foot](https://en.wikipedia.org/wiki/Foot_(unit)) | `feet`, `foot`, `ft` |
| `Length` | [Furlong](https://en.wikipedia.org/wiki/Furlong) | `furlong`, `furlongs` |
| `Length` | [Inch](https://en.wikipedia.org/wiki/Inch) | `in`, `inch`, `inches` |
| `Length` | [Jupiter radius](https://en.wikipedia.org/wiki/Jupiter) | `jupiter_radius` |
| `Length` | [League](https://en.wikipedia.org/wiki/League_(unit)) | `league`, `leagues` |
| `Length` | [Light-second](https://en.wikipedia.org/wiki/Light-second) | `lightsecond`, `lightseconds`, `lsec` |
| `Length` | [Light-year](https://en.wikipedia.org/wiki/Light-year) | `lightyear`, `lightyears`, `ly`, `lyr` |
| `Length` | [Lunar radius](https://en.wikipedia.org/wiki/Moon#Size_and_mass) | `lunar_radius` |
| `Length` | [Mars radius](https://en.wikipedia.org/wiki/Mars) | `mars_radius` |
| `Length` | [Metre](https://en.wikipedia.org/wiki/Metre) | `m`, `meter`, `meters`, `metre`, `metres` |
| `Length` | [Micron](https://en.wikipedia.org/wiki/Micrometre) | `micron` |
| `Length` | [Mile](https://en.wikipedia.org/wiki/Mile) | `mi`, `mile`, `miles` |
| `Length` | [Nautical Mile](https://en.wikipedia.org/wiki/Nautical_mile) | `nautical_mile`, `nautical_miles`, `NM`, `nmi` |
| `Length` | [Parsec](https://en.wikipedia.org/wiki/Parsec) | `parsec`, `parsecs`, `pc` |
| `Length` | [Planck length](https://en.wikipedia.org/wiki/Planck_length) | `planck_length` |
| `Length` | [Rack unit](https://en.wikipedia.org/wiki/Rack_unit) | `rackunit`, `rackunits`, `RU`, `U` |
| `Length` | [US rod](https://en.wikipedia.org/wiki/Rod_(unit)) | `perch`, `rod`, `rods` |
| `Length` | [Smoot](https://en.wikipedia.org/wiki/Smoot) | `smoot` |
| `Length` | [Solar radius](https://en.wikipedia.org/wiki/Sun) | `solar_radius` |
| `Length` | [Stoney length](https://en.wikipedia.org/wiki/Stoney_units) | `stoney_length` |
| `Length` | [Thousandth of an inch](https://en.wikipedia.org/wiki/Thousandth_of_an_inch) | `mil`, `mils`, `thou` |
| `Length` | [Yard](https://en.wikipedia.org/wiki/Yard) | `yard`, `yards`, `yd` |
| `Length / Volume` | [Miles per gallon](https://en.wikipedia.org/wiki/Fuel_economy_in_automobiles) | `mpg` |
| `Length^2` | [darcy](https://en.wikipedia.org/wiki/Darcy_(unit)) | `darcies`, `darcy`, `darcys` |
| `LinesOfCode` | [Lines of code](https://en.wikipedia.org/wiki/Source_lines_of_code) | `LOC`, `SLOC` |
| `LuminousFlux` | [Lumen](https://en.wikipedia.org/wiki/Lumen_(unit)) | `lm`, `lumen`, `lumens` |
| `LuminousIntensity` | [Candela](https://en.wikipedia.org/wiki/Candela) | `candela`, `candelas`, `cd` |
| `MagneticFieldStrength` | [Oersted](https://en.wikipedia.org/wiki/Oersted) | `Oe`, `oersted` |
| `MagneticFlux` | [Maxwell](https://en.wikipedia.org/wiki/Maxwell_(unit)) | `maxwell`, `Mx` |
| `MagneticFlux` | [Weber](https://en.wikipedia.org/wiki/Weber_(unit)) | `Wb`, `weber`, `webers` |
| `MagneticFluxDensity` | [Gauss](https://en.wikipedia.org/wiki/Gauss_(unit)) | `gauss` |
| `MagneticFluxDensity` | [Tesla](https://en.wikipedia.org/wiki/Tesla_(unit)) | `T`, `tesla`, `teslas` |
| `Mass` | [Dalton](https://en.wikipedia.org/wiki/Dalton) | `Da`, `dalton`, `daltons` |
| `Mass` | [Earth mass](https://en.wikipedia.org/wiki/Earth) | `earth_mass` |
| `Mass` | [Firkin](https://en.wikipedia.org/wiki/Firkin_(unit)) | `firkin`, `firkins` |
| `Mass` | [Grain](https://en.wikipedia.org/wiki/Grain_(unit)) | `grain`, `grains` |
| `Mass` | [Gram](https://en.wikipedia.org/wiki/Gram) | `g`, `gram`, `gramme`, `grammes`, `grams` |
| `Mass` | [Jupiter mass](https://en.wikipedia.org/wiki/Jupiter) | `jupiter_mass` |
| `Mass` | [Hundredweight](https://en.wikipedia.org/wiki/Hundredweight) | `cwt`, `long_hundredweight` |
| `Mass` | [Long ton](https://en.wikipedia.org/wiki/Long_ton) | `long_ton`, `long_tons` |
| `Mass` | [Lunar mass](https://en.wikipedia.org/wiki/Moon#Size_and_mass) | `lunar_mass` |
| `Mass` | [Mars mass](https://en.wikipedia.org/wiki/Mars) | `mars_mass` |
| `Mass` | [Ounce](https://en.wikipedia.org/wiki/Ounce) | `ounce`, `ounces`, `oz` |
| `Mass` | [Planck mass](https://en.wikipedia.org/wiki/Planck_mass) | `planck_mass` |
| `Mass` | [Pound](https://en.wikipedia.org/wiki/Pound_(mass)) | `lb`, `lbs`, `pound`, `pounds` |
| `Mass` | [Solar mass](https://en.wikipedia.org/wiki/Sun) | `solar_mass` |
| `Mass` | [Stone](https://en.wikipedia.org/wiki/Stone_(unit)) | `stone` |
| `Mass` | [Stoney mass](https://en.wikipedia.org/wiki/Stoney_units) | `stoney_mass` |
| `Mass` | [Tonne](https://en.wikipedia.org/wiki/Tonne) | `metricton`, `ton`, `tonne`, `tonnes`, `tons` |
| `Molality` | [Molal](https://en.wikipedia.org/wiki/Molality) | `molal` |
| `Molarity` | [Molar](https://en.wikipedia.org/wiki/Molar_concentration) | `molar` |
| `Money` | [Australian dollar](https://en.wikipedia.org/wiki/Australian_dollar) | `A$`, `AUD`, `aud`, `australian_dollar`, `australian_dollars` |
| `Money` | [Brazilian real](https://en.wikipedia.org/wiki/Brazilian_real) | `brazilian_real`, `brazilian_reals`, `BRL`, `brl`, `R$`, `r$` |
| `Money` | [Pound sterling](https://en.wikipedia.org/wiki/Pound_sterling) | `british_pound`, `GBP`, `gbp`, `pound_sterling`, `£` |
| `Money` | [Bulgarian lev](https://en.wikipedia.org/wiki/Bulgarian_lev) | `BGN`, `bgn`, `bulgarian_lev`, `bulgarian_leva` |
| `Money` | [Canadian dollar](https://en.wikipedia.org/wiki/Canadian_dollar) | `C$`, `c$`, `CAD`, `cad`, `canadian_dollar`, `canadian_dollars` |
| `Money` | [Czech koruna](https://en.wikipedia.org/wiki/Czech_koruna) | `czech_koruna`, `czech_korunas`, `CZK`, `czk`, `Kč` |
| `Money` | [Danish krone](https://en.wikipedia.org/wiki/Danish_krone) | `danish_krone`, `danish_kroner`, `DKK`, `dkk` |
| `Money` | [US dollar](https://en.wikipedia.org/wiki/United_States_dollar) | `$`, `dollar`, `dollars`, `USD`, `usd` |
| `Money` | [Euro](https://en.wikipedia.org/wiki/Euro) | `EUR`, `eur`, `euro`, `euros`, `€` |
| `Money` | [Hong Kong dollar](https://en.wikipedia.org/wiki/Hong_Kong_dollar) | `HK$`, `hk$`, `HKD`, `hkd`, `hong_kong_dollar`, `hong_kong_dollars` |
| `Money` | [Hungarian forint](https://en.wikipedia.org/wiki/Hungarian_forint) | `Ft`, `HUF`, `huf`, `hungarian_forint`, `hungarian_forints` |
| `Money` | [Icelandic króna](https://en.wikipedia.org/wiki/Icelandic_króna) | `icelandic_krona`, `icelandic_kronur`, `icelandic_króna`, `icelandic_krónur`, `ISK`, `isk` |
| `Money` | [Indian rupee](https://en.wikipedia.org/wiki/Indian_rupee) | `indian_rupee`, `indian_rupees`, `INR`, `inr`, `₹` |
| `Money` | [Indonesian rupiah](https://en.wikipedia.org/wiki/Indonesian_rupiah) | `IDR`, `idr`, `indonesian_rupiah`, `indonesian_rupiahs`, `Rp` |
| `Money` | [Israeli new shekel](https://en.wikipedia.org/wiki/Israeli_new_shekel) | `ILS`, `ils`, `israeli_new_shekel`, `israeli_new_shekels`, `NIS`, `nis`, `₪` |
| `Money` | [Malaysian ringgit](https://en.wikipedia.org/wiki/Malaysian_ringgit) | `malaysian_ringgit`, `malaysian_ringgits`, `MYR`, `RM` |
| `Money` | [New Zealand dollar](https://en.wikipedia.org/wiki/New_Zealand_dollar) | `new_zealand_dollar`, `new_zealand_dollars`, `NZ$`, `nz$`, `NZD`, `nzd` |
| `Money` | [Norwegian krone](https://en.wikipedia.org/wiki/Norwegian_krone) | `NOK`, `nok`, `norwegian_krone`, `norwegian_kroner` |
| `Money` | [Philippine peso](https://en.wikipedia.org/wiki/Philippine_peso) | `philippine_peso`, `philippine_pesos`, `PHP`, `php`, `₱` |
| `Money` | [Polish złoty](https://en.wikipedia.org/wiki/Polish_złoty) | `PLN`, `pln`, `polish_zloty`, `polish_zlotys`, `zł` |
| `Money` | [Chinese yuan](https://en.wikipedia.org/wiki/Renminbi) | `CNY`, `cny`, `renminbi`, `yuan`, `元` |
| `Money` | [Romanian leu](https://en.wikipedia.org/wiki/Romanian_leu) | `lei`, `romanian_leu`, `romanian_leus`, `RON`, `ron` |
| `Money` | [Singapore dollar](https://en.wikipedia.org/wiki/Singapore_dollar) | `S$`, `SGD`, `sgd`, `singapore_dollar`, `singapore_dollars` |
| `Money` | [South African rand](https://en.wikipedia.org/wiki/South_African_rand) | `south_african_rand`, `ZAR`, `zar` |
| `Money` | [South Korean won](https://en.wikipedia.org/wiki/South_Korean_won) | `KRW`, `krw`, `south_korean_won`, `south_korean_wons`, `₩` |
| `Money` | [Swedish krona](https://en.wikipedia.org/wiki/Swedish_krona) | `SEK`, `sek`, `swedish_krona`, `swedish_kronor` |
| `Money` | [Swiss franc](https://en.wikipedia.org/wiki/Swiss_franc) | `CHF`, `chf`, `swiss_franc`, `swiss_francs` |
| `Money` | [Thai baht](https://en.wikipedia.org/wiki/Thai_baht) | `thai_baht`, `thai_bahts`, `THB`, `thb`, `฿` |
| `Money` | [Turkish lira](https://en.wikipedia.org/wiki/Turkish_lira) | `TRY`, `try`, `turkish_lira`, `turkish_liras`, `₺` |
| `Money` | [Japanese yen](https://en.wikipedia.org/wiki/Japanese_yen) | `JPY`, `jpy`, `yen`, `¥`, `円` |
| `Person` | Person | `capita`, `people`, `person`, `persons` |
| `Piece` | Piece | `piece`, `pieces` |
| `Pixel` | [Pixel](https://en.wikipedia.org/wiki/Pixel) | `pixel`, `pixels`, `px` |
| `Pixel / Length` | [Pixels per inch](https://en.wikipedia.org/wiki/Pixels_per_inch) | `ppi` |
| `Power` | [Metric horsepower](https://en.wikipedia.org/wiki/Horsepower) | `horsepower`, `hp` |
| `Power` | [Watt](https://en.wikipedia.org/wiki/Watt) | `W`, `watt`, `watts` |
| `Pressure` | [Standard atmosphere](https://en.wikipedia.org/wiki/Standard_atmosphere_(unit)) | `atm`, `atmosphere`, `atmospheres` |
| `Pressure` | [Bar](https://en.wikipedia.org/wiki/Bar_(unit)) | `bar`, `bars` |
| `Pressure` | [Inch of mercury](https://en.wikipedia.org/wiki/Inch_of_mercury) | `inHg` |
| `Pressure` | [Kilopound-force per square inch](https://en.wikipedia.org/wiki/Ksi_(unit)) | `ksi`, `KSI` |
| `Pressure` | [Millimeter of mercury](https://en.wikipedia.org/wiki/Millimeter_of_mercury) | `mmHg` |
| `Pressure` | [Megapound-force per square inch](https://en.wikipedia.org/wiki/Ksi_(unit)) | `mpsi`, `MPSI` |
| `Pressure` | [Pascal](https://en.wikipedia.org/wiki/Pascal_(unit)) | `Pa`, `pascal`, `pascals` |
| `Pressure` | [Pound-force per square inch](https://en.wikipedia.org/wiki/Pounds_per_square_inch) | `psi`, `PSI` |
| `Pressure` | [Torr](https://en.wikipedia.org/wiki/Torr) | `torr` |
| `RadiantFlux` | [Solar luminosity](https://en.wikipedia.org/wiki/Solar_luminosity) | `solar_luminosity` |
| `Scalar` | [Billion](https://en.wikipedia.org/wiki/Billion) | `billion` |
| `Scalar` | [Dozen](https://en.wikipedia.org/wiki/Dozen) | `dozen` |
| `Scalar` | [Hundred](https://en.wikipedia.org/wiki/100_(number)) | `hundred` |
| `Scalar` | [Million](https://en.wikipedia.org/wiki/Million) | `million` |
| `Scalar` | [Parts per billion](https://en.wikipedia.org/wiki/Parts-per_notation) | `partsperbillion`, `ppb` |
| `Scalar` | [Parts per million](https://en.wikipedia.org/wiki/Parts-per_notation) | `partspermillion`, `ppm` |
| `Scalar` | [Parts per quadrillion](https://en.wikipedia.org/wiki/Parts-per_notation) | `partsperquadrillion`, `ppq` |
| `Scalar` | [Parts per trillion](https://en.wikipedia.org/wiki/Parts-per_notation) | `partspertrillion`, `ppt` |
| `Scalar` | [Percent](https://en.wikipedia.org/wiki/Percentage) | `%`, `pct`, `percent` |
| `Scalar` | [Permille](https://en.wikipedia.org/wiki/Per_mille) | `permil`, `permill`, `permille`, `‰` |
| `Scalar` | [Quadrillion](https://en.wikipedia.org/wiki/Quadrillion) | `quadrillion` |
| `Scalar` | [Quintillion](https://en.wikipedia.org/wiki/Quintillion) | `quintillion` |
| `Scalar` | [Thousand](https://en.wikipedia.org/wiki/1000_(number)) | `thousand` |
| `Scalar` | [Trillion](https://en.wikipedia.org/wiki/Trillion) | `trillion` |
| `SolidAngle` | [Steradian](https://en.wikipedia.org/wiki/Steradian) | `sr`, `steradian`, `steradians` |
| `SpectralFluxDensity` | [Jansky](https://en.wikipedia.org/wiki/Jansky) | `jansky`, `janskys`, `Jy` |
| `SpectralFluxDensity` | [Solar flux unit](https://en.wikipedia.org/wiki/Solar_flux_unit) | `sfu`, `solarfluxunit`, `solarfluxunits` |
| `Temperature` | [Kelvin](https://en.wikipedia.org/wiki/Kelvin) | `K`, `kelvin`, `kelvins` |
| `Temperature` | [Planck temperature](https://en.wikipedia.org/wiki/Planck_temperature) | `planck_temperature` |
| `Time` | [Century](https://en.wikipedia.org/wiki/Century) | `centuries`, `century` |
| `Time` | [Day](https://en.wikipedia.org/wiki/Day) | `d`, `day`, `days` |
| `Time` | [Decade](https://en.wikipedia.org/wiki/Decade) | `decade`, `decades` |
| `Time` | [Fortnight](https://en.wikipedia.org/wiki/Fortnight) | `fortnight`, `fortnights` |
| `Time` | [Gregorian year](https://en.wikipedia.org/wiki/Gregorian_year) | `gregorian_year`, `gregorian_years` |
| `Time` | [Hour](https://en.wikipedia.org/wiki/Hour) | `h`, `hour`, `hours`, `hr` |
| `Time` | [Julian year](https://en.wikipedia.org/wiki/Julian_year_(astronomy)) | `julian_year`, `julian_years` |
| `Time` | [Millennium](https://en.wikipedia.org/wiki/Millennium) | `millennia`, `millennium` |
| `Time` | [Minute](https://en.wikipedia.org/wiki/Minute) | `min`, `minute`, `minutes` |
| `Time` | [Month](https://en.wikipedia.org/wiki/Month) | `month`, `months` |
| `Time` | [Planck time](https://en.wikipedia.org/wiki/Planck_time) | `planck_time` |
| `Time` | [Second](https://en.wikipedia.org/wiki/Second) | `s`, `sec`, `second`, `seconds` |
| `Time` | [Sidereal day](https://en.wikipedia.org/wiki/Sidereal_time#Sidereal_day) | `sidereal_day`, `sidereal_days` |
| `Time` | [Stoney time](https://en.wikipedia.org/wiki/Stoney_units) | `stoney_time` |
| `Time` | [Week](https://en.wikipedia.org/wiki/Week) | `week`, `weeks` |
| `Time` | [Tropical year](https://en.wikipedia.org/wiki/Tropical_year) | `tropical_year`, `tropical_years`, `year`, `years`, `yr` |
| `Velocity` | [Knot](https://en.wikipedia.org/wiki/Knot_(unit)) | `kn`, `knot`, `knots`, `kt` |
| `Velocity` | [Kilometres per hour](https://en.wikipedia.org/wiki/Kilometres_per_hour) | `kph` |
| `Velocity` | [Miles per hour](https://en.wikipedia.org/wiki/Miles_per_hour) | `mph` |
| `Voltage` | [Volt](https://en.wikipedia.org/wiki/Volt) | `V`, `volt`, `volts` |
| `Volume` | [Cubic centimetre](https://en.wikipedia.org/wiki/Cubic_centimetre) | `cc`, `ccm` |
| `Volume` | [US cup](https://en.wikipedia.org/wiki/Cup_(unit)) | `cup`, `cups` |
| `Volume` | [US fluid ounce](https://en.wikipedia.org/wiki/Fluid_ounce) | `floz`, `fluidounce`, `fluidounces` |
| `Volume` | [US liquid gallon](https://en.wikipedia.org/wiki/Gallon) | `gal`, `gallon`, `gallons` |
| `Volume` | [US hogshead](https://en.wikipedia.org/wiki/Hogshead) | `hogshead`, `hogsheads` |
| `Volume` | [Imperial Bushel](https://en.wikipedia.org/wiki/Bushel#Imperial_bushel) | `imperial_bushel`, `imperial_bushels`, `UK_bu` |
| `Volume` | [Imperial Fluid Drachm](https://en.wikipedia.org/wiki/Fluid_drachm#Imperial_fluid_drachm) | `imperial_fluid_drachm`, `imperial_fluid_drachms`, `UK_fldr` |
| `Volume` | [Imperial Fluid Ounce](https://en.wikipedia.org/wiki/Fluid_ounce) | `imperial_fluidounce`, `imperial_fluidounces`, `UK_floz` |
| `Volume` | [Imperial Gallon](https://en.wikipedia.org/wiki/Gallon#Imperial_gallon) | `imperial_gallon`, `imperial_gallons`, `UK_gal` |
| `Volume` | [Imperial Gill](https://en.wikipedia.org/wiki/Gill_(unit)) | `imperial_gill`, `imperial_gills`, `UK_gi` |
| `Volume` | [Imperial Pint](https://en.wikipedia.org/wiki/Pint#Imperial_pint) | `imperial_pint`, `imperial_pints`, `UK_pt` |
| `Volume` | [Imperial Quart](https://en.wikipedia.org/wiki/Quart#Imperial_quart) | `imperial_quart`, `imperial_quarts`, `UK_qt` |
| `Volume` | [Litre](https://en.wikipedia.org/wiki/Litre) | `l`, `L`, `liter`, `liters`, `litre`, `litres` |
| `Volume` | [US liquid pint](https://en.wikipedia.org/wiki/Pint) | `pint`, `pints` |
| `Volume` | [Swimming pool](https://en.wikipedia.org/wiki/Olympic-size_swimming_pool) | `swimmingpool` |
| `Volume` | [US tablespoon](https://en.wikipedia.org/wiki/Tablespoon) | `tablespoon`, `tablespoons`, `tbsp` |
| `Volume` | [US teaspoon](https://en.wikipedia.org/wiki/Teaspoon) | `teaspoon`, `teaspoons`, `tsp` |
