<!-- This file is autogenerated! Do not modify it -->

# Flow rate in a pipe

``` numbat
# This script calculates and prints the flow rate in a pipe
# using the Hagen-Poiseuille equation. It assumes the dynamic
# viscosity of water and allows for inputs of pipe radius,
# pipe length, and pressure difference.

let μ_water: DynamicViscosity = 1 mPa·s

fn flow_rate(radius: Length, length: Length, Δp: Pressure) -> FlowRate =
    π × radius^4 × Δp / (8 μ_water × length)

let pipe_radius = 1 cm
let pipe_length = 10 m
let Δp = 0.1 bar

let Q = flow_rate(pipe_radius, pipe_length, Δp)
print("Flow rate: {Q -> L/s}")
```
