<!-- This file is autogenerated! Do not modify it -->

# Barometric formula

``` numbat
# This script calculates the air pressure at a specified
# height above sea level using the barometric formula.

let p0: Pressure = 1 atm
let t0: Temperature = 288.15 K

dimension TemperatureGradient = Temperature / Length
let lapse_rate: TemperatureGradient = 0.65 K / 100 m

fn air_pressure(height: Length) -> Pressure =
    p0 · (1 - lapse_rate · height / t0)^5.255

print("Air pressure 1500 m above sea level: {air_pressure(1500 m) -> hPa}")
```
