# @generated by usage-cli from usage spec

if (-not (Get-Command 'usage' -ErrorAction SilentlyContinue)) {
    Write-Warning "Error: usage CLI not found. This is required for completions to work in mise."
    Write-Warning "See https://usage.jdx.dev for more information."
    return
}

Register-ArgumentCompleter -Native -CommandName 'mise' -ScriptBlock {
    param($wordToComplete, $commandAst, $cursorPosition)

    $tmpDir = if ($env:TEMP) { $env:TEMP } else { [System.IO.Path]::GetTempPath() }
    $specFile = Join-Path $tmpDir "usage__usage_spec_mise_2026_2_0.kdl"

    if (-not (Test-Path $specFile)) {
    mise usage | Out-File -FilePath $specFile -Encoding utf8
}

    $words = $commandAst.CommandElements | ForEach-Object { $_.ToString() }
    if ($words.Count -lt 1) {
        $words = @('mise')
    }

    $completions = & 'usage' complete-word --shell powershell -f "$specFile" -- @words $wordToComplete 2>$null

    if ($completions) {
        $completions | ForEach-Object {
            $parts = $_ -split "`t", 2
            $completion = $parts[0]
            $description = if ($parts.Count -gt 1) { $parts[1] } else { '' }

            [System.Management.Automation.CompletionResult]::new(
                $completion,
                $completion,
                'ParameterValue',
                $description
            )
        }
    }
}
