use crate::input::{map_keybindings, KeyBindings};

/// Create a mocked version of `KeyBindings`.
#[must_use]
pub(crate) fn create_test_keybindings() -> KeyBindings {
	KeyBindings {
		redo: map_keybindings(&[String::from("Controly")]),
		undo: map_keybindings(&[String::from("Controlz")]),
		scroll_down: map_keybindings(&[String::from("Down")]),
		scroll_end: map_keybindings(&[String::from("End")]),
		scroll_home: map_keybindings(&[String::from("Home")]),
		scroll_left: map_keybindings(&[String::from("Left")]),
		scroll_right: map_keybindings(&[String::from("Right")]),
		scroll_up: map_keybindings(&[String::from("Up")]),
		scroll_step_down: map_keybindings(&[String::from("PageDown")]),
		scroll_step_up: map_keybindings(&[String::from("PageUp")]),
		help: map_keybindings(&[String::from("?")]),
		search_start: map_keybindings(&[String::from("/")]),
		search_next: map_keybindings(&[String::from("n")]),
		search_previous: map_keybindings(&[String::from("N")]),
		abort: map_keybindings(&[String::from("q")]),
		action_break: map_keybindings(&[String::from("b")]),
		action_drop: map_keybindings(&[String::from("d")]),
		action_edit: map_keybindings(&[String::from("e")]),
		action_fixup: map_keybindings(&[String::from("f")]),
		action_pick: map_keybindings(&[String::from("p")]),
		action_reword: map_keybindings(&[String::from("r")]),
		action_squash: map_keybindings(&[String::from("s")]),
		confirm_yes: map_keybindings(&[String::from("y")]),
		edit: map_keybindings(&[String::from("E")]),
		force_abort: map_keybindings(&[String::from("Q")]),
		force_rebase: map_keybindings(&[String::from("W")]),
		insert_line: map_keybindings(&[String::from("I")]),
		move_down: map_keybindings(&[String::from("Down")]),
		move_down_step: map_keybindings(&[String::from("PageDown")]),
		move_end: map_keybindings(&[String::from("End")]),
		move_home: map_keybindings(&[String::from("Home")]),
		move_left: map_keybindings(&[String::from("Left")]),
		move_right: map_keybindings(&[String::from("Right")]),
		move_selection_down: map_keybindings(&[String::from("j")]),
		move_selection_up: map_keybindings(&[String::from("k")]),
		move_up: map_keybindings(&[String::from("Up")]),
		move_up_step: map_keybindings(&[String::from("PageUp")]),
		open_in_external_editor: map_keybindings(&[String::from('!')]),
		rebase: map_keybindings(&[String::from('w')]),
		remove_line: map_keybindings(&[String::from("Delete")]),
		show_commit: map_keybindings(&[String::from("c")]),
		show_diff: map_keybindings(&[String::from("d")]),
		toggle_visual_mode: map_keybindings(&[String::from("v")]),
		fixup_keep_message: map_keybindings(&[String::from("u")]),
		fixup_keep_message_with_editor: map_keybindings(&[String::from("U")]),
	}
}
