/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.common.util.collections;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import me.jellysquid.mods.sodium.client.SodiumClientMod;

public class WorkStealingFutureDrain<T>
implements Iterator<T> {
    private final BooleanSupplier workStealFunction;
    private final LinkedList<CompletableFuture<T>> queue;
    private T next = null;

    public WorkStealingFutureDrain(LinkedList<CompletableFuture<T>> queue, BooleanSupplier workStealFunction) {
        this.queue = queue;
        this.workStealFunction = workStealFunction;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        this.next = this.findNext();
        return this.next != null;
    }

    private T findNext() {
        boolean shouldStealWork = true;
        while (!this.queue.isEmpty()) {
            Iterator iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                CompletableFuture future = (CompletableFuture)iterator.next();
                if (shouldStealWork && !future.isDone()) continue;
                iterator.remove();
                try {
                    return future.join();
                }
                catch (CancellationException e) {
                    SodiumClientMod.logger().warn("Future was cancelled: {}", (Object)future);
                }
            }
            if (!shouldStealWork || this.workStealFunction.getAsBoolean()) continue;
            shouldStealWork = false;
        }
        return null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.next;
        this.next = null;
        return result;
    }
}

