#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 4326
#define LARGE_STATE_COUNT 1527
#define SYMBOL_COUNT 190
#define ALIAS_COUNT 1
#define TOKEN_COUNT 89
#define EXTERNAL_TOKEN_COUNT 10
#define FIELD_COUNT 7
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 29

enum {
  sym_identifier = 1,
  anon_sym_function = 2,
  anon_sym_end = 3,
  anon_sym_abstract = 4,
  anon_sym_type = 5,
  anon_sym_primitive = 6,
  aux_sym_primitive_definition_token1 = 7,
  anon_sym_mutable = 8,
  anon_sym_struct = 9,
  anon_sym_module = 10,
  anon_sym_macro = 11,
  anon_sym_LPAREN = 12,
  anon_sym_COMMA = 13,
  anon_sym_RPAREN = 14,
  anon_sym_SEMI = 15,
  anon_sym_EQ = 16,
  anon_sym_DOT_DOT_DOT = 17,
  anon_sym_COLON_COLON = 18,
  anon_sym_LBRACE = 19,
  anon_sym_RBRACE = 20,
  anon_sym_LT_COLON = 21,
  anon_sym_if = 22,
  anon_sym_elseif = 23,
  anon_sym_else = 24,
  anon_sym_try = 25,
  anon_sym_catch = 26,
  anon_sym_finally = 27,
  anon_sym_for = 28,
  anon_sym_while = 29,
  sym_break_statement = 30,
  sym_continue_statement = 31,
  anon_sym_return = 32,
  anon_sym_let = 33,
  anon_sym_const = 34,
  anon_sym_quote = 35,
  anon_sym_using = 36,
  anon_sym_import = 37,
  anon_sym_COLON = 38,
  anon_sym_DOT = 39,
  anon_sym_export = 40,
  anon_sym_COLON2 = 41,
  anon_sym_LBRACK = 42,
  anon_sym_RBRACK = 43,
  anon_sym_begin = 44,
  anon_sym_do = 45,
  anon_sym_SQUOTE = 46,
  anon_sym_PLUS = 47,
  anon_sym_LT_PIPE = 48,
  anon_sym_PIPE_GT = 49,
  anon_sym_in = 50,
  anon_sym_isa = 51,
  anon_sym_PIPE_PIPE = 52,
  anon_sym_AMP_AMP = 53,
  anon_sym_QMARK = 54,
  anon_sym_EQ_GT = 55,
  anon_sym_LBRACK2 = 56,
  anon_sym_ = 57,
  anon_sym_DASH_GT = 58,
  anon_sym_DOLLAR = 59,
  anon_sym_AT = 60,
  aux_sym_integer_literal_token1 = 61,
  aux_sym_integer_literal_token2 = 62,
  aux_sym_integer_literal_token3 = 63,
  sym_float_literal = 64,
  sym_escape_sequence = 65,
  aux_sym_character_literal_token1 = 66,
  sym__unary_operator = 67,
  sym__power_operator = 68,
  sym__bitshift_operator = 69,
  sym__rational_operator = 70,
  sym__times_operator = 71,
  sym__plus_operator = 72,
  sym__dotty_operator = 73,
  sym__comparison_operator = 74,
  sym__arrow_operator = 75,
  sym__assign_operator = 76,
  anon_sym_LF = 77,
  sym_line_comment = 78,
  sym_block_comment = 79,
  sym__immediate_paren = 80,
  sym__string_start = 81,
  sym__command_start = 82,
  sym__immediate_string_start = 83,
  sym__immediate_command_start = 84,
  sym__string_end = 85,
  sym__command_end = 86,
  sym__string_content = 87,
  sym__string_content_no_interp = 88,
  sym_source_file = 89,
  sym__expression_list = 90,
  sym_function_definition = 91,
  sym_abstract_definition = 92,
  sym_primitive_definition = 93,
  sym_struct_definition = 94,
  sym_module_definition = 95,
  sym_macro_definition = 96,
  sym_parameter_list = 97,
  sym_keyword_parameters = 98,
  sym_optional_parameter = 99,
  sym_spread_parameter = 100,
  sym_typed_parameter = 101,
  sym_type_parameter_list = 102,
  sym_constrained_parameter = 103,
  sym_subtype_clause = 104,
  sym_if_statement = 105,
  sym_elseif_clause = 106,
  sym_else_clause = 107,
  sym_try_statement = 108,
  sym_catch_clause = 109,
  sym_finally_clause = 110,
  sym_for_statement = 111,
  sym_while_statement = 112,
  sym_return_statement = 113,
  sym_let_statement = 114,
  sym_const_statement = 115,
  sym_variable_declaration = 116,
  sym_quote_statement = 117,
  sym_import_statement = 118,
  sym_selected_import = 119,
  sym_scoped_identifier = 120,
  sym_export_statement = 121,
  sym__expression = 122,
  sym__primary_expression = 123,
  sym_bare_tuple_expression = 124,
  sym_operator = 125,
  sym_parenthesized_expression = 126,
  sym_field_expression = 127,
  sym_subscript_expression = 128,
  sym_typed_expression = 129,
  sym_parameterized_identifier = 130,
  sym_type_argument_list = 131,
  sym_compound_expression = 132,
  sym_call_expression = 133,
  sym_broadcast_call_expression = 134,
  sym_macro_expression = 135,
  sym_macro_argument_list = 136,
  sym_argument_list = 137,
  sym_do_clause = 138,
  sym_named_field = 139,
  sym_spread_expression = 140,
  sym_assignment_expression = 141,
  sym_unary_expression = 142,
  sym_binary_expression = 143,
  sym_ternary_expression = 144,
  sym_pair_expression = 145,
  sym_tuple_expression = 146,
  sym_array_expression = 147,
  sym_matrix_expression = 148,
  sym_matrix_row = 149,
  sym_generator_expression = 150,
  sym_array_comprehension_expression = 151,
  sym__comprehension_clause = 152,
  sym_if_clause = 153,
  sym_for_clause = 154,
  sym_for_binding = 155,
  sym_function_expression = 156,
  sym_range_expression = 157,
  sym_coefficient_expression = 158,
  sym_quote_expression = 159,
  sym_interpolation_expression = 160,
  sym_macro_identifier = 161,
  sym__literal = 162,
  sym_integer_literal = 163,
  sym_character_literal = 164,
  sym_string_literal = 165,
  sym_command_literal = 166,
  sym_prefixed_string_literal = 167,
  sym_prefixed_command_literal = 168,
  sym_string_interpolation = 169,
  aux_sym__expression_list_repeat1 = 170,
  aux_sym_parameter_list_repeat1 = 171,
  aux_sym_type_parameter_list_repeat1 = 172,
  aux_sym_if_statement_repeat1 = 173,
  aux_sym_for_statement_repeat1 = 174,
  aux_sym_let_statement_repeat1 = 175,
  aux_sym_import_statement_repeat1 = 176,
  aux_sym_selected_import_repeat1 = 177,
  aux_sym_export_statement_repeat1 = 178,
  aux_sym_bare_tuple_expression_repeat1 = 179,
  aux_sym_subscript_expression_repeat1 = 180,
  aux_sym_type_argument_list_repeat1 = 181,
  aux_sym_macro_argument_list_repeat1 = 182,
  aux_sym_argument_list_repeat1 = 183,
  aux_sym_argument_list_repeat2 = 184,
  aux_sym_tuple_expression_repeat1 = 185,
  aux_sym_matrix_expression_repeat1 = 186,
  aux_sym__comprehension_clause_repeat1 = 187,
  aux_sym_string_literal_repeat1 = 188,
  aux_sym_prefixed_string_literal_repeat1 = 189,
  alias_sym_named_argument = 190,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_function] = "function",
  [anon_sym_end] = "end",
  [anon_sym_abstract] = "abstract",
  [anon_sym_type] = "type",
  [anon_sym_primitive] = "primitive",
  [aux_sym_primitive_definition_token1] = "primitive_definition_token1",
  [anon_sym_mutable] = "mutable",
  [anon_sym_struct] = "struct",
  [anon_sym_module] = "module",
  [anon_sym_macro] = "macro",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SEMI] = ";",
  [anon_sym_EQ] = "=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LT_COLON] = "<:",
  [anon_sym_if] = "if",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_for] = "for",
  [anon_sym_while] = "while",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [anon_sym_return] = "return",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_quote] = "quote",
  [anon_sym_using] = "using",
  [anon_sym_import] = "import",
  [anon_sym_COLON] = ":",
  [anon_sym_DOT] = ".",
  [anon_sym_export] = "export",
  [anon_sym_COLON2] = ":",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_begin] = "begin",
  [anon_sym_do] = "do",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_PLUS] = "operator",
  [anon_sym_LT_PIPE] = "operator",
  [anon_sym_PIPE_GT] = "operator",
  [anon_sym_in] = "in",
  [anon_sym_isa] = "operator",
  [anon_sym_PIPE_PIPE] = "operator",
  [anon_sym_AMP_AMP] = "operator",
  [anon_sym_QMARK] = "\?",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_LBRACK2] = "[",
  [anon_sym_] = "∈",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_AT] = "@",
  [aux_sym_integer_literal_token1] = "integer_literal_token1",
  [aux_sym_integer_literal_token2] = "integer_literal_token2",
  [aux_sym_integer_literal_token3] = "integer_literal_token3",
  [sym_float_literal] = "float_literal",
  [sym_escape_sequence] = "escape_sequence",
  [aux_sym_character_literal_token1] = "character_literal_token1",
  [sym__unary_operator] = "_unary_operator",
  [sym__power_operator] = "_power_operator",
  [sym__bitshift_operator] = "_bitshift_operator",
  [sym__rational_operator] = "_rational_operator",
  [sym__times_operator] = "_times_operator",
  [sym__plus_operator] = "_plus_operator",
  [sym__dotty_operator] = "_dotty_operator",
  [sym__comparison_operator] = "_comparison_operator",
  [sym__arrow_operator] = "operator",
  [sym__assign_operator] = "operator",
  [anon_sym_LF] = "\n",
  [sym_line_comment] = "line_comment",
  [sym_block_comment] = "block_comment",
  [sym__immediate_paren] = "_immediate_paren",
  [sym__string_start] = "_string_start",
  [sym__command_start] = "_command_start",
  [sym__immediate_string_start] = "_immediate_string_start",
  [sym__immediate_command_start] = "_immediate_command_start",
  [sym__string_end] = "_string_end",
  [sym__command_end] = "_command_end",
  [sym__string_content] = "_string_content",
  [sym__string_content_no_interp] = "_string_content_no_interp",
  [sym_source_file] = "source_file",
  [sym__expression_list] = "_expression_list",
  [sym_function_definition] = "function_definition",
  [sym_abstract_definition] = "abstract_definition",
  [sym_primitive_definition] = "primitive_definition",
  [sym_struct_definition] = "struct_definition",
  [sym_module_definition] = "module_definition",
  [sym_macro_definition] = "macro_definition",
  [sym_parameter_list] = "parameter_list",
  [sym_keyword_parameters] = "keyword_parameters",
  [sym_optional_parameter] = "optional_parameter",
  [sym_spread_parameter] = "spread_parameter",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type_parameter_list] = "type_parameter_list",
  [sym_constrained_parameter] = "constrained_parameter",
  [sym_subtype_clause] = "subtype_clause",
  [sym_if_statement] = "if_statement",
  [sym_elseif_clause] = "elseif_clause",
  [sym_else_clause] = "else_clause",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_return_statement] = "return_statement",
  [sym_let_statement] = "let_statement",
  [sym_const_statement] = "const_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_quote_statement] = "quote_statement",
  [sym_import_statement] = "import_statement",
  [sym_selected_import] = "selected_import",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_export_statement] = "export_statement",
  [sym__expression] = "_expression",
  [sym__primary_expression] = "_primary_expression",
  [sym_bare_tuple_expression] = "bare_tuple_expression",
  [sym_operator] = "operator",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_field_expression] = "field_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_typed_expression] = "typed_expression",
  [sym_parameterized_identifier] = "parameterized_identifier",
  [sym_type_argument_list] = "type_argument_list",
  [sym_compound_expression] = "compound_expression",
  [sym_call_expression] = "call_expression",
  [sym_broadcast_call_expression] = "broadcast_call_expression",
  [sym_macro_expression] = "macro_expression",
  [sym_macro_argument_list] = "macro_argument_list",
  [sym_argument_list] = "argument_list",
  [sym_do_clause] = "do_clause",
  [sym_named_field] = "named_field",
  [sym_spread_expression] = "spread_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_pair_expression] = "pair_expression",
  [sym_tuple_expression] = "tuple_expression",
  [sym_array_expression] = "array_expression",
  [sym_matrix_expression] = "matrix_expression",
  [sym_matrix_row] = "matrix_row",
  [sym_generator_expression] = "generator_expression",
  [sym_array_comprehension_expression] = "array_comprehension_expression",
  [sym__comprehension_clause] = "_comprehension_clause",
  [sym_if_clause] = "if_clause",
  [sym_for_clause] = "for_clause",
  [sym_for_binding] = "for_binding",
  [sym_function_expression] = "function_expression",
  [sym_range_expression] = "range_expression",
  [sym_coefficient_expression] = "coefficient_expression",
  [sym_quote_expression] = "quote_expression",
  [sym_interpolation_expression] = "interpolation_expression",
  [sym_macro_identifier] = "macro_identifier",
  [sym__literal] = "_literal",
  [sym_integer_literal] = "integer_literal",
  [sym_character_literal] = "character_literal",
  [sym_string_literal] = "string_literal",
  [sym_command_literal] = "command_literal",
  [sym_prefixed_string_literal] = "prefixed_string_literal",
  [sym_prefixed_command_literal] = "prefixed_command_literal",
  [sym_string_interpolation] = "string_interpolation",
  [aux_sym__expression_list_repeat1] = "_expression_list_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_type_parameter_list_repeat1] = "type_parameter_list_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_let_statement_repeat1] = "let_statement_repeat1",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [aux_sym_selected_import_repeat1] = "selected_import_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_bare_tuple_expression_repeat1] = "bare_tuple_expression_repeat1",
  [aux_sym_subscript_expression_repeat1] = "subscript_expression_repeat1",
  [aux_sym_type_argument_list_repeat1] = "type_argument_list_repeat1",
  [aux_sym_macro_argument_list_repeat1] = "macro_argument_list_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_argument_list_repeat2] = "argument_list_repeat2",
  [aux_sym_tuple_expression_repeat1] = "tuple_expression_repeat1",
  [aux_sym_matrix_expression_repeat1] = "matrix_expression_repeat1",
  [aux_sym__comprehension_clause_repeat1] = "_comprehension_clause_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym_prefixed_string_literal_repeat1] = "prefixed_string_literal_repeat1",
  [alias_sym_named_argument] = "named_argument",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_primitive] = anon_sym_primitive,
  [aux_sym_primitive_definition_token1] = aux_sym_primitive_definition_token1,
  [anon_sym_mutable] = anon_sym_mutable,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_macro] = anon_sym_macro,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LT_COLON] = anon_sym_LT_COLON,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_while] = anon_sym_while,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_quote] = anon_sym_quote,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_COLON2] = anon_sym_COLON,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_begin] = anon_sym_begin,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_PLUS] = sym_operator,
  [anon_sym_LT_PIPE] = sym_operator,
  [anon_sym_PIPE_GT] = sym_operator,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_isa] = sym_operator,
  [anon_sym_PIPE_PIPE] = sym_operator,
  [anon_sym_AMP_AMP] = sym_operator,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_LBRACK2] = anon_sym_LBRACK,
  [anon_sym_] = anon_sym_,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_AT] = anon_sym_AT,
  [aux_sym_integer_literal_token1] = aux_sym_integer_literal_token1,
  [aux_sym_integer_literal_token2] = aux_sym_integer_literal_token2,
  [aux_sym_integer_literal_token3] = aux_sym_integer_literal_token3,
  [sym_float_literal] = sym_float_literal,
  [sym_escape_sequence] = sym_escape_sequence,
  [aux_sym_character_literal_token1] = aux_sym_character_literal_token1,
  [sym__unary_operator] = sym__unary_operator,
  [sym__power_operator] = sym__power_operator,
  [sym__bitshift_operator] = sym__bitshift_operator,
  [sym__rational_operator] = sym__rational_operator,
  [sym__times_operator] = sym__times_operator,
  [sym__plus_operator] = sym__plus_operator,
  [sym__dotty_operator] = sym__dotty_operator,
  [sym__comparison_operator] = sym__comparison_operator,
  [sym__arrow_operator] = sym_operator,
  [sym__assign_operator] = sym_operator,
  [anon_sym_LF] = anon_sym_LF,
  [sym_line_comment] = sym_line_comment,
  [sym_block_comment] = sym_block_comment,
  [sym__immediate_paren] = sym__immediate_paren,
  [sym__string_start] = sym__string_start,
  [sym__command_start] = sym__command_start,
  [sym__immediate_string_start] = sym__immediate_string_start,
  [sym__immediate_command_start] = sym__immediate_command_start,
  [sym__string_end] = sym__string_end,
  [sym__command_end] = sym__command_end,
  [sym__string_content] = sym__string_content,
  [sym__string_content_no_interp] = sym__string_content_no_interp,
  [sym_source_file] = sym_source_file,
  [sym__expression_list] = sym__expression_list,
  [sym_function_definition] = sym_function_definition,
  [sym_abstract_definition] = sym_abstract_definition,
  [sym_primitive_definition] = sym_primitive_definition,
  [sym_struct_definition] = sym_struct_definition,
  [sym_module_definition] = sym_module_definition,
  [sym_macro_definition] = sym_macro_definition,
  [sym_parameter_list] = sym_parameter_list,
  [sym_keyword_parameters] = sym_keyword_parameters,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym_spread_parameter] = sym_spread_parameter,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type_parameter_list] = sym_type_parameter_list,
  [sym_constrained_parameter] = sym_constrained_parameter,
  [sym_subtype_clause] = sym_subtype_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif_clause] = sym_elseif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_let_statement] = sym_let_statement,
  [sym_const_statement] = sym_const_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_quote_statement] = sym_quote_statement,
  [sym_import_statement] = sym_import_statement,
  [sym_selected_import] = sym_selected_import,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_export_statement] = sym_export_statement,
  [sym__expression] = sym__expression,
  [sym__primary_expression] = sym__primary_expression,
  [sym_bare_tuple_expression] = sym_bare_tuple_expression,
  [sym_operator] = sym_operator,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_field_expression] = sym_field_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_typed_expression] = sym_typed_expression,
  [sym_parameterized_identifier] = sym_parameterized_identifier,
  [sym_type_argument_list] = sym_type_argument_list,
  [sym_compound_expression] = sym_compound_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_broadcast_call_expression] = sym_broadcast_call_expression,
  [sym_macro_expression] = sym_macro_expression,
  [sym_macro_argument_list] = sym_macro_argument_list,
  [sym_argument_list] = sym_argument_list,
  [sym_do_clause] = sym_do_clause,
  [sym_named_field] = sym_named_field,
  [sym_spread_expression] = sym_spread_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_pair_expression] = sym_pair_expression,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_array_expression] = sym_array_expression,
  [sym_matrix_expression] = sym_matrix_expression,
  [sym_matrix_row] = sym_matrix_row,
  [sym_generator_expression] = sym_generator_expression,
  [sym_array_comprehension_expression] = sym_array_comprehension_expression,
  [sym__comprehension_clause] = sym__comprehension_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_for_clause] = sym_for_clause,
  [sym_for_binding] = sym_for_binding,
  [sym_function_expression] = sym_function_expression,
  [sym_range_expression] = sym_range_expression,
  [sym_coefficient_expression] = sym_coefficient_expression,
  [sym_quote_expression] = sym_quote_expression,
  [sym_interpolation_expression] = sym_interpolation_expression,
  [sym_macro_identifier] = sym_macro_identifier,
  [sym__literal] = sym__literal,
  [sym_integer_literal] = sym_integer_literal,
  [sym_character_literal] = sym_character_literal,
  [sym_string_literal] = sym_string_literal,
  [sym_command_literal] = sym_command_literal,
  [sym_prefixed_string_literal] = sym_prefixed_string_literal,
  [sym_prefixed_command_literal] = sym_prefixed_command_literal,
  [sym_string_interpolation] = sym_string_interpolation,
  [aux_sym__expression_list_repeat1] = aux_sym__expression_list_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_type_parameter_list_repeat1] = aux_sym_type_parameter_list_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_let_statement_repeat1] = aux_sym_let_statement_repeat1,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [aux_sym_selected_import_repeat1] = aux_sym_selected_import_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_bare_tuple_expression_repeat1] = aux_sym_bare_tuple_expression_repeat1,
  [aux_sym_subscript_expression_repeat1] = aux_sym_subscript_expression_repeat1,
  [aux_sym_type_argument_list_repeat1] = aux_sym_type_argument_list_repeat1,
  [aux_sym_macro_argument_list_repeat1] = aux_sym_macro_argument_list_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_argument_list_repeat2] = aux_sym_argument_list_repeat2,
  [aux_sym_tuple_expression_repeat1] = aux_sym_tuple_expression_repeat1,
  [aux_sym_matrix_expression_repeat1] = aux_sym_matrix_expression_repeat1,
  [aux_sym__comprehension_clause_repeat1] = aux_sym__comprehension_clause_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym_prefixed_string_literal_repeat1] = aux_sym_prefixed_string_literal_repeat1,
  [alias_sym_named_argument] = alias_sym_named_argument,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_primitive] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_primitive_definition_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_mutable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_macro] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_quote] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_begin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_PIPE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_isa] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_integer_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integer_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integer_literal_token3] = {
    .visible = false,
    .named = false,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_character_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__unary_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__power_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__bitshift_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__rational_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__times_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__plus_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__dotty_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__comparison_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__arrow_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__assign_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_paren] = {
    .visible = false,
    .named = true,
  },
  [sym__string_start] = {
    .visible = false,
    .named = true,
  },
  [sym__command_start] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_string_start] = {
    .visible = false,
    .named = true,
  },
  [sym__immediate_command_start] = {
    .visible = false,
    .named = true,
  },
  [sym__string_end] = {
    .visible = false,
    .named = true,
  },
  [sym__command_end] = {
    .visible = false,
    .named = true,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__string_content_no_interp] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_list] = {
    .visible = false,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_module_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_constrained_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_subtype_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_let_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_const_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_quote_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_selected_import] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_bare_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parameterized_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_type_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_broadcast_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_do_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_named_field] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_matrix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_matrix_row] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_comprehension_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_coefficient_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_quote_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_character_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_command_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_prefixed_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_prefixed_command_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_interpolation] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_selected_import_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bare_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_macro_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_matrix_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_prefixed_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_named_argument] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_condition = 2,
  field_name = 3,
  field_parameters = 4,
  field_prefix = 5,
  field_type_parameters = 6,
  field_value = 7,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_condition] = "condition",
  [field_name] = "name",
  [field_parameters] = "parameters",
  [field_prefix] = "prefix",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [4] = {.index = 0, .length = 1},
  [5] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 3, .length = 2},
  [8] = {.index = 5, .length = 1},
  [9] = {.index = 6, .length = 2},
  [10] = {.index = 8, .length = 2},
  [11] = {.index = 10, .length = 3},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 5, .length = 1},
  [14] = {.index = 15, .length = 2},
  [15] = {.index = 17, .length = 3},
  [17] = {.index = 20, .length = 2},
  [18] = {.index = 13, .length = 2},
  [19] = {.index = 5, .length = 1},
  [20] = {.index = 22, .length = 2},
  [21] = {.index = 24, .length = 3},
  [23] = {.index = 13, .length = 2},
  [24] = {.index = 27, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
  [1] =
    {field_condition, 1},
  [2] =
    {field_prefix, 0},
  [3] =
    {field_name, 1},
    {field_parameters, 2},
  [5] =
    {field_name, 2},
  [6] =
    {field_name, 1},
    {field_type_parameters, 2},
  [8] =
    {field_alternative, 2},
    {field_condition, 1},
  [10] =
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [13] =
    {field_name, 2},
    {field_type_parameters, 3},
  [15] =
    {field_alternative, 3},
    {field_condition, 1},
  [17] =
    {field_alternative, 2},
    {field_alternative, 3},
    {field_condition, 1},
  [20] =
    {field_name, 0},
    {field_value, 2},
  [22] =
    {field_alternative, 4},
    {field_condition, 1},
  [24] =
    {field_alternative, 3},
    {field_alternative, 4},
    {field_condition, 1},
  [27] =
    {field_alternative, 4},
    {field_alternative, 5},
    {field_condition, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_operator,
  },
  [2] = {
    [0] = sym_integer_literal,
  },
  [3] = {
    [1] = sym_operator,
  },
  [13] = {
    [3] = sym_integer_literal,
  },
  [16] = {
    [1] = alias_sym_named_argument,
  },
  [18] = {
    [4] = sym_integer_literal,
  },
  [19] = {
    [4] = sym_integer_literal,
  },
  [22] = {
    [2] = alias_sym_named_argument,
  },
  [23] = {
    [5] = sym_integer_literal,
  },
  [25] = {
    [3] = alias_sym_named_argument,
  },
  [26] = {
    [1] = alias_sym_named_argument,
    [3] = alias_sym_named_argument,
  },
  [27] = {
    [4] = alias_sym_named_argument,
  },
  [28] = {
    [1] = alias_sym_named_argument,
    [4] = alias_sym_named_argument,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_named_field, 2,
    sym_named_field,
    alias_sym_named_argument,
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 6917
    ? (c < 3024
      ? (c < 2392
        ? (c < 1568
          ? (c < 895
            ? (c < 710
              ? (c < 181
                ? (c < 'a'
                  ? (c >= 'A' && c <= '_')
                  : (c <= 'z' || c == 170))
                : (c <= 181 || (c < 192
                  ? c == 186
                  : c <= 705)))
              : (c <= 721 || (c < 880
                ? (c < 748
                  ? (c >= 736 && c <= 740)
                  : (c <= 748 || c == 750))
                : (c <= 884 || (c < 890
                  ? (c >= 886 && c <= 887)
                  : c <= 893)))))
            : (c <= 895 || (c < 1162
              ? (c < 910
                ? (c < 904
                  ? c == 902
                  : (c <= 906 || c == 908))
                : (c <= 929 || (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)))
              : (c <= 1327 || (c < 1376
                ? (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)
                : (c <= 1416 || (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : c <= 1522)))))))
          : (c <= 1610 || (c < 2042
            ? (c < 1791
              ? (c < 1765
                ? (c < 1649
                  ? (c >= 1646 && c <= 1647)
                  : (c <= 1747 || c == 1749))
                : (c <= 1766 || (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : c <= 1788)))
              : (c <= 1791 || (c < 1969
                ? (c < 1810
                  ? c == 1808
                  : (c <= 1839 || (c >= 1869 && c <= 1957)))
                : (c <= 1969 || (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : c <= 2037)))))
            : (c <= 2042 || (c < 2160
              ? (c < 2088
                ? (c < 2074
                  ? (c >= 2048 && c <= 2069)
                  : (c <= 2074 || c == 2084))
                : (c <= 2088 || (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)))
              : (c <= 2183 || (c < 2308
                ? (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)
                : (c <= 2361 || (c < 2384
                  ? c == 2365
                  : c <= 2384)))))))))
        : (c <= 2401 || (c < 2730
          ? (c < 2565
            ? (c < 2486
              ? (c < 2451
                ? (c < 2437
                  ? (c >= 2417 && c <= 2432)
                  : (c <= 2444 || (c >= 2447 && c <= 2448)))
                : (c <= 2472 || (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : c <= 2482)))
              : (c <= 2489 || (c < 2527
                ? (c < 2510
                  ? c == 2493
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : c <= 2556)))))
            : (c <= 2570 || (c < 2649
              ? (c < 2610
                ? (c < 2579
                  ? (c >= 2575 && c <= 2576)
                  : (c <= 2600 || (c >= 2602 && c <= 2608)))
                : (c <= 2611 || (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)))
              : (c <= 2652 || (c < 2693
                ? (c < 2674
                  ? c == 2654
                  : c <= 2676)
                : (c <= 2701 || (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : c <= 2728)))))))
          : (c <= 2736 || (c < 2908
            ? (c < 2821
              ? (c < 2768
                ? (c < 2741
                  ? (c >= 2738 && c <= 2739)
                  : (c <= 2745 || c == 2749))
                : (c <= 2768 || (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : c <= 2809)))
              : (c <= 2828 || (c < 2866
                ? (c < 2835
                  ? (c >= 2831 && c <= 2832)
                  : (c <= 2856 || (c >= 2858 && c <= 2864)))
                : (c <= 2867 || (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : c <= 2877)))))
            : (c <= 2909 || (c < 2969
              ? (c < 2949
                ? (c < 2929
                  ? (c >= 2911 && c <= 2913)
                  : (c <= 2929 || c == 2947))
                : (c <= 2954 || (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)))
              : (c <= 2970 || (c < 2979
                ? (c < 2974
                  ? c == 2972
                  : c <= 2975)
                : (c <= 2980 || (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : c <= 3001)))))))))))
      : (c <= 3024 || (c < 4193
        ? (c < 3461
          ? (c < 3253
            ? (c < 3165
              ? (c < 3114
                ? (c < 3086
                  ? (c >= 3077 && c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))
                : (c <= 3129 || (c < 3160
                  ? c == 3133
                  : c <= 3162)))
              : (c <= 3165 || (c < 3214
                ? (c < 3200
                  ? (c >= 3168 && c <= 3169)
                  : (c <= 3200 || (c >= 3205 && c <= 3212)))
                : (c <= 3216 || (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : c <= 3251)))))
            : (c <= 3257 || (c < 3346
              ? (c < 3313
                ? (c < 3293
                  ? c == 3261
                  : (c <= 3294 || (c >= 3296 && c <= 3297)))
                : (c <= 3314 || (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)))
              : (c <= 3386 || (c < 3412
                ? (c < 3406
                  ? c == 3389
                  : c <= 3406)
                : (c <= 3414 || (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : c <= 3455)))))))
          : (c <= 3478 || (c < 3762
            ? (c < 3648
              ? (c < 3520
                ? (c < 3507
                  ? (c >= 3482 && c <= 3505)
                  : (c <= 3515 || c == 3517))
                : (c <= 3526 || (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : c <= 3635)))
              : (c <= 3654 || (c < 3724
                ? (c < 3716
                  ? (c >= 3713 && c <= 3714)
                  : (c <= 3716 || (c >= 3718 && c <= 3722)))
                : (c <= 3747 || (c < 3751
                  ? c == 3749
                  : c <= 3760)))))
            : (c <= 3763 || (c < 3913
              ? (c < 3804
                ? (c < 3776
                  ? c == 3773
                  : (c <= 3780 || c == 3782))
                : (c <= 3807 || (c < 3904
                  ? c == 3840
                  : c <= 3911)))
              : (c <= 3948 || (c < 4159
                ? (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)
                : (c <= 4159 || (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : c <= 4189)))))))))
        : (c <= 4193 || (c < 5112
          ? (c < 4704
            ? (c < 4301
              ? (c < 4238
                ? (c < 4206
                  ? (c >= 4197 && c <= 4198)
                  : (c <= 4208 || (c >= 4213 && c <= 4225)))
                : (c <= 4238 || (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : c <= 4295)))
              : (c <= 4301 || (c < 4688
                ? (c < 4348
                  ? (c >= 4304 && c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))
                : (c <= 4694 || (c < 4698
                  ? c == 4696
                  : c <= 4701)))))
            : (c <= 4744 || (c < 4808
              ? (c < 4792
                ? (c < 4752
                  ? (c >= 4746 && c <= 4749)
                  : (c <= 4784 || (c >= 4786 && c <= 4789)))
                : (c <= 4798 || (c < 4802
                  ? c == 4800
                  : c <= 4805)))
              : (c <= 4822 || (c < 4888
                ? (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)
                : (c <= 4954 || (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : c <= 5109)))))))
          : (c <= 5117 || (c < 6176
            ? (c < 5919
              ? (c < 5792
                ? (c < 5743
                  ? (c >= 5121 && c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))
                : (c <= 5866 || (c < 5888
                  ? (c >= 5870 && c <= 5880)
                  : c <= 5905)))
              : (c <= 5937 || (c < 6016
                ? (c < 5984
                  ? (c >= 5952 && c <= 5969)
                  : (c <= 5996 || (c >= 5998 && c <= 6000)))
                : (c <= 6067 || (c < 6108
                  ? c == 6103
                  : c <= 6108)))))
            : (c <= 6264 || (c < 6512
              ? (c < 6320
                ? (c < 6279
                  ? (c >= 6272 && c <= 6276)
                  : (c <= 6312 || c == 6314))
                : (c <= 6389 || (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)))
              : (c <= 6516 || (c < 6656
                ? (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)
                : (c <= 6678 || (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : c <= 6823)))))))))))))
    : (c <= 6963 || (c < 43261
      ? (c < 11499
        ? (c < 8126
          ? (c < 7418
            ? (c < 7258
              ? (c < 7098
                ? (c < 7043
                  ? (c >= 6981 && c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : c <= 7247)))
              : (c <= 7293 || (c < 7401
                ? (c < 7312
                  ? (c >= 7296 && c <= 7304)
                  : (c <= 7354 || (c >= 7357 && c <= 7359)))
                : (c <= 7404 || (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : c <= 7414)))))
            : (c <= 7418 || (c < 8025
              ? (c < 7968
                ? (c < 7680
                  ? (c >= 7424 && c <= 7615)
                  : (c <= 7957 || (c >= 7960 && c <= 7965)))
                : (c <= 8005 || (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)))
              : (c <= 8025 || (c < 8031
                ? (c < 8029
                  ? c == 8027
                  : c <= 8029)
                : (c <= 8061 || (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : c <= 8124)))))))
          : (c <= 8126 || (c < 8469
            ? (c < 8182
              ? (c < 8150
                ? (c < 8134
                  ? (c >= 8130 && c <= 8132)
                  : (c <= 8140 || (c >= 8144 && c <= 8147)))
                : (c <= 8155 || (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : c <= 8180)))
              : (c <= 8188 || (c < 8450
                ? (c < 8319
                  ? c == 8305
                  : (c <= 8319 || (c >= 8336 && c <= 8348)))
                : (c <= 8450 || (c < 8458
                  ? c == 8455
                  : c <= 8467)))))
            : (c <= 8469 || (c < 8508
              ? (c < 8488
                ? (c < 8484
                  ? (c >= 8473 && c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)))
              : (c <= 8511 || (c < 8544
                ? (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)
                : (c <= 8584 || (c < 11264
                  ? c == 8711
                  : c <= 11492)))))))))
        : (c <= 11502 || (c < 12704
          ? (c < 11728
            ? (c < 11648
              ? (c < 11565
                ? (c < 11520
                  ? (c >= 11506 && c <= 11507)
                  : (c <= 11557 || c == 11559))
                : (c <= 11565 || (c < 11631
                  ? (c >= 11568 && c <= 11623)
                  : c <= 11631)))
              : (c <= 11670 || (c < 11704
                ? (c < 11688
                  ? (c >= 11680 && c <= 11686)
                  : (c <= 11694 || (c >= 11696 && c <= 11702)))
                : (c <= 11710 || (c < 11720
                  ? (c >= 11712 && c <= 11718)
                  : c <= 11726)))))
            : (c <= 11734 || (c < 12353
              ? (c < 12321
                ? (c < 11823
                  ? (c >= 11736 && c <= 11742)
                  : (c <= 11823 || (c >= 12293 && c <= 12295)))
                : (c <= 12329 || (c < 12344
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)))
              : (c <= 12438 || (c < 12540
                ? (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : c <= 12538)
                : (c <= 12543 || (c < 12593
                  ? (c >= 12549 && c <= 12591)
                  : c <= 12686)))))))
          : (c <= 12735 || (c < 42786
            ? (c < 42240
              ? (c < 19968
                ? (c < 13312
                  ? (c >= 12784 && c <= 12799)
                  : (c <= 13312 || c == 19903))
                : (c <= 19968 || (c < 42192
                  ? (c >= 40959 && c <= 42124)
                  : c <= 42237)))
              : (c <= 42508 || (c < 42623
                ? (c < 42538
                  ? (c >= 42512 && c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42775
                  ? (c >= 42656 && c <= 42735)
                  : c <= 42783)))))
            : (c <= 42888 || (c < 43015
              ? (c < 42965
                ? (c < 42960
                  ? (c >= 42891 && c <= 42954)
                  : (c <= 42961 || c == 42963))
                : (c <= 42969 || (c < 43011
                  ? (c >= 42994 && c <= 43009)
                  : c <= 43013)))
              : (c <= 43018 || (c < 43138
                ? (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)
                : (c <= 43187 || (c < 43259
                  ? (c >= 43250 && c <= 43255)
                  : c <= 43259)))))))))))
      : (c <= 43262 || (c < 65345
        ? (c < 43816
          ? (c < 43646
            ? (c < 43494
              ? (c < 43396
                ? (c < 43312
                  ? (c >= 43274 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43488
                  ? c == 43471
                  : c <= 43492)))
              : (c <= 43503 || (c < 43588
                ? (c < 43520
                  ? (c >= 43514 && c <= 43518)
                  : (c <= 43560 || (c >= 43584 && c <= 43586)))
                : (c <= 43595 || (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : c <= 43642)))))
            : (c <= 43695 || (c < 43744
              ? (c < 43712
                ? (c < 43701
                  ? c == 43697
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))
                : (c <= 43712 || (c < 43739
                  ? c == 43714
                  : c <= 43741)))
              : (c <= 43754 || (c < 43785
                ? (c < 43777
                  ? (c >= 43762 && c <= 43764)
                  : c <= 43782)
                : (c <= 43790 || (c < 43808
                  ? (c >= 43793 && c <= 43798)
                  : c <= 43814)))))))
          : (c <= 43822 || (c < 64298
            ? (c < 55243
              ? (c < 44032
                ? (c < 43868
                  ? (c >= 43824 && c <= 43866)
                  : (c <= 43881 || (c >= 43888 && c <= 44002)))
                : (c <= 44032 || (c < 55216
                  ? c == 55203
                  : c <= 55238)))
              : (c <= 55291 || (c < 64275
                ? (c < 64112
                  ? (c >= 63744 && c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))
                : (c <= 64279 || (c < 64287
                  ? c == 64285
                  : c <= 64296)))))
            : (c <= 64310 || (c < 64848
              ? (c < 64323
                ? (c < 64318
                  ? (c >= 64312 && c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : c <= 64829)))
              : (c <= 64911 || (c < 65136
                ? (c < 65008
                  ? (c >= 64914 && c <= 64967)
                  : c <= 65019)
                : (c <= 65140 || (c < 65313
                  ? (c >= 65142 && c <= 65276)
                  : c <= 65338)))))))))
        : (c <= 65370 || (c < 66864
          ? (c < 66176
            ? (c < 65549
              ? (c < 65490
                ? (c < 65474
                  ? (c >= 65382 && c <= 65470)
                  : (c <= 65479 || (c >= 65482 && c <= 65487)))
                : (c <= 65495 || (c < 65536
                  ? (c >= 65498 && c <= 65500)
                  : c <= 65547)))
              : (c <= 65574 || (c < 65616
                ? (c < 65596
                  ? (c >= 65576 && c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))
                : (c <= 65629 || (c < 65856
                  ? (c >= 65664 && c <= 65786)
                  : c <= 65908)))))
            : (c <= 66204 || (c < 66504
              ? (c < 66384
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66378)))
                : (c <= 66421 || (c < 66464
                  ? (c >= 66432 && c <= 66461)
                  : c <= 66499)))
              : (c <= 66511 || (c < 66736
                ? (c < 66560
                  ? (c >= 66513 && c <= 66517)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 6917
    ? (c < 3024
      ? (c < 2392
        ? (c < 1568
          ? (c < 890
            ? (c < 192
              ? (c < 170
                ? (c < '_'
                  ? (c >= 'A' && c <= 'Z')
                  : (c <= '_' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 705 || (c < 750
                ? (c < 736
                  ? (c >= 710 && c <= 721)
                  : (c <= 740 || c == 748))
                : (c <= 750 || (c < 886
                  ? (c >= 880 && c <= 884)
                  : c <= 887)))))
            : (c <= 893 || (c < 1015
              ? (c < 908
                ? (c < 902
                  ? c == 895
                  : (c <= 902 || (c >= 904 && c <= 906)))
                : (c <= 908 || (c < 931
                  ? (c >= 910 && c <= 929)
                  : c <= 1013)))
              : (c <= 1153 || (c < 1376
                ? (c < 1329
                  ? (c >= 1162 && c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : c <= 1522)))))))
          : (c <= 1610 || (c < 2042
            ? (c < 1791
              ? (c < 1765
                ? (c < 1649
                  ? (c >= 1646 && c <= 1647)
                  : (c <= 1747 || c == 1749))
                : (c <= 1766 || (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : c <= 1788)))
              : (c <= 1791 || (c < 1969
                ? (c < 1810
                  ? c == 1808
                  : (c <= 1839 || (c >= 1869 && c <= 1957)))
                : (c <= 1969 || (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : c <= 2037)))))
            : (c <= 2042 || (c < 2160
              ? (c < 2088
                ? (c < 2074
                  ? (c >= 2048 && c <= 2069)
                  : (c <= 2074 || c == 2084))
                : (c <= 2088 || (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)))
              : (c <= 2183 || (c < 2308
                ? (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)
                : (c <= 2361 || (c < 2384
                  ? c == 2365
                  : c <= 2384)))))))))
        : (c <= 2401 || (c < 2730
          ? (c < 2565
            ? (c < 2486
              ? (c < 2451
                ? (c < 2437
                  ? (c >= 2417 && c <= 2432)
                  : (c <= 2444 || (c >= 2447 && c <= 2448)))
                : (c <= 2472 || (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : c <= 2482)))
              : (c <= 2489 || (c < 2527
                ? (c < 2510
                  ? c == 2493
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : c <= 2556)))))
            : (c <= 2570 || (c < 2649
              ? (c < 2610
                ? (c < 2579
                  ? (c >= 2575 && c <= 2576)
                  : (c <= 2600 || (c >= 2602 && c <= 2608)))
                : (c <= 2611 || (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)))
              : (c <= 2652 || (c < 2693
                ? (c < 2674
                  ? c == 2654
                  : c <= 2676)
                : (c <= 2701 || (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : c <= 2728)))))))
          : (c <= 2736 || (c < 2908
            ? (c < 2821
              ? (c < 2768
                ? (c < 2741
                  ? (c >= 2738 && c <= 2739)
                  : (c <= 2745 || c == 2749))
                : (c <= 2768 || (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : c <= 2809)))
              : (c <= 2828 || (c < 2866
                ? (c < 2835
                  ? (c >= 2831 && c <= 2832)
                  : (c <= 2856 || (c >= 2858 && c <= 2864)))
                : (c <= 2867 || (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : c <= 2877)))))
            : (c <= 2909 || (c < 2969
              ? (c < 2949
                ? (c < 2929
                  ? (c >= 2911 && c <= 2913)
                  : (c <= 2929 || c == 2947))
                : (c <= 2954 || (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)))
              : (c <= 2970 || (c < 2979
                ? (c < 2974
                  ? c == 2972
                  : c <= 2975)
                : (c <= 2980 || (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : c <= 3001)))))))))))
      : (c <= 3024 || (c < 4193
        ? (c < 3461
          ? (c < 3253
            ? (c < 3165
              ? (c < 3114
                ? (c < 3086
                  ? (c >= 3077 && c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))
                : (c <= 3129 || (c < 3160
                  ? c == 3133
                  : c <= 3162)))
              : (c <= 3165 || (c < 3214
                ? (c < 3200
                  ? (c >= 3168 && c <= 3169)
                  : (c <= 3200 || (c >= 3205 && c <= 3212)))
                : (c <= 3216 || (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : c <= 3251)))))
            : (c <= 3257 || (c < 3346
              ? (c < 3313
                ? (c < 3293
                  ? c == 3261
                  : (c <= 3294 || (c >= 3296 && c <= 3297)))
                : (c <= 3314 || (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)))
              : (c <= 3386 || (c < 3412
                ? (c < 3406
                  ? c == 3389
                  : c <= 3406)
                : (c <= 3414 || (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : c <= 3455)))))))
          : (c <= 3478 || (c < 3762
            ? (c < 3648
              ? (c < 3520
                ? (c < 3507
                  ? (c >= 3482 && c <= 3505)
                  : (c <= 3515 || c == 3517))
                : (c <= 3526 || (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : c <= 3635)))
              : (c <= 3654 || (c < 3724
                ? (c < 3716
                  ? (c >= 3713 && c <= 3714)
                  : (c <= 3716 || (c >= 3718 && c <= 3722)))
                : (c <= 3747 || (c < 3751
                  ? c == 3749
                  : c <= 3760)))))
            : (c <= 3763 || (c < 3913
              ? (c < 3804
                ? (c < 3776
                  ? c == 3773
                  : (c <= 3780 || c == 3782))
                : (c <= 3807 || (c < 3904
                  ? c == 3840
                  : c <= 3911)))
              : (c <= 3948 || (c < 4159
                ? (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)
                : (c <= 4159 || (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : c <= 4189)))))))))
        : (c <= 4193 || (c < 5112
          ? (c < 4704
            ? (c < 4301
              ? (c < 4238
                ? (c < 4206
                  ? (c >= 4197 && c <= 4198)
                  : (c <= 4208 || (c >= 4213 && c <= 4225)))
                : (c <= 4238 || (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : c <= 4295)))
              : (c <= 4301 || (c < 4688
                ? (c < 4348
                  ? (c >= 4304 && c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))
                : (c <= 4694 || (c < 4698
                  ? c == 4696
                  : c <= 4701)))))
            : (c <= 4744 || (c < 4808
              ? (c < 4792
                ? (c < 4752
                  ? (c >= 4746 && c <= 4749)
                  : (c <= 4784 || (c >= 4786 && c <= 4789)))
                : (c <= 4798 || (c < 4802
                  ? c == 4800
                  : c <= 4805)))
              : (c <= 4822 || (c < 4888
                ? (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)
                : (c <= 4954 || (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : c <= 5109)))))))
          : (c <= 5117 || (c < 6176
            ? (c < 5919
              ? (c < 5792
                ? (c < 5743
                  ? (c >= 5121 && c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))
                : (c <= 5866 || (c < 5888
                  ? (c >= 5870 && c <= 5880)
                  : c <= 5905)))
              : (c <= 5937 || (c < 6016
                ? (c < 5984
                  ? (c >= 5952 && c <= 5969)
                  : (c <= 5996 || (c >= 5998 && c <= 6000)))
                : (c <= 6067 || (c < 6108
                  ? c == 6103
                  : c <= 6108)))))
            : (c <= 6264 || (c < 6512
              ? (c < 6320
                ? (c < 6279
                  ? (c >= 6272 && c <= 6276)
                  : (c <= 6312 || c == 6314))
                : (c <= 6389 || (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)))
              : (c <= 6516 || (c < 6656
                ? (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)
                : (c <= 6678 || (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : c <= 6823)))))))))))))
    : (c <= 6963 || (c < 43261
      ? (c < 11499
        ? (c < 8126
          ? (c < 7418
            ? (c < 7258
              ? (c < 7098
                ? (c < 7043
                  ? (c >= 6981 && c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : c <= 7247)))
              : (c <= 7293 || (c < 7401
                ? (c < 7312
                  ? (c >= 7296 && c <= 7304)
                  : (c <= 7354 || (c >= 7357 && c <= 7359)))
                : (c <= 7404 || (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : c <= 7414)))))
            : (c <= 7418 || (c < 8025
              ? (c < 7968
                ? (c < 7680
                  ? (c >= 7424 && c <= 7615)
                  : (c <= 7957 || (c >= 7960 && c <= 7965)))
                : (c <= 8005 || (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)))
              : (c <= 8025 || (c < 8031
                ? (c < 8029
                  ? c == 8027
                  : c <= 8029)
                : (c <= 8061 || (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : c <= 8124)))))))
          : (c <= 8126 || (c < 8469
            ? (c < 8182
              ? (c < 8150
                ? (c < 8134
                  ? (c >= 8130 && c <= 8132)
                  : (c <= 8140 || (c >= 8144 && c <= 8147)))
                : (c <= 8155 || (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : c <= 8180)))
              : (c <= 8188 || (c < 8450
                ? (c < 8319
                  ? c == 8305
                  : (c <= 8319 || (c >= 8336 && c <= 8348)))
                : (c <= 8450 || (c < 8458
                  ? c == 8455
                  : c <= 8467)))))
            : (c <= 8469 || (c < 8508
              ? (c < 8488
                ? (c < 8484
                  ? (c >= 8473 && c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)))
              : (c <= 8511 || (c < 8544
                ? (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)
                : (c <= 8584 || (c < 11264
                  ? c == 8711
                  : c <= 11492)))))))))
        : (c <= 11502 || (c < 12704
          ? (c < 11728
            ? (c < 11648
              ? (c < 11565
                ? (c < 11520
                  ? (c >= 11506 && c <= 11507)
                  : (c <= 11557 || c == 11559))
                : (c <= 11565 || (c < 11631
                  ? (c >= 11568 && c <= 11623)
                  : c <= 11631)))
              : (c <= 11670 || (c < 11704
                ? (c < 11688
                  ? (c >= 11680 && c <= 11686)
                  : (c <= 11694 || (c >= 11696 && c <= 11702)))
                : (c <= 11710 || (c < 11720
                  ? (c >= 11712 && c <= 11718)
                  : c <= 11726)))))
            : (c <= 11734 || (c < 12353
              ? (c < 12321
                ? (c < 11823
                  ? (c >= 11736 && c <= 11742)
                  : (c <= 11823 || (c >= 12293 && c <= 12295)))
                : (c <= 12329 || (c < 12344
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)))
              : (c <= 12438 || (c < 12540
                ? (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : c <= 12538)
                : (c <= 12543 || (c < 12593
                  ? (c >= 12549 && c <= 12591)
                  : c <= 12686)))))))
          : (c <= 12735 || (c < 42786
            ? (c < 42240
              ? (c < 19968
                ? (c < 13312
                  ? (c >= 12784 && c <= 12799)
                  : (c <= 13312 || c == 19903))
                : (c <= 19968 || (c < 42192
                  ? (c >= 40959 && c <= 42124)
                  : c <= 42237)))
              : (c <= 42508 || (c < 42623
                ? (c < 42538
                  ? (c >= 42512 && c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42775
                  ? (c >= 42656 && c <= 42735)
                  : c <= 42783)))))
            : (c <= 42888 || (c < 43015
              ? (c < 42965
                ? (c < 42960
                  ? (c >= 42891 && c <= 42954)
                  : (c <= 42961 || c == 42963))
                : (c <= 42969 || (c < 43011
                  ? (c >= 42994 && c <= 43009)
                  : c <= 43013)))
              : (c <= 43018 || (c < 43138
                ? (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)
                : (c <= 43187 || (c < 43259
                  ? (c >= 43250 && c <= 43255)
                  : c <= 43259)))))))))))
      : (c <= 43262 || (c < 65345
        ? (c < 43816
          ? (c < 43646
            ? (c < 43494
              ? (c < 43396
                ? (c < 43312
                  ? (c >= 43274 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43488
                  ? c == 43471
                  : c <= 43492)))
              : (c <= 43503 || (c < 43588
                ? (c < 43520
                  ? (c >= 43514 && c <= 43518)
                  : (c <= 43560 || (c >= 43584 && c <= 43586)))
                : (c <= 43595 || (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : c <= 43642)))))
            : (c <= 43695 || (c < 43744
              ? (c < 43712
                ? (c < 43701
                  ? c == 43697
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))
                : (c <= 43712 || (c < 43739
                  ? c == 43714
                  : c <= 43741)))
              : (c <= 43754 || (c < 43785
                ? (c < 43777
                  ? (c >= 43762 && c <= 43764)
                  : c <= 43782)
                : (c <= 43790 || (c < 43808
                  ? (c >= 43793 && c <= 43798)
                  : c <= 43814)))))))
          : (c <= 43822 || (c < 64298
            ? (c < 55243
              ? (c < 44032
                ? (c < 43868
                  ? (c >= 43824 && c <= 43866)
                  : (c <= 43881 || (c >= 43888 && c <= 44002)))
                : (c <= 44032 || (c < 55216
                  ? c == 55203
                  : c <= 55238)))
              : (c <= 55291 || (c < 64275
                ? (c < 64112
                  ? (c >= 63744 && c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))
                : (c <= 64279 || (c < 64287
                  ? c == 64285
                  : c <= 64296)))))
            : (c <= 64310 || (c < 64848
              ? (c < 64323
                ? (c < 64318
                  ? (c >= 64312 && c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : c <= 64829)))
              : (c <= 64911 || (c < 65136
                ? (c < 65008
                  ? (c >= 64914 && c <= 64967)
                  : c <= 65019)
                : (c <= 65140 || (c < 65313
                  ? (c >= 65142 && c <= 65276)
                  : c <= 65338)))))))))
        : (c <= 65370 || (c < 66864
          ? (c < 66176
            ? (c < 65549
              ? (c < 65490
                ? (c < 65474
                  ? (c >= 65382 && c <= 65470)
                  : (c <= 65479 || (c >= 65482 && c <= 65487)))
                : (c <= 65495 || (c < 65536
                  ? (c >= 65498 && c <= 65500)
                  : c <= 65547)))
              : (c <= 65574 || (c < 65616
                ? (c < 65596
                  ? (c >= 65576 && c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))
                : (c <= 65629 || (c < 65856
                  ? (c >= 65664 && c <= 65786)
                  : c <= 65908)))))
            : (c <= 66204 || (c < 66504
              ? (c < 66384
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66378)))
                : (c <= 66421 || (c < 66464
                  ? (c >= 66432 && c <= 66461)
                  : c <= 66499)))
              : (c <= 66511 || (c < 66736
                ? (c < 66560
                  ? (c >= 66513 && c <= 66517)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 6823
    ? (c < 2984
      ? (c < 2365
        ? (c < 1488
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < '_'
                  ? (c >= 'A' && c <= 'Z')
                  : (c <= '_' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1329
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : (c <= 1153 || (c >= 1162 && c <= 1327)))
                : (c <= 1366 || (c < 1376
                  ? c == 1369
                  : c <= 1416)))))))
          : (c <= 1514 || (c < 1994
            ? (c < 1774
              ? (c < 1649
                ? (c < 1568
                  ? (c >= 1519 && c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))
                : (c <= 1747 || (c < 1765
                  ? c == 1749
                  : c <= 1766)))
              : (c <= 1775 || (c < 1810
                ? (c < 1791
                  ? (c >= 1786 && c <= 1788)
                  : (c <= 1791 || c == 1808))
                : (c <= 1839 || (c < 1969
                  ? (c >= 1869 && c <= 1957)
                  : c <= 1969)))))
            : (c <= 2026 || (c < 2112
              ? (c < 2074
                ? (c < 2042
                  ? (c >= 2036 && c <= 2037)
                  : (c <= 2042 || (c >= 2048 && c <= 2069)))
                : (c <= 2074 || (c < 2088
                  ? c == 2084
                  : c <= 2088)))
              : (c <= 2136 || (c < 2185
                ? (c < 2160
                  ? (c >= 2144 && c <= 2154)
                  : c <= 2183)
                : (c <= 2190 || (c < 2308
                  ? (c >= 2208 && c <= 2249)
                  : c <= 2361)))))))))
        : (c <= 2365 || (c < 2703
          ? (c < 2544
            ? (c < 2474
              ? (c < 2437
                ? (c < 2392
                  ? c == 2384
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2451
                  ? (c >= 2447 && c <= 2448)
                  : c <= 2472)))
              : (c <= 2480 || (c < 2510
                ? (c < 2486
                  ? c == 2482
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2527
                  ? (c >= 2524 && c <= 2525)
                  : c <= 2529)))))
            : (c <= 2545 || (c < 2613
              ? (c < 2579
                ? (c < 2565
                  ? c == 2556
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2610
                  ? (c >= 2602 && c <= 2608)
                  : c <= 2611)))
              : (c <= 2614 || (c < 2654
                ? (c < 2649
                  ? (c >= 2616 && c <= 2617)
                  : c <= 2652)
                : (c <= 2654 || (c < 2693
                  ? (c >= 2674 && c <= 2676)
                  : c <= 2701)))))))
          : (c <= 2705 || (c < 2869
            ? (c < 2784
              ? (c < 2741
                ? (c < 2730
                  ? (c >= 2707 && c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2768
                  ? c == 2749
                  : c <= 2768)))
              : (c <= 2785 || (c < 2835
                ? (c < 2821
                  ? c == 2809
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2866
                  ? (c >= 2858 && c <= 2864)
                  : c <= 2867)))))
            : (c <= 2873 || (c < 2958
              ? (c < 2929
                ? (c < 2908
                  ? c == 2877
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2929 || (c < 2949
                  ? c == 2947
                  : c <= 2954)))
              : (c <= 2960 || (c < 2972
                ? (c < 2969
                  ? (c >= 2962 && c <= 2965)
                  : c <= 2970)
                : (c <= 2972 || (c < 2979
                  ? (c >= 2974 && c <= 2975)
                  : c <= 2980)))))))))))
      : (c <= 2986 || (c < 4186
        ? (c < 3450
          ? (c < 3218
            ? (c < 3133
              ? (c < 3086
                ? (c < 3024
                  ? (c >= 2990 && c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))
                : (c <= 3088 || (c < 3114
                  ? (c >= 3090 && c <= 3112)
                  : c <= 3129)))
              : (c <= 3133 || (c < 3200
                ? (c < 3165
                  ? (c >= 3160 && c <= 3162)
                  : (c <= 3165 || (c >= 3168 && c <= 3169)))
                : (c <= 3200 || (c < 3214
                  ? (c >= 3205 && c <= 3212)
                  : c <= 3216)))))
            : (c <= 3240 || (c < 3332
              ? (c < 3293
                ? (c < 3253
                  ? (c >= 3242 && c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3313
                  ? (c >= 3296 && c <= 3297)
                  : c <= 3314)))
              : (c <= 3340 || (c < 3406
                ? (c < 3346
                  ? (c >= 3342 && c <= 3344)
                  : (c <= 3386 || c == 3389))
                : (c <= 3406 || (c < 3423
                  ? (c >= 3412 && c <= 3414)
                  : c <= 3425)))))))
          : (c <= 3455 || (c < 3751
            ? (c < 3634
              ? (c < 3517
                ? (c < 3482
                  ? (c >= 3461 && c <= 3478)
                  : (c <= 3505 || (c >= 3507 && c <= 3515)))
                : (c <= 3517 || (c < 3585
                  ? (c >= 3520 && c <= 3526)
                  : c <= 3632)))
              : (c <= 3635 || (c < 3718
                ? (c < 3713
                  ? (c >= 3648 && c <= 3654)
                  : (c <= 3714 || c == 3716))
                : (c <= 3722 || (c < 3749
                  ? (c >= 3724 && c <= 3747)
                  : c <= 3749)))))
            : (c <= 3760 || (c < 3904
              ? (c < 3782
                ? (c < 3773
                  ? (c >= 3762 && c <= 3763)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))
                : (c <= 3782 || (c < 3840
                  ? (c >= 3804 && c <= 3807)
                  : c <= 3840)))
              : (c <= 3911 || (c < 4096
                ? (c < 3976
                  ? (c >= 3913 && c <= 3948)
                  : c <= 3980)
                : (c <= 4138 || (c < 4176
                  ? c == 4159
                  : c <= 4181)))))))))
        : (c <= 4189 || (c < 5024
          ? (c < 4698
            ? (c < 4295
              ? (c < 4213
                ? (c < 4197
                  ? c == 4193
                  : (c <= 4198 || (c >= 4206 && c <= 4208)))
                : (c <= 4225 || (c < 4256
                  ? c == 4238
                  : c <= 4293)))
              : (c <= 4295 || (c < 4682
                ? (c < 4304
                  ? c == 4301
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))
                : (c <= 4685 || (c < 4696
                  ? (c >= 4688 && c <= 4694)
                  : c <= 4696)))))
            : (c <= 4701 || (c < 4802
              ? (c < 4786
                ? (c < 4746
                  ? (c >= 4704 && c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))
                : (c <= 4789 || (c < 4800
                  ? (c >= 4792 && c <= 4798)
                  : c <= 4800)))
              : (c <= 4805 || (c < 4882
                ? (c < 4824
                  ? (c >= 4808 && c <= 4822)
                  : c <= 4880)
                : (c <= 4885 || (c < 4992
                  ? (c >= 4888 && c <= 4954)
                  : c <= 5007)))))))
          : (c <= 5109 || (c < 6108
            ? (c < 5888
              ? (c < 5761
                ? (c < 5121
                  ? (c >= 5112 && c <= 5117)
                  : (c <= 5740 || (c >= 5743 && c <= 5759)))
                : (c <= 5786 || (c < 5870
                  ? (c >= 5792 && c <= 5866)
                  : c <= 5880)))
              : (c <= 5905 || (c < 5998
                ? (c < 5952
                  ? (c >= 5919 && c <= 5937)
                  : (c <= 5969 || (c >= 5984 && c <= 5996)))
                : (c <= 6000 || (c < 6103
                  ? (c >= 6016 && c <= 6067)
                  : c <= 6103)))))
            : (c <= 6108 || (c < 6480
              ? (c < 6314
                ? (c < 6272
                  ? (c >= 6176 && c <= 6264)
                  : (c <= 6276 || (c >= 6279 && c <= 6312)))
                : (c <= 6314 || (c < 6400
                  ? (c >= 6320 && c <= 6389)
                  : c <= 6430)))
              : (c <= 6509 || (c < 6576
                ? (c < 6528
                  ? (c >= 6512 && c <= 6516)
                  : c <= 6571)
                : (c <= 6601 || (c < 6688
                  ? (c >= 6656 && c <= 6678)
                  : c <= 6740)))))))))))))
    : (c <= 6823 || (c < 43261
      ? (c < 11499
        ? (c < 8126
          ? (c < 7413
            ? (c < 7245
              ? (c < 7086
                ? (c < 6981
                  ? (c >= 6917 && c <= 6963)
                  : (c <= 6988 || (c >= 7043 && c <= 7072)))
                : (c <= 7087 || (c < 7168
                  ? (c >= 7098 && c <= 7141)
                  : c <= 7203)))
              : (c <= 7247 || (c < 7357
                ? (c < 7296
                  ? (c >= 7258 && c <= 7293)
                  : (c <= 7304 || (c >= 7312 && c <= 7354)))
                : (c <= 7359 || (c < 7406
                  ? (c >= 7401 && c <= 7404)
                  : c <= 7411)))))
            : (c <= 7414 || (c < 8016
              ? (c < 7960
                ? (c < 7424
                  ? c == 7418
                  : (c <= 7615 || (c >= 7680 && c <= 7957)))
                : (c <= 7965 || (c < 8008
                  ? (c >= 7968 && c <= 8005)
                  : c <= 8013)))
              : (c <= 8023 || (c < 8031
                ? (c < 8027
                  ? c == 8025
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : c <= 8124)))))))
          : (c <= 8126 || (c < 8469
            ? (c < 8182
              ? (c < 8150
                ? (c < 8134
                  ? (c >= 8130 && c <= 8132)
                  : (c <= 8140 || (c >= 8144 && c <= 8147)))
                : (c <= 8155 || (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : c <= 8180)))
              : (c <= 8188 || (c < 8450
                ? (c < 8319
                  ? c == 8305
                  : (c <= 8319 || (c >= 8336 && c <= 8348)))
                : (c <= 8450 || (c < 8458
                  ? c == 8455
                  : c <= 8467)))))
            : (c <= 8469 || (c < 8508
              ? (c < 8488
                ? (c < 8484
                  ? (c >= 8473 && c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)))
              : (c <= 8511 || (c < 8544
                ? (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)
                : (c <= 8584 || (c < 11264
                  ? c == 8711
                  : c <= 11492)))))))))
        : (c <= 11502 || (c < 12704
          ? (c < 11728
            ? (c < 11648
              ? (c < 11565
                ? (c < 11520
                  ? (c >= 11506 && c <= 11507)
                  : (c <= 11557 || c == 11559))
                : (c <= 11565 || (c < 11631
                  ? (c >= 11568 && c <= 11623)
                  : c <= 11631)))
              : (c <= 11670 || (c < 11704
                ? (c < 11688
                  ? (c >= 11680 && c <= 11686)
                  : (c <= 11694 || (c >= 11696 && c <= 11702)))
                : (c <= 11710 || (c < 11720
                  ? (c >= 11712 && c <= 11718)
                  : c <= 11726)))))
            : (c <= 11734 || (c < 12353
              ? (c < 12321
                ? (c < 11823
                  ? (c >= 11736 && c <= 11742)
                  : (c <= 11823 || (c >= 12293 && c <= 12295)))
                : (c <= 12329 || (c < 12344
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)))
              : (c <= 12438 || (c < 12540
                ? (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : c <= 12538)
                : (c <= 12543 || (c < 12593
                  ? (c >= 12549 && c <= 12591)
                  : c <= 12686)))))))
          : (c <= 12735 || (c < 42786
            ? (c < 42240
              ? (c < 19968
                ? (c < 13312
                  ? (c >= 12784 && c <= 12799)
                  : (c <= 13312 || c == 19903))
                : (c <= 19968 || (c < 42192
                  ? (c >= 40959 && c <= 42124)
                  : c <= 42237)))
              : (c <= 42508 || (c < 42623
                ? (c < 42538
                  ? (c >= 42512 && c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42775
                  ? (c >= 42656 && c <= 42735)
                  : c <= 42783)))))
            : (c <= 42888 || (c < 43015
              ? (c < 42965
                ? (c < 42960
                  ? (c >= 42891 && c <= 42954)
                  : (c <= 42961 || c == 42963))
                : (c <= 42969 || (c < 43011
                  ? (c >= 42994 && c <= 43009)
                  : c <= 43013)))
              : (c <= 43018 || (c < 43138
                ? (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)
                : (c <= 43187 || (c < 43259
                  ? (c >= 43250 && c <= 43255)
                  : c <= 43259)))))))))))
      : (c <= 43262 || (c < 65345
        ? (c < 43816
          ? (c < 43646
            ? (c < 43494
              ? (c < 43396
                ? (c < 43312
                  ? (c >= 43274 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43488
                  ? c == 43471
                  : c <= 43492)))
              : (c <= 43503 || (c < 43588
                ? (c < 43520
                  ? (c >= 43514 && c <= 43518)
                  : (c <= 43560 || (c >= 43584 && c <= 43586)))
                : (c <= 43595 || (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : c <= 43642)))))
            : (c <= 43695 || (c < 43744
              ? (c < 43712
                ? (c < 43701
                  ? c == 43697
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))
                : (c <= 43712 || (c < 43739
                  ? c == 43714
                  : c <= 43741)))
              : (c <= 43754 || (c < 43785
                ? (c < 43777
                  ? (c >= 43762 && c <= 43764)
                  : c <= 43782)
                : (c <= 43790 || (c < 43808
                  ? (c >= 43793 && c <= 43798)
                  : c <= 43814)))))))
          : (c <= 43822 || (c < 64298
            ? (c < 55243
              ? (c < 44032
                ? (c < 43868
                  ? (c >= 43824 && c <= 43866)
                  : (c <= 43881 || (c >= 43888 && c <= 44002)))
                : (c <= 44032 || (c < 55216
                  ? c == 55203
                  : c <= 55238)))
              : (c <= 55291 || (c < 64275
                ? (c < 64112
                  ? (c >= 63744 && c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))
                : (c <= 64279 || (c < 64287
                  ? c == 64285
                  : c <= 64296)))))
            : (c <= 64310 || (c < 64848
              ? (c < 64323
                ? (c < 64318
                  ? (c >= 64312 && c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : c <= 64829)))
              : (c <= 64911 || (c < 65136
                ? (c < 65008
                  ? (c >= 64914 && c <= 64967)
                  : c <= 65019)
                : (c <= 65140 || (c < 65313
                  ? (c >= 65142 && c <= 65276)
                  : c <= 65338)))))))))
        : (c <= 65370 || (c < 66864
          ? (c < 66176
            ? (c < 65549
              ? (c < 65490
                ? (c < 65474
                  ? (c >= 65382 && c <= 65470)
                  : (c <= 65479 || (c >= 65482 && c <= 65487)))
                : (c <= 65495 || (c < 65536
                  ? (c >= 65498 && c <= 65500)
                  : c <= 65547)))
              : (c <= 65574 || (c < 65616
                ? (c < 65596
                  ? (c >= 65576 && c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))
                : (c <= 65629 || (c < 65856
                  ? (c >= 65664 && c <= 65786)
                  : c <= 65908)))))
            : (c <= 66204 || (c < 66504
              ? (c < 66384
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66378)))
                : (c <= 66421 || (c < 66464
                  ? (c >= 66432 && c <= 66461)
                  : c <= 66499)))
              : (c <= 66511 || (c < 66736
                ? (c < 66560
                  ? (c >= 66513 && c <= 66517)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_4(int32_t c) {
  return (c < 6823
    ? (c < 2990
      ? (c < 2384
        ? (c < 1519
          ? (c < 886
            ? (c < 192
              ? (c < 170
                ? (c < '_'
                  ? (c >= 'A' && c <= 'Z')
                  : (c <= '_' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 748
                ? (c < 710
                  ? (c >= 216 && c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))
                : (c <= 748 || (c < 880
                  ? c == 750
                  : c <= 884)))))
            : (c <= 887 || (c < 931
              ? (c < 904
                ? (c < 895
                  ? (c >= 890 && c <= 893)
                  : (c <= 895 || c == 902))
                : (c <= 906 || (c < 910
                  ? c == 908
                  : c <= 929)))
              : (c <= 1013 || (c < 1369
                ? (c < 1162
                  ? (c >= 1015 && c <= 1153)
                  : (c <= 1327 || (c >= 1329 && c <= 1366)))
                : (c <= 1369 || (c < 1488
                  ? (c >= 1376 && c <= 1416)
                  : c <= 1514)))))))
          : (c <= 1522 || (c < 2036
            ? (c < 1786
              ? (c < 1749
                ? (c < 1646
                  ? (c >= 1568 && c <= 1610)
                  : (c <= 1647 || (c >= 1649 && c <= 1747)))
                : (c <= 1749 || (c < 1774
                  ? (c >= 1765 && c <= 1766)
                  : c <= 1775)))
              : (c <= 1788 || (c < 1869
                ? (c < 1808
                  ? c == 1791
                  : (c <= 1808 || (c >= 1810 && c <= 1839)))
                : (c <= 1957 || (c < 1994
                  ? c == 1969
                  : c <= 2026)))))
            : (c <= 2037 || (c < 2144
              ? (c < 2084
                ? (c < 2048
                  ? c == 2042
                  : (c <= 2069 || c == 2074))
                : (c <= 2084 || (c < 2112
                  ? c == 2088
                  : c <= 2136)))
              : (c <= 2154 || (c < 2208
                ? (c < 2185
                  ? (c >= 2160 && c <= 2183)
                  : c <= 2190)
                : (c <= 2249 || (c < 2365
                  ? (c >= 2308 && c <= 2361)
                  : c <= 2365)))))))))
        : (c <= 2384 || (c < 2707
          ? (c < 2556
            ? (c < 2482
              ? (c < 2447
                ? (c < 2417
                  ? (c >= 2392 && c <= 2401)
                  : (c <= 2432 || (c >= 2437 && c <= 2444)))
                : (c <= 2448 || (c < 2474
                  ? (c >= 2451 && c <= 2472)
                  : c <= 2480)))
              : (c <= 2482 || (c < 2524
                ? (c < 2493
                  ? (c >= 2486 && c <= 2489)
                  : (c <= 2493 || c == 2510))
                : (c <= 2525 || (c < 2544
                  ? (c >= 2527 && c <= 2529)
                  : c <= 2545)))))
            : (c <= 2556 || (c < 2616
              ? (c < 2602
                ? (c < 2575
                  ? (c >= 2565 && c <= 2570)
                  : (c <= 2576 || (c >= 2579 && c <= 2600)))
                : (c <= 2608 || (c < 2613
                  ? (c >= 2610 && c <= 2611)
                  : c <= 2614)))
              : (c <= 2617 || (c < 2674
                ? (c < 2654
                  ? (c >= 2649 && c <= 2652)
                  : c <= 2654)
                : (c <= 2676 || (c < 2703
                  ? (c >= 2693 && c <= 2701)
                  : c <= 2705)))))))
          : (c <= 2728 || (c < 2877
            ? (c < 2809
              ? (c < 2749
                ? (c < 2738
                  ? (c >= 2730 && c <= 2736)
                  : (c <= 2739 || (c >= 2741 && c <= 2745)))
                : (c <= 2749 || (c < 2784
                  ? c == 2768
                  : c <= 2785)))
              : (c <= 2809 || (c < 2858
                ? (c < 2831
                  ? (c >= 2821 && c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))
                : (c <= 2864 || (c < 2869
                  ? (c >= 2866 && c <= 2867)
                  : c <= 2873)))))
            : (c <= 2877 || (c < 2962
              ? (c < 2947
                ? (c < 2911
                  ? (c >= 2908 && c <= 2909)
                  : (c <= 2913 || c == 2929))
                : (c <= 2947 || (c < 2958
                  ? (c >= 2949 && c <= 2954)
                  : c <= 2960)))
              : (c <= 2965 || (c < 2974
                ? (c < 2972
                  ? (c >= 2969 && c <= 2970)
                  : c <= 2972)
                : (c <= 2975 || (c < 2984
                  ? (c >= 2979 && c <= 2980)
                  : c <= 2986)))))))))))
      : (c <= 3001 || (c < 4186
        ? (c < 3450
          ? (c < 3242
            ? (c < 3160
              ? (c < 3090
                ? (c < 3077
                  ? c == 3024
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))
                : (c <= 3112 || (c < 3133
                  ? (c >= 3114 && c <= 3129)
                  : c <= 3133)))
              : (c <= 3162 || (c < 3205
                ? (c < 3168
                  ? c == 3165
                  : (c <= 3169 || c == 3200))
                : (c <= 3212 || (c < 3218
                  ? (c >= 3214 && c <= 3216)
                  : c <= 3240)))))
            : (c <= 3251 || (c < 3342
              ? (c < 3296
                ? (c < 3261
                  ? (c >= 3253 && c <= 3257)
                  : (c <= 3261 || (c >= 3293 && c <= 3294)))
                : (c <= 3297 || (c < 3332
                  ? (c >= 3313 && c <= 3314)
                  : c <= 3340)))
              : (c <= 3344 || (c < 3406
                ? (c < 3389
                  ? (c >= 3346 && c <= 3386)
                  : c <= 3389)
                : (c <= 3406 || (c < 3423
                  ? (c >= 3412 && c <= 3414)
                  : c <= 3425)))))))
          : (c <= 3455 || (c < 3751
            ? (c < 3634
              ? (c < 3517
                ? (c < 3482
                  ? (c >= 3461 && c <= 3478)
                  : (c <= 3505 || (c >= 3507 && c <= 3515)))
                : (c <= 3517 || (c < 3585
                  ? (c >= 3520 && c <= 3526)
                  : c <= 3632)))
              : (c <= 3635 || (c < 3718
                ? (c < 3713
                  ? (c >= 3648 && c <= 3654)
                  : (c <= 3714 || c == 3716))
                : (c <= 3722 || (c < 3749
                  ? (c >= 3724 && c <= 3747)
                  : c <= 3749)))))
            : (c <= 3760 || (c < 3904
              ? (c < 3782
                ? (c < 3773
                  ? (c >= 3762 && c <= 3763)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))
                : (c <= 3782 || (c < 3840
                  ? (c >= 3804 && c <= 3807)
                  : c <= 3840)))
              : (c <= 3911 || (c < 4096
                ? (c < 3976
                  ? (c >= 3913 && c <= 3948)
                  : c <= 3980)
                : (c <= 4138 || (c < 4176
                  ? c == 4159
                  : c <= 4181)))))))))
        : (c <= 4189 || (c < 5024
          ? (c < 4698
            ? (c < 4295
              ? (c < 4213
                ? (c < 4197
                  ? c == 4193
                  : (c <= 4198 || (c >= 4206 && c <= 4208)))
                : (c <= 4225 || (c < 4256
                  ? c == 4238
                  : c <= 4293)))
              : (c <= 4295 || (c < 4682
                ? (c < 4304
                  ? c == 4301
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))
                : (c <= 4685 || (c < 4696
                  ? (c >= 4688 && c <= 4694)
                  : c <= 4696)))))
            : (c <= 4701 || (c < 4802
              ? (c < 4786
                ? (c < 4746
                  ? (c >= 4704 && c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))
                : (c <= 4789 || (c < 4800
                  ? (c >= 4792 && c <= 4798)
                  : c <= 4800)))
              : (c <= 4805 || (c < 4882
                ? (c < 4824
                  ? (c >= 4808 && c <= 4822)
                  : c <= 4880)
                : (c <= 4885 || (c < 4992
                  ? (c >= 4888 && c <= 4954)
                  : c <= 5007)))))))
          : (c <= 5109 || (c < 6108
            ? (c < 5888
              ? (c < 5761
                ? (c < 5121
                  ? (c >= 5112 && c <= 5117)
                  : (c <= 5740 || (c >= 5743 && c <= 5759)))
                : (c <= 5786 || (c < 5870
                  ? (c >= 5792 && c <= 5866)
                  : c <= 5880)))
              : (c <= 5905 || (c < 5998
                ? (c < 5952
                  ? (c >= 5919 && c <= 5937)
                  : (c <= 5969 || (c >= 5984 && c <= 5996)))
                : (c <= 6000 || (c < 6103
                  ? (c >= 6016 && c <= 6067)
                  : c <= 6103)))))
            : (c <= 6108 || (c < 6480
              ? (c < 6314
                ? (c < 6272
                  ? (c >= 6176 && c <= 6264)
                  : (c <= 6276 || (c >= 6279 && c <= 6312)))
                : (c <= 6314 || (c < 6400
                  ? (c >= 6320 && c <= 6389)
                  : c <= 6430)))
              : (c <= 6509 || (c < 6576
                ? (c < 6528
                  ? (c >= 6512 && c <= 6516)
                  : c <= 6571)
                : (c <= 6601 || (c < 6688
                  ? (c >= 6656 && c <= 6678)
                  : c <= 6740)))))))))))))
    : (c <= 6823 || (c < 43261
      ? (c < 11499
        ? (c < 8126
          ? (c < 7413
            ? (c < 7245
              ? (c < 7086
                ? (c < 6981
                  ? (c >= 6917 && c <= 6963)
                  : (c <= 6988 || (c >= 7043 && c <= 7072)))
                : (c <= 7087 || (c < 7168
                  ? (c >= 7098 && c <= 7141)
                  : c <= 7203)))
              : (c <= 7247 || (c < 7357
                ? (c < 7296
                  ? (c >= 7258 && c <= 7293)
                  : (c <= 7304 || (c >= 7312 && c <= 7354)))
                : (c <= 7359 || (c < 7406
                  ? (c >= 7401 && c <= 7404)
                  : c <= 7411)))))
            : (c <= 7414 || (c < 8016
              ? (c < 7960
                ? (c < 7424
                  ? c == 7418
                  : (c <= 7615 || (c >= 7680 && c <= 7957)))
                : (c <= 7965 || (c < 8008
                  ? (c >= 7968 && c <= 8005)
                  : c <= 8013)))
              : (c <= 8023 || (c < 8031
                ? (c < 8027
                  ? c == 8025
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : c <= 8124)))))))
          : (c <= 8126 || (c < 8469
            ? (c < 8182
              ? (c < 8150
                ? (c < 8134
                  ? (c >= 8130 && c <= 8132)
                  : (c <= 8140 || (c >= 8144 && c <= 8147)))
                : (c <= 8155 || (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : c <= 8180)))
              : (c <= 8188 || (c < 8450
                ? (c < 8319
                  ? c == 8305
                  : (c <= 8319 || (c >= 8336 && c <= 8348)))
                : (c <= 8450 || (c < 8458
                  ? c == 8455
                  : c <= 8467)))))
            : (c <= 8469 || (c < 8508
              ? (c < 8488
                ? (c < 8484
                  ? (c >= 8473 && c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)))
              : (c <= 8511 || (c < 8544
                ? (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)
                : (c <= 8584 || (c < 11264
                  ? c == 8711
                  : c <= 11492)))))))))
        : (c <= 11502 || (c < 12704
          ? (c < 11728
            ? (c < 11648
              ? (c < 11565
                ? (c < 11520
                  ? (c >= 11506 && c <= 11507)
                  : (c <= 11557 || c == 11559))
                : (c <= 11565 || (c < 11631
                  ? (c >= 11568 && c <= 11623)
                  : c <= 11631)))
              : (c <= 11670 || (c < 11704
                ? (c < 11688
                  ? (c >= 11680 && c <= 11686)
                  : (c <= 11694 || (c >= 11696 && c <= 11702)))
                : (c <= 11710 || (c < 11720
                  ? (c >= 11712 && c <= 11718)
                  : c <= 11726)))))
            : (c <= 11734 || (c < 12353
              ? (c < 12321
                ? (c < 11823
                  ? (c >= 11736 && c <= 11742)
                  : (c <= 11823 || (c >= 12293 && c <= 12295)))
                : (c <= 12329 || (c < 12344
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)))
              : (c <= 12438 || (c < 12540
                ? (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : c <= 12538)
                : (c <= 12543 || (c < 12593
                  ? (c >= 12549 && c <= 12591)
                  : c <= 12686)))))))
          : (c <= 12735 || (c < 42786
            ? (c < 42240
              ? (c < 19968
                ? (c < 13312
                  ? (c >= 12784 && c <= 12799)
                  : (c <= 13312 || c == 19903))
                : (c <= 19968 || (c < 42192
                  ? (c >= 40959 && c <= 42124)
                  : c <= 42237)))
              : (c <= 42508 || (c < 42623
                ? (c < 42538
                  ? (c >= 42512 && c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42775
                  ? (c >= 42656 && c <= 42735)
                  : c <= 42783)))))
            : (c <= 42888 || (c < 43015
              ? (c < 42965
                ? (c < 42960
                  ? (c >= 42891 && c <= 42954)
                  : (c <= 42961 || c == 42963))
                : (c <= 42969 || (c < 43011
                  ? (c >= 42994 && c <= 43009)
                  : c <= 43013)))
              : (c <= 43018 || (c < 43138
                ? (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)
                : (c <= 43187 || (c < 43259
                  ? (c >= 43250 && c <= 43255)
                  : c <= 43259)))))))))))
      : (c <= 43262 || (c < 65345
        ? (c < 43816
          ? (c < 43646
            ? (c < 43494
              ? (c < 43396
                ? (c < 43312
                  ? (c >= 43274 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43488
                  ? c == 43471
                  : c <= 43492)))
              : (c <= 43503 || (c < 43588
                ? (c < 43520
                  ? (c >= 43514 && c <= 43518)
                  : (c <= 43560 || (c >= 43584 && c <= 43586)))
                : (c <= 43595 || (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : c <= 43642)))))
            : (c <= 43695 || (c < 43744
              ? (c < 43712
                ? (c < 43701
                  ? c == 43697
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))
                : (c <= 43712 || (c < 43739
                  ? c == 43714
                  : c <= 43741)))
              : (c <= 43754 || (c < 43785
                ? (c < 43777
                  ? (c >= 43762 && c <= 43764)
                  : c <= 43782)
                : (c <= 43790 || (c < 43808
                  ? (c >= 43793 && c <= 43798)
                  : c <= 43814)))))))
          : (c <= 43822 || (c < 64298
            ? (c < 55243
              ? (c < 44032
                ? (c < 43868
                  ? (c >= 43824 && c <= 43866)
                  : (c <= 43881 || (c >= 43888 && c <= 44002)))
                : (c <= 44032 || (c < 55216
                  ? c == 55203
                  : c <= 55238)))
              : (c <= 55291 || (c < 64275
                ? (c < 64112
                  ? (c >= 63744 && c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))
                : (c <= 64279 || (c < 64287
                  ? c == 64285
                  : c <= 64296)))))
            : (c <= 64310 || (c < 64848
              ? (c < 64323
                ? (c < 64318
                  ? (c >= 64312 && c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : c <= 64829)))
              : (c <= 64911 || (c < 65136
                ? (c < 65008
                  ? (c >= 64914 && c <= 64967)
                  : c <= 65019)
                : (c <= 65140 || (c < 65313
                  ? (c >= 65142 && c <= 65276)
                  : c <= 65338)))))))))
        : (c <= 65370 || (c < 66864
          ? (c < 66176
            ? (c < 65549
              ? (c < 65490
                ? (c < 65474
                  ? (c >= 65382 && c <= 65470)
                  : (c <= 65479 || (c >= 65482 && c <= 65487)))
                : (c <= 65495 || (c < 65536
                  ? (c >= 65498 && c <= 65500)
                  : c <= 65547)))
              : (c <= 65574 || (c < 65616
                ? (c < 65596
                  ? (c >= 65576 && c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))
                : (c <= 65629 || (c < 65856
                  ? (c >= 65664 && c <= 65786)
                  : c <= 65908)))))
            : (c <= 66204 || (c < 66504
              ? (c < 66384
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66378)))
                : (c <= 66421 || (c < 66464
                  ? (c >= 66432 && c <= 66461)
                  : c <= 66499)))
              : (c <= 66511 || (c < 66736
                ? (c < 66560
                  ? (c >= 66513 && c <= 66517)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_5(int32_t c) {
  return (c < 8768
    ? (c < 8617
      ? (c < 177
        ? (c < '$'
          ? (c < '\r'
            ? (c < '\t'
              ? c == 0
              : c <= '\n')
            : (c <= '\r' || (c < '"'
              ? c == ' '
              : c <= '"')))
          : (c <= '/' || (c < '`'
            ? (c < '['
              ? (c >= ':' && c <= '>')
              : c <= '^')
            : (c <= '`' || (c >= '{' && c <= '}')))))
        : (c <= 177 || (c < 8592
          ? (c < 8230
            ? (c < 247
              ? c == 215
              : c <= 247)
            : (c <= 8230 || (c < 8523
              ? c == 8285
              : c <= 8523)))
          : (c <= 8596 || (c < 8610
            ? (c < 8608
              ? (c >= 8602 && c <= 8606)
              : c <= 8608)
            : (c <= 8612 || c == 8614))))))
      : (c <= 8620 || (c < 8672
        ? (c < 8649
          ? (c < 8640
            ? (c < 8636
              ? c == 8622
              : c <= 8637)
            : (c <= 8641 || (c < 8646
              ? c == 8644
              : c <= 8647)))
          : (c <= 8649 || (c < 8660
            ? (c < 8658
              ? (c >= 8651 && c <= 8656)
              : c <= 8658)
            : (c <= 8660 || (c >= 8666 && c <= 8669)))))
        : (c <= 8672 || (c < 8733
          ? (c < 8712
            ? (c < 8692
              ? c == 8674
              : c <= 8703)
            : (c <= 8717 || (c < 8727
              ? (c >= 8723 && c <= 8724)
              : c <= 8729)))
          : (c <= 8733 || (c < 8762
            ? (c < 8759
              ? (c >= 8740 && c <= 8746)
              : c <= 8760)
            : (c <= 8763 || (c >= 8765 && c <= 8766)))))))))
    : (c <= 8843 || (c < 10679
      ? (c < 9655
        ? (c < 8880
          ? (c < 8873
            ? (c < 8862
              ? (c >= 8845 && c <= 8860)
              : c <= 8867)
            : (c <= 8873 || (c < 8878
              ? c == 8876
              : c <= 8878)))
          : (c <= 8887 || (c < 8905
            ? (c < 8900
              ? (c >= 8891 && c <= 8893)
              : c <= 8903)
            : (c <= 8915 || (c >= 8917 && c <= 8959)))))
        : (c <= 9655 || (c < 10229
          ? (c < 10193
            ? (c < 10184
              ? c == 10178
              : c <= 10185)
            : (c <= 10194 || (c < 10224
              ? (c >= 10197 && c <= 10199)
              : c <= 10225)))
          : (c <= 10231 || (c < 10525
            ? (c < 10496
              ? (c >= 10233 && c <= 10239)
              : c <= 10520)
            : (c <= 10528 || (c >= 10564 && c <= 10608)))))))
      : (c <= 10680 || (c < 10800
        ? (c < 10742
          ? (c < 10721
            ? (c < 10686
              ? c == 10684
              : c <= 10689)
            : (c <= 10721 || (c < 10740
              ? (c >= 10723 && c <= 10725)
              : c <= 10740)))
          : (c <= 10743 || (c < 10781
            ? (c < 10759
              ? (c >= 10746 && c <= 10747)
              : c <= 10760)
            : (c <= 10781 || (c >= 10786 && c <= 10798)))))
        : (c <= 10813 || (c < 10971
          ? (c < 10842
            ? (c < 10826
              ? (c >= 10816 && c <= 10821)
              : c <= 10840)
            : (c <= 10851 || (c < 10858
              ? (c >= 10854 && c <= 10855)
              : c <= 10969)))
          : (c <= 10971 || (c < 11079
            ? (c < 11056
              ? (c >= 10999 && c <= 11002)
              : c <= 11076)
            : (c <= 11084 || (c >= 65513 && c <= 65516)))))))))));
}

static inline bool sym_escape_sequence_character_set_1(int32_t c) {
  return (c < '`'
    ? (c < '\''
      ? (c < '$'
        ? c == '"'
        : c <= '$')
      : (c <= '\'' || c == '\\'))
    : (c <= 'b' || (c < 'r'
      ? (c < 'n'
        ? c == 'f'
        : c <= 'n')
      : (c <= 'r' || (c >= 't' && c <= 'v')))));
}

static inline bool aux_sym_character_literal_token1_character_set_1(int32_t c) {
  return (c < 10197
    ? (c < 8845
      ? (c < 8727
        ? (c < 215
          ? (c < '*'
            ? c == '%'
            : c <= '*')
          : (c <= 215 || (c < 8523
            ? c == 247
            : c <= 8523)))
        : (c <= 8729 || (c < 8745
          ? (c < 8743
            ? c == 8740
            : c <= 8743)
          : (c <= 8745 || c == 8768))))
      : (c <= 8845 || (c < 8905
        ? (c < 8864
          ? (c < 8855
            ? c == 8851
            : c <= 8859)
          : (c <= 8865 || (c < 8900
            ? c == 8892
            : c <= 8903)))
        : (c <= 8908 || (c < 9655
          ? (c < 8914
            ? c == 8911
            : c <= 8914)
          : (c <= 9655 || c == 10193))))))
    : (c <= 10199 || (c < 10827
      ? (c < 10781
        ? (c < 10686
          ? (c < 10684
            ? c == 10680
            : c <= 10684)
          : (c <= 10687 || (c < 10759
            ? (c >= 10742 && c <= 10743)
            : c <= 10759)))
        : (c <= 10781 || (c < 10816
          ? (c < 10811
            ? (c >= 10800 && c <= 10808)
            : c <= 10813)
          : (c <= 10816 || (c >= 10819 && c <= 10820)))))
      : (c <= 10827 || (c < 10840
        ? (c < 10835
          ? (c < 10833
            ? (c >= 10829 && c <= 10830)
            : c <= 10833)
          : (c <= 10835 || c == 10837))
        : (c <= 10840 || (c < 10846
          ? (c < 10844
            ? c == 10842
            : c <= 10844)
          : (c <= 10848 || c == 10971))))))));
}

static inline bool sym__power_operator_character_set_1(int32_t c) {
  return (c < 10577
    ? (c < 10504
      ? (c < 8595
        ? (c < 8593
          ? c == '^'
          : c <= 8593)
        : (c <= 8595 || (c < 10224
          ? c == 8693
          : c <= 10225)))
      : (c <= 10507 || (c < 10572
        ? (c < 10569
          ? (c >= 10514 && c <= 10515)
          : c <= 10569)
        : (c <= 10573 || c == 10575))))
    : (c <= 10577 || (c < 10595
      ? (c < 10588
        ? (c < 10584
          ? (c >= 10580 && c <= 10581)
          : c <= 10585)
        : (c <= 10589 || (c >= 10592 && c <= 10593)))
      : (c <= 10595 || (c < 65514
        ? (c < 10606
          ? c == 10597
          : c <= 10607)
        : (c <= 65514 || c == 65516))))));
}

static inline bool sym__times_operator_character_set_1(int32_t c) {
  return (c < 9655
    ? (c < 8851
      ? (c < 8740
        ? (c < 8523
          ? c == 215
          : (c <= 8523 || (c >= 8727 && c <= 8729)))
        : (c <= 8740 || (c < 8768
          ? (c >= 8743 && c <= 8745)
          : (c <= 8768 || c == 8845))))
      : (c <= 8859 || (c < 8905
        ? (c < 8892
          ? (c >= 8864 && c <= 8865)
          : (c <= 8892 || (c >= 8900 && c <= 8903)))
        : (c <= 8908 || (c < 8914
          ? c == 8911
          : c <= 8914)))))
    : (c <= 9655 || (c < 10759
      ? (c < 10684
        ? (c < 10197
          ? c == 10193
          : (c <= 10199 || c == 10680))
        : (c <= 10684 || (c < 10742
          ? (c >= 10686 && c <= 10687)
          : c <= 10743)))
      : (c <= 10759 || (c < 10827
        ? (c < 10800
          ? c == 10781
          : (c <= 10813 || (c >= 10816 && c <= 10820)))
        : (c <= 10840 || (c < 10971
          ? (c >= 10842 && c <= 10848)
          : c <= 10971)))))));
}

static inline bool sym__times_operator_character_set_2(int32_t c) {
  return (c < 10193
    ? (c < 8768
      ? (c < 8523
        ? (c < '\\'
          ? (c < '*'
            ? c == '%'
            : c <= '*')
          : (c <= '\\' || (c < 247
            ? c == 215
            : c <= 247)))
        : (c <= 8523 || (c < 8743
          ? (c < 8740
            ? (c >= 8727 && c <= 8729)
            : c <= 8740)
          : (c <= 8743 || c == 8745))))
      : (c <= 8768 || (c < 8900
        ? (c < 8855
          ? (c < 8851
            ? c == 8845
            : c <= 8851)
          : (c <= 8859 || (c < 8892
            ? (c >= 8864 && c <= 8865)
            : c <= 8892)))
        : (c <= 8903 || (c < 8914
          ? (c < 8911
            ? (c >= 8905 && c <= 8908)
            : c <= 8911)
          : (c <= 8914 || c == 9655))))))
    : (c <= 10193 || (c < 10819
      ? (c < 10759
        ? (c < 10684
          ? (c < 10680
            ? (c >= 10197 && c <= 10199)
            : c <= 10680)
          : (c <= 10684 || (c < 10742
            ? (c >= 10686 && c <= 10687)
            : c <= 10743)))
        : (c <= 10759 || (c < 10811
          ? (c < 10800
            ? c == 10781
            : c <= 10808)
          : (c <= 10813 || c == 10816))))
      : (c <= 10820 || (c < 10840
        ? (c < 10833
          ? (c < 10829
            ? c == 10827
            : c <= 10830)
          : (c <= 10833 || (c < 10837
            ? c == 10835
            : c <= 10837)))
        : (c <= 10840 || (c < 10846
          ? (c < 10844
            ? c == 10842
            : c <= 10844)
          : (c <= 10848 || c == 10971))))))));
}

static inline bool sym__times_operator_character_set_3(int32_t c) {
  return (c < 10193
    ? (c < 8768
      ? (c < 8523
        ? (c < '\\'
          ? (c < '*'
            ? (c >= '%' && c <= '&')
            : c <= '*')
          : (c <= '\\' || (c < 247
            ? c == 215
            : c <= 247)))
        : (c <= 8523 || (c < 8743
          ? (c < 8740
            ? (c >= 8727 && c <= 8729)
            : c <= 8740)
          : (c <= 8743 || c == 8745))))
      : (c <= 8768 || (c < 8900
        ? (c < 8855
          ? (c < 8851
            ? c == 8845
            : c <= 8851)
          : (c <= 8859 || (c < 8892
            ? (c >= 8864 && c <= 8865)
            : c <= 8892)))
        : (c <= 8903 || (c < 8914
          ? (c < 8911
            ? (c >= 8905 && c <= 8908)
            : c <= 8911)
          : (c <= 8914 || c == 9655))))))
    : (c <= 10193 || (c < 10819
      ? (c < 10759
        ? (c < 10684
          ? (c < 10680
            ? (c >= 10197 && c <= 10199)
            : c <= 10680)
          : (c <= 10684 || (c < 10742
            ? (c >= 10686 && c <= 10687)
            : c <= 10743)))
        : (c <= 10759 || (c < 10811
          ? (c < 10800
            ? c == 10781
            : c <= 10808)
          : (c <= 10813 || c == 10816))))
      : (c <= 10820 || (c < 10840
        ? (c < 10833
          ? (c < 10829
            ? c == 10827
            : c <= 10830)
          : (c <= 10833 || (c < 10837
            ? c == 10835
            : c <= 10837)))
        : (c <= 10840 || (c < 10846
          ? (c < 10844
            ? c == 10842
            : c <= 10844)
          : (c <= 10848 || c == 10971))))))));
}

static inline bool sym__times_operator_character_set_4(int32_t c) {
  return (c < 8911
    ? (c < 8743
      ? (c < 247
        ? (c < '\\'
          ? (c < '*'
            ? (c >= '%' && c <= '&')
            : c <= '*')
          : (c <= '\\' || c == 215))
        : (c <= 247 || (c < 8727
          ? c == 8523
          : (c <= 8729 || c == 8740))))
      : (c <= 8745 || (c < 8864
        ? (c < 8845
          ? c == 8768
          : (c <= 8845 || (c >= 8851 && c <= 8859)))
        : (c <= 8865 || (c < 8900
          ? c == 8892
          : (c <= 8903 || (c >= 8905 && c <= 8908)))))))
    : (c <= 8911 || (c < 10742
      ? (c < 10197
        ? (c < 9655
          ? c == 8914
          : (c <= 9655 || c == 10193))
        : (c <= 10199 || (c < 10684
          ? c == 10680
          : (c <= 10684 || (c >= 10686 && c <= 10687)))))
      : (c <= 10743 || (c < 10816
        ? (c < 10781
          ? c == 10759
          : (c <= 10781 || (c >= 10800 && c <= 10813)))
        : (c <= 10820 || (c < 10842
          ? (c >= 10827 && c <= 10840)
          : (c <= 10848 || c == 10971))))))));
}

static inline bool sym__times_operator_character_set_5(int32_t c) {
  return (c < 8911
    ? (c < 8743
      ? (c < 247
        ? (c < '\\'
          ? (c < '*'
            ? c == '%'
            : c <= '*')
          : (c <= '\\' || c == 215))
        : (c <= 247 || (c < 8727
          ? c == 8523
          : (c <= 8729 || c == 8740))))
      : (c <= 8745 || (c < 8864
        ? (c < 8845
          ? c == 8768
          : (c <= 8845 || (c >= 8851 && c <= 8859)))
        : (c <= 8865 || (c < 8900
          ? c == 8892
          : (c <= 8903 || (c >= 8905 && c <= 8908)))))))
    : (c <= 8911 || (c < 10742
      ? (c < 10197
        ? (c < 9655
          ? c == 8914
          : (c <= 9655 || c == 10193))
        : (c <= 10199 || (c < 10684
          ? c == 10680
          : (c <= 10684 || (c >= 10686 && c <= 10687)))))
      : (c <= 10743 || (c < 10816
        ? (c < 10781
          ? c == 10759
          : (c <= 10781 || (c >= 10800 && c <= 10813)))
        : (c <= 10820 || (c < 10842
          ? (c >= 10827 && c <= 10840)
          : (c <= 10848 || c == 10971))))))));
}

static inline bool sym__plus_operator_character_set_1(int32_t c) {
  return (c < 10760
    ? (c < 8846
      ? (c < 8746
        ? (c < 8723
          ? c == 177
          : (c <= 8724 || c == 8744))
        : (c <= 8746 || (c < 8783
          ? c == 8760
          : c <= 8783)))
      : (c <= 8846 || (c < 8910
        ? (c < 8862
          ? (c >= 8852 && c <= 8854)
          : (c <= 8863 || c == 8893))
        : (c <= 8910 || (c < 10746
          ? c == 8915
          : c <= 10747)))))
    : (c <= 10760 || (c < 10831
      ? (c < 10821
        ? (c < 10809
          ? (c >= 10786 && c <= 10798)
          : (c <= 10810 || (c >= 10817 && c <= 10818)))
        : (c <= 10821 || (c < 10828
          ? c == 10826
          : c <= 10828)))
      : (c <= 10832 || (c < 10843
        ? (c < 10836
          ? c == 10834
          : (c <= 10836 || (c >= 10838 && c <= 10839)))
        : (c <= 10843 || (c < 10849
          ? c == 10845
          : c <= 10851)))))));
}

static inline bool sym__plus_operator_character_set_2(int32_t c) {
  return (c < 8910
    ? (c < 8783
      ? (c < 8744
        ? (c < 8723
          ? c == 177
          : c <= 8724)
        : (c <= 8746 || c == 8760))
      : (c <= 8783 || (c < 8862
        ? (c < 8852
          ? c == 8846
          : c <= 8854)
        : (c <= 8863 || (c >= 8891 && c <= 8893)))))
    : (c <= 8910 || (c < 10809
      ? (c < 10760
        ? (c < 10746
          ? c == 8915
          : c <= 10747)
        : (c <= 10760 || (c >= 10786 && c <= 10798)))
      : (c <= 10810 || (c < 10826
        ? (c >= 10817 && c <= 10821)
        : (c <= 10839 || (c >= 10843 && c <= 10851)))))));
}

static inline bool sym__plus_operator_character_set_3(int32_t c) {
  return (c < 8891
    ? (c < 8760
      ? (c < 8723
        ? (c < 177
          ? c == '|'
          : c <= 177)
        : (c <= 8724 || (c >= 8744 && c <= 8746)))
      : (c <= 8760 || (c < 8852
        ? (c < 8846
          ? c == 8783
          : c <= 8846)
        : (c <= 8854 || (c >= 8862 && c <= 8863)))))
    : (c <= 8893 || (c < 10786
      ? (c < 10746
        ? (c < 8915
          ? c == 8910
          : c <= 8915)
        : (c <= 10747 || c == 10760))
      : (c <= 10798 || (c < 10826
        ? (c < 10817
          ? (c >= 10809 && c <= 10810)
          : c <= 10821)
        : (c <= 10839 || (c >= 10843 && c <= 10851)))))));
}

static inline bool sym__plus_operator_character_set_4(int32_t c) {
  return (c < 10746
    ? (c < 8783
      ? (c < 8723
        ? (c < '|'
          ? c == '$'
          : (c <= '|' || c == 177))
        : (c <= 8724 || (c < 8746
          ? c == 8744
          : (c <= 8746 || c == 8760))))
      : (c <= 8783 || (c < 8891
        ? (c < 8852
          ? c == 8846
          : (c <= 8854 || (c >= 8862 && c <= 8863)))
        : (c <= 8891 || (c < 8910
          ? c == 8893
          : (c <= 8910 || c == 8915))))))
    : (c <= 10747 || (c < 10831
      ? (c < 10817
        ? (c < 10786
          ? c == 10760
          : (c <= 10798 || (c >= 10809 && c <= 10810)))
        : (c <= 10818 || (c < 10826
          ? c == 10821
          : (c <= 10826 || c == 10828))))
      : (c <= 10832 || (c < 10843
        ? (c < 10836
          ? c == 10834
          : (c <= 10836 || (c >= 10838 && c <= 10839)))
        : (c <= 10843 || (c < 10849
          ? c == 10845
          : c <= 10851)))))));
}

static inline bool sym__plus_operator_character_set_5(int32_t c) {
  return (c < 10746
    ? (c < 8846
      ? (c < 8744
        ? (c < 177
          ? c == '$'
          : (c <= 177 || (c >= 8723 && c <= 8724)))
        : (c <= 8744 || (c < 8760
          ? c == 8746
          : (c <= 8760 || c == 8783))))
      : (c <= 8846 || (c < 8893
        ? (c < 8862
          ? (c >= 8852 && c <= 8854)
          : (c <= 8863 || c == 8891))
        : (c <= 8893 || (c < 8915
          ? c == 8910
          : c <= 8915)))))
    : (c <= 10747 || (c < 10831
      ? (c < 10817
        ? (c < 10786
          ? c == 10760
          : (c <= 10798 || (c >= 10809 && c <= 10810)))
        : (c <= 10818 || (c < 10826
          ? c == 10821
          : (c <= 10826 || c == 10828))))
      : (c <= 10832 || (c < 10843
        ? (c < 10836
          ? c == 10834
          : (c <= 10836 || (c >= 10838 && c <= 10839)))
        : (c <= 10843 || (c < 10849
          ? c == 10845
          : c <= 10851)))))));
}

static inline bool sym__plus_operator_character_set_6(int32_t c) {
  return (c < 8891
    ? (c < 8760
      ? (c < 177
        ? (c < '|'
          ? c == '-'
          : c <= '|')
        : (c <= 177 || (c < 8744
          ? (c >= 8723 && c <= 8724)
          : c <= 8746)))
      : (c <= 8760 || (c < 8852
        ? (c < 8846
          ? c == 8783
          : c <= 8846)
        : (c <= 8854 || (c >= 8862 && c <= 8863)))))
    : (c <= 8893 || (c < 10786
      ? (c < 10746
        ? (c < 8915
          ? c == 8910
          : c <= 8915)
        : (c <= 10747 || c == 10760))
      : (c <= 10798 || (c < 10826
        ? (c < 10817
          ? (c >= 10809 && c <= 10810)
          : c <= 10821)
        : (c <= 10839 || (c >= 10843 && c <= 10851)))))));
}

static inline bool sym__comparison_operator_character_set_1(int32_t c) {
  return (c < 8880
    ? (c < 8771
      ? (c < 8759
        ? (c < 8733
          ? (c >= 8713 && c <= 8717)
          : (c <= 8733 || (c >= 8741 && c <= 8742)))
        : (c <= 8759 || (c < 8765
          ? (c >= 8762 && c <= 8763)
          : (c <= 8766 || c == 8769))))
      : (c <= 8787 || (c < 8873
        ? (c < 8847
          ? (c >= 8790 && c <= 8843)
          : (c <= 8860 || (c >= 8866 && c <= 8867)))
        : (c <= 8873 || (c < 8878
          ? c == 8876
          : c <= 8878)))))
    : (c <= 8887 || (c < 10688
      ? (c < 10184
        ? (c < 8917
          ? (c >= 8909 && c <= 8913)
          : (c <= 8959 || c == 10178))
        : (c <= 10185 || (c < 10679
          ? c == 10194
          : c <= 10679)))
      : (c <= 10689 || (c < 10858
        ? (c < 10723
          ? c == 10721
          : (c <= 10725 || (c >= 10854 && c <= 10855)))
        : (c <= 10867 || (c < 10999
          ? (c >= 10869 && c <= 10969)
          : c <= 11002)))))));
}

static inline bool sym__comparison_operator_character_set_2(int32_t c) {
  return (c < 8880
    ? (c < 8771
      ? (c < 8759
        ? (c < 8733
          ? (c >= 8712 && c <= 8717)
          : (c <= 8733 || (c >= 8741 && c <= 8742)))
        : (c <= 8759 || (c < 8765
          ? (c >= 8762 && c <= 8763)
          : (c <= 8766 || c == 8769))))
      : (c <= 8787 || (c < 8873
        ? (c < 8847
          ? (c >= 8790 && c <= 8843)
          : (c <= 8860 || (c >= 8866 && c <= 8867)))
        : (c <= 8873 || (c < 8878
          ? c == 8876
          : c <= 8878)))))
    : (c <= 8887 || (c < 10688
      ? (c < 10184
        ? (c < 8917
          ? (c >= 8909 && c <= 8913)
          : (c <= 8959 || c == 10178))
        : (c <= 10185 || (c < 10679
          ? c == 10194
          : c <= 10679)))
      : (c <= 10689 || (c < 10858
        ? (c < 10723
          ? c == 10721
          : (c <= 10725 || (c >= 10854 && c <= 10855)))
        : (c <= 10867 || (c < 10999
          ? (c >= 10869 && c <= 10969)
          : c <= 11002)))))));
}

static inline bool sym__comparison_operator_character_set_3(int32_t c) {
  return (c < 8880
    ? (c < 8769
      ? (c < 8759
        ? (c < 8733
          ? (c >= 8712 && c <= 8717)
          : (c <= 8733 || (c >= 8741 && c <= 8742)))
        : (c <= 8759 || (c < 8765
          ? (c >= 8762 && c <= 8763)
          : c <= 8766)))
      : (c <= 8769 || (c < 8873
        ? (c < 8847
          ? (c >= 8771 && c <= 8843)
          : (c <= 8860 || (c >= 8866 && c <= 8867)))
        : (c <= 8873 || (c < 8878
          ? c == 8876
          : c <= 8878)))))
    : (c <= 8887 || (c < 10688
      ? (c < 10184
        ? (c < 8917
          ? (c >= 8909 && c <= 8913)
          : (c <= 8959 || c == 10178))
        : (c <= 10185 || (c < 10679
          ? c == 10194
          : c <= 10679)))
      : (c <= 10689 || (c < 10854
        ? (c < 10723
          ? c == 10721
          : c <= 10725)
        : (c <= 10855 || (c < 10999
          ? (c >= 10858 && c <= 10969)
          : c <= 11002)))))));
}

static inline bool sym__arrow_operator_character_set_1(int32_t c) {
  return (c < 10229
    ? (c < 8644
      ? (c < 8610
        ? (c < 8596
          ? (c < 8594
            ? c == 8592
            : c <= 8594)
          : (c <= 8596 || (c < 8608
            ? (c >= 8602 && c <= 8606)
            : c <= 8608)))
        : (c <= 8612 || (c < 8622
          ? (c < 8617
            ? c == 8614
            : c <= 8620)
          : (c <= 8622 || (c < 8640
            ? (c >= 8636 && c <= 8637)
            : c <= 8641)))))
      : (c <= 8644 || (c < 8666
        ? (c < 8651
          ? (c < 8649
            ? (c >= 8646 && c <= 8647)
            : c <= 8649)
          : (c <= 8656 || (c < 8660
            ? c == 8658
            : c <= 8660)))
        : (c <= 8669 || (c < 8692
          ? (c < 8674
            ? c == 8672
            : c <= 8674)
          : (c <= 8692 || (c >= 8694 && c <= 8703)))))))
    : (c <= 10231 || (c < 10586
      ? (c < 10564
        ? (c < 10508
          ? (c < 10496
            ? (c >= 10233 && c <= 10239)
            : c <= 10503)
          : (c <= 10513 || (c < 10525
            ? (c >= 10516 && c <= 10520)
            : c <= 10528)))
        : (c <= 10568 || (c < 10576
          ? (c < 10574
            ? (c >= 10570 && c <= 10571)
            : c <= 10574)
          : (c <= 10576 || (c < 10582
            ? (c >= 10578 && c <= 10579)
            : c <= 10583)))))
      : (c <= 10587 || (c < 10740
        ? (c < 10596
          ? (c < 10594
            ? (c >= 10590 && c <= 10591)
            : c <= 10594)
          : (c <= 10596 || (c < 10608
            ? (c >= 10598 && c <= 10605)
            : c <= 10608)))
        : (c <= 10740 || (c < 65513
          ? (c < 11079
            ? (c >= 11056 && c <= 11076)
            : c <= 11084)
          : (c <= 65513 || c == 65515))))))));
}

static inline bool sym__arrow_operator_character_set_2(int32_t c) {
  return (c < 8660
    ? (c < 8636
      ? (c < 8610
        ? (c < 8602
          ? (c >= 8592 && c <= 8596)
          : (c <= 8606 || c == 8608))
        : (c <= 8612 || (c < 8617
          ? c == 8614
          : (c <= 8620 || c == 8622))))
      : (c <= 8637 || (c < 8649
        ? (c < 8644
          ? (c >= 8640 && c <= 8641)
          : (c <= 8644 || (c >= 8646 && c <= 8647)))
        : (c <= 8649 || (c < 8658
          ? (c >= 8651 && c <= 8656)
          : c <= 8658)))))
    : (c <= 8660 || (c < 10496
      ? (c < 8692
        ? (c < 8672
          ? (c >= 8666 && c <= 8669)
          : (c <= 8672 || c == 8674))
        : (c <= 8703 || (c < 10233
          ? (c >= 10229 && c <= 10231)
          : c <= 10239)))
      : (c <= 10520 || (c < 11056
        ? (c < 10564
          ? (c >= 10525 && c <= 10528)
          : (c <= 10608 || c == 10740))
        : (c <= 11076 || (c < 65513
          ? (c >= 11079 && c <= 11084)
          : c <= 65515)))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(94);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(171);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(189);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (lookahead == 8712) ADVANCE(133);
      if (sym__comparison_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(92)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(28);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(121);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(110);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(172);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(121);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(172);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(183);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(166);
      if (lookahead == '.') ADVANCE(29);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(118);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(212);
      if (lookahead == '=') ADVANCE(103);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (sym__plus_operator_character_set_3(lookahead)) ADVANCE(191);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '$') ADVANCE(135);
      if (aux_sym_character_literal_token1_character_set_1(lookahead)) ADVANCE(153);
      if (lookahead == '&') ADVANCE(157);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(155);
      if (lookahead == '/') ADVANCE(160);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(159);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(164);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == '\\') ADVANCE(190);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(153);
      if (lookahead == '|') ADVANCE(163);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(153);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(153);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(153);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(153);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(153);
      if (lookahead == 8770) ADVANCE(153);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(154);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      if (lookahead != 0) ADVANCE(153);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(171);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(171);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 15:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 16:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 17:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(28);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 18:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 19:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 20:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(169);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(110);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(172);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 23:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_2(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(172);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(191);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 24:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(183);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == '-') ADVANCE(166);
      if (lookahead == '.') ADVANCE(29);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(118);
      if (lookahead == '<') ADVANCE(206);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '{') ADVANCE(107);
      if (sym__plus_operator_character_set_3(lookahead)) ADVANCE(191);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 25:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (sym__plus_operator_character_set_4(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_4(lookahead)) ADVANCE(183);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == '-') ADVANCE(166);
      if (lookahead == '.') ADVANCE(29);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == '<') ADVANCE(212);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '[') ADVANCE(132);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 26:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (sym__plus_operator_character_set_4(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_4(lookahead)) ADVANCE(183);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == '-') ADVANCE(166);
      if (lookahead == '.') ADVANCE(115);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '<') ADVANCE(212);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(214);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 27:
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(188);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(168);
      if (lookahead == '-') ADVANCE(173);
      if (lookahead == '.') ADVANCE(202);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '<') ADVANCE(207);
      if (lookahead == '=') ADVANCE(218);
      if (lookahead == '>') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '|') ADVANCE(198);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      END_STATE();
    case 28:
      if (lookahead == '!') ADVANCE(174);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(183);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == '-') ADVANCE(166);
      if (lookahead == '.') ADVANCE(202);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '<') ADVANCE(208);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(211);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (sym__plus_operator_character_set_3(lookahead)) ADVANCE(191);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      END_STATE();
    case 29:
      if (lookahead == '!') ADVANCE(174);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(183);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == '-') ADVANCE(166);
      if (lookahead == '.' ||
          lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '<') ADVANCE(208);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(211);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (sym__plus_operator_character_set_3(lookahead)) ADVANCE(191);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      END_STATE();
    case 30:
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 31:
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 32:
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(196);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 33:
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(196);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 34:
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 35:
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 36:
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (sym__plus_operator_character_set_5(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_5(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(194);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 37:
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (sym__plus_operator_character_set_5(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_5(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(194);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 38:
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (sym__plus_operator_character_set_5(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_5(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(197);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(39)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 39:
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (sym__plus_operator_character_set_5(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_5(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(197);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(39)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 40:
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (sym__plus_operator_character_set_5(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_5(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(194);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(40)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 41:
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (sym__plus_operator_character_set_5(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_5(lookahead)) ADVANCE(183);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(194);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == ':') ADVANCE(110);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(205);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == '|') ADVANCE(200);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(40)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 42:
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '.') ADVANCE(112);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(69);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == 8712) ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43)
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(138);
      END_STATE();
    case 43:
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '.') ADVANCE(112);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '\\') ADVANCE(69);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == 8712) ADVANCE(133);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43)
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(138);
      END_STATE();
    case 44:
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(54);
      if (lookahead == '%') ADVANCE(54);
      if (lookahead == '&') ADVANCE(54);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(54);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(54);
      if (lookahead == '.') ADVANCE(46);
      if (lookahead == '/') ADVANCE(51);
      if (lookahead == ':') ADVANCE(52);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(53);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '>') ADVANCE(59);
      if (lookahead == '\\') ADVANCE(54);
      if (lookahead == '^') ADVANCE(54);
      if (lookahead == '|') ADVANCE(54);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 247) ADVANCE(54);
      if (lookahead == 8891) ADVANCE(54);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44)
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(138);
      END_STATE();
    case 45:
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '\\') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(156);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(153);
      END_STATE();
    case 46:
      if (lookahead == '%') ADVANCE(54);
      if (lookahead == '&') ADVANCE(54);
      if (lookahead == '*') ADVANCE(54);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == '-') ADVANCE(54);
      if (lookahead == '.') ADVANCE(49);
      if (lookahead == '/') ADVANCE(51);
      if (lookahead == '<') ADVANCE(53);
      if (lookahead == '=' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == '>') ADVANCE(59);
      if (lookahead == '\\') ADVANCE(54);
      if (lookahead == '^') ADVANCE(54);
      if (lookahead == '|') ADVANCE(54);
      if (lookahead == 247) ADVANCE(54);
      if (lookahead == 8891) ADVANCE(54);
      END_STATE();
    case 47:
      if (lookahead == '%') ADVANCE(54);
      if (lookahead == '&') ADVANCE(54);
      if (lookahead == '*') ADVANCE(54);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == '-') ADVANCE(54);
      if (lookahead == '/') ADVANCE(51);
      if (lookahead == '<') ADVANCE(53);
      if (lookahead == '=' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == '>') ADVANCE(59);
      if (lookahead == '\\') ADVANCE(54);
      if (lookahead == '^') ADVANCE(54);
      if (lookahead == '|') ADVANCE(54);
      if (lookahead == 247) ADVANCE(54);
      if (lookahead == 8891) ADVANCE(54);
      END_STATE();
    case 48:
      if (lookahead == '-') ADVANCE(216);
      END_STATE();
    case 49:
      if (lookahead == '.') ADVANCE(105);
      END_STATE();
    case 50:
      if (lookahead == '.') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      END_STATE();
    case 51:
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 52:
      if (lookahead == ':') ADVANCE(106);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 53:
      if (lookahead == '<') ADVANCE(54);
      END_STATE();
    case 54:
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 55:
      if (lookahead == '=') ADVANCE(217);
      if (lookahead == '>') ADVANCE(54);
      END_STATE();
    case 56:
      if (lookahead == '=') ADVANCE(209);
      END_STATE();
    case 57:
      if (lookahead == '=') ADVANCE(209);
      if (lookahead == '>') ADVANCE(131);
      END_STATE();
    case 58:
      if (lookahead == '>') ADVANCE(215);
      END_STATE();
    case 59:
      if (lookahead == '>') ADVANCE(55);
      END_STATE();
    case 60:
      if (lookahead == '_') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(96);
      END_STATE();
    case 61:
      if (lookahead == '_') ADVANCE(61);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(139);
      END_STATE();
    case 62:
      if (lookahead == '_') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(140);
      END_STATE();
    case 63:
      if (lookahead == '_') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      END_STATE();
    case 64:
      if (lookahead == '_') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      END_STATE();
    case 65:
      if (lookahead == '_') ADVANCE(66);
      if (lookahead == 'p') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 66:
      if (lookahead == '_') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 67:
      if (lookahead == '_') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      END_STATE();
    case 68:
      if (lookahead == 'p') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 69:
      if (lookahead == 'x') ADVANCE(77);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(147);
      if (sym_escape_sequence_character_set_1(lookahead)) ADVANCE(145);
      END_STATE();
    case 70:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      END_STATE();
    case 71:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(139);
      END_STATE();
    case 72:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(140);
      END_STATE();
    case 73:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      END_STATE();
    case 74:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(145);
      END_STATE();
    case 75:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(152);
      END_STATE();
    case 76:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 77:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(74);
      END_STATE();
    case 78:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(171);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(79)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 79:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(171);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(79)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 80:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(83)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 81:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(82)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 82:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(82)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 83:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(83)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 84:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(84)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 85:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(86)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 86:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(86)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 87:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(88)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 88:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(88)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 89:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(196);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '[') ADVANCE(121);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(90)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 90:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(196);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_3(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(90)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      END_STATE();
    case 91:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(219);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(54);
      if (lookahead == '%') ADVANCE(54);
      if (lookahead == '&') ADVANCE(54);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(54);
      if (lookahead == '+') ADVANCE(54);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(54);
      if (lookahead == '.') ADVANCE(47);
      if (lookahead == '/') ADVANCE(51);
      if (lookahead == ':') ADVANCE(54);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(53);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '>') ADVANCE(59);
      if (lookahead == '\\') ADVANCE(54);
      if (lookahead == '^') ADVANCE(54);
      if (lookahead == '|') ADVANCE(54);
      if (lookahead == '~' ||
          lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 247) ADVANCE(54);
      if (lookahead == 8891) ADVANCE(54);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(91)
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(138);
      END_STATE();
    case 92:
      if (eof) ADVANCE(94);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(136);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(185);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(125);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(171);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(120);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(204);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(213);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == '\\') ADVANCE(189);
      if (lookahead == ']') ADVANCE(122);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '|') ADVANCE(199);
      if (lookahead == '}') ADVANCE(108);
      if (lookahead == '~') ADVANCE(166);
      if (lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (lookahead == 8712) ADVANCE(133);
      if (sym__comparison_operator_character_set_1(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(92)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 93:
      if (eof) ADVANCE(94);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '#') ADVANCE(221);
      if (lookahead == '$') ADVANCE(135);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(183);
      if (lookahead == '\'') ADVANCE(123);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(166);
      if (lookahead == '.') ADVANCE(29);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(118);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(212);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(214);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == ']') ADVANCE(122);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (sym__plus_operator_character_set_3(lookahead)) ADVANCE(191);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(93)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(138);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym_primitive_definition_token1);
      if (lookahead == '.') ADVANCE(143);
      if (lookahead == '_') ADVANCE(60);
      if (lookahead == 'b') ADVANCE(71);
      if (lookahead == 'o') ADVANCE(72);
      if (lookahead == 'x') ADVANCE(50);
      if (lookahead == 'E' ||
          lookahead == 'e' ||
          lookahead == 'f') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(96);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym_primitive_definition_token1);
      if (lookahead == '.') ADVANCE(143);
      if (lookahead == '_') ADVANCE(60);
      if (lookahead == 'E' ||
          lookahead == 'e' ||
          lookahead == 'f') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(96);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(aux_sym_primitive_definition_token1);
      if (lookahead == '_') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(97);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(209);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(209);
      if (lookahead == '>') ADVANCE(131);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_LT_COLON);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(106);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(106);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '!') ADVANCE(174);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(188);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(168);
      if (lookahead == '-') ADVANCE(173);
      if (lookahead == '.') ADVANCE(202);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '<') ADVANCE(207);
      if (lookahead == '=') ADVANCE(218);
      if (lookahead == '>') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '|') ADVANCE(198);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '!') ADVANCE(174);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(183);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == '-') ADVANCE(166);
      if (lookahead == '.') ADVANCE(202);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '<') ADVANCE(208);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(211);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (sym__plus_operator_character_set_3(lookahead)) ADVANCE(191);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '!') ADVANCE(174);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(183);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == '-') ADVANCE(166);
      if (lookahead == '.' ||
          lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '<') ADVANCE(208);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(211);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (sym__plus_operator_character_set_3(lookahead)) ADVANCE(191);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '!') ADVANCE(56);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '&') ADVANCE(188);
      if (lookahead == '*') ADVANCE(188);
      if (lookahead == '+') ADVANCE(193);
      if (lookahead == '-') ADVANCE(198);
      if (lookahead == '.') ADVANCE(202);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '<') ADVANCE(207);
      if (lookahead == '=') ADVANCE(218);
      if (lookahead == '>') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '^') ADVANCE(176);
      if (lookahead == '|') ADVANCE(198);
      if (sym__plus_operator_character_set_1(lookahead)) ADVANCE(191);
      if (sym__times_operator_character_set_1(lookahead)) ADVANCE(183);
      if (lookahead == 247) ADVANCE(188);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_1(lookahead)) ADVANCE(215);
      if ((8593 <= lookahead && lookahead <= 8595) ||
          lookahead == 8693 ||
          lookahead == 10224 ||
          lookahead == 10225 ||
          (10504 <= lookahead && lookahead <= 10515) ||
          (10569 <= lookahead && lookahead <= 10607) ||
          (65514 <= lookahead && lookahead <= 65516)) ADVANCE(175);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (lookahead == 8788 ||
          lookahead == 8789 ||
          lookahead == 10868) ADVANCE(217);
      if (lookahead == 8891) ADVANCE(198);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '!') ADVANCE(56);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(183);
      if (lookahead == '+') ADVANCE(192);
      if (sym__plus_operator_character_set_6(lookahead)) ADVANCE(191);
      if (lookahead == '.') ADVANCE(202);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '<') ADVANCE(208);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(211);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_COLON2);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_COLON2);
      if (lookahead == ':') ADVANCE(106);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_COLON2);
      if (lookahead == ':') ADVANCE(106);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(191);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(191);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_LT_PIPE);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_LBRACK2);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_identifier);
      if (!sym_identifier_character_set_5(lookahead)) ADVANCE(138);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_integer_literal_token1);
      if (lookahead == '_') ADVANCE(61);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(139);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_integer_literal_token2);
      if (lookahead == '_') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_integer_literal_token3);
      if (lookahead == '.') ADVANCE(68);
      if (lookahead == '_') ADVANCE(63);
      if (lookahead == 'p') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == '_') ADVANCE(64);
      if (lookahead == 'E' ||
          lookahead == 'e' ||
          lookahead == 'f') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == 'E' ||
          lookahead == 'e' ||
          lookahead == 'f') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_float_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(145);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(146);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(145);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(148);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(149);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(150);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(151);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '$') ADVANCE(135);
      if (aux_sym_character_literal_token1_character_set_1(lookahead)) ADVANCE(153);
      if (lookahead == '&') ADVANCE(157);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '+') ADVANCE(124);
      if (lookahead == '-') ADVANCE(158);
      if (lookahead == '.') ADVANCE(155);
      if (lookahead == '/') ADVANCE(160);
      if (lookahead == '0') ADVANCE(95);
      if (lookahead == ':') ADVANCE(119);
      if (lookahead == ';') ADVANCE(101);
      if (lookahead == '<') ADVANCE(159);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(164);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '@') ADVANCE(137);
      if (lookahead == '[') ADVANCE(132);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(153);
      if (lookahead == '|') ADVANCE(163);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(153);
      if (sym__plus_operator_character_set_2(lookahead)) ADVANCE(153);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(153);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(153);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(153);
      if (lookahead == 8770) ADVANCE(153);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(154);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(96);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(138);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(153);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (lookahead == '!') ADVANCE(174);
      if (sym__times_operator_character_set_3(lookahead)) ADVANCE(183);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == '-') ADVANCE(166);
      if (lookahead == '.') ADVANCE(202);
      if (lookahead == '/') ADVANCE(187);
      if (lookahead == '<') ADVANCE(208);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(211);
      if (sym__power_operator_character_set_1(lookahead)) ADVANCE(175);
      if (sym__plus_operator_character_set_3(lookahead)) ADVANCE(191);
      if (lookahead == '~' ||
          lookahead == 172 ||
          (8730 <= lookahead && lookahead <= 8732)) ADVANCE(166);
      if (lookahead == 8230 ||
          lookahead == 8285 ||
          (8942 <= lookahead && lookahead <= 8945)) ADVANCE(201);
      if (sym__arrow_operator_character_set_2(lookahead)) ADVANCE(215);
      if (sym__comparison_operator_character_set_2(lookahead)) ADVANCE(203);
      if (lookahead == 8770) ADVANCE(191);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(142);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(156);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(153);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (lookahead == '&') ADVANCE(129);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (lookahead == '-') ADVANCE(58);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == ':') ADVANCE(109);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '=') ADVANCE(203);
      if (lookahead == '|') ADVANCE(126);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (lookahead == '/') ADVANCE(181);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (lookahead == '=') ADVANCE(209);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (lookahead == '=') ADVANCE(209);
      if (lookahead == '>') ADVANCE(131);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '|') ADVANCE(128);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (lookahead == ':' ||
          lookahead == '=') ADVANCE(203);
      if (lookahead == '>') ADVANCE(180);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_character_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(221);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym__unary_operator);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym__unary_operator);
      if (lookahead == '+') ADVANCE(191);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym__unary_operator);
      if (lookahead == '+') ADVANCE(191);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym__unary_operator);
      if (lookahead == '-') ADVANCE(58);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym__unary_operator);
      if (lookahead == '-') ADVANCE(58);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym__unary_operator);
      if (lookahead == '-') ADVANCE(58);
      if (lookahead == '=') ADVANCE(217);
      if (lookahead == '>') ADVANCE(134);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym__unary_operator);
      if (lookahead == '-') ADVANCE(58);
      if (lookahead == '>') ADVANCE(134);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym__unary_operator);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym__unary_operator);
      if (lookahead == '=') ADVANCE(209);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym__power_operator);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym__power_operator);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym__bitshift_operator);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym__bitshift_operator);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym__bitshift_operator);
      if (lookahead == '=') ADVANCE(217);
      if (lookahead == '>') ADVANCE(178);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym__bitshift_operator);
      if (lookahead == '>') ADVANCE(177);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym__rational_operator);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym__rational_operator);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym__times_operator);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym__times_operator);
      if (lookahead == '&') ADVANCE(129);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym__times_operator);
      if (lookahead == '&') ADVANCE(129);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym__times_operator);
      if (lookahead == '/') ADVANCE(182);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym__times_operator);
      if (lookahead == '/') ADVANCE(181);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym__times_operator);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym__times_operator);
      if (lookahead == '=') ADVANCE(217);
      if (lookahead == 'x') ADVANCE(77);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(147);
      if (sym_escape_sequence_character_set_1(lookahead)) ADVANCE(145);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym__times_operator);
      if (lookahead == 'x') ADVANCE(77);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(147);
      if (sym_escape_sequence_character_set_1(lookahead)) ADVANCE(145);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym__plus_operator);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '+') ADVANCE(191);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '+') ADVANCE(191);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '-') ADVANCE(58);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '-') ADVANCE(58);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '-') ADVANCE(58);
      if (lookahead == '=') ADVANCE(217);
      if (lookahead == '>') ADVANCE(134);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '-') ADVANCE(58);
      if (lookahead == '>') ADVANCE(134);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '=') ADVANCE(217);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '|') ADVANCE(128);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym__plus_operator);
      if (lookahead == '>') ADVANCE(127);
      if (lookahead == '|') ADVANCE(128);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym__dotty_operator);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym__dotty_operator);
      if (lookahead == '.') ADVANCE(105);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym__comparison_operator);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == ':') ADVANCE(109);
      if (lookahead == '<') ADVANCE(178);
      if (lookahead == '=') ADVANCE(203);
      if (lookahead == '|') ADVANCE(126);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == ':') ADVANCE(109);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '=') ADVANCE(203);
      if (lookahead == '|') ADVANCE(126);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == ':') ADVANCE(109);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '=') ADVANCE(203);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == '<') ADVANCE(178);
      if (lookahead == '=') ADVANCE(203);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == '<') ADVANCE(177);
      if (lookahead == '=') ADVANCE(203);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == '=') ADVANCE(203);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == '=') ADVANCE(203);
      if (lookahead == '>') ADVANCE(179);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == '=') ADVANCE(203);
      if (lookahead == '>') ADVANCE(180);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == ':' ||
          lookahead == '=') ADVANCE(203);
      if (lookahead == '<') ADVANCE(177);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == ':' ||
          lookahead == '=') ADVANCE(203);
      if (lookahead == '>') ADVANCE(179);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym__comparison_operator);
      if (lookahead == ':' ||
          lookahead == '=') ADVANCE(203);
      if (lookahead == '>') ADVANCE(180);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym__arrow_operator);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym__arrow_operator);
      if (lookahead == '>') ADVANCE(215);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym__assign_operator);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym__assign_operator);
      if (lookahead == '=') ADVANCE(209);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(219);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(220);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(154);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(221);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'p') ADVANCE(10);
      if (lookahead == 'q') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      if (lookahead == 'w') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(17);
      END_STATE();
    case 2:
      if (lookahead == 'e') ADVANCE(18);
      if (lookahead == 'r') ADVANCE(19);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(20);
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 4:
      if (lookahead == 'o') ADVANCE(22);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 'x') ADVANCE(25);
      END_STATE();
    case 6:
      if (lookahead == 'i') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      if (lookahead == 'u') ADVANCE(28);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(29);
      if (lookahead == 'm') ADVANCE(30);
      if (lookahead == 'n') ADVANCE(31);
      if (lookahead == 's') ADVANCE(32);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'o') ADVANCE(35);
      if (lookahead == 'u') ADVANCE(36);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(37);
      END_STATE();
    case 11:
      if (lookahead == 'u') ADVANCE(38);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 13:
      if (lookahead == 't') ADVANCE(40);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(41);
      if (lookahead == 'y') ADVANCE(42);
      END_STATE();
    case 15:
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 16:
      if (lookahead == 'h') ADVANCE(44);
      END_STATE();
    case 17:
      if (lookahead == 's') ADVANCE(45);
      END_STATE();
    case 18:
      if (lookahead == 'g') ADVANCE(46);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 20:
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 21:
      if (lookahead == 'n') ADVANCE(49);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 23:
      if (lookahead == 's') ADVANCE(50);
      END_STATE();
    case 24:
      if (lookahead == 'd') ADVANCE(51);
      END_STATE();
    case 25:
      if (lookahead == 'p') ADVANCE(52);
      END_STATE();
    case 26:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 27:
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 28:
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 30:
      if (lookahead == 'p') ADVANCE(56);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(57);
      END_STATE();
    case 33:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 34:
      if (lookahead == 'c') ADVANCE(59);
      END_STATE();
    case 35:
      if (lookahead == 'd') ADVANCE(60);
      END_STATE();
    case 36:
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 37:
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 39:
      if (lookahead == 't') ADVANCE(64);
      END_STATE();
    case 40:
      if (lookahead == 'r') ADVANCE(65);
      END_STATE();
    case 41:
      if (lookahead == 'y') ADVANCE(66);
      END_STATE();
    case 42:
      if (lookahead == 'p') ADVANCE(67);
      END_STATE();
    case 43:
      if (lookahead == 'i') ADVANCE(68);
      END_STATE();
    case 44:
      if (lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(71);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(72);
      END_STATE();
    case 48:
      if (lookahead == 'c') ADVANCE(73);
      END_STATE();
    case 49:
      if (lookahead == 's') ADVANCE(74);
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(76);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 52:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 53:
      if (lookahead == 'a') ADVANCE(78);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 55:
      if (lookahead == 'c') ADVANCE(79);
      END_STATE();
    case 56:
      if (lookahead == 'o') ADVANCE(80);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_isa);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 60:
      if (lookahead == 'u') ADVANCE(82);
      END_STATE();
    case 61:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 62:
      if (lookahead == 'm') ADVANCE(84);
      END_STATE();
    case 63:
      if (lookahead == 't') ADVANCE(85);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(86);
      END_STATE();
    case 65:
      if (lookahead == 'u') ADVANCE(87);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 68:
      if (lookahead == 'n') ADVANCE(89);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(90);
      END_STATE();
    case 70:
      if (lookahead == 'r') ADVANCE(91);
      END_STATE();
    case 71:
      if (lookahead == 'n') ADVANCE(92);
      END_STATE();
    case 72:
      if (lookahead == 'k') ADVANCE(93);
      END_STATE();
    case 73:
      if (lookahead == 'h') ADVANCE(94);
      END_STATE();
    case 74:
      if (lookahead == 't') ADVANCE(95);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(96);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 77:
      if (lookahead == 'r') ADVANCE(98);
      END_STATE();
    case 78:
      if (lookahead == 'l') ADVANCE(99);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(100);
      END_STATE();
    case 80:
      if (lookahead == 'r') ADVANCE(101);
      END_STATE();
    case 81:
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(103);
      END_STATE();
    case 83:
      if (lookahead == 'b') ADVANCE(104);
      END_STATE();
    case 84:
      if (lookahead == 'i') ADVANCE(105);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 86:
      if (lookahead == 'r') ADVANCE(107);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(108);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 89:
      if (lookahead == 'g') ADVANCE(109);
      END_STATE();
    case 90:
      if (lookahead == 'e') ADVANCE(110);
      END_STATE();
    case 91:
      if (lookahead == 'a') ADVANCE(111);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_begin);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 96:
      if (lookahead == 'n') ADVANCE(112);
      END_STATE();
    case 97:
      if (lookahead == 'f') ADVANCE(113);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(114);
      END_STATE();
    case 99:
      if (lookahead == 'l') ADVANCE(115);
      END_STATE();
    case 100:
      if (lookahead == 'i') ADVANCE(116);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_macro);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(119);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_quote);
      END_STATE();
    case 107:
      if (lookahead == 'n') ADVANCE(121);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 111:
      if (lookahead == 'c') ADVANCE(123);
      END_STATE();
    case 112:
      if (lookahead == 'u') ADVANCE(124);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 115:
      if (lookahead == 'y') ADVANCE(125);
      END_STATE();
    case 116:
      if (lookahead == 'o') ADVANCE(126);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(128);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 126:
      if (lookahead == 'n') ADVANCE(131);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_mutable);
      END_STATE();
    case 128:
      if (lookahead == 'v') ADVANCE(132);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_continue_statement);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(133);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_primitive);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 93, .external_lex_state = 2},
  [2] = {.lex_state = 78, .external_lex_state = 3},
  [3] = {.lex_state = 84, .external_lex_state = 4},
  [4] = {.lex_state = 84, .external_lex_state = 4},
  [5] = {.lex_state = 84, .external_lex_state = 2},
  [6] = {.lex_state = 84, .external_lex_state = 2},
  [7] = {.lex_state = 84, .external_lex_state = 2},
  [8] = {.lex_state = 84, .external_lex_state = 2},
  [9] = {.lex_state = 84, .external_lex_state = 4},
  [10] = {.lex_state = 84, .external_lex_state = 4},
  [11] = {.lex_state = 1, .external_lex_state = 2},
  [12] = {.lex_state = 16, .external_lex_state = 4},
  [13] = {.lex_state = 1, .external_lex_state = 2},
  [14] = {.lex_state = 1, .external_lex_state = 2},
  [15] = {.lex_state = 1, .external_lex_state = 2},
  [16] = {.lex_state = 1, .external_lex_state = 2},
  [17] = {.lex_state = 1, .external_lex_state = 2},
  [18] = {.lex_state = 16, .external_lex_state = 4},
  [19] = {.lex_state = 1, .external_lex_state = 2},
  [20] = {.lex_state = 84, .external_lex_state = 2},
  [21] = {.lex_state = 1, .external_lex_state = 2},
  [22] = {.lex_state = 84, .external_lex_state = 2},
  [23] = {.lex_state = 84, .external_lex_state = 4},
  [24] = {.lex_state = 84, .external_lex_state = 4},
  [25] = {.lex_state = 16, .external_lex_state = 4},
  [26] = {.lex_state = 84, .external_lex_state = 4},
  [27] = {.lex_state = 84, .external_lex_state = 4},
  [28] = {.lex_state = 17, .external_lex_state = 4},
  [29] = {.lex_state = 16, .external_lex_state = 2},
  [30] = {.lex_state = 84, .external_lex_state = 4},
  [31] = {.lex_state = 16, .external_lex_state = 2},
  [32] = {.lex_state = 16, .external_lex_state = 2},
  [33] = {.lex_state = 1, .external_lex_state = 4},
  [34] = {.lex_state = 84, .external_lex_state = 4},
  [35] = {.lex_state = 84, .external_lex_state = 4},
  [36] = {.lex_state = 84, .external_lex_state = 4},
  [37] = {.lex_state = 17, .external_lex_state = 4},
  [38] = {.lex_state = 16, .external_lex_state = 2},
  [39] = {.lex_state = 16, .external_lex_state = 4},
  [40] = {.lex_state = 84, .external_lex_state = 4},
  [41] = {.lex_state = 84, .external_lex_state = 2},
  [42] = {.lex_state = 1, .external_lex_state = 4},
  [43] = {.lex_state = 16, .external_lex_state = 2},
  [44] = {.lex_state = 16, .external_lex_state = 2},
  [45] = {.lex_state = 1, .external_lex_state = 2},
  [46] = {.lex_state = 17, .external_lex_state = 2},
  [47] = {.lex_state = 84, .external_lex_state = 2},
  [48] = {.lex_state = 1, .external_lex_state = 2},
  [49] = {.lex_state = 84, .external_lex_state = 4},
  [50] = {.lex_state = 17, .external_lex_state = 2},
  [51] = {.lex_state = 17, .external_lex_state = 4},
  [52] = {.lex_state = 17, .external_lex_state = 4},
  [53] = {.lex_state = 84, .external_lex_state = 4},
  [54] = {.lex_state = 84, .external_lex_state = 2},
  [55] = {.lex_state = 84, .external_lex_state = 2},
  [56] = {.lex_state = 1, .external_lex_state = 2},
  [57] = {.lex_state = 1, .external_lex_state = 2},
  [58] = {.lex_state = 17, .external_lex_state = 2},
  [59] = {.lex_state = 84, .external_lex_state = 2},
  [60] = {.lex_state = 17, .external_lex_state = 2},
  [61] = {.lex_state = 1, .external_lex_state = 4},
  [62] = {.lex_state = 17, .external_lex_state = 4},
  [63] = {.lex_state = 1, .external_lex_state = 2},
  [64] = {.lex_state = 17, .external_lex_state = 2},
  [65] = {.lex_state = 17, .external_lex_state = 4},
  [66] = {.lex_state = 1, .external_lex_state = 4},
  [67] = {.lex_state = 1, .external_lex_state = 2},
  [68] = {.lex_state = 1, .external_lex_state = 2},
  [69] = {.lex_state = 1, .external_lex_state = 2},
  [70] = {.lex_state = 1, .external_lex_state = 2},
  [71] = {.lex_state = 1, .external_lex_state = 2},
  [72] = {.lex_state = 1, .external_lex_state = 2},
  [73] = {.lex_state = 1, .external_lex_state = 2},
  [74] = {.lex_state = 1, .external_lex_state = 2},
  [75] = {.lex_state = 84, .external_lex_state = 2},
  [76] = {.lex_state = 17, .external_lex_state = 2},
  [77] = {.lex_state = 84, .external_lex_state = 2},
  [78] = {.lex_state = 1, .external_lex_state = 2},
  [79] = {.lex_state = 1, .external_lex_state = 2},
  [80] = {.lex_state = 17, .external_lex_state = 2},
  [81] = {.lex_state = 1, .external_lex_state = 2},
  [82] = {.lex_state = 17, .external_lex_state = 2},
  [83] = {.lex_state = 17, .external_lex_state = 4},
  [84] = {.lex_state = 17, .external_lex_state = 2},
  [85] = {.lex_state = 17, .external_lex_state = 4},
  [86] = {.lex_state = 17, .external_lex_state = 2},
  [87] = {.lex_state = 93, .external_lex_state = 2},
  [88] = {.lex_state = 93, .external_lex_state = 2},
  [89] = {.lex_state = 93, .external_lex_state = 2},
  [90] = {.lex_state = 93, .external_lex_state = 2},
  [91] = {.lex_state = 93, .external_lex_state = 2},
  [92] = {.lex_state = 93, .external_lex_state = 2},
  [93] = {.lex_state = 93, .external_lex_state = 2},
  [94] = {.lex_state = 93, .external_lex_state = 2},
  [95] = {.lex_state = 93, .external_lex_state = 2},
  [96] = {.lex_state = 93, .external_lex_state = 2},
  [97] = {.lex_state = 93, .external_lex_state = 2},
  [98] = {.lex_state = 93, .external_lex_state = 2},
  [99] = {.lex_state = 93, .external_lex_state = 2},
  [100] = {.lex_state = 93, .external_lex_state = 2},
  [101] = {.lex_state = 93, .external_lex_state = 2},
  [102] = {.lex_state = 93, .external_lex_state = 2},
  [103] = {.lex_state = 8, .external_lex_state = 2},
  [104] = {.lex_state = 93, .external_lex_state = 2},
  [105] = {.lex_state = 24, .external_lex_state = 2},
  [106] = {.lex_state = 8, .external_lex_state = 2},
  [107] = {.lex_state = 93, .external_lex_state = 2},
  [108] = {.lex_state = 24, .external_lex_state = 2},
  [109] = {.lex_state = 8, .external_lex_state = 2},
  [110] = {.lex_state = 24, .external_lex_state = 2},
  [111] = {.lex_state = 93, .external_lex_state = 2},
  [112] = {.lex_state = 93, .external_lex_state = 2},
  [113] = {.lex_state = 93, .external_lex_state = 2},
  [114] = {.lex_state = 24, .external_lex_state = 2},
  [115] = {.lex_state = 8, .external_lex_state = 2},
  [116] = {.lex_state = 8, .external_lex_state = 2},
  [117] = {.lex_state = 8, .external_lex_state = 2},
  [118] = {.lex_state = 8, .external_lex_state = 2},
  [119] = {.lex_state = 24, .external_lex_state = 2},
  [120] = {.lex_state = 8, .external_lex_state = 2},
  [121] = {.lex_state = 8, .external_lex_state = 2},
  [122] = {.lex_state = 8, .external_lex_state = 2},
  [123] = {.lex_state = 8, .external_lex_state = 2},
  [124] = {.lex_state = 8, .external_lex_state = 2},
  [125] = {.lex_state = 24, .external_lex_state = 2},
  [126] = {.lex_state = 24, .external_lex_state = 2},
  [127] = {.lex_state = 8, .external_lex_state = 2},
  [128] = {.lex_state = 8, .external_lex_state = 2},
  [129] = {.lex_state = 8, .external_lex_state = 2},
  [130] = {.lex_state = 93, .external_lex_state = 2},
  [131] = {.lex_state = 8, .external_lex_state = 2},
  [132] = {.lex_state = 24, .external_lex_state = 2},
  [133] = {.lex_state = 8, .external_lex_state = 2},
  [134] = {.lex_state = 8, .external_lex_state = 2},
  [135] = {.lex_state = 93, .external_lex_state = 2},
  [136] = {.lex_state = 24, .external_lex_state = 2},
  [137] = {.lex_state = 8, .external_lex_state = 2},
  [138] = {.lex_state = 8, .external_lex_state = 2},
  [139] = {.lex_state = 8, .external_lex_state = 2},
  [140] = {.lex_state = 8, .external_lex_state = 2},
  [141] = {.lex_state = 8, .external_lex_state = 2},
  [142] = {.lex_state = 8, .external_lex_state = 2},
  [143] = {.lex_state = 8, .external_lex_state = 2},
  [144] = {.lex_state = 93, .external_lex_state = 2},
  [145] = {.lex_state = 8, .external_lex_state = 2},
  [146] = {.lex_state = 24, .external_lex_state = 2},
  [147] = {.lex_state = 24, .external_lex_state = 2},
  [148] = {.lex_state = 8, .external_lex_state = 2},
  [149] = {.lex_state = 93, .external_lex_state = 2},
  [150] = {.lex_state = 93, .external_lex_state = 2},
  [151] = {.lex_state = 8, .external_lex_state = 2},
  [152] = {.lex_state = 24, .external_lex_state = 2},
  [153] = {.lex_state = 8, .external_lex_state = 2},
  [154] = {.lex_state = 24, .external_lex_state = 2},
  [155] = {.lex_state = 24, .external_lex_state = 2},
  [156] = {.lex_state = 24, .external_lex_state = 2},
  [157] = {.lex_state = 8, .external_lex_state = 2},
  [158] = {.lex_state = 8, .external_lex_state = 2},
  [159] = {.lex_state = 24, .external_lex_state = 2},
  [160] = {.lex_state = 8, .external_lex_state = 2},
  [161] = {.lex_state = 8, .external_lex_state = 2},
  [162] = {.lex_state = 24, .external_lex_state = 2},
  [163] = {.lex_state = 24, .external_lex_state = 2},
  [164] = {.lex_state = 24, .external_lex_state = 2},
  [165] = {.lex_state = 24, .external_lex_state = 2},
  [166] = {.lex_state = 24, .external_lex_state = 2},
  [167] = {.lex_state = 24, .external_lex_state = 2},
  [168] = {.lex_state = 24, .external_lex_state = 2},
  [169] = {.lex_state = 24, .external_lex_state = 2},
  [170] = {.lex_state = 24, .external_lex_state = 2},
  [171] = {.lex_state = 93, .external_lex_state = 2},
  [172] = {.lex_state = 24, .external_lex_state = 2},
  [173] = {.lex_state = 24, .external_lex_state = 2},
  [174] = {.lex_state = 8, .external_lex_state = 2},
  [175] = {.lex_state = 24, .external_lex_state = 2},
  [176] = {.lex_state = 24, .external_lex_state = 2},
  [177] = {.lex_state = 24, .external_lex_state = 2},
  [178] = {.lex_state = 24, .external_lex_state = 2},
  [179] = {.lex_state = 93, .external_lex_state = 2},
  [180] = {.lex_state = 24, .external_lex_state = 2},
  [181] = {.lex_state = 93, .external_lex_state = 2},
  [182] = {.lex_state = 93, .external_lex_state = 2},
  [183] = {.lex_state = 93, .external_lex_state = 2},
  [184] = {.lex_state = 93, .external_lex_state = 2},
  [185] = {.lex_state = 93, .external_lex_state = 2},
  [186] = {.lex_state = 93, .external_lex_state = 2},
  [187] = {.lex_state = 93, .external_lex_state = 2},
  [188] = {.lex_state = 93, .external_lex_state = 2},
  [189] = {.lex_state = 93, .external_lex_state = 2},
  [190] = {.lex_state = 93, .external_lex_state = 2},
  [191] = {.lex_state = 93, .external_lex_state = 2},
  [192] = {.lex_state = 93, .external_lex_state = 2},
  [193] = {.lex_state = 93, .external_lex_state = 2},
  [194] = {.lex_state = 93, .external_lex_state = 2},
  [195] = {.lex_state = 93, .external_lex_state = 2},
  [196] = {.lex_state = 93, .external_lex_state = 2},
  [197] = {.lex_state = 93, .external_lex_state = 2},
  [198] = {.lex_state = 93, .external_lex_state = 2},
  [199] = {.lex_state = 93, .external_lex_state = 2},
  [200] = {.lex_state = 93, .external_lex_state = 2},
  [201] = {.lex_state = 93, .external_lex_state = 2},
  [202] = {.lex_state = 93, .external_lex_state = 2},
  [203] = {.lex_state = 93, .external_lex_state = 2},
  [204] = {.lex_state = 93, .external_lex_state = 2},
  [205] = {.lex_state = 93, .external_lex_state = 2},
  [206] = {.lex_state = 93, .external_lex_state = 2},
  [207] = {.lex_state = 93, .external_lex_state = 2},
  [208] = {.lex_state = 93, .external_lex_state = 2},
  [209] = {.lex_state = 93, .external_lex_state = 2},
  [210] = {.lex_state = 93, .external_lex_state = 2},
  [211] = {.lex_state = 93, .external_lex_state = 2},
  [212] = {.lex_state = 93, .external_lex_state = 2},
  [213] = {.lex_state = 93, .external_lex_state = 2},
  [214] = {.lex_state = 93, .external_lex_state = 2},
  [215] = {.lex_state = 93, .external_lex_state = 2},
  [216] = {.lex_state = 93, .external_lex_state = 2},
  [217] = {.lex_state = 93, .external_lex_state = 2},
  [218] = {.lex_state = 93, .external_lex_state = 2},
  [219] = {.lex_state = 93, .external_lex_state = 2},
  [220] = {.lex_state = 93, .external_lex_state = 2},
  [221] = {.lex_state = 93, .external_lex_state = 2},
  [222] = {.lex_state = 93, .external_lex_state = 2},
  [223] = {.lex_state = 93, .external_lex_state = 2},
  [224] = {.lex_state = 93, .external_lex_state = 2},
  [225] = {.lex_state = 93, .external_lex_state = 2},
  [226] = {.lex_state = 93, .external_lex_state = 2},
  [227] = {.lex_state = 93, .external_lex_state = 2},
  [228] = {.lex_state = 93, .external_lex_state = 2},
  [229] = {.lex_state = 93, .external_lex_state = 2},
  [230] = {.lex_state = 93, .external_lex_state = 2},
  [231] = {.lex_state = 93, .external_lex_state = 2},
  [232] = {.lex_state = 93, .external_lex_state = 2},
  [233] = {.lex_state = 93, .external_lex_state = 2},
  [234] = {.lex_state = 93, .external_lex_state = 2},
  [235] = {.lex_state = 93, .external_lex_state = 2},
  [236] = {.lex_state = 93, .external_lex_state = 2},
  [237] = {.lex_state = 93, .external_lex_state = 2},
  [238] = {.lex_state = 93, .external_lex_state = 2},
  [239] = {.lex_state = 93, .external_lex_state = 2},
  [240] = {.lex_state = 93, .external_lex_state = 2},
  [241] = {.lex_state = 93, .external_lex_state = 2},
  [242] = {.lex_state = 93, .external_lex_state = 2},
  [243] = {.lex_state = 93, .external_lex_state = 2},
  [244] = {.lex_state = 93, .external_lex_state = 2},
  [245] = {.lex_state = 93, .external_lex_state = 2},
  [246] = {.lex_state = 93, .external_lex_state = 2},
  [247] = {.lex_state = 93, .external_lex_state = 2},
  [248] = {.lex_state = 93, .external_lex_state = 2},
  [249] = {.lex_state = 93, .external_lex_state = 2},
  [250] = {.lex_state = 93, .external_lex_state = 2},
  [251] = {.lex_state = 93, .external_lex_state = 2},
  [252] = {.lex_state = 93, .external_lex_state = 2},
  [253] = {.lex_state = 93, .external_lex_state = 2},
  [254] = {.lex_state = 93, .external_lex_state = 2},
  [255] = {.lex_state = 93, .external_lex_state = 2},
  [256] = {.lex_state = 93, .external_lex_state = 2},
  [257] = {.lex_state = 93, .external_lex_state = 2},
  [258] = {.lex_state = 93, .external_lex_state = 2},
  [259] = {.lex_state = 93, .external_lex_state = 2},
  [260] = {.lex_state = 93, .external_lex_state = 2},
  [261] = {.lex_state = 93, .external_lex_state = 2},
  [262] = {.lex_state = 93, .external_lex_state = 2},
  [263] = {.lex_state = 93, .external_lex_state = 2},
  [264] = {.lex_state = 93, .external_lex_state = 2},
  [265] = {.lex_state = 93, .external_lex_state = 2},
  [266] = {.lex_state = 93, .external_lex_state = 2},
  [267] = {.lex_state = 93, .external_lex_state = 2},
  [268] = {.lex_state = 93, .external_lex_state = 2},
  [269] = {.lex_state = 93, .external_lex_state = 2},
  [270] = {.lex_state = 93, .external_lex_state = 2},
  [271] = {.lex_state = 93, .external_lex_state = 2},
  [272] = {.lex_state = 93, .external_lex_state = 2},
  [273] = {.lex_state = 93, .external_lex_state = 2},
  [274] = {.lex_state = 93, .external_lex_state = 2},
  [275] = {.lex_state = 93, .external_lex_state = 2},
  [276] = {.lex_state = 93, .external_lex_state = 2},
  [277] = {.lex_state = 93, .external_lex_state = 2},
  [278] = {.lex_state = 93, .external_lex_state = 2},
  [279] = {.lex_state = 93, .external_lex_state = 2},
  [280] = {.lex_state = 93, .external_lex_state = 2},
  [281] = {.lex_state = 93, .external_lex_state = 2},
  [282] = {.lex_state = 93, .external_lex_state = 2},
  [283] = {.lex_state = 93, .external_lex_state = 2},
  [284] = {.lex_state = 93, .external_lex_state = 2},
  [285] = {.lex_state = 93, .external_lex_state = 2},
  [286] = {.lex_state = 93, .external_lex_state = 2},
  [287] = {.lex_state = 93, .external_lex_state = 2},
  [288] = {.lex_state = 93, .external_lex_state = 2},
  [289] = {.lex_state = 93, .external_lex_state = 2},
  [290] = {.lex_state = 93, .external_lex_state = 2},
  [291] = {.lex_state = 93, .external_lex_state = 2},
  [292] = {.lex_state = 93, .external_lex_state = 2},
  [293] = {.lex_state = 93, .external_lex_state = 2},
  [294] = {.lex_state = 93, .external_lex_state = 2},
  [295] = {.lex_state = 93, .external_lex_state = 2},
  [296] = {.lex_state = 93, .external_lex_state = 2},
  [297] = {.lex_state = 93, .external_lex_state = 2},
  [298] = {.lex_state = 93, .external_lex_state = 2},
  [299] = {.lex_state = 93, .external_lex_state = 2},
  [300] = {.lex_state = 93, .external_lex_state = 2},
  [301] = {.lex_state = 93, .external_lex_state = 2},
  [302] = {.lex_state = 93, .external_lex_state = 2},
  [303] = {.lex_state = 93, .external_lex_state = 2},
  [304] = {.lex_state = 93, .external_lex_state = 2},
  [305] = {.lex_state = 93, .external_lex_state = 2},
  [306] = {.lex_state = 93, .external_lex_state = 2},
  [307] = {.lex_state = 93, .external_lex_state = 2},
  [308] = {.lex_state = 93, .external_lex_state = 2},
  [309] = {.lex_state = 93, .external_lex_state = 2},
  [310] = {.lex_state = 93, .external_lex_state = 2},
  [311] = {.lex_state = 93, .external_lex_state = 2},
  [312] = {.lex_state = 93, .external_lex_state = 2},
  [313] = {.lex_state = 93, .external_lex_state = 2},
  [314] = {.lex_state = 93, .external_lex_state = 2},
  [315] = {.lex_state = 93, .external_lex_state = 2},
  [316] = {.lex_state = 93, .external_lex_state = 2},
  [317] = {.lex_state = 93, .external_lex_state = 2},
  [318] = {.lex_state = 93, .external_lex_state = 2},
  [319] = {.lex_state = 93, .external_lex_state = 2},
  [320] = {.lex_state = 93, .external_lex_state = 2},
  [321] = {.lex_state = 93, .external_lex_state = 2},
  [322] = {.lex_state = 93, .external_lex_state = 2},
  [323] = {.lex_state = 93, .external_lex_state = 2},
  [324] = {.lex_state = 93, .external_lex_state = 2},
  [325] = {.lex_state = 93, .external_lex_state = 2},
  [326] = {.lex_state = 93, .external_lex_state = 2},
  [327] = {.lex_state = 93, .external_lex_state = 2},
  [328] = {.lex_state = 93, .external_lex_state = 2},
  [329] = {.lex_state = 93, .external_lex_state = 2},
  [330] = {.lex_state = 93, .external_lex_state = 2},
  [331] = {.lex_state = 93, .external_lex_state = 2},
  [332] = {.lex_state = 93, .external_lex_state = 2},
  [333] = {.lex_state = 93, .external_lex_state = 2},
  [334] = {.lex_state = 93, .external_lex_state = 2},
  [335] = {.lex_state = 93, .external_lex_state = 2},
  [336] = {.lex_state = 93, .external_lex_state = 2},
  [337] = {.lex_state = 93, .external_lex_state = 2},
  [338] = {.lex_state = 93, .external_lex_state = 2},
  [339] = {.lex_state = 93, .external_lex_state = 2},
  [340] = {.lex_state = 93, .external_lex_state = 2},
  [341] = {.lex_state = 93, .external_lex_state = 2},
  [342] = {.lex_state = 93, .external_lex_state = 2},
  [343] = {.lex_state = 93, .external_lex_state = 2},
  [344] = {.lex_state = 93, .external_lex_state = 2},
  [345] = {.lex_state = 93, .external_lex_state = 2},
  [346] = {.lex_state = 93, .external_lex_state = 2},
  [347] = {.lex_state = 93, .external_lex_state = 2},
  [348] = {.lex_state = 93, .external_lex_state = 2},
  [349] = {.lex_state = 93, .external_lex_state = 2},
  [350] = {.lex_state = 93, .external_lex_state = 2},
  [351] = {.lex_state = 93, .external_lex_state = 2},
  [352] = {.lex_state = 93, .external_lex_state = 2},
  [353] = {.lex_state = 93, .external_lex_state = 2},
  [354] = {.lex_state = 93, .external_lex_state = 2},
  [355] = {.lex_state = 93, .external_lex_state = 2},
  [356] = {.lex_state = 93, .external_lex_state = 2},
  [357] = {.lex_state = 93, .external_lex_state = 2},
  [358] = {.lex_state = 93, .external_lex_state = 2},
  [359] = {.lex_state = 93, .external_lex_state = 2},
  [360] = {.lex_state = 93, .external_lex_state = 2},
  [361] = {.lex_state = 93, .external_lex_state = 2},
  [362] = {.lex_state = 93, .external_lex_state = 2},
  [363] = {.lex_state = 93, .external_lex_state = 2},
  [364] = {.lex_state = 93, .external_lex_state = 2},
  [365] = {.lex_state = 93, .external_lex_state = 2},
  [366] = {.lex_state = 93, .external_lex_state = 2},
  [367] = {.lex_state = 93, .external_lex_state = 2},
  [368] = {.lex_state = 93, .external_lex_state = 2},
  [369] = {.lex_state = 93, .external_lex_state = 2},
  [370] = {.lex_state = 93, .external_lex_state = 2},
  [371] = {.lex_state = 93, .external_lex_state = 2},
  [372] = {.lex_state = 93, .external_lex_state = 2},
  [373] = {.lex_state = 93, .external_lex_state = 2},
  [374] = {.lex_state = 93, .external_lex_state = 2},
  [375] = {.lex_state = 93, .external_lex_state = 2},
  [376] = {.lex_state = 93, .external_lex_state = 2},
  [377] = {.lex_state = 93, .external_lex_state = 2},
  [378] = {.lex_state = 93, .external_lex_state = 2},
  [379] = {.lex_state = 93, .external_lex_state = 2},
  [380] = {.lex_state = 93, .external_lex_state = 2},
  [381] = {.lex_state = 93, .external_lex_state = 2},
  [382] = {.lex_state = 93, .external_lex_state = 2},
  [383] = {.lex_state = 93, .external_lex_state = 2},
  [384] = {.lex_state = 93, .external_lex_state = 2},
  [385] = {.lex_state = 93, .external_lex_state = 2},
  [386] = {.lex_state = 93, .external_lex_state = 2},
  [387] = {.lex_state = 93, .external_lex_state = 2},
  [388] = {.lex_state = 93, .external_lex_state = 2},
  [389] = {.lex_state = 93, .external_lex_state = 2},
  [390] = {.lex_state = 93, .external_lex_state = 2},
  [391] = {.lex_state = 93, .external_lex_state = 2},
  [392] = {.lex_state = 93, .external_lex_state = 2},
  [393] = {.lex_state = 93, .external_lex_state = 2},
  [394] = {.lex_state = 93, .external_lex_state = 2},
  [395] = {.lex_state = 93, .external_lex_state = 2},
  [396] = {.lex_state = 93, .external_lex_state = 2},
  [397] = {.lex_state = 93, .external_lex_state = 2},
  [398] = {.lex_state = 93, .external_lex_state = 2},
  [399] = {.lex_state = 93, .external_lex_state = 2},
  [400] = {.lex_state = 93, .external_lex_state = 2},
  [401] = {.lex_state = 93, .external_lex_state = 2},
  [402] = {.lex_state = 93, .external_lex_state = 2},
  [403] = {.lex_state = 93, .external_lex_state = 2},
  [404] = {.lex_state = 93, .external_lex_state = 2},
  [405] = {.lex_state = 93, .external_lex_state = 2},
  [406] = {.lex_state = 93, .external_lex_state = 2},
  [407] = {.lex_state = 93, .external_lex_state = 2},
  [408] = {.lex_state = 93, .external_lex_state = 2},
  [409] = {.lex_state = 93, .external_lex_state = 2},
  [410] = {.lex_state = 93, .external_lex_state = 2},
  [411] = {.lex_state = 93, .external_lex_state = 2},
  [412] = {.lex_state = 93, .external_lex_state = 2},
  [413] = {.lex_state = 93, .external_lex_state = 2},
  [414] = {.lex_state = 93, .external_lex_state = 2},
  [415] = {.lex_state = 93, .external_lex_state = 2},
  [416] = {.lex_state = 93, .external_lex_state = 2},
  [417] = {.lex_state = 93, .external_lex_state = 2},
  [418] = {.lex_state = 93, .external_lex_state = 2},
  [419] = {.lex_state = 93, .external_lex_state = 2},
  [420] = {.lex_state = 93, .external_lex_state = 2},
  [421] = {.lex_state = 93, .external_lex_state = 2},
  [422] = {.lex_state = 93, .external_lex_state = 2},
  [423] = {.lex_state = 93, .external_lex_state = 2},
  [424] = {.lex_state = 93, .external_lex_state = 2},
  [425] = {.lex_state = 93, .external_lex_state = 2},
  [426] = {.lex_state = 93, .external_lex_state = 2},
  [427] = {.lex_state = 93, .external_lex_state = 2},
  [428] = {.lex_state = 93, .external_lex_state = 2},
  [429] = {.lex_state = 93, .external_lex_state = 2},
  [430] = {.lex_state = 93, .external_lex_state = 2},
  [431] = {.lex_state = 93, .external_lex_state = 2},
  [432] = {.lex_state = 93, .external_lex_state = 2},
  [433] = {.lex_state = 93, .external_lex_state = 2},
  [434] = {.lex_state = 93, .external_lex_state = 2},
  [435] = {.lex_state = 93, .external_lex_state = 2},
  [436] = {.lex_state = 93, .external_lex_state = 2},
  [437] = {.lex_state = 93, .external_lex_state = 2},
  [438] = {.lex_state = 93, .external_lex_state = 2},
  [439] = {.lex_state = 93, .external_lex_state = 2},
  [440] = {.lex_state = 93, .external_lex_state = 2},
  [441] = {.lex_state = 93, .external_lex_state = 2},
  [442] = {.lex_state = 93, .external_lex_state = 2},
  [443] = {.lex_state = 93, .external_lex_state = 2},
  [444] = {.lex_state = 93, .external_lex_state = 2},
  [445] = {.lex_state = 93, .external_lex_state = 2},
  [446] = {.lex_state = 93, .external_lex_state = 2},
  [447] = {.lex_state = 93, .external_lex_state = 2},
  [448] = {.lex_state = 93, .external_lex_state = 2},
  [449] = {.lex_state = 93, .external_lex_state = 2},
  [450] = {.lex_state = 93, .external_lex_state = 2},
  [451] = {.lex_state = 93, .external_lex_state = 2},
  [452] = {.lex_state = 93, .external_lex_state = 2},
  [453] = {.lex_state = 93, .external_lex_state = 2},
  [454] = {.lex_state = 93, .external_lex_state = 2},
  [455] = {.lex_state = 93, .external_lex_state = 2},
  [456] = {.lex_state = 93, .external_lex_state = 2},
  [457] = {.lex_state = 93, .external_lex_state = 2},
  [458] = {.lex_state = 93, .external_lex_state = 2},
  [459] = {.lex_state = 93, .external_lex_state = 2},
  [460] = {.lex_state = 93, .external_lex_state = 2},
  [461] = {.lex_state = 93, .external_lex_state = 2},
  [462] = {.lex_state = 93, .external_lex_state = 2},
  [463] = {.lex_state = 93, .external_lex_state = 2},
  [464] = {.lex_state = 93, .external_lex_state = 2},
  [465] = {.lex_state = 93, .external_lex_state = 2},
  [466] = {.lex_state = 93, .external_lex_state = 2},
  [467] = {.lex_state = 93, .external_lex_state = 2},
  [468] = {.lex_state = 93, .external_lex_state = 2},
  [469] = {.lex_state = 93, .external_lex_state = 2},
  [470] = {.lex_state = 93, .external_lex_state = 2},
  [471] = {.lex_state = 93, .external_lex_state = 2},
  [472] = {.lex_state = 93, .external_lex_state = 2},
  [473] = {.lex_state = 93, .external_lex_state = 2},
  [474] = {.lex_state = 93, .external_lex_state = 2},
  [475] = {.lex_state = 93, .external_lex_state = 2},
  [476] = {.lex_state = 93, .external_lex_state = 2},
  [477] = {.lex_state = 93, .external_lex_state = 2},
  [478] = {.lex_state = 93, .external_lex_state = 2},
  [479] = {.lex_state = 93, .external_lex_state = 2},
  [480] = {.lex_state = 93, .external_lex_state = 2},
  [481] = {.lex_state = 93, .external_lex_state = 2},
  [482] = {.lex_state = 93, .external_lex_state = 2},
  [483] = {.lex_state = 93, .external_lex_state = 2},
  [484] = {.lex_state = 93, .external_lex_state = 2},
  [485] = {.lex_state = 93, .external_lex_state = 2},
  [486] = {.lex_state = 93, .external_lex_state = 2},
  [487] = {.lex_state = 93, .external_lex_state = 2},
  [488] = {.lex_state = 93, .external_lex_state = 2},
  [489] = {.lex_state = 93, .external_lex_state = 2},
  [490] = {.lex_state = 93, .external_lex_state = 2},
  [491] = {.lex_state = 93, .external_lex_state = 2},
  [492] = {.lex_state = 93, .external_lex_state = 2},
  [493] = {.lex_state = 93, .external_lex_state = 2},
  [494] = {.lex_state = 93, .external_lex_state = 2},
  [495] = {.lex_state = 93, .external_lex_state = 2},
  [496] = {.lex_state = 93, .external_lex_state = 2},
  [497] = {.lex_state = 93, .external_lex_state = 2},
  [498] = {.lex_state = 93, .external_lex_state = 2},
  [499] = {.lex_state = 93, .external_lex_state = 2},
  [500] = {.lex_state = 93, .external_lex_state = 2},
  [501] = {.lex_state = 93, .external_lex_state = 2},
  [502] = {.lex_state = 93, .external_lex_state = 2},
  [503] = {.lex_state = 93, .external_lex_state = 2},
  [504] = {.lex_state = 93, .external_lex_state = 2},
  [505] = {.lex_state = 93, .external_lex_state = 2},
  [506] = {.lex_state = 93, .external_lex_state = 2},
  [507] = {.lex_state = 93, .external_lex_state = 2},
  [508] = {.lex_state = 93, .external_lex_state = 2},
  [509] = {.lex_state = 93, .external_lex_state = 2},
  [510] = {.lex_state = 93, .external_lex_state = 2},
  [511] = {.lex_state = 93, .external_lex_state = 2},
  [512] = {.lex_state = 93, .external_lex_state = 2},
  [513] = {.lex_state = 93, .external_lex_state = 2},
  [514] = {.lex_state = 93, .external_lex_state = 2},
  [515] = {.lex_state = 93, .external_lex_state = 2},
  [516] = {.lex_state = 93, .external_lex_state = 2},
  [517] = {.lex_state = 93, .external_lex_state = 2},
  [518] = {.lex_state = 93, .external_lex_state = 2},
  [519] = {.lex_state = 93, .external_lex_state = 2},
  [520] = {.lex_state = 93, .external_lex_state = 2},
  [521] = {.lex_state = 93, .external_lex_state = 2},
  [522] = {.lex_state = 93, .external_lex_state = 2},
  [523] = {.lex_state = 93, .external_lex_state = 2},
  [524] = {.lex_state = 93, .external_lex_state = 2},
  [525] = {.lex_state = 93, .external_lex_state = 2},
  [526] = {.lex_state = 93, .external_lex_state = 2},
  [527] = {.lex_state = 93, .external_lex_state = 2},
  [528] = {.lex_state = 93, .external_lex_state = 2},
  [529] = {.lex_state = 93, .external_lex_state = 2},
  [530] = {.lex_state = 93, .external_lex_state = 2},
  [531] = {.lex_state = 93, .external_lex_state = 2},
  [532] = {.lex_state = 93, .external_lex_state = 2},
  [533] = {.lex_state = 93, .external_lex_state = 2},
  [534] = {.lex_state = 93, .external_lex_state = 2},
  [535] = {.lex_state = 93, .external_lex_state = 2},
  [536] = {.lex_state = 93, .external_lex_state = 2},
  [537] = {.lex_state = 93, .external_lex_state = 2},
  [538] = {.lex_state = 93, .external_lex_state = 2},
  [539] = {.lex_state = 93, .external_lex_state = 2},
  [540] = {.lex_state = 93, .external_lex_state = 2},
  [541] = {.lex_state = 93, .external_lex_state = 2},
  [542] = {.lex_state = 93, .external_lex_state = 2},
  [543] = {.lex_state = 93, .external_lex_state = 2},
  [544] = {.lex_state = 93, .external_lex_state = 2},
  [545] = {.lex_state = 93, .external_lex_state = 2},
  [546] = {.lex_state = 93, .external_lex_state = 2},
  [547] = {.lex_state = 93, .external_lex_state = 2},
  [548] = {.lex_state = 93, .external_lex_state = 2},
  [549] = {.lex_state = 93, .external_lex_state = 2},
  [550] = {.lex_state = 93, .external_lex_state = 2},
  [551] = {.lex_state = 93, .external_lex_state = 2},
  [552] = {.lex_state = 93, .external_lex_state = 2},
  [553] = {.lex_state = 93, .external_lex_state = 2},
  [554] = {.lex_state = 93, .external_lex_state = 2},
  [555] = {.lex_state = 93, .external_lex_state = 2},
  [556] = {.lex_state = 93, .external_lex_state = 2},
  [557] = {.lex_state = 93, .external_lex_state = 2},
  [558] = {.lex_state = 93, .external_lex_state = 2},
  [559] = {.lex_state = 93, .external_lex_state = 2},
  [560] = {.lex_state = 93, .external_lex_state = 2},
  [561] = {.lex_state = 93, .external_lex_state = 2},
  [562] = {.lex_state = 93, .external_lex_state = 2},
  [563] = {.lex_state = 93, .external_lex_state = 2},
  [564] = {.lex_state = 93, .external_lex_state = 2},
  [565] = {.lex_state = 93, .external_lex_state = 2},
  [566] = {.lex_state = 93, .external_lex_state = 2},
  [567] = {.lex_state = 93, .external_lex_state = 2},
  [568] = {.lex_state = 93, .external_lex_state = 2},
  [569] = {.lex_state = 93, .external_lex_state = 2},
  [570] = {.lex_state = 93, .external_lex_state = 2},
  [571] = {.lex_state = 93, .external_lex_state = 2},
  [572] = {.lex_state = 93, .external_lex_state = 2},
  [573] = {.lex_state = 93, .external_lex_state = 2},
  [574] = {.lex_state = 93, .external_lex_state = 2},
  [575] = {.lex_state = 93, .external_lex_state = 2},
  [576] = {.lex_state = 93, .external_lex_state = 2},
  [577] = {.lex_state = 93, .external_lex_state = 2},
  [578] = {.lex_state = 93, .external_lex_state = 2},
  [579] = {.lex_state = 93, .external_lex_state = 2},
  [580] = {.lex_state = 93, .external_lex_state = 2},
  [581] = {.lex_state = 93, .external_lex_state = 2},
  [582] = {.lex_state = 93, .external_lex_state = 2},
  [583] = {.lex_state = 93, .external_lex_state = 2},
  [584] = {.lex_state = 93, .external_lex_state = 2},
  [585] = {.lex_state = 93, .external_lex_state = 2},
  [586] = {.lex_state = 93, .external_lex_state = 2},
  [587] = {.lex_state = 93, .external_lex_state = 2},
  [588] = {.lex_state = 93, .external_lex_state = 2},
  [589] = {.lex_state = 93, .external_lex_state = 2},
  [590] = {.lex_state = 93, .external_lex_state = 2},
  [591] = {.lex_state = 93, .external_lex_state = 2},
  [592] = {.lex_state = 93, .external_lex_state = 2},
  [593] = {.lex_state = 93, .external_lex_state = 2},
  [594] = {.lex_state = 93, .external_lex_state = 2},
  [595] = {.lex_state = 93, .external_lex_state = 2},
  [596] = {.lex_state = 93, .external_lex_state = 2},
  [597] = {.lex_state = 93, .external_lex_state = 2},
  [598] = {.lex_state = 93, .external_lex_state = 2},
  [599] = {.lex_state = 93, .external_lex_state = 2},
  [600] = {.lex_state = 93, .external_lex_state = 2},
  [601] = {.lex_state = 93, .external_lex_state = 2},
  [602] = {.lex_state = 93, .external_lex_state = 2},
  [603] = {.lex_state = 93, .external_lex_state = 2},
  [604] = {.lex_state = 93, .external_lex_state = 2},
  [605] = {.lex_state = 93, .external_lex_state = 2},
  [606] = {.lex_state = 93, .external_lex_state = 2},
  [607] = {.lex_state = 93, .external_lex_state = 2},
  [608] = {.lex_state = 93, .external_lex_state = 2},
  [609] = {.lex_state = 93, .external_lex_state = 2},
  [610] = {.lex_state = 93, .external_lex_state = 2},
  [611] = {.lex_state = 93, .external_lex_state = 2},
  [612] = {.lex_state = 93, .external_lex_state = 2},
  [613] = {.lex_state = 93, .external_lex_state = 2},
  [614] = {.lex_state = 93, .external_lex_state = 2},
  [615] = {.lex_state = 93, .external_lex_state = 2},
  [616] = {.lex_state = 93, .external_lex_state = 2},
  [617] = {.lex_state = 93, .external_lex_state = 2},
  [618] = {.lex_state = 93, .external_lex_state = 2},
  [619] = {.lex_state = 93, .external_lex_state = 2},
  [620] = {.lex_state = 93, .external_lex_state = 2},
  [621] = {.lex_state = 93, .external_lex_state = 2},
  [622] = {.lex_state = 93, .external_lex_state = 2},
  [623] = {.lex_state = 93, .external_lex_state = 2},
  [624] = {.lex_state = 93, .external_lex_state = 2},
  [625] = {.lex_state = 93, .external_lex_state = 2},
  [626] = {.lex_state = 93, .external_lex_state = 2},
  [627] = {.lex_state = 93, .external_lex_state = 2},
  [628] = {.lex_state = 93, .external_lex_state = 2},
  [629] = {.lex_state = 93, .external_lex_state = 2},
  [630] = {.lex_state = 93, .external_lex_state = 2},
  [631] = {.lex_state = 93, .external_lex_state = 2},
  [632] = {.lex_state = 93, .external_lex_state = 2},
  [633] = {.lex_state = 93, .external_lex_state = 2},
  [634] = {.lex_state = 93, .external_lex_state = 2},
  [635] = {.lex_state = 93, .external_lex_state = 2},
  [636] = {.lex_state = 93, .external_lex_state = 2},
  [637] = {.lex_state = 93, .external_lex_state = 2},
  [638] = {.lex_state = 93, .external_lex_state = 2},
  [639] = {.lex_state = 93, .external_lex_state = 2},
  [640] = {.lex_state = 93, .external_lex_state = 2},
  [641] = {.lex_state = 93, .external_lex_state = 2},
  [642] = {.lex_state = 93, .external_lex_state = 2},
  [643] = {.lex_state = 93, .external_lex_state = 2},
  [644] = {.lex_state = 93, .external_lex_state = 2},
  [645] = {.lex_state = 93, .external_lex_state = 2},
  [646] = {.lex_state = 93, .external_lex_state = 2},
  [647] = {.lex_state = 93, .external_lex_state = 2},
  [648] = {.lex_state = 93, .external_lex_state = 2},
  [649] = {.lex_state = 93, .external_lex_state = 2},
  [650] = {.lex_state = 93, .external_lex_state = 2},
  [651] = {.lex_state = 93, .external_lex_state = 2},
  [652] = {.lex_state = 93, .external_lex_state = 2},
  [653] = {.lex_state = 93, .external_lex_state = 2},
  [654] = {.lex_state = 93, .external_lex_state = 2},
  [655] = {.lex_state = 93, .external_lex_state = 2},
  [656] = {.lex_state = 93, .external_lex_state = 2},
  [657] = {.lex_state = 93, .external_lex_state = 2},
  [658] = {.lex_state = 93, .external_lex_state = 2},
  [659] = {.lex_state = 93, .external_lex_state = 2},
  [660] = {.lex_state = 93, .external_lex_state = 2},
  [661] = {.lex_state = 93, .external_lex_state = 2},
  [662] = {.lex_state = 93, .external_lex_state = 2},
  [663] = {.lex_state = 93, .external_lex_state = 2},
  [664] = {.lex_state = 93, .external_lex_state = 2},
  [665] = {.lex_state = 93, .external_lex_state = 2},
  [666] = {.lex_state = 93, .external_lex_state = 2},
  [667] = {.lex_state = 93, .external_lex_state = 2},
  [668] = {.lex_state = 93, .external_lex_state = 2},
  [669] = {.lex_state = 93, .external_lex_state = 2},
  [670] = {.lex_state = 93, .external_lex_state = 2},
  [671] = {.lex_state = 93, .external_lex_state = 2},
  [672] = {.lex_state = 93, .external_lex_state = 2},
  [673] = {.lex_state = 93, .external_lex_state = 2},
  [674] = {.lex_state = 93, .external_lex_state = 2},
  [675] = {.lex_state = 93, .external_lex_state = 2},
  [676] = {.lex_state = 93, .external_lex_state = 2},
  [677] = {.lex_state = 93, .external_lex_state = 2},
  [678] = {.lex_state = 93, .external_lex_state = 2},
  [679] = {.lex_state = 93, .external_lex_state = 2},
  [680] = {.lex_state = 93, .external_lex_state = 2},
  [681] = {.lex_state = 93, .external_lex_state = 2},
  [682] = {.lex_state = 93, .external_lex_state = 2},
  [683] = {.lex_state = 93, .external_lex_state = 2},
  [684] = {.lex_state = 93, .external_lex_state = 2},
  [685] = {.lex_state = 93, .external_lex_state = 2},
  [686] = {.lex_state = 93, .external_lex_state = 2},
  [687] = {.lex_state = 93, .external_lex_state = 2},
  [688] = {.lex_state = 93, .external_lex_state = 2},
  [689] = {.lex_state = 93, .external_lex_state = 2},
  [690] = {.lex_state = 93, .external_lex_state = 2},
  [691] = {.lex_state = 93, .external_lex_state = 2},
  [692] = {.lex_state = 93, .external_lex_state = 2},
  [693] = {.lex_state = 93, .external_lex_state = 2},
  [694] = {.lex_state = 93, .external_lex_state = 2},
  [695] = {.lex_state = 93, .external_lex_state = 2},
  [696] = {.lex_state = 93, .external_lex_state = 2},
  [697] = {.lex_state = 93, .external_lex_state = 2},
  [698] = {.lex_state = 93, .external_lex_state = 2},
  [699] = {.lex_state = 93, .external_lex_state = 2},
  [700] = {.lex_state = 93, .external_lex_state = 2},
  [701] = {.lex_state = 93, .external_lex_state = 2},
  [702] = {.lex_state = 93, .external_lex_state = 2},
  [703] = {.lex_state = 93, .external_lex_state = 2},
  [704] = {.lex_state = 93, .external_lex_state = 2},
  [705] = {.lex_state = 93, .external_lex_state = 2},
  [706] = {.lex_state = 93, .external_lex_state = 2},
  [707] = {.lex_state = 93, .external_lex_state = 2},
  [708] = {.lex_state = 93, .external_lex_state = 2},
  [709] = {.lex_state = 93, .external_lex_state = 2},
  [710] = {.lex_state = 93, .external_lex_state = 2},
  [711] = {.lex_state = 93, .external_lex_state = 2},
  [712] = {.lex_state = 93, .external_lex_state = 2},
  [713] = {.lex_state = 93, .external_lex_state = 2},
  [714] = {.lex_state = 93, .external_lex_state = 2},
  [715] = {.lex_state = 93, .external_lex_state = 2},
  [716] = {.lex_state = 93, .external_lex_state = 2},
  [717] = {.lex_state = 93, .external_lex_state = 2},
  [718] = {.lex_state = 93, .external_lex_state = 2},
  [719] = {.lex_state = 93, .external_lex_state = 2},
  [720] = {.lex_state = 93, .external_lex_state = 2},
  [721] = {.lex_state = 93, .external_lex_state = 2},
  [722] = {.lex_state = 93, .external_lex_state = 2},
  [723] = {.lex_state = 93, .external_lex_state = 2},
  [724] = {.lex_state = 93, .external_lex_state = 2},
  [725] = {.lex_state = 93, .external_lex_state = 2},
  [726] = {.lex_state = 93, .external_lex_state = 2},
  [727] = {.lex_state = 93, .external_lex_state = 2},
  [728] = {.lex_state = 93, .external_lex_state = 2},
  [729] = {.lex_state = 93, .external_lex_state = 2},
  [730] = {.lex_state = 93, .external_lex_state = 2},
  [731] = {.lex_state = 93, .external_lex_state = 2},
  [732] = {.lex_state = 93, .external_lex_state = 2},
  [733] = {.lex_state = 93, .external_lex_state = 2},
  [734] = {.lex_state = 93, .external_lex_state = 2},
  [735] = {.lex_state = 93, .external_lex_state = 2},
  [736] = {.lex_state = 93, .external_lex_state = 2},
  [737] = {.lex_state = 93, .external_lex_state = 2},
  [738] = {.lex_state = 93, .external_lex_state = 2},
  [739] = {.lex_state = 93, .external_lex_state = 2},
  [740] = {.lex_state = 93, .external_lex_state = 2},
  [741] = {.lex_state = 93, .external_lex_state = 2},
  [742] = {.lex_state = 93, .external_lex_state = 2},
  [743] = {.lex_state = 93, .external_lex_state = 2},
  [744] = {.lex_state = 93, .external_lex_state = 2},
  [745] = {.lex_state = 93, .external_lex_state = 2},
  [746] = {.lex_state = 93, .external_lex_state = 2},
  [747] = {.lex_state = 93, .external_lex_state = 2},
  [748] = {.lex_state = 93, .external_lex_state = 2},
  [749] = {.lex_state = 93, .external_lex_state = 2},
  [750] = {.lex_state = 93, .external_lex_state = 2},
  [751] = {.lex_state = 93, .external_lex_state = 2},
  [752] = {.lex_state = 93, .external_lex_state = 2},
  [753] = {.lex_state = 93, .external_lex_state = 2},
  [754] = {.lex_state = 93, .external_lex_state = 2},
  [755] = {.lex_state = 93, .external_lex_state = 2},
  [756] = {.lex_state = 93, .external_lex_state = 2},
  [757] = {.lex_state = 93, .external_lex_state = 2},
  [758] = {.lex_state = 93, .external_lex_state = 2},
  [759] = {.lex_state = 93, .external_lex_state = 2},
  [760] = {.lex_state = 93, .external_lex_state = 2},
  [761] = {.lex_state = 93, .external_lex_state = 2},
  [762] = {.lex_state = 93, .external_lex_state = 2},
  [763] = {.lex_state = 93, .external_lex_state = 2},
  [764] = {.lex_state = 93, .external_lex_state = 2},
  [765] = {.lex_state = 93, .external_lex_state = 2},
  [766] = {.lex_state = 93, .external_lex_state = 2},
  [767] = {.lex_state = 93, .external_lex_state = 2},
  [768] = {.lex_state = 93, .external_lex_state = 2},
  [769] = {.lex_state = 93, .external_lex_state = 2},
  [770] = {.lex_state = 93, .external_lex_state = 2},
  [771] = {.lex_state = 93, .external_lex_state = 2},
  [772] = {.lex_state = 93, .external_lex_state = 2},
  [773] = {.lex_state = 93, .external_lex_state = 2},
  [774] = {.lex_state = 93, .external_lex_state = 2},
  [775] = {.lex_state = 93, .external_lex_state = 2},
  [776] = {.lex_state = 93, .external_lex_state = 2},
  [777] = {.lex_state = 93, .external_lex_state = 2},
  [778] = {.lex_state = 93, .external_lex_state = 2},
  [779] = {.lex_state = 93, .external_lex_state = 2},
  [780] = {.lex_state = 93, .external_lex_state = 2},
  [781] = {.lex_state = 93, .external_lex_state = 2},
  [782] = {.lex_state = 93, .external_lex_state = 2},
  [783] = {.lex_state = 93, .external_lex_state = 2},
  [784] = {.lex_state = 93, .external_lex_state = 2},
  [785] = {.lex_state = 93, .external_lex_state = 2},
  [786] = {.lex_state = 93, .external_lex_state = 2},
  [787] = {.lex_state = 93, .external_lex_state = 2},
  [788] = {.lex_state = 93, .external_lex_state = 2},
  [789] = {.lex_state = 93, .external_lex_state = 2},
  [790] = {.lex_state = 93, .external_lex_state = 2},
  [791] = {.lex_state = 93, .external_lex_state = 2},
  [792] = {.lex_state = 93, .external_lex_state = 2},
  [793] = {.lex_state = 93, .external_lex_state = 2},
  [794] = {.lex_state = 93, .external_lex_state = 2},
  [795] = {.lex_state = 93, .external_lex_state = 2},
  [796] = {.lex_state = 93, .external_lex_state = 2},
  [797] = {.lex_state = 93, .external_lex_state = 2},
  [798] = {.lex_state = 93, .external_lex_state = 2},
  [799] = {.lex_state = 93, .external_lex_state = 2},
  [800] = {.lex_state = 93, .external_lex_state = 2},
  [801] = {.lex_state = 93, .external_lex_state = 2},
  [802] = {.lex_state = 93, .external_lex_state = 2},
  [803] = {.lex_state = 93, .external_lex_state = 2},
  [804] = {.lex_state = 93, .external_lex_state = 2},
  [805] = {.lex_state = 93, .external_lex_state = 2},
  [806] = {.lex_state = 93, .external_lex_state = 2},
  [807] = {.lex_state = 93, .external_lex_state = 2},
  [808] = {.lex_state = 93, .external_lex_state = 2},
  [809] = {.lex_state = 93, .external_lex_state = 2},
  [810] = {.lex_state = 93, .external_lex_state = 2},
  [811] = {.lex_state = 93, .external_lex_state = 2},
  [812] = {.lex_state = 93, .external_lex_state = 2},
  [813] = {.lex_state = 93, .external_lex_state = 2},
  [814] = {.lex_state = 78, .external_lex_state = 3},
  [815] = {.lex_state = 81, .external_lex_state = 3},
  [816] = {.lex_state = 10, .external_lex_state = 3},
  [817] = {.lex_state = 81, .external_lex_state = 4},
  [818] = {.lex_state = 81, .external_lex_state = 4},
  [819] = {.lex_state = 81, .external_lex_state = 4},
  [820] = {.lex_state = 81, .external_lex_state = 4},
  [821] = {.lex_state = 81, .external_lex_state = 4},
  [822] = {.lex_state = 81, .external_lex_state = 4},
  [823] = {.lex_state = 81, .external_lex_state = 4},
  [824] = {.lex_state = 81, .external_lex_state = 4},
  [825] = {.lex_state = 81, .external_lex_state = 4},
  [826] = {.lex_state = 81, .external_lex_state = 4},
  [827] = {.lex_state = 81, .external_lex_state = 4},
  [828] = {.lex_state = 81, .external_lex_state = 4},
  [829] = {.lex_state = 81, .external_lex_state = 4},
  [830] = {.lex_state = 81, .external_lex_state = 4},
  [831] = {.lex_state = 81, .external_lex_state = 4},
  [832] = {.lex_state = 81, .external_lex_state = 4},
  [833] = {.lex_state = 81, .external_lex_state = 4},
  [834] = {.lex_state = 81, .external_lex_state = 4},
  [835] = {.lex_state = 81, .external_lex_state = 4},
  [836] = {.lex_state = 81, .external_lex_state = 4},
  [837] = {.lex_state = 81, .external_lex_state = 4},
  [838] = {.lex_state = 81, .external_lex_state = 4},
  [839] = {.lex_state = 81, .external_lex_state = 4},
  [840] = {.lex_state = 81, .external_lex_state = 4},
  [841] = {.lex_state = 81, .external_lex_state = 4},
  [842] = {.lex_state = 81, .external_lex_state = 4},
  [843] = {.lex_state = 81, .external_lex_state = 4},
  [844] = {.lex_state = 13, .external_lex_state = 3},
  [845] = {.lex_state = 78, .external_lex_state = 4},
  [846] = {.lex_state = 81, .external_lex_state = 4},
  [847] = {.lex_state = 81, .external_lex_state = 4},
  [848] = {.lex_state = 81, .external_lex_state = 4},
  [849] = {.lex_state = 6, .external_lex_state = 3},
  [850] = {.lex_state = 81, .external_lex_state = 4},
  [851] = {.lex_state = 81, .external_lex_state = 4},
  [852] = {.lex_state = 81, .external_lex_state = 4},
  [853] = {.lex_state = 81, .external_lex_state = 4},
  [854] = {.lex_state = 81, .external_lex_state = 4},
  [855] = {.lex_state = 81, .external_lex_state = 4},
  [856] = {.lex_state = 81, .external_lex_state = 4},
  [857] = {.lex_state = 78, .external_lex_state = 3},
  [858] = {.lex_state = 80, .external_lex_state = 2},
  [859] = {.lex_state = 81, .external_lex_state = 4},
  [860] = {.lex_state = 81, .external_lex_state = 4},
  [861] = {.lex_state = 81, .external_lex_state = 4},
  [862] = {.lex_state = 81, .external_lex_state = 4},
  [863] = {.lex_state = 81, .external_lex_state = 4},
  [864] = {.lex_state = 81, .external_lex_state = 4},
  [865] = {.lex_state = 81, .external_lex_state = 4},
  [866] = {.lex_state = 81, .external_lex_state = 4},
  [867] = {.lex_state = 81, .external_lex_state = 4},
  [868] = {.lex_state = 81, .external_lex_state = 4},
  [869] = {.lex_state = 22, .external_lex_state = 3},
  [870] = {.lex_state = 81, .external_lex_state = 4},
  [871] = {.lex_state = 81, .external_lex_state = 4},
  [872] = {.lex_state = 81, .external_lex_state = 4},
  [873] = {.lex_state = 81, .external_lex_state = 4},
  [874] = {.lex_state = 6, .external_lex_state = 3},
  [875] = {.lex_state = 81, .external_lex_state = 2},
  [876] = {.lex_state = 81, .external_lex_state = 3},
  [877] = {.lex_state = 80, .external_lex_state = 2},
  [878] = {.lex_state = 18, .external_lex_state = 3},
  [879] = {.lex_state = 2, .external_lex_state = 3},
  [880] = {.lex_state = 80, .external_lex_state = 2},
  [881] = {.lex_state = 13, .external_lex_state = 4},
  [882] = {.lex_state = 80, .external_lex_state = 2},
  [883] = {.lex_state = 13, .external_lex_state = 4},
  [884] = {.lex_state = 13, .external_lex_state = 4},
  [885] = {.lex_state = 81, .external_lex_state = 2},
  [886] = {.lex_state = 13, .external_lex_state = 4},
  [887] = {.lex_state = 13, .external_lex_state = 4},
  [888] = {.lex_state = 84, .external_lex_state = 2},
  [889] = {.lex_state = 13, .external_lex_state = 4},
  [890] = {.lex_state = 13, .external_lex_state = 4},
  [891] = {.lex_state = 81, .external_lex_state = 2},
  [892] = {.lex_state = 13, .external_lex_state = 4},
  [893] = {.lex_state = 13, .external_lex_state = 4},
  [894] = {.lex_state = 81, .external_lex_state = 2},
  [895] = {.lex_state = 84, .external_lex_state = 4},
  [896] = {.lex_state = 84, .external_lex_state = 2},
  [897] = {.lex_state = 84, .external_lex_state = 2},
  [898] = {.lex_state = 13, .external_lex_state = 4},
  [899] = {.lex_state = 13, .external_lex_state = 4},
  [900] = {.lex_state = 81, .external_lex_state = 2},
  [901] = {.lex_state = 81, .external_lex_state = 2},
  [902] = {.lex_state = 81, .external_lex_state = 2},
  [903] = {.lex_state = 13, .external_lex_state = 4},
  [904] = {.lex_state = 81, .external_lex_state = 2},
  [905] = {.lex_state = 13, .external_lex_state = 4},
  [906] = {.lex_state = 13, .external_lex_state = 4},
  [907] = {.lex_state = 13, .external_lex_state = 4},
  [908] = {.lex_state = 13, .external_lex_state = 4},
  [909] = {.lex_state = 84, .external_lex_state = 2},
  [910] = {.lex_state = 81, .external_lex_state = 2},
  [911] = {.lex_state = 81, .external_lex_state = 2},
  [912] = {.lex_state = 13, .external_lex_state = 4},
  [913] = {.lex_state = 10, .external_lex_state = 4},
  [914] = {.lex_state = 13, .external_lex_state = 4},
  [915] = {.lex_state = 13, .external_lex_state = 4},
  [916] = {.lex_state = 81, .external_lex_state = 2},
  [917] = {.lex_state = 84, .external_lex_state = 2},
  [918] = {.lex_state = 84, .external_lex_state = 4},
  [919] = {.lex_state = 84, .external_lex_state = 4},
  [920] = {.lex_state = 84, .external_lex_state = 2},
  [921] = {.lex_state = 13, .external_lex_state = 4},
  [922] = {.lex_state = 84, .external_lex_state = 2},
  [923] = {.lex_state = 84, .external_lex_state = 2},
  [924] = {.lex_state = 84, .external_lex_state = 2},
  [925] = {.lex_state = 84, .external_lex_state = 2},
  [926] = {.lex_state = 13, .external_lex_state = 4},
  [927] = {.lex_state = 13, .external_lex_state = 4},
  [928] = {.lex_state = 13, .external_lex_state = 4},
  [929] = {.lex_state = 84, .external_lex_state = 2},
  [930] = {.lex_state = 22, .external_lex_state = 3},
  [931] = {.lex_state = 13, .external_lex_state = 4},
  [932] = {.lex_state = 84, .external_lex_state = 2},
  [933] = {.lex_state = 84, .external_lex_state = 2},
  [934] = {.lex_state = 84, .external_lex_state = 2},
  [935] = {.lex_state = 13, .external_lex_state = 4},
  [936] = {.lex_state = 13, .external_lex_state = 4},
  [937] = {.lex_state = 81, .external_lex_state = 2},
  [938] = {.lex_state = 84, .external_lex_state = 2},
  [939] = {.lex_state = 81, .external_lex_state = 2},
  [940] = {.lex_state = 13, .external_lex_state = 4},
  [941] = {.lex_state = 84, .external_lex_state = 2},
  [942] = {.lex_state = 84, .external_lex_state = 4},
  [943] = {.lex_state = 84, .external_lex_state = 2},
  [944] = {.lex_state = 84, .external_lex_state = 2},
  [945] = {.lex_state = 84, .external_lex_state = 2},
  [946] = {.lex_state = 84, .external_lex_state = 2},
  [947] = {.lex_state = 84, .external_lex_state = 2},
  [948] = {.lex_state = 13, .external_lex_state = 4},
  [949] = {.lex_state = 84, .external_lex_state = 2},
  [950] = {.lex_state = 84, .external_lex_state = 2},
  [951] = {.lex_state = 84, .external_lex_state = 2},
  [952] = {.lex_state = 13, .external_lex_state = 4},
  [953] = {.lex_state = 84, .external_lex_state = 2},
  [954] = {.lex_state = 84, .external_lex_state = 2},
  [955] = {.lex_state = 84, .external_lex_state = 2},
  [956] = {.lex_state = 84, .external_lex_state = 2},
  [957] = {.lex_state = 84, .external_lex_state = 2},
  [958] = {.lex_state = 84, .external_lex_state = 2},
  [959] = {.lex_state = 84, .external_lex_state = 2},
  [960] = {.lex_state = 84, .external_lex_state = 2},
  [961] = {.lex_state = 84, .external_lex_state = 2},
  [962] = {.lex_state = 84, .external_lex_state = 2},
  [963] = {.lex_state = 84, .external_lex_state = 2},
  [964] = {.lex_state = 84, .external_lex_state = 2},
  [965] = {.lex_state = 84, .external_lex_state = 2},
  [966] = {.lex_state = 84, .external_lex_state = 2},
  [967] = {.lex_state = 84, .external_lex_state = 2},
  [968] = {.lex_state = 84, .external_lex_state = 2},
  [969] = {.lex_state = 84, .external_lex_state = 2},
  [970] = {.lex_state = 84, .external_lex_state = 2},
  [971] = {.lex_state = 84, .external_lex_state = 2},
  [972] = {.lex_state = 84, .external_lex_state = 2},
  [973] = {.lex_state = 84, .external_lex_state = 2},
  [974] = {.lex_state = 84, .external_lex_state = 2},
  [975] = {.lex_state = 84, .external_lex_state = 2},
  [976] = {.lex_state = 84, .external_lex_state = 2},
  [977] = {.lex_state = 13, .external_lex_state = 4},
  [978] = {.lex_state = 13, .external_lex_state = 4},
  [979] = {.lex_state = 84, .external_lex_state = 2},
  [980] = {.lex_state = 84, .external_lex_state = 2},
  [981] = {.lex_state = 84, .external_lex_state = 2},
  [982] = {.lex_state = 84, .external_lex_state = 2},
  [983] = {.lex_state = 84, .external_lex_state = 2},
  [984] = {.lex_state = 84, .external_lex_state = 2},
  [985] = {.lex_state = 84, .external_lex_state = 2},
  [986] = {.lex_state = 84, .external_lex_state = 2},
  [987] = {.lex_state = 81, .external_lex_state = 4},
  [988] = {.lex_state = 84, .external_lex_state = 2},
  [989] = {.lex_state = 84, .external_lex_state = 2},
  [990] = {.lex_state = 84, .external_lex_state = 2},
  [991] = {.lex_state = 84, .external_lex_state = 2},
  [992] = {.lex_state = 84, .external_lex_state = 2},
  [993] = {.lex_state = 84, .external_lex_state = 2},
  [994] = {.lex_state = 84, .external_lex_state = 2},
  [995] = {.lex_state = 84, .external_lex_state = 2},
  [996] = {.lex_state = 84, .external_lex_state = 2},
  [997] = {.lex_state = 18, .external_lex_state = 4},
  [998] = {.lex_state = 84, .external_lex_state = 2},
  [999] = {.lex_state = 84, .external_lex_state = 2},
  [1000] = {.lex_state = 84, .external_lex_state = 2},
  [1001] = {.lex_state = 84, .external_lex_state = 2},
  [1002] = {.lex_state = 84, .external_lex_state = 2},
  [1003] = {.lex_state = 84, .external_lex_state = 2},
  [1004] = {.lex_state = 84, .external_lex_state = 2},
  [1005] = {.lex_state = 84, .external_lex_state = 2},
  [1006] = {.lex_state = 84, .external_lex_state = 2},
  [1007] = {.lex_state = 84, .external_lex_state = 2},
  [1008] = {.lex_state = 84, .external_lex_state = 2},
  [1009] = {.lex_state = 84, .external_lex_state = 2},
  [1010] = {.lex_state = 84, .external_lex_state = 2},
  [1011] = {.lex_state = 84, .external_lex_state = 2},
  [1012] = {.lex_state = 81, .external_lex_state = 4},
  [1013] = {.lex_state = 84, .external_lex_state = 2},
  [1014] = {.lex_state = 84, .external_lex_state = 2},
  [1015] = {.lex_state = 13, .external_lex_state = 4},
  [1016] = {.lex_state = 84, .external_lex_state = 2},
  [1017] = {.lex_state = 2, .external_lex_state = 4},
  [1018] = {.lex_state = 84, .external_lex_state = 2},
  [1019] = {.lex_state = 84, .external_lex_state = 2},
  [1020] = {.lex_state = 84, .external_lex_state = 2},
  [1021] = {.lex_state = 84, .external_lex_state = 2},
  [1022] = {.lex_state = 84, .external_lex_state = 2},
  [1023] = {.lex_state = 84, .external_lex_state = 2},
  [1024] = {.lex_state = 84, .external_lex_state = 2},
  [1025] = {.lex_state = 84, .external_lex_state = 2},
  [1026] = {.lex_state = 84, .external_lex_state = 2},
  [1027] = {.lex_state = 84, .external_lex_state = 2},
  [1028] = {.lex_state = 13, .external_lex_state = 4},
  [1029] = {.lex_state = 84, .external_lex_state = 2},
  [1030] = {.lex_state = 84, .external_lex_state = 2},
  [1031] = {.lex_state = 84, .external_lex_state = 2},
  [1032] = {.lex_state = 84, .external_lex_state = 2},
  [1033] = {.lex_state = 13, .external_lex_state = 4},
  [1034] = {.lex_state = 84, .external_lex_state = 2},
  [1035] = {.lex_state = 84, .external_lex_state = 2},
  [1036] = {.lex_state = 84, .external_lex_state = 2},
  [1037] = {.lex_state = 84, .external_lex_state = 2},
  [1038] = {.lex_state = 84, .external_lex_state = 2},
  [1039] = {.lex_state = 84, .external_lex_state = 2},
  [1040] = {.lex_state = 84, .external_lex_state = 2},
  [1041] = {.lex_state = 13, .external_lex_state = 4},
  [1042] = {.lex_state = 13, .external_lex_state = 4},
  [1043] = {.lex_state = 18, .external_lex_state = 4},
  [1044] = {.lex_state = 13, .external_lex_state = 4},
  [1045] = {.lex_state = 84, .external_lex_state = 2},
  [1046] = {.lex_state = 2, .external_lex_state = 4},
  [1047] = {.lex_state = 13, .external_lex_state = 4},
  [1048] = {.lex_state = 13, .external_lex_state = 4},
  [1049] = {.lex_state = 13, .external_lex_state = 4},
  [1050] = {.lex_state = 13, .external_lex_state = 4},
  [1051] = {.lex_state = 13, .external_lex_state = 4},
  [1052] = {.lex_state = 84, .external_lex_state = 2},
  [1053] = {.lex_state = 84, .external_lex_state = 2},
  [1054] = {.lex_state = 84, .external_lex_state = 2},
  [1055] = {.lex_state = 84, .external_lex_state = 2},
  [1056] = {.lex_state = 13, .external_lex_state = 4},
  [1057] = {.lex_state = 84, .external_lex_state = 2},
  [1058] = {.lex_state = 84, .external_lex_state = 2},
  [1059] = {.lex_state = 84, .external_lex_state = 2},
  [1060] = {.lex_state = 84, .external_lex_state = 2},
  [1061] = {.lex_state = 84, .external_lex_state = 2},
  [1062] = {.lex_state = 84, .external_lex_state = 2},
  [1063] = {.lex_state = 84, .external_lex_state = 2},
  [1064] = {.lex_state = 13, .external_lex_state = 4},
  [1065] = {.lex_state = 13, .external_lex_state = 4},
  [1066] = {.lex_state = 13, .external_lex_state = 4},
  [1067] = {.lex_state = 84, .external_lex_state = 2},
  [1068] = {.lex_state = 84, .external_lex_state = 2},
  [1069] = {.lex_state = 84, .external_lex_state = 2},
  [1070] = {.lex_state = 84, .external_lex_state = 2},
  [1071] = {.lex_state = 13, .external_lex_state = 4},
  [1072] = {.lex_state = 84, .external_lex_state = 2},
  [1073] = {.lex_state = 84, .external_lex_state = 2},
  [1074] = {.lex_state = 13, .external_lex_state = 4},
  [1075] = {.lex_state = 84, .external_lex_state = 2},
  [1076] = {.lex_state = 84, .external_lex_state = 2},
  [1077] = {.lex_state = 84, .external_lex_state = 2},
  [1078] = {.lex_state = 13, .external_lex_state = 4},
  [1079] = {.lex_state = 84, .external_lex_state = 2},
  [1080] = {.lex_state = 84, .external_lex_state = 2},
  [1081] = {.lex_state = 84, .external_lex_state = 2},
  [1082] = {.lex_state = 84, .external_lex_state = 2},
  [1083] = {.lex_state = 84, .external_lex_state = 2},
  [1084] = {.lex_state = 84, .external_lex_state = 2},
  [1085] = {.lex_state = 13, .external_lex_state = 4},
  [1086] = {.lex_state = 84, .external_lex_state = 2},
  [1087] = {.lex_state = 12, .external_lex_state = 2},
  [1088] = {.lex_state = 18, .external_lex_state = 4},
  [1089] = {.lex_state = 84, .external_lex_state = 2},
  [1090] = {.lex_state = 2, .external_lex_state = 4},
  [1091] = {.lex_state = 84, .external_lex_state = 2},
  [1092] = {.lex_state = 84, .external_lex_state = 2},
  [1093] = {.lex_state = 84, .external_lex_state = 2},
  [1094] = {.lex_state = 84, .external_lex_state = 2},
  [1095] = {.lex_state = 13, .external_lex_state = 4},
  [1096] = {.lex_state = 81, .external_lex_state = 4},
  [1097] = {.lex_state = 84, .external_lex_state = 2},
  [1098] = {.lex_state = 2, .external_lex_state = 4},
  [1099] = {.lex_state = 81, .external_lex_state = 4},
  [1100] = {.lex_state = 13, .external_lex_state = 2},
  [1101] = {.lex_state = 13, .external_lex_state = 2},
  [1102] = {.lex_state = 6, .external_lex_state = 4},
  [1103] = {.lex_state = 18, .external_lex_state = 4},
  [1104] = {.lex_state = 18, .external_lex_state = 4},
  [1105] = {.lex_state = 81, .external_lex_state = 4},
  [1106] = {.lex_state = 18, .external_lex_state = 4},
  [1107] = {.lex_state = 18, .external_lex_state = 4},
  [1108] = {.lex_state = 18, .external_lex_state = 4},
  [1109] = {.lex_state = 18, .external_lex_state = 4},
  [1110] = {.lex_state = 18, .external_lex_state = 4},
  [1111] = {.lex_state = 18, .external_lex_state = 4},
  [1112] = {.lex_state = 18, .external_lex_state = 4},
  [1113] = {.lex_state = 18, .external_lex_state = 4},
  [1114] = {.lex_state = 18, .external_lex_state = 4},
  [1115] = {.lex_state = 18, .external_lex_state = 4},
  [1116] = {.lex_state = 18, .external_lex_state = 4},
  [1117] = {.lex_state = 78, .external_lex_state = 4},
  [1118] = {.lex_state = 18, .external_lex_state = 4},
  [1119] = {.lex_state = 18, .external_lex_state = 4},
  [1120] = {.lex_state = 18, .external_lex_state = 4},
  [1121] = {.lex_state = 18, .external_lex_state = 4},
  [1122] = {.lex_state = 18, .external_lex_state = 4},
  [1123] = {.lex_state = 18, .external_lex_state = 4},
  [1124] = {.lex_state = 18, .external_lex_state = 4},
  [1125] = {.lex_state = 2, .external_lex_state = 4},
  [1126] = {.lex_state = 2, .external_lex_state = 4},
  [1127] = {.lex_state = 18, .external_lex_state = 4},
  [1128] = {.lex_state = 2, .external_lex_state = 4},
  [1129] = {.lex_state = 2, .external_lex_state = 4},
  [1130] = {.lex_state = 18, .external_lex_state = 4},
  [1131] = {.lex_state = 2, .external_lex_state = 4},
  [1132] = {.lex_state = 2, .external_lex_state = 4},
  [1133] = {.lex_state = 2, .external_lex_state = 4},
  [1134] = {.lex_state = 12, .external_lex_state = 2},
  [1135] = {.lex_state = 2, .external_lex_state = 4},
  [1136] = {.lex_state = 12, .external_lex_state = 2},
  [1137] = {.lex_state = 2, .external_lex_state = 4},
  [1138] = {.lex_state = 2, .external_lex_state = 4},
  [1139] = {.lex_state = 12, .external_lex_state = 2},
  [1140] = {.lex_state = 2, .external_lex_state = 4},
  [1141] = {.lex_state = 2, .external_lex_state = 4},
  [1142] = {.lex_state = 22, .external_lex_state = 4},
  [1143] = {.lex_state = 2, .external_lex_state = 4},
  [1144] = {.lex_state = 81, .external_lex_state = 4},
  [1145] = {.lex_state = 2, .external_lex_state = 4},
  [1146] = {.lex_state = 2, .external_lex_state = 4},
  [1147] = {.lex_state = 2, .external_lex_state = 4},
  [1148] = {.lex_state = 2, .external_lex_state = 4},
  [1149] = {.lex_state = 81, .external_lex_state = 4},
  [1150] = {.lex_state = 81, .external_lex_state = 4},
  [1151] = {.lex_state = 2, .external_lex_state = 4},
  [1152] = {.lex_state = 2, .external_lex_state = 4},
  [1153] = {.lex_state = 2, .external_lex_state = 4},
  [1154] = {.lex_state = 81, .external_lex_state = 4},
  [1155] = {.lex_state = 81, .external_lex_state = 4},
  [1156] = {.lex_state = 18, .external_lex_state = 4},
  [1157] = {.lex_state = 2, .external_lex_state = 4},
  [1158] = {.lex_state = 2, .external_lex_state = 4},
  [1159] = {.lex_state = 81, .external_lex_state = 4},
  [1160] = {.lex_state = 81, .external_lex_state = 4},
  [1161] = {.lex_state = 81, .external_lex_state = 4},
  [1162] = {.lex_state = 81, .external_lex_state = 4},
  [1163] = {.lex_state = 81, .external_lex_state = 4},
  [1164] = {.lex_state = 81, .external_lex_state = 4},
  [1165] = {.lex_state = 81, .external_lex_state = 4},
  [1166] = {.lex_state = 18, .external_lex_state = 4},
  [1167] = {.lex_state = 81, .external_lex_state = 4},
  [1168] = {.lex_state = 81, .external_lex_state = 4},
  [1169] = {.lex_state = 81, .external_lex_state = 4},
  [1170] = {.lex_state = 81, .external_lex_state = 4},
  [1171] = {.lex_state = 81, .external_lex_state = 4},
  [1172] = {.lex_state = 81, .external_lex_state = 4},
  [1173] = {.lex_state = 2, .external_lex_state = 4},
  [1174] = {.lex_state = 81, .external_lex_state = 4},
  [1175] = {.lex_state = 81, .external_lex_state = 4},
  [1176] = {.lex_state = 81, .external_lex_state = 4},
  [1177] = {.lex_state = 81, .external_lex_state = 4},
  [1178] = {.lex_state = 13, .external_lex_state = 2},
  [1179] = {.lex_state = 2, .external_lex_state = 4},
  [1180] = {.lex_state = 18, .external_lex_state = 4},
  [1181] = {.lex_state = 18, .external_lex_state = 4},
  [1182] = {.lex_state = 18, .external_lex_state = 4},
  [1183] = {.lex_state = 18, .external_lex_state = 4},
  [1184] = {.lex_state = 18, .external_lex_state = 4},
  [1185] = {.lex_state = 18, .external_lex_state = 4},
  [1186] = {.lex_state = 18, .external_lex_state = 4},
  [1187] = {.lex_state = 18, .external_lex_state = 4},
  [1188] = {.lex_state = 16, .external_lex_state = 2},
  [1189] = {.lex_state = 81, .external_lex_state = 4},
  [1190] = {.lex_state = 81, .external_lex_state = 4},
  [1191] = {.lex_state = 81, .external_lex_state = 4},
  [1192] = {.lex_state = 16, .external_lex_state = 2},
  [1193] = {.lex_state = 18, .external_lex_state = 4},
  [1194] = {.lex_state = 18, .external_lex_state = 4},
  [1195] = {.lex_state = 81, .external_lex_state = 4},
  [1196] = {.lex_state = 81, .external_lex_state = 4},
  [1197] = {.lex_state = 18, .external_lex_state = 4},
  [1198] = {.lex_state = 18, .external_lex_state = 4},
  [1199] = {.lex_state = 13, .external_lex_state = 2},
  [1200] = {.lex_state = 18, .external_lex_state = 4},
  [1201] = {.lex_state = 18, .external_lex_state = 4},
  [1202] = {.lex_state = 16, .external_lex_state = 2},
  [1203] = {.lex_state = 2, .external_lex_state = 4},
  [1204] = {.lex_state = 18, .external_lex_state = 4},
  [1205] = {.lex_state = 81, .external_lex_state = 4},
  [1206] = {.lex_state = 81, .external_lex_state = 4},
  [1207] = {.lex_state = 18, .external_lex_state = 4},
  [1208] = {.lex_state = 84, .external_lex_state = 2},
  [1209] = {.lex_state = 18, .external_lex_state = 4},
  [1210] = {.lex_state = 18, .external_lex_state = 4},
  [1211] = {.lex_state = 18, .external_lex_state = 4},
  [1212] = {.lex_state = 16, .external_lex_state = 2},
  [1213] = {.lex_state = 5, .external_lex_state = 2},
  [1214] = {.lex_state = 2, .external_lex_state = 4},
  [1215] = {.lex_state = 2, .external_lex_state = 4},
  [1216] = {.lex_state = 81, .external_lex_state = 4},
  [1217] = {.lex_state = 81, .external_lex_state = 4},
  [1218] = {.lex_state = 16, .external_lex_state = 2},
  [1219] = {.lex_state = 18, .external_lex_state = 4},
  [1220] = {.lex_state = 13, .external_lex_state = 2},
  [1221] = {.lex_state = 18, .external_lex_state = 4},
  [1222] = {.lex_state = 16, .external_lex_state = 2},
  [1223] = {.lex_state = 18, .external_lex_state = 4},
  [1224] = {.lex_state = 16, .external_lex_state = 4},
  [1225] = {.lex_state = 13, .external_lex_state = 2},
  [1226] = {.lex_state = 21, .external_lex_state = 2},
  [1227] = {.lex_state = 2, .external_lex_state = 4},
  [1228] = {.lex_state = 13, .external_lex_state = 2},
  [1229] = {.lex_state = 81, .external_lex_state = 4},
  [1230] = {.lex_state = 84, .external_lex_state = 2},
  [1231] = {.lex_state = 81, .external_lex_state = 4},
  [1232] = {.lex_state = 16, .external_lex_state = 2},
  [1233] = {.lex_state = 80, .external_lex_state = 2},
  [1234] = {.lex_state = 18, .external_lex_state = 4},
  [1235] = {.lex_state = 16, .external_lex_state = 2},
  [1236] = {.lex_state = 16, .external_lex_state = 2},
  [1237] = {.lex_state = 18, .external_lex_state = 4},
  [1238] = {.lex_state = 16, .external_lex_state = 2},
  [1239] = {.lex_state = 2, .external_lex_state = 4},
  [1240] = {.lex_state = 16, .external_lex_state = 4},
  [1241] = {.lex_state = 16, .external_lex_state = 4},
  [1242] = {.lex_state = 16, .external_lex_state = 2},
  [1243] = {.lex_state = 81, .external_lex_state = 4},
  [1244] = {.lex_state = 2, .external_lex_state = 4},
  [1245] = {.lex_state = 16, .external_lex_state = 2},
  [1246] = {.lex_state = 2, .external_lex_state = 4},
  [1247] = {.lex_state = 2, .external_lex_state = 4},
  [1248] = {.lex_state = 81, .external_lex_state = 4},
  [1249] = {.lex_state = 2, .external_lex_state = 4},
  [1250] = {.lex_state = 81, .external_lex_state = 4},
  [1251] = {.lex_state = 2, .external_lex_state = 4},
  [1252] = {.lex_state = 2, .external_lex_state = 4},
  [1253] = {.lex_state = 81, .external_lex_state = 4},
  [1254] = {.lex_state = 13, .external_lex_state = 2},
  [1255] = {.lex_state = 13, .external_lex_state = 2},
  [1256] = {.lex_state = 13, .external_lex_state = 2},
  [1257] = {.lex_state = 16, .external_lex_state = 2},
  [1258] = {.lex_state = 16, .external_lex_state = 2},
  [1259] = {.lex_state = 81, .external_lex_state = 4},
  [1260] = {.lex_state = 81, .external_lex_state = 4},
  [1261] = {.lex_state = 2, .external_lex_state = 4},
  [1262] = {.lex_state = 16, .external_lex_state = 2},
  [1263] = {.lex_state = 81, .external_lex_state = 4},
  [1264] = {.lex_state = 16, .external_lex_state = 4},
  [1265] = {.lex_state = 2, .external_lex_state = 4},
  [1266] = {.lex_state = 16, .external_lex_state = 2},
  [1267] = {.lex_state = 81, .external_lex_state = 4},
  [1268] = {.lex_state = 16, .external_lex_state = 2},
  [1269] = {.lex_state = 81, .external_lex_state = 4},
  [1270] = {.lex_state = 81, .external_lex_state = 4},
  [1271] = {.lex_state = 81, .external_lex_state = 4},
  [1272] = {.lex_state = 2, .external_lex_state = 4},
  [1273] = {.lex_state = 81, .external_lex_state = 4},
  [1274] = {.lex_state = 16, .external_lex_state = 2},
  [1275] = {.lex_state = 2, .external_lex_state = 4},
  [1276] = {.lex_state = 2, .external_lex_state = 4},
  [1277] = {.lex_state = 2, .external_lex_state = 4},
  [1278] = {.lex_state = 2, .external_lex_state = 4},
  [1279] = {.lex_state = 84, .external_lex_state = 2},
  [1280] = {.lex_state = 2, .external_lex_state = 4},
  [1281] = {.lex_state = 2, .external_lex_state = 4},
  [1282] = {.lex_state = 16, .external_lex_state = 2},
  [1283] = {.lex_state = 13, .external_lex_state = 2},
  [1284] = {.lex_state = 13, .external_lex_state = 2},
  [1285] = {.lex_state = 84, .external_lex_state = 2},
  [1286] = {.lex_state = 2, .external_lex_state = 4},
  [1287] = {.lex_state = 2, .external_lex_state = 4},
  [1288] = {.lex_state = 2, .external_lex_state = 4},
  [1289] = {.lex_state = 81, .external_lex_state = 4},
  [1290] = {.lex_state = 13, .external_lex_state = 2},
  [1291] = {.lex_state = 16, .external_lex_state = 2},
  [1292] = {.lex_state = 16, .external_lex_state = 2},
  [1293] = {.lex_state = 16, .external_lex_state = 2},
  [1294] = {.lex_state = 16, .external_lex_state = 2},
  [1295] = {.lex_state = 16, .external_lex_state = 2},
  [1296] = {.lex_state = 16, .external_lex_state = 2},
  [1297] = {.lex_state = 16, .external_lex_state = 2},
  [1298] = {.lex_state = 16, .external_lex_state = 2},
  [1299] = {.lex_state = 16, .external_lex_state = 2},
  [1300] = {.lex_state = 16, .external_lex_state = 2},
  [1301] = {.lex_state = 16, .external_lex_state = 2},
  [1302] = {.lex_state = 16, .external_lex_state = 2},
  [1303] = {.lex_state = 16, .external_lex_state = 2},
  [1304] = {.lex_state = 16, .external_lex_state = 2},
  [1305] = {.lex_state = 16, .external_lex_state = 2},
  [1306] = {.lex_state = 5, .external_lex_state = 2},
  [1307] = {.lex_state = 16, .external_lex_state = 2},
  [1308] = {.lex_state = 16, .external_lex_state = 2},
  [1309] = {.lex_state = 5, .external_lex_state = 2},
  [1310] = {.lex_state = 16, .external_lex_state = 2},
  [1311] = {.lex_state = 16, .external_lex_state = 2},
  [1312] = {.lex_state = 16, .external_lex_state = 2},
  [1313] = {.lex_state = 16, .external_lex_state = 2},
  [1314] = {.lex_state = 16, .external_lex_state = 2},
  [1315] = {.lex_state = 16, .external_lex_state = 2},
  [1316] = {.lex_state = 16, .external_lex_state = 2},
  [1317] = {.lex_state = 16, .external_lex_state = 2},
  [1318] = {.lex_state = 16, .external_lex_state = 2},
  [1319] = {.lex_state = 16, .external_lex_state = 2},
  [1320] = {.lex_state = 16, .external_lex_state = 2},
  [1321] = {.lex_state = 16, .external_lex_state = 2},
  [1322] = {.lex_state = 16, .external_lex_state = 2},
  [1323] = {.lex_state = 16, .external_lex_state = 2},
  [1324] = {.lex_state = 16, .external_lex_state = 2},
  [1325] = {.lex_state = 16, .external_lex_state = 2},
  [1326] = {.lex_state = 16, .external_lex_state = 2},
  [1327] = {.lex_state = 16, .external_lex_state = 2},
  [1328] = {.lex_state = 16, .external_lex_state = 2},
  [1329] = {.lex_state = 16, .external_lex_state = 2},
  [1330] = {.lex_state = 16, .external_lex_state = 2},
  [1331] = {.lex_state = 16, .external_lex_state = 2},
  [1332] = {.lex_state = 16, .external_lex_state = 2},
  [1333] = {.lex_state = 16, .external_lex_state = 2},
  [1334] = {.lex_state = 16, .external_lex_state = 2},
  [1335] = {.lex_state = 16, .external_lex_state = 2},
  [1336] = {.lex_state = 16, .external_lex_state = 2},
  [1337] = {.lex_state = 16, .external_lex_state = 2},
  [1338] = {.lex_state = 16, .external_lex_state = 2},
  [1339] = {.lex_state = 16, .external_lex_state = 2},
  [1340] = {.lex_state = 16, .external_lex_state = 2},
  [1341] = {.lex_state = 16, .external_lex_state = 2},
  [1342] = {.lex_state = 16, .external_lex_state = 2},
  [1343] = {.lex_state = 16, .external_lex_state = 2},
  [1344] = {.lex_state = 16, .external_lex_state = 2},
  [1345] = {.lex_state = 16, .external_lex_state = 2},
  [1346] = {.lex_state = 16, .external_lex_state = 2},
  [1347] = {.lex_state = 16, .external_lex_state = 2},
  [1348] = {.lex_state = 16, .external_lex_state = 2},
  [1349] = {.lex_state = 16, .external_lex_state = 2},
  [1350] = {.lex_state = 16, .external_lex_state = 2},
  [1351] = {.lex_state = 16, .external_lex_state = 2},
  [1352] = {.lex_state = 16, .external_lex_state = 2},
  [1353] = {.lex_state = 16, .external_lex_state = 2},
  [1354] = {.lex_state = 16, .external_lex_state = 2},
  [1355] = {.lex_state = 16, .external_lex_state = 2},
  [1356] = {.lex_state = 16, .external_lex_state = 2},
  [1357] = {.lex_state = 16, .external_lex_state = 2},
  [1358] = {.lex_state = 16, .external_lex_state = 2},
  [1359] = {.lex_state = 16, .external_lex_state = 2},
  [1360] = {.lex_state = 16, .external_lex_state = 2},
  [1361] = {.lex_state = 16, .external_lex_state = 2},
  [1362] = {.lex_state = 16, .external_lex_state = 2},
  [1363] = {.lex_state = 16, .external_lex_state = 2},
  [1364] = {.lex_state = 16, .external_lex_state = 2},
  [1365] = {.lex_state = 16, .external_lex_state = 2},
  [1366] = {.lex_state = 16, .external_lex_state = 2},
  [1367] = {.lex_state = 16, .external_lex_state = 2},
  [1368] = {.lex_state = 16, .external_lex_state = 2},
  [1369] = {.lex_state = 16, .external_lex_state = 2},
  [1370] = {.lex_state = 16, .external_lex_state = 2},
  [1371] = {.lex_state = 16, .external_lex_state = 2},
  [1372] = {.lex_state = 16, .external_lex_state = 2},
  [1373] = {.lex_state = 5, .external_lex_state = 2},
  [1374] = {.lex_state = 16, .external_lex_state = 2},
  [1375] = {.lex_state = 16, .external_lex_state = 2},
  [1376] = {.lex_state = 16, .external_lex_state = 2},
  [1377] = {.lex_state = 80, .external_lex_state = 2},
  [1378] = {.lex_state = 80, .external_lex_state = 2},
  [1379] = {.lex_state = 16, .external_lex_state = 2},
  [1380] = {.lex_state = 16, .external_lex_state = 2},
  [1381] = {.lex_state = 16, .external_lex_state = 2},
  [1382] = {.lex_state = 16, .external_lex_state = 2},
  [1383] = {.lex_state = 16, .external_lex_state = 2},
  [1384] = {.lex_state = 16, .external_lex_state = 2},
  [1385] = {.lex_state = 16, .external_lex_state = 2},
  [1386] = {.lex_state = 16, .external_lex_state = 2},
  [1387] = {.lex_state = 2, .external_lex_state = 2},
  [1388] = {.lex_state = 16, .external_lex_state = 2},
  [1389] = {.lex_state = 16, .external_lex_state = 2},
  [1390] = {.lex_state = 16, .external_lex_state = 2},
  [1391] = {.lex_state = 16, .external_lex_state = 2},
  [1392] = {.lex_state = 16, .external_lex_state = 2},
  [1393] = {.lex_state = 16, .external_lex_state = 2},
  [1394] = {.lex_state = 18, .external_lex_state = 2},
  [1395] = {.lex_state = 18, .external_lex_state = 2},
  [1396] = {.lex_state = 16, .external_lex_state = 2},
  [1397] = {.lex_state = 16, .external_lex_state = 2},
  [1398] = {.lex_state = 16, .external_lex_state = 2},
  [1399] = {.lex_state = 16, .external_lex_state = 2},
  [1400] = {.lex_state = 2, .external_lex_state = 2},
  [1401] = {.lex_state = 16, .external_lex_state = 2},
  [1402] = {.lex_state = 16, .external_lex_state = 2},
  [1403] = {.lex_state = 16, .external_lex_state = 2},
  [1404] = {.lex_state = 16, .external_lex_state = 2},
  [1405] = {.lex_state = 16, .external_lex_state = 2},
  [1406] = {.lex_state = 16, .external_lex_state = 2},
  [1407] = {.lex_state = 16, .external_lex_state = 2},
  [1408] = {.lex_state = 16, .external_lex_state = 2},
  [1409] = {.lex_state = 16, .external_lex_state = 2},
  [1410] = {.lex_state = 16, .external_lex_state = 2},
  [1411] = {.lex_state = 16, .external_lex_state = 2},
  [1412] = {.lex_state = 16, .external_lex_state = 2},
  [1413] = {.lex_state = 84, .external_lex_state = 2},
  [1414] = {.lex_state = 16, .external_lex_state = 2},
  [1415] = {.lex_state = 16, .external_lex_state = 2},
  [1416] = {.lex_state = 81, .external_lex_state = 2},
  [1417] = {.lex_state = 16, .external_lex_state = 2},
  [1418] = {.lex_state = 84, .external_lex_state = 2},
  [1419] = {.lex_state = 16, .external_lex_state = 2},
  [1420] = {.lex_state = 16, .external_lex_state = 2},
  [1421] = {.lex_state = 81, .external_lex_state = 2},
  [1422] = {.lex_state = 16, .external_lex_state = 2},
  [1423] = {.lex_state = 16, .external_lex_state = 2},
  [1424] = {.lex_state = 16, .external_lex_state = 2},
  [1425] = {.lex_state = 80, .external_lex_state = 2},
  [1426] = {.lex_state = 16, .external_lex_state = 2},
  [1427] = {.lex_state = 16, .external_lex_state = 2},
  [1428] = {.lex_state = 21, .external_lex_state = 2},
  [1429] = {.lex_state = 21, .external_lex_state = 2},
  [1430] = {.lex_state = 21, .external_lex_state = 2},
  [1431] = {.lex_state = 1, .external_lex_state = 2},
  [1432] = {.lex_state = 17, .external_lex_state = 2},
  [1433] = {.lex_state = 2, .external_lex_state = 2},
  [1434] = {.lex_state = 1, .external_lex_state = 4},
  [1435] = {.lex_state = 2, .external_lex_state = 2},
  [1436] = {.lex_state = 2, .external_lex_state = 2},
  [1437] = {.lex_state = 2, .external_lex_state = 2},
  [1438] = {.lex_state = 1, .external_lex_state = 2},
  [1439] = {.lex_state = 1, .external_lex_state = 2},
  [1440] = {.lex_state = 1, .external_lex_state = 2},
  [1441] = {.lex_state = 2, .external_lex_state = 2},
  [1442] = {.lex_state = 2, .external_lex_state = 2},
  [1443] = {.lex_state = 1, .external_lex_state = 2},
  [1444] = {.lex_state = 1, .external_lex_state = 2},
  [1445] = {.lex_state = 1, .external_lex_state = 2},
  [1446] = {.lex_state = 2, .external_lex_state = 2},
  [1447] = {.lex_state = 2, .external_lex_state = 2},
  [1448] = {.lex_state = 2, .external_lex_state = 2},
  [1449] = {.lex_state = 1, .external_lex_state = 2},
  [1450] = {.lex_state = 1, .external_lex_state = 2},
  [1451] = {.lex_state = 1, .external_lex_state = 2},
  [1452] = {.lex_state = 84, .external_lex_state = 2},
  [1453] = {.lex_state = 2, .external_lex_state = 2},
  [1454] = {.lex_state = 2, .external_lex_state = 2},
  [1455] = {.lex_state = 84, .external_lex_state = 2},
  [1456] = {.lex_state = 1, .external_lex_state = 2},
  [1457] = {.lex_state = 1, .external_lex_state = 2},
  [1458] = {.lex_state = 84, .external_lex_state = 2},
  [1459] = {.lex_state = 18, .external_lex_state = 2},
  [1460] = {.lex_state = 1, .external_lex_state = 4},
  [1461] = {.lex_state = 17, .external_lex_state = 4},
  [1462] = {.lex_state = 18, .external_lex_state = 2},
  [1463] = {.lex_state = 18, .external_lex_state = 2},
  [1464] = {.lex_state = 18, .external_lex_state = 2},
  [1465] = {.lex_state = 84, .external_lex_state = 2},
  [1466] = {.lex_state = 17, .external_lex_state = 2},
  [1467] = {.lex_state = 1, .external_lex_state = 2},
  [1468] = {.lex_state = 17, .external_lex_state = 2},
  [1469] = {.lex_state = 1, .external_lex_state = 2},
  [1470] = {.lex_state = 17, .external_lex_state = 2},
  [1471] = {.lex_state = 17, .external_lex_state = 2},
  [1472] = {.lex_state = 1, .external_lex_state = 4},
  [1473] = {.lex_state = 1, .external_lex_state = 4},
  [1474] = {.lex_state = 18, .external_lex_state = 2},
  [1475] = {.lex_state = 18, .external_lex_state = 2},
  [1476] = {.lex_state = 17, .external_lex_state = 2},
  [1477] = {.lex_state = 17, .external_lex_state = 2},
  [1478] = {.lex_state = 17, .external_lex_state = 2},
  [1479] = {.lex_state = 18, .external_lex_state = 2},
  [1480] = {.lex_state = 18, .external_lex_state = 2},
  [1481] = {.lex_state = 18, .external_lex_state = 2},
  [1482] = {.lex_state = 1, .external_lex_state = 2},
  [1483] = {.lex_state = 17, .external_lex_state = 2},
  [1484] = {.lex_state = 17, .external_lex_state = 2},
  [1485] = {.lex_state = 18, .external_lex_state = 2},
  [1486] = {.lex_state = 18, .external_lex_state = 2},
  [1487] = {.lex_state = 17, .external_lex_state = 2},
  [1488] = {.lex_state = 17, .external_lex_state = 2},
  [1489] = {.lex_state = 17, .external_lex_state = 2},
  [1490] = {.lex_state = 81, .external_lex_state = 2},
  [1491] = {.lex_state = 17, .external_lex_state = 4},
  [1492] = {.lex_state = 84, .external_lex_state = 4},
  [1493] = {.lex_state = 84, .external_lex_state = 2},
  [1494] = {.lex_state = 81, .external_lex_state = 2},
  [1495] = {.lex_state = 81, .external_lex_state = 2},
  [1496] = {.lex_state = 81, .external_lex_state = 2},
  [1497] = {.lex_state = 84, .external_lex_state = 2},
  [1498] = {.lex_state = 17, .external_lex_state = 2},
  [1499] = {.lex_state = 84, .external_lex_state = 2},
  [1500] = {.lex_state = 84, .external_lex_state = 2},
  [1501] = {.lex_state = 84, .external_lex_state = 2},
  [1502] = {.lex_state = 17, .external_lex_state = 4},
  [1503] = {.lex_state = 17, .external_lex_state = 4},
  [1504] = {.lex_state = 84, .external_lex_state = 2},
  [1505] = {.lex_state = 81, .external_lex_state = 2},
  [1506] = {.lex_state = 81, .external_lex_state = 2},
  [1507] = {.lex_state = 17, .external_lex_state = 2},
  [1508] = {.lex_state = 84, .external_lex_state = 2},
  [1509] = {.lex_state = 84, .external_lex_state = 4},
  [1510] = {.lex_state = 84, .external_lex_state = 4},
  [1511] = {.lex_state = 84, .external_lex_state = 2},
  [1512] = {.lex_state = 84, .external_lex_state = 2},
  [1513] = {.lex_state = 81, .external_lex_state = 2},
  [1514] = {.lex_state = 81, .external_lex_state = 2},
  [1515] = {.lex_state = 81, .external_lex_state = 2},
  [1516] = {.lex_state = 9, .external_lex_state = 2},
  [1517] = {.lex_state = 1, .external_lex_state = 2},
  [1518] = {.lex_state = 17, .external_lex_state = 2},
  [1519] = {.lex_state = 84, .external_lex_state = 2},
  [1520] = {.lex_state = 84, .external_lex_state = 2},
  [1521] = {.lex_state = 84, .external_lex_state = 2},
  [1522] = {.lex_state = 81, .external_lex_state = 2},
  [1523] = {.lex_state = 81, .external_lex_state = 2},
  [1524] = {.lex_state = 84, .external_lex_state = 2},
  [1525] = {.lex_state = 84, .external_lex_state = 2},
  [1526] = {.lex_state = 84, .external_lex_state = 4},
  [1527] = {.lex_state = 84, .external_lex_state = 2},
  [1528] = {.lex_state = 17, .external_lex_state = 2},
  [1529] = {.lex_state = 17, .external_lex_state = 2},
  [1530] = {.lex_state = 84, .external_lex_state = 2},
  [1531] = {.lex_state = 1, .external_lex_state = 2},
  [1532] = {.lex_state = 1, .external_lex_state = 2},
  [1533] = {.lex_state = 1, .external_lex_state = 2},
  [1534] = {.lex_state = 1, .external_lex_state = 2},
  [1535] = {.lex_state = 1, .external_lex_state = 2},
  [1536] = {.lex_state = 1, .external_lex_state = 2},
  [1537] = {.lex_state = 1, .external_lex_state = 2},
  [1538] = {.lex_state = 1, .external_lex_state = 2},
  [1539] = {.lex_state = 1, .external_lex_state = 2},
  [1540] = {.lex_state = 84, .external_lex_state = 2},
  [1541] = {.lex_state = 1, .external_lex_state = 2},
  [1542] = {.lex_state = 1, .external_lex_state = 2},
  [1543] = {.lex_state = 1, .external_lex_state = 2},
  [1544] = {.lex_state = 1, .external_lex_state = 2},
  [1545] = {.lex_state = 1, .external_lex_state = 2},
  [1546] = {.lex_state = 1, .external_lex_state = 2},
  [1547] = {.lex_state = 1, .external_lex_state = 2},
  [1548] = {.lex_state = 84, .external_lex_state = 2},
  [1549] = {.lex_state = 84, .external_lex_state = 2},
  [1550] = {.lex_state = 84, .external_lex_state = 2},
  [1551] = {.lex_state = 1, .external_lex_state = 2},
  [1552] = {.lex_state = 1, .external_lex_state = 2},
  [1553] = {.lex_state = 1, .external_lex_state = 2},
  [1554] = {.lex_state = 1, .external_lex_state = 2},
  [1555] = {.lex_state = 17, .external_lex_state = 2},
  [1556] = {.lex_state = 84, .external_lex_state = 2},
  [1557] = {.lex_state = 84, .external_lex_state = 2},
  [1558] = {.lex_state = 84, .external_lex_state = 2},
  [1559] = {.lex_state = 84, .external_lex_state = 2},
  [1560] = {.lex_state = 84, .external_lex_state = 2},
  [1561] = {.lex_state = 84, .external_lex_state = 2},
  [1562] = {.lex_state = 84, .external_lex_state = 2},
  [1563] = {.lex_state = 84, .external_lex_state = 2},
  [1564] = {.lex_state = 84, .external_lex_state = 2},
  [1565] = {.lex_state = 84, .external_lex_state = 2},
  [1566] = {.lex_state = 84, .external_lex_state = 2},
  [1567] = {.lex_state = 84, .external_lex_state = 2},
  [1568] = {.lex_state = 1, .external_lex_state = 2},
  [1569] = {.lex_state = 1, .external_lex_state = 2},
  [1570] = {.lex_state = 1, .external_lex_state = 2},
  [1571] = {.lex_state = 17, .external_lex_state = 2},
  [1572] = {.lex_state = 1, .external_lex_state = 2},
  [1573] = {.lex_state = 84, .external_lex_state = 2},
  [1574] = {.lex_state = 84, .external_lex_state = 2},
  [1575] = {.lex_state = 84, .external_lex_state = 2},
  [1576] = {.lex_state = 84, .external_lex_state = 2},
  [1577] = {.lex_state = 84, .external_lex_state = 2},
  [1578] = {.lex_state = 84, .external_lex_state = 2},
  [1579] = {.lex_state = 84, .external_lex_state = 2},
  [1580] = {.lex_state = 84, .external_lex_state = 2},
  [1581] = {.lex_state = 84, .external_lex_state = 2},
  [1582] = {.lex_state = 17, .external_lex_state = 2},
  [1583] = {.lex_state = 17, .external_lex_state = 2},
  [1584] = {.lex_state = 84, .external_lex_state = 2},
  [1585] = {.lex_state = 84, .external_lex_state = 2},
  [1586] = {.lex_state = 84, .external_lex_state = 2},
  [1587] = {.lex_state = 84, .external_lex_state = 2},
  [1588] = {.lex_state = 84, .external_lex_state = 2},
  [1589] = {.lex_state = 84, .external_lex_state = 2},
  [1590] = {.lex_state = 84, .external_lex_state = 2},
  [1591] = {.lex_state = 84, .external_lex_state = 2},
  [1592] = {.lex_state = 1, .external_lex_state = 2},
  [1593] = {.lex_state = 84, .external_lex_state = 2},
  [1594] = {.lex_state = 84, .external_lex_state = 2},
  [1595] = {.lex_state = 84, .external_lex_state = 2},
  [1596] = {.lex_state = 84, .external_lex_state = 2},
  [1597] = {.lex_state = 84, .external_lex_state = 2},
  [1598] = {.lex_state = 84, .external_lex_state = 2},
  [1599] = {.lex_state = 17, .external_lex_state = 2},
  [1600] = {.lex_state = 17, .external_lex_state = 2},
  [1601] = {.lex_state = 17, .external_lex_state = 2},
  [1602] = {.lex_state = 84, .external_lex_state = 2},
  [1603] = {.lex_state = 84, .external_lex_state = 2},
  [1604] = {.lex_state = 84, .external_lex_state = 2},
  [1605] = {.lex_state = 17, .external_lex_state = 2},
  [1606] = {.lex_state = 17, .external_lex_state = 2},
  [1607] = {.lex_state = 17, .external_lex_state = 2},
  [1608] = {.lex_state = 17, .external_lex_state = 2},
  [1609] = {.lex_state = 17, .external_lex_state = 2},
  [1610] = {.lex_state = 17, .external_lex_state = 2},
  [1611] = {.lex_state = 17, .external_lex_state = 2},
  [1612] = {.lex_state = 17, .external_lex_state = 2},
  [1613] = {.lex_state = 17, .external_lex_state = 2},
  [1614] = {.lex_state = 17, .external_lex_state = 2},
  [1615] = {.lex_state = 17, .external_lex_state = 2},
  [1616] = {.lex_state = 17, .external_lex_state = 2},
  [1617] = {.lex_state = 17, .external_lex_state = 2},
  [1618] = {.lex_state = 17, .external_lex_state = 2},
  [1619] = {.lex_state = 17, .external_lex_state = 2},
  [1620] = {.lex_state = 17, .external_lex_state = 2},
  [1621] = {.lex_state = 17, .external_lex_state = 2},
  [1622] = {.lex_state = 17, .external_lex_state = 2},
  [1623] = {.lex_state = 84, .external_lex_state = 2},
  [1624] = {.lex_state = 84, .external_lex_state = 2},
  [1625] = {.lex_state = 84, .external_lex_state = 2},
  [1626] = {.lex_state = 84, .external_lex_state = 2},
  [1627] = {.lex_state = 84, .external_lex_state = 2},
  [1628] = {.lex_state = 84, .external_lex_state = 2},
  [1629] = {.lex_state = 84, .external_lex_state = 2},
  [1630] = {.lex_state = 84, .external_lex_state = 2},
  [1631] = {.lex_state = 84, .external_lex_state = 2},
  [1632] = {.lex_state = 84, .external_lex_state = 2},
  [1633] = {.lex_state = 1, .external_lex_state = 2},
  [1634] = {.lex_state = 84, .external_lex_state = 2},
  [1635] = {.lex_state = 84, .external_lex_state = 2},
  [1636] = {.lex_state = 84, .external_lex_state = 2},
  [1637] = {.lex_state = 84, .external_lex_state = 2},
  [1638] = {.lex_state = 84, .external_lex_state = 2},
  [1639] = {.lex_state = 84, .external_lex_state = 2},
  [1640] = {.lex_state = 1, .external_lex_state = 2},
  [1641] = {.lex_state = 84, .external_lex_state = 2},
  [1642] = {.lex_state = 17, .external_lex_state = 2},
  [1643] = {.lex_state = 17, .external_lex_state = 2},
  [1644] = {.lex_state = 17, .external_lex_state = 2},
  [1645] = {.lex_state = 17, .external_lex_state = 2},
  [1646] = {.lex_state = 17, .external_lex_state = 2},
  [1647] = {.lex_state = 17, .external_lex_state = 2},
  [1648] = {.lex_state = 84, .external_lex_state = 2},
  [1649] = {.lex_state = 17, .external_lex_state = 2},
  [1650] = {.lex_state = 17, .external_lex_state = 2},
  [1651] = {.lex_state = 84, .external_lex_state = 2},
  [1652] = {.lex_state = 17, .external_lex_state = 2},
  [1653] = {.lex_state = 1, .external_lex_state = 2},
  [1654] = {.lex_state = 1, .external_lex_state = 2},
  [1655] = {.lex_state = 16, .external_lex_state = 2},
  [1656] = {.lex_state = 17, .external_lex_state = 2},
  [1657] = {.lex_state = 17, .external_lex_state = 2},
  [1658] = {.lex_state = 17, .external_lex_state = 2},
  [1659] = {.lex_state = 17, .external_lex_state = 2},
  [1660] = {.lex_state = 84, .external_lex_state = 2},
  [1661] = {.lex_state = 17, .external_lex_state = 2},
  [1662] = {.lex_state = 1, .external_lex_state = 2},
  [1663] = {.lex_state = 84, .external_lex_state = 2},
  [1664] = {.lex_state = 84, .external_lex_state = 2},
  [1665] = {.lex_state = 84, .external_lex_state = 2},
  [1666] = {.lex_state = 84, .external_lex_state = 2},
  [1667] = {.lex_state = 84, .external_lex_state = 2},
  [1668] = {.lex_state = 84, .external_lex_state = 2},
  [1669] = {.lex_state = 84, .external_lex_state = 2},
  [1670] = {.lex_state = 84, .external_lex_state = 2},
  [1671] = {.lex_state = 17, .external_lex_state = 2},
  [1672] = {.lex_state = 84, .external_lex_state = 2},
  [1673] = {.lex_state = 84, .external_lex_state = 2},
  [1674] = {.lex_state = 84, .external_lex_state = 2},
  [1675] = {.lex_state = 84, .external_lex_state = 2},
  [1676] = {.lex_state = 84, .external_lex_state = 2},
  [1677] = {.lex_state = 84, .external_lex_state = 2},
  [1678] = {.lex_state = 84, .external_lex_state = 2},
  [1679] = {.lex_state = 84, .external_lex_state = 2},
  [1680] = {.lex_state = 17, .external_lex_state = 2},
  [1681] = {.lex_state = 84, .external_lex_state = 2},
  [1682] = {.lex_state = 84, .external_lex_state = 2},
  [1683] = {.lex_state = 17, .external_lex_state = 2},
  [1684] = {.lex_state = 1, .external_lex_state = 2},
  [1685] = {.lex_state = 17, .external_lex_state = 2},
  [1686] = {.lex_state = 84, .external_lex_state = 2},
  [1687] = {.lex_state = 84, .external_lex_state = 2},
  [1688] = {.lex_state = 84, .external_lex_state = 2},
  [1689] = {.lex_state = 1, .external_lex_state = 2},
  [1690] = {.lex_state = 84, .external_lex_state = 2},
  [1691] = {.lex_state = 84, .external_lex_state = 2},
  [1692] = {.lex_state = 84, .external_lex_state = 2},
  [1693] = {.lex_state = 1, .external_lex_state = 2},
  [1694] = {.lex_state = 1, .external_lex_state = 2},
  [1695] = {.lex_state = 1, .external_lex_state = 2},
  [1696] = {.lex_state = 17, .external_lex_state = 2},
  [1697] = {.lex_state = 84, .external_lex_state = 2},
  [1698] = {.lex_state = 84, .external_lex_state = 2},
  [1699] = {.lex_state = 84, .external_lex_state = 2},
  [1700] = {.lex_state = 84, .external_lex_state = 2},
  [1701] = {.lex_state = 84, .external_lex_state = 2},
  [1702] = {.lex_state = 84, .external_lex_state = 2},
  [1703] = {.lex_state = 84, .external_lex_state = 2},
  [1704] = {.lex_state = 84, .external_lex_state = 2},
  [1705] = {.lex_state = 1, .external_lex_state = 2},
  [1706] = {.lex_state = 1, .external_lex_state = 2},
  [1707] = {.lex_state = 1, .external_lex_state = 2},
  [1708] = {.lex_state = 84, .external_lex_state = 2},
  [1709] = {.lex_state = 1, .external_lex_state = 2},
  [1710] = {.lex_state = 17, .external_lex_state = 2},
  [1711] = {.lex_state = 1, .external_lex_state = 2},
  [1712] = {.lex_state = 1, .external_lex_state = 2},
  [1713] = {.lex_state = 84, .external_lex_state = 2},
  [1714] = {.lex_state = 17, .external_lex_state = 2},
  [1715] = {.lex_state = 17, .external_lex_state = 2},
  [1716] = {.lex_state = 17, .external_lex_state = 2},
  [1717] = {.lex_state = 17, .external_lex_state = 2},
  [1718] = {.lex_state = 17, .external_lex_state = 2},
  [1719] = {.lex_state = 17, .external_lex_state = 2},
  [1720] = {.lex_state = 17, .external_lex_state = 2},
  [1721] = {.lex_state = 17, .external_lex_state = 2},
  [1722] = {.lex_state = 1, .external_lex_state = 2},
  [1723] = {.lex_state = 17, .external_lex_state = 2},
  [1724] = {.lex_state = 84, .external_lex_state = 2},
  [1725] = {.lex_state = 17, .external_lex_state = 2},
  [1726] = {.lex_state = 17, .external_lex_state = 2},
  [1727] = {.lex_state = 17, .external_lex_state = 2},
  [1728] = {.lex_state = 17, .external_lex_state = 2},
  [1729] = {.lex_state = 17, .external_lex_state = 2},
  [1730] = {.lex_state = 17, .external_lex_state = 2},
  [1731] = {.lex_state = 17, .external_lex_state = 2},
  [1732] = {.lex_state = 17, .external_lex_state = 2},
  [1733] = {.lex_state = 17, .external_lex_state = 2},
  [1734] = {.lex_state = 1, .external_lex_state = 2},
  [1735] = {.lex_state = 1, .external_lex_state = 2},
  [1736] = {.lex_state = 17, .external_lex_state = 2},
  [1737] = {.lex_state = 17, .external_lex_state = 2},
  [1738] = {.lex_state = 17, .external_lex_state = 2},
  [1739] = {.lex_state = 17, .external_lex_state = 2},
  [1740] = {.lex_state = 17, .external_lex_state = 2},
  [1741] = {.lex_state = 17, .external_lex_state = 2},
  [1742] = {.lex_state = 17, .external_lex_state = 2},
  [1743] = {.lex_state = 17, .external_lex_state = 2},
  [1744] = {.lex_state = 17, .external_lex_state = 2},
  [1745] = {.lex_state = 17, .external_lex_state = 2},
  [1746] = {.lex_state = 17, .external_lex_state = 2},
  [1747] = {.lex_state = 17, .external_lex_state = 2},
  [1748] = {.lex_state = 17, .external_lex_state = 2},
  [1749] = {.lex_state = 17, .external_lex_state = 2},
  [1750] = {.lex_state = 17, .external_lex_state = 2},
  [1751] = {.lex_state = 17, .external_lex_state = 2},
  [1752] = {.lex_state = 1, .external_lex_state = 2},
  [1753] = {.lex_state = 84, .external_lex_state = 2},
  [1754] = {.lex_state = 84, .external_lex_state = 2},
  [1755] = {.lex_state = 17, .external_lex_state = 2},
  [1756] = {.lex_state = 84, .external_lex_state = 2},
  [1757] = {.lex_state = 1, .external_lex_state = 2},
  [1758] = {.lex_state = 84, .external_lex_state = 2},
  [1759] = {.lex_state = 84, .external_lex_state = 2},
  [1760] = {.lex_state = 1, .external_lex_state = 2},
  [1761] = {.lex_state = 1, .external_lex_state = 2},
  [1762] = {.lex_state = 1, .external_lex_state = 2},
  [1763] = {.lex_state = 17, .external_lex_state = 2},
  [1764] = {.lex_state = 84, .external_lex_state = 2},
  [1765] = {.lex_state = 1, .external_lex_state = 2},
  [1766] = {.lex_state = 17, .external_lex_state = 2},
  [1767] = {.lex_state = 84, .external_lex_state = 2},
  [1768] = {.lex_state = 17, .external_lex_state = 2},
  [1769] = {.lex_state = 1, .external_lex_state = 2},
  [1770] = {.lex_state = 84, .external_lex_state = 2},
  [1771] = {.lex_state = 1, .external_lex_state = 2},
  [1772] = {.lex_state = 17, .external_lex_state = 2},
  [1773] = {.lex_state = 17, .external_lex_state = 2},
  [1774] = {.lex_state = 17, .external_lex_state = 2},
  [1775] = {.lex_state = 17, .external_lex_state = 2},
  [1776] = {.lex_state = 17, .external_lex_state = 2},
  [1777] = {.lex_state = 17, .external_lex_state = 2},
  [1778] = {.lex_state = 17, .external_lex_state = 2},
  [1779] = {.lex_state = 17, .external_lex_state = 2},
  [1780] = {.lex_state = 17, .external_lex_state = 2},
  [1781] = {.lex_state = 17, .external_lex_state = 2},
  [1782] = {.lex_state = 1, .external_lex_state = 2},
  [1783] = {.lex_state = 1, .external_lex_state = 2},
  [1784] = {.lex_state = 1, .external_lex_state = 2},
  [1785] = {.lex_state = 17, .external_lex_state = 2},
  [1786] = {.lex_state = 17, .external_lex_state = 2},
  [1787] = {.lex_state = 17, .external_lex_state = 2},
  [1788] = {.lex_state = 84, .external_lex_state = 2},
  [1789] = {.lex_state = 1, .external_lex_state = 2},
  [1790] = {.lex_state = 17, .external_lex_state = 2},
  [1791] = {.lex_state = 17, .external_lex_state = 2},
  [1792] = {.lex_state = 84, .external_lex_state = 2},
  [1793] = {.lex_state = 1, .external_lex_state = 2},
  [1794] = {.lex_state = 1, .external_lex_state = 2},
  [1795] = {.lex_state = 1, .external_lex_state = 2},
  [1796] = {.lex_state = 1, .external_lex_state = 2},
  [1797] = {.lex_state = 1, .external_lex_state = 2},
  [1798] = {.lex_state = 17, .external_lex_state = 2},
  [1799] = {.lex_state = 1, .external_lex_state = 2},
  [1800] = {.lex_state = 1, .external_lex_state = 2},
  [1801] = {.lex_state = 1, .external_lex_state = 2},
  [1802] = {.lex_state = 1, .external_lex_state = 2},
  [1803] = {.lex_state = 1, .external_lex_state = 2},
  [1804] = {.lex_state = 1, .external_lex_state = 2},
  [1805] = {.lex_state = 1, .external_lex_state = 2},
  [1806] = {.lex_state = 1, .external_lex_state = 2},
  [1807] = {.lex_state = 1, .external_lex_state = 2},
  [1808] = {.lex_state = 17, .external_lex_state = 2},
  [1809] = {.lex_state = 1, .external_lex_state = 2},
  [1810] = {.lex_state = 17, .external_lex_state = 2},
  [1811] = {.lex_state = 84, .external_lex_state = 2},
  [1812] = {.lex_state = 1, .external_lex_state = 2},
  [1813] = {.lex_state = 84, .external_lex_state = 2},
  [1814] = {.lex_state = 17, .external_lex_state = 2},
  [1815] = {.lex_state = 84, .external_lex_state = 2},
  [1816] = {.lex_state = 84, .external_lex_state = 2},
  [1817] = {.lex_state = 17, .external_lex_state = 2},
  [1818] = {.lex_state = 1, .external_lex_state = 2},
  [1819] = {.lex_state = 17, .external_lex_state = 2},
  [1820] = {.lex_state = 17, .external_lex_state = 2},
  [1821] = {.lex_state = 17, .external_lex_state = 2},
  [1822] = {.lex_state = 17, .external_lex_state = 2},
  [1823] = {.lex_state = 17, .external_lex_state = 2},
  [1824] = {.lex_state = 17, .external_lex_state = 2},
  [1825] = {.lex_state = 17, .external_lex_state = 2},
  [1826] = {.lex_state = 1, .external_lex_state = 2},
  [1827] = {.lex_state = 1, .external_lex_state = 2},
  [1828] = {.lex_state = 84, .external_lex_state = 2},
  [1829] = {.lex_state = 17, .external_lex_state = 2},
  [1830] = {.lex_state = 1, .external_lex_state = 2},
  [1831] = {.lex_state = 84, .external_lex_state = 2},
  [1832] = {.lex_state = 17, .external_lex_state = 2},
  [1833] = {.lex_state = 17, .external_lex_state = 2},
  [1834] = {.lex_state = 1, .external_lex_state = 2},
  [1835] = {.lex_state = 17, .external_lex_state = 2},
  [1836] = {.lex_state = 84, .external_lex_state = 2},
  [1837] = {.lex_state = 1, .external_lex_state = 2},
  [1838] = {.lex_state = 17, .external_lex_state = 2},
  [1839] = {.lex_state = 17, .external_lex_state = 2},
  [1840] = {.lex_state = 1, .external_lex_state = 2},
  [1841] = {.lex_state = 17, .external_lex_state = 2},
  [1842] = {.lex_state = 17, .external_lex_state = 2},
  [1843] = {.lex_state = 1, .external_lex_state = 2},
  [1844] = {.lex_state = 84, .external_lex_state = 2},
  [1845] = {.lex_state = 17, .external_lex_state = 2},
  [1846] = {.lex_state = 84, .external_lex_state = 2},
  [1847] = {.lex_state = 17, .external_lex_state = 2},
  [1848] = {.lex_state = 17, .external_lex_state = 2},
  [1849] = {.lex_state = 1, .external_lex_state = 2},
  [1850] = {.lex_state = 1, .external_lex_state = 2},
  [1851] = {.lex_state = 1, .external_lex_state = 2},
  [1852] = {.lex_state = 1, .external_lex_state = 2},
  [1853] = {.lex_state = 1, .external_lex_state = 2},
  [1854] = {.lex_state = 1, .external_lex_state = 2},
  [1855] = {.lex_state = 17, .external_lex_state = 2},
  [1856] = {.lex_state = 1, .external_lex_state = 2},
  [1857] = {.lex_state = 17, .external_lex_state = 2},
  [1858] = {.lex_state = 17, .external_lex_state = 2},
  [1859] = {.lex_state = 1, .external_lex_state = 2},
  [1860] = {.lex_state = 84, .external_lex_state = 2},
  [1861] = {.lex_state = 1, .external_lex_state = 2},
  [1862] = {.lex_state = 1, .external_lex_state = 2},
  [1863] = {.lex_state = 1, .external_lex_state = 2},
  [1864] = {.lex_state = 84, .external_lex_state = 2},
  [1865] = {.lex_state = 1, .external_lex_state = 2},
  [1866] = {.lex_state = 1, .external_lex_state = 2},
  [1867] = {.lex_state = 17, .external_lex_state = 2},
  [1868] = {.lex_state = 1, .external_lex_state = 2},
  [1869] = {.lex_state = 1, .external_lex_state = 2},
  [1870] = {.lex_state = 1, .external_lex_state = 2},
  [1871] = {.lex_state = 1, .external_lex_state = 2},
  [1872] = {.lex_state = 1, .external_lex_state = 2},
  [1873] = {.lex_state = 1, .external_lex_state = 2},
  [1874] = {.lex_state = 1, .external_lex_state = 2},
  [1875] = {.lex_state = 1, .external_lex_state = 2},
  [1876] = {.lex_state = 1, .external_lex_state = 2},
  [1877] = {.lex_state = 1, .external_lex_state = 2},
  [1878] = {.lex_state = 1, .external_lex_state = 2},
  [1879] = {.lex_state = 1, .external_lex_state = 2},
  [1880] = {.lex_state = 1, .external_lex_state = 2},
  [1881] = {.lex_state = 1, .external_lex_state = 2},
  [1882] = {.lex_state = 1, .external_lex_state = 2},
  [1883] = {.lex_state = 1, .external_lex_state = 2},
  [1884] = {.lex_state = 1, .external_lex_state = 2},
  [1885] = {.lex_state = 1, .external_lex_state = 2},
  [1886] = {.lex_state = 1, .external_lex_state = 2},
  [1887] = {.lex_state = 1, .external_lex_state = 2},
  [1888] = {.lex_state = 1, .external_lex_state = 2},
  [1889] = {.lex_state = 1, .external_lex_state = 2},
  [1890] = {.lex_state = 1, .external_lex_state = 2},
  [1891] = {.lex_state = 1, .external_lex_state = 2},
  [1892] = {.lex_state = 1, .external_lex_state = 2},
  [1893] = {.lex_state = 1, .external_lex_state = 2},
  [1894] = {.lex_state = 1, .external_lex_state = 2},
  [1895] = {.lex_state = 1, .external_lex_state = 2},
  [1896] = {.lex_state = 1, .external_lex_state = 2},
  [1897] = {.lex_state = 1, .external_lex_state = 2},
  [1898] = {.lex_state = 1, .external_lex_state = 2},
  [1899] = {.lex_state = 1, .external_lex_state = 2},
  [1900] = {.lex_state = 1, .external_lex_state = 2},
  [1901] = {.lex_state = 1, .external_lex_state = 2},
  [1902] = {.lex_state = 1, .external_lex_state = 2},
  [1903] = {.lex_state = 1, .external_lex_state = 2},
  [1904] = {.lex_state = 1, .external_lex_state = 2},
  [1905] = {.lex_state = 1, .external_lex_state = 2},
  [1906] = {.lex_state = 1, .external_lex_state = 2},
  [1907] = {.lex_state = 1, .external_lex_state = 2},
  [1908] = {.lex_state = 1, .external_lex_state = 2},
  [1909] = {.lex_state = 1, .external_lex_state = 2},
  [1910] = {.lex_state = 1, .external_lex_state = 2},
  [1911] = {.lex_state = 17, .external_lex_state = 2},
  [1912] = {.lex_state = 17, .external_lex_state = 2},
  [1913] = {.lex_state = 17, .external_lex_state = 2},
  [1914] = {.lex_state = 17, .external_lex_state = 2},
  [1915] = {.lex_state = 17, .external_lex_state = 2},
  [1916] = {.lex_state = 17, .external_lex_state = 2},
  [1917] = {.lex_state = 17, .external_lex_state = 2},
  [1918] = {.lex_state = 17, .external_lex_state = 2},
  [1919] = {.lex_state = 17, .external_lex_state = 2},
  [1920] = {.lex_state = 17, .external_lex_state = 2},
  [1921] = {.lex_state = 17, .external_lex_state = 2},
  [1922] = {.lex_state = 17, .external_lex_state = 2},
  [1923] = {.lex_state = 17, .external_lex_state = 2},
  [1924] = {.lex_state = 17, .external_lex_state = 2},
  [1925] = {.lex_state = 17, .external_lex_state = 2},
  [1926] = {.lex_state = 17, .external_lex_state = 2},
  [1927] = {.lex_state = 17, .external_lex_state = 2},
  [1928] = {.lex_state = 17, .external_lex_state = 2},
  [1929] = {.lex_state = 8, .external_lex_state = 2},
  [1930] = {.lex_state = 8, .external_lex_state = 2},
  [1931] = {.lex_state = 8, .external_lex_state = 2},
  [1932] = {.lex_state = 8, .external_lex_state = 2},
  [1933] = {.lex_state = 8, .external_lex_state = 2},
  [1934] = {.lex_state = 24, .external_lex_state = 2},
  [1935] = {.lex_state = 24, .external_lex_state = 2},
  [1936] = {.lex_state = 93, .external_lex_state = 2},
  [1937] = {.lex_state = 93, .external_lex_state = 2},
  [1938] = {.lex_state = 93, .external_lex_state = 2},
  [1939] = {.lex_state = 93, .external_lex_state = 2},
  [1940] = {.lex_state = 85, .external_lex_state = 5},
  [1941] = {.lex_state = 89, .external_lex_state = 5},
  [1942] = {.lex_state = 32, .external_lex_state = 5},
  [1943] = {.lex_state = 85, .external_lex_state = 6},
  [1944] = {.lex_state = 30, .external_lex_state = 5},
  [1945] = {.lex_state = 85, .external_lex_state = 6},
  [1946] = {.lex_state = 85, .external_lex_state = 6},
  [1947] = {.lex_state = 89, .external_lex_state = 5},
  [1948] = {.lex_state = 89, .external_lex_state = 6},
  [1949] = {.lex_state = 85, .external_lex_state = 6},
  [1950] = {.lex_state = 85, .external_lex_state = 6},
  [1951] = {.lex_state = 85, .external_lex_state = 6},
  [1952] = {.lex_state = 85, .external_lex_state = 6},
  [1953] = {.lex_state = 85, .external_lex_state = 6},
  [1954] = {.lex_state = 85, .external_lex_state = 6},
  [1955] = {.lex_state = 85, .external_lex_state = 6},
  [1956] = {.lex_state = 85, .external_lex_state = 6},
  [1957] = {.lex_state = 85, .external_lex_state = 6},
  [1958] = {.lex_state = 85, .external_lex_state = 6},
  [1959] = {.lex_state = 85, .external_lex_state = 6},
  [1960] = {.lex_state = 85, .external_lex_state = 6},
  [1961] = {.lex_state = 85, .external_lex_state = 6},
  [1962] = {.lex_state = 85, .external_lex_state = 6},
  [1963] = {.lex_state = 85, .external_lex_state = 6},
  [1964] = {.lex_state = 85, .external_lex_state = 6},
  [1965] = {.lex_state = 85, .external_lex_state = 6},
  [1966] = {.lex_state = 85, .external_lex_state = 6},
  [1967] = {.lex_state = 85, .external_lex_state = 6},
  [1968] = {.lex_state = 85, .external_lex_state = 6},
  [1969] = {.lex_state = 85, .external_lex_state = 6},
  [1970] = {.lex_state = 85, .external_lex_state = 6},
  [1971] = {.lex_state = 38, .external_lex_state = 5},
  [1972] = {.lex_state = 85, .external_lex_state = 6},
  [1973] = {.lex_state = 85, .external_lex_state = 6},
  [1974] = {.lex_state = 25, .external_lex_state = 2},
  [1975] = {.lex_state = 85, .external_lex_state = 6},
  [1976] = {.lex_state = 85, .external_lex_state = 6},
  [1977] = {.lex_state = 85, .external_lex_state = 6},
  [1978] = {.lex_state = 85, .external_lex_state = 6},
  [1979] = {.lex_state = 85, .external_lex_state = 6},
  [1980] = {.lex_state = 85, .external_lex_state = 6},
  [1981] = {.lex_state = 85, .external_lex_state = 6},
  [1982] = {.lex_state = 85, .external_lex_state = 6},
  [1983] = {.lex_state = 85, .external_lex_state = 6},
  [1984] = {.lex_state = 85, .external_lex_state = 6},
  [1985] = {.lex_state = 25, .external_lex_state = 2},
  [1986] = {.lex_state = 25, .external_lex_state = 2},
  [1987] = {.lex_state = 85, .external_lex_state = 6},
  [1988] = {.lex_state = 85, .external_lex_state = 6},
  [1989] = {.lex_state = 85, .external_lex_state = 6},
  [1990] = {.lex_state = 85, .external_lex_state = 6},
  [1991] = {.lex_state = 85, .external_lex_state = 6},
  [1992] = {.lex_state = 85, .external_lex_state = 6},
  [1993] = {.lex_state = 85, .external_lex_state = 6},
  [1994] = {.lex_state = 85, .external_lex_state = 6},
  [1995] = {.lex_state = 85, .external_lex_state = 6},
  [1996] = {.lex_state = 30, .external_lex_state = 6},
  [1997] = {.lex_state = 85, .external_lex_state = 6},
  [1998] = {.lex_state = 85, .external_lex_state = 6},
  [1999] = {.lex_state = 25, .external_lex_state = 2},
  [2000] = {.lex_state = 85, .external_lex_state = 6},
  [2001] = {.lex_state = 85, .external_lex_state = 7},
  [2002] = {.lex_state = 30, .external_lex_state = 6},
  [2003] = {.lex_state = 85, .external_lex_state = 7},
  [2004] = {.lex_state = 85, .external_lex_state = 6},
  [2005] = {.lex_state = 25, .external_lex_state = 2},
  [2006] = {.lex_state = 30, .external_lex_state = 6},
  [2007] = {.lex_state = 36, .external_lex_state = 5},
  [2008] = {.lex_state = 25, .external_lex_state = 2},
  [2009] = {.lex_state = 85, .external_lex_state = 6},
  [2010] = {.lex_state = 25, .external_lex_state = 2},
  [2011] = {.lex_state = 25, .external_lex_state = 2},
  [2012] = {.lex_state = 25, .external_lex_state = 2},
  [2013] = {.lex_state = 87, .external_lex_state = 7},
  [2014] = {.lex_state = 30, .external_lex_state = 7},
  [2015] = {.lex_state = 87, .external_lex_state = 7},
  [2016] = {.lex_state = 30, .external_lex_state = 7},
  [2017] = {.lex_state = 30, .external_lex_state = 6},
  [2018] = {.lex_state = 30, .external_lex_state = 6},
  [2019] = {.lex_state = 30, .external_lex_state = 6},
  [2020] = {.lex_state = 30, .external_lex_state = 6},
  [2021] = {.lex_state = 30, .external_lex_state = 6},
  [2022] = {.lex_state = 30, .external_lex_state = 6},
  [2023] = {.lex_state = 30, .external_lex_state = 6},
  [2024] = {.lex_state = 30, .external_lex_state = 6},
  [2025] = {.lex_state = 30, .external_lex_state = 6},
  [2026] = {.lex_state = 30, .external_lex_state = 6},
  [2027] = {.lex_state = 30, .external_lex_state = 6},
  [2028] = {.lex_state = 32, .external_lex_state = 6},
  [2029] = {.lex_state = 30, .external_lex_state = 6},
  [2030] = {.lex_state = 30, .external_lex_state = 6},
  [2031] = {.lex_state = 30, .external_lex_state = 6},
  [2032] = {.lex_state = 30, .external_lex_state = 6},
  [2033] = {.lex_state = 30, .external_lex_state = 6},
  [2034] = {.lex_state = 30, .external_lex_state = 6},
  [2035] = {.lex_state = 30, .external_lex_state = 6},
  [2036] = {.lex_state = 30, .external_lex_state = 6},
  [2037] = {.lex_state = 30, .external_lex_state = 6},
  [2038] = {.lex_state = 30, .external_lex_state = 6},
  [2039] = {.lex_state = 30, .external_lex_state = 6},
  [2040] = {.lex_state = 30, .external_lex_state = 6},
  [2041] = {.lex_state = 87, .external_lex_state = 7},
  [2042] = {.lex_state = 30, .external_lex_state = 6},
  [2043] = {.lex_state = 87, .external_lex_state = 7},
  [2044] = {.lex_state = 85, .external_lex_state = 6},
  [2045] = {.lex_state = 85, .external_lex_state = 7},
  [2046] = {.lex_state = 30, .external_lex_state = 6},
  [2047] = {.lex_state = 85, .external_lex_state = 7},
  [2048] = {.lex_state = 85, .external_lex_state = 7},
  [2049] = {.lex_state = 30, .external_lex_state = 6},
  [2050] = {.lex_state = 30, .external_lex_state = 6},
  [2051] = {.lex_state = 30, .external_lex_state = 6},
  [2052] = {.lex_state = 85, .external_lex_state = 7},
  [2053] = {.lex_state = 30, .external_lex_state = 6},
  [2054] = {.lex_state = 85, .external_lex_state = 7},
  [2055] = {.lex_state = 30, .external_lex_state = 6},
  [2056] = {.lex_state = 30, .external_lex_state = 6},
  [2057] = {.lex_state = 85, .external_lex_state = 6},
  [2058] = {.lex_state = 30, .external_lex_state = 6},
  [2059] = {.lex_state = 85, .external_lex_state = 7},
  [2060] = {.lex_state = 30, .external_lex_state = 6},
  [2061] = {.lex_state = 85, .external_lex_state = 7},
  [2062] = {.lex_state = 30, .external_lex_state = 6},
  [2063] = {.lex_state = 30, .external_lex_state = 6},
  [2064] = {.lex_state = 85, .external_lex_state = 7},
  [2065] = {.lex_state = 85, .external_lex_state = 7},
  [2066] = {.lex_state = 30, .external_lex_state = 6},
  [2067] = {.lex_state = 85, .external_lex_state = 7},
  [2068] = {.lex_state = 85, .external_lex_state = 7},
  [2069] = {.lex_state = 30, .external_lex_state = 6},
  [2070] = {.lex_state = 85, .external_lex_state = 7},
  [2071] = {.lex_state = 36, .external_lex_state = 6},
  [2072] = {.lex_state = 85, .external_lex_state = 7},
  [2073] = {.lex_state = 89, .external_lex_state = 5},
  [2074] = {.lex_state = 36, .external_lex_state = 6},
  [2075] = {.lex_state = 89, .external_lex_state = 5},
  [2076] = {.lex_state = 30, .external_lex_state = 6},
  [2077] = {.lex_state = 85, .external_lex_state = 7},
  [2078] = {.lex_state = 30, .external_lex_state = 6},
  [2079] = {.lex_state = 30, .external_lex_state = 6},
  [2080] = {.lex_state = 30, .external_lex_state = 6},
  [2081] = {.lex_state = 85, .external_lex_state = 7},
  [2082] = {.lex_state = 85, .external_lex_state = 7},
  [2083] = {.lex_state = 34, .external_lex_state = 7},
  [2084] = {.lex_state = 30, .external_lex_state = 6},
  [2085] = {.lex_state = 30, .external_lex_state = 6},
  [2086] = {.lex_state = 30, .external_lex_state = 6},
  [2087] = {.lex_state = 85, .external_lex_state = 7},
  [2088] = {.lex_state = 85, .external_lex_state = 7},
  [2089] = {.lex_state = 36, .external_lex_state = 6},
  [2090] = {.lex_state = 30, .external_lex_state = 6},
  [2091] = {.lex_state = 30, .external_lex_state = 6},
  [2092] = {.lex_state = 30, .external_lex_state = 6},
  [2093] = {.lex_state = 85, .external_lex_state = 7},
  [2094] = {.lex_state = 85, .external_lex_state = 7},
  [2095] = {.lex_state = 38, .external_lex_state = 5},
  [2096] = {.lex_state = 30, .external_lex_state = 6},
  [2097] = {.lex_state = 85, .external_lex_state = 7},
  [2098] = {.lex_state = 85, .external_lex_state = 7},
  [2099] = {.lex_state = 85, .external_lex_state = 7},
  [2100] = {.lex_state = 85, .external_lex_state = 7},
  [2101] = {.lex_state = 85, .external_lex_state = 7},
  [2102] = {.lex_state = 85, .external_lex_state = 7},
  [2103] = {.lex_state = 85, .external_lex_state = 7},
  [2104] = {.lex_state = 85, .external_lex_state = 7},
  [2105] = {.lex_state = 85, .external_lex_state = 7},
  [2106] = {.lex_state = 85, .external_lex_state = 7},
  [2107] = {.lex_state = 85, .external_lex_state = 7},
  [2108] = {.lex_state = 85, .external_lex_state = 7},
  [2109] = {.lex_state = 85, .external_lex_state = 7},
  [2110] = {.lex_state = 85, .external_lex_state = 7},
  [2111] = {.lex_state = 85, .external_lex_state = 7},
  [2112] = {.lex_state = 85, .external_lex_state = 7},
  [2113] = {.lex_state = 85, .external_lex_state = 7},
  [2114] = {.lex_state = 85, .external_lex_state = 7},
  [2115] = {.lex_state = 85, .external_lex_state = 7},
  [2116] = {.lex_state = 85, .external_lex_state = 7},
  [2117] = {.lex_state = 85, .external_lex_state = 7},
  [2118] = {.lex_state = 85, .external_lex_state = 7},
  [2119] = {.lex_state = 85, .external_lex_state = 7},
  [2120] = {.lex_state = 85, .external_lex_state = 7},
  [2121] = {.lex_state = 85, .external_lex_state = 7},
  [2122] = {.lex_state = 85, .external_lex_state = 7},
  [2123] = {.lex_state = 85, .external_lex_state = 7},
  [2124] = {.lex_state = 85, .external_lex_state = 7},
  [2125] = {.lex_state = 34, .external_lex_state = 7},
  [2126] = {.lex_state = 85, .external_lex_state = 7},
  [2127] = {.lex_state = 85, .external_lex_state = 7},
  [2128] = {.lex_state = 34, .external_lex_state = 7},
  [2129] = {.lex_state = 85, .external_lex_state = 7},
  [2130] = {.lex_state = 85, .external_lex_state = 7},
  [2131] = {.lex_state = 85, .external_lex_state = 7},
  [2132] = {.lex_state = 85, .external_lex_state = 7},
  [2133] = {.lex_state = 85, .external_lex_state = 7},
  [2134] = {.lex_state = 85, .external_lex_state = 7},
  [2135] = {.lex_state = 85, .external_lex_state = 7},
  [2136] = {.lex_state = 85, .external_lex_state = 7},
  [2137] = {.lex_state = 85, .external_lex_state = 7},
  [2138] = {.lex_state = 85, .external_lex_state = 7},
  [2139] = {.lex_state = 85, .external_lex_state = 7},
  [2140] = {.lex_state = 85, .external_lex_state = 7},
  [2141] = {.lex_state = 85, .external_lex_state = 7},
  [2142] = {.lex_state = 85, .external_lex_state = 7},
  [2143] = {.lex_state = 85, .external_lex_state = 7},
  [2144] = {.lex_state = 85, .external_lex_state = 7},
  [2145] = {.lex_state = 34, .external_lex_state = 7},
  [2146] = {.lex_state = 85, .external_lex_state = 7},
  [2147] = {.lex_state = 85, .external_lex_state = 7},
  [2148] = {.lex_state = 85, .external_lex_state = 7},
  [2149] = {.lex_state = 85, .external_lex_state = 7},
  [2150] = {.lex_state = 85, .external_lex_state = 7},
  [2151] = {.lex_state = 85, .external_lex_state = 7},
  [2152] = {.lex_state = 85, .external_lex_state = 7},
  [2153] = {.lex_state = 85, .external_lex_state = 7},
  [2154] = {.lex_state = 36, .external_lex_state = 6},
  [2155] = {.lex_state = 85, .external_lex_state = 7},
  [2156] = {.lex_state = 85, .external_lex_state = 7},
  [2157] = {.lex_state = 85, .external_lex_state = 7},
  [2158] = {.lex_state = 85, .external_lex_state = 7},
  [2159] = {.lex_state = 85, .external_lex_state = 7},
  [2160] = {.lex_state = 85, .external_lex_state = 7},
  [2161] = {.lex_state = 85, .external_lex_state = 7},
  [2162] = {.lex_state = 38, .external_lex_state = 6},
  [2163] = {.lex_state = 85, .external_lex_state = 7},
  [2164] = {.lex_state = 85, .external_lex_state = 7},
  [2165] = {.lex_state = 85, .external_lex_state = 7},
  [2166] = {.lex_state = 36, .external_lex_state = 6},
  [2167] = {.lex_state = 85, .external_lex_state = 7},
  [2168] = {.lex_state = 85, .external_lex_state = 7},
  [2169] = {.lex_state = 85, .external_lex_state = 7},
  [2170] = {.lex_state = 85, .external_lex_state = 7},
  [2171] = {.lex_state = 85, .external_lex_state = 7},
  [2172] = {.lex_state = 85, .external_lex_state = 7},
  [2173] = {.lex_state = 85, .external_lex_state = 7},
  [2174] = {.lex_state = 85, .external_lex_state = 7},
  [2175] = {.lex_state = 85, .external_lex_state = 7},
  [2176] = {.lex_state = 85, .external_lex_state = 7},
  [2177] = {.lex_state = 85, .external_lex_state = 7},
  [2178] = {.lex_state = 85, .external_lex_state = 7},
  [2179] = {.lex_state = 85, .external_lex_state = 7},
  [2180] = {.lex_state = 85, .external_lex_state = 7},
  [2181] = {.lex_state = 85, .external_lex_state = 7},
  [2182] = {.lex_state = 38, .external_lex_state = 5},
  [2183] = {.lex_state = 85, .external_lex_state = 7},
  [2184] = {.lex_state = 85, .external_lex_state = 7},
  [2185] = {.lex_state = 85, .external_lex_state = 7},
  [2186] = {.lex_state = 85, .external_lex_state = 7},
  [2187] = {.lex_state = 85, .external_lex_state = 7},
  [2188] = {.lex_state = 85, .external_lex_state = 7},
  [2189] = {.lex_state = 85, .external_lex_state = 7},
  [2190] = {.lex_state = 85, .external_lex_state = 7},
  [2191] = {.lex_state = 85, .external_lex_state = 7},
  [2192] = {.lex_state = 85, .external_lex_state = 7},
  [2193] = {.lex_state = 85, .external_lex_state = 7},
  [2194] = {.lex_state = 85, .external_lex_state = 7},
  [2195] = {.lex_state = 85, .external_lex_state = 7},
  [2196] = {.lex_state = 36, .external_lex_state = 7},
  [2197] = {.lex_state = 85, .external_lex_state = 7},
  [2198] = {.lex_state = 85, .external_lex_state = 7},
  [2199] = {.lex_state = 85, .external_lex_state = 7},
  [2200] = {.lex_state = 85, .external_lex_state = 7},
  [2201] = {.lex_state = 85, .external_lex_state = 7},
  [2202] = {.lex_state = 85, .external_lex_state = 7},
  [2203] = {.lex_state = 85, .external_lex_state = 7},
  [2204] = {.lex_state = 85, .external_lex_state = 7},
  [2205] = {.lex_state = 85, .external_lex_state = 7},
  [2206] = {.lex_state = 85, .external_lex_state = 7},
  [2207] = {.lex_state = 85, .external_lex_state = 7},
  [2208] = {.lex_state = 36, .external_lex_state = 7},
  [2209] = {.lex_state = 85, .external_lex_state = 7},
  [2210] = {.lex_state = 85, .external_lex_state = 7},
  [2211] = {.lex_state = 85, .external_lex_state = 7},
  [2212] = {.lex_state = 36, .external_lex_state = 6},
  [2213] = {.lex_state = 36, .external_lex_state = 6},
  [2214] = {.lex_state = 36, .external_lex_state = 6},
  [2215] = {.lex_state = 36, .external_lex_state = 6},
  [2216] = {.lex_state = 36, .external_lex_state = 6},
  [2217] = {.lex_state = 36, .external_lex_state = 6},
  [2218] = {.lex_state = 36, .external_lex_state = 6},
  [2219] = {.lex_state = 85, .external_lex_state = 7},
  [2220] = {.lex_state = 36, .external_lex_state = 6},
  [2221] = {.lex_state = 85, .external_lex_state = 7},
  [2222] = {.lex_state = 36, .external_lex_state = 6},
  [2223] = {.lex_state = 36, .external_lex_state = 6},
  [2224] = {.lex_state = 36, .external_lex_state = 6},
  [2225] = {.lex_state = 36, .external_lex_state = 6},
  [2226] = {.lex_state = 36, .external_lex_state = 6},
  [2227] = {.lex_state = 36, .external_lex_state = 6},
  [2228] = {.lex_state = 36, .external_lex_state = 6},
  [2229] = {.lex_state = 36, .external_lex_state = 6},
  [2230] = {.lex_state = 36, .external_lex_state = 6},
  [2231] = {.lex_state = 36, .external_lex_state = 6},
  [2232] = {.lex_state = 36, .external_lex_state = 6},
  [2233] = {.lex_state = 36, .external_lex_state = 6},
  [2234] = {.lex_state = 36, .external_lex_state = 6},
  [2235] = {.lex_state = 36, .external_lex_state = 6},
  [2236] = {.lex_state = 36, .external_lex_state = 6},
  [2237] = {.lex_state = 36, .external_lex_state = 6},
  [2238] = {.lex_state = 36, .external_lex_state = 6},
  [2239] = {.lex_state = 36, .external_lex_state = 6},
  [2240] = {.lex_state = 36, .external_lex_state = 6},
  [2241] = {.lex_state = 36, .external_lex_state = 6},
  [2242] = {.lex_state = 36, .external_lex_state = 6},
  [2243] = {.lex_state = 36, .external_lex_state = 6},
  [2244] = {.lex_state = 30, .external_lex_state = 7},
  [2245] = {.lex_state = 36, .external_lex_state = 6},
  [2246] = {.lex_state = 85, .external_lex_state = 7},
  [2247] = {.lex_state = 36, .external_lex_state = 6},
  [2248] = {.lex_state = 36, .external_lex_state = 6},
  [2249] = {.lex_state = 36, .external_lex_state = 6},
  [2250] = {.lex_state = 36, .external_lex_state = 6},
  [2251] = {.lex_state = 36, .external_lex_state = 6},
  [2252] = {.lex_state = 36, .external_lex_state = 6},
  [2253] = {.lex_state = 36, .external_lex_state = 6},
  [2254] = {.lex_state = 36, .external_lex_state = 6},
  [2255] = {.lex_state = 36, .external_lex_state = 6},
  [2256] = {.lex_state = 36, .external_lex_state = 6},
  [2257] = {.lex_state = 36, .external_lex_state = 6},
  [2258] = {.lex_state = 85, .external_lex_state = 7},
  [2259] = {.lex_state = 85, .external_lex_state = 7},
  [2260] = {.lex_state = 36, .external_lex_state = 6},
  [2261] = {.lex_state = 85, .external_lex_state = 7},
  [2262] = {.lex_state = 41, .external_lex_state = 7},
  [2263] = {.lex_state = 36, .external_lex_state = 6},
  [2264] = {.lex_state = 85, .external_lex_state = 7},
  [2265] = {.lex_state = 85, .external_lex_state = 7},
  [2266] = {.lex_state = 30, .external_lex_state = 6},
  [2267] = {.lex_state = 30, .external_lex_state = 7},
  [2268] = {.lex_state = 30, .external_lex_state = 7},
  [2269] = {.lex_state = 85, .external_lex_state = 7},
  [2270] = {.lex_state = 85, .external_lex_state = 7},
  [2271] = {.lex_state = 30, .external_lex_state = 6},
  [2272] = {.lex_state = 85, .external_lex_state = 7},
  [2273] = {.lex_state = 30, .external_lex_state = 7},
  [2274] = {.lex_state = 30, .external_lex_state = 7},
  [2275] = {.lex_state = 30, .external_lex_state = 7},
  [2276] = {.lex_state = 85, .external_lex_state = 7},
  [2277] = {.lex_state = 30, .external_lex_state = 7},
  [2278] = {.lex_state = 85, .external_lex_state = 7},
  [2279] = {.lex_state = 85, .external_lex_state = 7},
  [2280] = {.lex_state = 30, .external_lex_state = 7},
  [2281] = {.lex_state = 85, .external_lex_state = 7},
  [2282] = {.lex_state = 30, .external_lex_state = 7},
  [2283] = {.lex_state = 85, .external_lex_state = 7},
  [2284] = {.lex_state = 85, .external_lex_state = 7},
  [2285] = {.lex_state = 85, .external_lex_state = 7},
  [2286] = {.lex_state = 30, .external_lex_state = 7},
  [2287] = {.lex_state = 30, .external_lex_state = 7},
  [2288] = {.lex_state = 85, .external_lex_state = 7},
  [2289] = {.lex_state = 30, .external_lex_state = 7},
  [2290] = {.lex_state = 30, .external_lex_state = 7},
  [2291] = {.lex_state = 85, .external_lex_state = 7},
  [2292] = {.lex_state = 30, .external_lex_state = 7},
  [2293] = {.lex_state = 85, .external_lex_state = 7},
  [2294] = {.lex_state = 30, .external_lex_state = 7},
  [2295] = {.lex_state = 85, .external_lex_state = 7},
  [2296] = {.lex_state = 30, .external_lex_state = 7},
  [2297] = {.lex_state = 85, .external_lex_state = 7},
  [2298] = {.lex_state = 85, .external_lex_state = 7},
  [2299] = {.lex_state = 85, .external_lex_state = 7},
  [2300] = {.lex_state = 85, .external_lex_state = 7},
  [2301] = {.lex_state = 85, .external_lex_state = 7},
  [2302] = {.lex_state = 30, .external_lex_state = 7},
  [2303] = {.lex_state = 30, .external_lex_state = 7},
  [2304] = {.lex_state = 36, .external_lex_state = 6},
  [2305] = {.lex_state = 85, .external_lex_state = 7},
  [2306] = {.lex_state = 30, .external_lex_state = 7},
  [2307] = {.lex_state = 30, .external_lex_state = 7},
  [2308] = {.lex_state = 85, .external_lex_state = 7},
  [2309] = {.lex_state = 30, .external_lex_state = 7},
  [2310] = {.lex_state = 36, .external_lex_state = 6},
  [2311] = {.lex_state = 30, .external_lex_state = 7},
  [2312] = {.lex_state = 85, .external_lex_state = 7},
  [2313] = {.lex_state = 85, .external_lex_state = 7},
  [2314] = {.lex_state = 30, .external_lex_state = 7},
  [2315] = {.lex_state = 30, .external_lex_state = 7},
  [2316] = {.lex_state = 30, .external_lex_state = 7},
  [2317] = {.lex_state = 30, .external_lex_state = 7},
  [2318] = {.lex_state = 30, .external_lex_state = 7},
  [2319] = {.lex_state = 30, .external_lex_state = 7},
  [2320] = {.lex_state = 85, .external_lex_state = 7},
  [2321] = {.lex_state = 30, .external_lex_state = 7},
  [2322] = {.lex_state = 30, .external_lex_state = 7},
  [2323] = {.lex_state = 30, .external_lex_state = 7},
  [2324] = {.lex_state = 30, .external_lex_state = 7},
  [2325] = {.lex_state = 30, .external_lex_state = 7},
  [2326] = {.lex_state = 30, .external_lex_state = 7},
  [2327] = {.lex_state = 30, .external_lex_state = 7},
  [2328] = {.lex_state = 30, .external_lex_state = 7},
  [2329] = {.lex_state = 30, .external_lex_state = 7},
  [2330] = {.lex_state = 30, .external_lex_state = 7},
  [2331] = {.lex_state = 30, .external_lex_state = 7},
  [2332] = {.lex_state = 30, .external_lex_state = 7},
  [2333] = {.lex_state = 30, .external_lex_state = 7},
  [2334] = {.lex_state = 30, .external_lex_state = 7},
  [2335] = {.lex_state = 41, .external_lex_state = 7},
  [2336] = {.lex_state = 30, .external_lex_state = 7},
  [2337] = {.lex_state = 30, .external_lex_state = 7},
  [2338] = {.lex_state = 30, .external_lex_state = 7},
  [2339] = {.lex_state = 30, .external_lex_state = 7},
  [2340] = {.lex_state = 30, .external_lex_state = 7},
  [2341] = {.lex_state = 30, .external_lex_state = 7},
  [2342] = {.lex_state = 30, .external_lex_state = 7},
  [2343] = {.lex_state = 30, .external_lex_state = 7},
  [2344] = {.lex_state = 30, .external_lex_state = 7},
  [2345] = {.lex_state = 30, .external_lex_state = 7},
  [2346] = {.lex_state = 30, .external_lex_state = 7},
  [2347] = {.lex_state = 30, .external_lex_state = 7},
  [2348] = {.lex_state = 30, .external_lex_state = 7},
  [2349] = {.lex_state = 30, .external_lex_state = 7},
  [2350] = {.lex_state = 30, .external_lex_state = 7},
  [2351] = {.lex_state = 30, .external_lex_state = 7},
  [2352] = {.lex_state = 30, .external_lex_state = 7},
  [2353] = {.lex_state = 30, .external_lex_state = 7},
  [2354] = {.lex_state = 30, .external_lex_state = 7},
  [2355] = {.lex_state = 30, .external_lex_state = 7},
  [2356] = {.lex_state = 30, .external_lex_state = 7},
  [2357] = {.lex_state = 30, .external_lex_state = 7},
  [2358] = {.lex_state = 30, .external_lex_state = 7},
  [2359] = {.lex_state = 30, .external_lex_state = 7},
  [2360] = {.lex_state = 30, .external_lex_state = 7},
  [2361] = {.lex_state = 30, .external_lex_state = 7},
  [2362] = {.lex_state = 30, .external_lex_state = 7},
  [2363] = {.lex_state = 30, .external_lex_state = 7},
  [2364] = {.lex_state = 30, .external_lex_state = 7},
  [2365] = {.lex_state = 30, .external_lex_state = 7},
  [2366] = {.lex_state = 30, .external_lex_state = 7},
  [2367] = {.lex_state = 30, .external_lex_state = 7},
  [2368] = {.lex_state = 30, .external_lex_state = 7},
  [2369] = {.lex_state = 30, .external_lex_state = 7},
  [2370] = {.lex_state = 30, .external_lex_state = 7},
  [2371] = {.lex_state = 30, .external_lex_state = 7},
  [2372] = {.lex_state = 30, .external_lex_state = 7},
  [2373] = {.lex_state = 30, .external_lex_state = 7},
  [2374] = {.lex_state = 30, .external_lex_state = 7},
  [2375] = {.lex_state = 30, .external_lex_state = 7},
  [2376] = {.lex_state = 30, .external_lex_state = 7},
  [2377] = {.lex_state = 30, .external_lex_state = 7},
  [2378] = {.lex_state = 30, .external_lex_state = 7},
  [2379] = {.lex_state = 30, .external_lex_state = 7},
  [2380] = {.lex_state = 30, .external_lex_state = 7},
  [2381] = {.lex_state = 30, .external_lex_state = 7},
  [2382] = {.lex_state = 30, .external_lex_state = 7},
  [2383] = {.lex_state = 30, .external_lex_state = 7},
  [2384] = {.lex_state = 30, .external_lex_state = 7},
  [2385] = {.lex_state = 30, .external_lex_state = 7},
  [2386] = {.lex_state = 30, .external_lex_state = 7},
  [2387] = {.lex_state = 30, .external_lex_state = 7},
  [2388] = {.lex_state = 30, .external_lex_state = 7},
  [2389] = {.lex_state = 30, .external_lex_state = 7},
  [2390] = {.lex_state = 30, .external_lex_state = 7},
  [2391] = {.lex_state = 30, .external_lex_state = 7},
  [2392] = {.lex_state = 30, .external_lex_state = 7},
  [2393] = {.lex_state = 30, .external_lex_state = 7},
  [2394] = {.lex_state = 30, .external_lex_state = 7},
  [2395] = {.lex_state = 30, .external_lex_state = 7},
  [2396] = {.lex_state = 30, .external_lex_state = 7},
  [2397] = {.lex_state = 30, .external_lex_state = 7},
  [2398] = {.lex_state = 30, .external_lex_state = 7},
  [2399] = {.lex_state = 30, .external_lex_state = 7},
  [2400] = {.lex_state = 30, .external_lex_state = 7},
  [2401] = {.lex_state = 30, .external_lex_state = 7},
  [2402] = {.lex_state = 30, .external_lex_state = 7},
  [2403] = {.lex_state = 30, .external_lex_state = 7},
  [2404] = {.lex_state = 30, .external_lex_state = 7},
  [2405] = {.lex_state = 30, .external_lex_state = 7},
  [2406] = {.lex_state = 30, .external_lex_state = 7},
  [2407] = {.lex_state = 30, .external_lex_state = 7},
  [2408] = {.lex_state = 30, .external_lex_state = 7},
  [2409] = {.lex_state = 30, .external_lex_state = 7},
  [2410] = {.lex_state = 30, .external_lex_state = 7},
  [2411] = {.lex_state = 30, .external_lex_state = 7},
  [2412] = {.lex_state = 30, .external_lex_state = 7},
  [2413] = {.lex_state = 30, .external_lex_state = 7},
  [2414] = {.lex_state = 41, .external_lex_state = 7},
  [2415] = {.lex_state = 30, .external_lex_state = 7},
  [2416] = {.lex_state = 30, .external_lex_state = 7},
  [2417] = {.lex_state = 30, .external_lex_state = 7},
  [2418] = {.lex_state = 30, .external_lex_state = 7},
  [2419] = {.lex_state = 30, .external_lex_state = 7},
  [2420] = {.lex_state = 30, .external_lex_state = 7},
  [2421] = {.lex_state = 30, .external_lex_state = 7},
  [2422] = {.lex_state = 30, .external_lex_state = 7},
  [2423] = {.lex_state = 30, .external_lex_state = 7},
  [2424] = {.lex_state = 30, .external_lex_state = 7},
  [2425] = {.lex_state = 30, .external_lex_state = 7},
  [2426] = {.lex_state = 41, .external_lex_state = 7},
  [2427] = {.lex_state = 30, .external_lex_state = 7},
  [2428] = {.lex_state = 30, .external_lex_state = 7},
  [2429] = {.lex_state = 30, .external_lex_state = 7},
  [2430] = {.lex_state = 30, .external_lex_state = 7},
  [2431] = {.lex_state = 30, .external_lex_state = 7},
  [2432] = {.lex_state = 30, .external_lex_state = 7},
  [2433] = {.lex_state = 30, .external_lex_state = 7},
  [2434] = {.lex_state = 30, .external_lex_state = 7},
  [2435] = {.lex_state = 30, .external_lex_state = 7},
  [2436] = {.lex_state = 30, .external_lex_state = 7},
  [2437] = {.lex_state = 30, .external_lex_state = 7},
  [2438] = {.lex_state = 30, .external_lex_state = 7},
  [2439] = {.lex_state = 30, .external_lex_state = 7},
  [2440] = {.lex_state = 30, .external_lex_state = 7},
  [2441] = {.lex_state = 30, .external_lex_state = 7},
  [2442] = {.lex_state = 30, .external_lex_state = 7},
  [2443] = {.lex_state = 30, .external_lex_state = 7},
  [2444] = {.lex_state = 30, .external_lex_state = 7},
  [2445] = {.lex_state = 30, .external_lex_state = 7},
  [2446] = {.lex_state = 36, .external_lex_state = 7},
  [2447] = {.lex_state = 36, .external_lex_state = 7},
  [2448] = {.lex_state = 36, .external_lex_state = 7},
  [2449] = {.lex_state = 36, .external_lex_state = 7},
  [2450] = {.lex_state = 36, .external_lex_state = 7},
  [2451] = {.lex_state = 36, .external_lex_state = 6},
  [2452] = {.lex_state = 36, .external_lex_state = 7},
  [2453] = {.lex_state = 36, .external_lex_state = 7},
  [2454] = {.lex_state = 30, .external_lex_state = 7},
  [2455] = {.lex_state = 30, .external_lex_state = 7},
  [2456] = {.lex_state = 36, .external_lex_state = 7},
  [2457] = {.lex_state = 85, .external_lex_state = 7},
  [2458] = {.lex_state = 36, .external_lex_state = 7},
  [2459] = {.lex_state = 36, .external_lex_state = 7},
  [2460] = {.lex_state = 36, .external_lex_state = 7},
  [2461] = {.lex_state = 36, .external_lex_state = 7},
  [2462] = {.lex_state = 36, .external_lex_state = 7},
  [2463] = {.lex_state = 36, .external_lex_state = 7},
  [2464] = {.lex_state = 36, .external_lex_state = 7},
  [2465] = {.lex_state = 36, .external_lex_state = 7},
  [2466] = {.lex_state = 36, .external_lex_state = 7},
  [2467] = {.lex_state = 36, .external_lex_state = 7},
  [2468] = {.lex_state = 85, .external_lex_state = 7},
  [2469] = {.lex_state = 36, .external_lex_state = 6},
  [2470] = {.lex_state = 36, .external_lex_state = 7},
  [2471] = {.lex_state = 36, .external_lex_state = 7},
  [2472] = {.lex_state = 36, .external_lex_state = 7},
  [2473] = {.lex_state = 36, .external_lex_state = 7},
  [2474] = {.lex_state = 36, .external_lex_state = 7},
  [2475] = {.lex_state = 36, .external_lex_state = 7},
  [2476] = {.lex_state = 36, .external_lex_state = 7},
  [2477] = {.lex_state = 36, .external_lex_state = 7},
  [2478] = {.lex_state = 36, .external_lex_state = 7},
  [2479] = {.lex_state = 36, .external_lex_state = 7},
  [2480] = {.lex_state = 36, .external_lex_state = 7},
  [2481] = {.lex_state = 36, .external_lex_state = 7},
  [2482] = {.lex_state = 36, .external_lex_state = 7},
  [2483] = {.lex_state = 36, .external_lex_state = 7},
  [2484] = {.lex_state = 36, .external_lex_state = 7},
  [2485] = {.lex_state = 36, .external_lex_state = 7},
  [2486] = {.lex_state = 36, .external_lex_state = 7},
  [2487] = {.lex_state = 36, .external_lex_state = 7},
  [2488] = {.lex_state = 36, .external_lex_state = 7},
  [2489] = {.lex_state = 36, .external_lex_state = 7},
  [2490] = {.lex_state = 36, .external_lex_state = 7},
  [2491] = {.lex_state = 36, .external_lex_state = 7},
  [2492] = {.lex_state = 36, .external_lex_state = 7},
  [2493] = {.lex_state = 36, .external_lex_state = 7},
  [2494] = {.lex_state = 36, .external_lex_state = 7},
  [2495] = {.lex_state = 36, .external_lex_state = 7},
  [2496] = {.lex_state = 85, .external_lex_state = 7},
  [2497] = {.lex_state = 36, .external_lex_state = 7},
  [2498] = {.lex_state = 36, .external_lex_state = 7},
  [2499] = {.lex_state = 36, .external_lex_state = 7},
  [2500] = {.lex_state = 36, .external_lex_state = 7},
  [2501] = {.lex_state = 36, .external_lex_state = 7},
  [2502] = {.lex_state = 36, .external_lex_state = 7},
  [2503] = {.lex_state = 36, .external_lex_state = 7},
  [2504] = {.lex_state = 36, .external_lex_state = 7},
  [2505] = {.lex_state = 36, .external_lex_state = 7},
  [2506] = {.lex_state = 36, .external_lex_state = 7},
  [2507] = {.lex_state = 36, .external_lex_state = 7},
  [2508] = {.lex_state = 36, .external_lex_state = 7},
  [2509] = {.lex_state = 36, .external_lex_state = 7},
  [2510] = {.lex_state = 36, .external_lex_state = 7},
  [2511] = {.lex_state = 36, .external_lex_state = 7},
  [2512] = {.lex_state = 36, .external_lex_state = 7},
  [2513] = {.lex_state = 36, .external_lex_state = 7},
  [2514] = {.lex_state = 36, .external_lex_state = 7},
  [2515] = {.lex_state = 36, .external_lex_state = 7},
  [2516] = {.lex_state = 36, .external_lex_state = 7},
  [2517] = {.lex_state = 36, .external_lex_state = 7},
  [2518] = {.lex_state = 36, .external_lex_state = 7},
  [2519] = {.lex_state = 36, .external_lex_state = 7},
  [2520] = {.lex_state = 36, .external_lex_state = 7},
  [2521] = {.lex_state = 36, .external_lex_state = 7},
  [2522] = {.lex_state = 36, .external_lex_state = 7},
  [2523] = {.lex_state = 36, .external_lex_state = 7},
  [2524] = {.lex_state = 36, .external_lex_state = 7},
  [2525] = {.lex_state = 36, .external_lex_state = 7},
  [2526] = {.lex_state = 36, .external_lex_state = 7},
  [2527] = {.lex_state = 36, .external_lex_state = 7},
  [2528] = {.lex_state = 36, .external_lex_state = 7},
  [2529] = {.lex_state = 36, .external_lex_state = 7},
  [2530] = {.lex_state = 36, .external_lex_state = 7},
  [2531] = {.lex_state = 36, .external_lex_state = 7},
  [2532] = {.lex_state = 36, .external_lex_state = 7},
  [2533] = {.lex_state = 36, .external_lex_state = 7},
  [2534] = {.lex_state = 36, .external_lex_state = 7},
  [2535] = {.lex_state = 36, .external_lex_state = 7},
  [2536] = {.lex_state = 36, .external_lex_state = 7},
  [2537] = {.lex_state = 36, .external_lex_state = 7},
  [2538] = {.lex_state = 36, .external_lex_state = 7},
  [2539] = {.lex_state = 36, .external_lex_state = 7},
  [2540] = {.lex_state = 36, .external_lex_state = 7},
  [2541] = {.lex_state = 36, .external_lex_state = 7},
  [2542] = {.lex_state = 36, .external_lex_state = 7},
  [2543] = {.lex_state = 36, .external_lex_state = 7},
  [2544] = {.lex_state = 36, .external_lex_state = 7},
  [2545] = {.lex_state = 36, .external_lex_state = 7},
  [2546] = {.lex_state = 36, .external_lex_state = 7},
  [2547] = {.lex_state = 36, .external_lex_state = 7},
  [2548] = {.lex_state = 36, .external_lex_state = 7},
  [2549] = {.lex_state = 36, .external_lex_state = 7},
  [2550] = {.lex_state = 36, .external_lex_state = 7},
  [2551] = {.lex_state = 36, .external_lex_state = 7},
  [2552] = {.lex_state = 36, .external_lex_state = 7},
  [2553] = {.lex_state = 36, .external_lex_state = 7},
  [2554] = {.lex_state = 36, .external_lex_state = 7},
  [2555] = {.lex_state = 36, .external_lex_state = 7},
  [2556] = {.lex_state = 36, .external_lex_state = 7},
  [2557] = {.lex_state = 36, .external_lex_state = 7},
  [2558] = {.lex_state = 36, .external_lex_state = 7},
  [2559] = {.lex_state = 36, .external_lex_state = 7},
  [2560] = {.lex_state = 36, .external_lex_state = 7},
  [2561] = {.lex_state = 36, .external_lex_state = 7},
  [2562] = {.lex_state = 36, .external_lex_state = 7},
  [2563] = {.lex_state = 36, .external_lex_state = 7},
  [2564] = {.lex_state = 36, .external_lex_state = 7},
  [2565] = {.lex_state = 36, .external_lex_state = 7},
  [2566] = {.lex_state = 36, .external_lex_state = 7},
  [2567] = {.lex_state = 36, .external_lex_state = 7},
  [2568] = {.lex_state = 36, .external_lex_state = 7},
  [2569] = {.lex_state = 36, .external_lex_state = 7},
  [2570] = {.lex_state = 36, .external_lex_state = 7},
  [2571] = {.lex_state = 36, .external_lex_state = 7},
  [2572] = {.lex_state = 36, .external_lex_state = 7},
  [2573] = {.lex_state = 36, .external_lex_state = 7},
  [2574] = {.lex_state = 36, .external_lex_state = 7},
  [2575] = {.lex_state = 36, .external_lex_state = 7},
  [2576] = {.lex_state = 36, .external_lex_state = 7},
  [2577] = {.lex_state = 36, .external_lex_state = 7},
  [2578] = {.lex_state = 36, .external_lex_state = 7},
  [2579] = {.lex_state = 36, .external_lex_state = 7},
  [2580] = {.lex_state = 36, .external_lex_state = 7},
  [2581] = {.lex_state = 36, .external_lex_state = 7},
  [2582] = {.lex_state = 36, .external_lex_state = 7},
  [2583] = {.lex_state = 36, .external_lex_state = 7},
  [2584] = {.lex_state = 36, .external_lex_state = 7},
  [2585] = {.lex_state = 36, .external_lex_state = 7},
  [2586] = {.lex_state = 36, .external_lex_state = 7},
  [2587] = {.lex_state = 36, .external_lex_state = 7},
  [2588] = {.lex_state = 36, .external_lex_state = 7},
  [2589] = {.lex_state = 36, .external_lex_state = 7},
  [2590] = {.lex_state = 36, .external_lex_state = 7},
  [2591] = {.lex_state = 36, .external_lex_state = 7},
  [2592] = {.lex_state = 36, .external_lex_state = 7},
  [2593] = {.lex_state = 36, .external_lex_state = 7},
  [2594] = {.lex_state = 36, .external_lex_state = 7},
  [2595] = {.lex_state = 36, .external_lex_state = 7},
  [2596] = {.lex_state = 36, .external_lex_state = 7},
  [2597] = {.lex_state = 30, .external_lex_state = 7},
  [2598] = {.lex_state = 85, .external_lex_state = 7},
  [2599] = {.lex_state = 36, .external_lex_state = 7},
  [2600] = {.lex_state = 36, .external_lex_state = 7},
  [2601] = {.lex_state = 85, .external_lex_state = 7},
  [2602] = {.lex_state = 85, .external_lex_state = 7},
  [2603] = {.lex_state = 85, .external_lex_state = 7},
  [2604] = {.lex_state = 85, .external_lex_state = 7},
  [2605] = {.lex_state = 36, .external_lex_state = 7},
  [2606] = {.lex_state = 36, .external_lex_state = 7},
  [2607] = {.lex_state = 36, .external_lex_state = 7},
  [2608] = {.lex_state = 36, .external_lex_state = 7},
  [2609] = {.lex_state = 85, .external_lex_state = 7},
  [2610] = {.lex_state = 85, .external_lex_state = 7},
  [2611] = {.lex_state = 85, .external_lex_state = 7},
  [2612] = {.lex_state = 85, .external_lex_state = 7},
  [2613] = {.lex_state = 85, .external_lex_state = 7},
  [2614] = {.lex_state = 36, .external_lex_state = 7},
  [2615] = {.lex_state = 36, .external_lex_state = 7},
  [2616] = {.lex_state = 36, .external_lex_state = 7},
  [2617] = {.lex_state = 85, .external_lex_state = 7},
  [2618] = {.lex_state = 85, .external_lex_state = 7},
  [2619] = {.lex_state = 85, .external_lex_state = 7},
  [2620] = {.lex_state = 85, .external_lex_state = 7},
  [2621] = {.lex_state = 85, .external_lex_state = 7},
  [2622] = {.lex_state = 85, .external_lex_state = 7},
  [2623] = {.lex_state = 85, .external_lex_state = 7},
  [2624] = {.lex_state = 85, .external_lex_state = 7},
  [2625] = {.lex_state = 85, .external_lex_state = 7},
  [2626] = {.lex_state = 36, .external_lex_state = 7},
  [2627] = {.lex_state = 85, .external_lex_state = 7},
  [2628] = {.lex_state = 85, .external_lex_state = 7},
  [2629] = {.lex_state = 85, .external_lex_state = 7},
  [2630] = {.lex_state = 36, .external_lex_state = 7},
  [2631] = {.lex_state = 85, .external_lex_state = 7},
  [2632] = {.lex_state = 36, .external_lex_state = 7},
  [2633] = {.lex_state = 85, .external_lex_state = 7},
  [2634] = {.lex_state = 36, .external_lex_state = 7},
  [2635] = {.lex_state = 85, .external_lex_state = 7},
  [2636] = {.lex_state = 36, .external_lex_state = 7},
  [2637] = {.lex_state = 36, .external_lex_state = 7},
  [2638] = {.lex_state = 85, .external_lex_state = 7},
  [2639] = {.lex_state = 36, .external_lex_state = 7},
  [2640] = {.lex_state = 85, .external_lex_state = 7},
  [2641] = {.lex_state = 85, .external_lex_state = 7},
  [2642] = {.lex_state = 36, .external_lex_state = 7},
  [2643] = {.lex_state = 85, .external_lex_state = 7},
  [2644] = {.lex_state = 85, .external_lex_state = 7},
  [2645] = {.lex_state = 85, .external_lex_state = 7},
  [2646] = {.lex_state = 85, .external_lex_state = 7},
  [2647] = {.lex_state = 85, .external_lex_state = 7},
  [2648] = {.lex_state = 36, .external_lex_state = 7},
  [2649] = {.lex_state = 85, .external_lex_state = 7},
  [2650] = {.lex_state = 36, .external_lex_state = 7},
  [2651] = {.lex_state = 36, .external_lex_state = 7},
  [2652] = {.lex_state = 85, .external_lex_state = 7},
  [2653] = {.lex_state = 85, .external_lex_state = 7},
  [2654] = {.lex_state = 85, .external_lex_state = 7},
  [2655] = {.lex_state = 85, .external_lex_state = 7},
  [2656] = {.lex_state = 85, .external_lex_state = 7},
  [2657] = {.lex_state = 85, .external_lex_state = 7},
  [2658] = {.lex_state = 85, .external_lex_state = 7},
  [2659] = {.lex_state = 85, .external_lex_state = 7},
  [2660] = {.lex_state = 85, .external_lex_state = 7},
  [2661] = {.lex_state = 85, .external_lex_state = 7},
  [2662] = {.lex_state = 85, .external_lex_state = 7},
  [2663] = {.lex_state = 36, .external_lex_state = 7},
  [2664] = {.lex_state = 85, .external_lex_state = 7},
  [2665] = {.lex_state = 85, .external_lex_state = 7},
  [2666] = {.lex_state = 36, .external_lex_state = 7},
  [2667] = {.lex_state = 85, .external_lex_state = 7},
  [2668] = {.lex_state = 36, .external_lex_state = 7},
  [2669] = {.lex_state = 36, .external_lex_state = 7},
  [2670] = {.lex_state = 36, .external_lex_state = 7},
  [2671] = {.lex_state = 85, .external_lex_state = 7},
  [2672] = {.lex_state = 30, .external_lex_state = 7},
  [2673] = {.lex_state = 30, .external_lex_state = 7},
  [2674] = {.lex_state = 36, .external_lex_state = 7},
  [2675] = {.lex_state = 30, .external_lex_state = 7},
  [2676] = {.lex_state = 30, .external_lex_state = 7},
  [2677] = {.lex_state = 30, .external_lex_state = 7},
  [2678] = {.lex_state = 30, .external_lex_state = 7},
  [2679] = {.lex_state = 30, .external_lex_state = 7},
  [2680] = {.lex_state = 30, .external_lex_state = 7},
  [2681] = {.lex_state = 30, .external_lex_state = 7},
  [2682] = {.lex_state = 36, .external_lex_state = 7},
  [2683] = {.lex_state = 36, .external_lex_state = 7},
  [2684] = {.lex_state = 36, .external_lex_state = 7},
  [2685] = {.lex_state = 36, .external_lex_state = 7},
  [2686] = {.lex_state = 36, .external_lex_state = 7},
  [2687] = {.lex_state = 36, .external_lex_state = 7},
  [2688] = {.lex_state = 36, .external_lex_state = 7},
  [2689] = {.lex_state = 36, .external_lex_state = 7},
  [2690] = {.lex_state = 36, .external_lex_state = 7},
  [2691] = {.lex_state = 36, .external_lex_state = 7},
  [2692] = {.lex_state = 36, .external_lex_state = 7},
  [2693] = {.lex_state = 36, .external_lex_state = 7},
  [2694] = {.lex_state = 36, .external_lex_state = 7},
  [2695] = {.lex_state = 36, .external_lex_state = 7},
  [2696] = {.lex_state = 36, .external_lex_state = 7},
  [2697] = {.lex_state = 36, .external_lex_state = 7},
  [2698] = {.lex_state = 36, .external_lex_state = 7},
  [2699] = {.lex_state = 36, .external_lex_state = 7},
  [2700] = {.lex_state = 36, .external_lex_state = 7},
  [2701] = {.lex_state = 36, .external_lex_state = 7},
  [2702] = {.lex_state = 36, .external_lex_state = 7},
  [2703] = {.lex_state = 36, .external_lex_state = 7},
  [2704] = {.lex_state = 36, .external_lex_state = 7},
  [2705] = {.lex_state = 36, .external_lex_state = 7},
  [2706] = {.lex_state = 36, .external_lex_state = 7},
  [2707] = {.lex_state = 36, .external_lex_state = 7},
  [2708] = {.lex_state = 36, .external_lex_state = 7},
  [2709] = {.lex_state = 36, .external_lex_state = 7},
  [2710] = {.lex_state = 36, .external_lex_state = 7},
  [2711] = {.lex_state = 36, .external_lex_state = 7},
  [2712] = {.lex_state = 36, .external_lex_state = 7},
  [2713] = {.lex_state = 36, .external_lex_state = 7},
  [2714] = {.lex_state = 36, .external_lex_state = 7},
  [2715] = {.lex_state = 36, .external_lex_state = 7},
  [2716] = {.lex_state = 36, .external_lex_state = 7},
  [2717] = {.lex_state = 36, .external_lex_state = 7},
  [2718] = {.lex_state = 36, .external_lex_state = 7},
  [2719] = {.lex_state = 36, .external_lex_state = 7},
  [2720] = {.lex_state = 36, .external_lex_state = 7},
  [2721] = {.lex_state = 36, .external_lex_state = 7},
  [2722] = {.lex_state = 36, .external_lex_state = 7},
  [2723] = {.lex_state = 36, .external_lex_state = 7},
  [2724] = {.lex_state = 36, .external_lex_state = 7},
  [2725] = {.lex_state = 36, .external_lex_state = 7},
  [2726] = {.lex_state = 36, .external_lex_state = 7},
  [2727] = {.lex_state = 36, .external_lex_state = 7},
  [2728] = {.lex_state = 36, .external_lex_state = 7},
  [2729] = {.lex_state = 36, .external_lex_state = 7},
  [2730] = {.lex_state = 36, .external_lex_state = 7},
  [2731] = {.lex_state = 36, .external_lex_state = 7},
  [2732] = {.lex_state = 36, .external_lex_state = 7},
  [2733] = {.lex_state = 91, .external_lex_state = 7},
  [2734] = {.lex_state = 91, .external_lex_state = 7},
  [2735] = {.lex_state = 42, .external_lex_state = 5},
  [2736] = {.lex_state = 26, .external_lex_state = 7},
  [2737] = {.lex_state = 26, .external_lex_state = 7},
  [2738] = {.lex_state = 26, .external_lex_state = 7},
  [2739] = {.lex_state = 26, .external_lex_state = 7},
  [2740] = {.lex_state = 26, .external_lex_state = 7},
  [2741] = {.lex_state = 26, .external_lex_state = 7},
  [2742] = {.lex_state = 26, .external_lex_state = 7},
  [2743] = {.lex_state = 26, .external_lex_state = 7},
  [2744] = {.lex_state = 26, .external_lex_state = 7},
  [2745] = {.lex_state = 26, .external_lex_state = 7},
  [2746] = {.lex_state = 26, .external_lex_state = 7},
  [2747] = {.lex_state = 26, .external_lex_state = 7},
  [2748] = {.lex_state = 91, .external_lex_state = 7},
  [2749] = {.lex_state = 26, .external_lex_state = 7},
  [2750] = {.lex_state = 25, .external_lex_state = 7},
  [2751] = {.lex_state = 25, .external_lex_state = 7},
  [2752] = {.lex_state = 25, .external_lex_state = 7},
  [2753] = {.lex_state = 25, .external_lex_state = 7},
  [2754] = {.lex_state = 91, .external_lex_state = 7},
  [2755] = {.lex_state = 25, .external_lex_state = 7},
  [2756] = {.lex_state = 25, .external_lex_state = 7},
  [2757] = {.lex_state = 91, .external_lex_state = 7},
  [2758] = {.lex_state = 25, .external_lex_state = 7},
  [2759] = {.lex_state = 25, .external_lex_state = 7},
  [2760] = {.lex_state = 78, .external_lex_state = 7},
  [2761] = {.lex_state = 78, .external_lex_state = 7},
  [2762] = {.lex_state = 78, .external_lex_state = 7},
  [2763] = {.lex_state = 78, .external_lex_state = 7},
  [2764] = {.lex_state = 44, .external_lex_state = 7},
  [2765] = {.lex_state = 42, .external_lex_state = 6},
  [2766] = {.lex_state = 91, .external_lex_state = 7},
  [2767] = {.lex_state = 91, .external_lex_state = 7},
  [2768] = {.lex_state = 42, .external_lex_state = 6},
  [2769] = {.lex_state = 42, .external_lex_state = 6},
  [2770] = {.lex_state = 0, .external_lex_state = 7},
  [2771] = {.lex_state = 0, .external_lex_state = 7},
  [2772] = {.lex_state = 42, .external_lex_state = 6},
  [2773] = {.lex_state = 0, .external_lex_state = 7},
  [2774] = {.lex_state = 0, .external_lex_state = 7},
  [2775] = {.lex_state = 42, .external_lex_state = 8},
  [2776] = {.lex_state = 42, .external_lex_state = 9},
  [2777] = {.lex_state = 42, .external_lex_state = 8},
  [2778] = {.lex_state = 44, .external_lex_state = 7},
  [2779] = {.lex_state = 42, .external_lex_state = 8},
  [2780] = {.lex_state = 42, .external_lex_state = 9},
  [2781] = {.lex_state = 42, .external_lex_state = 8},
  [2782] = {.lex_state = 42, .external_lex_state = 9},
  [2783] = {.lex_state = 42, .external_lex_state = 9},
  [2784] = {.lex_state = 42, .external_lex_state = 8},
  [2785] = {.lex_state = 42, .external_lex_state = 9},
  [2786] = {.lex_state = 42, .external_lex_state = 8},
  [2787] = {.lex_state = 42, .external_lex_state = 9},
  [2788] = {.lex_state = 42, .external_lex_state = 9},
  [2789] = {.lex_state = 42, .external_lex_state = 8},
  [2790] = {.lex_state = 42, .external_lex_state = 8},
  [2791] = {.lex_state = 42, .external_lex_state = 9},
  [2792] = {.lex_state = 42, .external_lex_state = 7},
  [2793] = {.lex_state = 0, .external_lex_state = 7},
  [2794] = {.lex_state = 0, .external_lex_state = 7},
  [2795] = {.lex_state = 0, .external_lex_state = 7},
  [2796] = {.lex_state = 42, .external_lex_state = 8},
  [2797] = {.lex_state = 0, .external_lex_state = 7},
  [2798] = {.lex_state = 0, .external_lex_state = 7},
  [2799] = {.lex_state = 0, .external_lex_state = 7},
  [2800] = {.lex_state = 42, .external_lex_state = 7},
  [2801] = {.lex_state = 0, .external_lex_state = 7},
  [2802] = {.lex_state = 42, .external_lex_state = 8},
  [2803] = {.lex_state = 42, .external_lex_state = 9},
  [2804] = {.lex_state = 42, .external_lex_state = 9},
  [2805] = {.lex_state = 0, .external_lex_state = 7},
  [2806] = {.lex_state = 0, .external_lex_state = 7},
  [2807] = {.lex_state = 0, .external_lex_state = 7},
  [2808] = {.lex_state = 0, .external_lex_state = 7},
  [2809] = {.lex_state = 0, .external_lex_state = 7},
  [2810] = {.lex_state = 0, .external_lex_state = 7},
  [2811] = {.lex_state = 0, .external_lex_state = 7},
  [2812] = {.lex_state = 0, .external_lex_state = 7},
  [2813] = {.lex_state = 0, .external_lex_state = 7},
  [2814] = {.lex_state = 0, .external_lex_state = 7},
  [2815] = {.lex_state = 44, .external_lex_state = 7},
  [2816] = {.lex_state = 0, .external_lex_state = 7},
  [2817] = {.lex_state = 0, .external_lex_state = 7},
  [2818] = {.lex_state = 0, .external_lex_state = 7},
  [2819] = {.lex_state = 0, .external_lex_state = 7},
  [2820] = {.lex_state = 0, .external_lex_state = 7},
  [2821] = {.lex_state = 42, .external_lex_state = 9},
  [2822] = {.lex_state = 0, .external_lex_state = 7},
  [2823] = {.lex_state = 0, .external_lex_state = 7},
  [2824] = {.lex_state = 0, .external_lex_state = 7},
  [2825] = {.lex_state = 0, .external_lex_state = 7},
  [2826] = {.lex_state = 0, .external_lex_state = 7},
  [2827] = {.lex_state = 42, .external_lex_state = 8},
  [2828] = {.lex_state = 42, .external_lex_state = 9},
  [2829] = {.lex_state = 0, .external_lex_state = 7},
  [2830] = {.lex_state = 42, .external_lex_state = 8},
  [2831] = {.lex_state = 0, .external_lex_state = 7},
  [2832] = {.lex_state = 0, .external_lex_state = 7},
  [2833] = {.lex_state = 42, .external_lex_state = 8},
  [2834] = {.lex_state = 0, .external_lex_state = 7},
  [2835] = {.lex_state = 42, .external_lex_state = 9},
  [2836] = {.lex_state = 91, .external_lex_state = 7},
  [2837] = {.lex_state = 42, .external_lex_state = 9},
  [2838] = {.lex_state = 0, .external_lex_state = 7},
  [2839] = {.lex_state = 0, .external_lex_state = 7},
  [2840] = {.lex_state = 0, .external_lex_state = 7},
  [2841] = {.lex_state = 0, .external_lex_state = 7},
  [2842] = {.lex_state = 42, .external_lex_state = 8},
  [2843] = {.lex_state = 0, .external_lex_state = 7},
  [2844] = {.lex_state = 0, .external_lex_state = 7},
  [2845] = {.lex_state = 0, .external_lex_state = 7},
  [2846] = {.lex_state = 42, .external_lex_state = 9},
  [2847] = {.lex_state = 0, .external_lex_state = 7},
  [2848] = {.lex_state = 0, .external_lex_state = 7},
  [2849] = {.lex_state = 0, .external_lex_state = 7},
  [2850] = {.lex_state = 42, .external_lex_state = 8},
  [2851] = {.lex_state = 0, .external_lex_state = 7},
  [2852] = {.lex_state = 42, .external_lex_state = 8},
  [2853] = {.lex_state = 42, .external_lex_state = 9},
  [2854] = {.lex_state = 42, .external_lex_state = 9},
  [2855] = {.lex_state = 42, .external_lex_state = 8},
  [2856] = {.lex_state = 0, .external_lex_state = 7},
  [2857] = {.lex_state = 44, .external_lex_state = 7},
  [2858] = {.lex_state = 0, .external_lex_state = 7},
  [2859] = {.lex_state = 0, .external_lex_state = 7},
  [2860] = {.lex_state = 0, .external_lex_state = 7},
  [2861] = {.lex_state = 0, .external_lex_state = 7},
  [2862] = {.lex_state = 42, .external_lex_state = 6},
  [2863] = {.lex_state = 0, .external_lex_state = 7},
  [2864] = {.lex_state = 0, .external_lex_state = 7},
  [2865] = {.lex_state = 42, .external_lex_state = 6},
  [2866] = {.lex_state = 32, .external_lex_state = 7},
  [2867] = {.lex_state = 32, .external_lex_state = 7},
  [2868] = {.lex_state = 0, .external_lex_state = 7},
  [2869] = {.lex_state = 44, .external_lex_state = 7},
  [2870] = {.lex_state = 32, .external_lex_state = 7},
  [2871] = {.lex_state = 32, .external_lex_state = 7},
  [2872] = {.lex_state = 0, .external_lex_state = 7},
  [2873] = {.lex_state = 91, .external_lex_state = 7},
  [2874] = {.lex_state = 0, .external_lex_state = 7},
  [2875] = {.lex_state = 0, .external_lex_state = 7},
  [2876] = {.lex_state = 0, .external_lex_state = 7},
  [2877] = {.lex_state = 42, .external_lex_state = 6},
  [2878] = {.lex_state = 0, .external_lex_state = 7},
  [2879] = {.lex_state = 32, .external_lex_state = 7},
  [2880] = {.lex_state = 0, .external_lex_state = 7},
  [2881] = {.lex_state = 42, .external_lex_state = 6},
  [2882] = {.lex_state = 91, .external_lex_state = 7},
  [2883] = {.lex_state = 42, .external_lex_state = 6},
  [2884] = {.lex_state = 42, .external_lex_state = 6},
  [2885] = {.lex_state = 0, .external_lex_state = 7},
  [2886] = {.lex_state = 0, .external_lex_state = 7},
  [2887] = {.lex_state = 0, .external_lex_state = 7},
  [2888] = {.lex_state = 42, .external_lex_state = 6},
  [2889] = {.lex_state = 32, .external_lex_state = 7},
  [2890] = {.lex_state = 42, .external_lex_state = 6},
  [2891] = {.lex_state = 32, .external_lex_state = 7},
  [2892] = {.lex_state = 0, .external_lex_state = 7},
  [2893] = {.lex_state = 0, .external_lex_state = 7},
  [2894] = {.lex_state = 0, .external_lex_state = 7},
  [2895] = {.lex_state = 32, .external_lex_state = 7},
  [2896] = {.lex_state = 42, .external_lex_state = 6},
  [2897] = {.lex_state = 42, .external_lex_state = 6},
  [2898] = {.lex_state = 0, .external_lex_state = 7},
  [2899] = {.lex_state = 0, .external_lex_state = 7},
  [2900] = {.lex_state = 42, .external_lex_state = 6},
  [2901] = {.lex_state = 0, .external_lex_state = 7},
  [2902] = {.lex_state = 0, .external_lex_state = 10},
  [2903] = {.lex_state = 0, .external_lex_state = 7},
  [2904] = {.lex_state = 0, .external_lex_state = 11},
  [2905] = {.lex_state = 0, .external_lex_state = 10},
  [2906] = {.lex_state = 0, .external_lex_state = 7},
  [2907] = {.lex_state = 0, .external_lex_state = 11},
  [2908] = {.lex_state = 0, .external_lex_state = 10},
  [2909] = {.lex_state = 0, .external_lex_state = 11},
  [2910] = {.lex_state = 42, .external_lex_state = 7},
  [2911] = {.lex_state = 42, .external_lex_state = 7},
  [2912] = {.lex_state = 42, .external_lex_state = 7},
  [2913] = {.lex_state = 0, .external_lex_state = 7},
  [2914] = {.lex_state = 0, .external_lex_state = 7},
  [2915] = {.lex_state = 42, .external_lex_state = 7},
  [2916] = {.lex_state = 0, .external_lex_state = 7},
  [2917] = {.lex_state = 0, .external_lex_state = 7},
  [2918] = {.lex_state = 0, .external_lex_state = 10},
  [2919] = {.lex_state = 0, .external_lex_state = 11},
  [2920] = {.lex_state = 0, .external_lex_state = 7},
  [2921] = {.lex_state = 0, .external_lex_state = 10},
  [2922] = {.lex_state = 0, .external_lex_state = 7},
  [2923] = {.lex_state = 42, .external_lex_state = 8},
  [2924] = {.lex_state = 0, .external_lex_state = 11},
  [2925] = {.lex_state = 0, .external_lex_state = 10},
  [2926] = {.lex_state = 0, .external_lex_state = 11},
  [2927] = {.lex_state = 0, .external_lex_state = 10},
  [2928] = {.lex_state = 0, .external_lex_state = 7},
  [2929] = {.lex_state = 0, .external_lex_state = 7},
  [2930] = {.lex_state = 0, .external_lex_state = 7},
  [2931] = {.lex_state = 42, .external_lex_state = 7},
  [2932] = {.lex_state = 0, .external_lex_state = 11},
  [2933] = {.lex_state = 0, .external_lex_state = 10},
  [2934] = {.lex_state = 42, .external_lex_state = 7},
  [2935] = {.lex_state = 0, .external_lex_state = 11},
  [2936] = {.lex_state = 0, .external_lex_state = 7},
  [2937] = {.lex_state = 42, .external_lex_state = 7},
  [2938] = {.lex_state = 0, .external_lex_state = 7},
  [2939] = {.lex_state = 0, .external_lex_state = 7},
  [2940] = {.lex_state = 0, .external_lex_state = 7},
  [2941] = {.lex_state = 0, .external_lex_state = 7},
  [2942] = {.lex_state = 0, .external_lex_state = 7},
  [2943] = {.lex_state = 0, .external_lex_state = 7},
  [2944] = {.lex_state = 0, .external_lex_state = 7},
  [2945] = {.lex_state = 0, .external_lex_state = 7},
  [2946] = {.lex_state = 42, .external_lex_state = 7},
  [2947] = {.lex_state = 0, .external_lex_state = 7},
  [2948] = {.lex_state = 42, .external_lex_state = 7},
  [2949] = {.lex_state = 0, .external_lex_state = 7},
  [2950] = {.lex_state = 0, .external_lex_state = 7},
  [2951] = {.lex_state = 0, .external_lex_state = 7},
  [2952] = {.lex_state = 42, .external_lex_state = 8},
  [2953] = {.lex_state = 32, .external_lex_state = 7},
  [2954] = {.lex_state = 78, .external_lex_state = 7},
  [2955] = {.lex_state = 0, .external_lex_state = 7},
  [2956] = {.lex_state = 0, .external_lex_state = 7},
  [2957] = {.lex_state = 42, .external_lex_state = 7},
  [2958] = {.lex_state = 0, .external_lex_state = 7},
  [2959] = {.lex_state = 0, .external_lex_state = 7},
  [2960] = {.lex_state = 42, .external_lex_state = 7},
  [2961] = {.lex_state = 0, .external_lex_state = 7},
  [2962] = {.lex_state = 0, .external_lex_state = 7},
  [2963] = {.lex_state = 0, .external_lex_state = 7},
  [2964] = {.lex_state = 0, .external_lex_state = 7},
  [2965] = {.lex_state = 0, .external_lex_state = 10},
  [2966] = {.lex_state = 0, .external_lex_state = 10},
  [2967] = {.lex_state = 0, .external_lex_state = 11},
  [2968] = {.lex_state = 0, .external_lex_state = 7},
  [2969] = {.lex_state = 0, .external_lex_state = 7},
  [2970] = {.lex_state = 42, .external_lex_state = 6},
  [2971] = {.lex_state = 0, .external_lex_state = 7},
  [2972] = {.lex_state = 0, .external_lex_state = 7},
  [2973] = {.lex_state = 0, .external_lex_state = 7},
  [2974] = {.lex_state = 0, .external_lex_state = 7},
  [2975] = {.lex_state = 0, .external_lex_state = 7},
  [2976] = {.lex_state = 0, .external_lex_state = 11},
  [2977] = {.lex_state = 0, .external_lex_state = 7},
  [2978] = {.lex_state = 0, .external_lex_state = 7},
  [2979] = {.lex_state = 42, .external_lex_state = 7},
  [2980] = {.lex_state = 42, .external_lex_state = 6},
  [2981] = {.lex_state = 0, .external_lex_state = 11},
  [2982] = {.lex_state = 0, .external_lex_state = 10},
  [2983] = {.lex_state = 0, .external_lex_state = 7},
  [2984] = {.lex_state = 0, .external_lex_state = 11},
  [2985] = {.lex_state = 42, .external_lex_state = 9},
  [2986] = {.lex_state = 0, .external_lex_state = 10},
  [2987] = {.lex_state = 42, .external_lex_state = 7},
  [2988] = {.lex_state = 0, .external_lex_state = 7},
  [2989] = {.lex_state = 0, .external_lex_state = 7},
  [2990] = {.lex_state = 0, .external_lex_state = 7},
  [2991] = {.lex_state = 0, .external_lex_state = 7},
  [2992] = {.lex_state = 0, .external_lex_state = 7},
  [2993] = {.lex_state = 42, .external_lex_state = 7},
  [2994] = {.lex_state = 0, .external_lex_state = 7},
  [2995] = {.lex_state = 0, .external_lex_state = 7},
  [2996] = {.lex_state = 0, .external_lex_state = 7},
  [2997] = {.lex_state = 42, .external_lex_state = 7},
  [2998] = {.lex_state = 0, .external_lex_state = 7},
  [2999] = {.lex_state = 0, .external_lex_state = 7},
  [3000] = {.lex_state = 0, .external_lex_state = 7},
  [3001] = {.lex_state = 0, .external_lex_state = 7},
  [3002] = {.lex_state = 0, .external_lex_state = 7},
  [3003] = {.lex_state = 0, .external_lex_state = 7},
  [3004] = {.lex_state = 0, .external_lex_state = 7},
  [3005] = {.lex_state = 0, .external_lex_state = 7},
  [3006] = {.lex_state = 0, .external_lex_state = 10},
  [3007] = {.lex_state = 32, .external_lex_state = 7},
  [3008] = {.lex_state = 0, .external_lex_state = 7},
  [3009] = {.lex_state = 78, .external_lex_state = 7},
  [3010] = {.lex_state = 42, .external_lex_state = 7},
  [3011] = {.lex_state = 0, .external_lex_state = 11},
  [3012] = {.lex_state = 0, .external_lex_state = 11},
  [3013] = {.lex_state = 0, .external_lex_state = 10},
  [3014] = {.lex_state = 0, .external_lex_state = 7},
  [3015] = {.lex_state = 0, .external_lex_state = 7},
  [3016] = {.lex_state = 42, .external_lex_state = 9},
  [3017] = {.lex_state = 0, .external_lex_state = 7},
  [3018] = {.lex_state = 0, .external_lex_state = 7},
  [3019] = {.lex_state = 0, .external_lex_state = 7},
  [3020] = {.lex_state = 0, .external_lex_state = 7},
  [3021] = {.lex_state = 0, .external_lex_state = 7},
  [3022] = {.lex_state = 0, .external_lex_state = 11},
  [3023] = {.lex_state = 0, .external_lex_state = 7},
  [3024] = {.lex_state = 0, .external_lex_state = 10},
  [3025] = {.lex_state = 0, .external_lex_state = 11},
  [3026] = {.lex_state = 0, .external_lex_state = 7},
  [3027] = {.lex_state = 42, .external_lex_state = 7},
  [3028] = {.lex_state = 0, .external_lex_state = 7},
  [3029] = {.lex_state = 0, .external_lex_state = 10},
  [3030] = {.lex_state = 78, .external_lex_state = 7},
  [3031] = {.lex_state = 0, .external_lex_state = 7},
  [3032] = {.lex_state = 42, .external_lex_state = 6},
  [3033] = {.lex_state = 0, .external_lex_state = 7},
  [3034] = {.lex_state = 42, .external_lex_state = 7},
  [3035] = {.lex_state = 0, .external_lex_state = 7},
  [3036] = {.lex_state = 42, .external_lex_state = 6},
  [3037] = {.lex_state = 42, .external_lex_state = 6},
  [3038] = {.lex_state = 0, .external_lex_state = 7},
  [3039] = {.lex_state = 0, .external_lex_state = 7},
  [3040] = {.lex_state = 42, .external_lex_state = 6},
  [3041] = {.lex_state = 42, .external_lex_state = 6},
  [3042] = {.lex_state = 42, .external_lex_state = 6},
  [3043] = {.lex_state = 42, .external_lex_state = 6},
  [3044] = {.lex_state = 42, .external_lex_state = 6},
  [3045] = {.lex_state = 42, .external_lex_state = 6},
  [3046] = {.lex_state = 0, .external_lex_state = 7},
  [3047] = {.lex_state = 42, .external_lex_state = 6},
  [3048] = {.lex_state = 42, .external_lex_state = 6},
  [3049] = {.lex_state = 42, .external_lex_state = 6},
  [3050] = {.lex_state = 42, .external_lex_state = 6},
  [3051] = {.lex_state = 42, .external_lex_state = 6},
  [3052] = {.lex_state = 42, .external_lex_state = 6},
  [3053] = {.lex_state = 42, .external_lex_state = 6},
  [3054] = {.lex_state = 42, .external_lex_state = 6},
  [3055] = {.lex_state = 0, .external_lex_state = 7},
  [3056] = {.lex_state = 42, .external_lex_state = 6},
  [3057] = {.lex_state = 0, .external_lex_state = 10},
  [3058] = {.lex_state = 0, .external_lex_state = 11},
  [3059] = {.lex_state = 42, .external_lex_state = 6},
  [3060] = {.lex_state = 42, .external_lex_state = 6},
  [3061] = {.lex_state = 42, .external_lex_state = 6},
  [3062] = {.lex_state = 42, .external_lex_state = 6},
  [3063] = {.lex_state = 0, .external_lex_state = 7},
  [3064] = {.lex_state = 0, .external_lex_state = 7},
  [3065] = {.lex_state = 0, .external_lex_state = 7},
  [3066] = {.lex_state = 0, .external_lex_state = 7},
  [3067] = {.lex_state = 0, .external_lex_state = 7},
  [3068] = {.lex_state = 0, .external_lex_state = 7},
  [3069] = {.lex_state = 0, .external_lex_state = 7},
  [3070] = {.lex_state = 0, .external_lex_state = 7},
  [3071] = {.lex_state = 0, .external_lex_state = 7},
  [3072] = {.lex_state = 0, .external_lex_state = 7},
  [3073] = {.lex_state = 0, .external_lex_state = 7},
  [3074] = {.lex_state = 0, .external_lex_state = 7},
  [3075] = {.lex_state = 0, .external_lex_state = 7},
  [3076] = {.lex_state = 0, .external_lex_state = 7},
  [3077] = {.lex_state = 0, .external_lex_state = 7},
  [3078] = {.lex_state = 0, .external_lex_state = 7},
  [3079] = {.lex_state = 0, .external_lex_state = 7},
  [3080] = {.lex_state = 0, .external_lex_state = 7},
  [3081] = {.lex_state = 0, .external_lex_state = 7},
  [3082] = {.lex_state = 0, .external_lex_state = 7},
  [3083] = {.lex_state = 0, .external_lex_state = 7},
  [3084] = {.lex_state = 0, .external_lex_state = 7},
  [3085] = {.lex_state = 0, .external_lex_state = 7},
  [3086] = {.lex_state = 0, .external_lex_state = 7},
  [3087] = {.lex_state = 0, .external_lex_state = 7},
  [3088] = {.lex_state = 0, .external_lex_state = 7},
  [3089] = {.lex_state = 0, .external_lex_state = 7},
  [3090] = {.lex_state = 0, .external_lex_state = 7},
  [3091] = {.lex_state = 0, .external_lex_state = 7},
  [3092] = {.lex_state = 0, .external_lex_state = 7},
  [3093] = {.lex_state = 0, .external_lex_state = 7},
  [3094] = {.lex_state = 0, .external_lex_state = 7},
  [3095] = {.lex_state = 0, .external_lex_state = 7},
  [3096] = {.lex_state = 0, .external_lex_state = 7},
  [3097] = {.lex_state = 0, .external_lex_state = 7},
  [3098] = {.lex_state = 0, .external_lex_state = 7},
  [3099] = {.lex_state = 0, .external_lex_state = 7},
  [3100] = {.lex_state = 0, .external_lex_state = 7},
  [3101] = {.lex_state = 0, .external_lex_state = 7},
  [3102] = {.lex_state = 0, .external_lex_state = 7},
  [3103] = {.lex_state = 0, .external_lex_state = 7},
  [3104] = {.lex_state = 0, .external_lex_state = 7},
  [3105] = {.lex_state = 0, .external_lex_state = 7},
  [3106] = {.lex_state = 32, .external_lex_state = 7},
  [3107] = {.lex_state = 0, .external_lex_state = 7},
  [3108] = {.lex_state = 0, .external_lex_state = 7},
  [3109] = {.lex_state = 0, .external_lex_state = 7},
  [3110] = {.lex_state = 0, .external_lex_state = 7},
  [3111] = {.lex_state = 0, .external_lex_state = 7},
  [3112] = {.lex_state = 0, .external_lex_state = 7},
  [3113] = {.lex_state = 0, .external_lex_state = 7},
  [3114] = {.lex_state = 0, .external_lex_state = 7},
  [3115] = {.lex_state = 0, .external_lex_state = 7},
  [3116] = {.lex_state = 0, .external_lex_state = 7},
  [3117] = {.lex_state = 0, .external_lex_state = 7},
  [3118] = {.lex_state = 0, .external_lex_state = 7},
  [3119] = {.lex_state = 0, .external_lex_state = 7},
  [3120] = {.lex_state = 0, .external_lex_state = 7},
  [3121] = {.lex_state = 0, .external_lex_state = 7},
  [3122] = {.lex_state = 0, .external_lex_state = 7},
  [3123] = {.lex_state = 0, .external_lex_state = 7},
  [3124] = {.lex_state = 0, .external_lex_state = 7},
  [3125] = {.lex_state = 0, .external_lex_state = 7},
  [3126] = {.lex_state = 0, .external_lex_state = 7},
  [3127] = {.lex_state = 0, .external_lex_state = 7},
  [3128] = {.lex_state = 0, .external_lex_state = 7},
  [3129] = {.lex_state = 0, .external_lex_state = 7},
  [3130] = {.lex_state = 42, .external_lex_state = 7},
  [3131] = {.lex_state = 0, .external_lex_state = 7},
  [3132] = {.lex_state = 0, .external_lex_state = 7},
  [3133] = {.lex_state = 0, .external_lex_state = 7},
  [3134] = {.lex_state = 0, .external_lex_state = 7},
  [3135] = {.lex_state = 0, .external_lex_state = 7},
  [3136] = {.lex_state = 0, .external_lex_state = 7},
  [3137] = {.lex_state = 0, .external_lex_state = 7},
  [3138] = {.lex_state = 0, .external_lex_state = 7},
  [3139] = {.lex_state = 0, .external_lex_state = 7},
  [3140] = {.lex_state = 0, .external_lex_state = 7},
  [3141] = {.lex_state = 0, .external_lex_state = 7},
  [3142] = {.lex_state = 0, .external_lex_state = 7},
  [3143] = {.lex_state = 0, .external_lex_state = 7},
  [3144] = {.lex_state = 0, .external_lex_state = 7},
  [3145] = {.lex_state = 0, .external_lex_state = 7},
  [3146] = {.lex_state = 0, .external_lex_state = 7},
  [3147] = {.lex_state = 0, .external_lex_state = 7},
  [3148] = {.lex_state = 32, .external_lex_state = 7},
  [3149] = {.lex_state = 0, .external_lex_state = 7},
  [3150] = {.lex_state = 0, .external_lex_state = 7},
  [3151] = {.lex_state = 0, .external_lex_state = 7},
  [3152] = {.lex_state = 0, .external_lex_state = 7},
  [3153] = {.lex_state = 0, .external_lex_state = 7},
  [3154] = {.lex_state = 0, .external_lex_state = 7},
  [3155] = {.lex_state = 0, .external_lex_state = 7},
  [3156] = {.lex_state = 0, .external_lex_state = 7},
  [3157] = {.lex_state = 0, .external_lex_state = 7},
  [3158] = {.lex_state = 0, .external_lex_state = 7},
  [3159] = {.lex_state = 0, .external_lex_state = 7},
  [3160] = {.lex_state = 0, .external_lex_state = 7},
  [3161] = {.lex_state = 0, .external_lex_state = 7},
  [3162] = {.lex_state = 0, .external_lex_state = 7},
  [3163] = {.lex_state = 0, .external_lex_state = 7},
  [3164] = {.lex_state = 0, .external_lex_state = 7},
  [3165] = {.lex_state = 0, .external_lex_state = 7},
  [3166] = {.lex_state = 0, .external_lex_state = 7},
  [3167] = {.lex_state = 0, .external_lex_state = 7},
  [3168] = {.lex_state = 0, .external_lex_state = 7},
  [3169] = {.lex_state = 0, .external_lex_state = 7},
  [3170] = {.lex_state = 0, .external_lex_state = 7},
  [3171] = {.lex_state = 0, .external_lex_state = 7},
  [3172] = {.lex_state = 0, .external_lex_state = 7},
  [3173] = {.lex_state = 0, .external_lex_state = 7},
  [3174] = {.lex_state = 0, .external_lex_state = 7},
  [3175] = {.lex_state = 0, .external_lex_state = 7},
  [3176] = {.lex_state = 0, .external_lex_state = 7},
  [3177] = {.lex_state = 0, .external_lex_state = 7},
  [3178] = {.lex_state = 42, .external_lex_state = 6},
  [3179] = {.lex_state = 0, .external_lex_state = 7},
  [3180] = {.lex_state = 0, .external_lex_state = 7},
  [3181] = {.lex_state = 0, .external_lex_state = 7},
  [3182] = {.lex_state = 0, .external_lex_state = 7},
  [3183] = {.lex_state = 0, .external_lex_state = 7},
  [3184] = {.lex_state = 0, .external_lex_state = 7},
  [3185] = {.lex_state = 0, .external_lex_state = 7},
  [3186] = {.lex_state = 42, .external_lex_state = 7},
  [3187] = {.lex_state = 0, .external_lex_state = 7},
  [3188] = {.lex_state = 0, .external_lex_state = 7},
  [3189] = {.lex_state = 0, .external_lex_state = 7},
  [3190] = {.lex_state = 0, .external_lex_state = 7},
  [3191] = {.lex_state = 0, .external_lex_state = 7},
  [3192] = {.lex_state = 0, .external_lex_state = 7},
  [3193] = {.lex_state = 32, .external_lex_state = 7},
  [3194] = {.lex_state = 0, .external_lex_state = 7},
  [3195] = {.lex_state = 0, .external_lex_state = 7},
  [3196] = {.lex_state = 0, .external_lex_state = 7},
  [3197] = {.lex_state = 0, .external_lex_state = 7},
  [3198] = {.lex_state = 0, .external_lex_state = 7},
  [3199] = {.lex_state = 0, .external_lex_state = 7},
  [3200] = {.lex_state = 0, .external_lex_state = 7},
  [3201] = {.lex_state = 0, .external_lex_state = 7},
  [3202] = {.lex_state = 0, .external_lex_state = 7},
  [3203] = {.lex_state = 0, .external_lex_state = 7},
  [3204] = {.lex_state = 0, .external_lex_state = 7},
  [3205] = {.lex_state = 0, .external_lex_state = 7},
  [3206] = {.lex_state = 0, .external_lex_state = 7},
  [3207] = {.lex_state = 0, .external_lex_state = 7},
  [3208] = {.lex_state = 0, .external_lex_state = 7},
  [3209] = {.lex_state = 0, .external_lex_state = 7},
  [3210] = {.lex_state = 0, .external_lex_state = 7},
  [3211] = {.lex_state = 0, .external_lex_state = 7},
  [3212] = {.lex_state = 0, .external_lex_state = 7},
  [3213] = {.lex_state = 0, .external_lex_state = 7},
  [3214] = {.lex_state = 0, .external_lex_state = 7},
  [3215] = {.lex_state = 0, .external_lex_state = 7},
  [3216] = {.lex_state = 0, .external_lex_state = 7},
  [3217] = {.lex_state = 0, .external_lex_state = 7},
  [3218] = {.lex_state = 0, .external_lex_state = 7},
  [3219] = {.lex_state = 0, .external_lex_state = 7},
  [3220] = {.lex_state = 0, .external_lex_state = 7},
  [3221] = {.lex_state = 0, .external_lex_state = 7},
  [3222] = {.lex_state = 0, .external_lex_state = 7},
  [3223] = {.lex_state = 0, .external_lex_state = 7},
  [3224] = {.lex_state = 0, .external_lex_state = 7},
  [3225] = {.lex_state = 0, .external_lex_state = 7},
  [3226] = {.lex_state = 0, .external_lex_state = 7},
  [3227] = {.lex_state = 0, .external_lex_state = 7},
  [3228] = {.lex_state = 0, .external_lex_state = 7},
  [3229] = {.lex_state = 0, .external_lex_state = 7},
  [3230] = {.lex_state = 0, .external_lex_state = 7},
  [3231] = {.lex_state = 0, .external_lex_state = 7},
  [3232] = {.lex_state = 0, .external_lex_state = 7},
  [3233] = {.lex_state = 0, .external_lex_state = 7},
  [3234] = {.lex_state = 32, .external_lex_state = 7},
  [3235] = {.lex_state = 0, .external_lex_state = 7},
  [3236] = {.lex_state = 0, .external_lex_state = 7},
  [3237] = {.lex_state = 0, .external_lex_state = 7},
  [3238] = {.lex_state = 0, .external_lex_state = 7},
  [3239] = {.lex_state = 0, .external_lex_state = 7},
  [3240] = {.lex_state = 0, .external_lex_state = 7},
  [3241] = {.lex_state = 0, .external_lex_state = 7},
  [3242] = {.lex_state = 0, .external_lex_state = 7},
  [3243] = {.lex_state = 0, .external_lex_state = 7},
  [3244] = {.lex_state = 42, .external_lex_state = 6},
  [3245] = {.lex_state = 0, .external_lex_state = 7},
  [3246] = {.lex_state = 0, .external_lex_state = 7},
  [3247] = {.lex_state = 0, .external_lex_state = 7},
  [3248] = {.lex_state = 0, .external_lex_state = 7},
  [3249] = {.lex_state = 0, .external_lex_state = 7},
  [3250] = {.lex_state = 0, .external_lex_state = 7},
  [3251] = {.lex_state = 0, .external_lex_state = 7},
  [3252] = {.lex_state = 0, .external_lex_state = 7},
  [3253] = {.lex_state = 0, .external_lex_state = 7},
  [3254] = {.lex_state = 0, .external_lex_state = 7},
  [3255] = {.lex_state = 0, .external_lex_state = 7},
  [3256] = {.lex_state = 0, .external_lex_state = 7},
  [3257] = {.lex_state = 0, .external_lex_state = 7},
  [3258] = {.lex_state = 0, .external_lex_state = 7},
  [3259] = {.lex_state = 0, .external_lex_state = 7},
  [3260] = {.lex_state = 0, .external_lex_state = 7},
  [3261] = {.lex_state = 0, .external_lex_state = 7},
  [3262] = {.lex_state = 0, .external_lex_state = 7},
  [3263] = {.lex_state = 0, .external_lex_state = 7},
  [3264] = {.lex_state = 0, .external_lex_state = 7},
  [3265] = {.lex_state = 32, .external_lex_state = 7},
  [3266] = {.lex_state = 0, .external_lex_state = 7},
  [3267] = {.lex_state = 0, .external_lex_state = 7},
  [3268] = {.lex_state = 0, .external_lex_state = 7},
  [3269] = {.lex_state = 0, .external_lex_state = 7},
  [3270] = {.lex_state = 0, .external_lex_state = 7},
  [3271] = {.lex_state = 0, .external_lex_state = 7},
  [3272] = {.lex_state = 0, .external_lex_state = 7},
  [3273] = {.lex_state = 0, .external_lex_state = 7},
  [3274] = {.lex_state = 0, .external_lex_state = 7},
  [3275] = {.lex_state = 0, .external_lex_state = 7},
  [3276] = {.lex_state = 0, .external_lex_state = 7},
  [3277] = {.lex_state = 0, .external_lex_state = 7},
  [3278] = {.lex_state = 0, .external_lex_state = 7},
  [3279] = {.lex_state = 0, .external_lex_state = 7},
  [3280] = {.lex_state = 0, .external_lex_state = 7},
  [3281] = {.lex_state = 0, .external_lex_state = 7},
  [3282] = {.lex_state = 0, .external_lex_state = 7},
  [3283] = {.lex_state = 0, .external_lex_state = 7},
  [3284] = {.lex_state = 0, .external_lex_state = 7},
  [3285] = {.lex_state = 0, .external_lex_state = 7},
  [3286] = {.lex_state = 0, .external_lex_state = 7},
  [3287] = {.lex_state = 32, .external_lex_state = 7},
  [3288] = {.lex_state = 0, .external_lex_state = 7},
  [3289] = {.lex_state = 0, .external_lex_state = 7},
  [3290] = {.lex_state = 0, .external_lex_state = 7},
  [3291] = {.lex_state = 0, .external_lex_state = 7},
  [3292] = {.lex_state = 0, .external_lex_state = 7},
  [3293] = {.lex_state = 0, .external_lex_state = 7},
  [3294] = {.lex_state = 0, .external_lex_state = 7},
  [3295] = {.lex_state = 0, .external_lex_state = 7},
  [3296] = {.lex_state = 0, .external_lex_state = 7},
  [3297] = {.lex_state = 0, .external_lex_state = 7},
  [3298] = {.lex_state = 0, .external_lex_state = 7},
  [3299] = {.lex_state = 0, .external_lex_state = 7},
  [3300] = {.lex_state = 0, .external_lex_state = 7},
  [3301] = {.lex_state = 0, .external_lex_state = 7},
  [3302] = {.lex_state = 0, .external_lex_state = 7},
  [3303] = {.lex_state = 0, .external_lex_state = 7},
  [3304] = {.lex_state = 42, .external_lex_state = 6},
  [3305] = {.lex_state = 0, .external_lex_state = 7},
  [3306] = {.lex_state = 0, .external_lex_state = 7},
  [3307] = {.lex_state = 0, .external_lex_state = 7},
  [3308] = {.lex_state = 0, .external_lex_state = 7},
  [3309] = {.lex_state = 0, .external_lex_state = 7},
  [3310] = {.lex_state = 0, .external_lex_state = 7},
  [3311] = {.lex_state = 0, .external_lex_state = 7},
  [3312] = {.lex_state = 0, .external_lex_state = 7},
  [3313] = {.lex_state = 0, .external_lex_state = 7},
  [3314] = {.lex_state = 0, .external_lex_state = 7},
  [3315] = {.lex_state = 0, .external_lex_state = 7},
  [3316] = {.lex_state = 42, .external_lex_state = 6},
  [3317] = {.lex_state = 0, .external_lex_state = 7},
  [3318] = {.lex_state = 32, .external_lex_state = 7},
  [3319] = {.lex_state = 32, .external_lex_state = 7},
  [3320] = {.lex_state = 42, .external_lex_state = 6},
  [3321] = {.lex_state = 0, .external_lex_state = 7},
  [3322] = {.lex_state = 42, .external_lex_state = 7},
  [3323] = {.lex_state = 0, .external_lex_state = 7},
  [3324] = {.lex_state = 0, .external_lex_state = 7},
  [3325] = {.lex_state = 0, .external_lex_state = 7},
  [3326] = {.lex_state = 0, .external_lex_state = 7},
  [3327] = {.lex_state = 0, .external_lex_state = 7},
  [3328] = {.lex_state = 0, .external_lex_state = 7},
  [3329] = {.lex_state = 42, .external_lex_state = 7},
  [3330] = {.lex_state = 0, .external_lex_state = 7},
  [3331] = {.lex_state = 0, .external_lex_state = 7},
  [3332] = {.lex_state = 0, .external_lex_state = 7},
  [3333] = {.lex_state = 0, .external_lex_state = 7},
  [3334] = {.lex_state = 44, .external_lex_state = 7},
  [3335] = {.lex_state = 0, .external_lex_state = 7},
  [3336] = {.lex_state = 0, .external_lex_state = 7},
  [3337] = {.lex_state = 0, .external_lex_state = 7},
  [3338] = {.lex_state = 0, .external_lex_state = 7},
  [3339] = {.lex_state = 0, .external_lex_state = 7},
  [3340] = {.lex_state = 0, .external_lex_state = 7},
  [3341] = {.lex_state = 0, .external_lex_state = 7},
  [3342] = {.lex_state = 0, .external_lex_state = 7},
  [3343] = {.lex_state = 42, .external_lex_state = 7},
  [3344] = {.lex_state = 0, .external_lex_state = 7},
  [3345] = {.lex_state = 0, .external_lex_state = 7},
  [3346] = {.lex_state = 0, .external_lex_state = 7},
  [3347] = {.lex_state = 0, .external_lex_state = 7},
  [3348] = {.lex_state = 0, .external_lex_state = 7},
  [3349] = {.lex_state = 0, .external_lex_state = 7},
  [3350] = {.lex_state = 0, .external_lex_state = 7},
  [3351] = {.lex_state = 0, .external_lex_state = 7},
  [3352] = {.lex_state = 0, .external_lex_state = 7},
  [3353] = {.lex_state = 0, .external_lex_state = 7},
  [3354] = {.lex_state = 0, .external_lex_state = 7},
  [3355] = {.lex_state = 0, .external_lex_state = 7},
  [3356] = {.lex_state = 0, .external_lex_state = 7},
  [3357] = {.lex_state = 0, .external_lex_state = 7},
  [3358] = {.lex_state = 42, .external_lex_state = 6},
  [3359] = {.lex_state = 42, .external_lex_state = 7},
  [3360] = {.lex_state = 0, .external_lex_state = 7},
  [3361] = {.lex_state = 0, .external_lex_state = 7},
  [3362] = {.lex_state = 0, .external_lex_state = 7},
  [3363] = {.lex_state = 0, .external_lex_state = 7},
  [3364] = {.lex_state = 0, .external_lex_state = 7},
  [3365] = {.lex_state = 0, .external_lex_state = 7},
  [3366] = {.lex_state = 0, .external_lex_state = 7},
  [3367] = {.lex_state = 0, .external_lex_state = 7},
  [3368] = {.lex_state = 0, .external_lex_state = 7},
  [3369] = {.lex_state = 0, .external_lex_state = 7},
  [3370] = {.lex_state = 0, .external_lex_state = 7},
  [3371] = {.lex_state = 0, .external_lex_state = 7},
  [3372] = {.lex_state = 0, .external_lex_state = 7},
  [3373] = {.lex_state = 0, .external_lex_state = 7},
  [3374] = {.lex_state = 0, .external_lex_state = 7},
  [3375] = {.lex_state = 0, .external_lex_state = 7},
  [3376] = {.lex_state = 0, .external_lex_state = 7},
  [3377] = {.lex_state = 0, .external_lex_state = 7},
  [3378] = {.lex_state = 0, .external_lex_state = 7},
  [3379] = {.lex_state = 0, .external_lex_state = 7},
  [3380] = {.lex_state = 0, .external_lex_state = 7},
  [3381] = {.lex_state = 0, .external_lex_state = 7},
  [3382] = {.lex_state = 0, .external_lex_state = 7},
  [3383] = {.lex_state = 0, .external_lex_state = 7},
  [3384] = {.lex_state = 0, .external_lex_state = 7},
  [3385] = {.lex_state = 0, .external_lex_state = 7},
  [3386] = {.lex_state = 0, .external_lex_state = 7},
  [3387] = {.lex_state = 42, .external_lex_state = 6},
  [3388] = {.lex_state = 0, .external_lex_state = 7},
  [3389] = {.lex_state = 0, .external_lex_state = 7},
  [3390] = {.lex_state = 0, .external_lex_state = 7},
  [3391] = {.lex_state = 0, .external_lex_state = 7},
  [3392] = {.lex_state = 42, .external_lex_state = 6},
  [3393] = {.lex_state = 42, .external_lex_state = 6},
  [3394] = {.lex_state = 0, .external_lex_state = 7},
  [3395] = {.lex_state = 0, .external_lex_state = 7},
  [3396] = {.lex_state = 0, .external_lex_state = 7},
  [3397] = {.lex_state = 0, .external_lex_state = 7},
  [3398] = {.lex_state = 42, .external_lex_state = 6},
  [3399] = {.lex_state = 0, .external_lex_state = 7},
  [3400] = {.lex_state = 0, .external_lex_state = 7},
  [3401] = {.lex_state = 0, .external_lex_state = 7},
  [3402] = {.lex_state = 42, .external_lex_state = 6},
  [3403] = {.lex_state = 0, .external_lex_state = 7},
  [3404] = {.lex_state = 42, .external_lex_state = 6},
  [3405] = {.lex_state = 0, .external_lex_state = 7},
  [3406] = {.lex_state = 0, .external_lex_state = 7},
  [3407] = {.lex_state = 42, .external_lex_state = 6},
  [3408] = {.lex_state = 0, .external_lex_state = 7},
  [3409] = {.lex_state = 42, .external_lex_state = 6},
  [3410] = {.lex_state = 0, .external_lex_state = 7},
  [3411] = {.lex_state = 0, .external_lex_state = 7},
  [3412] = {.lex_state = 0, .external_lex_state = 7},
  [3413] = {.lex_state = 0, .external_lex_state = 7},
  [3414] = {.lex_state = 42, .external_lex_state = 6},
  [3415] = {.lex_state = 0, .external_lex_state = 7},
  [3416] = {.lex_state = 0, .external_lex_state = 7},
  [3417] = {.lex_state = 0, .external_lex_state = 7},
  [3418] = {.lex_state = 0, .external_lex_state = 7},
  [3419] = {.lex_state = 0, .external_lex_state = 7},
  [3420] = {.lex_state = 0, .external_lex_state = 7},
  [3421] = {.lex_state = 0, .external_lex_state = 7},
  [3422] = {.lex_state = 0, .external_lex_state = 7},
  [3423] = {.lex_state = 42, .external_lex_state = 6},
  [3424] = {.lex_state = 42, .external_lex_state = 6},
  [3425] = {.lex_state = 42, .external_lex_state = 6},
  [3426] = {.lex_state = 0, .external_lex_state = 7},
  [3427] = {.lex_state = 0, .external_lex_state = 7},
  [3428] = {.lex_state = 42, .external_lex_state = 6},
  [3429] = {.lex_state = 0, .external_lex_state = 7},
  [3430] = {.lex_state = 0, .external_lex_state = 7},
  [3431] = {.lex_state = 0, .external_lex_state = 7},
  [3432] = {.lex_state = 0, .external_lex_state = 7},
  [3433] = {.lex_state = 42, .external_lex_state = 6},
  [3434] = {.lex_state = 0, .external_lex_state = 7},
  [3435] = {.lex_state = 0, .external_lex_state = 7},
  [3436] = {.lex_state = 0, .external_lex_state = 7},
  [3437] = {.lex_state = 0, .external_lex_state = 7},
  [3438] = {.lex_state = 0, .external_lex_state = 7},
  [3439] = {.lex_state = 0, .external_lex_state = 7},
  [3440] = {.lex_state = 0, .external_lex_state = 7},
  [3441] = {.lex_state = 0, .external_lex_state = 7},
  [3442] = {.lex_state = 0, .external_lex_state = 7},
  [3443] = {.lex_state = 0, .external_lex_state = 7},
  [3444] = {.lex_state = 0, .external_lex_state = 7},
  [3445] = {.lex_state = 0, .external_lex_state = 7},
  [3446] = {.lex_state = 0, .external_lex_state = 7},
  [3447] = {.lex_state = 0, .external_lex_state = 7},
  [3448] = {.lex_state = 0, .external_lex_state = 7},
  [3449] = {.lex_state = 0, .external_lex_state = 7},
  [3450] = {.lex_state = 0, .external_lex_state = 7},
  [3451] = {.lex_state = 0, .external_lex_state = 7},
  [3452] = {.lex_state = 0, .external_lex_state = 7},
  [3453] = {.lex_state = 0, .external_lex_state = 7},
  [3454] = {.lex_state = 0, .external_lex_state = 7},
  [3455] = {.lex_state = 0, .external_lex_state = 7},
  [3456] = {.lex_state = 0, .external_lex_state = 7},
  [3457] = {.lex_state = 0, .external_lex_state = 7},
  [3458] = {.lex_state = 0, .external_lex_state = 7},
  [3459] = {.lex_state = 0, .external_lex_state = 7},
  [3460] = {.lex_state = 0, .external_lex_state = 7},
  [3461] = {.lex_state = 0, .external_lex_state = 7},
  [3462] = {.lex_state = 0, .external_lex_state = 7},
  [3463] = {.lex_state = 0, .external_lex_state = 7},
  [3464] = {.lex_state = 0, .external_lex_state = 7},
  [3465] = {.lex_state = 0, .external_lex_state = 7},
  [3466] = {.lex_state = 0, .external_lex_state = 7},
  [3467] = {.lex_state = 0, .external_lex_state = 7},
  [3468] = {.lex_state = 0, .external_lex_state = 7},
  [3469] = {.lex_state = 0, .external_lex_state = 7},
  [3470] = {.lex_state = 0, .external_lex_state = 7},
  [3471] = {.lex_state = 0, .external_lex_state = 7},
  [3472] = {.lex_state = 0, .external_lex_state = 7},
  [3473] = {.lex_state = 0, .external_lex_state = 7},
  [3474] = {.lex_state = 0, .external_lex_state = 7},
  [3475] = {.lex_state = 0, .external_lex_state = 7},
  [3476] = {.lex_state = 0, .external_lex_state = 7},
  [3477] = {.lex_state = 0, .external_lex_state = 7},
  [3478] = {.lex_state = 0, .external_lex_state = 7},
  [3479] = {.lex_state = 0, .external_lex_state = 7},
  [3480] = {.lex_state = 0, .external_lex_state = 7},
  [3481] = {.lex_state = 0, .external_lex_state = 7},
  [3482] = {.lex_state = 0, .external_lex_state = 7},
  [3483] = {.lex_state = 0, .external_lex_state = 7},
  [3484] = {.lex_state = 0, .external_lex_state = 7},
  [3485] = {.lex_state = 0, .external_lex_state = 7},
  [3486] = {.lex_state = 0, .external_lex_state = 7},
  [3487] = {.lex_state = 0, .external_lex_state = 7},
  [3488] = {.lex_state = 0, .external_lex_state = 7},
  [3489] = {.lex_state = 0, .external_lex_state = 7},
  [3490] = {.lex_state = 0, .external_lex_state = 7},
  [3491] = {.lex_state = 0, .external_lex_state = 7},
  [3492] = {.lex_state = 0, .external_lex_state = 7},
  [3493] = {.lex_state = 0, .external_lex_state = 7},
  [3494] = {.lex_state = 0, .external_lex_state = 7},
  [3495] = {.lex_state = 0, .external_lex_state = 7},
  [3496] = {.lex_state = 0, .external_lex_state = 7},
  [3497] = {.lex_state = 0, .external_lex_state = 7},
  [3498] = {.lex_state = 0, .external_lex_state = 7},
  [3499] = {.lex_state = 0, .external_lex_state = 7},
  [3500] = {.lex_state = 0, .external_lex_state = 7},
  [3501] = {.lex_state = 0, .external_lex_state = 7},
  [3502] = {.lex_state = 0, .external_lex_state = 7},
  [3503] = {.lex_state = 0, .external_lex_state = 7},
  [3504] = {.lex_state = 0, .external_lex_state = 7},
  [3505] = {.lex_state = 0, .external_lex_state = 7},
  [3506] = {.lex_state = 0, .external_lex_state = 7},
  [3507] = {.lex_state = 0, .external_lex_state = 7},
  [3508] = {.lex_state = 0, .external_lex_state = 7},
  [3509] = {.lex_state = 0, .external_lex_state = 7},
  [3510] = {.lex_state = 0, .external_lex_state = 7},
  [3511] = {.lex_state = 0, .external_lex_state = 7},
  [3512] = {.lex_state = 0, .external_lex_state = 7},
  [3513] = {.lex_state = 0, .external_lex_state = 7},
  [3514] = {.lex_state = 0, .external_lex_state = 7},
  [3515] = {.lex_state = 0, .external_lex_state = 7},
  [3516] = {.lex_state = 0, .external_lex_state = 7},
  [3517] = {.lex_state = 0, .external_lex_state = 7},
  [3518] = {.lex_state = 0, .external_lex_state = 7},
  [3519] = {.lex_state = 0, .external_lex_state = 7},
  [3520] = {.lex_state = 0, .external_lex_state = 7},
  [3521] = {.lex_state = 0, .external_lex_state = 7},
  [3522] = {.lex_state = 0, .external_lex_state = 7},
  [3523] = {.lex_state = 0, .external_lex_state = 7},
  [3524] = {.lex_state = 0, .external_lex_state = 7},
  [3525] = {.lex_state = 0, .external_lex_state = 7},
  [3526] = {.lex_state = 0, .external_lex_state = 7},
  [3527] = {.lex_state = 0, .external_lex_state = 7},
  [3528] = {.lex_state = 0, .external_lex_state = 7},
  [3529] = {.lex_state = 0, .external_lex_state = 7},
  [3530] = {.lex_state = 0, .external_lex_state = 7},
  [3531] = {.lex_state = 0, .external_lex_state = 7},
  [3532] = {.lex_state = 0, .external_lex_state = 7},
  [3533] = {.lex_state = 0, .external_lex_state = 7},
  [3534] = {.lex_state = 0, .external_lex_state = 7},
  [3535] = {.lex_state = 0, .external_lex_state = 7},
  [3536] = {.lex_state = 0, .external_lex_state = 7},
  [3537] = {.lex_state = 0, .external_lex_state = 7},
  [3538] = {.lex_state = 0, .external_lex_state = 7},
  [3539] = {.lex_state = 0, .external_lex_state = 7},
  [3540] = {.lex_state = 0, .external_lex_state = 7},
  [3541] = {.lex_state = 0, .external_lex_state = 7},
  [3542] = {.lex_state = 0, .external_lex_state = 7},
  [3543] = {.lex_state = 0, .external_lex_state = 7},
  [3544] = {.lex_state = 0, .external_lex_state = 7},
  [3545] = {.lex_state = 0, .external_lex_state = 7},
  [3546] = {.lex_state = 0, .external_lex_state = 7},
  [3547] = {.lex_state = 0, .external_lex_state = 7},
  [3548] = {.lex_state = 0, .external_lex_state = 7},
  [3549] = {.lex_state = 0, .external_lex_state = 7},
  [3550] = {.lex_state = 0, .external_lex_state = 7},
  [3551] = {.lex_state = 0, .external_lex_state = 7},
  [3552] = {.lex_state = 0, .external_lex_state = 7},
  [3553] = {.lex_state = 0, .external_lex_state = 7},
  [3554] = {.lex_state = 0, .external_lex_state = 7},
  [3555] = {.lex_state = 0, .external_lex_state = 7},
  [3556] = {.lex_state = 0, .external_lex_state = 7},
  [3557] = {.lex_state = 42, .external_lex_state = 6},
  [3558] = {.lex_state = 0, .external_lex_state = 7},
  [3559] = {.lex_state = 0, .external_lex_state = 7},
  [3560] = {.lex_state = 0, .external_lex_state = 7},
  [3561] = {.lex_state = 0, .external_lex_state = 7},
  [3562] = {.lex_state = 0, .external_lex_state = 7},
  [3563] = {.lex_state = 0, .external_lex_state = 7},
  [3564] = {.lex_state = 0, .external_lex_state = 7},
  [3565] = {.lex_state = 0, .external_lex_state = 7},
  [3566] = {.lex_state = 0, .external_lex_state = 7},
  [3567] = {.lex_state = 0, .external_lex_state = 7},
  [3568] = {.lex_state = 0, .external_lex_state = 7},
  [3569] = {.lex_state = 0, .external_lex_state = 7},
  [3570] = {.lex_state = 0, .external_lex_state = 7},
  [3571] = {.lex_state = 0, .external_lex_state = 7},
  [3572] = {.lex_state = 0, .external_lex_state = 7},
  [3573] = {.lex_state = 0, .external_lex_state = 7},
  [3574] = {.lex_state = 0, .external_lex_state = 7},
  [3575] = {.lex_state = 0, .external_lex_state = 7},
  [3576] = {.lex_state = 0, .external_lex_state = 7},
  [3577] = {.lex_state = 0, .external_lex_state = 7},
  [3578] = {.lex_state = 0, .external_lex_state = 7},
  [3579] = {.lex_state = 0, .external_lex_state = 7},
  [3580] = {.lex_state = 0, .external_lex_state = 7},
  [3581] = {.lex_state = 0, .external_lex_state = 7},
  [3582] = {.lex_state = 0, .external_lex_state = 7},
  [3583] = {.lex_state = 0, .external_lex_state = 7},
  [3584] = {.lex_state = 0, .external_lex_state = 7},
  [3585] = {.lex_state = 0, .external_lex_state = 6},
  [3586] = {.lex_state = 0, .external_lex_state = 7},
  [3587] = {.lex_state = 0, .external_lex_state = 7},
  [3588] = {.lex_state = 0, .external_lex_state = 7},
  [3589] = {.lex_state = 0, .external_lex_state = 7},
  [3590] = {.lex_state = 0, .external_lex_state = 7},
  [3591] = {.lex_state = 0, .external_lex_state = 7},
  [3592] = {.lex_state = 0, .external_lex_state = 7},
  [3593] = {.lex_state = 0, .external_lex_state = 7},
  [3594] = {.lex_state = 0, .external_lex_state = 7},
  [3595] = {.lex_state = 0, .external_lex_state = 7},
  [3596] = {.lex_state = 0, .external_lex_state = 7},
  [3597] = {.lex_state = 0, .external_lex_state = 7},
  [3598] = {.lex_state = 0, .external_lex_state = 7},
  [3599] = {.lex_state = 0, .external_lex_state = 7},
  [3600] = {.lex_state = 0, .external_lex_state = 7},
  [3601] = {.lex_state = 0, .external_lex_state = 7},
  [3602] = {.lex_state = 0, .external_lex_state = 7},
  [3603] = {.lex_state = 44, .external_lex_state = 7},
  [3604] = {.lex_state = 0, .external_lex_state = 7},
  [3605] = {.lex_state = 0, .external_lex_state = 7},
  [3606] = {.lex_state = 0, .external_lex_state = 7},
  [3607] = {.lex_state = 0, .external_lex_state = 7},
  [3608] = {.lex_state = 0, .external_lex_state = 7},
  [3609] = {.lex_state = 0, .external_lex_state = 7},
  [3610] = {.lex_state = 0, .external_lex_state = 7},
  [3611] = {.lex_state = 0, .external_lex_state = 7},
  [3612] = {.lex_state = 0, .external_lex_state = 6},
  [3613] = {.lex_state = 44, .external_lex_state = 7},
  [3614] = {.lex_state = 0, .external_lex_state = 7},
  [3615] = {.lex_state = 0, .external_lex_state = 7},
  [3616] = {.lex_state = 0, .external_lex_state = 7},
  [3617] = {.lex_state = 0, .external_lex_state = 7},
  [3618] = {.lex_state = 0, .external_lex_state = 7},
  [3619] = {.lex_state = 0, .external_lex_state = 7},
  [3620] = {.lex_state = 0, .external_lex_state = 7},
  [3621] = {.lex_state = 0, .external_lex_state = 7},
  [3622] = {.lex_state = 0, .external_lex_state = 7},
  [3623] = {.lex_state = 0, .external_lex_state = 7},
  [3624] = {.lex_state = 0, .external_lex_state = 7},
  [3625] = {.lex_state = 0, .external_lex_state = 7},
  [3626] = {.lex_state = 0, .external_lex_state = 7},
  [3627] = {.lex_state = 0, .external_lex_state = 7},
  [3628] = {.lex_state = 0, .external_lex_state = 7},
  [3629] = {.lex_state = 0, .external_lex_state = 7},
  [3630] = {.lex_state = 0, .external_lex_state = 7},
  [3631] = {.lex_state = 44, .external_lex_state = 7},
  [3632] = {.lex_state = 0, .external_lex_state = 7},
  [3633] = {.lex_state = 0, .external_lex_state = 7},
  [3634] = {.lex_state = 0, .external_lex_state = 7},
  [3635] = {.lex_state = 0, .external_lex_state = 7},
  [3636] = {.lex_state = 0, .external_lex_state = 7},
  [3637] = {.lex_state = 0, .external_lex_state = 7},
  [3638] = {.lex_state = 0, .external_lex_state = 6},
  [3639] = {.lex_state = 0, .external_lex_state = 7},
  [3640] = {.lex_state = 0, .external_lex_state = 7},
  [3641] = {.lex_state = 0, .external_lex_state = 7},
  [3642] = {.lex_state = 0, .external_lex_state = 7},
  [3643] = {.lex_state = 0, .external_lex_state = 7},
  [3644] = {.lex_state = 0, .external_lex_state = 7},
  [3645] = {.lex_state = 0, .external_lex_state = 7},
  [3646] = {.lex_state = 45, .external_lex_state = 7},
  [3647] = {.lex_state = 0, .external_lex_state = 7},
  [3648] = {.lex_state = 0, .external_lex_state = 7},
  [3649] = {.lex_state = 0, .external_lex_state = 7},
  [3650] = {.lex_state = 0, .external_lex_state = 7},
  [3651] = {.lex_state = 44, .external_lex_state = 7},
  [3652] = {.lex_state = 0, .external_lex_state = 7},
  [3653] = {.lex_state = 0, .external_lex_state = 7},
  [3654] = {.lex_state = 0, .external_lex_state = 7},
  [3655] = {.lex_state = 0, .external_lex_state = 7},
  [3656] = {.lex_state = 0, .external_lex_state = 7},
  [3657] = {.lex_state = 0, .external_lex_state = 7},
  [3658] = {.lex_state = 45, .external_lex_state = 7},
  [3659] = {.lex_state = 0, .external_lex_state = 7},
  [3660] = {.lex_state = 0, .external_lex_state = 7},
  [3661] = {.lex_state = 0, .external_lex_state = 7},
  [3662] = {.lex_state = 44, .external_lex_state = 7},
  [3663] = {.lex_state = 0, .external_lex_state = 7},
  [3664] = {.lex_state = 0, .external_lex_state = 7},
  [3665] = {.lex_state = 0, .external_lex_state = 7},
  [3666] = {.lex_state = 0, .external_lex_state = 7},
  [3667] = {.lex_state = 0, .external_lex_state = 7},
  [3668] = {.lex_state = 0, .external_lex_state = 7},
  [3669] = {.lex_state = 0, .external_lex_state = 7},
  [3670] = {.lex_state = 0, .external_lex_state = 7},
  [3671] = {.lex_state = 44, .external_lex_state = 7},
  [3672] = {.lex_state = 0, .external_lex_state = 7},
  [3673] = {.lex_state = 0, .external_lex_state = 7},
  [3674] = {.lex_state = 0, .external_lex_state = 7},
  [3675] = {.lex_state = 0, .external_lex_state = 7},
  [3676] = {.lex_state = 0, .external_lex_state = 7},
  [3677] = {.lex_state = 0, .external_lex_state = 7},
  [3678] = {.lex_state = 0, .external_lex_state = 7},
  [3679] = {.lex_state = 45, .external_lex_state = 7},
  [3680] = {.lex_state = 0, .external_lex_state = 7},
  [3681] = {.lex_state = 0, .external_lex_state = 7},
  [3682] = {.lex_state = 0, .external_lex_state = 7},
  [3683] = {.lex_state = 0, .external_lex_state = 7},
  [3684] = {.lex_state = 0, .external_lex_state = 7},
  [3685] = {.lex_state = 0, .external_lex_state = 7},
  [3686] = {.lex_state = 0, .external_lex_state = 7},
  [3687] = {.lex_state = 0, .external_lex_state = 7},
  [3688] = {.lex_state = 44, .external_lex_state = 7},
  [3689] = {.lex_state = 0, .external_lex_state = 7},
  [3690] = {.lex_state = 0, .external_lex_state = 7},
  [3691] = {.lex_state = 0, .external_lex_state = 7},
  [3692] = {.lex_state = 0, .external_lex_state = 6},
  [3693] = {.lex_state = 0, .external_lex_state = 7},
  [3694] = {.lex_state = 0, .external_lex_state = 7},
  [3695] = {.lex_state = 0, .external_lex_state = 7},
  [3696] = {.lex_state = 0, .external_lex_state = 7},
  [3697] = {.lex_state = 45, .external_lex_state = 7},
  [3698] = {.lex_state = 0, .external_lex_state = 7},
  [3699] = {.lex_state = 0, .external_lex_state = 7},
  [3700] = {.lex_state = 0, .external_lex_state = 7},
  [3701] = {.lex_state = 0, .external_lex_state = 7},
  [3702] = {.lex_state = 0, .external_lex_state = 6},
  [3703] = {.lex_state = 0, .external_lex_state = 7},
  [3704] = {.lex_state = 0, .external_lex_state = 7},
  [3705] = {.lex_state = 44, .external_lex_state = 7},
  [3706] = {.lex_state = 0, .external_lex_state = 7},
  [3707] = {.lex_state = 0, .external_lex_state = 7},
  [3708] = {.lex_state = 0, .external_lex_state = 7},
  [3709] = {.lex_state = 0, .external_lex_state = 7},
  [3710] = {.lex_state = 45, .external_lex_state = 7},
  [3711] = {.lex_state = 0, .external_lex_state = 7},
  [3712] = {.lex_state = 0, .external_lex_state = 7},
  [3713] = {.lex_state = 0, .external_lex_state = 7},
  [3714] = {.lex_state = 0, .external_lex_state = 7},
  [3715] = {.lex_state = 0, .external_lex_state = 7},
  [3716] = {.lex_state = 0, .external_lex_state = 7},
  [3717] = {.lex_state = 0, .external_lex_state = 7},
  [3718] = {.lex_state = 44, .external_lex_state = 7},
  [3719] = {.lex_state = 0, .external_lex_state = 7},
  [3720] = {.lex_state = 0, .external_lex_state = 7},
  [3721] = {.lex_state = 44, .external_lex_state = 7},
  [3722] = {.lex_state = 0, .external_lex_state = 7},
  [3723] = {.lex_state = 0, .external_lex_state = 6},
  [3724] = {.lex_state = 0, .external_lex_state = 7},
  [3725] = {.lex_state = 0, .external_lex_state = 7},
  [3726] = {.lex_state = 45, .external_lex_state = 7},
  [3727] = {.lex_state = 0, .external_lex_state = 7},
  [3728] = {.lex_state = 0, .external_lex_state = 7},
  [3729] = {.lex_state = 0, .external_lex_state = 7},
  [3730] = {.lex_state = 0, .external_lex_state = 7},
  [3731] = {.lex_state = 0, .external_lex_state = 7},
  [3732] = {.lex_state = 0, .external_lex_state = 7},
  [3733] = {.lex_state = 0, .external_lex_state = 7},
  [3734] = {.lex_state = 0, .external_lex_state = 7},
  [3735] = {.lex_state = 44, .external_lex_state = 7},
  [3736] = {.lex_state = 0, .external_lex_state = 7},
  [3737] = {.lex_state = 0, .external_lex_state = 7},
  [3738] = {.lex_state = 0, .external_lex_state = 7},
  [3739] = {.lex_state = 0, .external_lex_state = 7},
  [3740] = {.lex_state = 0, .external_lex_state = 7},
  [3741] = {.lex_state = 45, .external_lex_state = 7},
  [3742] = {.lex_state = 0, .external_lex_state = 6},
  [3743] = {.lex_state = 0, .external_lex_state = 7},
  [3744] = {.lex_state = 0, .external_lex_state = 7},
  [3745] = {.lex_state = 0, .external_lex_state = 7},
  [3746] = {.lex_state = 0, .external_lex_state = 7},
  [3747] = {.lex_state = 0, .external_lex_state = 6},
  [3748] = {.lex_state = 0, .external_lex_state = 7},
  [3749] = {.lex_state = 0, .external_lex_state = 7},
  [3750] = {.lex_state = 0, .external_lex_state = 7},
  [3751] = {.lex_state = 0, .external_lex_state = 7},
  [3752] = {.lex_state = 0, .external_lex_state = 7},
  [3753] = {.lex_state = 44, .external_lex_state = 7},
  [3754] = {.lex_state = 0, .external_lex_state = 7},
  [3755] = {.lex_state = 0, .external_lex_state = 7},
  [3756] = {.lex_state = 0, .external_lex_state = 7},
  [3757] = {.lex_state = 0, .external_lex_state = 7},
  [3758] = {.lex_state = 0, .external_lex_state = 7},
  [3759] = {.lex_state = 0, .external_lex_state = 7},
  [3760] = {.lex_state = 44, .external_lex_state = 7},
  [3761] = {.lex_state = 0, .external_lex_state = 7},
  [3762] = {.lex_state = 0, .external_lex_state = 7},
  [3763] = {.lex_state = 0, .external_lex_state = 6},
  [3764] = {.lex_state = 0, .external_lex_state = 7},
  [3765] = {.lex_state = 0, .external_lex_state = 7},
  [3766] = {.lex_state = 45, .external_lex_state = 7},
  [3767] = {.lex_state = 0, .external_lex_state = 7},
  [3768] = {.lex_state = 0, .external_lex_state = 7},
  [3769] = {.lex_state = 0, .external_lex_state = 7},
  [3770] = {.lex_state = 0, .external_lex_state = 7},
  [3771] = {.lex_state = 32, .external_lex_state = 7},
  [3772] = {.lex_state = 0, .external_lex_state = 7},
  [3773] = {.lex_state = 0, .external_lex_state = 7},
  [3774] = {.lex_state = 0, .external_lex_state = 7},
  [3775] = {.lex_state = 0, .external_lex_state = 7},
  [3776] = {.lex_state = 0, .external_lex_state = 7},
  [3777] = {.lex_state = 0, .external_lex_state = 7},
  [3778] = {.lex_state = 0, .external_lex_state = 7},
  [3779] = {.lex_state = 0, .external_lex_state = 7},
  [3780] = {.lex_state = 0, .external_lex_state = 7},
  [3781] = {.lex_state = 0, .external_lex_state = 7},
  [3782] = {.lex_state = 0, .external_lex_state = 7},
  [3783] = {.lex_state = 0, .external_lex_state = 7},
  [3784] = {.lex_state = 0, .external_lex_state = 7},
  [3785] = {.lex_state = 0, .external_lex_state = 7},
  [3786] = {.lex_state = 0, .external_lex_state = 7},
  [3787] = {.lex_state = 0, .external_lex_state = 7},
  [3788] = {.lex_state = 0, .external_lex_state = 7},
  [3789] = {.lex_state = 0, .external_lex_state = 7},
  [3790] = {.lex_state = 0, .external_lex_state = 7},
  [3791] = {.lex_state = 42, .external_lex_state = 7},
  [3792] = {.lex_state = 0, .external_lex_state = 7},
  [3793] = {.lex_state = 0, .external_lex_state = 7},
  [3794] = {.lex_state = 0, .external_lex_state = 7},
  [3795] = {.lex_state = 0, .external_lex_state = 7},
  [3796] = {.lex_state = 0, .external_lex_state = 7},
  [3797] = {.lex_state = 0, .external_lex_state = 7},
  [3798] = {.lex_state = 0, .external_lex_state = 7},
  [3799] = {.lex_state = 0, .external_lex_state = 7},
  [3800] = {.lex_state = 0, .external_lex_state = 7},
  [3801] = {.lex_state = 0, .external_lex_state = 7},
  [3802] = {.lex_state = 0, .external_lex_state = 7},
  [3803] = {.lex_state = 0, .external_lex_state = 7},
  [3804] = {.lex_state = 0, .external_lex_state = 7},
  [3805] = {.lex_state = 0, .external_lex_state = 7},
  [3806] = {.lex_state = 0, .external_lex_state = 7},
  [3807] = {.lex_state = 0, .external_lex_state = 7},
  [3808] = {.lex_state = 0, .external_lex_state = 7},
  [3809] = {.lex_state = 0, .external_lex_state = 7},
  [3810] = {.lex_state = 0, .external_lex_state = 7},
  [3811] = {.lex_state = 0, .external_lex_state = 7},
  [3812] = {.lex_state = 0, .external_lex_state = 7},
  [3813] = {.lex_state = 0, .external_lex_state = 7},
  [3814] = {.lex_state = 0, .external_lex_state = 7},
  [3815] = {.lex_state = 0, .external_lex_state = 7},
  [3816] = {.lex_state = 0, .external_lex_state = 7},
  [3817] = {.lex_state = 0, .external_lex_state = 7},
  [3818] = {.lex_state = 0, .external_lex_state = 7},
  [3819] = {.lex_state = 0, .external_lex_state = 7},
  [3820] = {.lex_state = 0, .external_lex_state = 7},
  [3821] = {.lex_state = 0, .external_lex_state = 7},
  [3822] = {.lex_state = 0, .external_lex_state = 7},
  [3823] = {.lex_state = 0, .external_lex_state = 7},
  [3824] = {.lex_state = 0, .external_lex_state = 7},
  [3825] = {.lex_state = 0, .external_lex_state = 7},
  [3826] = {.lex_state = 0, .external_lex_state = 7},
  [3827] = {.lex_state = 0, .external_lex_state = 7},
  [3828] = {.lex_state = 0, .external_lex_state = 7},
  [3829] = {.lex_state = 0, .external_lex_state = 7},
  [3830] = {.lex_state = 0, .external_lex_state = 7},
  [3831] = {.lex_state = 0, .external_lex_state = 7},
  [3832] = {.lex_state = 0, .external_lex_state = 7},
  [3833] = {.lex_state = 0, .external_lex_state = 7},
  [3834] = {.lex_state = 0, .external_lex_state = 7},
  [3835] = {.lex_state = 0, .external_lex_state = 7},
  [3836] = {.lex_state = 0, .external_lex_state = 7},
  [3837] = {.lex_state = 0, .external_lex_state = 7},
  [3838] = {.lex_state = 0, .external_lex_state = 7},
  [3839] = {.lex_state = 0, .external_lex_state = 7},
  [3840] = {.lex_state = 0, .external_lex_state = 7},
  [3841] = {.lex_state = 0, .external_lex_state = 7},
  [3842] = {.lex_state = 0, .external_lex_state = 7},
  [3843] = {.lex_state = 0, .external_lex_state = 7},
  [3844] = {.lex_state = 0, .external_lex_state = 7},
  [3845] = {.lex_state = 0, .external_lex_state = 7},
  [3846] = {.lex_state = 0, .external_lex_state = 7},
  [3847] = {.lex_state = 0, .external_lex_state = 7},
  [3848] = {.lex_state = 0, .external_lex_state = 7},
  [3849] = {.lex_state = 0, .external_lex_state = 7},
  [3850] = {.lex_state = 0, .external_lex_state = 7},
  [3851] = {.lex_state = 0, .external_lex_state = 7},
  [3852] = {.lex_state = 0, .external_lex_state = 7},
  [3853] = {.lex_state = 0, .external_lex_state = 7},
  [3854] = {.lex_state = 0, .external_lex_state = 7},
  [3855] = {.lex_state = 0, .external_lex_state = 7},
  [3856] = {.lex_state = 0, .external_lex_state = 7},
  [3857] = {.lex_state = 0, .external_lex_state = 7},
  [3858] = {.lex_state = 0, .external_lex_state = 7},
  [3859] = {.lex_state = 0, .external_lex_state = 7},
  [3860] = {.lex_state = 0, .external_lex_state = 7},
  [3861] = {.lex_state = 0, .external_lex_state = 7},
  [3862] = {.lex_state = 0, .external_lex_state = 7},
  [3863] = {.lex_state = 0, .external_lex_state = 7},
  [3864] = {.lex_state = 0, .external_lex_state = 7},
  [3865] = {.lex_state = 0, .external_lex_state = 7},
  [3866] = {.lex_state = 0, .external_lex_state = 7},
  [3867] = {.lex_state = 0, .external_lex_state = 7},
  [3868] = {.lex_state = 0, .external_lex_state = 7},
  [3869] = {.lex_state = 0, .external_lex_state = 7},
  [3870] = {.lex_state = 0, .external_lex_state = 7},
  [3871] = {.lex_state = 0, .external_lex_state = 7},
  [3872] = {.lex_state = 0, .external_lex_state = 7},
  [3873] = {.lex_state = 0, .external_lex_state = 7},
  [3874] = {.lex_state = 0, .external_lex_state = 7},
  [3875] = {.lex_state = 0, .external_lex_state = 7},
  [3876] = {.lex_state = 0, .external_lex_state = 7},
  [3877] = {.lex_state = 0, .external_lex_state = 7},
  [3878] = {.lex_state = 0, .external_lex_state = 7},
  [3879] = {.lex_state = 0, .external_lex_state = 7},
  [3880] = {.lex_state = 0, .external_lex_state = 7},
  [3881] = {.lex_state = 0, .external_lex_state = 7},
  [3882] = {.lex_state = 0, .external_lex_state = 7},
  [3883] = {.lex_state = 0, .external_lex_state = 7},
  [3884] = {.lex_state = 0, .external_lex_state = 7},
  [3885] = {.lex_state = 0, .external_lex_state = 7},
  [3886] = {.lex_state = 0, .external_lex_state = 7},
  [3887] = {.lex_state = 0, .external_lex_state = 7},
  [3888] = {.lex_state = 0, .external_lex_state = 7},
  [3889] = {.lex_state = 0, .external_lex_state = 7},
  [3890] = {.lex_state = 0, .external_lex_state = 7},
  [3891] = {.lex_state = 0, .external_lex_state = 7},
  [3892] = {.lex_state = 0, .external_lex_state = 7},
  [3893] = {.lex_state = 0, .external_lex_state = 7},
  [3894] = {.lex_state = 0, .external_lex_state = 7},
  [3895] = {.lex_state = 0, .external_lex_state = 7},
  [3896] = {.lex_state = 0, .external_lex_state = 7},
  [3897] = {.lex_state = 0, .external_lex_state = 7},
  [3898] = {.lex_state = 0, .external_lex_state = 7},
  [3899] = {.lex_state = 0, .external_lex_state = 7},
  [3900] = {.lex_state = 0, .external_lex_state = 7},
  [3901] = {.lex_state = 0, .external_lex_state = 7},
  [3902] = {.lex_state = 0, .external_lex_state = 7},
  [3903] = {.lex_state = 0, .external_lex_state = 7},
  [3904] = {.lex_state = 0, .external_lex_state = 7},
  [3905] = {.lex_state = 0, .external_lex_state = 7},
  [3906] = {.lex_state = 0, .external_lex_state = 7},
  [3907] = {.lex_state = 0, .external_lex_state = 7},
  [3908] = {.lex_state = 0, .external_lex_state = 7},
  [3909] = {.lex_state = 0, .external_lex_state = 7},
  [3910] = {.lex_state = 0, .external_lex_state = 7},
  [3911] = {.lex_state = 0, .external_lex_state = 7},
  [3912] = {.lex_state = 0, .external_lex_state = 7},
  [3913] = {.lex_state = 0, .external_lex_state = 7},
  [3914] = {.lex_state = 32, .external_lex_state = 7},
  [3915] = {.lex_state = 0, .external_lex_state = 7},
  [3916] = {.lex_state = 0, .external_lex_state = 7},
  [3917] = {.lex_state = 32, .external_lex_state = 7},
  [3918] = {.lex_state = 0, .external_lex_state = 7},
  [3919] = {.lex_state = 0, .external_lex_state = 7},
  [3920] = {.lex_state = 0, .external_lex_state = 7},
  [3921] = {.lex_state = 0, .external_lex_state = 7},
  [3922] = {.lex_state = 0, .external_lex_state = 7},
  [3923] = {.lex_state = 0, .external_lex_state = 7},
  [3924] = {.lex_state = 0, .external_lex_state = 7},
  [3925] = {.lex_state = 0, .external_lex_state = 7},
  [3926] = {.lex_state = 0, .external_lex_state = 7},
  [3927] = {.lex_state = 0, .external_lex_state = 7},
  [3928] = {.lex_state = 0, .external_lex_state = 7},
  [3929] = {.lex_state = 0, .external_lex_state = 7},
  [3930] = {.lex_state = 0, .external_lex_state = 7},
  [3931] = {.lex_state = 0, .external_lex_state = 7},
  [3932] = {.lex_state = 0, .external_lex_state = 7},
  [3933] = {.lex_state = 0, .external_lex_state = 7},
  [3934] = {.lex_state = 0, .external_lex_state = 7},
  [3935] = {.lex_state = 0, .external_lex_state = 7},
  [3936] = {.lex_state = 0, .external_lex_state = 7},
  [3937] = {.lex_state = 0, .external_lex_state = 7},
  [3938] = {.lex_state = 32, .external_lex_state = 7},
  [3939] = {.lex_state = 0, .external_lex_state = 7},
  [3940] = {.lex_state = 0, .external_lex_state = 7},
  [3941] = {.lex_state = 0, .external_lex_state = 7},
  [3942] = {.lex_state = 0, .external_lex_state = 7},
  [3943] = {.lex_state = 0, .external_lex_state = 7},
  [3944] = {.lex_state = 0, .external_lex_state = 7},
  [3945] = {.lex_state = 0, .external_lex_state = 7},
  [3946] = {.lex_state = 0, .external_lex_state = 7},
  [3947] = {.lex_state = 0, .external_lex_state = 7},
  [3948] = {.lex_state = 0, .external_lex_state = 7},
  [3949] = {.lex_state = 0, .external_lex_state = 7},
  [3950] = {.lex_state = 0, .external_lex_state = 7},
  [3951] = {.lex_state = 0, .external_lex_state = 7},
  [3952] = {.lex_state = 0, .external_lex_state = 7},
  [3953] = {.lex_state = 0, .external_lex_state = 7},
  [3954] = {.lex_state = 0, .external_lex_state = 7},
  [3955] = {.lex_state = 0, .external_lex_state = 7},
  [3956] = {.lex_state = 0, .external_lex_state = 7},
  [3957] = {.lex_state = 0, .external_lex_state = 7},
  [3958] = {.lex_state = 0, .external_lex_state = 7},
  [3959] = {.lex_state = 0, .external_lex_state = 7},
  [3960] = {.lex_state = 0, .external_lex_state = 7},
  [3961] = {.lex_state = 0, .external_lex_state = 7},
  [3962] = {.lex_state = 0, .external_lex_state = 7},
  [3963] = {.lex_state = 0, .external_lex_state = 7},
  [3964] = {.lex_state = 0, .external_lex_state = 7},
  [3965] = {.lex_state = 0, .external_lex_state = 7},
  [3966] = {.lex_state = 0, .external_lex_state = 7},
  [3967] = {.lex_state = 0, .external_lex_state = 6},
  [3968] = {.lex_state = 0, .external_lex_state = 7},
  [3969] = {.lex_state = 0, .external_lex_state = 7},
  [3970] = {.lex_state = 0, .external_lex_state = 7},
  [3971] = {.lex_state = 0, .external_lex_state = 7},
  [3972] = {.lex_state = 0, .external_lex_state = 7},
  [3973] = {.lex_state = 0, .external_lex_state = 7},
  [3974] = {.lex_state = 0, .external_lex_state = 7},
  [3975] = {.lex_state = 0, .external_lex_state = 7},
  [3976] = {.lex_state = 0, .external_lex_state = 7},
  [3977] = {.lex_state = 0, .external_lex_state = 7},
  [3978] = {.lex_state = 0, .external_lex_state = 7},
  [3979] = {.lex_state = 0, .external_lex_state = 7},
  [3980] = {.lex_state = 0, .external_lex_state = 7},
  [3981] = {.lex_state = 0, .external_lex_state = 7},
  [3982] = {.lex_state = 0, .external_lex_state = 7},
  [3983] = {.lex_state = 0, .external_lex_state = 7},
  [3984] = {.lex_state = 0, .external_lex_state = 7},
  [3985] = {.lex_state = 0, .external_lex_state = 7},
  [3986] = {.lex_state = 0, .external_lex_state = 7},
  [3987] = {.lex_state = 0, .external_lex_state = 7},
  [3988] = {.lex_state = 0, .external_lex_state = 7},
  [3989] = {.lex_state = 0, .external_lex_state = 7},
  [3990] = {.lex_state = 0, .external_lex_state = 7},
  [3991] = {.lex_state = 0, .external_lex_state = 7},
  [3992] = {.lex_state = 0, .external_lex_state = 7},
  [3993] = {.lex_state = 0, .external_lex_state = 7},
  [3994] = {.lex_state = 0, .external_lex_state = 7},
  [3995] = {.lex_state = 0, .external_lex_state = 7},
  [3996] = {.lex_state = 0, .external_lex_state = 7},
  [3997] = {.lex_state = 0, .external_lex_state = 7},
  [3998] = {.lex_state = 0, .external_lex_state = 7},
  [3999] = {.lex_state = 0, .external_lex_state = 7},
  [4000] = {.lex_state = 0, .external_lex_state = 7},
  [4001] = {.lex_state = 0, .external_lex_state = 7},
  [4002] = {.lex_state = 0, .external_lex_state = 7},
  [4003] = {.lex_state = 0, .external_lex_state = 7},
  [4004] = {.lex_state = 0, .external_lex_state = 7},
  [4005] = {.lex_state = 0, .external_lex_state = 7},
  [4006] = {.lex_state = 0, .external_lex_state = 7},
  [4007] = {.lex_state = 0, .external_lex_state = 7},
  [4008] = {.lex_state = 0, .external_lex_state = 7},
  [4009] = {.lex_state = 0, .external_lex_state = 7},
  [4010] = {.lex_state = 0, .external_lex_state = 7},
  [4011] = {.lex_state = 0, .external_lex_state = 7},
  [4012] = {.lex_state = 0, .external_lex_state = 7},
  [4013] = {.lex_state = 0, .external_lex_state = 7},
  [4014] = {.lex_state = 0, .external_lex_state = 7},
  [4015] = {.lex_state = 0, .external_lex_state = 7},
  [4016] = {.lex_state = 0, .external_lex_state = 7},
  [4017] = {.lex_state = 0, .external_lex_state = 7},
  [4018] = {.lex_state = 0, .external_lex_state = 7},
  [4019] = {.lex_state = 0, .external_lex_state = 7},
  [4020] = {.lex_state = 0, .external_lex_state = 7},
  [4021] = {.lex_state = 0, .external_lex_state = 7},
  [4022] = {.lex_state = 0, .external_lex_state = 7},
  [4023] = {.lex_state = 0, .external_lex_state = 7},
  [4024] = {.lex_state = 0, .external_lex_state = 7},
  [4025] = {.lex_state = 0, .external_lex_state = 7},
  [4026] = {.lex_state = 0, .external_lex_state = 7},
  [4027] = {.lex_state = 0, .external_lex_state = 7},
  [4028] = {.lex_state = 0, .external_lex_state = 7},
  [4029] = {.lex_state = 0, .external_lex_state = 7},
  [4030] = {.lex_state = 0, .external_lex_state = 7},
  [4031] = {.lex_state = 0, .external_lex_state = 7},
  [4032] = {.lex_state = 0, .external_lex_state = 7},
  [4033] = {.lex_state = 0, .external_lex_state = 7},
  [4034] = {.lex_state = 0, .external_lex_state = 7},
  [4035] = {.lex_state = 0, .external_lex_state = 7},
  [4036] = {.lex_state = 0, .external_lex_state = 7},
  [4037] = {.lex_state = 0, .external_lex_state = 7},
  [4038] = {.lex_state = 0, .external_lex_state = 7},
  [4039] = {.lex_state = 0, .external_lex_state = 7},
  [4040] = {.lex_state = 0, .external_lex_state = 7},
  [4041] = {.lex_state = 0, .external_lex_state = 7},
  [4042] = {.lex_state = 0, .external_lex_state = 7},
  [4043] = {.lex_state = 0, .external_lex_state = 7},
  [4044] = {.lex_state = 0, .external_lex_state = 7},
  [4045] = {.lex_state = 0, .external_lex_state = 7},
  [4046] = {.lex_state = 0, .external_lex_state = 7},
  [4047] = {.lex_state = 0, .external_lex_state = 7},
  [4048] = {.lex_state = 0, .external_lex_state = 7},
  [4049] = {.lex_state = 0, .external_lex_state = 7},
  [4050] = {.lex_state = 0, .external_lex_state = 7},
  [4051] = {.lex_state = 0, .external_lex_state = 7},
  [4052] = {.lex_state = 0, .external_lex_state = 7},
  [4053] = {.lex_state = 0, .external_lex_state = 7},
  [4054] = {.lex_state = 0, .external_lex_state = 7},
  [4055] = {.lex_state = 0, .external_lex_state = 7},
  [4056] = {.lex_state = 0, .external_lex_state = 7},
  [4057] = {.lex_state = 32, .external_lex_state = 7},
  [4058] = {.lex_state = 0, .external_lex_state = 7},
  [4059] = {.lex_state = 0, .external_lex_state = 7},
  [4060] = {.lex_state = 32, .external_lex_state = 7},
  [4061] = {.lex_state = 0, .external_lex_state = 7},
  [4062] = {.lex_state = 0, .external_lex_state = 7},
  [4063] = {.lex_state = 0, .external_lex_state = 7},
  [4064] = {.lex_state = 0, .external_lex_state = 7},
  [4065] = {.lex_state = 0, .external_lex_state = 7},
  [4066] = {.lex_state = 0, .external_lex_state = 7},
  [4067] = {.lex_state = 0, .external_lex_state = 7},
  [4068] = {.lex_state = 0, .external_lex_state = 7},
  [4069] = {.lex_state = 0, .external_lex_state = 7},
  [4070] = {.lex_state = 0, .external_lex_state = 7},
  [4071] = {.lex_state = 0, .external_lex_state = 7},
  [4072] = {.lex_state = 0, .external_lex_state = 7},
  [4073] = {.lex_state = 0, .external_lex_state = 7},
  [4074] = {.lex_state = 0, .external_lex_state = 7},
  [4075] = {.lex_state = 0, .external_lex_state = 7},
  [4076] = {.lex_state = 0, .external_lex_state = 7},
  [4077] = {.lex_state = 0, .external_lex_state = 7},
  [4078] = {.lex_state = 0, .external_lex_state = 7},
  [4079] = {.lex_state = 0, .external_lex_state = 7},
  [4080] = {.lex_state = 0, .external_lex_state = 7},
  [4081] = {.lex_state = 0, .external_lex_state = 7},
  [4082] = {.lex_state = 0, .external_lex_state = 7},
  [4083] = {.lex_state = 0, .external_lex_state = 7},
  [4084] = {.lex_state = 0, .external_lex_state = 7},
  [4085] = {.lex_state = 0, .external_lex_state = 7},
  [4086] = {.lex_state = 0, .external_lex_state = 7},
  [4087] = {.lex_state = 0, .external_lex_state = 7},
  [4088] = {.lex_state = 0, .external_lex_state = 7},
  [4089] = {.lex_state = 0, .external_lex_state = 7},
  [4090] = {.lex_state = 32, .external_lex_state = 7},
  [4091] = {.lex_state = 0, .external_lex_state = 7},
  [4092] = {.lex_state = 0, .external_lex_state = 7},
  [4093] = {.lex_state = 32, .external_lex_state = 7},
  [4094] = {.lex_state = 0, .external_lex_state = 7},
  [4095] = {.lex_state = 0, .external_lex_state = 7},
  [4096] = {.lex_state = 0, .external_lex_state = 7},
  [4097] = {.lex_state = 0, .external_lex_state = 7},
  [4098] = {.lex_state = 0, .external_lex_state = 7},
  [4099] = {.lex_state = 0, .external_lex_state = 7},
  [4100] = {.lex_state = 0, .external_lex_state = 7},
  [4101] = {.lex_state = 0, .external_lex_state = 7},
  [4102] = {.lex_state = 0, .external_lex_state = 7},
  [4103] = {.lex_state = 0, .external_lex_state = 7},
  [4104] = {.lex_state = 0, .external_lex_state = 7},
  [4105] = {.lex_state = 0, .external_lex_state = 7},
  [4106] = {.lex_state = 0, .external_lex_state = 7},
  [4107] = {.lex_state = 0, .external_lex_state = 7},
  [4108] = {.lex_state = 0, .external_lex_state = 7},
  [4109] = {.lex_state = 0, .external_lex_state = 7},
  [4110] = {.lex_state = 0, .external_lex_state = 7},
  [4111] = {.lex_state = 0, .external_lex_state = 7},
  [4112] = {.lex_state = 0, .external_lex_state = 7},
  [4113] = {.lex_state = 0, .external_lex_state = 7},
  [4114] = {.lex_state = 0, .external_lex_state = 7},
  [4115] = {.lex_state = 0, .external_lex_state = 7},
  [4116] = {.lex_state = 0, .external_lex_state = 7},
  [4117] = {.lex_state = 0, .external_lex_state = 7},
  [4118] = {.lex_state = 0, .external_lex_state = 7},
  [4119] = {.lex_state = 0, .external_lex_state = 7},
  [4120] = {.lex_state = 32, .external_lex_state = 7},
  [4121] = {.lex_state = 0, .external_lex_state = 7},
  [4122] = {.lex_state = 0, .external_lex_state = 7},
  [4123] = {.lex_state = 32, .external_lex_state = 7},
  [4124] = {.lex_state = 0, .external_lex_state = 7},
  [4125] = {.lex_state = 0, .external_lex_state = 7},
  [4126] = {.lex_state = 0, .external_lex_state = 7},
  [4127] = {.lex_state = 0, .external_lex_state = 7},
  [4128] = {.lex_state = 0, .external_lex_state = 7},
  [4129] = {.lex_state = 0, .external_lex_state = 7},
  [4130] = {.lex_state = 0, .external_lex_state = 7},
  [4131] = {.lex_state = 0, .external_lex_state = 7},
  [4132] = {.lex_state = 0, .external_lex_state = 7},
  [4133] = {.lex_state = 0, .external_lex_state = 7},
  [4134] = {.lex_state = 0, .external_lex_state = 7},
  [4135] = {.lex_state = 0, .external_lex_state = 7},
  [4136] = {.lex_state = 0, .external_lex_state = 7},
  [4137] = {.lex_state = 0, .external_lex_state = 7},
  [4138] = {.lex_state = 0, .external_lex_state = 7},
  [4139] = {.lex_state = 0, .external_lex_state = 7},
  [4140] = {.lex_state = 0, .external_lex_state = 7},
  [4141] = {.lex_state = 0, .external_lex_state = 7},
  [4142] = {.lex_state = 0, .external_lex_state = 7},
  [4143] = {.lex_state = 0, .external_lex_state = 7},
  [4144] = {.lex_state = 0, .external_lex_state = 7},
  [4145] = {.lex_state = 0, .external_lex_state = 7},
  [4146] = {.lex_state = 0, .external_lex_state = 7},
  [4147] = {.lex_state = 0, .external_lex_state = 7},
  [4148] = {.lex_state = 0, .external_lex_state = 7},
  [4149] = {.lex_state = 0, .external_lex_state = 7},
  [4150] = {.lex_state = 32, .external_lex_state = 7},
  [4151] = {.lex_state = 0, .external_lex_state = 7},
  [4152] = {.lex_state = 0, .external_lex_state = 7},
  [4153] = {.lex_state = 32, .external_lex_state = 7},
  [4154] = {.lex_state = 0, .external_lex_state = 7},
  [4155] = {.lex_state = 0, .external_lex_state = 7},
  [4156] = {.lex_state = 0, .external_lex_state = 7},
  [4157] = {.lex_state = 0, .external_lex_state = 7},
  [4158] = {.lex_state = 0, .external_lex_state = 7},
  [4159] = {.lex_state = 0, .external_lex_state = 7},
  [4160] = {.lex_state = 0, .external_lex_state = 7},
  [4161] = {.lex_state = 0, .external_lex_state = 7},
  [4162] = {.lex_state = 0, .external_lex_state = 7},
  [4163] = {.lex_state = 0, .external_lex_state = 7},
  [4164] = {.lex_state = 0, .external_lex_state = 7},
  [4165] = {.lex_state = 0, .external_lex_state = 7},
  [4166] = {.lex_state = 0, .external_lex_state = 7},
  [4167] = {.lex_state = 0, .external_lex_state = 7},
  [4168] = {.lex_state = 0, .external_lex_state = 7},
  [4169] = {.lex_state = 0, .external_lex_state = 7},
  [4170] = {.lex_state = 0, .external_lex_state = 7},
  [4171] = {.lex_state = 0, .external_lex_state = 7},
  [4172] = {.lex_state = 0, .external_lex_state = 7},
  [4173] = {.lex_state = 0, .external_lex_state = 7},
  [4174] = {.lex_state = 0, .external_lex_state = 7},
  [4175] = {.lex_state = 0, .external_lex_state = 7},
  [4176] = {.lex_state = 0, .external_lex_state = 7},
  [4177] = {.lex_state = 0, .external_lex_state = 7},
  [4178] = {.lex_state = 0, .external_lex_state = 7},
  [4179] = {.lex_state = 0, .external_lex_state = 7},
  [4180] = {.lex_state = 32, .external_lex_state = 7},
  [4181] = {.lex_state = 0, .external_lex_state = 7},
  [4182] = {.lex_state = 0, .external_lex_state = 7},
  [4183] = {.lex_state = 32, .external_lex_state = 7},
  [4184] = {.lex_state = 0, .external_lex_state = 7},
  [4185] = {.lex_state = 0, .external_lex_state = 7},
  [4186] = {.lex_state = 0, .external_lex_state = 7},
  [4187] = {.lex_state = 0, .external_lex_state = 7},
  [4188] = {.lex_state = 0, .external_lex_state = 7},
  [4189] = {.lex_state = 0, .external_lex_state = 7},
  [4190] = {.lex_state = 0, .external_lex_state = 7},
  [4191] = {.lex_state = 0, .external_lex_state = 7},
  [4192] = {.lex_state = 0, .external_lex_state = 7},
  [4193] = {.lex_state = 0, .external_lex_state = 7},
  [4194] = {.lex_state = 0, .external_lex_state = 7},
  [4195] = {.lex_state = 0, .external_lex_state = 7},
  [4196] = {.lex_state = 0, .external_lex_state = 7},
  [4197] = {.lex_state = 0, .external_lex_state = 7},
  [4198] = {.lex_state = 0, .external_lex_state = 7},
  [4199] = {.lex_state = 0, .external_lex_state = 7},
  [4200] = {.lex_state = 0, .external_lex_state = 7},
  [4201] = {.lex_state = 0, .external_lex_state = 7},
  [4202] = {.lex_state = 0, .external_lex_state = 7},
  [4203] = {.lex_state = 0, .external_lex_state = 7},
  [4204] = {.lex_state = 0, .external_lex_state = 7},
  [4205] = {.lex_state = 0, .external_lex_state = 7},
  [4206] = {.lex_state = 0, .external_lex_state = 7},
  [4207] = {.lex_state = 0, .external_lex_state = 7},
  [4208] = {.lex_state = 0, .external_lex_state = 7},
  [4209] = {.lex_state = 0, .external_lex_state = 7},
  [4210] = {.lex_state = 32, .external_lex_state = 7},
  [4211] = {.lex_state = 0, .external_lex_state = 7},
  [4212] = {.lex_state = 0, .external_lex_state = 7},
  [4213] = {.lex_state = 32, .external_lex_state = 7},
  [4214] = {.lex_state = 0, .external_lex_state = 7},
  [4215] = {.lex_state = 0, .external_lex_state = 7},
  [4216] = {.lex_state = 0, .external_lex_state = 7},
  [4217] = {.lex_state = 0, .external_lex_state = 7},
  [4218] = {.lex_state = 0, .external_lex_state = 7},
  [4219] = {.lex_state = 0, .external_lex_state = 7},
  [4220] = {.lex_state = 0, .external_lex_state = 7},
  [4221] = {.lex_state = 0, .external_lex_state = 7},
  [4222] = {.lex_state = 0, .external_lex_state = 7},
  [4223] = {.lex_state = 0, .external_lex_state = 7},
  [4224] = {.lex_state = 0, .external_lex_state = 7},
  [4225] = {.lex_state = 0, .external_lex_state = 7},
  [4226] = {.lex_state = 0, .external_lex_state = 7},
  [4227] = {.lex_state = 0, .external_lex_state = 7},
  [4228] = {.lex_state = 0, .external_lex_state = 7},
  [4229] = {.lex_state = 0, .external_lex_state = 7},
  [4230] = {.lex_state = 0, .external_lex_state = 7},
  [4231] = {.lex_state = 0, .external_lex_state = 7},
  [4232] = {.lex_state = 0, .external_lex_state = 7},
  [4233] = {.lex_state = 0, .external_lex_state = 7},
  [4234] = {.lex_state = 0, .external_lex_state = 7},
  [4235] = {.lex_state = 0, .external_lex_state = 7},
  [4236] = {.lex_state = 0, .external_lex_state = 7},
  [4237] = {.lex_state = 0, .external_lex_state = 7},
  [4238] = {.lex_state = 0, .external_lex_state = 7},
  [4239] = {.lex_state = 0, .external_lex_state = 7},
  [4240] = {.lex_state = 0, .external_lex_state = 7},
  [4241] = {.lex_state = 0, .external_lex_state = 7},
  [4242] = {.lex_state = 0, .external_lex_state = 7},
  [4243] = {.lex_state = 0, .external_lex_state = 7},
  [4244] = {.lex_state = 0, .external_lex_state = 7},
  [4245] = {.lex_state = 0, .external_lex_state = 7},
  [4246] = {.lex_state = 0, .external_lex_state = 7},
  [4247] = {.lex_state = 0, .external_lex_state = 7},
  [4248] = {.lex_state = 0, .external_lex_state = 7},
  [4249] = {.lex_state = 0, .external_lex_state = 7},
  [4250] = {.lex_state = 0, .external_lex_state = 7},
  [4251] = {.lex_state = 0, .external_lex_state = 7},
  [4252] = {.lex_state = 0, .external_lex_state = 7},
  [4253] = {.lex_state = 0, .external_lex_state = 7},
  [4254] = {.lex_state = 0, .external_lex_state = 7},
  [4255] = {.lex_state = 0, .external_lex_state = 7},
  [4256] = {.lex_state = 0, .external_lex_state = 7},
  [4257] = {.lex_state = 0, .external_lex_state = 7},
  [4258] = {.lex_state = 0, .external_lex_state = 7},
  [4259] = {.lex_state = 0, .external_lex_state = 7},
  [4260] = {.lex_state = 0, .external_lex_state = 7},
  [4261] = {.lex_state = 0, .external_lex_state = 7},
  [4262] = {.lex_state = 0, .external_lex_state = 7},
  [4263] = {.lex_state = 0, .external_lex_state = 7},
  [4264] = {.lex_state = 0, .external_lex_state = 7},
  [4265] = {.lex_state = 0, .external_lex_state = 7},
  [4266] = {.lex_state = 0, .external_lex_state = 7},
  [4267] = {.lex_state = 0, .external_lex_state = 7},
  [4268] = {.lex_state = 0, .external_lex_state = 7},
  [4269] = {.lex_state = 0, .external_lex_state = 7},
  [4270] = {.lex_state = 0, .external_lex_state = 7},
  [4271] = {.lex_state = 0, .external_lex_state = 7},
  [4272] = {.lex_state = 0, .external_lex_state = 7},
  [4273] = {.lex_state = 0, .external_lex_state = 7},
  [4274] = {.lex_state = 0, .external_lex_state = 7},
  [4275] = {.lex_state = 0, .external_lex_state = 7},
  [4276] = {.lex_state = 0, .external_lex_state = 7},
  [4277] = {.lex_state = 0, .external_lex_state = 7},
  [4278] = {.lex_state = 0, .external_lex_state = 7},
  [4279] = {.lex_state = 0, .external_lex_state = 7},
  [4280] = {.lex_state = 0, .external_lex_state = 7},
  [4281] = {.lex_state = 0, .external_lex_state = 7},
  [4282] = {.lex_state = 0, .external_lex_state = 7},
  [4283] = {.lex_state = 0, .external_lex_state = 7},
  [4284] = {.lex_state = 0, .external_lex_state = 7},
  [4285] = {.lex_state = 0, .external_lex_state = 7},
  [4286] = {.lex_state = 0, .external_lex_state = 7},
  [4287] = {.lex_state = 0, .external_lex_state = 7},
  [4288] = {.lex_state = 0, .external_lex_state = 7},
  [4289] = {.lex_state = 0, .external_lex_state = 7},
  [4290] = {.lex_state = 0, .external_lex_state = 7},
  [4291] = {.lex_state = 0, .external_lex_state = 7},
  [4292] = {.lex_state = 0, .external_lex_state = 7},
  [4293] = {.lex_state = 0, .external_lex_state = 7},
  [4294] = {.lex_state = 0, .external_lex_state = 7},
  [4295] = {.lex_state = 0, .external_lex_state = 7},
  [4296] = {.lex_state = 0, .external_lex_state = 7},
  [4297] = {.lex_state = 0, .external_lex_state = 7},
  [4298] = {.lex_state = 0, .external_lex_state = 7},
  [4299] = {.lex_state = 0, .external_lex_state = 7},
  [4300] = {.lex_state = 0, .external_lex_state = 7},
  [4301] = {.lex_state = 0, .external_lex_state = 7},
  [4302] = {.lex_state = 0, .external_lex_state = 7},
  [4303] = {.lex_state = 0, .external_lex_state = 7},
  [4304] = {.lex_state = 0, .external_lex_state = 7},
  [4305] = {.lex_state = 0, .external_lex_state = 7},
  [4306] = {.lex_state = 0, .external_lex_state = 7},
  [4307] = {.lex_state = 0, .external_lex_state = 7},
  [4308] = {.lex_state = 0, .external_lex_state = 7},
  [4309] = {.lex_state = 0, .external_lex_state = 7},
  [4310] = {.lex_state = 0, .external_lex_state = 7},
  [4311] = {.lex_state = 0, .external_lex_state = 7},
  [4312] = {.lex_state = 0, .external_lex_state = 7},
  [4313] = {.lex_state = 0, .external_lex_state = 7},
  [4314] = {.lex_state = 0, .external_lex_state = 7},
  [4315] = {.lex_state = 0, .external_lex_state = 7},
  [4316] = {.lex_state = 0, .external_lex_state = 7},
  [4317] = {.lex_state = 0, .external_lex_state = 7},
  [4318] = {.lex_state = 0, .external_lex_state = 7},
  [4319] = {.lex_state = 0, .external_lex_state = 7},
  [4320] = {.lex_state = 0, .external_lex_state = 7},
  [4321] = {.lex_state = 0, .external_lex_state = 7},
  [4322] = {.lex_state = 0, .external_lex_state = 7},
  [4323] = {.lex_state = 0, .external_lex_state = 7},
  [4324] = {.lex_state = 0, .external_lex_state = 7},
  [4325] = {.lex_state = 0, .external_lex_state = 7},
};

enum {
  ts_external_token_block_comment = 0,
  ts_external_token__immediate_paren = 1,
  ts_external_token__string_start = 2,
  ts_external_token__command_start = 3,
  ts_external_token__immediate_string_start = 4,
  ts_external_token__immediate_command_start = 5,
  ts_external_token__string_end = 6,
  ts_external_token__command_end = 7,
  ts_external_token__string_content = 8,
  ts_external_token__string_content_no_interp = 9,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_block_comment] = sym_block_comment,
  [ts_external_token__immediate_paren] = sym__immediate_paren,
  [ts_external_token__string_start] = sym__string_start,
  [ts_external_token__command_start] = sym__command_start,
  [ts_external_token__immediate_string_start] = sym__immediate_string_start,
  [ts_external_token__immediate_command_start] = sym__immediate_command_start,
  [ts_external_token__string_end] = sym__string_end,
  [ts_external_token__command_end] = sym__command_end,
  [ts_external_token__string_content] = sym__string_content,
  [ts_external_token__string_content_no_interp] = sym__string_content_no_interp,
};

static const bool ts_external_scanner_states[12][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token__immediate_paren] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__command_start] = true,
    [ts_external_token__immediate_string_start] = true,
    [ts_external_token__immediate_command_start] = true,
    [ts_external_token__string_end] = true,
    [ts_external_token__command_end] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_content_no_interp] = true,
  },
  [2] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__command_start] = true,
  },
  [3] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token__immediate_paren] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__command_start] = true,
    [ts_external_token__immediate_string_start] = true,
    [ts_external_token__immediate_command_start] = true,
  },
  [4] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token__immediate_paren] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__command_start] = true,
  },
  [5] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token__immediate_paren] = true,
    [ts_external_token__immediate_string_start] = true,
    [ts_external_token__immediate_command_start] = true,
  },
  [6] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token__immediate_paren] = true,
  },
  [7] = {
    [ts_external_token_block_comment] = true,
  },
  [8] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token__command_end] = true,
    [ts_external_token__string_content] = true,
  },
  [9] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token__string_end] = true,
    [ts_external_token__string_content] = true,
  },
  [10] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token__string_end] = true,
    [ts_external_token__string_content_no_interp] = true,
  },
  [11] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token__command_end] = true,
    [ts_external_token__string_content_no_interp] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_primitive] = ACTIONS(1),
    [aux_sym_primitive_definition_token1] = ACTIONS(1),
    [anon_sym_mutable] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_macro] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LT_COLON] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [sym_continue_statement] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_quote] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_COLON2] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_begin] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_LT_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_isa] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_LBRACK2] = ACTIONS(1),
    [anon_sym_] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [aux_sym_integer_literal_token1] = ACTIONS(1),
    [aux_sym_integer_literal_token2] = ACTIONS(1),
    [aux_sym_integer_literal_token3] = ACTIONS(1),
    [sym_float_literal] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym__unary_operator] = ACTIONS(1),
    [sym__power_operator] = ACTIONS(1),
    [sym__bitshift_operator] = ACTIONS(1),
    [sym__rational_operator] = ACTIONS(1),
    [sym__times_operator] = ACTIONS(1),
    [sym__plus_operator] = ACTIONS(1),
    [sym__dotty_operator] = ACTIONS(1),
    [sym__comparison_operator] = ACTIONS(1),
    [sym__arrow_operator] = ACTIONS(1),
    [sym__assign_operator] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__command_start] = ACTIONS(1),
    [sym__immediate_string_start] = ACTIONS(1),
    [sym__immediate_command_start] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
    [sym__command_end] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym__string_content_no_interp] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(4202),
    [sym__expression_list] = STATE(4199),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4197),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2598),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2836),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2954),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(26),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(15),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(37),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(41),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(49),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_LBRACK2] = ACTIONS(55),
    [anon_sym_DOLLAR] = ACTIONS(57),
    [anon_sym_AT] = ACTIONS(59),
    [aux_sym_integer_literal_token1] = ACTIONS(61),
    [aux_sym_integer_literal_token2] = ACTIONS(61),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(65),
    [sym__unary_operator] = ACTIONS(67),
    [sym__power_operator] = ACTIONS(69),
    [sym__bitshift_operator] = ACTIONS(69),
    [sym__rational_operator] = ACTIONS(69),
    [sym__times_operator] = ACTIONS(71),
    [sym__plus_operator] = ACTIONS(71),
    [sym__dotty_operator] = ACTIONS(69),
    [sym__comparison_operator] = ACTIONS(71),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [2] = {
    [sym__expression_list] = STATE(3636),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_type_argument_list] = STATE(1975),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(79),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_COMMA] = ACTIONS(85),
    [anon_sym_SEMI] = ACTIONS(87),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(85),
    [anon_sym_COLON_COLON] = ACTIONS(85),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_LT_COLON] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_finally] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_DOT] = ACTIONS(85),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(95),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_PLUS] = ACTIONS(85),
    [anon_sym_LT_PIPE] = ACTIONS(85),
    [anon_sym_PIPE_GT] = ACTIONS(85),
    [anon_sym_in] = ACTIONS(85),
    [anon_sym_isa] = ACTIONS(85),
    [anon_sym_PIPE_PIPE] = ACTIONS(85),
    [anon_sym_AMP_AMP] = ACTIONS(85),
    [anon_sym_QMARK] = ACTIONS(85),
    [anon_sym_EQ_GT] = ACTIONS(85),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DASH_GT] = ACTIONS(103),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(71),
    [sym__bitshift_operator] = ACTIONS(71),
    [sym__rational_operator] = ACTIONS(71),
    [sym__times_operator] = ACTIONS(71),
    [sym__plus_operator] = ACTIONS(71),
    [sym__dotty_operator] = ACTIONS(71),
    [sym__comparison_operator] = ACTIONS(71),
    [sym__arrow_operator] = ACTIONS(85),
    [sym__assign_operator] = ACTIONS(85),
    [anon_sym_LF] = ACTIONS(113),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(97),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
    [sym__immediate_string_start] = ACTIONS(117),
    [sym__immediate_command_start] = ACTIONS(119),
  },
  [3] = {
    [sym_function_definition] = STATE(1081),
    [sym_abstract_definition] = STATE(1081),
    [sym_primitive_definition] = STATE(1081),
    [sym_struct_definition] = STATE(1081),
    [sym_module_definition] = STATE(1081),
    [sym_macro_definition] = STATE(1081),
    [sym_parameter_list] = STATE(3954),
    [sym_if_statement] = STATE(1081),
    [sym_try_statement] = STATE(1081),
    [sym_for_statement] = STATE(1081),
    [sym_while_statement] = STATE(1081),
    [sym_return_statement] = STATE(1081),
    [sym_let_statement] = STATE(1081),
    [sym_const_statement] = STATE(1081),
    [sym_quote_statement] = STATE(1081),
    [sym_import_statement] = STATE(1081),
    [sym_export_statement] = STATE(1081),
    [sym__expression] = STATE(1068),
    [sym__primary_expression] = STATE(870),
    [sym_operator] = STATE(919),
    [sym_parenthesized_expression] = STATE(870),
    [sym_field_expression] = STATE(818),
    [sym_subscript_expression] = STATE(870),
    [sym_typed_expression] = STATE(1081),
    [sym_parameterized_identifier] = STATE(870),
    [sym_compound_expression] = STATE(1081),
    [sym_call_expression] = STATE(870),
    [sym_broadcast_call_expression] = STATE(870),
    [sym_macro_expression] = STATE(1081),
    [sym_macro_argument_list] = STATE(2153),
    [sym_spread_expression] = STATE(1081),
    [sym_unary_expression] = STATE(1081),
    [sym_binary_expression] = STATE(1081),
    [sym_ternary_expression] = STATE(1081),
    [sym_pair_expression] = STATE(1081),
    [sym_tuple_expression] = STATE(870),
    [sym_array_expression] = STATE(870),
    [sym_matrix_expression] = STATE(870),
    [sym_generator_expression] = STATE(1081),
    [sym_array_comprehension_expression] = STATE(870),
    [sym_function_expression] = STATE(1081),
    [sym_range_expression] = STATE(1081),
    [sym_coefficient_expression] = STATE(1081),
    [sym_quote_expression] = STATE(1081),
    [sym_interpolation_expression] = STATE(1081),
    [sym_macro_identifier] = STATE(4),
    [sym__literal] = STATE(894),
    [sym_integer_literal] = STATE(894),
    [sym_character_literal] = STATE(894),
    [sym_string_literal] = STATE(894),
    [sym_command_literal] = STATE(894),
    [sym_prefixed_string_literal] = STATE(894),
    [sym_prefixed_command_literal] = STATE(894),
    [aux_sym_macro_argument_list_repeat1] = STATE(5),
    [sym_identifier] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(123),
    [anon_sym_end] = ACTIONS(125),
    [anon_sym_abstract] = ACTIONS(127),
    [anon_sym_primitive] = ACTIONS(129),
    [aux_sym_primitive_definition_token1] = ACTIONS(131),
    [anon_sym_mutable] = ACTIONS(133),
    [anon_sym_struct] = ACTIONS(135),
    [anon_sym_module] = ACTIONS(137),
    [anon_sym_macro] = ACTIONS(139),
    [anon_sym_LPAREN] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(125),
    [anon_sym_RPAREN] = ACTIONS(125),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_COLON_COLON] = ACTIONS(125),
    [anon_sym_LT_COLON] = ACTIONS(125),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_elseif] = ACTIONS(125),
    [anon_sym_else] = ACTIONS(125),
    [anon_sym_try] = ACTIONS(145),
    [anon_sym_catch] = ACTIONS(125),
    [anon_sym_finally] = ACTIONS(125),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_while] = ACTIONS(149),
    [sym_break_statement] = ACTIONS(151),
    [sym_continue_statement] = ACTIONS(151),
    [anon_sym_return] = ACTIONS(153),
    [anon_sym_let] = ACTIONS(155),
    [anon_sym_const] = ACTIONS(157),
    [anon_sym_quote] = ACTIONS(159),
    [anon_sym_using] = ACTIONS(161),
    [anon_sym_import] = ACTIONS(161),
    [anon_sym_export] = ACTIONS(163),
    [anon_sym_COLON2] = ACTIONS(165),
    [anon_sym_begin] = ACTIONS(167),
    [anon_sym_SQUOTE] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_LT_PIPE] = ACTIONS(125),
    [anon_sym_PIPE_GT] = ACTIONS(125),
    [anon_sym_in] = ACTIONS(125),
    [anon_sym_isa] = ACTIONS(125),
    [anon_sym_PIPE_PIPE] = ACTIONS(125),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_QMARK] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_LBRACK2] = ACTIONS(171),
    [anon_sym_DOLLAR] = ACTIONS(173),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(175),
    [aux_sym_integer_literal_token2] = ACTIONS(175),
    [aux_sym_integer_literal_token3] = ACTIONS(175),
    [sym_float_literal] = ACTIONS(177),
    [sym__unary_operator] = ACTIONS(179),
    [sym__power_operator] = ACTIONS(181),
    [sym__bitshift_operator] = ACTIONS(181),
    [sym__rational_operator] = ACTIONS(181),
    [sym__times_operator] = ACTIONS(181),
    [sym__plus_operator] = ACTIONS(181),
    [sym__dotty_operator] = ACTIONS(181),
    [sym__comparison_operator] = ACTIONS(181),
    [sym__arrow_operator] = ACTIONS(125),
    [sym__assign_operator] = ACTIONS(125),
    [anon_sym_LF] = ACTIONS(183),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(185),
    [sym__string_start] = ACTIONS(187),
    [sym__command_start] = ACTIONS(189),
  },
  [4] = {
    [sym_function_definition] = STATE(1081),
    [sym_abstract_definition] = STATE(1081),
    [sym_primitive_definition] = STATE(1081),
    [sym_struct_definition] = STATE(1081),
    [sym_module_definition] = STATE(1081),
    [sym_macro_definition] = STATE(1081),
    [sym_parameter_list] = STATE(3954),
    [sym_if_statement] = STATE(1081),
    [sym_try_statement] = STATE(1081),
    [sym_for_statement] = STATE(1081),
    [sym_while_statement] = STATE(1081),
    [sym_return_statement] = STATE(1081),
    [sym_let_statement] = STATE(1081),
    [sym_const_statement] = STATE(1081),
    [sym_quote_statement] = STATE(1081),
    [sym_import_statement] = STATE(1081),
    [sym_export_statement] = STATE(1081),
    [sym__expression] = STATE(1068),
    [sym__primary_expression] = STATE(870),
    [sym_operator] = STATE(919),
    [sym_parenthesized_expression] = STATE(870),
    [sym_field_expression] = STATE(818),
    [sym_subscript_expression] = STATE(870),
    [sym_typed_expression] = STATE(1081),
    [sym_parameterized_identifier] = STATE(870),
    [sym_compound_expression] = STATE(1081),
    [sym_call_expression] = STATE(870),
    [sym_broadcast_call_expression] = STATE(870),
    [sym_macro_expression] = STATE(1081),
    [sym_macro_argument_list] = STATE(989),
    [sym_spread_expression] = STATE(1081),
    [sym_unary_expression] = STATE(1081),
    [sym_binary_expression] = STATE(1081),
    [sym_ternary_expression] = STATE(1081),
    [sym_pair_expression] = STATE(1081),
    [sym_tuple_expression] = STATE(870),
    [sym_array_expression] = STATE(870),
    [sym_matrix_expression] = STATE(870),
    [sym_generator_expression] = STATE(1081),
    [sym_array_comprehension_expression] = STATE(870),
    [sym_function_expression] = STATE(1081),
    [sym_range_expression] = STATE(1081),
    [sym_coefficient_expression] = STATE(1081),
    [sym_quote_expression] = STATE(1081),
    [sym_interpolation_expression] = STATE(1081),
    [sym_macro_identifier] = STATE(4),
    [sym__literal] = STATE(894),
    [sym_integer_literal] = STATE(894),
    [sym_character_literal] = STATE(894),
    [sym_string_literal] = STATE(894),
    [sym_command_literal] = STATE(894),
    [sym_prefixed_string_literal] = STATE(894),
    [sym_prefixed_command_literal] = STATE(894),
    [aux_sym_macro_argument_list_repeat1] = STATE(5),
    [sym_identifier] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(123),
    [anon_sym_end] = ACTIONS(125),
    [anon_sym_abstract] = ACTIONS(127),
    [anon_sym_primitive] = ACTIONS(129),
    [aux_sym_primitive_definition_token1] = ACTIONS(131),
    [anon_sym_mutable] = ACTIONS(133),
    [anon_sym_struct] = ACTIONS(135),
    [anon_sym_module] = ACTIONS(137),
    [anon_sym_macro] = ACTIONS(139),
    [anon_sym_LPAREN] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(125),
    [anon_sym_RPAREN] = ACTIONS(125),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_COLON_COLON] = ACTIONS(125),
    [anon_sym_LT_COLON] = ACTIONS(125),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_elseif] = ACTIONS(125),
    [anon_sym_else] = ACTIONS(125),
    [anon_sym_try] = ACTIONS(145),
    [anon_sym_catch] = ACTIONS(125),
    [anon_sym_finally] = ACTIONS(125),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_while] = ACTIONS(149),
    [sym_break_statement] = ACTIONS(151),
    [sym_continue_statement] = ACTIONS(151),
    [anon_sym_return] = ACTIONS(153),
    [anon_sym_let] = ACTIONS(155),
    [anon_sym_const] = ACTIONS(157),
    [anon_sym_quote] = ACTIONS(159),
    [anon_sym_using] = ACTIONS(161),
    [anon_sym_import] = ACTIONS(161),
    [anon_sym_export] = ACTIONS(163),
    [anon_sym_COLON2] = ACTIONS(165),
    [anon_sym_begin] = ACTIONS(167),
    [anon_sym_SQUOTE] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_LT_PIPE] = ACTIONS(125),
    [anon_sym_PIPE_GT] = ACTIONS(125),
    [anon_sym_in] = ACTIONS(125),
    [anon_sym_isa] = ACTIONS(125),
    [anon_sym_PIPE_PIPE] = ACTIONS(125),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_QMARK] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_LBRACK2] = ACTIONS(171),
    [anon_sym_DOLLAR] = ACTIONS(173),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(175),
    [aux_sym_integer_literal_token2] = ACTIONS(175),
    [aux_sym_integer_literal_token3] = ACTIONS(175),
    [sym_float_literal] = ACTIONS(177),
    [sym__unary_operator] = ACTIONS(179),
    [sym__power_operator] = ACTIONS(181),
    [sym__bitshift_operator] = ACTIONS(181),
    [sym__rational_operator] = ACTIONS(181),
    [sym__times_operator] = ACTIONS(181),
    [sym__plus_operator] = ACTIONS(181),
    [sym__dotty_operator] = ACTIONS(181),
    [sym__comparison_operator] = ACTIONS(181),
    [sym__arrow_operator] = ACTIONS(125),
    [sym__assign_operator] = ACTIONS(125),
    [anon_sym_LF] = ACTIONS(183),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(191),
    [sym__string_start] = ACTIONS(187),
    [sym__command_start] = ACTIONS(189),
  },
  [5] = {
    [sym_function_definition] = STATE(1081),
    [sym_abstract_definition] = STATE(1081),
    [sym_primitive_definition] = STATE(1081),
    [sym_struct_definition] = STATE(1081),
    [sym_module_definition] = STATE(1081),
    [sym_macro_definition] = STATE(1081),
    [sym_parameter_list] = STATE(3954),
    [sym_if_statement] = STATE(1081),
    [sym_try_statement] = STATE(1081),
    [sym_for_statement] = STATE(1081),
    [sym_while_statement] = STATE(1081),
    [sym_return_statement] = STATE(1081),
    [sym_let_statement] = STATE(1081),
    [sym_const_statement] = STATE(1081),
    [sym_quote_statement] = STATE(1081),
    [sym_import_statement] = STATE(1081),
    [sym_export_statement] = STATE(1081),
    [sym__expression] = STATE(1068),
    [sym__primary_expression] = STATE(870),
    [sym_operator] = STATE(919),
    [sym_parenthesized_expression] = STATE(870),
    [sym_field_expression] = STATE(818),
    [sym_subscript_expression] = STATE(870),
    [sym_typed_expression] = STATE(1081),
    [sym_parameterized_identifier] = STATE(870),
    [sym_compound_expression] = STATE(1081),
    [sym_call_expression] = STATE(870),
    [sym_broadcast_call_expression] = STATE(870),
    [sym_macro_expression] = STATE(1081),
    [sym_spread_expression] = STATE(1081),
    [sym_unary_expression] = STATE(1081),
    [sym_binary_expression] = STATE(1081),
    [sym_ternary_expression] = STATE(1081),
    [sym_pair_expression] = STATE(1081),
    [sym_tuple_expression] = STATE(870),
    [sym_array_expression] = STATE(870),
    [sym_matrix_expression] = STATE(870),
    [sym_generator_expression] = STATE(1081),
    [sym_array_comprehension_expression] = STATE(870),
    [sym_function_expression] = STATE(1081),
    [sym_range_expression] = STATE(1081),
    [sym_coefficient_expression] = STATE(1081),
    [sym_quote_expression] = STATE(1081),
    [sym_interpolation_expression] = STATE(1081),
    [sym_macro_identifier] = STATE(4),
    [sym__literal] = STATE(894),
    [sym_integer_literal] = STATE(894),
    [sym_character_literal] = STATE(894),
    [sym_string_literal] = STATE(894),
    [sym_command_literal] = STATE(894),
    [sym_prefixed_string_literal] = STATE(894),
    [sym_prefixed_command_literal] = STATE(894),
    [aux_sym_macro_argument_list_repeat1] = STATE(6),
    [sym_identifier] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(123),
    [anon_sym_end] = ACTIONS(193),
    [anon_sym_abstract] = ACTIONS(127),
    [anon_sym_primitive] = ACTIONS(129),
    [aux_sym_primitive_definition_token1] = ACTIONS(131),
    [anon_sym_mutable] = ACTIONS(133),
    [anon_sym_struct] = ACTIONS(135),
    [anon_sym_module] = ACTIONS(137),
    [anon_sym_macro] = ACTIONS(139),
    [anon_sym_LPAREN] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(193),
    [anon_sym_RPAREN] = ACTIONS(193),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym_EQ] = ACTIONS(193),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [anon_sym_LT_COLON] = ACTIONS(193),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_elseif] = ACTIONS(193),
    [anon_sym_else] = ACTIONS(193),
    [anon_sym_try] = ACTIONS(145),
    [anon_sym_catch] = ACTIONS(193),
    [anon_sym_finally] = ACTIONS(193),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_while] = ACTIONS(149),
    [sym_break_statement] = ACTIONS(151),
    [sym_continue_statement] = ACTIONS(151),
    [anon_sym_return] = ACTIONS(153),
    [anon_sym_let] = ACTIONS(155),
    [anon_sym_const] = ACTIONS(157),
    [anon_sym_quote] = ACTIONS(159),
    [anon_sym_using] = ACTIONS(161),
    [anon_sym_import] = ACTIONS(161),
    [anon_sym_export] = ACTIONS(163),
    [anon_sym_COLON2] = ACTIONS(165),
    [anon_sym_begin] = ACTIONS(167),
    [anon_sym_SQUOTE] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_in] = ACTIONS(193),
    [anon_sym_isa] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_QMARK] = ACTIONS(193),
    [anon_sym_EQ_GT] = ACTIONS(193),
    [anon_sym_LBRACK2] = ACTIONS(171),
    [anon_sym_DOLLAR] = ACTIONS(173),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(175),
    [aux_sym_integer_literal_token2] = ACTIONS(175),
    [aux_sym_integer_literal_token3] = ACTIONS(175),
    [sym_float_literal] = ACTIONS(177),
    [sym__unary_operator] = ACTIONS(179),
    [sym__power_operator] = ACTIONS(181),
    [sym__bitshift_operator] = ACTIONS(181),
    [sym__rational_operator] = ACTIONS(181),
    [sym__times_operator] = ACTIONS(181),
    [sym__plus_operator] = ACTIONS(181),
    [sym__dotty_operator] = ACTIONS(181),
    [sym__comparison_operator] = ACTIONS(181),
    [sym__arrow_operator] = ACTIONS(193),
    [sym__assign_operator] = ACTIONS(193),
    [anon_sym_LF] = ACTIONS(195),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(187),
    [sym__command_start] = ACTIONS(189),
  },
  [6] = {
    [sym_function_definition] = STATE(1081),
    [sym_abstract_definition] = STATE(1081),
    [sym_primitive_definition] = STATE(1081),
    [sym_struct_definition] = STATE(1081),
    [sym_module_definition] = STATE(1081),
    [sym_macro_definition] = STATE(1081),
    [sym_parameter_list] = STATE(3954),
    [sym_if_statement] = STATE(1081),
    [sym_try_statement] = STATE(1081),
    [sym_for_statement] = STATE(1081),
    [sym_while_statement] = STATE(1081),
    [sym_return_statement] = STATE(1081),
    [sym_let_statement] = STATE(1081),
    [sym_const_statement] = STATE(1081),
    [sym_quote_statement] = STATE(1081),
    [sym_import_statement] = STATE(1081),
    [sym_export_statement] = STATE(1081),
    [sym__expression] = STATE(1068),
    [sym__primary_expression] = STATE(870),
    [sym_operator] = STATE(919),
    [sym_parenthesized_expression] = STATE(870),
    [sym_field_expression] = STATE(818),
    [sym_subscript_expression] = STATE(870),
    [sym_typed_expression] = STATE(1081),
    [sym_parameterized_identifier] = STATE(870),
    [sym_compound_expression] = STATE(1081),
    [sym_call_expression] = STATE(870),
    [sym_broadcast_call_expression] = STATE(870),
    [sym_macro_expression] = STATE(1081),
    [sym_spread_expression] = STATE(1081),
    [sym_unary_expression] = STATE(1081),
    [sym_binary_expression] = STATE(1081),
    [sym_ternary_expression] = STATE(1081),
    [sym_pair_expression] = STATE(1081),
    [sym_tuple_expression] = STATE(870),
    [sym_array_expression] = STATE(870),
    [sym_matrix_expression] = STATE(870),
    [sym_generator_expression] = STATE(1081),
    [sym_array_comprehension_expression] = STATE(870),
    [sym_function_expression] = STATE(1081),
    [sym_range_expression] = STATE(1081),
    [sym_coefficient_expression] = STATE(1081),
    [sym_quote_expression] = STATE(1081),
    [sym_interpolation_expression] = STATE(1081),
    [sym_macro_identifier] = STATE(4),
    [sym__literal] = STATE(894),
    [sym_integer_literal] = STATE(894),
    [sym_character_literal] = STATE(894),
    [sym_string_literal] = STATE(894),
    [sym_command_literal] = STATE(894),
    [sym_prefixed_string_literal] = STATE(894),
    [sym_prefixed_command_literal] = STATE(894),
    [aux_sym_macro_argument_list_repeat1] = STATE(6),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_function] = ACTIONS(200),
    [anon_sym_end] = ACTIONS(203),
    [anon_sym_abstract] = ACTIONS(205),
    [anon_sym_primitive] = ACTIONS(208),
    [aux_sym_primitive_definition_token1] = ACTIONS(211),
    [anon_sym_mutable] = ACTIONS(214),
    [anon_sym_struct] = ACTIONS(217),
    [anon_sym_module] = ACTIONS(220),
    [anon_sym_macro] = ACTIONS(223),
    [anon_sym_LPAREN] = ACTIONS(226),
    [anon_sym_COMMA] = ACTIONS(203),
    [anon_sym_RPAREN] = ACTIONS(203),
    [anon_sym_SEMI] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_COLON_COLON] = ACTIONS(203),
    [anon_sym_LT_COLON] = ACTIONS(203),
    [anon_sym_if] = ACTIONS(229),
    [anon_sym_elseif] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(203),
    [anon_sym_try] = ACTIONS(232),
    [anon_sym_catch] = ACTIONS(203),
    [anon_sym_finally] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(238),
    [sym_break_statement] = ACTIONS(241),
    [sym_continue_statement] = ACTIONS(241),
    [anon_sym_return] = ACTIONS(244),
    [anon_sym_let] = ACTIONS(247),
    [anon_sym_const] = ACTIONS(250),
    [anon_sym_quote] = ACTIONS(253),
    [anon_sym_using] = ACTIONS(256),
    [anon_sym_import] = ACTIONS(256),
    [anon_sym_export] = ACTIONS(259),
    [anon_sym_COLON2] = ACTIONS(262),
    [anon_sym_begin] = ACTIONS(265),
    [anon_sym_SQUOTE] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(203),
    [anon_sym_LT_PIPE] = ACTIONS(203),
    [anon_sym_PIPE_GT] = ACTIONS(203),
    [anon_sym_in] = ACTIONS(203),
    [anon_sym_isa] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(203),
    [anon_sym_EQ_GT] = ACTIONS(203),
    [anon_sym_LBRACK2] = ACTIONS(271),
    [anon_sym_DOLLAR] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(277),
    [aux_sym_integer_literal_token1] = ACTIONS(280),
    [aux_sym_integer_literal_token2] = ACTIONS(280),
    [aux_sym_integer_literal_token3] = ACTIONS(280),
    [sym_float_literal] = ACTIONS(283),
    [sym__unary_operator] = ACTIONS(286),
    [sym__power_operator] = ACTIONS(289),
    [sym__bitshift_operator] = ACTIONS(289),
    [sym__rational_operator] = ACTIONS(289),
    [sym__times_operator] = ACTIONS(289),
    [sym__plus_operator] = ACTIONS(289),
    [sym__dotty_operator] = ACTIONS(289),
    [sym__comparison_operator] = ACTIONS(289),
    [sym__arrow_operator] = ACTIONS(203),
    [sym__assign_operator] = ACTIONS(203),
    [anon_sym_LF] = ACTIONS(292),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(294),
    [sym__command_start] = ACTIONS(297),
  },
  [7] = {
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2098),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2143),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(300),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_COMMA] = ACTIONS(300),
    [anon_sym_RPAREN] = ACTIONS(300),
    [anon_sym_SEMI] = ACTIONS(300),
    [anon_sym_EQ] = ACTIONS(300),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(300),
    [anon_sym_COLON_COLON] = ACTIONS(300),
    [anon_sym_LT_COLON] = ACTIONS(300),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_elseif] = ACTIONS(300),
    [anon_sym_else] = ACTIONS(300),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_catch] = ACTIONS(300),
    [anon_sym_finally] = ACTIONS(300),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(95),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_PLUS] = ACTIONS(300),
    [anon_sym_LT_PIPE] = ACTIONS(300),
    [anon_sym_PIPE_GT] = ACTIONS(300),
    [anon_sym_in] = ACTIONS(300),
    [anon_sym_isa] = ACTIONS(300),
    [anon_sym_PIPE_PIPE] = ACTIONS(300),
    [anon_sym_AMP_AMP] = ACTIONS(300),
    [anon_sym_QMARK] = ACTIONS(300),
    [anon_sym_EQ_GT] = ACTIONS(300),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(71),
    [sym__bitshift_operator] = ACTIONS(71),
    [sym__rational_operator] = ACTIONS(71),
    [sym__times_operator] = ACTIONS(71),
    [sym__plus_operator] = ACTIONS(71),
    [sym__dotty_operator] = ACTIONS(71),
    [sym__comparison_operator] = ACTIONS(71),
    [sym__arrow_operator] = ACTIONS(300),
    [sym__assign_operator] = ACTIONS(300),
    [anon_sym_LF] = ACTIONS(302),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [8] = {
    [sym_function_definition] = STATE(1081),
    [sym_abstract_definition] = STATE(1081),
    [sym_primitive_definition] = STATE(1081),
    [sym_struct_definition] = STATE(1081),
    [sym_module_definition] = STATE(1081),
    [sym_macro_definition] = STATE(1081),
    [sym_parameter_list] = STATE(3954),
    [sym_if_statement] = STATE(1081),
    [sym_try_statement] = STATE(1081),
    [sym_for_statement] = STATE(1081),
    [sym_while_statement] = STATE(1081),
    [sym_return_statement] = STATE(1081),
    [sym_let_statement] = STATE(1081),
    [sym_const_statement] = STATE(1081),
    [sym_quote_statement] = STATE(1081),
    [sym_import_statement] = STATE(1081),
    [sym_export_statement] = STATE(1081),
    [sym__expression] = STATE(938),
    [sym__primary_expression] = STATE(870),
    [sym_bare_tuple_expression] = STATE(1067),
    [sym_operator] = STATE(919),
    [sym_parenthesized_expression] = STATE(870),
    [sym_field_expression] = STATE(818),
    [sym_subscript_expression] = STATE(870),
    [sym_typed_expression] = STATE(1081),
    [sym_parameterized_identifier] = STATE(870),
    [sym_compound_expression] = STATE(1081),
    [sym_call_expression] = STATE(870),
    [sym_broadcast_call_expression] = STATE(870),
    [sym_macro_expression] = STATE(1081),
    [sym_spread_expression] = STATE(1081),
    [sym_unary_expression] = STATE(1081),
    [sym_binary_expression] = STATE(1081),
    [sym_ternary_expression] = STATE(1081),
    [sym_pair_expression] = STATE(1081),
    [sym_tuple_expression] = STATE(870),
    [sym_array_expression] = STATE(870),
    [sym_matrix_expression] = STATE(870),
    [sym_generator_expression] = STATE(1081),
    [sym_array_comprehension_expression] = STATE(870),
    [sym_function_expression] = STATE(1081),
    [sym_range_expression] = STATE(1081),
    [sym_coefficient_expression] = STATE(1081),
    [sym_quote_expression] = STATE(1081),
    [sym_interpolation_expression] = STATE(1081),
    [sym_macro_identifier] = STATE(4),
    [sym__literal] = STATE(894),
    [sym_integer_literal] = STATE(894),
    [sym_character_literal] = STATE(894),
    [sym_string_literal] = STATE(894),
    [sym_command_literal] = STATE(894),
    [sym_prefixed_string_literal] = STATE(894),
    [sym_prefixed_command_literal] = STATE(894),
    [sym_identifier] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(123),
    [anon_sym_end] = ACTIONS(300),
    [anon_sym_abstract] = ACTIONS(127),
    [anon_sym_primitive] = ACTIONS(129),
    [aux_sym_primitive_definition_token1] = ACTIONS(131),
    [anon_sym_mutable] = ACTIONS(133),
    [anon_sym_struct] = ACTIONS(135),
    [anon_sym_module] = ACTIONS(137),
    [anon_sym_macro] = ACTIONS(139),
    [anon_sym_LPAREN] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(300),
    [anon_sym_RPAREN] = ACTIONS(300),
    [anon_sym_SEMI] = ACTIONS(300),
    [anon_sym_EQ] = ACTIONS(300),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(300),
    [anon_sym_COLON_COLON] = ACTIONS(300),
    [anon_sym_LT_COLON] = ACTIONS(300),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_elseif] = ACTIONS(300),
    [anon_sym_else] = ACTIONS(300),
    [anon_sym_try] = ACTIONS(145),
    [anon_sym_catch] = ACTIONS(300),
    [anon_sym_finally] = ACTIONS(300),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_while] = ACTIONS(149),
    [sym_break_statement] = ACTIONS(151),
    [sym_continue_statement] = ACTIONS(151),
    [anon_sym_return] = ACTIONS(153),
    [anon_sym_let] = ACTIONS(155),
    [anon_sym_const] = ACTIONS(157),
    [anon_sym_quote] = ACTIONS(159),
    [anon_sym_using] = ACTIONS(161),
    [anon_sym_import] = ACTIONS(161),
    [anon_sym_export] = ACTIONS(163),
    [anon_sym_COLON2] = ACTIONS(165),
    [anon_sym_begin] = ACTIONS(167),
    [anon_sym_SQUOTE] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(300),
    [anon_sym_LT_PIPE] = ACTIONS(300),
    [anon_sym_PIPE_GT] = ACTIONS(300),
    [anon_sym_in] = ACTIONS(300),
    [anon_sym_isa] = ACTIONS(300),
    [anon_sym_PIPE_PIPE] = ACTIONS(300),
    [anon_sym_AMP_AMP] = ACTIONS(300),
    [anon_sym_QMARK] = ACTIONS(300),
    [anon_sym_EQ_GT] = ACTIONS(300),
    [anon_sym_LBRACK2] = ACTIONS(171),
    [anon_sym_DOLLAR] = ACTIONS(173),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(175),
    [aux_sym_integer_literal_token2] = ACTIONS(175),
    [aux_sym_integer_literal_token3] = ACTIONS(175),
    [sym_float_literal] = ACTIONS(177),
    [sym__unary_operator] = ACTIONS(179),
    [sym__power_operator] = ACTIONS(181),
    [sym__bitshift_operator] = ACTIONS(181),
    [sym__rational_operator] = ACTIONS(181),
    [sym__times_operator] = ACTIONS(181),
    [sym__plus_operator] = ACTIONS(181),
    [sym__dotty_operator] = ACTIONS(181),
    [sym__comparison_operator] = ACTIONS(181),
    [sym__arrow_operator] = ACTIONS(300),
    [sym__assign_operator] = ACTIONS(300),
    [anon_sym_LF] = ACTIONS(302),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(187),
    [sym__command_start] = ACTIONS(189),
  },
  [9] = {
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2149),
    [sym__primary_expression] = STATE(1995),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_RPAREN] = ACTIONS(304),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LT_COLON] = ACTIONS(304),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_elseif] = ACTIONS(304),
    [anon_sym_else] = ACTIONS(304),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_catch] = ACTIONS(304),
    [anon_sym_finally] = ACTIONS(304),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(95),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(304),
    [anon_sym_PIPE_GT] = ACTIONS(304),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_EQ_GT] = ACTIONS(304),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(71),
    [sym__bitshift_operator] = ACTIONS(71),
    [sym__rational_operator] = ACTIONS(71),
    [sym__times_operator] = ACTIONS(71),
    [sym__plus_operator] = ACTIONS(71),
    [sym__dotty_operator] = ACTIONS(71),
    [sym__comparison_operator] = ACTIONS(71),
    [sym__arrow_operator] = ACTIONS(304),
    [sym__assign_operator] = ACTIONS(304),
    [anon_sym_LF] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [10] = {
    [sym_function_definition] = STATE(1081),
    [sym_abstract_definition] = STATE(1081),
    [sym_primitive_definition] = STATE(1081),
    [sym_struct_definition] = STATE(1081),
    [sym_module_definition] = STATE(1081),
    [sym_macro_definition] = STATE(1081),
    [sym_parameter_list] = STATE(3954),
    [sym_if_statement] = STATE(1081),
    [sym_try_statement] = STATE(1081),
    [sym_for_statement] = STATE(1081),
    [sym_while_statement] = STATE(1081),
    [sym_return_statement] = STATE(1081),
    [sym_let_statement] = STATE(1081),
    [sym_const_statement] = STATE(1081),
    [sym_quote_statement] = STATE(1081),
    [sym_import_statement] = STATE(1081),
    [sym_export_statement] = STATE(1081),
    [sym__expression] = STATE(1032),
    [sym__primary_expression] = STATE(870),
    [sym_operator] = STATE(919),
    [sym_parenthesized_expression] = STATE(870),
    [sym_field_expression] = STATE(818),
    [sym_subscript_expression] = STATE(870),
    [sym_typed_expression] = STATE(1081),
    [sym_parameterized_identifier] = STATE(870),
    [sym_compound_expression] = STATE(1081),
    [sym_call_expression] = STATE(870),
    [sym_broadcast_call_expression] = STATE(870),
    [sym_macro_expression] = STATE(1081),
    [sym_spread_expression] = STATE(1081),
    [sym_unary_expression] = STATE(1081),
    [sym_binary_expression] = STATE(1081),
    [sym_ternary_expression] = STATE(1081),
    [sym_pair_expression] = STATE(1081),
    [sym_tuple_expression] = STATE(870),
    [sym_array_expression] = STATE(870),
    [sym_matrix_expression] = STATE(870),
    [sym_generator_expression] = STATE(1081),
    [sym_array_comprehension_expression] = STATE(870),
    [sym_function_expression] = STATE(1081),
    [sym_range_expression] = STATE(1081),
    [sym_coefficient_expression] = STATE(1081),
    [sym_quote_expression] = STATE(1081),
    [sym_interpolation_expression] = STATE(1081),
    [sym_macro_identifier] = STATE(4),
    [sym__literal] = STATE(894),
    [sym_integer_literal] = STATE(894),
    [sym_character_literal] = STATE(894),
    [sym_string_literal] = STATE(894),
    [sym_command_literal] = STATE(894),
    [sym_prefixed_string_literal] = STATE(894),
    [sym_prefixed_command_literal] = STATE(894),
    [sym_identifier] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(123),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(127),
    [anon_sym_primitive] = ACTIONS(129),
    [aux_sym_primitive_definition_token1] = ACTIONS(131),
    [anon_sym_mutable] = ACTIONS(133),
    [anon_sym_struct] = ACTIONS(135),
    [anon_sym_module] = ACTIONS(137),
    [anon_sym_macro] = ACTIONS(139),
    [anon_sym_LPAREN] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_RPAREN] = ACTIONS(304),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LT_COLON] = ACTIONS(304),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_elseif] = ACTIONS(304),
    [anon_sym_else] = ACTIONS(304),
    [anon_sym_try] = ACTIONS(145),
    [anon_sym_catch] = ACTIONS(304),
    [anon_sym_finally] = ACTIONS(304),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_while] = ACTIONS(149),
    [sym_break_statement] = ACTIONS(151),
    [sym_continue_statement] = ACTIONS(151),
    [anon_sym_return] = ACTIONS(153),
    [anon_sym_let] = ACTIONS(155),
    [anon_sym_const] = ACTIONS(157),
    [anon_sym_quote] = ACTIONS(159),
    [anon_sym_using] = ACTIONS(161),
    [anon_sym_import] = ACTIONS(161),
    [anon_sym_export] = ACTIONS(163),
    [anon_sym_COLON2] = ACTIONS(165),
    [anon_sym_begin] = ACTIONS(167),
    [anon_sym_SQUOTE] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(304),
    [anon_sym_PIPE_GT] = ACTIONS(304),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_EQ_GT] = ACTIONS(304),
    [anon_sym_LBRACK2] = ACTIONS(171),
    [anon_sym_DOLLAR] = ACTIONS(173),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(175),
    [aux_sym_integer_literal_token2] = ACTIONS(175),
    [aux_sym_integer_literal_token3] = ACTIONS(175),
    [sym_float_literal] = ACTIONS(177),
    [sym__unary_operator] = ACTIONS(179),
    [sym__power_operator] = ACTIONS(181),
    [sym__bitshift_operator] = ACTIONS(181),
    [sym__rational_operator] = ACTIONS(181),
    [sym__times_operator] = ACTIONS(181),
    [sym__plus_operator] = ACTIONS(181),
    [sym__dotty_operator] = ACTIONS(181),
    [sym__comparison_operator] = ACTIONS(181),
    [sym__arrow_operator] = ACTIONS(304),
    [sym__assign_operator] = ACTIONS(304),
    [anon_sym_LF] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(187),
    [sym__command_start] = ACTIONS(189),
  },
  [11] = {
    [sym__expression_list] = STATE(2816),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_elseif_clause] = STATE(2818),
    [sym_else_clause] = STATE(3931),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [aux_sym_if_statement_repeat1] = STATE(2818),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(308),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(310),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_elseif] = ACTIONS(316),
    [anon_sym_else] = ACTIONS(318),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(356),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [12] = {
    [sym_function_definition] = STATE(1415),
    [sym_abstract_definition] = STATE(1415),
    [sym_primitive_definition] = STATE(1415),
    [sym_struct_definition] = STATE(1415),
    [sym_module_definition] = STATE(1415),
    [sym_macro_definition] = STATE(1415),
    [sym_parameter_list] = STATE(3775),
    [sym_if_statement] = STATE(1415),
    [sym_try_statement] = STATE(1415),
    [sym_for_statement] = STATE(1415),
    [sym_while_statement] = STATE(1415),
    [sym_return_statement] = STATE(1415),
    [sym_let_statement] = STATE(1415),
    [sym_const_statement] = STATE(1415),
    [sym_quote_statement] = STATE(1415),
    [sym_import_statement] = STATE(1415),
    [sym_export_statement] = STATE(1415),
    [sym__expression] = STATE(1337),
    [sym__primary_expression] = STATE(1095),
    [sym_operator] = STATE(1224),
    [sym_parenthesized_expression] = STATE(1095),
    [sym_field_expression] = STATE(883),
    [sym_subscript_expression] = STATE(1095),
    [sym_typed_expression] = STATE(1415),
    [sym_parameterized_identifier] = STATE(1095),
    [sym_compound_expression] = STATE(1415),
    [sym_call_expression] = STATE(1095),
    [sym_broadcast_call_expression] = STATE(1095),
    [sym_macro_expression] = STATE(1415),
    [sym_macro_argument_list] = STATE(1349),
    [sym_spread_expression] = STATE(1415),
    [sym_unary_expression] = STATE(1415),
    [sym_binary_expression] = STATE(1415),
    [sym_ternary_expression] = STATE(1415),
    [sym_pair_expression] = STATE(1415),
    [sym_tuple_expression] = STATE(1095),
    [sym_array_expression] = STATE(1095),
    [sym_matrix_expression] = STATE(1095),
    [sym_generator_expression] = STATE(1415),
    [sym_array_comprehension_expression] = STATE(1095),
    [sym_function_expression] = STATE(1415),
    [sym_range_expression] = STATE(1415),
    [sym_coefficient_expression] = STATE(1415),
    [sym_quote_expression] = STATE(1415),
    [sym_interpolation_expression] = STATE(1415),
    [sym_macro_identifier] = STATE(12),
    [sym__literal] = STATE(1225),
    [sym_integer_literal] = STATE(1225),
    [sym_character_literal] = STATE(1225),
    [sym_string_literal] = STATE(1225),
    [sym_command_literal] = STATE(1225),
    [sym_prefixed_string_literal] = STATE(1225),
    [sym_prefixed_command_literal] = STATE(1225),
    [aux_sym_macro_argument_list_repeat1] = STATE(31),
    [sym_identifier] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_end] = ACTIONS(125),
    [anon_sym_abstract] = ACTIONS(362),
    [anon_sym_primitive] = ACTIONS(364),
    [aux_sym_primitive_definition_token1] = ACTIONS(366),
    [anon_sym_mutable] = ACTIONS(368),
    [anon_sym_struct] = ACTIONS(370),
    [anon_sym_module] = ACTIONS(372),
    [anon_sym_macro] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(376),
    [anon_sym_COMMA] = ACTIONS(183),
    [anon_sym_RPAREN] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(183),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(183),
    [anon_sym_RBRACE] = ACTIONS(183),
    [anon_sym_LT_COLON] = ACTIONS(183),
    [anon_sym_if] = ACTIONS(378),
    [anon_sym_try] = ACTIONS(380),
    [anon_sym_for] = ACTIONS(382),
    [anon_sym_while] = ACTIONS(384),
    [sym_break_statement] = ACTIONS(386),
    [sym_continue_statement] = ACTIONS(386),
    [anon_sym_return] = ACTIONS(388),
    [anon_sym_let] = ACTIONS(390),
    [anon_sym_const] = ACTIONS(392),
    [anon_sym_quote] = ACTIONS(394),
    [anon_sym_using] = ACTIONS(396),
    [anon_sym_import] = ACTIONS(396),
    [anon_sym_export] = ACTIONS(398),
    [anon_sym_COLON2] = ACTIONS(400),
    [anon_sym_RBRACK] = ACTIONS(183),
    [anon_sym_begin] = ACTIONS(402),
    [anon_sym_SQUOTE] = ACTIONS(404),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_LT_PIPE] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_in] = ACTIONS(125),
    [anon_sym_isa] = ACTIONS(125),
    [anon_sym_PIPE_PIPE] = ACTIONS(183),
    [anon_sym_AMP_AMP] = ACTIONS(183),
    [anon_sym_QMARK] = ACTIONS(183),
    [anon_sym_EQ_GT] = ACTIONS(183),
    [anon_sym_LBRACK2] = ACTIONS(406),
    [anon_sym_DOLLAR] = ACTIONS(408),
    [anon_sym_AT] = ACTIONS(410),
    [aux_sym_integer_literal_token1] = ACTIONS(412),
    [aux_sym_integer_literal_token2] = ACTIONS(412),
    [aux_sym_integer_literal_token3] = ACTIONS(414),
    [sym_float_literal] = ACTIONS(416),
    [sym__unary_operator] = ACTIONS(418),
    [sym__power_operator] = ACTIONS(420),
    [sym__bitshift_operator] = ACTIONS(420),
    [sym__rational_operator] = ACTIONS(420),
    [sym__times_operator] = ACTIONS(420),
    [sym__plus_operator] = ACTIONS(420),
    [sym__dotty_operator] = ACTIONS(420),
    [sym__comparison_operator] = ACTIONS(420),
    [sym__arrow_operator] = ACTIONS(183),
    [sym__assign_operator] = ACTIONS(125),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(422),
    [sym__string_start] = ACTIONS(424),
    [sym__command_start] = ACTIONS(426),
  },
  [13] = {
    [sym__expression_list] = STATE(2809),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_elseif_clause] = STATE(2810),
    [sym_else_clause] = STATE(4005),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [aux_sym_if_statement_repeat1] = STATE(2810),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(428),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(430),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_elseif] = ACTIONS(316),
    [anon_sym_else] = ACTIONS(318),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(432),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [14] = {
    [sym__expression_list] = STATE(2826),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_elseif_clause] = STATE(2825),
    [sym_else_clause] = STATE(3866),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [aux_sym_if_statement_repeat1] = STATE(2825),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(434),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(436),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_elseif] = ACTIONS(316),
    [anon_sym_else] = ACTIONS(318),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(438),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [15] = {
    [sym__expression_list] = STATE(2812),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_elseif_clause] = STATE(2823),
    [sym_else_clause] = STATE(3999),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [aux_sym_if_statement_repeat1] = STATE(2823),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(440),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(442),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_elseif] = ACTIONS(316),
    [anon_sym_else] = ACTIONS(318),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(444),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [16] = {
    [sym__expression_list] = STATE(2843),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_elseif_clause] = STATE(2839),
    [sym_else_clause] = STATE(4222),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [aux_sym_if_statement_repeat1] = STATE(2839),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(446),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(448),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_elseif] = ACTIONS(316),
    [anon_sym_else] = ACTIONS(318),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(450),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [17] = {
    [sym__expression_list] = STATE(2794),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_elseif_clause] = STATE(2795),
    [sym_else_clause] = STATE(4147),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [aux_sym_if_statement_repeat1] = STATE(2795),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(452),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(454),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_elseif] = ACTIONS(316),
    [anon_sym_else] = ACTIONS(318),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(456),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [18] = {
    [sym_function_definition] = STATE(1415),
    [sym_abstract_definition] = STATE(1415),
    [sym_primitive_definition] = STATE(1415),
    [sym_struct_definition] = STATE(1415),
    [sym_module_definition] = STATE(1415),
    [sym_macro_definition] = STATE(1415),
    [sym_parameter_list] = STATE(3775),
    [sym_if_statement] = STATE(1415),
    [sym_try_statement] = STATE(1415),
    [sym_for_statement] = STATE(1415),
    [sym_while_statement] = STATE(1415),
    [sym_return_statement] = STATE(1415),
    [sym_let_statement] = STATE(1415),
    [sym_const_statement] = STATE(1415),
    [sym_quote_statement] = STATE(1415),
    [sym_import_statement] = STATE(1415),
    [sym_export_statement] = STATE(1415),
    [sym__expression] = STATE(1337),
    [sym__primary_expression] = STATE(1095),
    [sym_operator] = STATE(1224),
    [sym_parenthesized_expression] = STATE(1095),
    [sym_field_expression] = STATE(883),
    [sym_subscript_expression] = STATE(1095),
    [sym_typed_expression] = STATE(1415),
    [sym_parameterized_identifier] = STATE(1095),
    [sym_compound_expression] = STATE(1415),
    [sym_call_expression] = STATE(1095),
    [sym_broadcast_call_expression] = STATE(1095),
    [sym_macro_expression] = STATE(1415),
    [sym_macro_argument_list] = STATE(2373),
    [sym_spread_expression] = STATE(1415),
    [sym_unary_expression] = STATE(1415),
    [sym_binary_expression] = STATE(1415),
    [sym_ternary_expression] = STATE(1415),
    [sym_pair_expression] = STATE(1415),
    [sym_tuple_expression] = STATE(1095),
    [sym_array_expression] = STATE(1095),
    [sym_matrix_expression] = STATE(1095),
    [sym_generator_expression] = STATE(1415),
    [sym_array_comprehension_expression] = STATE(1095),
    [sym_function_expression] = STATE(1415),
    [sym_range_expression] = STATE(1415),
    [sym_coefficient_expression] = STATE(1415),
    [sym_quote_expression] = STATE(1415),
    [sym_interpolation_expression] = STATE(1415),
    [sym_macro_identifier] = STATE(12),
    [sym__literal] = STATE(1225),
    [sym_integer_literal] = STATE(1225),
    [sym_character_literal] = STATE(1225),
    [sym_string_literal] = STATE(1225),
    [sym_command_literal] = STATE(1225),
    [sym_prefixed_string_literal] = STATE(1225),
    [sym_prefixed_command_literal] = STATE(1225),
    [aux_sym_macro_argument_list_repeat1] = STATE(31),
    [sym_identifier] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_end] = ACTIONS(125),
    [anon_sym_abstract] = ACTIONS(362),
    [anon_sym_primitive] = ACTIONS(364),
    [aux_sym_primitive_definition_token1] = ACTIONS(366),
    [anon_sym_mutable] = ACTIONS(368),
    [anon_sym_struct] = ACTIONS(370),
    [anon_sym_module] = ACTIONS(372),
    [anon_sym_macro] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(376),
    [anon_sym_COMMA] = ACTIONS(183),
    [anon_sym_RPAREN] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(183),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(183),
    [anon_sym_RBRACE] = ACTIONS(183),
    [anon_sym_LT_COLON] = ACTIONS(183),
    [anon_sym_if] = ACTIONS(378),
    [anon_sym_try] = ACTIONS(380),
    [anon_sym_for] = ACTIONS(382),
    [anon_sym_while] = ACTIONS(384),
    [sym_break_statement] = ACTIONS(386),
    [sym_continue_statement] = ACTIONS(386),
    [anon_sym_return] = ACTIONS(388),
    [anon_sym_let] = ACTIONS(390),
    [anon_sym_const] = ACTIONS(392),
    [anon_sym_quote] = ACTIONS(394),
    [anon_sym_using] = ACTIONS(396),
    [anon_sym_import] = ACTIONS(396),
    [anon_sym_export] = ACTIONS(398),
    [anon_sym_COLON2] = ACTIONS(400),
    [anon_sym_RBRACK] = ACTIONS(183),
    [anon_sym_begin] = ACTIONS(402),
    [anon_sym_SQUOTE] = ACTIONS(404),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_LT_PIPE] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_in] = ACTIONS(125),
    [anon_sym_isa] = ACTIONS(125),
    [anon_sym_PIPE_PIPE] = ACTIONS(183),
    [anon_sym_AMP_AMP] = ACTIONS(183),
    [anon_sym_QMARK] = ACTIONS(183),
    [anon_sym_EQ_GT] = ACTIONS(183),
    [anon_sym_LBRACK2] = ACTIONS(406),
    [anon_sym_DOLLAR] = ACTIONS(408),
    [anon_sym_AT] = ACTIONS(410),
    [aux_sym_integer_literal_token1] = ACTIONS(412),
    [aux_sym_integer_literal_token2] = ACTIONS(412),
    [aux_sym_integer_literal_token3] = ACTIONS(414),
    [sym_float_literal] = ACTIONS(416),
    [sym__unary_operator] = ACTIONS(418),
    [sym__power_operator] = ACTIONS(420),
    [sym__bitshift_operator] = ACTIONS(420),
    [sym__rational_operator] = ACTIONS(420),
    [sym__times_operator] = ACTIONS(420),
    [sym__plus_operator] = ACTIONS(420),
    [sym__dotty_operator] = ACTIONS(420),
    [sym__comparison_operator] = ACTIONS(420),
    [sym__arrow_operator] = ACTIONS(183),
    [sym__assign_operator] = ACTIONS(125),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(458),
    [sym__string_start] = ACTIONS(424),
    [sym__command_start] = ACTIONS(426),
  },
  [19] = {
    [sym__expression_list] = STATE(2797),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_elseif_clause] = STATE(2798),
    [sym_else_clause] = STATE(4282),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [aux_sym_if_statement_repeat1] = STATE(2798),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(460),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(462),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_elseif] = ACTIONS(316),
    [anon_sym_else] = ACTIONS(318),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(464),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [20] = {
    [sym_function_definition] = STATE(1081),
    [sym_abstract_definition] = STATE(1081),
    [sym_primitive_definition] = STATE(1081),
    [sym_struct_definition] = STATE(1081),
    [sym_module_definition] = STATE(1081),
    [sym_macro_definition] = STATE(1081),
    [sym_parameter_list] = STATE(3954),
    [sym_if_statement] = STATE(1081),
    [sym_try_statement] = STATE(1081),
    [sym_for_statement] = STATE(1081),
    [sym_while_statement] = STATE(1081),
    [sym_return_statement] = STATE(1081),
    [sym_let_statement] = STATE(1081),
    [sym_const_statement] = STATE(1081),
    [sym_quote_statement] = STATE(1081),
    [sym_import_statement] = STATE(1081),
    [sym_export_statement] = STATE(1081),
    [sym__expression] = STATE(1052),
    [sym__primary_expression] = STATE(870),
    [sym_operator] = STATE(919),
    [sym_parenthesized_expression] = STATE(870),
    [sym_field_expression] = STATE(818),
    [sym_subscript_expression] = STATE(870),
    [sym_typed_expression] = STATE(1081),
    [sym_parameterized_identifier] = STATE(870),
    [sym_compound_expression] = STATE(1081),
    [sym_call_expression] = STATE(870),
    [sym_broadcast_call_expression] = STATE(870),
    [sym_macro_expression] = STATE(1081),
    [sym_spread_expression] = STATE(1081),
    [sym_unary_expression] = STATE(1081),
    [sym_binary_expression] = STATE(1081),
    [sym_ternary_expression] = STATE(1081),
    [sym_pair_expression] = STATE(1081),
    [sym_tuple_expression] = STATE(870),
    [sym_array_expression] = STATE(870),
    [sym_matrix_expression] = STATE(870),
    [sym_generator_expression] = STATE(1081),
    [sym_array_comprehension_expression] = STATE(870),
    [sym_function_expression] = STATE(1081),
    [sym_range_expression] = STATE(1081),
    [sym_coefficient_expression] = STATE(1081),
    [sym_quote_expression] = STATE(1081),
    [sym_interpolation_expression] = STATE(1081),
    [sym_macro_identifier] = STATE(4),
    [sym__literal] = STATE(894),
    [sym_integer_literal] = STATE(894),
    [sym_character_literal] = STATE(894),
    [sym_string_literal] = STATE(894),
    [sym_command_literal] = STATE(894),
    [sym_prefixed_string_literal] = STATE(894),
    [sym_prefixed_command_literal] = STATE(894),
    [sym_identifier] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(123),
    [anon_sym_end] = ACTIONS(466),
    [anon_sym_abstract] = ACTIONS(127),
    [anon_sym_primitive] = ACTIONS(129),
    [aux_sym_primitive_definition_token1] = ACTIONS(131),
    [anon_sym_mutable] = ACTIONS(133),
    [anon_sym_struct] = ACTIONS(135),
    [anon_sym_module] = ACTIONS(137),
    [anon_sym_macro] = ACTIONS(139),
    [anon_sym_LPAREN] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(466),
    [anon_sym_RPAREN] = ACTIONS(466),
    [anon_sym_SEMI] = ACTIONS(466),
    [anon_sym_EQ] = ACTIONS(466),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(466),
    [anon_sym_COLON_COLON] = ACTIONS(466),
    [anon_sym_LT_COLON] = ACTIONS(466),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_elseif] = ACTIONS(466),
    [anon_sym_else] = ACTIONS(466),
    [anon_sym_try] = ACTIONS(145),
    [anon_sym_catch] = ACTIONS(466),
    [anon_sym_finally] = ACTIONS(466),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_while] = ACTIONS(149),
    [sym_break_statement] = ACTIONS(151),
    [sym_continue_statement] = ACTIONS(151),
    [anon_sym_return] = ACTIONS(153),
    [anon_sym_let] = ACTIONS(155),
    [anon_sym_const] = ACTIONS(157),
    [anon_sym_quote] = ACTIONS(159),
    [anon_sym_using] = ACTIONS(161),
    [anon_sym_import] = ACTIONS(161),
    [anon_sym_export] = ACTIONS(163),
    [anon_sym_COLON2] = ACTIONS(165),
    [anon_sym_begin] = ACTIONS(167),
    [anon_sym_SQUOTE] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_LT_PIPE] = ACTIONS(466),
    [anon_sym_PIPE_GT] = ACTIONS(466),
    [anon_sym_in] = ACTIONS(466),
    [anon_sym_isa] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(466),
    [anon_sym_AMP_AMP] = ACTIONS(466),
    [anon_sym_QMARK] = ACTIONS(466),
    [anon_sym_EQ_GT] = ACTIONS(466),
    [anon_sym_LBRACK2] = ACTIONS(171),
    [anon_sym_DOLLAR] = ACTIONS(173),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(175),
    [aux_sym_integer_literal_token2] = ACTIONS(175),
    [aux_sym_integer_literal_token3] = ACTIONS(175),
    [sym_float_literal] = ACTIONS(177),
    [sym__unary_operator] = ACTIONS(179),
    [sym__power_operator] = ACTIONS(181),
    [sym__bitshift_operator] = ACTIONS(181),
    [sym__rational_operator] = ACTIONS(181),
    [sym__times_operator] = ACTIONS(181),
    [sym__plus_operator] = ACTIONS(181),
    [sym__dotty_operator] = ACTIONS(181),
    [sym__comparison_operator] = ACTIONS(181),
    [sym__arrow_operator] = ACTIONS(466),
    [sym__assign_operator] = ACTIONS(466),
    [anon_sym_LF] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(187),
    [sym__command_start] = ACTIONS(189),
  },
  [21] = {
    [sym__expression_list] = STATE(2819),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_elseif_clause] = STATE(2817),
    [sym_else_clause] = STATE(4071),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [aux_sym_if_statement_repeat1] = STATE(2817),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(470),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(472),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_elseif] = ACTIONS(316),
    [anon_sym_else] = ACTIONS(318),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(474),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [22] = {
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2261),
    [sym__primary_expression] = STATE(1995),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(466),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_COMMA] = ACTIONS(466),
    [anon_sym_RPAREN] = ACTIONS(466),
    [anon_sym_SEMI] = ACTIONS(466),
    [anon_sym_EQ] = ACTIONS(466),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(466),
    [anon_sym_COLON_COLON] = ACTIONS(466),
    [anon_sym_LT_COLON] = ACTIONS(466),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_elseif] = ACTIONS(466),
    [anon_sym_else] = ACTIONS(466),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_catch] = ACTIONS(466),
    [anon_sym_finally] = ACTIONS(466),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(95),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_LT_PIPE] = ACTIONS(466),
    [anon_sym_PIPE_GT] = ACTIONS(466),
    [anon_sym_in] = ACTIONS(466),
    [anon_sym_isa] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(466),
    [anon_sym_AMP_AMP] = ACTIONS(466),
    [anon_sym_QMARK] = ACTIONS(466),
    [anon_sym_EQ_GT] = ACTIONS(466),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(71),
    [sym__bitshift_operator] = ACTIONS(71),
    [sym__rational_operator] = ACTIONS(71),
    [sym__times_operator] = ACTIONS(71),
    [sym__plus_operator] = ACTIONS(71),
    [sym__dotty_operator] = ACTIONS(71),
    [sym__comparison_operator] = ACTIONS(71),
    [sym__arrow_operator] = ACTIONS(466),
    [sym__assign_operator] = ACTIONS(466),
    [anon_sym_LF] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [23] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(4236),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1902),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(42),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [sym_identifier] = ACTIONS(476),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LT_COLON] = ACTIONS(304),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(304),
    [anon_sym_else] = ACTIONS(304),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(518),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(304),
    [anon_sym_PIPE_GT] = ACTIONS(304),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_EQ_GT] = ACTIONS(304),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(534),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(304),
    [sym__assign_operator] = ACTIONS(304),
    [anon_sym_LF] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [24] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(4236),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1904),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(42),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [sym_identifier] = ACTIONS(476),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LT_COLON] = ACTIONS(304),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(304),
    [anon_sym_else] = ACTIONS(304),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(518),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(304),
    [anon_sym_PIPE_GT] = ACTIONS(304),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_EQ_GT] = ACTIONS(304),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(534),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(304),
    [sym__assign_operator] = ACTIONS(304),
    [anon_sym_LF] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [25] = {
    [sym_function_definition] = STATE(1415),
    [sym_abstract_definition] = STATE(1415),
    [sym_primitive_definition] = STATE(1415),
    [sym_struct_definition] = STATE(1415),
    [sym_module_definition] = STATE(1415),
    [sym_macro_definition] = STATE(1415),
    [sym_parameter_list] = STATE(3775),
    [sym_if_statement] = STATE(1415),
    [sym_try_statement] = STATE(1415),
    [sym_for_statement] = STATE(1415),
    [sym_while_statement] = STATE(1415),
    [sym_return_statement] = STATE(1415),
    [sym_let_statement] = STATE(1415),
    [sym_const_statement] = STATE(1415),
    [sym_quote_statement] = STATE(1415),
    [sym_import_statement] = STATE(1415),
    [sym_export_statement] = STATE(1415),
    [sym__expression] = STATE(1364),
    [sym__primary_expression] = STATE(1095),
    [sym_operator] = STATE(1224),
    [sym_parenthesized_expression] = STATE(1095),
    [sym_field_expression] = STATE(883),
    [sym_subscript_expression] = STATE(1095),
    [sym_typed_expression] = STATE(1415),
    [sym_parameterized_identifier] = STATE(1095),
    [sym_compound_expression] = STATE(1415),
    [sym_call_expression] = STATE(1095),
    [sym_broadcast_call_expression] = STATE(1095),
    [sym_macro_expression] = STATE(1415),
    [sym_spread_expression] = STATE(1415),
    [sym_unary_expression] = STATE(1415),
    [sym_binary_expression] = STATE(1415),
    [sym_ternary_expression] = STATE(1415),
    [sym_pair_expression] = STATE(1415),
    [sym_tuple_expression] = STATE(1095),
    [sym_array_expression] = STATE(1095),
    [sym_matrix_expression] = STATE(1095),
    [sym_generator_expression] = STATE(1415),
    [sym_array_comprehension_expression] = STATE(1095),
    [sym_function_expression] = STATE(1415),
    [sym_range_expression] = STATE(1415),
    [sym_coefficient_expression] = STATE(1415),
    [sym_quote_expression] = STATE(1415),
    [sym_interpolation_expression] = STATE(1415),
    [sym_macro_identifier] = STATE(12),
    [sym__literal] = STATE(1225),
    [sym_integer_literal] = STATE(1225),
    [sym_character_literal] = STATE(1225),
    [sym_string_literal] = STATE(1225),
    [sym_command_literal] = STATE(1225),
    [sym_prefixed_string_literal] = STATE(1225),
    [sym_prefixed_command_literal] = STATE(1225),
    [sym_identifier] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(362),
    [anon_sym_primitive] = ACTIONS(364),
    [aux_sym_primitive_definition_token1] = ACTIONS(366),
    [anon_sym_mutable] = ACTIONS(368),
    [anon_sym_struct] = ACTIONS(370),
    [anon_sym_module] = ACTIONS(372),
    [anon_sym_macro] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(376),
    [anon_sym_COMMA] = ACTIONS(306),
    [anon_sym_RPAREN] = ACTIONS(306),
    [anon_sym_SEMI] = ACTIONS(306),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(306),
    [anon_sym_COLON_COLON] = ACTIONS(306),
    [anon_sym_RBRACE] = ACTIONS(306),
    [anon_sym_LT_COLON] = ACTIONS(306),
    [anon_sym_if] = ACTIONS(378),
    [anon_sym_try] = ACTIONS(380),
    [anon_sym_for] = ACTIONS(382),
    [anon_sym_while] = ACTIONS(384),
    [sym_break_statement] = ACTIONS(386),
    [sym_continue_statement] = ACTIONS(386),
    [anon_sym_return] = ACTIONS(388),
    [anon_sym_let] = ACTIONS(390),
    [anon_sym_const] = ACTIONS(392),
    [anon_sym_quote] = ACTIONS(394),
    [anon_sym_using] = ACTIONS(396),
    [anon_sym_import] = ACTIONS(396),
    [anon_sym_export] = ACTIONS(398),
    [anon_sym_COLON2] = ACTIONS(400),
    [anon_sym_RBRACK] = ACTIONS(306),
    [anon_sym_begin] = ACTIONS(402),
    [anon_sym_SQUOTE] = ACTIONS(404),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(306),
    [anon_sym_PIPE_GT] = ACTIONS(306),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(306),
    [anon_sym_AMP_AMP] = ACTIONS(306),
    [anon_sym_QMARK] = ACTIONS(306),
    [anon_sym_EQ_GT] = ACTIONS(306),
    [anon_sym_LBRACK2] = ACTIONS(406),
    [anon_sym_DOLLAR] = ACTIONS(408),
    [anon_sym_AT] = ACTIONS(410),
    [aux_sym_integer_literal_token1] = ACTIONS(412),
    [aux_sym_integer_literal_token2] = ACTIONS(412),
    [aux_sym_integer_literal_token3] = ACTIONS(414),
    [sym_float_literal] = ACTIONS(416),
    [sym__unary_operator] = ACTIONS(418),
    [sym__power_operator] = ACTIONS(420),
    [sym__bitshift_operator] = ACTIONS(420),
    [sym__rational_operator] = ACTIONS(420),
    [sym__times_operator] = ACTIONS(420),
    [sym__plus_operator] = ACTIONS(420),
    [sym__dotty_operator] = ACTIONS(420),
    [sym__comparison_operator] = ACTIONS(420),
    [sym__arrow_operator] = ACTIONS(306),
    [sym__assign_operator] = ACTIONS(304),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(424),
    [sym__command_start] = ACTIONS(426),
  },
  [26] = {
    [sym_function_definition] = STATE(1713),
    [sym_abstract_definition] = STATE(1713),
    [sym_primitive_definition] = STATE(1713),
    [sym_struct_definition] = STATE(1713),
    [sym_module_definition] = STATE(1713),
    [sym_macro_definition] = STATE(1713),
    [sym_parameter_list] = STATE(4089),
    [sym_if_statement] = STATE(1713),
    [sym_try_statement] = STATE(1713),
    [sym_for_statement] = STATE(1713),
    [sym_while_statement] = STATE(1713),
    [sym_return_statement] = STATE(1713),
    [sym_let_statement] = STATE(1713),
    [sym_const_statement] = STATE(1713),
    [sym_quote_statement] = STATE(1713),
    [sym_import_statement] = STATE(1713),
    [sym_export_statement] = STATE(1713),
    [sym__expression] = STATE(1860),
    [sym__primary_expression] = STATE(1243),
    [sym_operator] = STATE(1492),
    [sym_parenthesized_expression] = STATE(1243),
    [sym_field_expression] = STATE(1012),
    [sym_subscript_expression] = STATE(1243),
    [sym_typed_expression] = STATE(1713),
    [sym_parameterized_identifier] = STATE(1243),
    [sym_compound_expression] = STATE(1713),
    [sym_call_expression] = STATE(1243),
    [sym_broadcast_call_expression] = STATE(1243),
    [sym_macro_expression] = STATE(1713),
    [sym_macro_argument_list] = STATE(2153),
    [sym_spread_expression] = STATE(1713),
    [sym_unary_expression] = STATE(1713),
    [sym_binary_expression] = STATE(1713),
    [sym_ternary_expression] = STATE(1713),
    [sym_pair_expression] = STATE(1713),
    [sym_tuple_expression] = STATE(1243),
    [sym_array_expression] = STATE(1243),
    [sym_matrix_expression] = STATE(1243),
    [sym_generator_expression] = STATE(1713),
    [sym_array_comprehension_expression] = STATE(1243),
    [sym_function_expression] = STATE(1713),
    [sym_range_expression] = STATE(1713),
    [sym_coefficient_expression] = STATE(1713),
    [sym_quote_expression] = STATE(1713),
    [sym_interpolation_expression] = STATE(1713),
    [sym_macro_identifier] = STATE(27),
    [sym__literal] = STATE(1494),
    [sym_integer_literal] = STATE(1494),
    [sym_character_literal] = STATE(1494),
    [sym_string_literal] = STATE(1494),
    [sym_command_literal] = STATE(1494),
    [sym_prefixed_string_literal] = STATE(1494),
    [sym_prefixed_command_literal] = STATE(1494),
    [aux_sym_macro_argument_list_repeat1] = STATE(47),
    [ts_builtin_sym_end] = ACTIONS(183),
    [sym_identifier] = ACTIONS(542),
    [anon_sym_function] = ACTIONS(544),
    [anon_sym_abstract] = ACTIONS(546),
    [anon_sym_primitive] = ACTIONS(548),
    [aux_sym_primitive_definition_token1] = ACTIONS(550),
    [anon_sym_mutable] = ACTIONS(552),
    [anon_sym_struct] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(556),
    [anon_sym_macro] = ACTIONS(558),
    [anon_sym_LPAREN] = ACTIONS(560),
    [anon_sym_COMMA] = ACTIONS(125),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_COLON_COLON] = ACTIONS(125),
    [anon_sym_LT_COLON] = ACTIONS(125),
    [anon_sym_if] = ACTIONS(562),
    [anon_sym_try] = ACTIONS(564),
    [anon_sym_for] = ACTIONS(566),
    [anon_sym_while] = ACTIONS(568),
    [sym_break_statement] = ACTIONS(570),
    [sym_continue_statement] = ACTIONS(570),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_let] = ACTIONS(574),
    [anon_sym_const] = ACTIONS(576),
    [anon_sym_quote] = ACTIONS(578),
    [anon_sym_using] = ACTIONS(580),
    [anon_sym_import] = ACTIONS(580),
    [anon_sym_export] = ACTIONS(582),
    [anon_sym_COLON2] = ACTIONS(584),
    [anon_sym_begin] = ACTIONS(586),
    [anon_sym_SQUOTE] = ACTIONS(588),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_LT_PIPE] = ACTIONS(125),
    [anon_sym_PIPE_GT] = ACTIONS(125),
    [anon_sym_in] = ACTIONS(125),
    [anon_sym_isa] = ACTIONS(125),
    [anon_sym_PIPE_PIPE] = ACTIONS(125),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_QMARK] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_LBRACK2] = ACTIONS(590),
    [anon_sym_DOLLAR] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(594),
    [aux_sym_integer_literal_token1] = ACTIONS(596),
    [aux_sym_integer_literal_token2] = ACTIONS(596),
    [aux_sym_integer_literal_token3] = ACTIONS(596),
    [sym_float_literal] = ACTIONS(598),
    [sym__unary_operator] = ACTIONS(600),
    [sym__power_operator] = ACTIONS(602),
    [sym__bitshift_operator] = ACTIONS(602),
    [sym__rational_operator] = ACTIONS(602),
    [sym__times_operator] = ACTIONS(602),
    [sym__plus_operator] = ACTIONS(602),
    [sym__dotty_operator] = ACTIONS(602),
    [sym__comparison_operator] = ACTIONS(602),
    [sym__arrow_operator] = ACTIONS(125),
    [sym__assign_operator] = ACTIONS(125),
    [anon_sym_LF] = ACTIONS(183),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(185),
    [sym__string_start] = ACTIONS(604),
    [sym__command_start] = ACTIONS(606),
  },
  [27] = {
    [sym_function_definition] = STATE(1713),
    [sym_abstract_definition] = STATE(1713),
    [sym_primitive_definition] = STATE(1713),
    [sym_struct_definition] = STATE(1713),
    [sym_module_definition] = STATE(1713),
    [sym_macro_definition] = STATE(1713),
    [sym_parameter_list] = STATE(4089),
    [sym_if_statement] = STATE(1713),
    [sym_try_statement] = STATE(1713),
    [sym_for_statement] = STATE(1713),
    [sym_while_statement] = STATE(1713),
    [sym_return_statement] = STATE(1713),
    [sym_let_statement] = STATE(1713),
    [sym_const_statement] = STATE(1713),
    [sym_quote_statement] = STATE(1713),
    [sym_import_statement] = STATE(1713),
    [sym_export_statement] = STATE(1713),
    [sym__expression] = STATE(1860),
    [sym__primary_expression] = STATE(1243),
    [sym_operator] = STATE(1492),
    [sym_parenthesized_expression] = STATE(1243),
    [sym_field_expression] = STATE(1012),
    [sym_subscript_expression] = STATE(1243),
    [sym_typed_expression] = STATE(1713),
    [sym_parameterized_identifier] = STATE(1243),
    [sym_compound_expression] = STATE(1713),
    [sym_call_expression] = STATE(1243),
    [sym_broadcast_call_expression] = STATE(1243),
    [sym_macro_expression] = STATE(1713),
    [sym_macro_argument_list] = STATE(1580),
    [sym_spread_expression] = STATE(1713),
    [sym_unary_expression] = STATE(1713),
    [sym_binary_expression] = STATE(1713),
    [sym_ternary_expression] = STATE(1713),
    [sym_pair_expression] = STATE(1713),
    [sym_tuple_expression] = STATE(1243),
    [sym_array_expression] = STATE(1243),
    [sym_matrix_expression] = STATE(1243),
    [sym_generator_expression] = STATE(1713),
    [sym_array_comprehension_expression] = STATE(1243),
    [sym_function_expression] = STATE(1713),
    [sym_range_expression] = STATE(1713),
    [sym_coefficient_expression] = STATE(1713),
    [sym_quote_expression] = STATE(1713),
    [sym_interpolation_expression] = STATE(1713),
    [sym_macro_identifier] = STATE(27),
    [sym__literal] = STATE(1494),
    [sym_integer_literal] = STATE(1494),
    [sym_character_literal] = STATE(1494),
    [sym_string_literal] = STATE(1494),
    [sym_command_literal] = STATE(1494),
    [sym_prefixed_string_literal] = STATE(1494),
    [sym_prefixed_command_literal] = STATE(1494),
    [aux_sym_macro_argument_list_repeat1] = STATE(47),
    [ts_builtin_sym_end] = ACTIONS(183),
    [sym_identifier] = ACTIONS(542),
    [anon_sym_function] = ACTIONS(544),
    [anon_sym_abstract] = ACTIONS(546),
    [anon_sym_primitive] = ACTIONS(548),
    [aux_sym_primitive_definition_token1] = ACTIONS(550),
    [anon_sym_mutable] = ACTIONS(552),
    [anon_sym_struct] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(556),
    [anon_sym_macro] = ACTIONS(558),
    [anon_sym_LPAREN] = ACTIONS(560),
    [anon_sym_COMMA] = ACTIONS(125),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_COLON_COLON] = ACTIONS(125),
    [anon_sym_LT_COLON] = ACTIONS(125),
    [anon_sym_if] = ACTIONS(562),
    [anon_sym_try] = ACTIONS(564),
    [anon_sym_for] = ACTIONS(566),
    [anon_sym_while] = ACTIONS(568),
    [sym_break_statement] = ACTIONS(570),
    [sym_continue_statement] = ACTIONS(570),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_let] = ACTIONS(574),
    [anon_sym_const] = ACTIONS(576),
    [anon_sym_quote] = ACTIONS(578),
    [anon_sym_using] = ACTIONS(580),
    [anon_sym_import] = ACTIONS(580),
    [anon_sym_export] = ACTIONS(582),
    [anon_sym_COLON2] = ACTIONS(584),
    [anon_sym_begin] = ACTIONS(586),
    [anon_sym_SQUOTE] = ACTIONS(588),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_LT_PIPE] = ACTIONS(125),
    [anon_sym_PIPE_GT] = ACTIONS(125),
    [anon_sym_in] = ACTIONS(125),
    [anon_sym_isa] = ACTIONS(125),
    [anon_sym_PIPE_PIPE] = ACTIONS(125),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_QMARK] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_LBRACK2] = ACTIONS(590),
    [anon_sym_DOLLAR] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(594),
    [aux_sym_integer_literal_token1] = ACTIONS(596),
    [aux_sym_integer_literal_token2] = ACTIONS(596),
    [aux_sym_integer_literal_token3] = ACTIONS(596),
    [sym_float_literal] = ACTIONS(598),
    [sym__unary_operator] = ACTIONS(600),
    [sym__power_operator] = ACTIONS(602),
    [sym__bitshift_operator] = ACTIONS(602),
    [sym__rational_operator] = ACTIONS(602),
    [sym__times_operator] = ACTIONS(602),
    [sym__plus_operator] = ACTIONS(602),
    [sym__dotty_operator] = ACTIONS(602),
    [sym__comparison_operator] = ACTIONS(602),
    [sym__arrow_operator] = ACTIONS(125),
    [sym__assign_operator] = ACTIONS(125),
    [anon_sym_LF] = ACTIONS(183),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(608),
    [sym__string_start] = ACTIONS(604),
    [sym__command_start] = ACTIONS(606),
  },
  [28] = {
    [sym_function_definition] = STATE(1855),
    [sym_abstract_definition] = STATE(1855),
    [sym_primitive_definition] = STATE(1855),
    [sym_struct_definition] = STATE(1855),
    [sym_module_definition] = STATE(1855),
    [sym_macro_definition] = STATE(1855),
    [sym_parameter_list] = STATE(4171),
    [sym_if_statement] = STATE(1855),
    [sym_try_statement] = STATE(1855),
    [sym_for_statement] = STATE(1855),
    [sym_while_statement] = STATE(1855),
    [sym_return_statement] = STATE(1855),
    [sym_let_statement] = STATE(1855),
    [sym_const_statement] = STATE(1855),
    [sym_quote_statement] = STATE(1855),
    [sym_import_statement] = STATE(1855),
    [sym_export_statement] = STATE(1855),
    [sym__expression] = STATE(1685),
    [sym__primary_expression] = STATE(1237),
    [sym_operator] = STATE(1461),
    [sym_parenthesized_expression] = STATE(1237),
    [sym_field_expression] = STATE(1088),
    [sym_subscript_expression] = STATE(1237),
    [sym_typed_expression] = STATE(1855),
    [sym_parameterized_identifier] = STATE(1237),
    [sym_compound_expression] = STATE(1855),
    [sym_call_expression] = STATE(1237),
    [sym_broadcast_call_expression] = STATE(1237),
    [sym_macro_expression] = STATE(1855),
    [sym_macro_argument_list] = STATE(1829),
    [sym_spread_expression] = STATE(1855),
    [sym_unary_expression] = STATE(1855),
    [sym_binary_expression] = STATE(1855),
    [sym_ternary_expression] = STATE(1855),
    [sym_pair_expression] = STATE(1855),
    [sym_tuple_expression] = STATE(1237),
    [sym_array_expression] = STATE(1237),
    [sym_matrix_expression] = STATE(1237),
    [sym_generator_expression] = STATE(1855),
    [sym_array_comprehension_expression] = STATE(1237),
    [sym_function_expression] = STATE(1855),
    [sym_range_expression] = STATE(1855),
    [sym_coefficient_expression] = STATE(1855),
    [sym_quote_expression] = STATE(1855),
    [sym_interpolation_expression] = STATE(1855),
    [sym_macro_identifier] = STATE(28),
    [sym__literal] = STATE(1462),
    [sym_integer_literal] = STATE(1462),
    [sym_character_literal] = STATE(1462),
    [sym_string_literal] = STATE(1462),
    [sym_command_literal] = STATE(1462),
    [sym_prefixed_string_literal] = STATE(1462),
    [sym_prefixed_command_literal] = STATE(1462),
    [aux_sym_macro_argument_list_repeat1] = STATE(60),
    [sym_identifier] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_end] = ACTIONS(125),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_primitive] = ACTIONS(616),
    [aux_sym_primitive_definition_token1] = ACTIONS(618),
    [anon_sym_mutable] = ACTIONS(620),
    [anon_sym_struct] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_macro] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_COMMA] = ACTIONS(183),
    [anon_sym_RPAREN] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(183),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(183),
    [anon_sym_RBRACE] = ACTIONS(183),
    [anon_sym_LT_COLON] = ACTIONS(183),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [sym_break_statement] = ACTIONS(638),
    [sym_continue_statement] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(644),
    [anon_sym_quote] = ACTIONS(646),
    [anon_sym_using] = ACTIONS(648),
    [anon_sym_import] = ACTIONS(648),
    [anon_sym_export] = ACTIONS(650),
    [anon_sym_COLON2] = ACTIONS(652),
    [anon_sym_RBRACK] = ACTIONS(183),
    [anon_sym_begin] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_LT_PIPE] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_in] = ACTIONS(125),
    [anon_sym_isa] = ACTIONS(125),
    [anon_sym_PIPE_PIPE] = ACTIONS(183),
    [anon_sym_AMP_AMP] = ACTIONS(183),
    [anon_sym_QMARK] = ACTIONS(183),
    [anon_sym_EQ_GT] = ACTIONS(183),
    [anon_sym_LBRACK2] = ACTIONS(658),
    [anon_sym_DOLLAR] = ACTIONS(660),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(664),
    [aux_sym_integer_literal_token2] = ACTIONS(664),
    [aux_sym_integer_literal_token3] = ACTIONS(666),
    [sym_float_literal] = ACTIONS(668),
    [sym__unary_operator] = ACTIONS(670),
    [sym__power_operator] = ACTIONS(672),
    [sym__bitshift_operator] = ACTIONS(672),
    [sym__rational_operator] = ACTIONS(672),
    [sym__times_operator] = ACTIONS(674),
    [sym__plus_operator] = ACTIONS(674),
    [sym__dotty_operator] = ACTIONS(674),
    [sym__comparison_operator] = ACTIONS(674),
    [sym__arrow_operator] = ACTIONS(183),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(676),
    [sym__string_start] = ACTIONS(678),
    [sym__command_start] = ACTIONS(680),
  },
  [29] = {
    [sym_function_definition] = STATE(2364),
    [sym_abstract_definition] = STATE(2364),
    [sym_primitive_definition] = STATE(2364),
    [sym_struct_definition] = STATE(2364),
    [sym_module_definition] = STATE(2364),
    [sym_macro_definition] = STATE(2364),
    [sym_parameter_list] = STATE(4021),
    [sym_if_statement] = STATE(2364),
    [sym_try_statement] = STATE(2364),
    [sym_for_statement] = STATE(2364),
    [sym_while_statement] = STATE(2364),
    [sym_return_statement] = STATE(2364),
    [sym_let_statement] = STATE(2364),
    [sym_const_statement] = STATE(2364),
    [sym_quote_statement] = STATE(2364),
    [sym_import_statement] = STATE(2364),
    [sym_export_statement] = STATE(2364),
    [sym__expression] = STATE(2280),
    [sym__primary_expression] = STATE(2049),
    [sym_bare_tuple_expression] = STATE(2383),
    [sym_operator] = STATE(2271),
    [sym_parenthesized_expression] = STATE(2049),
    [sym_field_expression] = STATE(2002),
    [sym_subscript_expression] = STATE(2049),
    [sym_typed_expression] = STATE(2364),
    [sym_parameterized_identifier] = STATE(2049),
    [sym_compound_expression] = STATE(2364),
    [sym_call_expression] = STATE(2049),
    [sym_broadcast_call_expression] = STATE(2049),
    [sym_macro_expression] = STATE(2364),
    [sym_spread_expression] = STATE(2364),
    [sym_unary_expression] = STATE(2364),
    [sym_binary_expression] = STATE(2364),
    [sym_ternary_expression] = STATE(2364),
    [sym_pair_expression] = STATE(2364),
    [sym_tuple_expression] = STATE(2049),
    [sym_array_expression] = STATE(2049),
    [sym_matrix_expression] = STATE(2049),
    [sym_generator_expression] = STATE(2364),
    [sym_array_comprehension_expression] = STATE(2049),
    [sym_function_expression] = STATE(2364),
    [sym_range_expression] = STATE(2364),
    [sym_coefficient_expression] = STATE(2364),
    [sym_quote_expression] = STATE(2364),
    [sym_interpolation_expression] = STATE(2364),
    [sym_macro_identifier] = STATE(18),
    [sym__literal] = STATE(2274),
    [sym_integer_literal] = STATE(2274),
    [sym_character_literal] = STATE(2274),
    [sym_string_literal] = STATE(2274),
    [sym_command_literal] = STATE(2274),
    [sym_prefixed_string_literal] = STATE(2274),
    [sym_prefixed_command_literal] = STATE(2274),
    [sym_identifier] = ACTIONS(682),
    [anon_sym_function] = ACTIONS(684),
    [anon_sym_end] = ACTIONS(300),
    [anon_sym_abstract] = ACTIONS(686),
    [anon_sym_primitive] = ACTIONS(688),
    [aux_sym_primitive_definition_token1] = ACTIONS(690),
    [anon_sym_mutable] = ACTIONS(692),
    [anon_sym_struct] = ACTIONS(694),
    [anon_sym_module] = ACTIONS(696),
    [anon_sym_macro] = ACTIONS(698),
    [anon_sym_LPAREN] = ACTIONS(700),
    [anon_sym_COMMA] = ACTIONS(302),
    [anon_sym_RPAREN] = ACTIONS(302),
    [anon_sym_SEMI] = ACTIONS(302),
    [anon_sym_EQ] = ACTIONS(300),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(302),
    [anon_sym_COLON_COLON] = ACTIONS(302),
    [anon_sym_RBRACE] = ACTIONS(302),
    [anon_sym_LT_COLON] = ACTIONS(302),
    [anon_sym_if] = ACTIONS(702),
    [anon_sym_try] = ACTIONS(704),
    [anon_sym_for] = ACTIONS(706),
    [anon_sym_while] = ACTIONS(708),
    [sym_break_statement] = ACTIONS(710),
    [sym_continue_statement] = ACTIONS(710),
    [anon_sym_return] = ACTIONS(712),
    [anon_sym_let] = ACTIONS(714),
    [anon_sym_const] = ACTIONS(716),
    [anon_sym_quote] = ACTIONS(718),
    [anon_sym_using] = ACTIONS(720),
    [anon_sym_import] = ACTIONS(720),
    [anon_sym_export] = ACTIONS(722),
    [anon_sym_COLON2] = ACTIONS(724),
    [anon_sym_RBRACK] = ACTIONS(302),
    [anon_sym_begin] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_PLUS] = ACTIONS(300),
    [anon_sym_LT_PIPE] = ACTIONS(302),
    [anon_sym_PIPE_GT] = ACTIONS(302),
    [anon_sym_in] = ACTIONS(300),
    [anon_sym_isa] = ACTIONS(300),
    [anon_sym_PIPE_PIPE] = ACTIONS(302),
    [anon_sym_AMP_AMP] = ACTIONS(302),
    [anon_sym_QMARK] = ACTIONS(302),
    [anon_sym_EQ_GT] = ACTIONS(302),
    [anon_sym_LBRACK2] = ACTIONS(730),
    [anon_sym_DOLLAR] = ACTIONS(732),
    [anon_sym_AT] = ACTIONS(410),
    [aux_sym_integer_literal_token1] = ACTIONS(734),
    [aux_sym_integer_literal_token2] = ACTIONS(734),
    [aux_sym_integer_literal_token3] = ACTIONS(736),
    [sym_float_literal] = ACTIONS(738),
    [sym__unary_operator] = ACTIONS(740),
    [sym__power_operator] = ACTIONS(742),
    [sym__bitshift_operator] = ACTIONS(742),
    [sym__rational_operator] = ACTIONS(742),
    [sym__times_operator] = ACTIONS(742),
    [sym__plus_operator] = ACTIONS(742),
    [sym__dotty_operator] = ACTIONS(742),
    [sym__comparison_operator] = ACTIONS(742),
    [sym__arrow_operator] = ACTIONS(302),
    [sym__assign_operator] = ACTIONS(300),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(744),
    [sym__command_start] = ACTIONS(746),
  },
  [30] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(4236),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1789),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(42),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [sym_identifier] = ACTIONS(476),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LT_COLON] = ACTIONS(304),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(304),
    [anon_sym_else] = ACTIONS(304),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(518),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(304),
    [anon_sym_PIPE_GT] = ACTIONS(304),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_EQ_GT] = ACTIONS(304),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(534),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(304),
    [sym__assign_operator] = ACTIONS(304),
    [anon_sym_LF] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [31] = {
    [sym_function_definition] = STATE(1415),
    [sym_abstract_definition] = STATE(1415),
    [sym_primitive_definition] = STATE(1415),
    [sym_struct_definition] = STATE(1415),
    [sym_module_definition] = STATE(1415),
    [sym_macro_definition] = STATE(1415),
    [sym_parameter_list] = STATE(3775),
    [sym_if_statement] = STATE(1415),
    [sym_try_statement] = STATE(1415),
    [sym_for_statement] = STATE(1415),
    [sym_while_statement] = STATE(1415),
    [sym_return_statement] = STATE(1415),
    [sym_let_statement] = STATE(1415),
    [sym_const_statement] = STATE(1415),
    [sym_quote_statement] = STATE(1415),
    [sym_import_statement] = STATE(1415),
    [sym_export_statement] = STATE(1415),
    [sym__expression] = STATE(1337),
    [sym__primary_expression] = STATE(1095),
    [sym_operator] = STATE(1224),
    [sym_parenthesized_expression] = STATE(1095),
    [sym_field_expression] = STATE(883),
    [sym_subscript_expression] = STATE(1095),
    [sym_typed_expression] = STATE(1415),
    [sym_parameterized_identifier] = STATE(1095),
    [sym_compound_expression] = STATE(1415),
    [sym_call_expression] = STATE(1095),
    [sym_broadcast_call_expression] = STATE(1095),
    [sym_macro_expression] = STATE(1415),
    [sym_spread_expression] = STATE(1415),
    [sym_unary_expression] = STATE(1415),
    [sym_binary_expression] = STATE(1415),
    [sym_ternary_expression] = STATE(1415),
    [sym_pair_expression] = STATE(1415),
    [sym_tuple_expression] = STATE(1095),
    [sym_array_expression] = STATE(1095),
    [sym_matrix_expression] = STATE(1095),
    [sym_generator_expression] = STATE(1415),
    [sym_array_comprehension_expression] = STATE(1095),
    [sym_function_expression] = STATE(1415),
    [sym_range_expression] = STATE(1415),
    [sym_coefficient_expression] = STATE(1415),
    [sym_quote_expression] = STATE(1415),
    [sym_interpolation_expression] = STATE(1415),
    [sym_macro_identifier] = STATE(12),
    [sym__literal] = STATE(1225),
    [sym_integer_literal] = STATE(1225),
    [sym_character_literal] = STATE(1225),
    [sym_string_literal] = STATE(1225),
    [sym_command_literal] = STATE(1225),
    [sym_prefixed_string_literal] = STATE(1225),
    [sym_prefixed_command_literal] = STATE(1225),
    [aux_sym_macro_argument_list_repeat1] = STATE(38),
    [sym_identifier] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_end] = ACTIONS(193),
    [anon_sym_abstract] = ACTIONS(362),
    [anon_sym_primitive] = ACTIONS(364),
    [aux_sym_primitive_definition_token1] = ACTIONS(366),
    [anon_sym_mutable] = ACTIONS(368),
    [anon_sym_struct] = ACTIONS(370),
    [anon_sym_module] = ACTIONS(372),
    [anon_sym_macro] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(376),
    [anon_sym_COMMA] = ACTIONS(195),
    [anon_sym_RPAREN] = ACTIONS(195),
    [anon_sym_SEMI] = ACTIONS(195),
    [anon_sym_EQ] = ACTIONS(193),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(195),
    [anon_sym_COLON_COLON] = ACTIONS(195),
    [anon_sym_RBRACE] = ACTIONS(195),
    [anon_sym_LT_COLON] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(378),
    [anon_sym_try] = ACTIONS(380),
    [anon_sym_for] = ACTIONS(382),
    [anon_sym_while] = ACTIONS(384),
    [sym_break_statement] = ACTIONS(386),
    [sym_continue_statement] = ACTIONS(386),
    [anon_sym_return] = ACTIONS(388),
    [anon_sym_let] = ACTIONS(390),
    [anon_sym_const] = ACTIONS(392),
    [anon_sym_quote] = ACTIONS(394),
    [anon_sym_using] = ACTIONS(396),
    [anon_sym_import] = ACTIONS(396),
    [anon_sym_export] = ACTIONS(398),
    [anon_sym_COLON2] = ACTIONS(400),
    [anon_sym_RBRACK] = ACTIONS(195),
    [anon_sym_begin] = ACTIONS(402),
    [anon_sym_SQUOTE] = ACTIONS(404),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(195),
    [anon_sym_PIPE_GT] = ACTIONS(195),
    [anon_sym_in] = ACTIONS(193),
    [anon_sym_isa] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(195),
    [anon_sym_AMP_AMP] = ACTIONS(195),
    [anon_sym_QMARK] = ACTIONS(195),
    [anon_sym_EQ_GT] = ACTIONS(195),
    [anon_sym_LBRACK2] = ACTIONS(406),
    [anon_sym_DOLLAR] = ACTIONS(408),
    [anon_sym_AT] = ACTIONS(410),
    [aux_sym_integer_literal_token1] = ACTIONS(412),
    [aux_sym_integer_literal_token2] = ACTIONS(412),
    [aux_sym_integer_literal_token3] = ACTIONS(414),
    [sym_float_literal] = ACTIONS(416),
    [sym__unary_operator] = ACTIONS(418),
    [sym__power_operator] = ACTIONS(420),
    [sym__bitshift_operator] = ACTIONS(420),
    [sym__rational_operator] = ACTIONS(420),
    [sym__times_operator] = ACTIONS(420),
    [sym__plus_operator] = ACTIONS(420),
    [sym__dotty_operator] = ACTIONS(420),
    [sym__comparison_operator] = ACTIONS(420),
    [sym__arrow_operator] = ACTIONS(195),
    [sym__assign_operator] = ACTIONS(193),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(424),
    [sym__command_start] = ACTIONS(426),
  },
  [32] = {
    [sym_function_definition] = STATE(1415),
    [sym_abstract_definition] = STATE(1415),
    [sym_primitive_definition] = STATE(1415),
    [sym_struct_definition] = STATE(1415),
    [sym_module_definition] = STATE(1415),
    [sym_macro_definition] = STATE(1415),
    [sym_parameter_list] = STATE(3775),
    [sym_if_statement] = STATE(1415),
    [sym_try_statement] = STATE(1415),
    [sym_for_statement] = STATE(1415),
    [sym_while_statement] = STATE(1415),
    [sym_return_statement] = STATE(1415),
    [sym_let_statement] = STATE(1415),
    [sym_const_statement] = STATE(1415),
    [sym_quote_statement] = STATE(1415),
    [sym_import_statement] = STATE(1415),
    [sym_export_statement] = STATE(1415),
    [sym__expression] = STATE(1232),
    [sym__primary_expression] = STATE(1095),
    [sym_bare_tuple_expression] = STATE(1406),
    [sym_operator] = STATE(1224),
    [sym_parenthesized_expression] = STATE(1095),
    [sym_field_expression] = STATE(883),
    [sym_subscript_expression] = STATE(1095),
    [sym_typed_expression] = STATE(1415),
    [sym_parameterized_identifier] = STATE(1095),
    [sym_compound_expression] = STATE(1415),
    [sym_call_expression] = STATE(1095),
    [sym_broadcast_call_expression] = STATE(1095),
    [sym_macro_expression] = STATE(1415),
    [sym_spread_expression] = STATE(1415),
    [sym_unary_expression] = STATE(1415),
    [sym_binary_expression] = STATE(1415),
    [sym_ternary_expression] = STATE(1415),
    [sym_pair_expression] = STATE(1415),
    [sym_tuple_expression] = STATE(1095),
    [sym_array_expression] = STATE(1095),
    [sym_matrix_expression] = STATE(1095),
    [sym_generator_expression] = STATE(1415),
    [sym_array_comprehension_expression] = STATE(1095),
    [sym_function_expression] = STATE(1415),
    [sym_range_expression] = STATE(1415),
    [sym_coefficient_expression] = STATE(1415),
    [sym_quote_expression] = STATE(1415),
    [sym_interpolation_expression] = STATE(1415),
    [sym_macro_identifier] = STATE(12),
    [sym__literal] = STATE(1225),
    [sym_integer_literal] = STATE(1225),
    [sym_character_literal] = STATE(1225),
    [sym_string_literal] = STATE(1225),
    [sym_command_literal] = STATE(1225),
    [sym_prefixed_string_literal] = STATE(1225),
    [sym_prefixed_command_literal] = STATE(1225),
    [sym_identifier] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_end] = ACTIONS(300),
    [anon_sym_abstract] = ACTIONS(362),
    [anon_sym_primitive] = ACTIONS(364),
    [aux_sym_primitive_definition_token1] = ACTIONS(366),
    [anon_sym_mutable] = ACTIONS(368),
    [anon_sym_struct] = ACTIONS(370),
    [anon_sym_module] = ACTIONS(372),
    [anon_sym_macro] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(376),
    [anon_sym_COMMA] = ACTIONS(302),
    [anon_sym_RPAREN] = ACTIONS(302),
    [anon_sym_SEMI] = ACTIONS(302),
    [anon_sym_EQ] = ACTIONS(300),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(302),
    [anon_sym_COLON_COLON] = ACTIONS(302),
    [anon_sym_RBRACE] = ACTIONS(302),
    [anon_sym_LT_COLON] = ACTIONS(302),
    [anon_sym_if] = ACTIONS(378),
    [anon_sym_try] = ACTIONS(380),
    [anon_sym_for] = ACTIONS(382),
    [anon_sym_while] = ACTIONS(384),
    [sym_break_statement] = ACTIONS(386),
    [sym_continue_statement] = ACTIONS(386),
    [anon_sym_return] = ACTIONS(388),
    [anon_sym_let] = ACTIONS(390),
    [anon_sym_const] = ACTIONS(392),
    [anon_sym_quote] = ACTIONS(394),
    [anon_sym_using] = ACTIONS(396),
    [anon_sym_import] = ACTIONS(396),
    [anon_sym_export] = ACTIONS(398),
    [anon_sym_COLON2] = ACTIONS(400),
    [anon_sym_RBRACK] = ACTIONS(302),
    [anon_sym_begin] = ACTIONS(402),
    [anon_sym_SQUOTE] = ACTIONS(404),
    [anon_sym_PLUS] = ACTIONS(300),
    [anon_sym_LT_PIPE] = ACTIONS(302),
    [anon_sym_PIPE_GT] = ACTIONS(302),
    [anon_sym_in] = ACTIONS(300),
    [anon_sym_isa] = ACTIONS(300),
    [anon_sym_PIPE_PIPE] = ACTIONS(302),
    [anon_sym_AMP_AMP] = ACTIONS(302),
    [anon_sym_QMARK] = ACTIONS(302),
    [anon_sym_EQ_GT] = ACTIONS(302),
    [anon_sym_LBRACK2] = ACTIONS(406),
    [anon_sym_DOLLAR] = ACTIONS(408),
    [anon_sym_AT] = ACTIONS(410),
    [aux_sym_integer_literal_token1] = ACTIONS(412),
    [aux_sym_integer_literal_token2] = ACTIONS(412),
    [aux_sym_integer_literal_token3] = ACTIONS(414),
    [sym_float_literal] = ACTIONS(416),
    [sym__unary_operator] = ACTIONS(418),
    [sym__power_operator] = ACTIONS(420),
    [sym__bitshift_operator] = ACTIONS(420),
    [sym__rational_operator] = ACTIONS(420),
    [sym__times_operator] = ACTIONS(420),
    [sym__plus_operator] = ACTIONS(420),
    [sym__dotty_operator] = ACTIONS(420),
    [sym__comparison_operator] = ACTIONS(420),
    [sym__arrow_operator] = ACTIONS(302),
    [sym__assign_operator] = ACTIONS(300),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(424),
    [sym__command_start] = ACTIONS(426),
  },
  [33] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(3882),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1800),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_macro_argument_list] = STATE(1722),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(33),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [aux_sym_macro_argument_list_repeat1] = STATE(48),
    [sym_identifier] = ACTIONS(748),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(125),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(125),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_COLON_COLON] = ACTIONS(125),
    [anon_sym_LT_COLON] = ACTIONS(125),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(125),
    [anon_sym_else] = ACTIONS(125),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(750),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_LT_PIPE] = ACTIONS(125),
    [anon_sym_PIPE_GT] = ACTIONS(125),
    [anon_sym_in] = ACTIONS(125),
    [anon_sym_isa] = ACTIONS(125),
    [anon_sym_PIPE_PIPE] = ACTIONS(125),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_QMARK] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(752),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(754),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(125),
    [anon_sym_LF] = ACTIONS(183),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(756),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [34] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(4236),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1901),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(42),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [sym_identifier] = ACTIONS(476),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LT_COLON] = ACTIONS(304),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(304),
    [anon_sym_else] = ACTIONS(304),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(518),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(304),
    [anon_sym_PIPE_GT] = ACTIONS(304),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_EQ_GT] = ACTIONS(304),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(534),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(304),
    [sym__assign_operator] = ACTIONS(304),
    [anon_sym_LF] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [35] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(4236),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1903),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(42),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [sym_identifier] = ACTIONS(476),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LT_COLON] = ACTIONS(304),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(304),
    [anon_sym_else] = ACTIONS(304),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(518),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(304),
    [anon_sym_PIPE_GT] = ACTIONS(304),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_EQ_GT] = ACTIONS(304),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(534),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(304),
    [sym__assign_operator] = ACTIONS(304),
    [anon_sym_LF] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [36] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(4236),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1894),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(42),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [sym_identifier] = ACTIONS(476),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LT_COLON] = ACTIONS(304),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(304),
    [anon_sym_else] = ACTIONS(304),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(518),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(304),
    [anon_sym_PIPE_GT] = ACTIONS(304),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_EQ_GT] = ACTIONS(304),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(534),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(304),
    [sym__assign_operator] = ACTIONS(304),
    [anon_sym_LF] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [37] = {
    [sym_function_definition] = STATE(1855),
    [sym_abstract_definition] = STATE(1855),
    [sym_primitive_definition] = STATE(1855),
    [sym_struct_definition] = STATE(1855),
    [sym_module_definition] = STATE(1855),
    [sym_macro_definition] = STATE(1855),
    [sym_parameter_list] = STATE(4171),
    [sym_if_statement] = STATE(1855),
    [sym_try_statement] = STATE(1855),
    [sym_for_statement] = STATE(1855),
    [sym_while_statement] = STATE(1855),
    [sym_return_statement] = STATE(1855),
    [sym_let_statement] = STATE(1855),
    [sym_const_statement] = STATE(1855),
    [sym_quote_statement] = STATE(1855),
    [sym_import_statement] = STATE(1855),
    [sym_export_statement] = STATE(1855),
    [sym__expression] = STATE(1685),
    [sym__primary_expression] = STATE(1237),
    [sym_operator] = STATE(1461),
    [sym_parenthesized_expression] = STATE(1237),
    [sym_field_expression] = STATE(1088),
    [sym_subscript_expression] = STATE(1237),
    [sym_typed_expression] = STATE(1855),
    [sym_parameterized_identifier] = STATE(1237),
    [sym_compound_expression] = STATE(1855),
    [sym_call_expression] = STATE(1237),
    [sym_broadcast_call_expression] = STATE(1237),
    [sym_macro_expression] = STATE(1855),
    [sym_macro_argument_list] = STATE(2581),
    [sym_spread_expression] = STATE(1855),
    [sym_unary_expression] = STATE(1855),
    [sym_binary_expression] = STATE(1855),
    [sym_ternary_expression] = STATE(1855),
    [sym_pair_expression] = STATE(1855),
    [sym_tuple_expression] = STATE(1237),
    [sym_array_expression] = STATE(1237),
    [sym_matrix_expression] = STATE(1237),
    [sym_generator_expression] = STATE(1855),
    [sym_array_comprehension_expression] = STATE(1237),
    [sym_function_expression] = STATE(1855),
    [sym_range_expression] = STATE(1855),
    [sym_coefficient_expression] = STATE(1855),
    [sym_quote_expression] = STATE(1855),
    [sym_interpolation_expression] = STATE(1855),
    [sym_macro_identifier] = STATE(28),
    [sym__literal] = STATE(1462),
    [sym_integer_literal] = STATE(1462),
    [sym_character_literal] = STATE(1462),
    [sym_string_literal] = STATE(1462),
    [sym_command_literal] = STATE(1462),
    [sym_prefixed_string_literal] = STATE(1462),
    [sym_prefixed_command_literal] = STATE(1462),
    [aux_sym_macro_argument_list_repeat1] = STATE(60),
    [sym_identifier] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_end] = ACTIONS(125),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_primitive] = ACTIONS(616),
    [aux_sym_primitive_definition_token1] = ACTIONS(618),
    [anon_sym_mutable] = ACTIONS(620),
    [anon_sym_struct] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_macro] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_COMMA] = ACTIONS(183),
    [anon_sym_RPAREN] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(183),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(183),
    [anon_sym_RBRACE] = ACTIONS(183),
    [anon_sym_LT_COLON] = ACTIONS(183),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [sym_break_statement] = ACTIONS(638),
    [sym_continue_statement] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(644),
    [anon_sym_quote] = ACTIONS(646),
    [anon_sym_using] = ACTIONS(648),
    [anon_sym_import] = ACTIONS(648),
    [anon_sym_export] = ACTIONS(650),
    [anon_sym_COLON2] = ACTIONS(652),
    [anon_sym_RBRACK] = ACTIONS(183),
    [anon_sym_begin] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_LT_PIPE] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_in] = ACTIONS(125),
    [anon_sym_isa] = ACTIONS(125),
    [anon_sym_PIPE_PIPE] = ACTIONS(183),
    [anon_sym_AMP_AMP] = ACTIONS(183),
    [anon_sym_QMARK] = ACTIONS(183),
    [anon_sym_EQ_GT] = ACTIONS(183),
    [anon_sym_LBRACK2] = ACTIONS(658),
    [anon_sym_DOLLAR] = ACTIONS(660),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(664),
    [aux_sym_integer_literal_token2] = ACTIONS(664),
    [aux_sym_integer_literal_token3] = ACTIONS(666),
    [sym_float_literal] = ACTIONS(668),
    [sym__unary_operator] = ACTIONS(670),
    [sym__power_operator] = ACTIONS(672),
    [sym__bitshift_operator] = ACTIONS(672),
    [sym__rational_operator] = ACTIONS(672),
    [sym__times_operator] = ACTIONS(674),
    [sym__plus_operator] = ACTIONS(674),
    [sym__dotty_operator] = ACTIONS(674),
    [sym__comparison_operator] = ACTIONS(674),
    [sym__arrow_operator] = ACTIONS(183),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(758),
    [sym__string_start] = ACTIONS(678),
    [sym__command_start] = ACTIONS(680),
  },
  [38] = {
    [sym_function_definition] = STATE(1415),
    [sym_abstract_definition] = STATE(1415),
    [sym_primitive_definition] = STATE(1415),
    [sym_struct_definition] = STATE(1415),
    [sym_module_definition] = STATE(1415),
    [sym_macro_definition] = STATE(1415),
    [sym_parameter_list] = STATE(3775),
    [sym_if_statement] = STATE(1415),
    [sym_try_statement] = STATE(1415),
    [sym_for_statement] = STATE(1415),
    [sym_while_statement] = STATE(1415),
    [sym_return_statement] = STATE(1415),
    [sym_let_statement] = STATE(1415),
    [sym_const_statement] = STATE(1415),
    [sym_quote_statement] = STATE(1415),
    [sym_import_statement] = STATE(1415),
    [sym_export_statement] = STATE(1415),
    [sym__expression] = STATE(1337),
    [sym__primary_expression] = STATE(1095),
    [sym_operator] = STATE(1224),
    [sym_parenthesized_expression] = STATE(1095),
    [sym_field_expression] = STATE(883),
    [sym_subscript_expression] = STATE(1095),
    [sym_typed_expression] = STATE(1415),
    [sym_parameterized_identifier] = STATE(1095),
    [sym_compound_expression] = STATE(1415),
    [sym_call_expression] = STATE(1095),
    [sym_broadcast_call_expression] = STATE(1095),
    [sym_macro_expression] = STATE(1415),
    [sym_spread_expression] = STATE(1415),
    [sym_unary_expression] = STATE(1415),
    [sym_binary_expression] = STATE(1415),
    [sym_ternary_expression] = STATE(1415),
    [sym_pair_expression] = STATE(1415),
    [sym_tuple_expression] = STATE(1095),
    [sym_array_expression] = STATE(1095),
    [sym_matrix_expression] = STATE(1095),
    [sym_generator_expression] = STATE(1415),
    [sym_array_comprehension_expression] = STATE(1095),
    [sym_function_expression] = STATE(1415),
    [sym_range_expression] = STATE(1415),
    [sym_coefficient_expression] = STATE(1415),
    [sym_quote_expression] = STATE(1415),
    [sym_interpolation_expression] = STATE(1415),
    [sym_macro_identifier] = STATE(12),
    [sym__literal] = STATE(1225),
    [sym_integer_literal] = STATE(1225),
    [sym_character_literal] = STATE(1225),
    [sym_string_literal] = STATE(1225),
    [sym_command_literal] = STATE(1225),
    [sym_prefixed_string_literal] = STATE(1225),
    [sym_prefixed_command_literal] = STATE(1225),
    [aux_sym_macro_argument_list_repeat1] = STATE(38),
    [sym_identifier] = ACTIONS(760),
    [anon_sym_function] = ACTIONS(763),
    [anon_sym_end] = ACTIONS(203),
    [anon_sym_abstract] = ACTIONS(766),
    [anon_sym_primitive] = ACTIONS(769),
    [aux_sym_primitive_definition_token1] = ACTIONS(772),
    [anon_sym_mutable] = ACTIONS(775),
    [anon_sym_struct] = ACTIONS(778),
    [anon_sym_module] = ACTIONS(781),
    [anon_sym_macro] = ACTIONS(784),
    [anon_sym_LPAREN] = ACTIONS(787),
    [anon_sym_COMMA] = ACTIONS(292),
    [anon_sym_RPAREN] = ACTIONS(292),
    [anon_sym_SEMI] = ACTIONS(292),
    [anon_sym_EQ] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(292),
    [anon_sym_COLON_COLON] = ACTIONS(292),
    [anon_sym_RBRACE] = ACTIONS(292),
    [anon_sym_LT_COLON] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(790),
    [anon_sym_try] = ACTIONS(793),
    [anon_sym_for] = ACTIONS(796),
    [anon_sym_while] = ACTIONS(799),
    [sym_break_statement] = ACTIONS(802),
    [sym_continue_statement] = ACTIONS(802),
    [anon_sym_return] = ACTIONS(805),
    [anon_sym_let] = ACTIONS(808),
    [anon_sym_const] = ACTIONS(811),
    [anon_sym_quote] = ACTIONS(814),
    [anon_sym_using] = ACTIONS(817),
    [anon_sym_import] = ACTIONS(817),
    [anon_sym_export] = ACTIONS(820),
    [anon_sym_COLON2] = ACTIONS(823),
    [anon_sym_RBRACK] = ACTIONS(292),
    [anon_sym_begin] = ACTIONS(826),
    [anon_sym_SQUOTE] = ACTIONS(829),
    [anon_sym_PLUS] = ACTIONS(203),
    [anon_sym_LT_PIPE] = ACTIONS(292),
    [anon_sym_PIPE_GT] = ACTIONS(292),
    [anon_sym_in] = ACTIONS(203),
    [anon_sym_isa] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(292),
    [anon_sym_AMP_AMP] = ACTIONS(292),
    [anon_sym_QMARK] = ACTIONS(292),
    [anon_sym_EQ_GT] = ACTIONS(292),
    [anon_sym_LBRACK2] = ACTIONS(832),
    [anon_sym_DOLLAR] = ACTIONS(835),
    [anon_sym_AT] = ACTIONS(838),
    [aux_sym_integer_literal_token1] = ACTIONS(841),
    [aux_sym_integer_literal_token2] = ACTIONS(841),
    [aux_sym_integer_literal_token3] = ACTIONS(844),
    [sym_float_literal] = ACTIONS(847),
    [sym__unary_operator] = ACTIONS(850),
    [sym__power_operator] = ACTIONS(853),
    [sym__bitshift_operator] = ACTIONS(853),
    [sym__rational_operator] = ACTIONS(853),
    [sym__times_operator] = ACTIONS(853),
    [sym__plus_operator] = ACTIONS(853),
    [sym__dotty_operator] = ACTIONS(853),
    [sym__comparison_operator] = ACTIONS(853),
    [sym__arrow_operator] = ACTIONS(292),
    [sym__assign_operator] = ACTIONS(203),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(856),
    [sym__command_start] = ACTIONS(859),
  },
  [39] = {
    [sym_function_definition] = STATE(2364),
    [sym_abstract_definition] = STATE(2364),
    [sym_primitive_definition] = STATE(2364),
    [sym_struct_definition] = STATE(2364),
    [sym_module_definition] = STATE(2364),
    [sym_macro_definition] = STATE(2364),
    [sym_parameter_list] = STATE(4021),
    [sym_if_statement] = STATE(2364),
    [sym_try_statement] = STATE(2364),
    [sym_for_statement] = STATE(2364),
    [sym_while_statement] = STATE(2364),
    [sym_return_statement] = STATE(2364),
    [sym_let_statement] = STATE(2364),
    [sym_const_statement] = STATE(2364),
    [sym_quote_statement] = STATE(2364),
    [sym_import_statement] = STATE(2364),
    [sym_export_statement] = STATE(2364),
    [sym__expression] = STATE(2376),
    [sym__primary_expression] = STATE(2049),
    [sym_operator] = STATE(2271),
    [sym_parenthesized_expression] = STATE(2049),
    [sym_field_expression] = STATE(2002),
    [sym_subscript_expression] = STATE(2049),
    [sym_typed_expression] = STATE(2364),
    [sym_parameterized_identifier] = STATE(2049),
    [sym_compound_expression] = STATE(2364),
    [sym_call_expression] = STATE(2049),
    [sym_broadcast_call_expression] = STATE(2049),
    [sym_macro_expression] = STATE(2364),
    [sym_spread_expression] = STATE(2364),
    [sym_unary_expression] = STATE(2364),
    [sym_binary_expression] = STATE(2364),
    [sym_ternary_expression] = STATE(2364),
    [sym_pair_expression] = STATE(2364),
    [sym_tuple_expression] = STATE(2049),
    [sym_array_expression] = STATE(2049),
    [sym_matrix_expression] = STATE(2049),
    [sym_generator_expression] = STATE(2364),
    [sym_array_comprehension_expression] = STATE(2049),
    [sym_function_expression] = STATE(2364),
    [sym_range_expression] = STATE(2364),
    [sym_coefficient_expression] = STATE(2364),
    [sym_quote_expression] = STATE(2364),
    [sym_interpolation_expression] = STATE(2364),
    [sym_macro_identifier] = STATE(18),
    [sym__literal] = STATE(2274),
    [sym_integer_literal] = STATE(2274),
    [sym_character_literal] = STATE(2274),
    [sym_string_literal] = STATE(2274),
    [sym_command_literal] = STATE(2274),
    [sym_prefixed_string_literal] = STATE(2274),
    [sym_prefixed_command_literal] = STATE(2274),
    [sym_identifier] = ACTIONS(682),
    [anon_sym_function] = ACTIONS(684),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(686),
    [anon_sym_primitive] = ACTIONS(688),
    [aux_sym_primitive_definition_token1] = ACTIONS(690),
    [anon_sym_mutable] = ACTIONS(692),
    [anon_sym_struct] = ACTIONS(694),
    [anon_sym_module] = ACTIONS(696),
    [anon_sym_macro] = ACTIONS(698),
    [anon_sym_LPAREN] = ACTIONS(700),
    [anon_sym_COMMA] = ACTIONS(306),
    [anon_sym_RPAREN] = ACTIONS(306),
    [anon_sym_SEMI] = ACTIONS(306),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(306),
    [anon_sym_COLON_COLON] = ACTIONS(306),
    [anon_sym_RBRACE] = ACTIONS(306),
    [anon_sym_LT_COLON] = ACTIONS(306),
    [anon_sym_if] = ACTIONS(702),
    [anon_sym_try] = ACTIONS(704),
    [anon_sym_for] = ACTIONS(706),
    [anon_sym_while] = ACTIONS(708),
    [sym_break_statement] = ACTIONS(710),
    [sym_continue_statement] = ACTIONS(710),
    [anon_sym_return] = ACTIONS(712),
    [anon_sym_let] = ACTIONS(714),
    [anon_sym_const] = ACTIONS(716),
    [anon_sym_quote] = ACTIONS(718),
    [anon_sym_using] = ACTIONS(720),
    [anon_sym_import] = ACTIONS(720),
    [anon_sym_export] = ACTIONS(722),
    [anon_sym_COLON2] = ACTIONS(724),
    [anon_sym_RBRACK] = ACTIONS(306),
    [anon_sym_begin] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(306),
    [anon_sym_PIPE_GT] = ACTIONS(306),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(306),
    [anon_sym_AMP_AMP] = ACTIONS(306),
    [anon_sym_QMARK] = ACTIONS(306),
    [anon_sym_EQ_GT] = ACTIONS(306),
    [anon_sym_LBRACK2] = ACTIONS(730),
    [anon_sym_DOLLAR] = ACTIONS(732),
    [anon_sym_AT] = ACTIONS(410),
    [aux_sym_integer_literal_token1] = ACTIONS(734),
    [aux_sym_integer_literal_token2] = ACTIONS(734),
    [aux_sym_integer_literal_token3] = ACTIONS(736),
    [sym_float_literal] = ACTIONS(738),
    [sym__unary_operator] = ACTIONS(740),
    [sym__power_operator] = ACTIONS(742),
    [sym__bitshift_operator] = ACTIONS(742),
    [sym__rational_operator] = ACTIONS(742),
    [sym__times_operator] = ACTIONS(742),
    [sym__plus_operator] = ACTIONS(742),
    [sym__dotty_operator] = ACTIONS(742),
    [sym__comparison_operator] = ACTIONS(742),
    [sym__arrow_operator] = ACTIONS(306),
    [sym__assign_operator] = ACTIONS(304),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(744),
    [sym__command_start] = ACTIONS(746),
  },
  [40] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(4236),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1897),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(42),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [sym_identifier] = ACTIONS(476),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LT_COLON] = ACTIONS(304),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(304),
    [anon_sym_else] = ACTIONS(304),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(518),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(304),
    [anon_sym_PIPE_GT] = ACTIONS(304),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_EQ_GT] = ACTIONS(304),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(534),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(304),
    [sym__assign_operator] = ACTIONS(304),
    [anon_sym_LF] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [41] = {
    [sym_function_definition] = STATE(1081),
    [sym_abstract_definition] = STATE(1081),
    [sym_primitive_definition] = STATE(1081),
    [sym_struct_definition] = STATE(1081),
    [sym_module_definition] = STATE(1081),
    [sym_macro_definition] = STATE(1081),
    [sym_parameter_list] = STATE(3954),
    [sym_if_statement] = STATE(1081),
    [sym_try_statement] = STATE(1081),
    [sym_for_statement] = STATE(1081),
    [sym_while_statement] = STATE(1081),
    [sym_return_statement] = STATE(1081),
    [sym_let_statement] = STATE(1081),
    [sym_const_statement] = STATE(1081),
    [sym_quote_statement] = STATE(1081),
    [sym_import_statement] = STATE(1081),
    [sym_export_statement] = STATE(1081),
    [sym__expression] = STATE(1413),
    [sym__primary_expression] = STATE(870),
    [sym_operator] = STATE(919),
    [sym_parenthesized_expression] = STATE(870),
    [sym_field_expression] = STATE(818),
    [sym_subscript_expression] = STATE(870),
    [sym_typed_expression] = STATE(1081),
    [sym_parameterized_identifier] = STATE(870),
    [sym_compound_expression] = STATE(1081),
    [sym_call_expression] = STATE(870),
    [sym_broadcast_call_expression] = STATE(870),
    [sym_macro_expression] = STATE(1081),
    [sym_spread_expression] = STATE(1081),
    [sym_unary_expression] = STATE(1081),
    [sym_binary_expression] = STATE(1081),
    [sym_ternary_expression] = STATE(1081),
    [sym_pair_expression] = STATE(1081),
    [sym_tuple_expression] = STATE(870),
    [sym_array_expression] = STATE(870),
    [sym_matrix_expression] = STATE(870),
    [sym_generator_expression] = STATE(1081),
    [sym_array_comprehension_expression] = STATE(870),
    [sym_function_expression] = STATE(1081),
    [sym_range_expression] = STATE(1081),
    [sym_coefficient_expression] = STATE(1081),
    [sym_quote_expression] = STATE(1081),
    [sym_interpolation_expression] = STATE(1081),
    [sym_macro_identifier] = STATE(4),
    [sym__literal] = STATE(894),
    [sym_integer_literal] = STATE(894),
    [sym_character_literal] = STATE(894),
    [sym_string_literal] = STATE(894),
    [sym_command_literal] = STATE(894),
    [sym_prefixed_string_literal] = STATE(894),
    [sym_prefixed_command_literal] = STATE(894),
    [sym_identifier] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(123),
    [anon_sym_end] = ACTIONS(466),
    [anon_sym_abstract] = ACTIONS(127),
    [anon_sym_primitive] = ACTIONS(129),
    [aux_sym_primitive_definition_token1] = ACTIONS(131),
    [anon_sym_mutable] = ACTIONS(133),
    [anon_sym_struct] = ACTIONS(135),
    [anon_sym_module] = ACTIONS(137),
    [anon_sym_macro] = ACTIONS(139),
    [anon_sym_LPAREN] = ACTIONS(141),
    [anon_sym_COMMA] = ACTIONS(466),
    [anon_sym_SEMI] = ACTIONS(466),
    [anon_sym_EQ] = ACTIONS(466),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(466),
    [anon_sym_COLON_COLON] = ACTIONS(466),
    [anon_sym_LT_COLON] = ACTIONS(466),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_elseif] = ACTIONS(466),
    [anon_sym_else] = ACTIONS(466),
    [anon_sym_try] = ACTIONS(145),
    [anon_sym_for] = ACTIONS(147),
    [anon_sym_while] = ACTIONS(149),
    [sym_break_statement] = ACTIONS(151),
    [sym_continue_statement] = ACTIONS(151),
    [anon_sym_return] = ACTIONS(153),
    [anon_sym_let] = ACTIONS(155),
    [anon_sym_const] = ACTIONS(157),
    [anon_sym_quote] = ACTIONS(159),
    [anon_sym_using] = ACTIONS(161),
    [anon_sym_import] = ACTIONS(161),
    [anon_sym_export] = ACTIONS(163),
    [anon_sym_COLON2] = ACTIONS(165),
    [anon_sym_begin] = ACTIONS(167),
    [anon_sym_SQUOTE] = ACTIONS(169),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_LT_PIPE] = ACTIONS(466),
    [anon_sym_PIPE_GT] = ACTIONS(466),
    [anon_sym_in] = ACTIONS(466),
    [anon_sym_isa] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(466),
    [anon_sym_AMP_AMP] = ACTIONS(466),
    [anon_sym_QMARK] = ACTIONS(466),
    [anon_sym_EQ_GT] = ACTIONS(466),
    [anon_sym_LBRACK2] = ACTIONS(171),
    [anon_sym_DOLLAR] = ACTIONS(173),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(175),
    [aux_sym_integer_literal_token2] = ACTIONS(175),
    [aux_sym_integer_literal_token3] = ACTIONS(175),
    [sym_float_literal] = ACTIONS(177),
    [sym__unary_operator] = ACTIONS(179),
    [sym__power_operator] = ACTIONS(181),
    [sym__bitshift_operator] = ACTIONS(181),
    [sym__rational_operator] = ACTIONS(181),
    [sym__times_operator] = ACTIONS(181),
    [sym__plus_operator] = ACTIONS(181),
    [sym__dotty_operator] = ACTIONS(181),
    [sym__comparison_operator] = ACTIONS(181),
    [sym__arrow_operator] = ACTIONS(466),
    [sym__assign_operator] = ACTIONS(466),
    [anon_sym_LF] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(187),
    [sym__command_start] = ACTIONS(189),
  },
  [42] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(4236),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1893),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_macro_argument_list] = STATE(1722),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(42),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [aux_sym_macro_argument_list_repeat1] = STATE(67),
    [sym_identifier] = ACTIONS(476),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(125),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(125),
    [anon_sym_COLON_COLON] = ACTIONS(125),
    [anon_sym_LT_COLON] = ACTIONS(125),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(125),
    [anon_sym_else] = ACTIONS(125),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(518),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_LT_PIPE] = ACTIONS(125),
    [anon_sym_PIPE_GT] = ACTIONS(125),
    [anon_sym_in] = ACTIONS(125),
    [anon_sym_isa] = ACTIONS(125),
    [anon_sym_PIPE_PIPE] = ACTIONS(125),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_QMARK] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(534),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(125),
    [anon_sym_LF] = ACTIONS(183),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(756),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [43] = {
    [sym_function_definition] = STATE(2364),
    [sym_abstract_definition] = STATE(2364),
    [sym_primitive_definition] = STATE(2364),
    [sym_struct_definition] = STATE(2364),
    [sym_module_definition] = STATE(2364),
    [sym_macro_definition] = STATE(2364),
    [sym_parameter_list] = STATE(4021),
    [sym_if_statement] = STATE(2364),
    [sym_try_statement] = STATE(2364),
    [sym_for_statement] = STATE(2364),
    [sym_while_statement] = STATE(2364),
    [sym_return_statement] = STATE(2364),
    [sym_let_statement] = STATE(2364),
    [sym_const_statement] = STATE(2364),
    [sym_quote_statement] = STATE(2364),
    [sym_import_statement] = STATE(2364),
    [sym_export_statement] = STATE(2364),
    [sym__expression] = STATE(2381),
    [sym__primary_expression] = STATE(2049),
    [sym_operator] = STATE(2271),
    [sym_parenthesized_expression] = STATE(2049),
    [sym_field_expression] = STATE(2002),
    [sym_subscript_expression] = STATE(2049),
    [sym_typed_expression] = STATE(2364),
    [sym_parameterized_identifier] = STATE(2049),
    [sym_compound_expression] = STATE(2364),
    [sym_call_expression] = STATE(2049),
    [sym_broadcast_call_expression] = STATE(2049),
    [sym_macro_expression] = STATE(2364),
    [sym_spread_expression] = STATE(2364),
    [sym_unary_expression] = STATE(2364),
    [sym_binary_expression] = STATE(2364),
    [sym_ternary_expression] = STATE(2364),
    [sym_pair_expression] = STATE(2364),
    [sym_tuple_expression] = STATE(2049),
    [sym_array_expression] = STATE(2049),
    [sym_matrix_expression] = STATE(2049),
    [sym_generator_expression] = STATE(2364),
    [sym_array_comprehension_expression] = STATE(2049),
    [sym_function_expression] = STATE(2364),
    [sym_range_expression] = STATE(2364),
    [sym_coefficient_expression] = STATE(2364),
    [sym_quote_expression] = STATE(2364),
    [sym_interpolation_expression] = STATE(2364),
    [sym_macro_identifier] = STATE(18),
    [sym__literal] = STATE(2274),
    [sym_integer_literal] = STATE(2274),
    [sym_character_literal] = STATE(2274),
    [sym_string_literal] = STATE(2274),
    [sym_command_literal] = STATE(2274),
    [sym_prefixed_string_literal] = STATE(2274),
    [sym_prefixed_command_literal] = STATE(2274),
    [sym_identifier] = ACTIONS(682),
    [anon_sym_function] = ACTIONS(684),
    [anon_sym_end] = ACTIONS(466),
    [anon_sym_abstract] = ACTIONS(686),
    [anon_sym_primitive] = ACTIONS(688),
    [aux_sym_primitive_definition_token1] = ACTIONS(690),
    [anon_sym_mutable] = ACTIONS(692),
    [anon_sym_struct] = ACTIONS(694),
    [anon_sym_module] = ACTIONS(696),
    [anon_sym_macro] = ACTIONS(698),
    [anon_sym_LPAREN] = ACTIONS(700),
    [anon_sym_COMMA] = ACTIONS(468),
    [anon_sym_RPAREN] = ACTIONS(468),
    [anon_sym_SEMI] = ACTIONS(468),
    [anon_sym_EQ] = ACTIONS(466),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(468),
    [anon_sym_COLON_COLON] = ACTIONS(468),
    [anon_sym_RBRACE] = ACTIONS(468),
    [anon_sym_LT_COLON] = ACTIONS(468),
    [anon_sym_if] = ACTIONS(702),
    [anon_sym_try] = ACTIONS(704),
    [anon_sym_for] = ACTIONS(706),
    [anon_sym_while] = ACTIONS(708),
    [sym_break_statement] = ACTIONS(710),
    [sym_continue_statement] = ACTIONS(710),
    [anon_sym_return] = ACTIONS(712),
    [anon_sym_let] = ACTIONS(714),
    [anon_sym_const] = ACTIONS(716),
    [anon_sym_quote] = ACTIONS(718),
    [anon_sym_using] = ACTIONS(720),
    [anon_sym_import] = ACTIONS(720),
    [anon_sym_export] = ACTIONS(722),
    [anon_sym_COLON2] = ACTIONS(724),
    [anon_sym_RBRACK] = ACTIONS(468),
    [anon_sym_begin] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_LT_PIPE] = ACTIONS(468),
    [anon_sym_PIPE_GT] = ACTIONS(468),
    [anon_sym_in] = ACTIONS(466),
    [anon_sym_isa] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(468),
    [anon_sym_AMP_AMP] = ACTIONS(468),
    [anon_sym_QMARK] = ACTIONS(468),
    [anon_sym_EQ_GT] = ACTIONS(468),
    [anon_sym_LBRACK2] = ACTIONS(730),
    [anon_sym_DOLLAR] = ACTIONS(732),
    [anon_sym_AT] = ACTIONS(410),
    [aux_sym_integer_literal_token1] = ACTIONS(734),
    [aux_sym_integer_literal_token2] = ACTIONS(734),
    [aux_sym_integer_literal_token3] = ACTIONS(736),
    [sym_float_literal] = ACTIONS(738),
    [sym__unary_operator] = ACTIONS(740),
    [sym__power_operator] = ACTIONS(742),
    [sym__bitshift_operator] = ACTIONS(742),
    [sym__rational_operator] = ACTIONS(742),
    [sym__times_operator] = ACTIONS(742),
    [sym__plus_operator] = ACTIONS(742),
    [sym__dotty_operator] = ACTIONS(742),
    [sym__comparison_operator] = ACTIONS(742),
    [sym__arrow_operator] = ACTIONS(468),
    [sym__assign_operator] = ACTIONS(466),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(744),
    [sym__command_start] = ACTIONS(746),
  },
  [44] = {
    [sym_function_definition] = STATE(1415),
    [sym_abstract_definition] = STATE(1415),
    [sym_primitive_definition] = STATE(1415),
    [sym_struct_definition] = STATE(1415),
    [sym_module_definition] = STATE(1415),
    [sym_macro_definition] = STATE(1415),
    [sym_parameter_list] = STATE(3775),
    [sym_if_statement] = STATE(1415),
    [sym_try_statement] = STATE(1415),
    [sym_for_statement] = STATE(1415),
    [sym_while_statement] = STATE(1415),
    [sym_return_statement] = STATE(1415),
    [sym_let_statement] = STATE(1415),
    [sym_const_statement] = STATE(1415),
    [sym_quote_statement] = STATE(1415),
    [sym_import_statement] = STATE(1415),
    [sym_export_statement] = STATE(1415),
    [sym__expression] = STATE(1396),
    [sym__primary_expression] = STATE(1095),
    [sym_operator] = STATE(1224),
    [sym_parenthesized_expression] = STATE(1095),
    [sym_field_expression] = STATE(883),
    [sym_subscript_expression] = STATE(1095),
    [sym_typed_expression] = STATE(1415),
    [sym_parameterized_identifier] = STATE(1095),
    [sym_compound_expression] = STATE(1415),
    [sym_call_expression] = STATE(1095),
    [sym_broadcast_call_expression] = STATE(1095),
    [sym_macro_expression] = STATE(1415),
    [sym_spread_expression] = STATE(1415),
    [sym_unary_expression] = STATE(1415),
    [sym_binary_expression] = STATE(1415),
    [sym_ternary_expression] = STATE(1415),
    [sym_pair_expression] = STATE(1415),
    [sym_tuple_expression] = STATE(1095),
    [sym_array_expression] = STATE(1095),
    [sym_matrix_expression] = STATE(1095),
    [sym_generator_expression] = STATE(1415),
    [sym_array_comprehension_expression] = STATE(1095),
    [sym_function_expression] = STATE(1415),
    [sym_range_expression] = STATE(1415),
    [sym_coefficient_expression] = STATE(1415),
    [sym_quote_expression] = STATE(1415),
    [sym_interpolation_expression] = STATE(1415),
    [sym_macro_identifier] = STATE(12),
    [sym__literal] = STATE(1225),
    [sym_integer_literal] = STATE(1225),
    [sym_character_literal] = STATE(1225),
    [sym_string_literal] = STATE(1225),
    [sym_command_literal] = STATE(1225),
    [sym_prefixed_string_literal] = STATE(1225),
    [sym_prefixed_command_literal] = STATE(1225),
    [sym_identifier] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_end] = ACTIONS(466),
    [anon_sym_abstract] = ACTIONS(362),
    [anon_sym_primitive] = ACTIONS(364),
    [aux_sym_primitive_definition_token1] = ACTIONS(366),
    [anon_sym_mutable] = ACTIONS(368),
    [anon_sym_struct] = ACTIONS(370),
    [anon_sym_module] = ACTIONS(372),
    [anon_sym_macro] = ACTIONS(374),
    [anon_sym_LPAREN] = ACTIONS(376),
    [anon_sym_COMMA] = ACTIONS(468),
    [anon_sym_RPAREN] = ACTIONS(468),
    [anon_sym_SEMI] = ACTIONS(468),
    [anon_sym_EQ] = ACTIONS(466),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(468),
    [anon_sym_COLON_COLON] = ACTIONS(468),
    [anon_sym_RBRACE] = ACTIONS(468),
    [anon_sym_LT_COLON] = ACTIONS(468),
    [anon_sym_if] = ACTIONS(378),
    [anon_sym_try] = ACTIONS(380),
    [anon_sym_for] = ACTIONS(382),
    [anon_sym_while] = ACTIONS(384),
    [sym_break_statement] = ACTIONS(386),
    [sym_continue_statement] = ACTIONS(386),
    [anon_sym_return] = ACTIONS(388),
    [anon_sym_let] = ACTIONS(390),
    [anon_sym_const] = ACTIONS(392),
    [anon_sym_quote] = ACTIONS(394),
    [anon_sym_using] = ACTIONS(396),
    [anon_sym_import] = ACTIONS(396),
    [anon_sym_export] = ACTIONS(398),
    [anon_sym_COLON2] = ACTIONS(400),
    [anon_sym_RBRACK] = ACTIONS(468),
    [anon_sym_begin] = ACTIONS(402),
    [anon_sym_SQUOTE] = ACTIONS(404),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_LT_PIPE] = ACTIONS(468),
    [anon_sym_PIPE_GT] = ACTIONS(468),
    [anon_sym_in] = ACTIONS(466),
    [anon_sym_isa] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(468),
    [anon_sym_AMP_AMP] = ACTIONS(468),
    [anon_sym_QMARK] = ACTIONS(468),
    [anon_sym_EQ_GT] = ACTIONS(468),
    [anon_sym_LBRACK2] = ACTIONS(406),
    [anon_sym_DOLLAR] = ACTIONS(408),
    [anon_sym_AT] = ACTIONS(410),
    [aux_sym_integer_literal_token1] = ACTIONS(412),
    [aux_sym_integer_literal_token2] = ACTIONS(412),
    [aux_sym_integer_literal_token3] = ACTIONS(414),
    [sym_float_literal] = ACTIONS(416),
    [sym__unary_operator] = ACTIONS(418),
    [sym__power_operator] = ACTIONS(420),
    [sym__bitshift_operator] = ACTIONS(420),
    [sym__rational_operator] = ACTIONS(420),
    [sym__times_operator] = ACTIONS(420),
    [sym__plus_operator] = ACTIONS(420),
    [sym__dotty_operator] = ACTIONS(420),
    [sym__comparison_operator] = ACTIONS(420),
    [sym__arrow_operator] = ACTIONS(468),
    [sym__assign_operator] = ACTIONS(466),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(424),
    [sym__command_start] = ACTIONS(426),
  },
  [45] = {
    [sym__expression_list] = STATE(3395),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(862),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(864),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_elseif] = ACTIONS(862),
    [anon_sym_else] = ACTIONS(862),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(866),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [46] = {
    [sym_function_definition] = STATE(2557),
    [sym_abstract_definition] = STATE(2557),
    [sym_primitive_definition] = STATE(2557),
    [sym_struct_definition] = STATE(2557),
    [sym_module_definition] = STATE(2557),
    [sym_macro_definition] = STATE(2557),
    [sym_parameter_list] = STATE(3815),
    [sym_if_statement] = STATE(2557),
    [sym_try_statement] = STATE(2557),
    [sym_for_statement] = STATE(2557),
    [sym_while_statement] = STATE(2557),
    [sym_return_statement] = STATE(2557),
    [sym_let_statement] = STATE(2557),
    [sym_const_statement] = STATE(2557),
    [sym_quote_statement] = STATE(2557),
    [sym_import_statement] = STATE(2557),
    [sym_export_statement] = STATE(2557),
    [sym__expression] = STATE(2473),
    [sym__primary_expression] = STATE(2256),
    [sym_bare_tuple_expression] = STATE(2531),
    [sym_operator] = STATE(2451),
    [sym_parenthesized_expression] = STATE(2256),
    [sym_field_expression] = STATE(2089),
    [sym_subscript_expression] = STATE(2256),
    [sym_typed_expression] = STATE(2557),
    [sym_parameterized_identifier] = STATE(2256),
    [sym_compound_expression] = STATE(2557),
    [sym_call_expression] = STATE(2256),
    [sym_broadcast_call_expression] = STATE(2256),
    [sym_macro_expression] = STATE(2557),
    [sym_spread_expression] = STATE(2557),
    [sym_unary_expression] = STATE(2557),
    [sym_binary_expression] = STATE(2557),
    [sym_ternary_expression] = STATE(2557),
    [sym_pair_expression] = STATE(2557),
    [sym_tuple_expression] = STATE(2256),
    [sym_array_expression] = STATE(2256),
    [sym_matrix_expression] = STATE(2256),
    [sym_generator_expression] = STATE(2557),
    [sym_array_comprehension_expression] = STATE(2256),
    [sym_function_expression] = STATE(2557),
    [sym_range_expression] = STATE(2557),
    [sym_coefficient_expression] = STATE(2557),
    [sym_quote_expression] = STATE(2557),
    [sym_interpolation_expression] = STATE(2557),
    [sym_macro_identifier] = STATE(37),
    [sym__literal] = STATE(2449),
    [sym_integer_literal] = STATE(2449),
    [sym_character_literal] = STATE(2449),
    [sym_string_literal] = STATE(2449),
    [sym_command_literal] = STATE(2449),
    [sym_prefixed_string_literal] = STATE(2449),
    [sym_prefixed_command_literal] = STATE(2449),
    [sym_identifier] = ACTIONS(868),
    [anon_sym_function] = ACTIONS(870),
    [anon_sym_end] = ACTIONS(300),
    [anon_sym_abstract] = ACTIONS(872),
    [anon_sym_primitive] = ACTIONS(874),
    [aux_sym_primitive_definition_token1] = ACTIONS(876),
    [anon_sym_mutable] = ACTIONS(878),
    [anon_sym_struct] = ACTIONS(880),
    [anon_sym_module] = ACTIONS(882),
    [anon_sym_macro] = ACTIONS(884),
    [anon_sym_LPAREN] = ACTIONS(886),
    [anon_sym_COMMA] = ACTIONS(302),
    [anon_sym_RPAREN] = ACTIONS(302),
    [anon_sym_SEMI] = ACTIONS(302),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(302),
    [anon_sym_COLON_COLON] = ACTIONS(302),
    [anon_sym_RBRACE] = ACTIONS(302),
    [anon_sym_LT_COLON] = ACTIONS(302),
    [anon_sym_if] = ACTIONS(888),
    [anon_sym_try] = ACTIONS(890),
    [anon_sym_for] = ACTIONS(892),
    [anon_sym_while] = ACTIONS(894),
    [sym_break_statement] = ACTIONS(896),
    [sym_continue_statement] = ACTIONS(896),
    [anon_sym_return] = ACTIONS(898),
    [anon_sym_let] = ACTIONS(900),
    [anon_sym_const] = ACTIONS(902),
    [anon_sym_quote] = ACTIONS(904),
    [anon_sym_using] = ACTIONS(906),
    [anon_sym_import] = ACTIONS(906),
    [anon_sym_export] = ACTIONS(908),
    [anon_sym_COLON2] = ACTIONS(910),
    [anon_sym_RBRACK] = ACTIONS(302),
    [anon_sym_begin] = ACTIONS(912),
    [anon_sym_SQUOTE] = ACTIONS(914),
    [anon_sym_PLUS] = ACTIONS(300),
    [anon_sym_LT_PIPE] = ACTIONS(302),
    [anon_sym_PIPE_GT] = ACTIONS(302),
    [anon_sym_in] = ACTIONS(300),
    [anon_sym_isa] = ACTIONS(300),
    [anon_sym_PIPE_PIPE] = ACTIONS(302),
    [anon_sym_AMP_AMP] = ACTIONS(302),
    [anon_sym_QMARK] = ACTIONS(302),
    [anon_sym_EQ_GT] = ACTIONS(302),
    [anon_sym_LBRACK2] = ACTIONS(916),
    [anon_sym_DOLLAR] = ACTIONS(918),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(920),
    [aux_sym_integer_literal_token2] = ACTIONS(920),
    [aux_sym_integer_literal_token3] = ACTIONS(922),
    [sym_float_literal] = ACTIONS(924),
    [sym__unary_operator] = ACTIONS(926),
    [sym__power_operator] = ACTIONS(928),
    [sym__bitshift_operator] = ACTIONS(928),
    [sym__rational_operator] = ACTIONS(928),
    [sym__times_operator] = ACTIONS(930),
    [sym__plus_operator] = ACTIONS(930),
    [sym__dotty_operator] = ACTIONS(930),
    [sym__comparison_operator] = ACTIONS(930),
    [sym__arrow_operator] = ACTIONS(302),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(932),
    [sym__command_start] = ACTIONS(934),
  },
  [47] = {
    [sym_function_definition] = STATE(1713),
    [sym_abstract_definition] = STATE(1713),
    [sym_primitive_definition] = STATE(1713),
    [sym_struct_definition] = STATE(1713),
    [sym_module_definition] = STATE(1713),
    [sym_macro_definition] = STATE(1713),
    [sym_parameter_list] = STATE(4089),
    [sym_if_statement] = STATE(1713),
    [sym_try_statement] = STATE(1713),
    [sym_for_statement] = STATE(1713),
    [sym_while_statement] = STATE(1713),
    [sym_return_statement] = STATE(1713),
    [sym_let_statement] = STATE(1713),
    [sym_const_statement] = STATE(1713),
    [sym_quote_statement] = STATE(1713),
    [sym_import_statement] = STATE(1713),
    [sym_export_statement] = STATE(1713),
    [sym__expression] = STATE(1860),
    [sym__primary_expression] = STATE(1243),
    [sym_operator] = STATE(1492),
    [sym_parenthesized_expression] = STATE(1243),
    [sym_field_expression] = STATE(1012),
    [sym_subscript_expression] = STATE(1243),
    [sym_typed_expression] = STATE(1713),
    [sym_parameterized_identifier] = STATE(1243),
    [sym_compound_expression] = STATE(1713),
    [sym_call_expression] = STATE(1243),
    [sym_broadcast_call_expression] = STATE(1243),
    [sym_macro_expression] = STATE(1713),
    [sym_spread_expression] = STATE(1713),
    [sym_unary_expression] = STATE(1713),
    [sym_binary_expression] = STATE(1713),
    [sym_ternary_expression] = STATE(1713),
    [sym_pair_expression] = STATE(1713),
    [sym_tuple_expression] = STATE(1243),
    [sym_array_expression] = STATE(1243),
    [sym_matrix_expression] = STATE(1243),
    [sym_generator_expression] = STATE(1713),
    [sym_array_comprehension_expression] = STATE(1243),
    [sym_function_expression] = STATE(1713),
    [sym_range_expression] = STATE(1713),
    [sym_coefficient_expression] = STATE(1713),
    [sym_quote_expression] = STATE(1713),
    [sym_interpolation_expression] = STATE(1713),
    [sym_macro_identifier] = STATE(27),
    [sym__literal] = STATE(1494),
    [sym_integer_literal] = STATE(1494),
    [sym_character_literal] = STATE(1494),
    [sym_string_literal] = STATE(1494),
    [sym_command_literal] = STATE(1494),
    [sym_prefixed_string_literal] = STATE(1494),
    [sym_prefixed_command_literal] = STATE(1494),
    [aux_sym_macro_argument_list_repeat1] = STATE(55),
    [ts_builtin_sym_end] = ACTIONS(195),
    [sym_identifier] = ACTIONS(542),
    [anon_sym_function] = ACTIONS(544),
    [anon_sym_abstract] = ACTIONS(546),
    [anon_sym_primitive] = ACTIONS(548),
    [aux_sym_primitive_definition_token1] = ACTIONS(550),
    [anon_sym_mutable] = ACTIONS(552),
    [anon_sym_struct] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(556),
    [anon_sym_macro] = ACTIONS(558),
    [anon_sym_LPAREN] = ACTIONS(560),
    [anon_sym_COMMA] = ACTIONS(193),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym_EQ] = ACTIONS(193),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [anon_sym_LT_COLON] = ACTIONS(193),
    [anon_sym_if] = ACTIONS(562),
    [anon_sym_try] = ACTIONS(564),
    [anon_sym_for] = ACTIONS(566),
    [anon_sym_while] = ACTIONS(568),
    [sym_break_statement] = ACTIONS(570),
    [sym_continue_statement] = ACTIONS(570),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_let] = ACTIONS(574),
    [anon_sym_const] = ACTIONS(576),
    [anon_sym_quote] = ACTIONS(578),
    [anon_sym_using] = ACTIONS(580),
    [anon_sym_import] = ACTIONS(580),
    [anon_sym_export] = ACTIONS(582),
    [anon_sym_COLON2] = ACTIONS(584),
    [anon_sym_begin] = ACTIONS(586),
    [anon_sym_SQUOTE] = ACTIONS(588),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_in] = ACTIONS(193),
    [anon_sym_isa] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_QMARK] = ACTIONS(193),
    [anon_sym_EQ_GT] = ACTIONS(193),
    [anon_sym_LBRACK2] = ACTIONS(590),
    [anon_sym_DOLLAR] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(594),
    [aux_sym_integer_literal_token1] = ACTIONS(596),
    [aux_sym_integer_literal_token2] = ACTIONS(596),
    [aux_sym_integer_literal_token3] = ACTIONS(596),
    [sym_float_literal] = ACTIONS(598),
    [sym__unary_operator] = ACTIONS(600),
    [sym__power_operator] = ACTIONS(602),
    [sym__bitshift_operator] = ACTIONS(602),
    [sym__rational_operator] = ACTIONS(602),
    [sym__times_operator] = ACTIONS(602),
    [sym__plus_operator] = ACTIONS(602),
    [sym__dotty_operator] = ACTIONS(602),
    [sym__comparison_operator] = ACTIONS(602),
    [sym__arrow_operator] = ACTIONS(193),
    [sym__assign_operator] = ACTIONS(193),
    [anon_sym_LF] = ACTIONS(195),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(604),
    [sym__command_start] = ACTIONS(606),
  },
  [48] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(3882),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1800),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(33),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [aux_sym_macro_argument_list_repeat1] = STATE(57),
    [sym_identifier] = ACTIONS(748),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(193),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(193),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [anon_sym_LT_COLON] = ACTIONS(193),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(193),
    [anon_sym_else] = ACTIONS(193),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(750),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_in] = ACTIONS(193),
    [anon_sym_isa] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_QMARK] = ACTIONS(193),
    [anon_sym_EQ_GT] = ACTIONS(193),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(752),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(754),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(193),
    [anon_sym_LF] = ACTIONS(195),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [49] = {
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4197),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2149),
    [sym__primary_expression] = STATE(1995),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(26),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [ts_builtin_sym_end] = ACTIONS(306),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(15),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LT_COLON] = ACTIONS(304),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(37),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(41),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(936),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(304),
    [anon_sym_PIPE_GT] = ACTIONS(304),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_EQ_GT] = ACTIONS(304),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(594),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(65),
    [sym__unary_operator] = ACTIONS(67),
    [sym__power_operator] = ACTIONS(71),
    [sym__bitshift_operator] = ACTIONS(71),
    [sym__rational_operator] = ACTIONS(71),
    [sym__times_operator] = ACTIONS(71),
    [sym__plus_operator] = ACTIONS(71),
    [sym__dotty_operator] = ACTIONS(71),
    [sym__comparison_operator] = ACTIONS(71),
    [sym__arrow_operator] = ACTIONS(304),
    [sym__assign_operator] = ACTIONS(304),
    [anon_sym_LF] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [50] = {
    [sym_function_definition] = STATE(1855),
    [sym_abstract_definition] = STATE(1855),
    [sym_primitive_definition] = STATE(1855),
    [sym_struct_definition] = STATE(1855),
    [sym_module_definition] = STATE(1855),
    [sym_macro_definition] = STATE(1855),
    [sym_parameter_list] = STATE(4171),
    [sym_if_statement] = STATE(1855),
    [sym_try_statement] = STATE(1855),
    [sym_for_statement] = STATE(1855),
    [sym_while_statement] = STATE(1855),
    [sym_return_statement] = STATE(1855),
    [sym_let_statement] = STATE(1855),
    [sym_const_statement] = STATE(1855),
    [sym_quote_statement] = STATE(1855),
    [sym_import_statement] = STATE(1855),
    [sym_export_statement] = STATE(1855),
    [sym__expression] = STATE(1685),
    [sym__primary_expression] = STATE(1237),
    [sym_operator] = STATE(1461),
    [sym_parenthesized_expression] = STATE(1237),
    [sym_field_expression] = STATE(1088),
    [sym_subscript_expression] = STATE(1237),
    [sym_typed_expression] = STATE(1855),
    [sym_parameterized_identifier] = STATE(1237),
    [sym_compound_expression] = STATE(1855),
    [sym_call_expression] = STATE(1237),
    [sym_broadcast_call_expression] = STATE(1237),
    [sym_macro_expression] = STATE(1855),
    [sym_spread_expression] = STATE(1855),
    [sym_unary_expression] = STATE(1855),
    [sym_binary_expression] = STATE(1855),
    [sym_ternary_expression] = STATE(1855),
    [sym_pair_expression] = STATE(1855),
    [sym_tuple_expression] = STATE(1237),
    [sym_array_expression] = STATE(1237),
    [sym_matrix_expression] = STATE(1237),
    [sym_generator_expression] = STATE(1855),
    [sym_array_comprehension_expression] = STATE(1237),
    [sym_function_expression] = STATE(1855),
    [sym_range_expression] = STATE(1855),
    [sym_coefficient_expression] = STATE(1855),
    [sym_quote_expression] = STATE(1855),
    [sym_interpolation_expression] = STATE(1855),
    [sym_macro_identifier] = STATE(28),
    [sym__literal] = STATE(1462),
    [sym_integer_literal] = STATE(1462),
    [sym_character_literal] = STATE(1462),
    [sym_string_literal] = STATE(1462),
    [sym_command_literal] = STATE(1462),
    [sym_prefixed_string_literal] = STATE(1462),
    [sym_prefixed_command_literal] = STATE(1462),
    [aux_sym_macro_argument_list_repeat1] = STATE(50),
    [sym_identifier] = ACTIONS(940),
    [anon_sym_function] = ACTIONS(943),
    [anon_sym_end] = ACTIONS(203),
    [anon_sym_abstract] = ACTIONS(946),
    [anon_sym_primitive] = ACTIONS(949),
    [aux_sym_primitive_definition_token1] = ACTIONS(952),
    [anon_sym_mutable] = ACTIONS(955),
    [anon_sym_struct] = ACTIONS(958),
    [anon_sym_module] = ACTIONS(961),
    [anon_sym_macro] = ACTIONS(964),
    [anon_sym_LPAREN] = ACTIONS(967),
    [anon_sym_COMMA] = ACTIONS(292),
    [anon_sym_RPAREN] = ACTIONS(292),
    [anon_sym_SEMI] = ACTIONS(292),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(292),
    [anon_sym_COLON_COLON] = ACTIONS(292),
    [anon_sym_RBRACE] = ACTIONS(292),
    [anon_sym_LT_COLON] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(970),
    [anon_sym_try] = ACTIONS(973),
    [anon_sym_for] = ACTIONS(976),
    [anon_sym_while] = ACTIONS(979),
    [sym_break_statement] = ACTIONS(982),
    [sym_continue_statement] = ACTIONS(982),
    [anon_sym_return] = ACTIONS(985),
    [anon_sym_let] = ACTIONS(988),
    [anon_sym_const] = ACTIONS(991),
    [anon_sym_quote] = ACTIONS(994),
    [anon_sym_using] = ACTIONS(997),
    [anon_sym_import] = ACTIONS(997),
    [anon_sym_export] = ACTIONS(1000),
    [anon_sym_COLON2] = ACTIONS(1003),
    [anon_sym_RBRACK] = ACTIONS(292),
    [anon_sym_begin] = ACTIONS(1006),
    [anon_sym_SQUOTE] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(203),
    [anon_sym_LT_PIPE] = ACTIONS(292),
    [anon_sym_PIPE_GT] = ACTIONS(292),
    [anon_sym_in] = ACTIONS(203),
    [anon_sym_isa] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(292),
    [anon_sym_AMP_AMP] = ACTIONS(292),
    [anon_sym_QMARK] = ACTIONS(292),
    [anon_sym_EQ_GT] = ACTIONS(292),
    [anon_sym_LBRACK2] = ACTIONS(1012),
    [anon_sym_DOLLAR] = ACTIONS(1015),
    [anon_sym_AT] = ACTIONS(1018),
    [aux_sym_integer_literal_token1] = ACTIONS(1021),
    [aux_sym_integer_literal_token2] = ACTIONS(1021),
    [aux_sym_integer_literal_token3] = ACTIONS(1024),
    [sym_float_literal] = ACTIONS(1027),
    [sym__unary_operator] = ACTIONS(1030),
    [sym__power_operator] = ACTIONS(1033),
    [sym__bitshift_operator] = ACTIONS(1033),
    [sym__rational_operator] = ACTIONS(1033),
    [sym__times_operator] = ACTIONS(1036),
    [sym__plus_operator] = ACTIONS(1036),
    [sym__dotty_operator] = ACTIONS(1036),
    [sym__comparison_operator] = ACTIONS(1036),
    [sym__arrow_operator] = ACTIONS(292),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(1039),
    [sym__command_start] = ACTIONS(1042),
  },
  [51] = {
    [sym_function_definition] = STATE(2557),
    [sym_abstract_definition] = STATE(2557),
    [sym_primitive_definition] = STATE(2557),
    [sym_struct_definition] = STATE(2557),
    [sym_module_definition] = STATE(2557),
    [sym_macro_definition] = STATE(2557),
    [sym_parameter_list] = STATE(3815),
    [sym_if_statement] = STATE(2557),
    [sym_try_statement] = STATE(2557),
    [sym_for_statement] = STATE(2557),
    [sym_while_statement] = STATE(2557),
    [sym_return_statement] = STATE(2557),
    [sym_let_statement] = STATE(2557),
    [sym_const_statement] = STATE(2557),
    [sym_quote_statement] = STATE(2557),
    [sym_import_statement] = STATE(2557),
    [sym_export_statement] = STATE(2557),
    [sym__expression] = STATE(2513),
    [sym__primary_expression] = STATE(2256),
    [sym_operator] = STATE(2451),
    [sym_parenthesized_expression] = STATE(2256),
    [sym_field_expression] = STATE(2089),
    [sym_subscript_expression] = STATE(2256),
    [sym_typed_expression] = STATE(2557),
    [sym_parameterized_identifier] = STATE(2256),
    [sym_compound_expression] = STATE(2557),
    [sym_call_expression] = STATE(2256),
    [sym_broadcast_call_expression] = STATE(2256),
    [sym_macro_expression] = STATE(2557),
    [sym_spread_expression] = STATE(2557),
    [sym_unary_expression] = STATE(2557),
    [sym_binary_expression] = STATE(2557),
    [sym_ternary_expression] = STATE(2557),
    [sym_pair_expression] = STATE(2557),
    [sym_tuple_expression] = STATE(2256),
    [sym_array_expression] = STATE(2256),
    [sym_matrix_expression] = STATE(2256),
    [sym_generator_expression] = STATE(2557),
    [sym_array_comprehension_expression] = STATE(2256),
    [sym_function_expression] = STATE(2557),
    [sym_range_expression] = STATE(2557),
    [sym_coefficient_expression] = STATE(2557),
    [sym_quote_expression] = STATE(2557),
    [sym_interpolation_expression] = STATE(2557),
    [sym_macro_identifier] = STATE(37),
    [sym__literal] = STATE(2449),
    [sym_integer_literal] = STATE(2449),
    [sym_character_literal] = STATE(2449),
    [sym_string_literal] = STATE(2449),
    [sym_command_literal] = STATE(2449),
    [sym_prefixed_string_literal] = STATE(2449),
    [sym_prefixed_command_literal] = STATE(2449),
    [sym_identifier] = ACTIONS(868),
    [anon_sym_function] = ACTIONS(870),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(872),
    [anon_sym_primitive] = ACTIONS(874),
    [aux_sym_primitive_definition_token1] = ACTIONS(876),
    [anon_sym_mutable] = ACTIONS(878),
    [anon_sym_struct] = ACTIONS(880),
    [anon_sym_module] = ACTIONS(882),
    [anon_sym_macro] = ACTIONS(884),
    [anon_sym_LPAREN] = ACTIONS(886),
    [anon_sym_COMMA] = ACTIONS(306),
    [anon_sym_RPAREN] = ACTIONS(306),
    [anon_sym_SEMI] = ACTIONS(306),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(306),
    [anon_sym_COLON_COLON] = ACTIONS(306),
    [anon_sym_RBRACE] = ACTIONS(306),
    [anon_sym_LT_COLON] = ACTIONS(306),
    [anon_sym_if] = ACTIONS(888),
    [anon_sym_try] = ACTIONS(890),
    [anon_sym_for] = ACTIONS(892),
    [anon_sym_while] = ACTIONS(894),
    [sym_break_statement] = ACTIONS(896),
    [sym_continue_statement] = ACTIONS(896),
    [anon_sym_return] = ACTIONS(898),
    [anon_sym_let] = ACTIONS(900),
    [anon_sym_const] = ACTIONS(902),
    [anon_sym_quote] = ACTIONS(904),
    [anon_sym_using] = ACTIONS(906),
    [anon_sym_import] = ACTIONS(906),
    [anon_sym_export] = ACTIONS(908),
    [anon_sym_COLON2] = ACTIONS(910),
    [anon_sym_RBRACK] = ACTIONS(306),
    [anon_sym_begin] = ACTIONS(912),
    [anon_sym_SQUOTE] = ACTIONS(914),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(306),
    [anon_sym_PIPE_GT] = ACTIONS(306),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(306),
    [anon_sym_AMP_AMP] = ACTIONS(306),
    [anon_sym_QMARK] = ACTIONS(306),
    [anon_sym_EQ_GT] = ACTIONS(306),
    [anon_sym_LBRACK2] = ACTIONS(916),
    [anon_sym_DOLLAR] = ACTIONS(918),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(920),
    [aux_sym_integer_literal_token2] = ACTIONS(920),
    [aux_sym_integer_literal_token3] = ACTIONS(922),
    [sym_float_literal] = ACTIONS(924),
    [sym__unary_operator] = ACTIONS(926),
    [sym__power_operator] = ACTIONS(928),
    [sym__bitshift_operator] = ACTIONS(928),
    [sym__rational_operator] = ACTIONS(928),
    [sym__times_operator] = ACTIONS(930),
    [sym__plus_operator] = ACTIONS(930),
    [sym__dotty_operator] = ACTIONS(930),
    [sym__comparison_operator] = ACTIONS(930),
    [sym__arrow_operator] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(932),
    [sym__command_start] = ACTIONS(934),
  },
  [52] = {
    [sym_function_definition] = STATE(1855),
    [sym_abstract_definition] = STATE(1855),
    [sym_primitive_definition] = STATE(1855),
    [sym_struct_definition] = STATE(1855),
    [sym_module_definition] = STATE(1855),
    [sym_macro_definition] = STATE(1855),
    [sym_parameter_list] = STATE(3801),
    [sym_if_statement] = STATE(1855),
    [sym_try_statement] = STATE(1855),
    [sym_for_statement] = STATE(1855),
    [sym_while_statement] = STATE(1855),
    [sym_return_statement] = STATE(1855),
    [sym_let_statement] = STATE(1855),
    [sym_const_statement] = STATE(1855),
    [sym_quote_statement] = STATE(1855),
    [sym_import_statement] = STATE(1855),
    [sym_export_statement] = STATE(1855),
    [sym__expression] = STATE(1920),
    [sym__primary_expression] = STATE(1237),
    [sym_operator] = STATE(1461),
    [sym_parenthesized_expression] = STATE(1237),
    [sym_field_expression] = STATE(1088),
    [sym_subscript_expression] = STATE(1237),
    [sym_typed_expression] = STATE(1855),
    [sym_parameterized_identifier] = STATE(1237),
    [sym_compound_expression] = STATE(1855),
    [sym_call_expression] = STATE(1237),
    [sym_broadcast_call_expression] = STATE(1237),
    [sym_macro_expression] = STATE(1855),
    [sym_macro_argument_list] = STATE(1829),
    [sym_spread_expression] = STATE(1855),
    [sym_unary_expression] = STATE(1855),
    [sym_binary_expression] = STATE(1855),
    [sym_ternary_expression] = STATE(1855),
    [sym_pair_expression] = STATE(1855),
    [sym_tuple_expression] = STATE(1237),
    [sym_array_expression] = STATE(1237),
    [sym_matrix_expression] = STATE(1237),
    [sym_generator_expression] = STATE(1855),
    [sym_array_comprehension_expression] = STATE(1237),
    [sym_function_expression] = STATE(1855),
    [sym_range_expression] = STATE(1855),
    [sym_coefficient_expression] = STATE(1855),
    [sym_quote_expression] = STATE(1855),
    [sym_interpolation_expression] = STATE(1855),
    [sym_macro_identifier] = STATE(52),
    [sym__literal] = STATE(1462),
    [sym_integer_literal] = STATE(1462),
    [sym_character_literal] = STATE(1462),
    [sym_string_literal] = STATE(1462),
    [sym_command_literal] = STATE(1462),
    [sym_prefixed_string_literal] = STATE(1462),
    [sym_prefixed_command_literal] = STATE(1462),
    [aux_sym_macro_argument_list_repeat1] = STATE(80),
    [sym_identifier] = ACTIONS(1045),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_end] = ACTIONS(125),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_primitive] = ACTIONS(616),
    [aux_sym_primitive_definition_token1] = ACTIONS(618),
    [anon_sym_mutable] = ACTIONS(620),
    [anon_sym_struct] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_macro] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_RPAREN] = ACTIONS(183),
    [anon_sym_SEMI] = ACTIONS(183),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(183),
    [anon_sym_LT_COLON] = ACTIONS(183),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [sym_break_statement] = ACTIONS(638),
    [sym_continue_statement] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(644),
    [anon_sym_quote] = ACTIONS(646),
    [anon_sym_using] = ACTIONS(648),
    [anon_sym_import] = ACTIONS(648),
    [anon_sym_export] = ACTIONS(650),
    [anon_sym_COLON2] = ACTIONS(1047),
    [anon_sym_RBRACK] = ACTIONS(183),
    [anon_sym_begin] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_LT_PIPE] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_in] = ACTIONS(125),
    [anon_sym_isa] = ACTIONS(125),
    [anon_sym_PIPE_PIPE] = ACTIONS(183),
    [anon_sym_AMP_AMP] = ACTIONS(183),
    [anon_sym_QMARK] = ACTIONS(183),
    [anon_sym_EQ_GT] = ACTIONS(183),
    [anon_sym_LBRACK2] = ACTIONS(658),
    [anon_sym_DOLLAR] = ACTIONS(1049),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(664),
    [aux_sym_integer_literal_token2] = ACTIONS(664),
    [aux_sym_integer_literal_token3] = ACTIONS(666),
    [sym_float_literal] = ACTIONS(668),
    [sym__unary_operator] = ACTIONS(1051),
    [sym__power_operator] = ACTIONS(672),
    [sym__bitshift_operator] = ACTIONS(672),
    [sym__rational_operator] = ACTIONS(672),
    [sym__times_operator] = ACTIONS(674),
    [sym__plus_operator] = ACTIONS(674),
    [sym__dotty_operator] = ACTIONS(674),
    [sym__comparison_operator] = ACTIONS(674),
    [sym__arrow_operator] = ACTIONS(183),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(676),
    [sym__string_start] = ACTIONS(678),
    [sym__command_start] = ACTIONS(680),
  },
  [53] = {
    [sym_function_definition] = STATE(1713),
    [sym_abstract_definition] = STATE(1713),
    [sym_primitive_definition] = STATE(1713),
    [sym_struct_definition] = STATE(1713),
    [sym_module_definition] = STATE(1713),
    [sym_macro_definition] = STATE(1713),
    [sym_parameter_list] = STATE(4089),
    [sym_if_statement] = STATE(1713),
    [sym_try_statement] = STATE(1713),
    [sym_for_statement] = STATE(1713),
    [sym_while_statement] = STATE(1713),
    [sym_return_statement] = STATE(1713),
    [sym_let_statement] = STATE(1713),
    [sym_const_statement] = STATE(1713),
    [sym_quote_statement] = STATE(1713),
    [sym_import_statement] = STATE(1713),
    [sym_export_statement] = STATE(1713),
    [sym__expression] = STATE(1687),
    [sym__primary_expression] = STATE(1243),
    [sym_operator] = STATE(1492),
    [sym_parenthesized_expression] = STATE(1243),
    [sym_field_expression] = STATE(1012),
    [sym_subscript_expression] = STATE(1243),
    [sym_typed_expression] = STATE(1713),
    [sym_parameterized_identifier] = STATE(1243),
    [sym_compound_expression] = STATE(1713),
    [sym_call_expression] = STATE(1243),
    [sym_broadcast_call_expression] = STATE(1243),
    [sym_macro_expression] = STATE(1713),
    [sym_spread_expression] = STATE(1713),
    [sym_unary_expression] = STATE(1713),
    [sym_binary_expression] = STATE(1713),
    [sym_ternary_expression] = STATE(1713),
    [sym_pair_expression] = STATE(1713),
    [sym_tuple_expression] = STATE(1243),
    [sym_array_expression] = STATE(1243),
    [sym_matrix_expression] = STATE(1243),
    [sym_generator_expression] = STATE(1713),
    [sym_array_comprehension_expression] = STATE(1243),
    [sym_function_expression] = STATE(1713),
    [sym_range_expression] = STATE(1713),
    [sym_coefficient_expression] = STATE(1713),
    [sym_quote_expression] = STATE(1713),
    [sym_interpolation_expression] = STATE(1713),
    [sym_macro_identifier] = STATE(27),
    [sym__literal] = STATE(1494),
    [sym_integer_literal] = STATE(1494),
    [sym_character_literal] = STATE(1494),
    [sym_string_literal] = STATE(1494),
    [sym_command_literal] = STATE(1494),
    [sym_prefixed_string_literal] = STATE(1494),
    [sym_prefixed_command_literal] = STATE(1494),
    [ts_builtin_sym_end] = ACTIONS(306),
    [sym_identifier] = ACTIONS(542),
    [anon_sym_function] = ACTIONS(544),
    [anon_sym_abstract] = ACTIONS(546),
    [anon_sym_primitive] = ACTIONS(548),
    [aux_sym_primitive_definition_token1] = ACTIONS(550),
    [anon_sym_mutable] = ACTIONS(552),
    [anon_sym_struct] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(556),
    [anon_sym_macro] = ACTIONS(558),
    [anon_sym_LPAREN] = ACTIONS(560),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_EQ] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LT_COLON] = ACTIONS(304),
    [anon_sym_if] = ACTIONS(562),
    [anon_sym_try] = ACTIONS(564),
    [anon_sym_for] = ACTIONS(566),
    [anon_sym_while] = ACTIONS(568),
    [sym_break_statement] = ACTIONS(570),
    [sym_continue_statement] = ACTIONS(570),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_let] = ACTIONS(574),
    [anon_sym_const] = ACTIONS(576),
    [anon_sym_quote] = ACTIONS(578),
    [anon_sym_using] = ACTIONS(580),
    [anon_sym_import] = ACTIONS(580),
    [anon_sym_export] = ACTIONS(582),
    [anon_sym_COLON2] = ACTIONS(584),
    [anon_sym_begin] = ACTIONS(586),
    [anon_sym_SQUOTE] = ACTIONS(588),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(304),
    [anon_sym_PIPE_GT] = ACTIONS(304),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_EQ_GT] = ACTIONS(304),
    [anon_sym_LBRACK2] = ACTIONS(590),
    [anon_sym_DOLLAR] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(594),
    [aux_sym_integer_literal_token1] = ACTIONS(596),
    [aux_sym_integer_literal_token2] = ACTIONS(596),
    [aux_sym_integer_literal_token3] = ACTIONS(596),
    [sym_float_literal] = ACTIONS(598),
    [sym__unary_operator] = ACTIONS(600),
    [sym__power_operator] = ACTIONS(602),
    [sym__bitshift_operator] = ACTIONS(602),
    [sym__rational_operator] = ACTIONS(602),
    [sym__times_operator] = ACTIONS(602),
    [sym__plus_operator] = ACTIONS(602),
    [sym__dotty_operator] = ACTIONS(602),
    [sym__comparison_operator] = ACTIONS(602),
    [sym__arrow_operator] = ACTIONS(304),
    [sym__assign_operator] = ACTIONS(304),
    [anon_sym_LF] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(604),
    [sym__command_start] = ACTIONS(606),
  },
  [54] = {
    [sym_function_definition] = STATE(1713),
    [sym_abstract_definition] = STATE(1713),
    [sym_primitive_definition] = STATE(1713),
    [sym_struct_definition] = STATE(1713),
    [sym_module_definition] = STATE(1713),
    [sym_macro_definition] = STATE(1713),
    [sym_parameter_list] = STATE(4089),
    [sym_if_statement] = STATE(1713),
    [sym_try_statement] = STATE(1713),
    [sym_for_statement] = STATE(1713),
    [sym_while_statement] = STATE(1713),
    [sym_return_statement] = STATE(1713),
    [sym_let_statement] = STATE(1713),
    [sym_const_statement] = STATE(1713),
    [sym_quote_statement] = STATE(1713),
    [sym_import_statement] = STATE(1713),
    [sym_export_statement] = STATE(1713),
    [sym__expression] = STATE(1497),
    [sym__primary_expression] = STATE(1243),
    [sym_bare_tuple_expression] = STATE(1700),
    [sym_operator] = STATE(1492),
    [sym_parenthesized_expression] = STATE(1243),
    [sym_field_expression] = STATE(1012),
    [sym_subscript_expression] = STATE(1243),
    [sym_typed_expression] = STATE(1713),
    [sym_parameterized_identifier] = STATE(1243),
    [sym_compound_expression] = STATE(1713),
    [sym_call_expression] = STATE(1243),
    [sym_broadcast_call_expression] = STATE(1243),
    [sym_macro_expression] = STATE(1713),
    [sym_spread_expression] = STATE(1713),
    [sym_unary_expression] = STATE(1713),
    [sym_binary_expression] = STATE(1713),
    [sym_ternary_expression] = STATE(1713),
    [sym_pair_expression] = STATE(1713),
    [sym_tuple_expression] = STATE(1243),
    [sym_array_expression] = STATE(1243),
    [sym_matrix_expression] = STATE(1243),
    [sym_generator_expression] = STATE(1713),
    [sym_array_comprehension_expression] = STATE(1243),
    [sym_function_expression] = STATE(1713),
    [sym_range_expression] = STATE(1713),
    [sym_coefficient_expression] = STATE(1713),
    [sym_quote_expression] = STATE(1713),
    [sym_interpolation_expression] = STATE(1713),
    [sym_macro_identifier] = STATE(27),
    [sym__literal] = STATE(1494),
    [sym_integer_literal] = STATE(1494),
    [sym_character_literal] = STATE(1494),
    [sym_string_literal] = STATE(1494),
    [sym_command_literal] = STATE(1494),
    [sym_prefixed_string_literal] = STATE(1494),
    [sym_prefixed_command_literal] = STATE(1494),
    [ts_builtin_sym_end] = ACTIONS(302),
    [sym_identifier] = ACTIONS(542),
    [anon_sym_function] = ACTIONS(544),
    [anon_sym_abstract] = ACTIONS(546),
    [anon_sym_primitive] = ACTIONS(548),
    [aux_sym_primitive_definition_token1] = ACTIONS(550),
    [anon_sym_mutable] = ACTIONS(552),
    [anon_sym_struct] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(556),
    [anon_sym_macro] = ACTIONS(558),
    [anon_sym_LPAREN] = ACTIONS(560),
    [anon_sym_COMMA] = ACTIONS(300),
    [anon_sym_SEMI] = ACTIONS(300),
    [anon_sym_EQ] = ACTIONS(300),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(300),
    [anon_sym_COLON_COLON] = ACTIONS(300),
    [anon_sym_LT_COLON] = ACTIONS(300),
    [anon_sym_if] = ACTIONS(562),
    [anon_sym_try] = ACTIONS(564),
    [anon_sym_for] = ACTIONS(566),
    [anon_sym_while] = ACTIONS(568),
    [sym_break_statement] = ACTIONS(570),
    [sym_continue_statement] = ACTIONS(570),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_let] = ACTIONS(574),
    [anon_sym_const] = ACTIONS(576),
    [anon_sym_quote] = ACTIONS(578),
    [anon_sym_using] = ACTIONS(580),
    [anon_sym_import] = ACTIONS(580),
    [anon_sym_export] = ACTIONS(582),
    [anon_sym_COLON2] = ACTIONS(584),
    [anon_sym_begin] = ACTIONS(586),
    [anon_sym_SQUOTE] = ACTIONS(588),
    [anon_sym_PLUS] = ACTIONS(300),
    [anon_sym_LT_PIPE] = ACTIONS(300),
    [anon_sym_PIPE_GT] = ACTIONS(300),
    [anon_sym_in] = ACTIONS(300),
    [anon_sym_isa] = ACTIONS(300),
    [anon_sym_PIPE_PIPE] = ACTIONS(300),
    [anon_sym_AMP_AMP] = ACTIONS(300),
    [anon_sym_QMARK] = ACTIONS(300),
    [anon_sym_EQ_GT] = ACTIONS(300),
    [anon_sym_LBRACK2] = ACTIONS(590),
    [anon_sym_DOLLAR] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(594),
    [aux_sym_integer_literal_token1] = ACTIONS(596),
    [aux_sym_integer_literal_token2] = ACTIONS(596),
    [aux_sym_integer_literal_token3] = ACTIONS(596),
    [sym_float_literal] = ACTIONS(598),
    [sym__unary_operator] = ACTIONS(600),
    [sym__power_operator] = ACTIONS(602),
    [sym__bitshift_operator] = ACTIONS(602),
    [sym__rational_operator] = ACTIONS(602),
    [sym__times_operator] = ACTIONS(602),
    [sym__plus_operator] = ACTIONS(602),
    [sym__dotty_operator] = ACTIONS(602),
    [sym__comparison_operator] = ACTIONS(602),
    [sym__arrow_operator] = ACTIONS(300),
    [sym__assign_operator] = ACTIONS(300),
    [anon_sym_LF] = ACTIONS(302),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(604),
    [sym__command_start] = ACTIONS(606),
  },
  [55] = {
    [sym_function_definition] = STATE(1713),
    [sym_abstract_definition] = STATE(1713),
    [sym_primitive_definition] = STATE(1713),
    [sym_struct_definition] = STATE(1713),
    [sym_module_definition] = STATE(1713),
    [sym_macro_definition] = STATE(1713),
    [sym_parameter_list] = STATE(4089),
    [sym_if_statement] = STATE(1713),
    [sym_try_statement] = STATE(1713),
    [sym_for_statement] = STATE(1713),
    [sym_while_statement] = STATE(1713),
    [sym_return_statement] = STATE(1713),
    [sym_let_statement] = STATE(1713),
    [sym_const_statement] = STATE(1713),
    [sym_quote_statement] = STATE(1713),
    [sym_import_statement] = STATE(1713),
    [sym_export_statement] = STATE(1713),
    [sym__expression] = STATE(1860),
    [sym__primary_expression] = STATE(1243),
    [sym_operator] = STATE(1492),
    [sym_parenthesized_expression] = STATE(1243),
    [sym_field_expression] = STATE(1012),
    [sym_subscript_expression] = STATE(1243),
    [sym_typed_expression] = STATE(1713),
    [sym_parameterized_identifier] = STATE(1243),
    [sym_compound_expression] = STATE(1713),
    [sym_call_expression] = STATE(1243),
    [sym_broadcast_call_expression] = STATE(1243),
    [sym_macro_expression] = STATE(1713),
    [sym_spread_expression] = STATE(1713),
    [sym_unary_expression] = STATE(1713),
    [sym_binary_expression] = STATE(1713),
    [sym_ternary_expression] = STATE(1713),
    [sym_pair_expression] = STATE(1713),
    [sym_tuple_expression] = STATE(1243),
    [sym_array_expression] = STATE(1243),
    [sym_matrix_expression] = STATE(1243),
    [sym_generator_expression] = STATE(1713),
    [sym_array_comprehension_expression] = STATE(1243),
    [sym_function_expression] = STATE(1713),
    [sym_range_expression] = STATE(1713),
    [sym_coefficient_expression] = STATE(1713),
    [sym_quote_expression] = STATE(1713),
    [sym_interpolation_expression] = STATE(1713),
    [sym_macro_identifier] = STATE(27),
    [sym__literal] = STATE(1494),
    [sym_integer_literal] = STATE(1494),
    [sym_character_literal] = STATE(1494),
    [sym_string_literal] = STATE(1494),
    [sym_command_literal] = STATE(1494),
    [sym_prefixed_string_literal] = STATE(1494),
    [sym_prefixed_command_literal] = STATE(1494),
    [aux_sym_macro_argument_list_repeat1] = STATE(55),
    [ts_builtin_sym_end] = ACTIONS(292),
    [sym_identifier] = ACTIONS(1053),
    [anon_sym_function] = ACTIONS(1056),
    [anon_sym_abstract] = ACTIONS(1059),
    [anon_sym_primitive] = ACTIONS(1062),
    [aux_sym_primitive_definition_token1] = ACTIONS(1065),
    [anon_sym_mutable] = ACTIONS(1068),
    [anon_sym_struct] = ACTIONS(1071),
    [anon_sym_module] = ACTIONS(1074),
    [anon_sym_macro] = ACTIONS(1077),
    [anon_sym_LPAREN] = ACTIONS(1080),
    [anon_sym_COMMA] = ACTIONS(203),
    [anon_sym_SEMI] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_COLON_COLON] = ACTIONS(203),
    [anon_sym_LT_COLON] = ACTIONS(203),
    [anon_sym_if] = ACTIONS(1083),
    [anon_sym_try] = ACTIONS(1086),
    [anon_sym_for] = ACTIONS(1089),
    [anon_sym_while] = ACTIONS(1092),
    [sym_break_statement] = ACTIONS(1095),
    [sym_continue_statement] = ACTIONS(1095),
    [anon_sym_return] = ACTIONS(1098),
    [anon_sym_let] = ACTIONS(1101),
    [anon_sym_const] = ACTIONS(1104),
    [anon_sym_quote] = ACTIONS(1107),
    [anon_sym_using] = ACTIONS(1110),
    [anon_sym_import] = ACTIONS(1110),
    [anon_sym_export] = ACTIONS(1113),
    [anon_sym_COLON2] = ACTIONS(1116),
    [anon_sym_begin] = ACTIONS(1119),
    [anon_sym_SQUOTE] = ACTIONS(1122),
    [anon_sym_PLUS] = ACTIONS(203),
    [anon_sym_LT_PIPE] = ACTIONS(203),
    [anon_sym_PIPE_GT] = ACTIONS(203),
    [anon_sym_in] = ACTIONS(203),
    [anon_sym_isa] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(203),
    [anon_sym_EQ_GT] = ACTIONS(203),
    [anon_sym_LBRACK2] = ACTIONS(1125),
    [anon_sym_DOLLAR] = ACTIONS(1128),
    [anon_sym_AT] = ACTIONS(1131),
    [aux_sym_integer_literal_token1] = ACTIONS(1134),
    [aux_sym_integer_literal_token2] = ACTIONS(1134),
    [aux_sym_integer_literal_token3] = ACTIONS(1134),
    [sym_float_literal] = ACTIONS(1137),
    [sym__unary_operator] = ACTIONS(1140),
    [sym__power_operator] = ACTIONS(1143),
    [sym__bitshift_operator] = ACTIONS(1143),
    [sym__rational_operator] = ACTIONS(1143),
    [sym__times_operator] = ACTIONS(1143),
    [sym__plus_operator] = ACTIONS(1143),
    [sym__dotty_operator] = ACTIONS(1143),
    [sym__comparison_operator] = ACTIONS(1143),
    [sym__arrow_operator] = ACTIONS(203),
    [sym__assign_operator] = ACTIONS(203),
    [anon_sym_LF] = ACTIONS(292),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(1146),
    [sym__command_start] = ACTIONS(1149),
  },
  [56] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(3882),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1438),
    [sym__primary_expression] = STATE(1203),
    [sym_bare_tuple_expression] = STATE(1695),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(33),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [sym_identifier] = ACTIONS(748),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(300),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(300),
    [anon_sym_SEMI] = ACTIONS(300),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(300),
    [anon_sym_COLON_COLON] = ACTIONS(300),
    [anon_sym_LT_COLON] = ACTIONS(300),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(300),
    [anon_sym_else] = ACTIONS(300),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(750),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(300),
    [anon_sym_LT_PIPE] = ACTIONS(300),
    [anon_sym_PIPE_GT] = ACTIONS(300),
    [anon_sym_in] = ACTIONS(300),
    [anon_sym_isa] = ACTIONS(300),
    [anon_sym_PIPE_PIPE] = ACTIONS(300),
    [anon_sym_AMP_AMP] = ACTIONS(300),
    [anon_sym_QMARK] = ACTIONS(300),
    [anon_sym_EQ_GT] = ACTIONS(300),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(752),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(754),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(300),
    [anon_sym_LF] = ACTIONS(302),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [57] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(3882),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1800),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(33),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [aux_sym_macro_argument_list_repeat1] = STATE(57),
    [sym_identifier] = ACTIONS(1152),
    [anon_sym_function] = ACTIONS(1155),
    [anon_sym_end] = ACTIONS(203),
    [anon_sym_abstract] = ACTIONS(1158),
    [anon_sym_primitive] = ACTIONS(1161),
    [aux_sym_primitive_definition_token1] = ACTIONS(1164),
    [anon_sym_mutable] = ACTIONS(1167),
    [anon_sym_struct] = ACTIONS(1170),
    [anon_sym_module] = ACTIONS(1173),
    [anon_sym_macro] = ACTIONS(1176),
    [anon_sym_LPAREN] = ACTIONS(1179),
    [anon_sym_COMMA] = ACTIONS(203),
    [anon_sym_SEMI] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_COLON_COLON] = ACTIONS(203),
    [anon_sym_LT_COLON] = ACTIONS(203),
    [anon_sym_if] = ACTIONS(1182),
    [anon_sym_elseif] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(203),
    [anon_sym_try] = ACTIONS(1185),
    [anon_sym_for] = ACTIONS(1188),
    [anon_sym_while] = ACTIONS(1191),
    [sym_break_statement] = ACTIONS(1194),
    [sym_continue_statement] = ACTIONS(1194),
    [anon_sym_return] = ACTIONS(1197),
    [anon_sym_let] = ACTIONS(1200),
    [anon_sym_const] = ACTIONS(1203),
    [anon_sym_quote] = ACTIONS(1206),
    [anon_sym_using] = ACTIONS(1209),
    [anon_sym_import] = ACTIONS(1209),
    [anon_sym_export] = ACTIONS(1212),
    [anon_sym_COLON2] = ACTIONS(1215),
    [anon_sym_begin] = ACTIONS(1218),
    [anon_sym_SQUOTE] = ACTIONS(1221),
    [anon_sym_PLUS] = ACTIONS(203),
    [anon_sym_LT_PIPE] = ACTIONS(203),
    [anon_sym_PIPE_GT] = ACTIONS(203),
    [anon_sym_in] = ACTIONS(203),
    [anon_sym_isa] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(203),
    [anon_sym_EQ_GT] = ACTIONS(203),
    [anon_sym_LBRACK2] = ACTIONS(1224),
    [anon_sym_DOLLAR] = ACTIONS(1227),
    [anon_sym_AT] = ACTIONS(1230),
    [aux_sym_integer_literal_token1] = ACTIONS(1233),
    [aux_sym_integer_literal_token2] = ACTIONS(1233),
    [aux_sym_integer_literal_token3] = ACTIONS(1233),
    [sym_float_literal] = ACTIONS(1236),
    [sym__unary_operator] = ACTIONS(1239),
    [sym__power_operator] = ACTIONS(1242),
    [sym__bitshift_operator] = ACTIONS(1242),
    [sym__rational_operator] = ACTIONS(1242),
    [sym__times_operator] = ACTIONS(1242),
    [sym__plus_operator] = ACTIONS(1242),
    [sym__dotty_operator] = ACTIONS(1242),
    [sym__comparison_operator] = ACTIONS(1242),
    [sym__arrow_operator] = ACTIONS(203),
    [anon_sym_LF] = ACTIONS(292),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(1245),
    [sym__command_start] = ACTIONS(1248),
  },
  [58] = {
    [sym_function_definition] = STATE(1855),
    [sym_abstract_definition] = STATE(1855),
    [sym_primitive_definition] = STATE(1855),
    [sym_struct_definition] = STATE(1855),
    [sym_module_definition] = STATE(1855),
    [sym_macro_definition] = STATE(1855),
    [sym_parameter_list] = STATE(4171),
    [sym_if_statement] = STATE(1855),
    [sym_try_statement] = STATE(1855),
    [sym_for_statement] = STATE(1855),
    [sym_while_statement] = STATE(1855),
    [sym_return_statement] = STATE(1855),
    [sym_let_statement] = STATE(1855),
    [sym_const_statement] = STATE(1855),
    [sym_quote_statement] = STATE(1855),
    [sym_import_statement] = STATE(1855),
    [sym_export_statement] = STATE(1855),
    [sym__expression] = STATE(1466),
    [sym__primary_expression] = STATE(1237),
    [sym_bare_tuple_expression] = STATE(1845),
    [sym_operator] = STATE(1461),
    [sym_parenthesized_expression] = STATE(1237),
    [sym_field_expression] = STATE(1088),
    [sym_subscript_expression] = STATE(1237),
    [sym_typed_expression] = STATE(1855),
    [sym_parameterized_identifier] = STATE(1237),
    [sym_compound_expression] = STATE(1855),
    [sym_call_expression] = STATE(1237),
    [sym_broadcast_call_expression] = STATE(1237),
    [sym_macro_expression] = STATE(1855),
    [sym_spread_expression] = STATE(1855),
    [sym_unary_expression] = STATE(1855),
    [sym_binary_expression] = STATE(1855),
    [sym_ternary_expression] = STATE(1855),
    [sym_pair_expression] = STATE(1855),
    [sym_tuple_expression] = STATE(1237),
    [sym_array_expression] = STATE(1237),
    [sym_matrix_expression] = STATE(1237),
    [sym_generator_expression] = STATE(1855),
    [sym_array_comprehension_expression] = STATE(1237),
    [sym_function_expression] = STATE(1855),
    [sym_range_expression] = STATE(1855),
    [sym_coefficient_expression] = STATE(1855),
    [sym_quote_expression] = STATE(1855),
    [sym_interpolation_expression] = STATE(1855),
    [sym_macro_identifier] = STATE(28),
    [sym__literal] = STATE(1462),
    [sym_integer_literal] = STATE(1462),
    [sym_character_literal] = STATE(1462),
    [sym_string_literal] = STATE(1462),
    [sym_command_literal] = STATE(1462),
    [sym_prefixed_string_literal] = STATE(1462),
    [sym_prefixed_command_literal] = STATE(1462),
    [sym_identifier] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_end] = ACTIONS(300),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_primitive] = ACTIONS(616),
    [aux_sym_primitive_definition_token1] = ACTIONS(618),
    [anon_sym_mutable] = ACTIONS(620),
    [anon_sym_struct] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_macro] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_COMMA] = ACTIONS(302),
    [anon_sym_RPAREN] = ACTIONS(302),
    [anon_sym_SEMI] = ACTIONS(302),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(302),
    [anon_sym_COLON_COLON] = ACTIONS(302),
    [anon_sym_RBRACE] = ACTIONS(302),
    [anon_sym_LT_COLON] = ACTIONS(302),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [sym_break_statement] = ACTIONS(638),
    [sym_continue_statement] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(644),
    [anon_sym_quote] = ACTIONS(646),
    [anon_sym_using] = ACTIONS(648),
    [anon_sym_import] = ACTIONS(648),
    [anon_sym_export] = ACTIONS(650),
    [anon_sym_COLON2] = ACTIONS(652),
    [anon_sym_RBRACK] = ACTIONS(302),
    [anon_sym_begin] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(300),
    [anon_sym_LT_PIPE] = ACTIONS(302),
    [anon_sym_PIPE_GT] = ACTIONS(302),
    [anon_sym_in] = ACTIONS(300),
    [anon_sym_isa] = ACTIONS(300),
    [anon_sym_PIPE_PIPE] = ACTIONS(302),
    [anon_sym_AMP_AMP] = ACTIONS(302),
    [anon_sym_QMARK] = ACTIONS(302),
    [anon_sym_EQ_GT] = ACTIONS(302),
    [anon_sym_LBRACK2] = ACTIONS(658),
    [anon_sym_DOLLAR] = ACTIONS(660),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(664),
    [aux_sym_integer_literal_token2] = ACTIONS(664),
    [aux_sym_integer_literal_token3] = ACTIONS(666),
    [sym_float_literal] = ACTIONS(668),
    [sym__unary_operator] = ACTIONS(670),
    [sym__power_operator] = ACTIONS(672),
    [sym__bitshift_operator] = ACTIONS(672),
    [sym__rational_operator] = ACTIONS(672),
    [sym__times_operator] = ACTIONS(674),
    [sym__plus_operator] = ACTIONS(674),
    [sym__dotty_operator] = ACTIONS(674),
    [sym__comparison_operator] = ACTIONS(674),
    [sym__arrow_operator] = ACTIONS(302),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(678),
    [sym__command_start] = ACTIONS(680),
  },
  [59] = {
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4197),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2617),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2143),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(26),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [ts_builtin_sym_end] = ACTIONS(302),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(15),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_COMMA] = ACTIONS(300),
    [anon_sym_SEMI] = ACTIONS(300),
    [anon_sym_EQ] = ACTIONS(300),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(300),
    [anon_sym_COLON_COLON] = ACTIONS(300),
    [anon_sym_LT_COLON] = ACTIONS(300),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(37),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(41),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(936),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_PLUS] = ACTIONS(300),
    [anon_sym_LT_PIPE] = ACTIONS(300),
    [anon_sym_PIPE_GT] = ACTIONS(300),
    [anon_sym_in] = ACTIONS(300),
    [anon_sym_isa] = ACTIONS(300),
    [anon_sym_PIPE_PIPE] = ACTIONS(300),
    [anon_sym_AMP_AMP] = ACTIONS(300),
    [anon_sym_QMARK] = ACTIONS(300),
    [anon_sym_EQ_GT] = ACTIONS(300),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(594),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(65),
    [sym__unary_operator] = ACTIONS(67),
    [sym__power_operator] = ACTIONS(71),
    [sym__bitshift_operator] = ACTIONS(71),
    [sym__rational_operator] = ACTIONS(71),
    [sym__times_operator] = ACTIONS(71),
    [sym__plus_operator] = ACTIONS(71),
    [sym__dotty_operator] = ACTIONS(71),
    [sym__comparison_operator] = ACTIONS(71),
    [sym__arrow_operator] = ACTIONS(300),
    [sym__assign_operator] = ACTIONS(300),
    [anon_sym_LF] = ACTIONS(302),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [60] = {
    [sym_function_definition] = STATE(1855),
    [sym_abstract_definition] = STATE(1855),
    [sym_primitive_definition] = STATE(1855),
    [sym_struct_definition] = STATE(1855),
    [sym_module_definition] = STATE(1855),
    [sym_macro_definition] = STATE(1855),
    [sym_parameter_list] = STATE(4171),
    [sym_if_statement] = STATE(1855),
    [sym_try_statement] = STATE(1855),
    [sym_for_statement] = STATE(1855),
    [sym_while_statement] = STATE(1855),
    [sym_return_statement] = STATE(1855),
    [sym_let_statement] = STATE(1855),
    [sym_const_statement] = STATE(1855),
    [sym_quote_statement] = STATE(1855),
    [sym_import_statement] = STATE(1855),
    [sym_export_statement] = STATE(1855),
    [sym__expression] = STATE(1685),
    [sym__primary_expression] = STATE(1237),
    [sym_operator] = STATE(1461),
    [sym_parenthesized_expression] = STATE(1237),
    [sym_field_expression] = STATE(1088),
    [sym_subscript_expression] = STATE(1237),
    [sym_typed_expression] = STATE(1855),
    [sym_parameterized_identifier] = STATE(1237),
    [sym_compound_expression] = STATE(1855),
    [sym_call_expression] = STATE(1237),
    [sym_broadcast_call_expression] = STATE(1237),
    [sym_macro_expression] = STATE(1855),
    [sym_spread_expression] = STATE(1855),
    [sym_unary_expression] = STATE(1855),
    [sym_binary_expression] = STATE(1855),
    [sym_ternary_expression] = STATE(1855),
    [sym_pair_expression] = STATE(1855),
    [sym_tuple_expression] = STATE(1237),
    [sym_array_expression] = STATE(1237),
    [sym_matrix_expression] = STATE(1237),
    [sym_generator_expression] = STATE(1855),
    [sym_array_comprehension_expression] = STATE(1237),
    [sym_function_expression] = STATE(1855),
    [sym_range_expression] = STATE(1855),
    [sym_coefficient_expression] = STATE(1855),
    [sym_quote_expression] = STATE(1855),
    [sym_interpolation_expression] = STATE(1855),
    [sym_macro_identifier] = STATE(28),
    [sym__literal] = STATE(1462),
    [sym_integer_literal] = STATE(1462),
    [sym_character_literal] = STATE(1462),
    [sym_string_literal] = STATE(1462),
    [sym_command_literal] = STATE(1462),
    [sym_prefixed_string_literal] = STATE(1462),
    [sym_prefixed_command_literal] = STATE(1462),
    [aux_sym_macro_argument_list_repeat1] = STATE(50),
    [sym_identifier] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_end] = ACTIONS(193),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_primitive] = ACTIONS(616),
    [aux_sym_primitive_definition_token1] = ACTIONS(618),
    [anon_sym_mutable] = ACTIONS(620),
    [anon_sym_struct] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_macro] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_COMMA] = ACTIONS(195),
    [anon_sym_RPAREN] = ACTIONS(195),
    [anon_sym_SEMI] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(195),
    [anon_sym_COLON_COLON] = ACTIONS(195),
    [anon_sym_RBRACE] = ACTIONS(195),
    [anon_sym_LT_COLON] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [sym_break_statement] = ACTIONS(638),
    [sym_continue_statement] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(644),
    [anon_sym_quote] = ACTIONS(646),
    [anon_sym_using] = ACTIONS(648),
    [anon_sym_import] = ACTIONS(648),
    [anon_sym_export] = ACTIONS(650),
    [anon_sym_COLON2] = ACTIONS(652),
    [anon_sym_RBRACK] = ACTIONS(195),
    [anon_sym_begin] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(195),
    [anon_sym_PIPE_GT] = ACTIONS(195),
    [anon_sym_in] = ACTIONS(193),
    [anon_sym_isa] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(195),
    [anon_sym_AMP_AMP] = ACTIONS(195),
    [anon_sym_QMARK] = ACTIONS(195),
    [anon_sym_EQ_GT] = ACTIONS(195),
    [anon_sym_LBRACK2] = ACTIONS(658),
    [anon_sym_DOLLAR] = ACTIONS(660),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(664),
    [aux_sym_integer_literal_token2] = ACTIONS(664),
    [aux_sym_integer_literal_token3] = ACTIONS(666),
    [sym_float_literal] = ACTIONS(668),
    [sym__unary_operator] = ACTIONS(670),
    [sym__power_operator] = ACTIONS(672),
    [sym__bitshift_operator] = ACTIONS(672),
    [sym__rational_operator] = ACTIONS(672),
    [sym__times_operator] = ACTIONS(674),
    [sym__plus_operator] = ACTIONS(674),
    [sym__dotty_operator] = ACTIONS(674),
    [sym__comparison_operator] = ACTIONS(674),
    [sym__arrow_operator] = ACTIONS(195),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(678),
    [sym__command_start] = ACTIONS(680),
  },
  [61] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(3882),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1711),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(33),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [sym_identifier] = ACTIONS(748),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(304),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LT_COLON] = ACTIONS(304),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(304),
    [anon_sym_else] = ACTIONS(304),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(750),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(304),
    [anon_sym_PIPE_GT] = ACTIONS(304),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_EQ_GT] = ACTIONS(304),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(752),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(754),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(304),
    [anon_sym_LF] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [62] = {
    [sym_function_definition] = STATE(1855),
    [sym_abstract_definition] = STATE(1855),
    [sym_primitive_definition] = STATE(1855),
    [sym_struct_definition] = STATE(1855),
    [sym_module_definition] = STATE(1855),
    [sym_macro_definition] = STATE(1855),
    [sym_parameter_list] = STATE(4171),
    [sym_if_statement] = STATE(1855),
    [sym_try_statement] = STATE(1855),
    [sym_for_statement] = STATE(1855),
    [sym_while_statement] = STATE(1855),
    [sym_return_statement] = STATE(1855),
    [sym_let_statement] = STATE(1855),
    [sym_const_statement] = STATE(1855),
    [sym_quote_statement] = STATE(1855),
    [sym_import_statement] = STATE(1855),
    [sym_export_statement] = STATE(1855),
    [sym__expression] = STATE(1833),
    [sym__primary_expression] = STATE(1237),
    [sym_operator] = STATE(1461),
    [sym_parenthesized_expression] = STATE(1237),
    [sym_field_expression] = STATE(1088),
    [sym_subscript_expression] = STATE(1237),
    [sym_typed_expression] = STATE(1855),
    [sym_parameterized_identifier] = STATE(1237),
    [sym_compound_expression] = STATE(1855),
    [sym_call_expression] = STATE(1237),
    [sym_broadcast_call_expression] = STATE(1237),
    [sym_macro_expression] = STATE(1855),
    [sym_spread_expression] = STATE(1855),
    [sym_unary_expression] = STATE(1855),
    [sym_binary_expression] = STATE(1855),
    [sym_ternary_expression] = STATE(1855),
    [sym_pair_expression] = STATE(1855),
    [sym_tuple_expression] = STATE(1237),
    [sym_array_expression] = STATE(1237),
    [sym_matrix_expression] = STATE(1237),
    [sym_generator_expression] = STATE(1855),
    [sym_array_comprehension_expression] = STATE(1237),
    [sym_function_expression] = STATE(1855),
    [sym_range_expression] = STATE(1855),
    [sym_coefficient_expression] = STATE(1855),
    [sym_quote_expression] = STATE(1855),
    [sym_interpolation_expression] = STATE(1855),
    [sym_macro_identifier] = STATE(28),
    [sym__literal] = STATE(1462),
    [sym_integer_literal] = STATE(1462),
    [sym_character_literal] = STATE(1462),
    [sym_string_literal] = STATE(1462),
    [sym_command_literal] = STATE(1462),
    [sym_prefixed_string_literal] = STATE(1462),
    [sym_prefixed_command_literal] = STATE(1462),
    [sym_identifier] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_primitive] = ACTIONS(616),
    [aux_sym_primitive_definition_token1] = ACTIONS(618),
    [anon_sym_mutable] = ACTIONS(620),
    [anon_sym_struct] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_macro] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_COMMA] = ACTIONS(306),
    [anon_sym_RPAREN] = ACTIONS(306),
    [anon_sym_SEMI] = ACTIONS(306),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(306),
    [anon_sym_COLON_COLON] = ACTIONS(306),
    [anon_sym_RBRACE] = ACTIONS(306),
    [anon_sym_LT_COLON] = ACTIONS(306),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [sym_break_statement] = ACTIONS(638),
    [sym_continue_statement] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(644),
    [anon_sym_quote] = ACTIONS(646),
    [anon_sym_using] = ACTIONS(648),
    [anon_sym_import] = ACTIONS(648),
    [anon_sym_export] = ACTIONS(650),
    [anon_sym_COLON2] = ACTIONS(652),
    [anon_sym_RBRACK] = ACTIONS(306),
    [anon_sym_begin] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(306),
    [anon_sym_PIPE_GT] = ACTIONS(306),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(306),
    [anon_sym_AMP_AMP] = ACTIONS(306),
    [anon_sym_QMARK] = ACTIONS(306),
    [anon_sym_EQ_GT] = ACTIONS(306),
    [anon_sym_LBRACK2] = ACTIONS(658),
    [anon_sym_DOLLAR] = ACTIONS(660),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(664),
    [aux_sym_integer_literal_token2] = ACTIONS(664),
    [aux_sym_integer_literal_token3] = ACTIONS(666),
    [sym_float_literal] = ACTIONS(668),
    [sym__unary_operator] = ACTIONS(670),
    [sym__power_operator] = ACTIONS(672),
    [sym__bitshift_operator] = ACTIONS(672),
    [sym__rational_operator] = ACTIONS(672),
    [sym__times_operator] = ACTIONS(674),
    [sym__plus_operator] = ACTIONS(674),
    [sym__dotty_operator] = ACTIONS(674),
    [sym__comparison_operator] = ACTIONS(674),
    [sym__arrow_operator] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(678),
    [sym__command_start] = ACTIONS(680),
  },
  [63] = {
    [sym__expression_list] = STATE(4066),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1251),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(1253),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(1255),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [64] = {
    [sym_function_definition] = STATE(1855),
    [sym_abstract_definition] = STATE(1855),
    [sym_primitive_definition] = STATE(1855),
    [sym_struct_definition] = STATE(1855),
    [sym_module_definition] = STATE(1855),
    [sym_macro_definition] = STATE(1855),
    [sym_parameter_list] = STATE(4171),
    [sym_if_statement] = STATE(1855),
    [sym_try_statement] = STATE(1855),
    [sym_for_statement] = STATE(1855),
    [sym_while_statement] = STATE(1855),
    [sym_return_statement] = STATE(1855),
    [sym_let_statement] = STATE(1855),
    [sym_const_statement] = STATE(1855),
    [sym_quote_statement] = STATE(1855),
    [sym_import_statement] = STATE(1855),
    [sym_export_statement] = STATE(1855),
    [sym__expression] = STATE(1839),
    [sym__primary_expression] = STATE(1237),
    [sym_operator] = STATE(1461),
    [sym_parenthesized_expression] = STATE(1237),
    [sym_field_expression] = STATE(1088),
    [sym_subscript_expression] = STATE(1237),
    [sym_typed_expression] = STATE(1855),
    [sym_parameterized_identifier] = STATE(1237),
    [sym_compound_expression] = STATE(1855),
    [sym_call_expression] = STATE(1237),
    [sym_broadcast_call_expression] = STATE(1237),
    [sym_macro_expression] = STATE(1855),
    [sym_spread_expression] = STATE(1855),
    [sym_unary_expression] = STATE(1855),
    [sym_binary_expression] = STATE(1855),
    [sym_ternary_expression] = STATE(1855),
    [sym_pair_expression] = STATE(1855),
    [sym_tuple_expression] = STATE(1237),
    [sym_array_expression] = STATE(1237),
    [sym_matrix_expression] = STATE(1237),
    [sym_generator_expression] = STATE(1855),
    [sym_array_comprehension_expression] = STATE(1237),
    [sym_function_expression] = STATE(1855),
    [sym_range_expression] = STATE(1855),
    [sym_coefficient_expression] = STATE(1855),
    [sym_quote_expression] = STATE(1855),
    [sym_interpolation_expression] = STATE(1855),
    [sym_macro_identifier] = STATE(28),
    [sym__literal] = STATE(1462),
    [sym_integer_literal] = STATE(1462),
    [sym_character_literal] = STATE(1462),
    [sym_string_literal] = STATE(1462),
    [sym_command_literal] = STATE(1462),
    [sym_prefixed_string_literal] = STATE(1462),
    [sym_prefixed_command_literal] = STATE(1462),
    [sym_identifier] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_end] = ACTIONS(466),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_primitive] = ACTIONS(616),
    [aux_sym_primitive_definition_token1] = ACTIONS(618),
    [anon_sym_mutable] = ACTIONS(620),
    [anon_sym_struct] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_macro] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_COMMA] = ACTIONS(468),
    [anon_sym_RPAREN] = ACTIONS(468),
    [anon_sym_SEMI] = ACTIONS(468),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(468),
    [anon_sym_COLON_COLON] = ACTIONS(468),
    [anon_sym_RBRACE] = ACTIONS(468),
    [anon_sym_LT_COLON] = ACTIONS(468),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [sym_break_statement] = ACTIONS(638),
    [sym_continue_statement] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(644),
    [anon_sym_quote] = ACTIONS(646),
    [anon_sym_using] = ACTIONS(648),
    [anon_sym_import] = ACTIONS(648),
    [anon_sym_export] = ACTIONS(650),
    [anon_sym_COLON2] = ACTIONS(652),
    [anon_sym_RBRACK] = ACTIONS(468),
    [anon_sym_begin] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_LT_PIPE] = ACTIONS(468),
    [anon_sym_PIPE_GT] = ACTIONS(468),
    [anon_sym_in] = ACTIONS(466),
    [anon_sym_isa] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(468),
    [anon_sym_AMP_AMP] = ACTIONS(468),
    [anon_sym_QMARK] = ACTIONS(468),
    [anon_sym_EQ_GT] = ACTIONS(468),
    [anon_sym_LBRACK2] = ACTIONS(658),
    [anon_sym_DOLLAR] = ACTIONS(660),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(664),
    [aux_sym_integer_literal_token2] = ACTIONS(664),
    [aux_sym_integer_literal_token3] = ACTIONS(666),
    [sym_float_literal] = ACTIONS(668),
    [sym__unary_operator] = ACTIONS(670),
    [sym__power_operator] = ACTIONS(672),
    [sym__bitshift_operator] = ACTIONS(672),
    [sym__rational_operator] = ACTIONS(672),
    [sym__times_operator] = ACTIONS(674),
    [sym__plus_operator] = ACTIONS(674),
    [sym__dotty_operator] = ACTIONS(674),
    [sym__comparison_operator] = ACTIONS(674),
    [sym__arrow_operator] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(678),
    [sym__command_start] = ACTIONS(680),
  },
  [65] = {
    [sym_function_definition] = STATE(1855),
    [sym_abstract_definition] = STATE(1855),
    [sym_primitive_definition] = STATE(1855),
    [sym_struct_definition] = STATE(1855),
    [sym_module_definition] = STATE(1855),
    [sym_macro_definition] = STATE(1855),
    [sym_parameter_list] = STATE(3801),
    [sym_if_statement] = STATE(1855),
    [sym_try_statement] = STATE(1855),
    [sym_for_statement] = STATE(1855),
    [sym_while_statement] = STATE(1855),
    [sym_return_statement] = STATE(1855),
    [sym_let_statement] = STATE(1855),
    [sym_const_statement] = STATE(1855),
    [sym_quote_statement] = STATE(1855),
    [sym_import_statement] = STATE(1855),
    [sym_export_statement] = STATE(1855),
    [sym__expression] = STATE(1920),
    [sym__primary_expression] = STATE(1237),
    [sym_operator] = STATE(1461),
    [sym_parenthesized_expression] = STATE(1237),
    [sym_field_expression] = STATE(1088),
    [sym_subscript_expression] = STATE(1237),
    [sym_typed_expression] = STATE(1855),
    [sym_parameterized_identifier] = STATE(1237),
    [sym_compound_expression] = STATE(1855),
    [sym_call_expression] = STATE(1237),
    [sym_broadcast_call_expression] = STATE(1237),
    [sym_macro_expression] = STATE(1855),
    [sym_macro_argument_list] = STATE(2581),
    [sym_spread_expression] = STATE(1855),
    [sym_unary_expression] = STATE(1855),
    [sym_binary_expression] = STATE(1855),
    [sym_ternary_expression] = STATE(1855),
    [sym_pair_expression] = STATE(1855),
    [sym_tuple_expression] = STATE(1237),
    [sym_array_expression] = STATE(1237),
    [sym_matrix_expression] = STATE(1237),
    [sym_generator_expression] = STATE(1855),
    [sym_array_comprehension_expression] = STATE(1237),
    [sym_function_expression] = STATE(1855),
    [sym_range_expression] = STATE(1855),
    [sym_coefficient_expression] = STATE(1855),
    [sym_quote_expression] = STATE(1855),
    [sym_interpolation_expression] = STATE(1855),
    [sym_macro_identifier] = STATE(52),
    [sym__literal] = STATE(1462),
    [sym_integer_literal] = STATE(1462),
    [sym_character_literal] = STATE(1462),
    [sym_string_literal] = STATE(1462),
    [sym_command_literal] = STATE(1462),
    [sym_prefixed_string_literal] = STATE(1462),
    [sym_prefixed_command_literal] = STATE(1462),
    [aux_sym_macro_argument_list_repeat1] = STATE(80),
    [sym_identifier] = ACTIONS(1045),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_end] = ACTIONS(125),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_primitive] = ACTIONS(616),
    [aux_sym_primitive_definition_token1] = ACTIONS(618),
    [anon_sym_mutable] = ACTIONS(620),
    [anon_sym_struct] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_macro] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_RPAREN] = ACTIONS(183),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(183),
    [anon_sym_COLON_COLON] = ACTIONS(183),
    [anon_sym_LT_COLON] = ACTIONS(183),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [sym_break_statement] = ACTIONS(638),
    [sym_continue_statement] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(644),
    [anon_sym_quote] = ACTIONS(646),
    [anon_sym_using] = ACTIONS(648),
    [anon_sym_import] = ACTIONS(648),
    [anon_sym_export] = ACTIONS(650),
    [anon_sym_COLON2] = ACTIONS(1047),
    [anon_sym_RBRACK] = ACTIONS(183),
    [anon_sym_begin] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(125),
    [anon_sym_LT_PIPE] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_in] = ACTIONS(125),
    [anon_sym_isa] = ACTIONS(125),
    [anon_sym_PIPE_PIPE] = ACTIONS(183),
    [anon_sym_AMP_AMP] = ACTIONS(183),
    [anon_sym_QMARK] = ACTIONS(183),
    [anon_sym_EQ_GT] = ACTIONS(183),
    [anon_sym_LBRACK2] = ACTIONS(658),
    [anon_sym_DOLLAR] = ACTIONS(1049),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(664),
    [aux_sym_integer_literal_token2] = ACTIONS(664),
    [aux_sym_integer_literal_token3] = ACTIONS(666),
    [sym_float_literal] = ACTIONS(668),
    [sym__unary_operator] = ACTIONS(1051),
    [sym__power_operator] = ACTIONS(672),
    [sym__bitshift_operator] = ACTIONS(672),
    [sym__rational_operator] = ACTIONS(672),
    [sym__times_operator] = ACTIONS(674),
    [sym__plus_operator] = ACTIONS(674),
    [sym__dotty_operator] = ACTIONS(674),
    [sym__comparison_operator] = ACTIONS(674),
    [sym__arrow_operator] = ACTIONS(183),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(758),
    [sym__string_start] = ACTIONS(678),
    [sym__command_start] = ACTIONS(680),
  },
  [66] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(4236),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1711),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(42),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [sym_identifier] = ACTIONS(476),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_SEMI] = ACTIONS(304),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(304),
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_LT_COLON] = ACTIONS(304),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(304),
    [anon_sym_else] = ACTIONS(304),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(518),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(304),
    [anon_sym_PIPE_GT] = ACTIONS(304),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(304),
    [anon_sym_AMP_AMP] = ACTIONS(304),
    [anon_sym_QMARK] = ACTIONS(304),
    [anon_sym_EQ_GT] = ACTIONS(304),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(534),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(304),
    [anon_sym_LF] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [67] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(4236),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1893),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(42),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [aux_sym_macro_argument_list_repeat1] = STATE(69),
    [sym_identifier] = ACTIONS(476),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(193),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(193),
    [anon_sym_COLON_COLON] = ACTIONS(193),
    [anon_sym_LT_COLON] = ACTIONS(193),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(193),
    [anon_sym_else] = ACTIONS(193),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(518),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(193),
    [anon_sym_PIPE_GT] = ACTIONS(193),
    [anon_sym_in] = ACTIONS(193),
    [anon_sym_isa] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(193),
    [anon_sym_AMP_AMP] = ACTIONS(193),
    [anon_sym_QMARK] = ACTIONS(193),
    [anon_sym_EQ_GT] = ACTIONS(193),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(534),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(193),
    [anon_sym_LF] = ACTIONS(195),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [68] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(3882),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1865),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(33),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [sym_identifier] = ACTIONS(748),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(466),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(466),
    [anon_sym_SEMI] = ACTIONS(466),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(466),
    [anon_sym_COLON_COLON] = ACTIONS(466),
    [anon_sym_LT_COLON] = ACTIONS(466),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(466),
    [anon_sym_else] = ACTIONS(466),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(750),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_LT_PIPE] = ACTIONS(466),
    [anon_sym_PIPE_GT] = ACTIONS(466),
    [anon_sym_in] = ACTIONS(466),
    [anon_sym_isa] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(466),
    [anon_sym_AMP_AMP] = ACTIONS(466),
    [anon_sym_QMARK] = ACTIONS(466),
    [anon_sym_EQ_GT] = ACTIONS(466),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(752),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(754),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(466),
    [anon_sym_LF] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [69] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(4236),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1893),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(42),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [aux_sym_macro_argument_list_repeat1] = STATE(69),
    [sym_identifier] = ACTIONS(1257),
    [anon_sym_function] = ACTIONS(1155),
    [anon_sym_end] = ACTIONS(203),
    [anon_sym_abstract] = ACTIONS(1158),
    [anon_sym_primitive] = ACTIONS(1161),
    [aux_sym_primitive_definition_token1] = ACTIONS(1164),
    [anon_sym_mutable] = ACTIONS(1167),
    [anon_sym_struct] = ACTIONS(1170),
    [anon_sym_module] = ACTIONS(1173),
    [anon_sym_macro] = ACTIONS(1176),
    [anon_sym_LPAREN] = ACTIONS(1179),
    [anon_sym_SEMI] = ACTIONS(203),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(203),
    [anon_sym_COLON_COLON] = ACTIONS(203),
    [anon_sym_LT_COLON] = ACTIONS(203),
    [anon_sym_if] = ACTIONS(1182),
    [anon_sym_elseif] = ACTIONS(203),
    [anon_sym_else] = ACTIONS(203),
    [anon_sym_try] = ACTIONS(1185),
    [anon_sym_for] = ACTIONS(1188),
    [anon_sym_while] = ACTIONS(1191),
    [sym_break_statement] = ACTIONS(1194),
    [sym_continue_statement] = ACTIONS(1194),
    [anon_sym_return] = ACTIONS(1197),
    [anon_sym_let] = ACTIONS(1200),
    [anon_sym_const] = ACTIONS(1203),
    [anon_sym_quote] = ACTIONS(1206),
    [anon_sym_using] = ACTIONS(1209),
    [anon_sym_import] = ACTIONS(1209),
    [anon_sym_export] = ACTIONS(1212),
    [anon_sym_COLON2] = ACTIONS(1260),
    [anon_sym_begin] = ACTIONS(1218),
    [anon_sym_SQUOTE] = ACTIONS(1221),
    [anon_sym_PLUS] = ACTIONS(203),
    [anon_sym_LT_PIPE] = ACTIONS(203),
    [anon_sym_PIPE_GT] = ACTIONS(203),
    [anon_sym_in] = ACTIONS(203),
    [anon_sym_isa] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(203),
    [anon_sym_EQ_GT] = ACTIONS(203),
    [anon_sym_LBRACK2] = ACTIONS(1224),
    [anon_sym_DOLLAR] = ACTIONS(1263),
    [anon_sym_AT] = ACTIONS(1230),
    [aux_sym_integer_literal_token1] = ACTIONS(1233),
    [aux_sym_integer_literal_token2] = ACTIONS(1233),
    [aux_sym_integer_literal_token3] = ACTIONS(1233),
    [sym_float_literal] = ACTIONS(1236),
    [sym__unary_operator] = ACTIONS(1266),
    [sym__power_operator] = ACTIONS(1242),
    [sym__bitshift_operator] = ACTIONS(1242),
    [sym__rational_operator] = ACTIONS(1242),
    [sym__times_operator] = ACTIONS(1242),
    [sym__plus_operator] = ACTIONS(1242),
    [sym__dotty_operator] = ACTIONS(1242),
    [sym__comparison_operator] = ACTIONS(1242),
    [sym__arrow_operator] = ACTIONS(203),
    [anon_sym_LF] = ACTIONS(292),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(1245),
    [sym__command_start] = ACTIONS(1248),
  },
  [70] = {
    [sym__expression_list] = STATE(3928),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1269),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(1271),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(1273),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [71] = {
    [sym__expression_list] = STATE(4001),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1275),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(1277),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(1279),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [72] = {
    [sym__expression_list] = STATE(4143),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1281),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(1283),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(1285),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [73] = {
    [sym__expression_list] = STATE(4218),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1287),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(1289),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(1291),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [74] = {
    [sym__expression_list] = STATE(3989),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1293),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(1295),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(1297),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [75] = {
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4197),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2643),
    [sym__primary_expression] = STATE(1995),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(26),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [ts_builtin_sym_end] = ACTIONS(468),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(15),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_COMMA] = ACTIONS(466),
    [anon_sym_SEMI] = ACTIONS(466),
    [anon_sym_EQ] = ACTIONS(466),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(466),
    [anon_sym_COLON_COLON] = ACTIONS(466),
    [anon_sym_LT_COLON] = ACTIONS(466),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(37),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(41),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(936),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(99),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_LT_PIPE] = ACTIONS(466),
    [anon_sym_PIPE_GT] = ACTIONS(466),
    [anon_sym_in] = ACTIONS(466),
    [anon_sym_isa] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(466),
    [anon_sym_AMP_AMP] = ACTIONS(466),
    [anon_sym_QMARK] = ACTIONS(466),
    [anon_sym_EQ_GT] = ACTIONS(466),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(938),
    [anon_sym_AT] = ACTIONS(594),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(65),
    [sym__unary_operator] = ACTIONS(67),
    [sym__power_operator] = ACTIONS(71),
    [sym__bitshift_operator] = ACTIONS(71),
    [sym__rational_operator] = ACTIONS(71),
    [sym__times_operator] = ACTIONS(71),
    [sym__plus_operator] = ACTIONS(71),
    [sym__dotty_operator] = ACTIONS(71),
    [sym__comparison_operator] = ACTIONS(71),
    [sym__arrow_operator] = ACTIONS(466),
    [sym__assign_operator] = ACTIONS(466),
    [anon_sym_LF] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [76] = {
    [sym_function_definition] = STATE(2557),
    [sym_abstract_definition] = STATE(2557),
    [sym_primitive_definition] = STATE(2557),
    [sym_struct_definition] = STATE(2557),
    [sym_module_definition] = STATE(2557),
    [sym_macro_definition] = STATE(2557),
    [sym_parameter_list] = STATE(3815),
    [sym_if_statement] = STATE(2557),
    [sym_try_statement] = STATE(2557),
    [sym_for_statement] = STATE(2557),
    [sym_while_statement] = STATE(2557),
    [sym_return_statement] = STATE(2557),
    [sym_let_statement] = STATE(2557),
    [sym_const_statement] = STATE(2557),
    [sym_quote_statement] = STATE(2557),
    [sym_import_statement] = STATE(2557),
    [sym_export_statement] = STATE(2557),
    [sym__expression] = STATE(2502),
    [sym__primary_expression] = STATE(2256),
    [sym_operator] = STATE(2451),
    [sym_parenthesized_expression] = STATE(2256),
    [sym_field_expression] = STATE(2089),
    [sym_subscript_expression] = STATE(2256),
    [sym_typed_expression] = STATE(2557),
    [sym_parameterized_identifier] = STATE(2256),
    [sym_compound_expression] = STATE(2557),
    [sym_call_expression] = STATE(2256),
    [sym_broadcast_call_expression] = STATE(2256),
    [sym_macro_expression] = STATE(2557),
    [sym_spread_expression] = STATE(2557),
    [sym_unary_expression] = STATE(2557),
    [sym_binary_expression] = STATE(2557),
    [sym_ternary_expression] = STATE(2557),
    [sym_pair_expression] = STATE(2557),
    [sym_tuple_expression] = STATE(2256),
    [sym_array_expression] = STATE(2256),
    [sym_matrix_expression] = STATE(2256),
    [sym_generator_expression] = STATE(2557),
    [sym_array_comprehension_expression] = STATE(2256),
    [sym_function_expression] = STATE(2557),
    [sym_range_expression] = STATE(2557),
    [sym_coefficient_expression] = STATE(2557),
    [sym_quote_expression] = STATE(2557),
    [sym_interpolation_expression] = STATE(2557),
    [sym_macro_identifier] = STATE(37),
    [sym__literal] = STATE(2449),
    [sym_integer_literal] = STATE(2449),
    [sym_character_literal] = STATE(2449),
    [sym_string_literal] = STATE(2449),
    [sym_command_literal] = STATE(2449),
    [sym_prefixed_string_literal] = STATE(2449),
    [sym_prefixed_command_literal] = STATE(2449),
    [sym_identifier] = ACTIONS(868),
    [anon_sym_function] = ACTIONS(870),
    [anon_sym_end] = ACTIONS(466),
    [anon_sym_abstract] = ACTIONS(872),
    [anon_sym_primitive] = ACTIONS(874),
    [aux_sym_primitive_definition_token1] = ACTIONS(876),
    [anon_sym_mutable] = ACTIONS(878),
    [anon_sym_struct] = ACTIONS(880),
    [anon_sym_module] = ACTIONS(882),
    [anon_sym_macro] = ACTIONS(884),
    [anon_sym_LPAREN] = ACTIONS(886),
    [anon_sym_COMMA] = ACTIONS(468),
    [anon_sym_RPAREN] = ACTIONS(468),
    [anon_sym_SEMI] = ACTIONS(468),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(468),
    [anon_sym_COLON_COLON] = ACTIONS(468),
    [anon_sym_RBRACE] = ACTIONS(468),
    [anon_sym_LT_COLON] = ACTIONS(468),
    [anon_sym_if] = ACTIONS(888),
    [anon_sym_try] = ACTIONS(890),
    [anon_sym_for] = ACTIONS(892),
    [anon_sym_while] = ACTIONS(894),
    [sym_break_statement] = ACTIONS(896),
    [sym_continue_statement] = ACTIONS(896),
    [anon_sym_return] = ACTIONS(898),
    [anon_sym_let] = ACTIONS(900),
    [anon_sym_const] = ACTIONS(902),
    [anon_sym_quote] = ACTIONS(904),
    [anon_sym_using] = ACTIONS(906),
    [anon_sym_import] = ACTIONS(906),
    [anon_sym_export] = ACTIONS(908),
    [anon_sym_COLON2] = ACTIONS(910),
    [anon_sym_RBRACK] = ACTIONS(468),
    [anon_sym_begin] = ACTIONS(912),
    [anon_sym_SQUOTE] = ACTIONS(914),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_LT_PIPE] = ACTIONS(468),
    [anon_sym_PIPE_GT] = ACTIONS(468),
    [anon_sym_in] = ACTIONS(466),
    [anon_sym_isa] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(468),
    [anon_sym_AMP_AMP] = ACTIONS(468),
    [anon_sym_QMARK] = ACTIONS(468),
    [anon_sym_EQ_GT] = ACTIONS(468),
    [anon_sym_LBRACK2] = ACTIONS(916),
    [anon_sym_DOLLAR] = ACTIONS(918),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(920),
    [aux_sym_integer_literal_token2] = ACTIONS(920),
    [aux_sym_integer_literal_token3] = ACTIONS(922),
    [sym_float_literal] = ACTIONS(924),
    [sym__unary_operator] = ACTIONS(926),
    [sym__power_operator] = ACTIONS(928),
    [sym__bitshift_operator] = ACTIONS(928),
    [sym__rational_operator] = ACTIONS(928),
    [sym__times_operator] = ACTIONS(930),
    [sym__plus_operator] = ACTIONS(930),
    [sym__dotty_operator] = ACTIONS(930),
    [sym__comparison_operator] = ACTIONS(930),
    [sym__arrow_operator] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(932),
    [sym__command_start] = ACTIONS(934),
  },
  [77] = {
    [sym_function_definition] = STATE(1713),
    [sym_abstract_definition] = STATE(1713),
    [sym_primitive_definition] = STATE(1713),
    [sym_struct_definition] = STATE(1713),
    [sym_module_definition] = STATE(1713),
    [sym_macro_definition] = STATE(1713),
    [sym_parameter_list] = STATE(4089),
    [sym_if_statement] = STATE(1713),
    [sym_try_statement] = STATE(1713),
    [sym_for_statement] = STATE(1713),
    [sym_while_statement] = STATE(1713),
    [sym_return_statement] = STATE(1713),
    [sym_let_statement] = STATE(1713),
    [sym_const_statement] = STATE(1713),
    [sym_quote_statement] = STATE(1713),
    [sym_import_statement] = STATE(1713),
    [sym_export_statement] = STATE(1713),
    [sym__expression] = STATE(1692),
    [sym__primary_expression] = STATE(1243),
    [sym_operator] = STATE(1492),
    [sym_parenthesized_expression] = STATE(1243),
    [sym_field_expression] = STATE(1012),
    [sym_subscript_expression] = STATE(1243),
    [sym_typed_expression] = STATE(1713),
    [sym_parameterized_identifier] = STATE(1243),
    [sym_compound_expression] = STATE(1713),
    [sym_call_expression] = STATE(1243),
    [sym_broadcast_call_expression] = STATE(1243),
    [sym_macro_expression] = STATE(1713),
    [sym_spread_expression] = STATE(1713),
    [sym_unary_expression] = STATE(1713),
    [sym_binary_expression] = STATE(1713),
    [sym_ternary_expression] = STATE(1713),
    [sym_pair_expression] = STATE(1713),
    [sym_tuple_expression] = STATE(1243),
    [sym_array_expression] = STATE(1243),
    [sym_matrix_expression] = STATE(1243),
    [sym_generator_expression] = STATE(1713),
    [sym_array_comprehension_expression] = STATE(1243),
    [sym_function_expression] = STATE(1713),
    [sym_range_expression] = STATE(1713),
    [sym_coefficient_expression] = STATE(1713),
    [sym_quote_expression] = STATE(1713),
    [sym_interpolation_expression] = STATE(1713),
    [sym_macro_identifier] = STATE(27),
    [sym__literal] = STATE(1494),
    [sym_integer_literal] = STATE(1494),
    [sym_character_literal] = STATE(1494),
    [sym_string_literal] = STATE(1494),
    [sym_command_literal] = STATE(1494),
    [sym_prefixed_string_literal] = STATE(1494),
    [sym_prefixed_command_literal] = STATE(1494),
    [ts_builtin_sym_end] = ACTIONS(468),
    [sym_identifier] = ACTIONS(542),
    [anon_sym_function] = ACTIONS(544),
    [anon_sym_abstract] = ACTIONS(546),
    [anon_sym_primitive] = ACTIONS(548),
    [aux_sym_primitive_definition_token1] = ACTIONS(550),
    [anon_sym_mutable] = ACTIONS(552),
    [anon_sym_struct] = ACTIONS(554),
    [anon_sym_module] = ACTIONS(556),
    [anon_sym_macro] = ACTIONS(558),
    [anon_sym_LPAREN] = ACTIONS(560),
    [anon_sym_COMMA] = ACTIONS(466),
    [anon_sym_SEMI] = ACTIONS(466),
    [anon_sym_EQ] = ACTIONS(466),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(466),
    [anon_sym_COLON_COLON] = ACTIONS(466),
    [anon_sym_LT_COLON] = ACTIONS(466),
    [anon_sym_if] = ACTIONS(562),
    [anon_sym_try] = ACTIONS(564),
    [anon_sym_for] = ACTIONS(566),
    [anon_sym_while] = ACTIONS(568),
    [sym_break_statement] = ACTIONS(570),
    [sym_continue_statement] = ACTIONS(570),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_let] = ACTIONS(574),
    [anon_sym_const] = ACTIONS(576),
    [anon_sym_quote] = ACTIONS(578),
    [anon_sym_using] = ACTIONS(580),
    [anon_sym_import] = ACTIONS(580),
    [anon_sym_export] = ACTIONS(582),
    [anon_sym_COLON2] = ACTIONS(584),
    [anon_sym_begin] = ACTIONS(586),
    [anon_sym_SQUOTE] = ACTIONS(588),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_LT_PIPE] = ACTIONS(466),
    [anon_sym_PIPE_GT] = ACTIONS(466),
    [anon_sym_in] = ACTIONS(466),
    [anon_sym_isa] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(466),
    [anon_sym_AMP_AMP] = ACTIONS(466),
    [anon_sym_QMARK] = ACTIONS(466),
    [anon_sym_EQ_GT] = ACTIONS(466),
    [anon_sym_LBRACK2] = ACTIONS(590),
    [anon_sym_DOLLAR] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(594),
    [aux_sym_integer_literal_token1] = ACTIONS(596),
    [aux_sym_integer_literal_token2] = ACTIONS(596),
    [aux_sym_integer_literal_token3] = ACTIONS(596),
    [sym_float_literal] = ACTIONS(598),
    [sym__unary_operator] = ACTIONS(600),
    [sym__power_operator] = ACTIONS(602),
    [sym__bitshift_operator] = ACTIONS(602),
    [sym__rational_operator] = ACTIONS(602),
    [sym__times_operator] = ACTIONS(602),
    [sym__plus_operator] = ACTIONS(602),
    [sym__dotty_operator] = ACTIONS(602),
    [sym__comparison_operator] = ACTIONS(602),
    [sym__arrow_operator] = ACTIONS(466),
    [sym__assign_operator] = ACTIONS(466),
    [anon_sym_LF] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(604),
    [sym__command_start] = ACTIONS(606),
  },
  [78] = {
    [sym__expression_list] = STATE(4273),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1299),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(1301),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(1303),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [79] = {
    [sym__expression_list] = STATE(3862),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2157),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_spread_expression] = STATE(2123),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_end] = ACTIONS(1305),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(1307),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(312),
    [anon_sym_COLON_COLON] = ACTIONS(314),
    [anon_sym_LT_COLON] = ACTIONS(314),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(320),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(324),
    [anon_sym_LT_PIPE] = ACTIONS(326),
    [anon_sym_PIPE_GT] = ACTIONS(328),
    [anon_sym_in] = ACTIONS(330),
    [anon_sym_isa] = ACTIONS(330),
    [anon_sym_PIPE_PIPE] = ACTIONS(332),
    [anon_sym_AMP_AMP] = ACTIONS(334),
    [anon_sym_QMARK] = ACTIONS(336),
    [anon_sym_EQ_GT] = ACTIONS(338),
    [anon_sym_LBRACK2] = ACTIONS(101),
    [anon_sym_DOLLAR] = ACTIONS(105),
    [anon_sym_AT] = ACTIONS(107),
    [aux_sym_integer_literal_token1] = ACTIONS(63),
    [aux_sym_integer_literal_token2] = ACTIONS(63),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(340),
    [sym__bitshift_operator] = ACTIONS(342),
    [sym__rational_operator] = ACTIONS(344),
    [sym__times_operator] = ACTIONS(346),
    [sym__plus_operator] = ACTIONS(348),
    [sym__dotty_operator] = ACTIONS(350),
    [sym__comparison_operator] = ACTIONS(352),
    [sym__arrow_operator] = ACTIONS(354),
    [anon_sym_LF] = ACTIONS(1309),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [80] = {
    [sym_function_definition] = STATE(1855),
    [sym_abstract_definition] = STATE(1855),
    [sym_primitive_definition] = STATE(1855),
    [sym_struct_definition] = STATE(1855),
    [sym_module_definition] = STATE(1855),
    [sym_macro_definition] = STATE(1855),
    [sym_parameter_list] = STATE(3801),
    [sym_if_statement] = STATE(1855),
    [sym_try_statement] = STATE(1855),
    [sym_for_statement] = STATE(1855),
    [sym_while_statement] = STATE(1855),
    [sym_return_statement] = STATE(1855),
    [sym_let_statement] = STATE(1855),
    [sym_const_statement] = STATE(1855),
    [sym_quote_statement] = STATE(1855),
    [sym_import_statement] = STATE(1855),
    [sym_export_statement] = STATE(1855),
    [sym__expression] = STATE(1920),
    [sym__primary_expression] = STATE(1237),
    [sym_operator] = STATE(1461),
    [sym_parenthesized_expression] = STATE(1237),
    [sym_field_expression] = STATE(1088),
    [sym_subscript_expression] = STATE(1237),
    [sym_typed_expression] = STATE(1855),
    [sym_parameterized_identifier] = STATE(1237),
    [sym_compound_expression] = STATE(1855),
    [sym_call_expression] = STATE(1237),
    [sym_broadcast_call_expression] = STATE(1237),
    [sym_macro_expression] = STATE(1855),
    [sym_spread_expression] = STATE(1855),
    [sym_unary_expression] = STATE(1855),
    [sym_binary_expression] = STATE(1855),
    [sym_ternary_expression] = STATE(1855),
    [sym_pair_expression] = STATE(1855),
    [sym_tuple_expression] = STATE(1237),
    [sym_array_expression] = STATE(1237),
    [sym_matrix_expression] = STATE(1237),
    [sym_generator_expression] = STATE(1855),
    [sym_array_comprehension_expression] = STATE(1237),
    [sym_function_expression] = STATE(1855),
    [sym_range_expression] = STATE(1855),
    [sym_coefficient_expression] = STATE(1855),
    [sym_quote_expression] = STATE(1855),
    [sym_interpolation_expression] = STATE(1855),
    [sym_macro_identifier] = STATE(52),
    [sym__literal] = STATE(1462),
    [sym_integer_literal] = STATE(1462),
    [sym_character_literal] = STATE(1462),
    [sym_string_literal] = STATE(1462),
    [sym_command_literal] = STATE(1462),
    [sym_prefixed_string_literal] = STATE(1462),
    [sym_prefixed_command_literal] = STATE(1462),
    [aux_sym_macro_argument_list_repeat1] = STATE(82),
    [sym_identifier] = ACTIONS(1045),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_end] = ACTIONS(193),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_primitive] = ACTIONS(616),
    [aux_sym_primitive_definition_token1] = ACTIONS(618),
    [anon_sym_mutable] = ACTIONS(620),
    [anon_sym_struct] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_macro] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_RPAREN] = ACTIONS(195),
    [anon_sym_SEMI] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(195),
    [anon_sym_COLON_COLON] = ACTIONS(195),
    [anon_sym_LT_COLON] = ACTIONS(195),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [sym_break_statement] = ACTIONS(638),
    [sym_continue_statement] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(644),
    [anon_sym_quote] = ACTIONS(646),
    [anon_sym_using] = ACTIONS(648),
    [anon_sym_import] = ACTIONS(648),
    [anon_sym_export] = ACTIONS(650),
    [anon_sym_COLON2] = ACTIONS(1047),
    [anon_sym_RBRACK] = ACTIONS(195),
    [anon_sym_begin] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(193),
    [anon_sym_LT_PIPE] = ACTIONS(195),
    [anon_sym_PIPE_GT] = ACTIONS(195),
    [anon_sym_in] = ACTIONS(193),
    [anon_sym_isa] = ACTIONS(193),
    [anon_sym_PIPE_PIPE] = ACTIONS(195),
    [anon_sym_AMP_AMP] = ACTIONS(195),
    [anon_sym_QMARK] = ACTIONS(195),
    [anon_sym_EQ_GT] = ACTIONS(195),
    [anon_sym_LBRACK2] = ACTIONS(658),
    [anon_sym_DOLLAR] = ACTIONS(1049),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(664),
    [aux_sym_integer_literal_token2] = ACTIONS(664),
    [aux_sym_integer_literal_token3] = ACTIONS(666),
    [sym_float_literal] = ACTIONS(668),
    [sym__unary_operator] = ACTIONS(1051),
    [sym__power_operator] = ACTIONS(672),
    [sym__bitshift_operator] = ACTIONS(672),
    [sym__rational_operator] = ACTIONS(672),
    [sym__times_operator] = ACTIONS(674),
    [sym__plus_operator] = ACTIONS(674),
    [sym__dotty_operator] = ACTIONS(674),
    [sym__comparison_operator] = ACTIONS(674),
    [sym__arrow_operator] = ACTIONS(195),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(678),
    [sym__command_start] = ACTIONS(680),
  },
  [81] = {
    [sym_function_definition] = STATE(1554),
    [sym_abstract_definition] = STATE(1554),
    [sym_primitive_definition] = STATE(1554),
    [sym_struct_definition] = STATE(1554),
    [sym_module_definition] = STATE(1554),
    [sym_macro_definition] = STATE(1554),
    [sym_parameter_list] = STATE(4236),
    [sym_if_statement] = STATE(1554),
    [sym_try_statement] = STATE(1554),
    [sym_for_statement] = STATE(1554),
    [sym_while_statement] = STATE(1554),
    [sym_return_statement] = STATE(1554),
    [sym_let_statement] = STATE(1554),
    [sym_const_statement] = STATE(1554),
    [sym_quote_statement] = STATE(1554),
    [sym_import_statement] = STATE(1554),
    [sym_export_statement] = STATE(1554),
    [sym__expression] = STATE(1908),
    [sym__primary_expression] = STATE(1203),
    [sym_operator] = STATE(1434),
    [sym_parenthesized_expression] = STATE(1203),
    [sym_field_expression] = STATE(1090),
    [sym_subscript_expression] = STATE(1203),
    [sym_typed_expression] = STATE(1554),
    [sym_parameterized_identifier] = STATE(1203),
    [sym_compound_expression] = STATE(1554),
    [sym_call_expression] = STATE(1203),
    [sym_broadcast_call_expression] = STATE(1203),
    [sym_macro_expression] = STATE(1554),
    [sym_spread_expression] = STATE(1554),
    [sym_unary_expression] = STATE(1554),
    [sym_binary_expression] = STATE(1554),
    [sym_ternary_expression] = STATE(1554),
    [sym_pair_expression] = STATE(1554),
    [sym_tuple_expression] = STATE(1203),
    [sym_array_expression] = STATE(1203),
    [sym_matrix_expression] = STATE(1203),
    [sym_generator_expression] = STATE(1554),
    [sym_array_comprehension_expression] = STATE(1203),
    [sym_function_expression] = STATE(1554),
    [sym_range_expression] = STATE(1554),
    [sym_coefficient_expression] = STATE(1554),
    [sym_quote_expression] = STATE(1554),
    [sym_interpolation_expression] = STATE(1554),
    [sym_macro_identifier] = STATE(42),
    [sym__literal] = STATE(1435),
    [sym_integer_literal] = STATE(1435),
    [sym_character_literal] = STATE(1435),
    [sym_string_literal] = STATE(1435),
    [sym_command_literal] = STATE(1435),
    [sym_prefixed_string_literal] = STATE(1435),
    [sym_prefixed_command_literal] = STATE(1435),
    [sym_identifier] = ACTIONS(476),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_end] = ACTIONS(466),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_primitive] = ACTIONS(482),
    [aux_sym_primitive_definition_token1] = ACTIONS(484),
    [anon_sym_mutable] = ACTIONS(486),
    [anon_sym_struct] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(490),
    [anon_sym_macro] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_SEMI] = ACTIONS(466),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(466),
    [anon_sym_COLON_COLON] = ACTIONS(466),
    [anon_sym_LT_COLON] = ACTIONS(466),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_elseif] = ACTIONS(466),
    [anon_sym_else] = ACTIONS(466),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(502),
    [sym_break_statement] = ACTIONS(504),
    [sym_continue_statement] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_let] = ACTIONS(508),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_quote] = ACTIONS(512),
    [anon_sym_using] = ACTIONS(514),
    [anon_sym_import] = ACTIONS(514),
    [anon_sym_export] = ACTIONS(516),
    [anon_sym_COLON2] = ACTIONS(518),
    [anon_sym_begin] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(522),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_LT_PIPE] = ACTIONS(466),
    [anon_sym_PIPE_GT] = ACTIONS(466),
    [anon_sym_in] = ACTIONS(466),
    [anon_sym_isa] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(466),
    [anon_sym_AMP_AMP] = ACTIONS(466),
    [anon_sym_QMARK] = ACTIONS(466),
    [anon_sym_EQ_GT] = ACTIONS(466),
    [anon_sym_LBRACK2] = ACTIONS(524),
    [anon_sym_DOLLAR] = ACTIONS(526),
    [anon_sym_AT] = ACTIONS(528),
    [aux_sym_integer_literal_token1] = ACTIONS(530),
    [aux_sym_integer_literal_token2] = ACTIONS(530),
    [aux_sym_integer_literal_token3] = ACTIONS(530),
    [sym_float_literal] = ACTIONS(532),
    [sym__unary_operator] = ACTIONS(534),
    [sym__power_operator] = ACTIONS(536),
    [sym__bitshift_operator] = ACTIONS(536),
    [sym__rational_operator] = ACTIONS(536),
    [sym__times_operator] = ACTIONS(536),
    [sym__plus_operator] = ACTIONS(536),
    [sym__dotty_operator] = ACTIONS(536),
    [sym__comparison_operator] = ACTIONS(536),
    [sym__arrow_operator] = ACTIONS(466),
    [anon_sym_LF] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(115),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(538),
    [sym__command_start] = ACTIONS(540),
  },
  [82] = {
    [sym_function_definition] = STATE(1855),
    [sym_abstract_definition] = STATE(1855),
    [sym_primitive_definition] = STATE(1855),
    [sym_struct_definition] = STATE(1855),
    [sym_module_definition] = STATE(1855),
    [sym_macro_definition] = STATE(1855),
    [sym_parameter_list] = STATE(3801),
    [sym_if_statement] = STATE(1855),
    [sym_try_statement] = STATE(1855),
    [sym_for_statement] = STATE(1855),
    [sym_while_statement] = STATE(1855),
    [sym_return_statement] = STATE(1855),
    [sym_let_statement] = STATE(1855),
    [sym_const_statement] = STATE(1855),
    [sym_quote_statement] = STATE(1855),
    [sym_import_statement] = STATE(1855),
    [sym_export_statement] = STATE(1855),
    [sym__expression] = STATE(1920),
    [sym__primary_expression] = STATE(1237),
    [sym_operator] = STATE(1461),
    [sym_parenthesized_expression] = STATE(1237),
    [sym_field_expression] = STATE(1088),
    [sym_subscript_expression] = STATE(1237),
    [sym_typed_expression] = STATE(1855),
    [sym_parameterized_identifier] = STATE(1237),
    [sym_compound_expression] = STATE(1855),
    [sym_call_expression] = STATE(1237),
    [sym_broadcast_call_expression] = STATE(1237),
    [sym_macro_expression] = STATE(1855),
    [sym_spread_expression] = STATE(1855),
    [sym_unary_expression] = STATE(1855),
    [sym_binary_expression] = STATE(1855),
    [sym_ternary_expression] = STATE(1855),
    [sym_pair_expression] = STATE(1855),
    [sym_tuple_expression] = STATE(1237),
    [sym_array_expression] = STATE(1237),
    [sym_matrix_expression] = STATE(1237),
    [sym_generator_expression] = STATE(1855),
    [sym_array_comprehension_expression] = STATE(1237),
    [sym_function_expression] = STATE(1855),
    [sym_range_expression] = STATE(1855),
    [sym_coefficient_expression] = STATE(1855),
    [sym_quote_expression] = STATE(1855),
    [sym_interpolation_expression] = STATE(1855),
    [sym_macro_identifier] = STATE(52),
    [sym__literal] = STATE(1462),
    [sym_integer_literal] = STATE(1462),
    [sym_character_literal] = STATE(1462),
    [sym_string_literal] = STATE(1462),
    [sym_command_literal] = STATE(1462),
    [sym_prefixed_string_literal] = STATE(1462),
    [sym_prefixed_command_literal] = STATE(1462),
    [aux_sym_macro_argument_list_repeat1] = STATE(82),
    [sym_identifier] = ACTIONS(1311),
    [anon_sym_function] = ACTIONS(943),
    [anon_sym_end] = ACTIONS(203),
    [anon_sym_abstract] = ACTIONS(946),
    [anon_sym_primitive] = ACTIONS(949),
    [aux_sym_primitive_definition_token1] = ACTIONS(952),
    [anon_sym_mutable] = ACTIONS(955),
    [anon_sym_struct] = ACTIONS(958),
    [anon_sym_module] = ACTIONS(961),
    [anon_sym_macro] = ACTIONS(964),
    [anon_sym_LPAREN] = ACTIONS(967),
    [anon_sym_RPAREN] = ACTIONS(292),
    [anon_sym_SEMI] = ACTIONS(292),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(292),
    [anon_sym_COLON_COLON] = ACTIONS(292),
    [anon_sym_LT_COLON] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(970),
    [anon_sym_try] = ACTIONS(973),
    [anon_sym_for] = ACTIONS(976),
    [anon_sym_while] = ACTIONS(979),
    [sym_break_statement] = ACTIONS(982),
    [sym_continue_statement] = ACTIONS(982),
    [anon_sym_return] = ACTIONS(985),
    [anon_sym_let] = ACTIONS(988),
    [anon_sym_const] = ACTIONS(991),
    [anon_sym_quote] = ACTIONS(994),
    [anon_sym_using] = ACTIONS(997),
    [anon_sym_import] = ACTIONS(997),
    [anon_sym_export] = ACTIONS(1000),
    [anon_sym_COLON2] = ACTIONS(1314),
    [anon_sym_RBRACK] = ACTIONS(292),
    [anon_sym_begin] = ACTIONS(1006),
    [anon_sym_SQUOTE] = ACTIONS(1009),
    [anon_sym_PLUS] = ACTIONS(203),
    [anon_sym_LT_PIPE] = ACTIONS(292),
    [anon_sym_PIPE_GT] = ACTIONS(292),
    [anon_sym_in] = ACTIONS(203),
    [anon_sym_isa] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(292),
    [anon_sym_AMP_AMP] = ACTIONS(292),
    [anon_sym_QMARK] = ACTIONS(292),
    [anon_sym_EQ_GT] = ACTIONS(292),
    [anon_sym_LBRACK2] = ACTIONS(1012),
    [anon_sym_DOLLAR] = ACTIONS(1317),
    [anon_sym_AT] = ACTIONS(1018),
    [aux_sym_integer_literal_token1] = ACTIONS(1021),
    [aux_sym_integer_literal_token2] = ACTIONS(1021),
    [aux_sym_integer_literal_token3] = ACTIONS(1024),
    [sym_float_literal] = ACTIONS(1027),
    [sym__unary_operator] = ACTIONS(1320),
    [sym__power_operator] = ACTIONS(1033),
    [sym__bitshift_operator] = ACTIONS(1033),
    [sym__rational_operator] = ACTIONS(1033),
    [sym__times_operator] = ACTIONS(1036),
    [sym__plus_operator] = ACTIONS(1036),
    [sym__dotty_operator] = ACTIONS(1036),
    [sym__comparison_operator] = ACTIONS(1036),
    [sym__arrow_operator] = ACTIONS(292),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(1039),
    [sym__command_start] = ACTIONS(1042),
  },
  [83] = {
    [sym_function_definition] = STATE(1855),
    [sym_abstract_definition] = STATE(1855),
    [sym_primitive_definition] = STATE(1855),
    [sym_struct_definition] = STATE(1855),
    [sym_module_definition] = STATE(1855),
    [sym_macro_definition] = STATE(1855),
    [sym_parameter_list] = STATE(3801),
    [sym_if_statement] = STATE(1855),
    [sym_try_statement] = STATE(1855),
    [sym_for_statement] = STATE(1855),
    [sym_while_statement] = STATE(1855),
    [sym_return_statement] = STATE(1855),
    [sym_let_statement] = STATE(1855),
    [sym_const_statement] = STATE(1855),
    [sym_quote_statement] = STATE(1855),
    [sym_import_statement] = STATE(1855),
    [sym_export_statement] = STATE(1855),
    [sym__expression] = STATE(1833),
    [sym__primary_expression] = STATE(1237),
    [sym_operator] = STATE(1461),
    [sym_parenthesized_expression] = STATE(1237),
    [sym_field_expression] = STATE(1088),
    [sym_subscript_expression] = STATE(1237),
    [sym_typed_expression] = STATE(1855),
    [sym_parameterized_identifier] = STATE(1237),
    [sym_compound_expression] = STATE(1855),
    [sym_call_expression] = STATE(1237),
    [sym_broadcast_call_expression] = STATE(1237),
    [sym_macro_expression] = STATE(1855),
    [sym_spread_expression] = STATE(1855),
    [sym_unary_expression] = STATE(1855),
    [sym_binary_expression] = STATE(1855),
    [sym_ternary_expression] = STATE(1855),
    [sym_pair_expression] = STATE(1855),
    [sym_tuple_expression] = STATE(1237),
    [sym_array_expression] = STATE(1237),
    [sym_matrix_expression] = STATE(1237),
    [sym_generator_expression] = STATE(1855),
    [sym_array_comprehension_expression] = STATE(1237),
    [sym_function_expression] = STATE(1855),
    [sym_range_expression] = STATE(1855),
    [sym_coefficient_expression] = STATE(1855),
    [sym_quote_expression] = STATE(1855),
    [sym_interpolation_expression] = STATE(1855),
    [sym_macro_identifier] = STATE(52),
    [sym__literal] = STATE(1462),
    [sym_integer_literal] = STATE(1462),
    [sym_character_literal] = STATE(1462),
    [sym_string_literal] = STATE(1462),
    [sym_command_literal] = STATE(1462),
    [sym_prefixed_string_literal] = STATE(1462),
    [sym_prefixed_command_literal] = STATE(1462),
    [sym_identifier] = ACTIONS(1045),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_primitive] = ACTIONS(616),
    [aux_sym_primitive_definition_token1] = ACTIONS(618),
    [anon_sym_mutable] = ACTIONS(620),
    [anon_sym_struct] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_macro] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_RPAREN] = ACTIONS(306),
    [anon_sym_SEMI] = ACTIONS(306),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(306),
    [anon_sym_COLON_COLON] = ACTIONS(306),
    [anon_sym_LT_COLON] = ACTIONS(306),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [sym_break_statement] = ACTIONS(638),
    [sym_continue_statement] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(644),
    [anon_sym_quote] = ACTIONS(646),
    [anon_sym_using] = ACTIONS(648),
    [anon_sym_import] = ACTIONS(648),
    [anon_sym_export] = ACTIONS(650),
    [anon_sym_COLON2] = ACTIONS(1047),
    [anon_sym_RBRACK] = ACTIONS(306),
    [anon_sym_begin] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(306),
    [anon_sym_PIPE_GT] = ACTIONS(306),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(306),
    [anon_sym_AMP_AMP] = ACTIONS(306),
    [anon_sym_QMARK] = ACTIONS(306),
    [anon_sym_EQ_GT] = ACTIONS(306),
    [anon_sym_LBRACK2] = ACTIONS(658),
    [anon_sym_DOLLAR] = ACTIONS(1049),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(664),
    [aux_sym_integer_literal_token2] = ACTIONS(664),
    [aux_sym_integer_literal_token3] = ACTIONS(666),
    [sym_float_literal] = ACTIONS(668),
    [sym__unary_operator] = ACTIONS(1051),
    [sym__power_operator] = ACTIONS(672),
    [sym__bitshift_operator] = ACTIONS(672),
    [sym__rational_operator] = ACTIONS(672),
    [sym__times_operator] = ACTIONS(674),
    [sym__plus_operator] = ACTIONS(674),
    [sym__dotty_operator] = ACTIONS(674),
    [sym__comparison_operator] = ACTIONS(674),
    [sym__arrow_operator] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(678),
    [sym__command_start] = ACTIONS(680),
  },
  [84] = {
    [sym_function_definition] = STATE(1855),
    [sym_abstract_definition] = STATE(1855),
    [sym_primitive_definition] = STATE(1855),
    [sym_struct_definition] = STATE(1855),
    [sym_module_definition] = STATE(1855),
    [sym_macro_definition] = STATE(1855),
    [sym_parameter_list] = STATE(3801),
    [sym_if_statement] = STATE(1855),
    [sym_try_statement] = STATE(1855),
    [sym_for_statement] = STATE(1855),
    [sym_while_statement] = STATE(1855),
    [sym_return_statement] = STATE(1855),
    [sym_let_statement] = STATE(1855),
    [sym_const_statement] = STATE(1855),
    [sym_quote_statement] = STATE(1855),
    [sym_import_statement] = STATE(1855),
    [sym_export_statement] = STATE(1855),
    [sym__expression] = STATE(1915),
    [sym__primary_expression] = STATE(1237),
    [sym_operator] = STATE(1461),
    [sym_parenthesized_expression] = STATE(1237),
    [sym_field_expression] = STATE(1088),
    [sym_subscript_expression] = STATE(1237),
    [sym_typed_expression] = STATE(1855),
    [sym_parameterized_identifier] = STATE(1237),
    [sym_compound_expression] = STATE(1855),
    [sym_call_expression] = STATE(1237),
    [sym_broadcast_call_expression] = STATE(1237),
    [sym_macro_expression] = STATE(1855),
    [sym_spread_expression] = STATE(1855),
    [sym_unary_expression] = STATE(1855),
    [sym_binary_expression] = STATE(1855),
    [sym_ternary_expression] = STATE(1855),
    [sym_pair_expression] = STATE(1855),
    [sym_tuple_expression] = STATE(1237),
    [sym_array_expression] = STATE(1237),
    [sym_matrix_expression] = STATE(1237),
    [sym_generator_expression] = STATE(1855),
    [sym_array_comprehension_expression] = STATE(1237),
    [sym_function_expression] = STATE(1855),
    [sym_range_expression] = STATE(1855),
    [sym_coefficient_expression] = STATE(1855),
    [sym_quote_expression] = STATE(1855),
    [sym_interpolation_expression] = STATE(1855),
    [sym_macro_identifier] = STATE(52),
    [sym__literal] = STATE(1462),
    [sym_integer_literal] = STATE(1462),
    [sym_character_literal] = STATE(1462),
    [sym_string_literal] = STATE(1462),
    [sym_command_literal] = STATE(1462),
    [sym_prefixed_string_literal] = STATE(1462),
    [sym_prefixed_command_literal] = STATE(1462),
    [sym_identifier] = ACTIONS(1045),
    [anon_sym_function] = ACTIONS(612),
    [anon_sym_end] = ACTIONS(466),
    [anon_sym_abstract] = ACTIONS(614),
    [anon_sym_primitive] = ACTIONS(616),
    [aux_sym_primitive_definition_token1] = ACTIONS(618),
    [anon_sym_mutable] = ACTIONS(620),
    [anon_sym_struct] = ACTIONS(622),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_macro] = ACTIONS(626),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_RPAREN] = ACTIONS(468),
    [anon_sym_SEMI] = ACTIONS(468),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(468),
    [anon_sym_COLON_COLON] = ACTIONS(468),
    [anon_sym_LT_COLON] = ACTIONS(468),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_while] = ACTIONS(636),
    [sym_break_statement] = ACTIONS(638),
    [sym_continue_statement] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(644),
    [anon_sym_quote] = ACTIONS(646),
    [anon_sym_using] = ACTIONS(648),
    [anon_sym_import] = ACTIONS(648),
    [anon_sym_export] = ACTIONS(650),
    [anon_sym_COLON2] = ACTIONS(1047),
    [anon_sym_RBRACK] = ACTIONS(468),
    [anon_sym_begin] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_LT_PIPE] = ACTIONS(468),
    [anon_sym_PIPE_GT] = ACTIONS(468),
    [anon_sym_in] = ACTIONS(466),
    [anon_sym_isa] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(468),
    [anon_sym_AMP_AMP] = ACTIONS(468),
    [anon_sym_QMARK] = ACTIONS(468),
    [anon_sym_EQ_GT] = ACTIONS(468),
    [anon_sym_LBRACK2] = ACTIONS(658),
    [anon_sym_DOLLAR] = ACTIONS(1049),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(664),
    [aux_sym_integer_literal_token2] = ACTIONS(664),
    [aux_sym_integer_literal_token3] = ACTIONS(666),
    [sym_float_literal] = ACTIONS(668),
    [sym__unary_operator] = ACTIONS(1051),
    [sym__power_operator] = ACTIONS(672),
    [sym__bitshift_operator] = ACTIONS(672),
    [sym__rational_operator] = ACTIONS(672),
    [sym__times_operator] = ACTIONS(674),
    [sym__plus_operator] = ACTIONS(674),
    [sym__dotty_operator] = ACTIONS(674),
    [sym__comparison_operator] = ACTIONS(674),
    [sym__arrow_operator] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(678),
    [sym__command_start] = ACTIONS(680),
  },
  [85] = {
    [sym_function_definition] = STATE(2557),
    [sym_abstract_definition] = STATE(2557),
    [sym_primitive_definition] = STATE(2557),
    [sym_struct_definition] = STATE(2557),
    [sym_module_definition] = STATE(2557),
    [sym_macro_definition] = STATE(2557),
    [sym_parameter_list] = STATE(3790),
    [sym_if_statement] = STATE(2557),
    [sym_try_statement] = STATE(2557),
    [sym_for_statement] = STATE(2557),
    [sym_while_statement] = STATE(2557),
    [sym_return_statement] = STATE(2557),
    [sym_let_statement] = STATE(2557),
    [sym_const_statement] = STATE(2557),
    [sym_quote_statement] = STATE(2557),
    [sym_import_statement] = STATE(2557),
    [sym_export_statement] = STATE(2557),
    [sym__expression] = STATE(2513),
    [sym__primary_expression] = STATE(2256),
    [sym_operator] = STATE(2451),
    [sym_parenthesized_expression] = STATE(2256),
    [sym_field_expression] = STATE(2089),
    [sym_subscript_expression] = STATE(2256),
    [sym_typed_expression] = STATE(2557),
    [sym_parameterized_identifier] = STATE(2256),
    [sym_compound_expression] = STATE(2557),
    [sym_call_expression] = STATE(2256),
    [sym_broadcast_call_expression] = STATE(2256),
    [sym_macro_expression] = STATE(2557),
    [sym_spread_expression] = STATE(2557),
    [sym_unary_expression] = STATE(2557),
    [sym_binary_expression] = STATE(2557),
    [sym_ternary_expression] = STATE(2557),
    [sym_pair_expression] = STATE(2557),
    [sym_tuple_expression] = STATE(2256),
    [sym_array_expression] = STATE(2256),
    [sym_matrix_expression] = STATE(2256),
    [sym_generator_expression] = STATE(2557),
    [sym_array_comprehension_expression] = STATE(2256),
    [sym_function_expression] = STATE(2557),
    [sym_range_expression] = STATE(2557),
    [sym_coefficient_expression] = STATE(2557),
    [sym_quote_expression] = STATE(2557),
    [sym_interpolation_expression] = STATE(2557),
    [sym_macro_identifier] = STATE(65),
    [sym__literal] = STATE(2449),
    [sym_integer_literal] = STATE(2449),
    [sym_character_literal] = STATE(2449),
    [sym_string_literal] = STATE(2449),
    [sym_command_literal] = STATE(2449),
    [sym_prefixed_string_literal] = STATE(2449),
    [sym_prefixed_command_literal] = STATE(2449),
    [sym_identifier] = ACTIONS(1323),
    [anon_sym_function] = ACTIONS(870),
    [anon_sym_end] = ACTIONS(304),
    [anon_sym_abstract] = ACTIONS(872),
    [anon_sym_primitive] = ACTIONS(874),
    [aux_sym_primitive_definition_token1] = ACTIONS(876),
    [anon_sym_mutable] = ACTIONS(878),
    [anon_sym_struct] = ACTIONS(880),
    [anon_sym_module] = ACTIONS(882),
    [anon_sym_macro] = ACTIONS(884),
    [anon_sym_LPAREN] = ACTIONS(886),
    [anon_sym_RPAREN] = ACTIONS(306),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(306),
    [anon_sym_COLON_COLON] = ACTIONS(306),
    [anon_sym_LT_COLON] = ACTIONS(306),
    [anon_sym_if] = ACTIONS(888),
    [anon_sym_try] = ACTIONS(890),
    [anon_sym_for] = ACTIONS(892),
    [anon_sym_while] = ACTIONS(894),
    [sym_break_statement] = ACTIONS(896),
    [sym_continue_statement] = ACTIONS(896),
    [anon_sym_return] = ACTIONS(898),
    [anon_sym_let] = ACTIONS(900),
    [anon_sym_const] = ACTIONS(902),
    [anon_sym_quote] = ACTIONS(904),
    [anon_sym_using] = ACTIONS(906),
    [anon_sym_import] = ACTIONS(906),
    [anon_sym_export] = ACTIONS(908),
    [anon_sym_COLON2] = ACTIONS(1325),
    [anon_sym_RBRACK] = ACTIONS(306),
    [anon_sym_begin] = ACTIONS(912),
    [anon_sym_SQUOTE] = ACTIONS(914),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_LT_PIPE] = ACTIONS(306),
    [anon_sym_PIPE_GT] = ACTIONS(306),
    [anon_sym_in] = ACTIONS(304),
    [anon_sym_isa] = ACTIONS(304),
    [anon_sym_PIPE_PIPE] = ACTIONS(306),
    [anon_sym_AMP_AMP] = ACTIONS(306),
    [anon_sym_QMARK] = ACTIONS(306),
    [anon_sym_EQ_GT] = ACTIONS(306),
    [anon_sym_LBRACK2] = ACTIONS(916),
    [anon_sym_DOLLAR] = ACTIONS(1327),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(920),
    [aux_sym_integer_literal_token2] = ACTIONS(920),
    [aux_sym_integer_literal_token3] = ACTIONS(922),
    [sym_float_literal] = ACTIONS(924),
    [sym__unary_operator] = ACTIONS(1329),
    [sym__power_operator] = ACTIONS(928),
    [sym__bitshift_operator] = ACTIONS(928),
    [sym__rational_operator] = ACTIONS(928),
    [sym__times_operator] = ACTIONS(930),
    [sym__plus_operator] = ACTIONS(930),
    [sym__dotty_operator] = ACTIONS(930),
    [sym__comparison_operator] = ACTIONS(930),
    [sym__arrow_operator] = ACTIONS(306),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__immediate_paren] = ACTIONS(306),
    [sym__string_start] = ACTIONS(932),
    [sym__command_start] = ACTIONS(934),
  },
  [86] = {
    [sym_function_definition] = STATE(2557),
    [sym_abstract_definition] = STATE(2557),
    [sym_primitive_definition] = STATE(2557),
    [sym_struct_definition] = STATE(2557),
    [sym_module_definition] = STATE(2557),
    [sym_macro_definition] = STATE(2557),
    [sym_parameter_list] = STATE(3790),
    [sym_if_statement] = STATE(2557),
    [sym_try_statement] = STATE(2557),
    [sym_for_statement] = STATE(2557),
    [sym_while_statement] = STATE(2557),
    [sym_return_statement] = STATE(2557),
    [sym_let_statement] = STATE(2557),
    [sym_const_statement] = STATE(2557),
    [sym_quote_statement] = STATE(2557),
    [sym_import_statement] = STATE(2557),
    [sym_export_statement] = STATE(2557),
    [sym__expression] = STATE(2630),
    [sym__primary_expression] = STATE(2256),
    [sym_operator] = STATE(2451),
    [sym_parenthesized_expression] = STATE(2256),
    [sym_field_expression] = STATE(2089),
    [sym_subscript_expression] = STATE(2256),
    [sym_typed_expression] = STATE(2557),
    [sym_parameterized_identifier] = STATE(2256),
    [sym_compound_expression] = STATE(2557),
    [sym_call_expression] = STATE(2256),
    [sym_broadcast_call_expression] = STATE(2256),
    [sym_macro_expression] = STATE(2557),
    [sym_spread_expression] = STATE(2557),
    [sym_unary_expression] = STATE(2557),
    [sym_binary_expression] = STATE(2557),
    [sym_ternary_expression] = STATE(2557),
    [sym_pair_expression] = STATE(2557),
    [sym_tuple_expression] = STATE(2256),
    [sym_array_expression] = STATE(2256),
    [sym_matrix_expression] = STATE(2256),
    [sym_generator_expression] = STATE(2557),
    [sym_array_comprehension_expression] = STATE(2256),
    [sym_function_expression] = STATE(2557),
    [sym_range_expression] = STATE(2557),
    [sym_coefficient_expression] = STATE(2557),
    [sym_quote_expression] = STATE(2557),
    [sym_interpolation_expression] = STATE(2557),
    [sym_macro_identifier] = STATE(65),
    [sym__literal] = STATE(2449),
    [sym_integer_literal] = STATE(2449),
    [sym_character_literal] = STATE(2449),
    [sym_string_literal] = STATE(2449),
    [sym_command_literal] = STATE(2449),
    [sym_prefixed_string_literal] = STATE(2449),
    [sym_prefixed_command_literal] = STATE(2449),
    [sym_identifier] = ACTIONS(1323),
    [anon_sym_function] = ACTIONS(870),
    [anon_sym_end] = ACTIONS(466),
    [anon_sym_abstract] = ACTIONS(872),
    [anon_sym_primitive] = ACTIONS(874),
    [aux_sym_primitive_definition_token1] = ACTIONS(876),
    [anon_sym_mutable] = ACTIONS(878),
    [anon_sym_struct] = ACTIONS(880),
    [anon_sym_module] = ACTIONS(882),
    [anon_sym_macro] = ACTIONS(884),
    [anon_sym_LPAREN] = ACTIONS(886),
    [anon_sym_RPAREN] = ACTIONS(468),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(468),
    [anon_sym_COLON_COLON] = ACTIONS(468),
    [anon_sym_LT_COLON] = ACTIONS(468),
    [anon_sym_if] = ACTIONS(888),
    [anon_sym_try] = ACTIONS(890),
    [anon_sym_for] = ACTIONS(892),
    [anon_sym_while] = ACTIONS(894),
    [sym_break_statement] = ACTIONS(896),
    [sym_continue_statement] = ACTIONS(896),
    [anon_sym_return] = ACTIONS(898),
    [anon_sym_let] = ACTIONS(900),
    [anon_sym_const] = ACTIONS(902),
    [anon_sym_quote] = ACTIONS(904),
    [anon_sym_using] = ACTIONS(906),
    [anon_sym_import] = ACTIONS(906),
    [anon_sym_export] = ACTIONS(908),
    [anon_sym_COLON2] = ACTIONS(1325),
    [anon_sym_RBRACK] = ACTIONS(468),
    [anon_sym_begin] = ACTIONS(912),
    [anon_sym_SQUOTE] = ACTIONS(914),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_LT_PIPE] = ACTIONS(468),
    [anon_sym_PIPE_GT] = ACTIONS(468),
    [anon_sym_in] = ACTIONS(466),
    [anon_sym_isa] = ACTIONS(466),
    [anon_sym_PIPE_PIPE] = ACTIONS(468),
    [anon_sym_AMP_AMP] = ACTIONS(468),
    [anon_sym_QMARK] = ACTIONS(468),
    [anon_sym_EQ_GT] = ACTIONS(468),
    [anon_sym_LBRACK2] = ACTIONS(916),
    [anon_sym_DOLLAR] = ACTIONS(1327),
    [anon_sym_AT] = ACTIONS(662),
    [aux_sym_integer_literal_token1] = ACTIONS(920),
    [aux_sym_integer_literal_token2] = ACTIONS(920),
    [aux_sym_integer_literal_token3] = ACTIONS(922),
    [sym_float_literal] = ACTIONS(924),
    [sym__unary_operator] = ACTIONS(1329),
    [sym__power_operator] = ACTIONS(928),
    [sym__bitshift_operator] = ACTIONS(928),
    [sym__rational_operator] = ACTIONS(928),
    [sym__times_operator] = ACTIONS(930),
    [sym__plus_operator] = ACTIONS(930),
    [sym__dotty_operator] = ACTIONS(930),
    [sym__comparison_operator] = ACTIONS(930),
    [sym__arrow_operator] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(932),
    [sym__command_start] = ACTIONS(934),
  },
  [87] = {
    [sym__expression_list] = STATE(3813),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_keyword_parameters] = STATE(4142),
    [sym_optional_parameter] = STATE(2875),
    [sym_spread_parameter] = STATE(2875),
    [sym_typed_parameter] = STATE(2800),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2305),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_named_field] = STATE(3677),
    [sym_spread_expression] = STATE(2601),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(1331),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_COMMA] = ACTIONS(1333),
    [anon_sym_RPAREN] = ACTIONS(1335),
    [anon_sym_SEMI] = ACTIONS(1337),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(1339),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_LBRACK2] = ACTIONS(55),
    [anon_sym_DOLLAR] = ACTIONS(1341),
    [anon_sym_AT] = ACTIONS(1343),
    [aux_sym_integer_literal_token1] = ACTIONS(61),
    [aux_sym_integer_literal_token2] = ACTIONS(61),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(69),
    [sym__bitshift_operator] = ACTIONS(69),
    [sym__rational_operator] = ACTIONS(69),
    [sym__times_operator] = ACTIONS(71),
    [sym__plus_operator] = ACTIONS(71),
    [sym__dotty_operator] = ACTIONS(69),
    [sym__comparison_operator] = ACTIONS(71),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [88] = {
    [sym__expression_list] = STATE(4234),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_keyword_parameters] = STATE(4142),
    [sym_optional_parameter] = STATE(2875),
    [sym_spread_parameter] = STATE(2875),
    [sym_typed_parameter] = STATE(2800),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2264),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_named_field] = STATE(3650),
    [sym_spread_expression] = STATE(2625),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(1331),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_COMMA] = ACTIONS(1345),
    [anon_sym_RPAREN] = ACTIONS(1347),
    [anon_sym_SEMI] = ACTIONS(1337),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(1339),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_LBRACK2] = ACTIONS(55),
    [anon_sym_DOLLAR] = ACTIONS(1341),
    [anon_sym_AT] = ACTIONS(1343),
    [aux_sym_integer_literal_token1] = ACTIONS(61),
    [aux_sym_integer_literal_token2] = ACTIONS(61),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(69),
    [sym__bitshift_operator] = ACTIONS(69),
    [sym__rational_operator] = ACTIONS(69),
    [sym__times_operator] = ACTIONS(71),
    [sym__plus_operator] = ACTIONS(71),
    [sym__dotty_operator] = ACTIONS(69),
    [sym__comparison_operator] = ACTIONS(71),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [89] = {
    [sym__expression_list] = STATE(4144),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_keyword_parameters] = STATE(4142),
    [sym_optional_parameter] = STATE(2875),
    [sym_spread_parameter] = STATE(2875),
    [sym_typed_parameter] = STATE(2800),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2300),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_named_field] = STATE(3711),
    [sym_spread_expression] = STATE(2609),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(1331),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_COMMA] = ACTIONS(1349),
    [anon_sym_RPAREN] = ACTIONS(1351),
    [anon_sym_SEMI] = ACTIONS(1337),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(1339),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_LBRACK2] = ACTIONS(55),
    [anon_sym_DOLLAR] = ACTIONS(1341),
    [anon_sym_AT] = ACTIONS(1343),
    [aux_sym_integer_literal_token1] = ACTIONS(61),
    [aux_sym_integer_literal_token2] = ACTIONS(61),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(69),
    [sym__bitshift_operator] = ACTIONS(69),
    [sym__rational_operator] = ACTIONS(69),
    [sym__times_operator] = ACTIONS(71),
    [sym__plus_operator] = ACTIONS(71),
    [sym__dotty_operator] = ACTIONS(69),
    [sym__comparison_operator] = ACTIONS(71),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [90] = {
    [sym__expression_list] = STATE(4166),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_keyword_parameters] = STATE(4142),
    [sym_optional_parameter] = STATE(2875),
    [sym_spread_parameter] = STATE(2875),
    [sym_typed_parameter] = STATE(2800),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2276),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_named_field] = STATE(3738),
    [sym_spread_expression] = STATE(2603),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(1331),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_COMMA] = ACTIONS(1353),
    [anon_sym_RPAREN] = ACTIONS(1355),
    [anon_sym_SEMI] = ACTIONS(1337),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(1339),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_LBRACK2] = ACTIONS(55),
    [anon_sym_DOLLAR] = ACTIONS(1341),
    [anon_sym_AT] = ACTIONS(1343),
    [aux_sym_integer_literal_token1] = ACTIONS(61),
    [aux_sym_integer_literal_token2] = ACTIONS(61),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(69),
    [sym__bitshift_operator] = ACTIONS(69),
    [sym__rational_operator] = ACTIONS(69),
    [sym__times_operator] = ACTIONS(71),
    [sym__plus_operator] = ACTIONS(71),
    [sym__dotty_operator] = ACTIONS(69),
    [sym__comparison_operator] = ACTIONS(71),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [91] = {
    [sym__expression_list] = STATE(4019),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_keyword_parameters] = STATE(4142),
    [sym_optional_parameter] = STATE(2875),
    [sym_spread_parameter] = STATE(2875),
    [sym_typed_parameter] = STATE(2800),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2298),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_named_field] = STATE(3707),
    [sym_spread_expression] = STATE(2612),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(1331),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_macro] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_COMMA] = ACTIONS(1357),
    [anon_sym_RPAREN] = ACTIONS(1359),
    [anon_sym_SEMI] = ACTIONS(1337),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_try] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_while] = ACTIONS(33),
    [sym_break_statement] = ACTIONS(35),
    [sym_continue_statement] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(91),
    [anon_sym_let] = ACTIONS(39),
    [anon_sym_const] = ACTIONS(93),
    [anon_sym_quote] = ACTIONS(43),
    [anon_sym_using] = ACTIONS(45),
    [anon_sym_import] = ACTIONS(45),
    [anon_sym_export] = ACTIONS(47),
    [anon_sym_COLON2] = ACTIONS(1339),
    [anon_sym_begin] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_LBRACK2] = ACTIONS(55),
    [anon_sym_DOLLAR] = ACTIONS(1341),
    [anon_sym_AT] = ACTIONS(1343),
    [aux_sym_integer_literal_token1] = ACTIONS(61),
    [aux_sym_integer_literal_token2] = ACTIONS(61),
    [aux_sym_integer_literal_token3] = ACTIONS(63),
    [sym_float_literal] = ACTIONS(109),
    [sym__unary_operator] = ACTIONS(111),
    [sym__power_operator] = ACTIONS(69),
    [sym__bitshift_operator] = ACTIONS(69),
    [sym__rational_operator] = ACTIONS(69),
    [sym__times_operator] = ACTIONS(71),
    [sym__plus_operator] = ACTIONS(71),
    [sym__dotty_operator] = ACTIONS(69),
    [sym__comparison_operator] = ACTIONS(71),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(73),
    [sym__command_start] = ACTIONS(75),
  },
  [92] = {
    [sym__expression_list] = STATE(4087),
    [sym_function_definition] = STATE(2123),
    [sym_abstract_definition] = STATE(2123),
    [sym_primitive_definition] = STATE(2123),
    [sym_struct_definition] = STATE(2123),
    [sym_module_definition] = STATE(2123),
    [sym_macro_definition] = STATE(2123),
    [sym_parameter_list] = STATE(4317),
    [sym_keyword_parameters] = STATE(4142),
    [sym_optional_parameter] = STATE(2875),
    [sym_spread_parameter] = STATE(2875),
    [sym_typed_parameter] = STATE(2800),
    [sym_if_statement] = STATE(2123),
    [sym_try_statement] = STATE(2123),
    [sym_for_statement] = STATE(2123),
    [sym_while_statement] = STATE(2123),
    [sym_return_statement] = STATE(2123),
    [sym_let_statement] = STATE(2123),
    [sym_const_statement] = STATE(2123),
    [sym_quote_statement] = STATE(2123),
    [sym_import_statement] = STATE(2123),
    [sym_export_statement] = STATE(2123),
    [sym__expression] = STATE(2291),
    [sym__primary_expression] = STATE(1995),
    [sym_bare_tuple_expression] = STATE(2748),
    [sym_operator] = STATE(2044),
    [sym_parenthesized_expression] = STATE(1995),
    [sym_field_expression] = STATE(1946),
    [sym_subscript_expression] = STATE(1995),
    [sym_typed_expression] = STATE(2123),
    [sym_parameterized_identifier] = STATE(1995),
    [sym_compound_expression] = STATE(2123),
    [sym_call_expression] = STATE(1995),
    [sym_broadcast_call_expression] = STATE(1995),
    [sym_macro_expression] = STATE(2123),
    [sym_named_field] = STATE(3720),
    [sym_spread_expression] = STATE(2619),
    [sym_assignment_expression] = STATE(2762),
    [sym_unary_expression] = STATE(2123),
    [sym_binary_expression] = STATE(2123),
    [sym_ternary_expression] = STATE(2123),
    [sym_pair_expression] = STATE(2123),
    [sym_tuple_expression] = STATE(1995),
    [sym_array_expression] = STATE(1995),
    [sym_matrix_expression] = STATE(1995),
    [sym_generator_expression] = STATE(2123),
    [sym_array_comprehension_expression] = STATE(1995),
    [sym_function_expression] = STATE(2123),
    [sym_range_expression] = STATE(2123),
    [sym_coefficient_expression] = STATE(2123),
    [sym_quote_expression] = STATE(2123),
    [sym_interpolation_expression] = STATE(2123),
    [sym_macro_identifier] = STATE(3),
    [sym__literal] = STATE(2052),
    [sym_integer_literal] = STATE(2052),
    [sym_character_literal] = STATE(2052),
    [sym_string_literal] = STATE(2052),
    [sym_command_literal] = STATE(2052),
    [sym_prefixed_string_literal] = STATE(2052),
    [sym_prefixed_command_literal] = STATE(2052),
    [sym_identifier] = ACTIONS(1331),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_abstract] = ACTIONS(11),
    [anon_sym_primitive] = ACTIONS(13),
    [aux_sym_primitive_definition_token1] = ACTIONS(81),
    [anon_sym_mutable] = ACTIONS(17),
    [anon_sym_struct] = ACTIONS(19),
    [anon_sym_module] = ACTIONS(21),
    [anon_sy