[38;2;249;38;114mpackage[0m[38;2;248;248;242m main[0m

[38;2;249;38;114mimport[0m[38;2;248;248;242m [0m[38;2;230;219;116m"[0m[38;2;230;219;116mcore:fmt[0m[38;2;230;219;116m"[0m
[38;2;249;38;114mimport[0m[38;2;248;248;242m [0m[38;2;230;219;116m"[0m[38;2;230;219;116mcore:math[0m[38;2;230;219;116m"[0m

[38;2;166;226;46mVector[0m[38;2;248;248;242m :: [0m[3;38;2;102;217;239mstruct[0m[38;2;248;248;242m {[0m
[38;2;248;248;242m	components: [0m[38;2;248;248;242m[[0m[38;2;248;248;242m][0m[3;38;2;102;217;239mf64[0m[38;2;248;248;242m,[0m
[38;2;248;248;242m}[0m

[38;2;166;226;46meuclidean_distance[0m[38;2;248;248;242m :: [0m[3;38;2;102;217;239mproc[0m[38;2;248;248;242m(v1: Vector, v2: Vector) -> [0m[3;38;2;102;217;239mf64[0m[38;2;248;248;242m {[0m
[38;2;248;248;242m	[0m[38;2;249;38;114mif[0m[38;2;248;248;242m [0m[38;2;102;217;239mlen[0m[38;2;248;248;242m(v1.components) != [0m[38;2;102;217;239mlen[0m[38;2;248;248;242m(v2.components) {[0m
[38;2;248;248;242m		[0m[38;2;102;217;239mpanic[0m[38;2;248;248;242m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mVectors must be same dimension[0m[38;2;230;219;116m"[0m[38;2;248;248;242m)[0m
[38;2;248;248;242m	}[0m
[38;2;248;248;242m	sum: [0m[3;38;2;102;217;239mf64[0m[38;2;248;248;242m = [0m[38;2;190;132;255m0.0[0m[38;2;248;248;242m;[0m
[38;2;248;248;242m	[0m[38;2;249;38;114mfor[0m[38;2;248;248;242m i, comp [0m[38;2;249;38;114min[0m[38;2;248;248;242m v1.components {[0m
[38;2;248;248;242m		diff := comp - v2.components[i];[0m
[38;2;248;248;242m		sum += diff * diff;[0m
[38;2;248;248;242m	}[0m
[38;2;248;248;242m	[0m[38;2;249;38;114mreturn[0m[38;2;248;248;242m math.[0m[38;2;102;217;239msqrt[0m[38;2;248;248;242m(sum);[0m
[38;2;248;248;242m}[0m

[38;2;166;226;46mmain[0m[38;2;248;248;242m :: [0m[3;38;2;102;217;239mproc[0m[38;2;248;248;242m() {[0m
[38;2;248;248;242m	v1: Vector = Vector{components = [0m[38;2;248;248;242m[[0m[38;2;248;248;242m][0m[3;38;2;102;217;239mf64[0m[38;2;248;248;242m{[0m[38;2;190;132;255m1.0[0m[38;2;248;248;242m, [0m[38;2;190;132;255m2.0[0m[38;2;248;248;242m, [0m[38;2;190;132;255m3.0[0m[38;2;248;248;242m}};[0m
[38;2;248;248;242m	v2: Vector = Vector{components = [0m[38;2;248;248;242m[[0m[38;2;248;248;242m][0m[3;38;2;102;217;239mf64[0m[38;2;248;248;242m{[0m[38;2;190;132;255m4.0[0m[38;2;248;248;242m, [0m[38;2;190;132;255m6.0[0m[38;2;248;248;242m, [0m[38;2;190;132;255m8.0[0m[38;2;248;248;242m}};[0m
[38;2;248;248;242m	dist: [0m[3;38;2;102;217;239mf64[0m[38;2;248;248;242m = [0m[38;2;102;217;239meuclidean_distance[0m[38;2;248;248;242m(v1, v2);[0m
[38;2;248;248;242m	fmt.[0m[38;2;102;217;239mprintln[0m[38;2;248;248;242m([0m[38;2;230;219;116m"[0m[38;2;230;219;116mDistance:[0m[38;2;230;219;116m"[0m[38;2;248;248;242m, dist);[0m
[38;2;248;248;242m}[0m
