/* tslint:disable */
/* eslint-disable */

/* auto-generated by NAPI-RS */

/**
 * Rule configuration similar to YAML
 * See https://ast-grep.github.io/reference/yaml.html
 */
export interface NapiConfig {
  /** The rule object, see https://ast-grep.github.io/reference/rule.html */
  rule: import('./manual').Rule
  /** See https://ast-grep.github.io/guide/rule-config.html#constraints */
  constraints?: Record<string, import('./manual').Rule>
  /** Available languages: html, css, js, jsx, ts, tsx */
  language?: Lang
  /**
   * transform is NOT useful in JavaScript. You can use JS code to directly transform the result.
   * https://ast-grep.github.io/reference/yaml.html#transform
   */
  transform?: any
  /** https://ast-grep.github.io/guide/rule-config/utility-rule.html */
  utils?: any
}
export interface FileOption {
  paths: Array<string>
  languageGlobs: Record<string, Array<string>>
}
export declare function parseFiles(paths: Array<string> | FileOption, callback: (err: null | Error, result: SgRoot) => void): Promise<number>
export interface FindConfig {
  /** specify the file paths to recursively find files */
  paths: Array<string>
  /** a Rule object to find what nodes will match */
  matcher: NapiConfig
  /**
   * An list of pattern globs to treat of certain files in the specified language.
   * eg. ['*.vue', '*.svelte'] for html.findFiles, or ['*.ts'] for tsx.findFiles.
   * It is slightly different from https://ast-grep.github.io/reference/sgconfig.html#languageglobs
   */
  languageGlobs?: Array<string>
}
export enum Lang {
  Html = 'Html',
  JavaScript = 'JavaScript',
  Tsx = 'Tsx',
  Css = 'Css',
  TypeScript = 'TypeScript',
  Bash = 'Bash',
  C = 'C',
  Cpp = 'Cpp',
  CSharp = 'CSharp',
  Go = 'Go',
  Elixir = 'Elixir',
  Haskell = 'Haskell',
  Java = 'Java',
  Json = 'Json',
  Kotlin = 'Kotlin',
  Lua = 'Lua',
  Php = 'Php',
  Python = 'Python',
  Ruby = 'Ruby',
  Rust = 'Rust',
  Scala = 'Scala',
  Sql = 'Sql',
  Swift = 'Swift',
  Yaml = 'Yaml'
}
export interface Edit {
  /** The start position of the edit */
  startPos: number
  /** The end position of the edit */
  endPos: number
  /** The text to be inserted */
  insertedText: string
}
export interface Pos {
  /** line number starting from 0 */
  line: number
  /** column number starting from 0 */
  column: number
  /** byte offset of the position */
  index: number
}
export interface Range {
  /** starting position of the range */
  start: Pos
  /** ending position of the range */
  end: Pos
}
/** Parse a string to an ast-grep instance */
export declare function parse(lang: Lang, src: string): SgRoot
/**
 * Parse a string to an ast-grep instance asynchronously in threads.
 * It utilize multiple CPU cores when **concurrent processing sources**.
 * However, spawning excessive many threads may backfire.
 * Please refer to libuv doc, nodejs' underlying runtime
 * for its default behavior and performance tuning tricks.
 */
export declare function parseAsync(lang: Lang, src: string): Promise<SgRoot>
/** Get the `kind` number from its string name. */
export declare function kind(lang: Lang, kindName: string): number
/** Compile a string to ast-grep Pattern. */
export declare function pattern(lang: Lang, pattern: string): NapiConfig
/**
 * Discover and parse multiple files in Rust.
 * `lang` specifies the language.
 * `config` specifies the file path and matcher.
 * `callback` will receive matching nodes found in a file.
 */
export declare function findInFiles(lang: Lang, config: FindConfig, callback: (err: null | Error, result: SgNode[]) => void): Promise<number>
export declare class SgNode {
  range(): Range
  isLeaf(): boolean
  isNamed(): boolean
  isNamedLeaf(): boolean
  /** Returns the string name of the node kind */
  kind(): string
  text(): string
  matches(m: string): boolean
  inside(m: string): boolean
  has(m: string): boolean
  precedes(m: string): boolean
  follows(m: string): boolean
  getMatch(m: string): SgNode | null
  getMultipleMatches(m: string): Array<SgNode>
  getTransformed(m: string): string | null
  /** Returns the node's SgRoot */
  getRoot(): SgRoot
  children(): Array<SgNode>
  find(matcher: string | number | NapiConfig): SgNode | null
  findAll(matcher: string | number | NapiConfig): Array<SgNode>
  /** Finds the child node in the `field` */
  field(name: string): SgNode | null
  parent(): SgNode | null
  child(nth: number): SgNode | null
  ancestors(): Array<SgNode>
  next(): SgNode | null
  nextAll(): Array<SgNode>
  prev(): SgNode | null
  prevAll(): Array<SgNode>
  replace(text: string): Edit
  commitEdits(edits: Array<Edit>): string
}
/** Represents the parsed tree of code. */
export declare class SgRoot {
  /** Returns the root SgNode of the ast-grep instance. */
  root(): SgNode
  /**
   * Returns the path of the file if it is discovered by ast-grep's `findInFiles`.
   * Returns `"anonymous"` if the instance is created by `lang.parse(source)`.
   */
  filename(): string
}
export declare namespace html {
  /** Parse a string to an ast-grep instance */
  export function parse(src: string): SgRoot
  /**
   * Parse a string to an ast-grep instance asynchronously in threads.
   * It utilize multiple CPU cores when **concurrent processing sources**.
   * However, spawning excessive many threads may backfire.
   * Please refer to libuv doc, nodejs' underlying runtime
   * for its default behavior and performance tuning tricks.
   */
  export function parseAsync(src: string): Promise<SgRoot>
  /** Get the `kind` number from its string name. */
  export function kind(kindName: string): number
  /** Compile a string to ast-grep Pattern. */
  export function pattern(pattern: string): NapiConfig
  /**
   * Discover and parse multiple files in Rust.
   * `config` specifies the file path and matcher.
   * `callback` will receive matching nodes found in a file.
   */
  export function findInFiles(config: FindConfig, callback: (err: null | Error, result: SgNode[]) => void): Promise<number>
}
export declare namespace js {
  /** Parse a string to an ast-grep instance */
  export function parse(src: string): SgRoot
  /**
   * Parse a string to an ast-grep instance asynchronously in threads.
   * It utilize multiple CPU cores when **concurrent processing sources**.
   * However, spawning excessive many threads may backfire.
   * Please refer to libuv doc, nodejs' underlying runtime
   * for its default behavior and performance tuning tricks.
   */
  export function parseAsync(src: string): Promise<SgRoot>
  /** Get the `kind` number from its string name. */
  export function kind(kindName: string): number
  /** Compile a string to ast-grep Pattern. */
  export function pattern(pattern: string): NapiConfig
  /**
   * Discover and parse multiple files in Rust.
   * `config` specifies the file path and matcher.
   * `callback` will receive matching nodes found in a file.
   */
  export function findInFiles(config: FindConfig, callback: (err: null | Error, result: SgNode[]) => void): Promise<number>
}
export declare namespace jsx {
  /** Parse a string to an ast-grep instance */
  export function parse(src: string): SgRoot
  /**
   * Parse a string to an ast-grep instance asynchronously in threads.
   * It utilize multiple CPU cores when **concurrent processing sources**.
   * However, spawning excessive many threads may backfire.
   * Please refer to libuv doc, nodejs' underlying runtime
   * for its default behavior and performance tuning tricks.
   */
  export function parseAsync(src: string): Promise<SgRoot>
  /** Get the `kind` number from its string name. */
  export function kind(kindName: string): number
  /** Compile a string to ast-grep Pattern. */
  export function pattern(pattern: string): NapiConfig
  /**
   * Discover and parse multiple files in Rust.
   * `config` specifies the file path and matcher.
   * `callback` will receive matching nodes found in a file.
   */
  export function findInFiles(config: FindConfig, callback: (err: null | Error, result: SgNode[]) => void): Promise<number>
}
export declare namespace ts {
  /** Parse a string to an ast-grep instance */
  export function parse(src: string): SgRoot
  /**
   * Parse a string to an ast-grep instance asynchronously in threads.
   * It utilize multiple CPU cores when **concurrent processing sources**.
   * However, spawning excessive many threads may backfire.
   * Please refer to libuv doc, nodejs' underlying runtime
   * for its default behavior and performance tuning tricks.
   */
  export function parseAsync(src: string): Promise<SgRoot>
  /** Get the `kind` number from its string name. */
  export function kind(kindName: string): number
  /** Compile a string to ast-grep Pattern. */
  export function pattern(pattern: string): NapiConfig
  /**
   * Discover and parse multiple files in Rust.
   * `config` specifies the file path and matcher.
   * `callback` will receive matching nodes found in a file.
   */
  export function findInFiles(config: FindConfig, callback: (err: null | Error, result: SgNode[]) => void): Promise<number>
}
export declare namespace tsx {
  /** Parse a string to an ast-grep instance */
  export function parse(src: string): SgRoot
  /**
   * Parse a string to an ast-grep instance asynchronously in threads.
   * It utilize multiple CPU cores when **concurrent processing sources**.
   * However, spawning excessive many threads may backfire.
   * Please refer to libuv doc, nodejs' underlying runtime
   * for its default behavior and performance tuning tricks.
   */
  export function parseAsync(src: string): Promise<SgRoot>
  /** Get the `kind` number from its string name. */
  export function kind(kindName: string): number
  /** Compile a string to ast-grep Pattern. */
  export function pattern(pattern: string): NapiConfig
  /**
   * Discover and parse multiple files in Rust.
   * `config` specifies the file path and matcher.
   * `callback` will receive matching nodes found in a file.
   */
  export function findInFiles(config: FindConfig, callback: (err: null | Error, result: SgNode[]) => void): Promise<number>
}
export declare namespace css {
  /** Parse a string to an ast-grep instance */
  export function parse(src: string): SgRoot
  /**
   * Parse a string to an ast-grep instance asynchronously in threads.
   * It utilize multiple CPU cores when **concurrent processing sources**.
   * However, spawning excessive many threads may backfire.
   * Please refer to libuv doc, nodejs' underlying runtime
   * for its default behavior and performance tuning tricks.
   */
  export function parseAsync(src: string): Promise<SgRoot>
  /** Get the `kind` number from its string name. */
  export function kind(kindName: string): number
  /** Compile a string to ast-grep Pattern. */
  export function pattern(pattern: string): NapiConfig
  /**
   * Discover and parse multiple files in Rust.
   * `config` specifies the file path and matcher.
   * `callback` will receive matching nodes found in a file.
   */
  export function findInFiles(config: FindConfig, callback: (err: null | Error, result: SgNode[]) => void): Promise<number>
}
