// -------------------- UIV+ VECTORS
//
// Generated from the python reference implementation
#[rustfmt::skip]
#[allow(clippy::type_complexity)]
const UIV_TEST_VECTORS : &[(bool, &str, &str, &str, &str, (&str, &str))] = &[
// All zeros, encrypt
(
    // Encrypt
    True,
    // (J,S)
    "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    // H
    "0000000000000000000000000000000000",
    // X_L
    "00000000000000000000000000000000",
    // X_R
    "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    // Output=(Y_L, Y_R)
    ("66e94bd4ef8a2c3b884cfa59ca342b2e", "66e94bd4ef8a2c3b884cfa59ca342b2e58e2fccefa7e3061367f1d57a4e7455a0388dace60b6a392f328c2b971b2fe78f795aaab494b5923f7fd89ff948bc1e0200211214e7394da2089b6acd093abe0c94da219118e297d7b7ebcbcc9c388f28ade7d85a8ee35616f7124a9d527029195b84d1b96c690ff2f2de30bf2ec89e00253786e126504f0dab90c48a30321de3345e6b0461e7c9e6c6b7afedde83f40deb3fa6794f8fd8f55a88dcbda9d68f2137cc9c83420077e7cf28ab2696b0df05d11452b58ac50aa2eb3a195b61b87e5c65a6dd5d7f7a84065d5a17ff46273086002496db63fa4b91bee387fa3030c95a73f8d0437e0915fbce5d7a62d8dab0a58b2431bc0bede02550f40238969ec780410befccde6944b69dd007debe39a9dbc5e24f519a4bdf478b1d9ec0b67125f28b06efaa55d79412ad628d45089c3c304f94db3a21df6cdaf6d2e2e3b355441eff64ad90527e752a4b2ebb4d0a1070ce2e2982e272fdb7cf4b584b095a0f957fdb828689437e37dc48b2ad379c6f3c6e957ee77afb88c65949ba12eec45c22865e4907ae42aee813898acdf91e2e4c21d828e0a76de2bb6bb6f869e5eef1f618dedd27562812b9a14e8996a5c352df3817e60d6ec20119a52c80a61ec195622627240212decca515feab63e2734587948a836a7de205cfec0c288351c"),
),
// All zeros, decrypt
(
    // Encrypt
    False,
    // (J,S)
    "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    // H
    "0000000000000000000000000000000000",
    // X_L
    "00000000000000000000000000000000",
    // X_R
    "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    // Output=(Y_L, Y_R)
    ("140f0f1011b5223d79587717ffd9ec3a", "66e94bd4ef8a2c3b884cfa59ca342b2e58e2fccefa7e3061367f1d57a4e7455a0388dace60b6a392f328c2b971b2fe78f795aaab494b5923f7fd89ff948bc1e0200211214e7394da2089b6acd093abe0c94da219118e297d7b7ebcbcc9c388f28ade7d85a8ee35616f7124a9d527029195b84d1b96c690ff2f2de30bf2ec89e00253786e126504f0dab90c48a30321de3345e6b0461e7c9e6c6b7afedde83f40deb3fa6794f8fd8f55a88dcbda9d68f2137cc9c83420077e7cf28ab2696b0df05d11452b58ac50aa2eb3a195b61b87e5c65a6dd5d7f7a84065d5a17ff46273086002496db63fa4b91bee387fa3030c95a73f8d0437e0915fbce5d7a62d8dab0a58b2431bc0bede02550f40238969ec780410befccde6944b69dd007debe39a9dbc5e24f519a4bdf478b1d9ec0b67125f28b06efaa55d79412ad628d45089c3c304f94db3a21df6cdaf6d2e2e3b355441eff64ad90527e752a4b2ebb4d0a1070ce2e2982e272fdb7cf4b584b095a0f957fdb828689437e37dc48b2ad379c6f3c6e957ee77afb88c65949ba12eec45c22865e4907ae42aee813898acdf91e2e4c21d828e0a76de2bb6bb6f869e5eef1f618dedd27562812b9a14e8996a5c352df3817e60d6ec20119a52c80a61ec195622627240212decca515feab63e2734587948a836a7de205cfec0c288351c"),
),
// All ones, encrypt
(
    // Encrypt
    True,
    // (J,S)
    "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
    // H
    "ffffffffffffffffffffffffffffffffff",
    // X_L
    "ffffffffffffffffffffffffffffffff",
    // X_R
    "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
    // Output=(Y_L, Y_R)
    ("7209baed4b605b158b7eb25de2200e83", "3fdc18066b5d503f8c98e83be033b6fba905324267618cc6989b486e0decf7cc897d17be093286a4d4fb5016c3e3323ccc416a30473081473bd471e430194ec4e2ac0af3bca0577b78f4c70e4dce9a3b2151d493584db307eae803cd73aa5a582a233bd9ff194e5418580a1f79a5533e1ec3686d5a0c196ddb9a55aee47e9c7020782ade85cfe15664f21244c6c04c198c26dfd9f25d9db796b995e42195861ac02d0966c5a12487e8b70ea6f0160cb649df33d239801a7067cb3a60b76402cc17d1394387a8f91866da3aa61cd79f74f64e850eeeef22c6a002e233e851c231cb50ca7a2dbb9778b34f68b9cb338b3d322b35b5255155d03d3b68b9d5a8223d0cdc770a7489f93a46cea8e4a5915a2c374d71c1809d735589ab26b2d420ce6196d93b43d0e7c1db651276b2f8c387dbb6c6e643ddf8ed58e17e3daa719a9b6f53f6f21cd1f278876e4ad639511cb775f5328a4f7bf6875e73f886c36f277866eac696a389649d96c76899556c5a045a5e26e2a1dd0a5071f23cc37c49bfac896d471239d6b9bea5f48050a18f1f99a1fdbf0743a9d6c13c9a4d60c3405d56ce948623ebdb5d2ee15390b47ea7070c4b4db92fa5a23a86360cfb6cd30c9e95d7f132d3067f3d9e2cfed91b6c7c782596b5403a73a842c79f296da2719493e63547b82f72474d806f8e246d73e8"),
),
// All ones, decrypt
(
    // Encrypt
    False,
    // (J,S)
    "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
    // H
    "ffffffffffffffffffffffffffffffffff",
    // X_L
    "ffffffffffffffffffffffffffffffff",
    // X_R
    "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
    // Output=(Y_L, Y_R)
    ("180d604716ae3cc001863cbd746d47b5", "24c5f5db8def563e742c7ef8fe6cba43fcdf69fce05918227a5b58149a0d76db82c80e193e8bef96a8042b4c4a27645b630d9af3737fe3574930c41345f843127fbd27e49df15ab52635bd91ec0e0997223ea5c33376e4a5805a082f01ee5dee9fe2927628b37995f98d72eb426d2412616b199b11d262d32a9f8c1a06d7a47978252b8c17e3af7a4c7aff2c2f6e480060a3afe58f82bb278d15539da3d1d6345400c676e444c66804b7f00d517d1d36487fef0b3148098df490d99d638797267ca2f0a2608955f4cf6c855511ec0931a751ac89856f68a85881224688edd64b56bee72da382abf487a9f1706df302bc33403fa21803348be6876b5cc4c9f9a960f744383d35ce10f08655abb055e21fa6786c59cf99edc02b989b4c16beb491b8c3578e02803b1b6489fdbc46f273a463ccb618479091d8029030b5b81757d747387cdda82438f3e4b944159c19b1473e30db758443c903378b505802ab9df6724ea1df898e069bfa2af676c9fc5b44f5bfc775acd34320ae5eda52ecb00f88eccc0bea148803821539d826106fc6840631ff5e1b006729bc4e5c39b58a7b340174a9a7676586599280620e5c0adf71918ceef77795fb9217b3687bf1f164e9564eff870d2e048844e173ef1ddb48b71e08d4c4a5bed47a225930040a77fad54af472ba6b51febe2b764061e5"),
),
// Pseudorandom 1, Encrypt
(
    // Encrypt
    True,
    // (J,S)
    "22169d562646db8ce3322daf9fa8e84bed57dac18beabdb619b40f5a02786e439e6132a5b7e7445ef962e2c7f30a0b2ec994ee1935e1787d6f89cbc15b9254d5",
    // H
    "81b1a82c63d8dd9f682f734e82e259a14b",
    // X_L
    "db4adc246c6a54fe55e11901f08f0eee",
    // X_R
    "dccb8aa0570982d5b08fa6b4fbb3bc7bcd7e1cb374f114fcdd0ed53255c523c1e8ecabfbaab00105af9933eff304a40877e3006be82417e44462fc6955777baf2f2f9c99966ddee30b7c65050dcc8f5d7bc22f9192e1c4a83ca0a2338deca9da4fed14058812ace259e9851f50c83d97515b647ff56749a3c615e1860a404e9b05619a48aa3e5f09779e72c77dfdd1ab5d796860178938efffb4e43bda443c2fba0d5be14baa375d881ee5e14d760a12c4d9807c8c54b714a75324c4074296ba8c86beceb4dc2337946f0af67c759d999d56aceebefd80438dc625b0b50f749440e8cd5bcee1afa05ff8cff1bfd3e0e68930b74b3baa7e6cb723896afc3098326716e0554319c9f8f3683a8fd359ae48a3591dac67adeea6e24600037cb1a42c38b23a9e7c31e6d0b13b84e88341458050856c476f6875dfe17806e0cd72baeebd0e1108fb13088a887153a1d13bac414ed120c26bda5bc08202fc1489746305dcda5dfc3e6a869b52d63654f3bc35841a2345df8691caf1de06d5ebd214af729e239efd62d05060eab13fb973ffb41f461224e2eee1f739529d37e8db40c065e52de7b8f19fbf695470341062c7f212d8cf5310cc17f487e04e8ed03fe50f3758eda9e41bf37af62f94709b16e01b4305d1a5ccad2bcacc7e35d4a1d1a40c26dbf3153739175ca65ab59cc1c9",
    // Output=(Y_L, Y_R)
    ("9ff8aec547f02caae7555ad7b0cb1372", "2c146ab50a19b0876c46da9b905d018b0e6a3e37a6e2c8d19f1f95455589491d2b37eb01f5233f00fe62df37e8872849428964cfa76f2ee576f40d241fa01e0c282bcd8f6af6bd1fc0abf3bafaa0868026f71b313d9668df4144f2125a1e4d9f161e5e9a4805c198741ff7439f8ed66174e4b1c031257571cd8207248fc96b0eca7cd2ab2b55738369021a9dd773be07a18867d7795c29767737c00e57dcd1e9bd7a11751571e0372fef750dfa9db34811ca501d44319ee8cb879cfa284f6bc987b18a2d7157b98ffe34ac0941667c996dcd0f7612b297c9dcbd4df42ebde396b480330241798144fa9d5f53186ca7146acdb58ee362ef9474af7ba560002b35ee9923179e3561eb2a31c16a1872c922bb3b4290062ba804c393d7cd17a739e2fd2862d01ee839e4be0f06761502c3c5cbb8803a11d558897b860e36db275728c589edd8fa9caa1784efb135fdf7075fc5dce030e6bf99f76e75c1f6856d26a06459f53d3a19bc3b658d3fbbe67a8b428609514f51dec71dd2a8e8811801f1f6c7275208a6f8cc62ea82f9ac82d7b899e36a287a56f5794f35f30f7f06c0ff61834701478e0f523fec0122c63683c3e6034724c98cb7164608efdbe1e916c9f3122119c27595e32ef18fb16dca7ca0766f9418b6cdc1030f65de928649269a30f523f6d79d4f3911b36d6f1dad"),
),
// Pseudorandom 1, Decrypt
(
    // Encrypt
    False,
    // (J,S)
    "22169d562646db8ce3322daf9fa8e84bed57dac18beabdb619b40f5a02786e439e6132a5b7e7445ef962e2c7f30a0b2ec994ee1935e1787d6f89cbc15b9254d5",
    // H
    "81b1a82c63d8dd9f682f734e82e259a14b",
    // X_L
    "db4adc246c6a54fe55e11901f08f0eee",
    // X_R
    "dccb8aa0570982d5b08fa6b4fbb3bc7bcd7e1cb374f114fcdd0ed53255c523c1e8ecabfbaab00105af9933eff304a40877e3006be82417e44462fc6955777baf2f2f9c99966ddee30b7c65050dcc8f5d7bc22f9192e1c4a83ca0a2338deca9da4fed14058812ace259e9851f50c83d97515b647ff56749a3c615e1860a404e9b05619a48aa3e5f09779e72c77dfdd1ab5d796860178938efffb4e43bda443c2fba0d5be14baa375d881ee5e14d760a12c4d9807c8c54b714a75324c4074296ba8c86beceb4dc2337946f0af67c759d999d56aceebefd80438dc625b0b50f749440e8cd5bcee1afa05ff8cff1bfd3e0e68930b74b3baa7e6cb723896afc3098326716e0554319c9f8f3683a8fd359ae48a3591dac67adeea6e24600037cb1a42c38b23a9e7c31e6d0b13b84e88341458050856c476f6875dfe17806e0cd72baeebd0e1108fb13088a887153a1d13bac414ed120c26bda5bc08202fc1489746305dcda5dfc3e6a869b52d63654f3bc35841a2345df8691caf1de06d5ebd214af729e239efd62d05060eab13fb973ffb41f461224e2eee1f739529d37e8db40c065e52de7b8f19fbf695470341062c7f212d8cf5310cc17f487e04e8ed03fe50f3758eda9e41bf37af62f94709b16e01b4305d1a5ccad2bcacc7e35d4a1d1a40c26dbf3153739175ca65ab59cc1c9",
    // Output=(Y_L, Y_R)
    ("ec6f9cdf2e0437c2021e4897f912ca14", "2cab63c03f62431461c0713d66ac115717340f433a427005173c83c1a6a4cea86a21214210be6623669a91fe73d81e1b8aab018899ec62666a14030705d822397161572afee91ff57e4d917ebecdf9b03e89388e3c5752d9b6503528c669cf06b1e192079a7f743f795529307b7788f47f1a97d6694f4c477ffde60fa2f15445249626da606ba8d1c680f9087b4b46e31101033b57b7f054ead97f28e9e33a9b2b06cd08ebf2afa03d6ab2f4aaaff1d1316561695b86ea9a3dce872a2492121cc3c59c8f4bfced8abb67b1843b955b74112dc8ae04993be6d9e7c3ef9688feaa29e2e5efc2392c95d9d5005ca8867d22e00f739b0781e0b19da8eaf07c10e395e465b3835464e5c272fbf176b46ff5a7477f22d29762ceae373da0619caec86664e879fee3171950c0c4187ca4a7c4668c628cdf94342d5947ec0a4aa0bebd98a4ca9a4595da7e7b44b6b2fde484babef06391c2d7de6f597bc0846471af5f63e6cc167992ccb6ae12f5a9e41873e224712ad01373244aa16a56796068a1b9b58031e6cb46d7dfc734e37d25b0347cf923450b2b089187271cb52c2577fba9cbd5728f4f5fae19f2198dd92a492028c3e03a25146489d15c7b5a31a0fd6e849ee49f828e1d7005dd04660cd9716a5a6ca2984a2b748eee062405a5273f2aa69757f059ca9f41e649d0555dda81"),
),
// Pseudorandom 2, Encrypt
(
    // Encrypt
    True,
    // (J,S)
    "e61126a280c66e99171b1ec940a75ba6d4c3301062760a9ff9f9b332433b8408af4a49ad5326b95da7f501bb8b34bce8ce6e8c33f57263a4779a161d3736b7e4",
    // H
    "837d18ad2b0162977d3461349b00bcfdd7",
    // X_L
    "4b9fa9b1d31ada9a15d29cd0bd920a53",
    // X_R
    "c819e68a3dbdb6e730e4c9ed6dc11187f7ef0f021f63f0da32b55c8e2c78d4bc55d0e487329542e0b63a8f57313a146443cb5b8ba9eaf77d7e80884333b0e33b806da9cb32e231b5a23aa9ffa6f598df337126b26d6f9ef0d6c6a1bb59d83d253ea0ddc7272d633eb785dd7649fb7618a3b2c721cfba7d3e3d4a95fafcb90c2c60a52258ff3da3e1ab1205747e049e4730d734eaa5744a18fa8b8c4aed37d28857a5877839a40659e9754795859dad3163d6358234072ae62f64e58c861fd2225c60a708bb9b199e2070315e6d8eda8365b7cdaf5d067280086fda2a304ccbf3177fb0d34bbc3b02b4aaf42e535fbf2a15b782a8f3004eecda69aade92eb7bc92b6d552172bd26db28dcdf36547fa2794bf598db51ba0578f176e0cd3db04bf8333819a17f9c0d6faa9128930a3d8e93170d1bdf4e17a26f794631c870d9fd0edc73c3ce51753cbf59f3c942b689ccd08d8c0e0b19840b5113b760893b7d3b3a7c8f2c8794cab2f35a49d1d3f8c93bc353f376904d1961d3958cdc7a1841fe305c5c48b98f3b829ab1540876c3bd9d73e979107ab6f8146fe8acf33bde92b0a0ec2088dca60ae8374bda9d36977e5653762e8744d2b66d5bcc26dde754ec5eb3f665fbdd1ce2d0a7a48c499c0a5b846a7cb3c478484703c31ebb0c20c66bc1c1722529be0bb850d9bff7437ca7",
    // Output=(Y_L, Y_R)
    ("6db7f5e28e54c81ce9a22df58eef5f65", "3cd4a53ab6f736234b88de2bb410502562856a75bc99fea4e58a4032b5d2c912cf7a6156bd2b78f26db2e0d40840f1ba131b212b910238c607a1445747b0fdf4a52e3d8d78552e72b1217b02f3eb6196769c65bf33bd71d60cdec6f232e6c729937183eab9e8db0b0f4f1809841820541d4d4d7d7eaf0a137438220c4262a67d38699ff0b71f95309256e48a951fc4f1af89f2df3af7f3c87b85acc47eb5a290018d348b077f447f46b5bebb6948899b98727eeb6245ad9aa907251ad1e6d2b54a11a8b8e3042c8396b38aad0610079270797e7b895474073b1bdd7a88500f0d2fa6201e64689ef2aa04bb426074e62f9dd3e624eef830281f901b502dde7460aec813a04320c9c524cb8af8aba6894b8a8d768e568e19640c41d1e77e9fa1d5ef62ab672d11a5619c969a302d1bdde88a4ca6c67e8c4d417ae711d4762d486baaa594c2fdb6b5c0d75c7c40546343feef2972dbcd8b9d2a2645a9afdf2487fd2aaa99a68e7bd58046482a76c7eeb25a9e6d4e3b8709c598de6e34421c17b0d261ffce4173e391270e1365d92d584ff9839914fce74e0e7a784aee9ddeea7b2f4174fdce57ed143e27e665f96c849588c8c4618f19a4eac120e084015509c4d651729eb2312f185f86b7704b505ec43f6122e9c9281a1017135460dd37211bd129c7f92d2f7101a229b81598e6"),
),
// Pseudorandom 2, Decrypt
(
    // Encrypt
    False,
    // (J,S)
    "e61126a280c66e99171b1ec940a75ba6d4c3301062760a9ff9f9b332433b8408af4a49ad5326b95da7f501bb8b34bce8ce6e8c33f57263a4779a161d3736b7e4",
    // H
    "837d18ad2b0162977d3461349b00bcfdd7",
    // X_L
    "4b9fa9b1d31ada9a15d29cd0bd920a53",
    // X_R
    "c819e68a3dbdb6e730e4c9ed6dc11187f7ef0f021f63f0da32b55c8e2c78d4bc55d0e487329542e0b63a8f57313a146443cb5b8ba9eaf77d7e80884333b0e33b806da9cb32e231b5a23aa9ffa6f598df337126b26d6f9ef0d6c6a1bb59d83d253ea0ddc7272d633eb785dd7649fb7618a3b2c721cfba7d3e3d4a95fafcb90c2c60a52258ff3da3e1ab1205747e049e4730d734eaa5744a18fa8b8c4aed37d28857a5877839a40659e9754795859dad3163d6358234072ae62f64e58c861fd2225c60a708bb9b199e2070315e6d8eda8365b7cdaf5d067280086fda2a304ccbf3177fb0d34bbc3b02b4aaf42e535fbf2a15b782a8f3004eecda69aade92eb7bc92b6d552172bd26db28dcdf36547fa2794bf598db51ba0578f176e0cd3db04bf8333819a17f9c0d6faa9128930a3d8e93170d1bdf4e17a26f794631c870d9fd0edc73c3ce51753cbf59f3c942b689ccd08d8c0e0b19840b5113b760893b7d3b3a7c8f2c8794cab2f35a49d1d3f8c93bc353f376904d1961d3958cdc7a1841fe305c5c48b98f3b829ab1540876c3bd9d73e979107ab6f8146fe8acf33bde92b0a0ec2088dca60ae8374bda9d36977e5653762e8744d2b66d5bcc26dde754ec5eb3f665fbdd1ce2d0a7a48c499c0a5b846a7cb3c478484703c31ebb0c20c66bc1c1722529be0bb850d9bff7437ca7",
    // Output=(Y_L, Y_R)
    ("03d9bd8ce21f970fbc46413aef8fc3d5", "c474be82fce6aac8fba5bf2d4730efaf3692b77512e195e423f51e0e92e04de2ae7b96b4e0bf27eec1900631adb4094f557de386e0ec05b9827a3f2f147bd6014bbbbe5f45ffdb6fb839154d8ac773b0e18e5d028856452c8a6e8fb8686ade64250423899d5932b764db7095585859d95ad3d99a9b352e7000bb888c2dbb732cf5fccf63d8bae537e1c14f1a37bc9aa48e1cf298e2e4c78abdd8f3d224f67a0ef0486590a6f69b4412e7451ef0b040cd80d68b29c283182795d503061429380759db84125f9d5d90e9352708f173754f2796070da600d13ca3ef6e38e4a739a0ff5b81898f6232ec4ea5a2ecd1e446162357a20b7d03b7368830445a6d79c51c87fd299e5da9b6f9c44a61832d7e8815eb21806e4a1b23903048612d8001c7c3e23130bfbc0d6a36925dd1264a0b37d87cadb439d75d0e44488b95505b35ebb3e1db54848cab5c15758704bb52b2a2093c6d08c9595362727827a8187ad5ca9dfcaf3575135997c5f3f8512eafef3f4b06d578de38a292a7b77c7cb128256fd1ab3c643e2a57222a53f62a421e086e38379d55d74700add78f8f6ca6e115816da29635d8f6d9f39a0aed9de719ad68762c194d552e73b9f480b0de7039af2eb3f863061d296a7d164aad939f61c81ed10447afe24220fd234f1cb99ae76128b5e7d02a252d3dd675a990c3e74b"),
),
// Pseudorandom 3, Encrypt
(
    // Encrypt
    True,
    // (J,S)
    "f32563514c60b34aff6107deb5a324e97833eb0da2c49ca86c3c977974b18d2148fc035e8d2d7bd6f29cfadd9b947caefc5fe707827619134babb436252c0391",
    // H
    "a97040573c1aae79986f933d6286e6e069",
    // X_L
    "84a8b1973bd819e817aef7a866bd2016",
    // X_R
    "73e89e5eea49fdb60bc19671e46c47d404047a75b9e80ea4f433b473f66f10a4670dfe487d54c49b1e31feb4566effbf42c1f04322f629826d580671fc45ee4f3942d424cace60bd159cd5de7138f931682569afdefaa769cd61e46b4f9d38b9214d953b40889a18e26b116c5af9eb0efe4d8cdb60ba09380cd0abbf42382ca5376d52b9c9a4700b72834b3f64de998ac0b1a619cc944583db92c04bb98875bed6b4afa60080830b03e809e9de9d1ecc4f7714751d7fbf83060895b749aceefebd09b745a326e9c85c7eaf39b7adff950106ebb65ea809d7b22b166971ee931f41c1f6b2ad8f0ed9c29223ec008dbc6011749782c2c01ee5a9449329f75cda97dab10c0e0824ecb4f5aa26cab07236a1c6a997fedbe7bb0e92a3a6bc04bec72ccc87fd75268fe534124462595ef876ddddf5133315e70ad60a5c3e98c0aad8e07019874123b5bc37364a7e1bdeac5b3654c3e7509126fc0a47a14ba7200cbef264e2fa29fcd46230c510a1403b61feefeee659e4ce44cb76d723bfbc9a8e960d8d02aa62001dbf5e0f43bb688c7c43d8851b7a6e967dced63803310b7b34bac0b56ba041a0aad014ae6f3139590eaa2a993332ff47cb096d5a6e8fa39d924580d343989ccc9bca7b4b94c2778bc9abfa0c9dacb0e40745032520e923a7c2cc1f0599cb84620b9058af0b6c382f",
    // Output=(Y_L, Y_R)
    ("1cdf946d1d9305046d085170db0a9b3b", "a626085eca89222587b5360b29c11428db58c2ce694c415db38bac14a3da0ff92b7a448cdad45df04280de0f88153270fd92a3c34ccc0800fb897fbddf15e6bbb6714587735643a5ac9358851f13c0eebc46fdbcb73bfe83804bbf5ca213bb76cae01adf8ab82fd48ebaec8e6d6a28eb833c5ac9f780d5b0e4bc62f021b36067374fdb65e899503b7d4992a2447fe41cbc90c11ddc0639219d877712e577be8c156f04ddd9af1bc7f426c4dd836d29da9765cdac5eaca44a652d8f1ac578795e543089d8d8ae5f2dacc59d208bc0a0326ebddad8759ade776652b70e4831c752c2b26598fd590a7326590fbcd7273088c8ab6307c571b216ad2274aec1a11f684158272114b141c32e249a6f81fa06f8602b972d4259bb6257b09c596f5dd58611fe83baeb7029cc65c476f92743afde6e82f9f4e39a8e3157103f6fc4f5809b3a681fe70484d0a4a38062fd1e4871d1ad812d5f5d3c911eef34a1c951bcbcaa1a91d6bec790d6e4b59162c34837684cff7d7e027c99c5f533201d6c62fb33eb3cdeedd812a8e30b7653f8fd3cd46cd5ca8fce3544baf2be7f4d6c9ac61d75d6314ee169f17e86725c0dbbeacf5233b1df683461695c4135e3f0971eade0ea99441753b6942661a372482ea7584bfad8d2816c3e1b2c9328f5dfac5e8f93c3aa53a8036579bffe3b21cfa741bc"),
),
// Pseudorandom 3, Decrypt
(
    // Encrypt
    False,
    // (J,S)
    "f32563514c60b34aff6107deb5a324e97833eb0da2c49ca86c3c977974b18d2148fc035e8d2d7bd6f29cfadd9b947caefc5fe707827619134babb436252c0391",
    // H
    "a97040573c1aae79986f933d6286e6e069",
    // X_L
    "84a8b1973bd819e817aef7a866bd2016",
    // X_R
    "73e89e5eea49fdb60bc19671e46c47d404047a75b9e80ea4f433b473f66f10a4670dfe487d54c49b1e31feb4566effbf42c1f04322f629826d580671fc45ee4f3942d424cace60bd159cd5de7138f931682569afdefaa769cd61e46b4f9d38b9214d953b40889a18e26b116c5af9eb0efe4d8cdb60ba09380cd0abbf42382ca5376d52b9c9a4700b72834b3f64de998ac0b1a619cc944583db92c04bb98875bed6b4afa60080830b03e809e9de9d1ecc4f7714751d7fbf83060895b749aceefebd09b745a326e9c85c7eaf39b7adff950106ebb65ea809d7b22b166971ee931f41c1f6b2ad8f0ed9c29223ec008dbc6011749782c2c01ee5a9449329f75cda97dab10c0e0824ecb4f5aa26cab07236a1c6a997fedbe7bb0e92a3a6bc04bec72ccc87fd75268fe534124462595ef876ddddf5133315e70ad60a5c3e98c0aad8e07019874123b5bc37364a7e1bdeac5b3654c3e7509126fc0a47a14ba7200cbef264e2fa29fcd46230c510a1403b61feefeee659e4ce44cb76d723bfbc9a8e960d8d02aa62001dbf5e0f43bb688c7c43d8851b7a6e967dced63803310b7b34bac0b56ba041a0aad014ae6f3139590eaa2a993332ff47cb096d5a6e8fa39d924580d343989ccc9bca7b4b94c2778bc9abfa0c9dacb0e40745032520e923a7c2cc1f0599cb84620b9058af0b6c382f",
    // Output=(Y_L, Y_R)
    ("4dddc62a3f3f2f15528fdbb5d4cc9bad", "d31627e244390dc55bb930676d04d969289c37377cdf51d8d87b587361f5ffb492a1608ff6d1ef2ff3336e56ed22c9b250bfefa04c9305265aa04de6001589b357a1e779aa27d10638da07763cd8900774ee0e017754b2c469d59d2c005c13c00400165edb181fd150cda9d11e1be238f0060828dc9ef23aac11e41acb2e27ac0d9d87ad07e03dc4349afe74726ddfd01d0e4064ef15dfa27417d038fdab117f0c69bdd2e7f70a94c08a4d458c3b0ec92a7c7fbf61ab2b0a9348d28ab51915e952306e6baa728d4c1bf9567b0c3b289af776602e7c125b8d05b590bcd74c5ab629cf677d1e3468cc6c6eb6e430c9b560aadc40393c3ed44b895456f1eba27ee038f9b98ba1f07f29877bb4aeeda005135148b8d1a603765fefb9266690e693e5fdbc4527a0674c3714aa39915a5f5cb0558513fd2e965ebea2d614cf6cfe23c2ce642771bf378097c2afe43b95284afd990a98dde1251a1f1de2d5650960882ac0c12e7a2313cfdebaf05a9dd8c95125d26a6553798d3f745a87f41dc228e9637260a6546bf5e73c738cc33020f4ce312538933405e9cd75d1f4c2418b6a88dfc6846a6a2a3a62cfe107ccae87719607ff801d11bf8b6024cbcac6d66a22445e2fc92baf0bb58348adb27aabc48132c93299668652886017af19117de6a7aedd20c5ceeef86b461c813e2cc44b"),
),
// Pseudorandom 4, Encrypt
(
    // Encrypt
    True,
    // (J,S)
    "7c5f3d9842de08497272a35a2bd9d877af6afc3c9129a8f98d5b2bddd3c1fce97e80c0ad331c69cd85c1bc2af104066668d57b16c7ced48a950163522dcbc37f",
    // H
    "e75e52a81768470fab9b32245352f13511",
    // X_L
    "1cb4bee05ab1f045df3f32be190106dd",
    // X_R
    "00f2becfe9dbfef521fd09dabbad42d2246296090062c6ce100f32cbbe1a3656e30552aa27a5d686f7fafacecea10f152913bea3e2c1cf67c6193cb3964844e868a7bccf58a85eccb8ad2dfff58640c6a39081f4234ebb0b099fbe48b3d42b17e15eede1db369d5b73cd223f3d062aa63fca1e886a4a88bc4aeef9d4e4583754270f59da4b5bcaeb0e661ecd9ab342191019bcd4dab8fff6514a6a353215699e59884cbdcb4dad9ea7dce8acbd24aeb9ede406d14c61df9c48a95f3e9169d295f8fd5df19174325c0bf132855d7d23b72a23b18016a1e888e51b3484600f255de4922c51acc7092656ea162160fa9159a10ec7b1c081605028e0bf4641e1cbba629ad85ae9c75de4c73c08509bc36ce8405589500c3cf4f3a871bddaa77831dc105a9941da1dd594c79c53f130f72450c92dcdcba8b6311298ba5c1cbe3d82235ece74a2061622ece1e41d3a42eaab31d049b7843301647ce062668d7244a50cb37343621034ef825eadf3c47ebc246e44ff7c84e5fb92dd3b8a8d8b1e44867fe49a3bd8814513441dd4c4360305194dbbeb877101f595f0320343dcbb9843402ac3300a1f5e1a02f1141cee369e5dca27b105a305b1d75e99b50ddd2e9bf6c092ce0b95345dfdf2740c9d212186d8a9aff9d2d04b32ef61099240be6693e69eed715e0697e252798a2ee274f0",
    // Output=(Y_L, Y_R)
    ("85ffba80eb5137eee559745dceeee851", "577081712a609bdba2eef981421504505889e3f3f86c68356da15967160c271dffcb14bb0cbc2b1c2442317673e2b31e82ae1a4bd7402c6d9ef14a4f079abc062c14365cec46397c6868dfc6a08dc9432192ed679d14d3e347df60a6d87d4de060fbb1c6a3c3ecc37a1e0c0a4eceb0c44b2cfaf8289124c63680cf508cbcc0aa535d1656a41da2c97ead1bc58e30767cf9daf8ddd5359fa4b24b7147c4e7f552e3e5aecb9adf59b6f224e858ff3d7b867fe1c7e3a1084b286ab570dd4ebf14314a9c83fbbead1f040549f48fb1ed3aa9844e5aee4e8009f1e53122a11aa943530736a770667a7addd17cfc0c4ef875fc41fa4c35b6f1487a45af84f9780765742284be2684996eff0b4f2041772ba245667e6d51bc385bba3894894f2868ae39a2a9e3c29d56881af0ef148891062f002e5e982082ad770dd3c2fabb07c4e0ed39bf9a4ab25f63dcfdaa1869d071166d522899c9368d4ea65c749123496b5cbe9347ecfea2e6023a963d138847607198ff7a10bb58308fc51222bb72ec30c3cd0e86efbab1e6b09b4c0e1db98b3c8d4de0e306d86e37a0217095946e48f98f3670ca3bddf4006ab96c431f519aca158f8658cbf888ead08e210a6740a416469a37c11993bbd39336b0c05037c64c5c7309145642acf09003ac1dce306d19ec9949ee4c019eda205dc5457f70e6"),
),
// Pseudorandom 4, Decrypt
(
    // Encrypt
    False,
    // (J,S)
    "7c5f3d9842de08497272a35a2bd9d877af6afc3c9129a8f98d5b2bddd3c1fce97e80c0ad331c69cd85c1bc2af104066668d57b16c7ced48a950163522dcbc37f",
    // H
    "e75e52a81768470fab9b32245352f13511",
    // X_L
    "1cb4bee05ab1f045df3f32be190106dd",
    // X_R
    "00f2becfe9dbfef521fd09dabbad42d2246296090062c6ce100f32cbbe1a3656e30552aa27a5d686f7fafacecea10f152913bea3e2c1cf67c6193cb3964844e868a7bccf58a85eccb8ad2dfff58640c6a39081f4234ebb0b099fbe48b3d42b17e15eede1db369d5b73cd223f3d062aa63fca1e886a4a88bc4aeef9d4e4583754270f59da4b5bcaeb0e661ecd9ab342191019bcd4dab8fff6514a6a353215699e59884cbdcb4dad9ea7dce8acbd24aeb9ede406d14c61df9c48a95f3e9169d295f8fd5df19174325c0bf132855d7d23b72a23b18016a1e888e51b3484600f255de4922c51acc7092656ea162160fa9159a10ec7b1c081605028e0bf4641e1cbba629ad85ae9c75de4c73c08509bc36ce8405589500c3cf4f3a871bddaa77831dc105a9941da1dd594c79c53f130f72450c92dcdcba8b6311298ba5c1cbe3d82235ece74a2061622ece1e41d3a42eaab31d049b7843301647ce062668d7244a50cb37343621034ef825eadf3c47ebc246e44ff7c84e5fb92dd3b8a8d8b1e44867fe49a3bd8814513441dd4c4360305194dbbeb877101f595f0320343dcbb9843402ac3300a1f5e1a02f1141cee369e5dca27b105a305b1d75e99b50ddd2e9bf6c092ce0b95345dfdf2740c9d212186d8a9aff9d2d04b32ef61099240be6693e69eed715e0697e252798a2ee274f0",
    // Output=(Y_L, Y_R)
    ("d46dce4339ce3f3f3330ef5d3f795934", "4d99fd03926c529152679a482dadeb866873f7122147c4f7a72a6e85d89f7804b1802d595b204cac6e50ca6e447562ac131a570672d119ca9a5a807eea7dabef4337a9173ad8641a00dbeae368c1e4296bf0091260b4621fb87a0e169d71eab5707d5c5e7ab23af65f364890a2b96d3689ef986f36beed87c6e30f207b643ca2caed5f61c112e716be4a8a5abb54d4c362f6230d6029e73002e979dd0bf7e2307005038f84c6145b63f9952688c98c1b416a6331c0b4451bb24be6491af04a9cfd0767a3a9473455fea671382c426c15ea48a1fed79054ed88054ab1eab43a740ccc1cf316ac068b5541958c76ccb4831a7574d731742d8809be1855183c40114ab156c4522c73203e36b7d907354eb5c6520da0e172aca47917418f036ab37f179ec738fb0ee7a0c32eac2f613ed08095a662f3a8365de737e7db4c23d8a93b7ca289fa0a324392946211dbe79300342ae317a6ceeed4f97f52db206f1710c726624dd1707f81a0c98cae37bf7e4299ab0b06093c0823d57d9472447d54d5c68b80f1107b9280f2d9a6c01c57afbdd63ffa0e4b4345f71dc1ba5ad7667d0ad10f1d98417c31af44c5777d3644f5a6d0867025b6f01923850451966dffb4f5d66b7014917b597bc2bff2240385de3e47a699fcf797893cd175c4ac7d3fc036d23a08f20f43a2662ab0e1575bb9"),
),
];

// -------------------- UIV+ KEY UPDATE VECTORS
#[rustfmt::skip]
const UIV_UPDATE_TEST_VECTORS: &[(&str, &str, (&str, &str))] = &[
// All zeros
(
    // (J,S)
    "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
    // N
    "00000000000000000000000000000000",
    // Output=((J',S'), N')
    ("7941dd0a63d994703e63d94a446804213ab4fb1d2b7ba376590a2c241d1f508dc6a7f418a14503deb89b17aadb2806f73fc06e5d14e675f5ec880023d4f73296", "12dce4a0e5bc792b5b5a55f9c2f30e07"),
),
// All ones
(
    // (J,S)
    "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
    // N
    "ffffffffffffffffffffffffffffffff",
    // Output=((J',S'), N')
    ("0c64bc2163059fad612a393dd7153e8b5ed68b8a84a9d2d7b9cb50770dd650c53344b53f0ea1083115b21b2095365dffa9e5d73b68714046ec734747dcfeec0e", "f3795b0e416e1295629aed9f414ccb53"),
),
// Pseudorandom 1
(
    // (J,S)
    "bf9b13b7097f5eee96b15423348ebf7aa13da31a2955a72ff17c7f75f9fd92f3280bb2d8992bc2a5f70f8e4e10f0404f16f3a0bbb91975bae7e11180adcba6da",
    // N
    "1ecb6e1ee6f0531c233676fd1c3ca701",
    // Output=((J',S'), N')
    ("e235a230bbc8c24d9796b17be01c614c9d623773c2ad9ba718f6e8f8ae11a152c0523fc64c5fd57c094ecee52b86bf0d7015b098d0a554a46b8768a2353fc058", "42495c791c7c15b5467dac1272c6a22c"),
),
// Pseudorandom 2
(
    // (J,S)
    "e773e6211d22f03e0220bd6e69803b2d0bfbd6321a9e0184e49660bc1989318a868d5ccd3f769537c4990df2998cddc14cd853d8614c6e7e3548af9c824b457d",
    // N
    "d8097e67afff2d56a6279229cfb37f29",
    // Output=((J',S'), N')
    ("30105ab8a79fab42b03182b77e0a9005c445d4f07269d92a64e691a99f285b8d27ca27ac82e637aee930879503b9d300260e3c3203fe969afe9c3d47f910da01", "5b24ccc5d942fd7878421ed1cc039ace"),
),
// Pseudorandom 3
(
    // (J,S)
    "a150329bf382e5c3b11619ac72ac3b2cdf55b19e94fd2f92bfca40ef540274ba571c53695d5d8f0d4d4935d2b599ee095754d3bbdd9929d60997eb4f745e0a48",
    // N
    "071652e3ea1b1d299ac07ab3df431090",
    // Output=((J',S'), N')
    ("d26102654babcd8c25abd540ee5f346e626eca9bad75a3772d7e11cb0317abb3e5d6f4f4f7486452bc93da79330bb037b7dad8289826e7f433bc1bcb6bc1e957", "e7a22b3d53409edb45ed442f5a3aeb81"),
),
// Pseudorandom 4
(
    // (J,S)
    "224dce00e26bdee463ac8b09cfda8d82a1e647f5f15ee3ed76c14ff92d57d01f2070c03304c5f08e0ddfae4690e8cf8ff52b07a739eb3b71c969d0bd5ed76567",
    // N
    "059945a49806db09e60fa6921759fc02",
    // Output=((J',S'), N')
    ("ba36136e165b2d326320de76fb8d155a6a5d7d963ddb436b0fa92f94ef66a474eb6823b8fcf033ba6e22e0efeb9d89996dcdbb8e8630dce6d255033e046dc5e1", "77c03a06cc01d081c7b98578bbc9a852"),
),
// Pseudorandom 5
(
    // (J,S)
    "ba31312925f0ea4813b7400649ca7789ce36f0c8718d7a8752f115c00735a0a3e50859cf07b4099fb75728ed7a766a70edcb272798abb191de1cb2a46f902c73",
    // N
    "018e3929ab803e9b6e5fb4bd9c1fc9e1",
    // Output=((J',S'), N')
    ("e851c25296c1f35f4bf6078285b957efa088d225df85a9adefadce94b081190aa2fe00ecd62027589b0fb33af543520628fef1b69a6e15725ca3ea17cbaefc5d", "18053e931749dd3a9ed7069124648b6a"),
),
// Pseudorandom 6
(
    // (J,S)
    "56fa9180e02b1d96fff07cb4502375e5c480fbd85f70650e13445b4f3c4228a671d1d3b4cf3582d8f33c9e1cbd0aa46fdbc41b5d24ed3e7f8ffd1f74daed66ec",
    // N
    "15073ad51ed0714a57318835edb35fb8",
    // Output=((J',S'), N')
    ("d7a5f05cf6500e2a9ea6400ddd4cbed8a00d2e3bb74e0a5097a02d6480b33249a4ee6528b3a2a70d4409192f27d9bb132cf13cbfcfd994abab510e0f97c1d0a6", "86a448a37b92be6d2e4eba84bc8f3819"),
),
// Pseudorandom 7
(
    // (J,S)
    "df4223c9f3190f08cbd9e531f8d14cdb3b056198819c3eed402376f55aeca2664969d9dcbffc98355dd52e11c38c1507cf35600ba151008c34842b245540db6e",
    // N
    "7c965af0577c48c6d3b65ef56f99f8f2",
    // Output=((J',S'), N')
    ("4438c11facc50013bd52f53858fc5b7dfdabe6169806a583b372a344518a97e3106d136b8f3ac7d3e41eab03eb5730c334183f9cc555a587af0bfbfd1ea67bd1", "bb7751edce82fa0392a5879f870c86bb"),
),
// Pseudorandom 8
(
    // (J,S)
    "602a99f4000ea3fc0488c7677df13014aac62ff3b6f7b6e2b5c7e72a742d488817bcd049f0e019fd191646841ab3f110e72b05c619c8258b746acb675b1fdd91",
    // N
    "690b56403667d406a41f73c179949b1d",
    // Output=((J',S'), N')
    ("c7562979d89419edd9f098617f3b94b468e514a781ca63244e2a857e61ea32db26a89093a902625825de51e57bbc72c1a3d9281e311846557ac19f2aaf5d9002", "c31a132271102df187b2de318e44d7f0"),
),
];
