;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt -all             %s -S -o - | filecheck %s

;; RUN: wasm-opt -all --roundtrip %s -S -o - | filecheck %s --check-prefix=RTRIP

(module
  ;; CHECK:      (type $func (func))
  ;; RTRIP:      (type $func (func))
  (type $func (func))

  ;; CHECK:      (table $table 10 20 funcref)
  ;; RTRIP:      (table $table 10 20 funcref)
  (table $table 10 20 funcref)

  ;; CHECK:      (elem declare func $func)

  ;; CHECK:      (func $func (type $func)
  ;; CHECK-NEXT:  (@metadata.code.inline "\00")
  ;; CHECK-NEXT:  (call $func)
  ;; CHECK-NEXT:  (@metadata.code.inline "\01")
  ;; CHECK-NEXT:  (call $func)
  ;; CHECK-NEXT:  (@metadata.code.inline "\7e")
  ;; CHECK-NEXT:  (call $func)
  ;; CHECK-NEXT:  (@metadata.code.inline "\7f")
  ;; CHECK-NEXT:  (call $func)
  ;; CHECK-NEXT:  (call $func)
  ;; CHECK-NEXT: )
  ;; RTRIP:      (elem declare func $func)

  ;; RTRIP:      (func $func (type $func)
  ;; RTRIP-NEXT:  (@metadata.code.inline "\00")
  ;; RTRIP-NEXT:  (call $func)
  ;; RTRIP-NEXT:  (@metadata.code.inline "\01")
  ;; RTRIP-NEXT:  (call $func)
  ;; RTRIP-NEXT:  (@metadata.code.inline "\7e")
  ;; RTRIP-NEXT:  (call $func)
  ;; RTRIP-NEXT:  (@metadata.code.inline "\7f")
  ;; RTRIP-NEXT:  (call $func)
  ;; RTRIP-NEXT:  (call $func)
  ;; RTRIP-NEXT: )
  (func $func
    (@metadata.code.inline "\00")
    (call $func)
    (@metadata.code.inline "\01")
    (call $func)
    (@metadata.code.inline "\7e")
    (call $func)
    (@metadata.code.inline "\7f")
    (call $func)
    ;; Unannotated
    (call $func)
  )

  ;; CHECK:      (func $other-calls (type $func)
  ;; CHECK-NEXT:  (@metadata.code.inline "\12")
  ;; CHECK-NEXT:  (call_indirect $table (type $func)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (@metadata.code.inline "\34")
  ;; CHECK-NEXT:  (call_ref $func
  ;; CHECK-NEXT:   (ref.func $func)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $other-calls (type $func)
  ;; RTRIP-NEXT:  (@metadata.code.inline "\12")
  ;; RTRIP-NEXT:  (call_indirect $table (type $func)
  ;; RTRIP-NEXT:   (i32.const 0)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT:  (@metadata.code.inline "\34")
  ;; RTRIP-NEXT:  (call_ref $func
  ;; RTRIP-NEXT:   (ref.func $func)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT: )
  (func $other-calls
    (@metadata.code.inline "\12")
    (call_indirect (type $func)
      (i32.const 0)
    )
    (@metadata.code.inline "\34")
    (call_ref $func
      (ref.func $func)
    )
  )

  ;; TODO: test function annotations, after
  ;; https://github.com/WebAssembly/tool-conventions/issues/251
)
