/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.IOException;
import java.util.Arrays;
import org.basex.build.BuildException;
import org.basex.build.BuildText;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.jobs.Job;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.XMLInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenObjectMap;

final class XMLScanner
extends Job {
    private static final byte[][] ENTITIES = Token.tokens("amp", "&", "apos", "'", "quot", "\"", "lt", "<", "gt", ">");
    private static final byte[] PUBIDTOK = Token.token(" \n'()+,/=?;!*#@$%");
    final TokenBuilder token = new TokenBuilder();
    BuildText.Type type;
    private final TokenObjectMap<byte[]> ents = new TokenObjectMap();
    private final TokenObjectMap<byte[]> pents = new TokenObjectMap();
    private final boolean dtd;
    private final boolean fragment;
    private Scan scan = Scan.CONTENT;
    private boolean prolog = true;
    private boolean pe;
    private boolean text = true;
    private int quote;
    private XMLInput input;

    XMLScanner(IO file, MainOptions opts, boolean fragment) throws IOException {
        this.fragment = fragment;
        this.input = new XMLInput(file);
        try {
            int n;
            int el = ENTITIES.length;
            for (int e = 0; e < el; e += 2) {
                this.ents.put(ENTITIES[e], ENTITIES[e + 1]);
            }
            this.dtd = opts.get(MainOptions.DTD);
            if (this.consume(BuildText.DOCDECL)) {
                if (this.s()) {
                    if (!this.version()) {
                        throw this.error("Document declaration must start with 'version'.", new Object[0]);
                    }
                    boolean s = this.s();
                    String encoding = this.encoding();
                    if (encoding != null) {
                        if (!s) {
                            throw this.error("Missing Whitespace.", new Object[0]);
                        }
                        s = this.s();
                    }
                    if (this.sddecl() != null && !s) {
                        throw this.error("Missing Whitespace.", new Object[0]);
                    }
                    this.s();
                    int ch = this.nextChar();
                    if (ch != 63) {
                        throw this.error("'%' expected, '%' found.", Character.valueOf('?'), Character.valueOf((char)ch));
                    }
                    ch = this.nextChar();
                    if (ch != 62) {
                        throw this.error("'%' expected, '%' found.", Character.valueOf('>'), Character.valueOf((char)ch));
                    }
                } else {
                    this.prev(5);
                }
            }
            if (!fragment && !this.s(n = this.consume())) {
                if (n != 60) {
                    throw this.error(n == 0 ? "No input found." : "No text allowed before root element.", new Object[0]);
                }
                this.prev(1);
            }
        }
        catch (IOException ex) {
            this.input.close();
            throw ex;
        }
    }

    boolean more() throws IOException {
        this.token.reset();
        int ch = this.consume();
        if (ch == 0) {
            this.type = BuildText.Type.EOF;
            return false;
        }
        switch (this.scan) {
            case CONTENT: {
                this.scanCONTENT(ch);
                break;
            }
            case ELEMENT: 
            case ATT: {
                this.scanELEMENT(ch);
                break;
            }
            case QUOTE: {
                this.scanATTVALUE(ch);
            }
        }
        return true;
    }

    void close() throws IOException {
        this.input.close();
        if (!this.fragment && this.prolog) {
            throw this.error("No input found.", new Object[0]);
        }
    }

    private void scanCONTENT(int ch) throws IOException {
        if (this.text && (ch != 60 || this.isCDATA())) {
            this.content(ch);
            return;
        }
        this.text = true;
        int c = this.nextChar();
        if (c == 33) {
            if (this.consume('-') && this.consume('-')) {
                this.type = BuildText.Type.COMMENT;
                this.comment();
            } else if (!this.fragment && this.consume(BuildText.DOCTYPE)) {
                this.type = BuildText.Type.DTD;
                this.dtd();
            } else {
                throw this.error("Comment or doctype declaration expected after '<!'.", new Object[0]);
            }
            return;
        }
        if (c == 63) {
            this.type = BuildText.Type.PI;
            this.pi();
            return;
        }
        this.prolog = false;
        this.scan = Scan.ELEMENT;
        if (c == 47) {
            this.type = BuildText.Type.L_BR_CLOSE;
            return;
        }
        this.type = BuildText.Type.L_BR;
        this.prev(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scanELEMENT(int ch) throws IOException {
        int c = ch;
        if (c == 62) {
            this.type = BuildText.Type.R_BR;
            this.scan = Scan.CONTENT;
            return;
        }
        if (c == 61) {
            this.type = BuildText.Type.EQ;
            return;
        }
        if (c == 39 || c == 34) {
            this.type = BuildText.Type.QUOTE;
            this.scan = Scan.QUOTE;
            this.quote = c;
            return;
        }
        if (c == 47) {
            this.type = BuildText.Type.CLOSE_R_BR;
            c = this.nextChar();
            if (c == 62) {
                this.scan = Scan.CONTENT;
                return;
            }
            this.token.add(c);
            throw this.error("Element was not properly closed.", new Object[0]);
        }
        if (this.s(c)) {
            this.type = BuildText.Type.WS;
            return;
        }
        if (!XMLToken.isStartChar(c)) {
            throw this.error("Invalid character found: '%'", Character.valueOf((char)c));
        }
        this.type = this.scan == Scan.ATT ? BuildText.Type.ATTNAME : BuildText.Type.ELEMNAME;
        do {
            this.token.add(c);
        } while (XMLToken.isChar(c = this.nextChar()));
        this.prev(1);
        this.scan = Scan.ATT;
    }

    private void scanATTVALUE(int ch) throws IOException {
        if (ch == this.quote) {
            this.type = BuildText.Type.QUOTE;
            this.scan = Scan.ATT;
        } else {
            this.type = BuildText.Type.ATTVALUE;
            this.attValue(ch);
            this.prev(1);
        }
    }

    private void attValue(int ch) throws IOException {
        boolean wrong = false;
        int c = ch;
        do {
            if (c == 0) {
                throw this.error("Attribute value was not properly closed.", Character.valueOf('\u0000'));
            }
            wrong |= c == 39 || c == 34;
            if (c == 60) {
                throw this.error(wrong ? "Attribute value was not properly closed." : "Invalid character '%' in attribute value.", Character.valueOf('<'));
            }
            if (c == 10) {
                c = 32;
            }
            if (c == 38) {
                byte[] r = this.ref(true);
                if (r.length == 1) {
                    this.token.add(r);
                    continue;
                }
                if (this.input.add(r, false)) continue;
                throw this.error("Entities: expansion limit exceeded or recursive definitions found.", new Object[0]);
            }
            this.token.add(c);
        } while ((c = this.consume()) != this.quote);
    }

    private void content(int ch) throws IOException {
        this.type = BuildText.Type.TEXT;
        boolean f = true;
        int c = ch;
        while (c != 0) {
            if (c == 60) {
                if (!f && !this.isCDATA()) {
                    this.text = false;
                    this.prev(1);
                    return;
                }
                this.cDATA();
            } else if (c == 38) {
                byte[] r = this.ref(true);
                if (r.length == 1) {
                    this.token.add(r);
                } else if (!this.input.add(r, false)) {
                    throw this.error("Entities: expansion limit exceeded or recursive definitions found.", new Object[0]);
                }
            } else {
                if (c == 93) {
                    if (this.consume() == 93) {
                        if (this.consume() == 62) {
                            throw this.error("']]>' not allowed in content.", new Object[0]);
                        }
                        this.prev(1);
                    }
                    this.prev(1);
                }
                this.token.add(c);
            }
            c = this.consume();
            f = false;
        }
        if (!this.fragment) {
            if (!Token.ws(this.token.toArray())) {
                throw this.error("No text allowed after closed root element.", new Object[0]);
            }
            this.type = BuildText.Type.EOF;
        }
    }

    private boolean isCDATA() throws IOException {
        if (!this.consume('!')) {
            return false;
        }
        if (!this.consume('[')) {
            this.prev(1);
            return false;
        }
        if (!this.consume(BuildText.CDATA)) {
            throw this.error("Invalid CDATA section.", new Object[0]);
        }
        return true;
    }

    private void cDATA() throws IOException {
        while (true) {
            int ch;
            if ((ch = this.nextChar()) != 93) {
                this.token.add(ch);
                continue;
            }
            if (this.consume(']')) {
                if (this.consume('>')) {
                    return;
                }
                this.prev(1);
            }
            this.token.add(ch);
        }
    }

    private void comment() throws IOException {
        while (true) {
            int ch;
            if ((ch = this.nextChar()) == 45 && this.consume('-')) {
                this.check('>');
                return;
            }
            this.token.add(ch);
        }
    }

    private void pi() throws IOException {
        byte[] tok = this.name(true);
        if (Token.eq(Token.lc(tok), Token.XML)) {
            throw this.error("'<?xml' is reserved for document declaration.", new Object[0]);
        }
        this.token.add(tok);
        int ch = this.nextChar();
        if (ch != 63 && !Token.ws(ch)) {
            throw this.error("Invalid processing instruction.", new Object[0]);
        }
        while (true) {
            if (ch != 63) {
                this.token.add(ch);
                ch = this.nextChar();
                continue;
            }
            ch = this.consume();
            if (ch == 62) {
                return;
            }
            this.token.add(63);
        }
    }

    private boolean s() throws IOException {
        int ch = this.consume();
        if (this.s(ch)) {
            return true;
        }
        this.prev(1);
        return false;
    }

    private void checkS() throws IOException {
        if (!this.s()) {
            throw this.error("Whitespace expected, '%' found.", Character.valueOf((char)this.consume()));
        }
    }

    private void check(char ch) throws IOException {
        int c = this.consume();
        if (c != ch) {
            throw this.error("'%' expected, '%' found.", Character.valueOf(ch), Character.valueOf((char)c));
        }
    }

    private void check(byte[] t) throws IOException {
        if (!this.consume(t)) {
            throw this.error("'%' expected, '%' found.", t, Character.valueOf((char)this.consume()));
        }
    }

    private boolean s(int ch) throws IOException {
        int c = ch;
        if (Token.ws(c)) {
            while (Token.ws(c = this.consume())) {
            }
            this.prev(1);
            return true;
        }
        return false;
    }

    private int qu() throws IOException {
        int qu = this.consume();
        if (qu != 39 && qu != 34) {
            throw this.error("Quote expected, '%' found.", Character.valueOf((char)qu));
        }
        return qu;
    }

    private byte[] ref(boolean e) throws IOException {
        if (this.consume('#')) {
            TokenBuilder ent = new TokenBuilder();
            int ch = this.nextChar();
            ent.add(ch);
            int b = 10;
            if (ch == 120) {
                b = 16;
                ch = this.nextChar();
                ent.add(ch);
            }
            int n = 0;
            do {
                boolean h;
                boolean m = ch >= 48 && ch <= 57;
                boolean bl = h = b == 16 && (ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70);
                if (!m && !h) {
                    this.completeRef(ent);
                    return Token.cpToken(63);
                }
                n *= b;
                n += ch & 0xF;
                if (!m) {
                    n += 9;
                }
                ch = this.nextChar();
                ent.add(ch);
            } while (ch != 59);
            if (!XMLToken.valid(n)) {
                return Token.cpToken(63);
            }
            ent.reset();
            ent.add(n);
            return ent.finish();
        }
        byte[] name = this.name(false);
        if (!this.consume(';')) {
            return Token.cpToken(63);
        }
        if (!e) {
            return Token.concat(Token.cpToken(38), name, BuildText.SEMI);
        }
        byte[] en = this.ents.get(name);
        if (en == null) {
            en = XMLToken.getEntity(name);
        }
        return en == null ? Token.cpToken(63) : en;
    }

    private byte[] peRef() throws IOException {
        byte[] name = this.name(true);
        this.consume(';');
        byte[] en = this.pents.get(name);
        return en == null ? name : en;
    }

    private void completeRef(TokenBuilder ent) throws IOException {
        int ch = this.consume();
        while (ent.size() < 10 && ch >= 32 && ch != 59) {
            ent.add(ch);
            ch = this.consume();
        }
    }

    private int nextChar() throws IOException {
        int ch = this.consume();
        if (ch == 0) {
            throw this.error("Unclosed tokens found.", this.token);
        }
        return ch;
    }

    private void prev(int num) {
        this.input.prev(num);
    }

    private int consume() throws IOException {
        int ch;
        block3: {
            byte[] val;
            do {
                if ((ch = this.input.read()) == -1) {
                    return 0;
                }
                if (ch != 37 || !this.pe) break block3;
                byte[] key = this.name(true);
                val = this.pents.get(key);
                if (val == null) {
                    throw this.error("Unknown parameter reference '%'.", new Object[]{key});
                }
                this.check(';');
            } while (this.input.add(val, true));
            throw this.error("Entities: expansion limit exceeded or recursive definitions found.", new Object[0]);
        }
        return ch;
    }

    private boolean consume(char ch) throws IOException {
        if (this.consume() == ch) {
            return true;
        }
        this.prev(1);
        return false;
    }

    private boolean consume(byte[] tok) throws IOException {
        int tl = tok.length;
        for (int t = 0; t < tl; ++t) {
            int ch = this.consume();
            if (ch == tok[t]) continue;
            this.prev(t + 1);
            return false;
        }
        return true;
    }

    private byte[] name(boolean enforce) throws IOException {
        TokenBuilder name = new TokenBuilder();
        int c = this.consume();
        if (!XMLToken.isStartChar(c)) {
            if (enforce) {
                throw this.error("Invalid name.", new Object[0]);
            }
            this.prev(1);
            return null;
        }
        do {
            name.add(c);
        } while (XMLToken.isChar(c = this.nextChar()));
        this.prev(1);
        return name.finish();
    }

    private void nmtoken() throws IOException {
        int c;
        TokenBuilder name = new TokenBuilder();
        while (XMLToken.isChar(c = this.nextChar())) {
            name.add(c);
        }
        this.prev(1);
        if (name.isEmpty()) {
            throw this.error("Invalid name.", new Object[0]);
        }
    }

    private void dtd() throws IOException {
        if (!this.prolog) {
            throw this.error("Misplaced document type definition.", new Object[0]);
        }
        if (!this.s()) {
            throw this.error("Error in DTD.", new Object[0]);
        }
        this.name(true);
        this.s();
        this.externalID(true, true);
        this.s();
        while (this.consume('[')) {
            this.s();
            while (this.markupDecl()) {
            }
            this.s();
            this.check(']');
            this.s();
        }
        this.check('>');
    }

    private byte[] externalID(boolean full, boolean root) throws IOException {
        byte[] content = null;
        boolean pub = this.consume(BuildText.PUBLIC);
        if (pub || this.consume(BuildText.SYSTEM)) {
            int qu;
            this.checkS();
            if (pub) {
                this.pubidLit();
                if (full) {
                    this.checkS();
                }
            }
            if ((qu = this.consume()) == 39 || qu == 34) {
                int ch;
                TokenBuilder tok = new TokenBuilder();
                while ((ch = this.nextChar()) != qu) {
                    tok.add(ch);
                }
                if (!full) {
                    return null;
                }
                String name = Token.string(tok.finish());
                if (!this.dtd && root) {
                    return null;
                }
                XMLInput tin = this.input;
                if (this.dtd) {
                    try {
                        content = this.input.io().merge(name).read();
                    }
                    catch (IOException ex) {
                        throw this.error(Util.message(ex), new Object[0]);
                    }
                } else {
                    content = new byte[]{};
                }
                this.input = new XMLInput(new IOContent(content, name));
                if (this.consume(BuildText.XDECL)) {
                    this.check(Token.XML);
                    this.s();
                    if (this.version()) {
                        this.checkS();
                    }
                    this.s();
                    if (this.encoding() == null) {
                        throw this.error("Encoding expected in text declaration.", new Object[0]);
                    }
                    ch = this.nextChar();
                    if (this.s(ch)) {
                        ch = this.nextChar();
                    }
                    if (ch != 63) {
                        throw this.error("'%' expected, '%' found.", Character.valueOf('?'), ch);
                    }
                    ch = this.nextChar();
                    if (ch != 62) {
                        throw this.error("'%' expected, '%' found.", Character.valueOf('>'), ch);
                    }
                    content = Arrays.copyOfRange(content, (int)this.input.pos(), content.length);
                }
                this.s();
                if (root) {
                    this.extSubsetDecl();
                    if (!this.consume('\u0000')) {
                        throw this.error("Unexpected end.", new Object[0]);
                    }
                }
                this.input = tin;
            } else {
                if (full) {
                    throw this.error("Quote expected, '%' found.", Character.valueOf((char)qu));
                }
                this.prev(1);
            }
        }
        return content;
    }

    private void pubidLit() throws IOException {
        int ch;
        int qu = this.qu();
        while ((ch = this.nextChar()) != qu) {
            if (XMLToken.isChar(ch) || Token.contains(PUBIDTOK, ch)) continue;
            throw this.error("Invalid character '%' in public identifier.", Character.valueOf((char)ch));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void extSubsetDecl() throws IOException {
        block0: while (true) {
            this.s();
            if (this.markupDecl()) continue;
            if (!this.consume(BuildText.COND)) {
                return;
            }
            this.s();
            incl = this.consume(BuildText.INCL);
            if (!incl) {
                this.check(BuildText.IGNO);
            }
            this.s();
            this.check('[');
            if (incl) {
                this.extSubsetDecl();
                this.check(BuildText.CONE);
                continue;
            }
            c = 1;
            while (true) {
                if (c != 0) ** break;
                continue block0;
                if (this.consume(BuildText.COND)) {
                    ++c;
                    continue;
                }
                if (this.consume(BuildText.CONE)) {
                    --c;
                    continue;
                }
                if (this.consume() == 0) break block0;
            }
            break;
        }
        throw this.error("Unexpected end.", new Object[0]);
    }

    private boolean markupDecl() throws IOException {
        if (this.consume(BuildText.ENT)) {
            this.checkS();
            if (this.consume('%')) {
                this.checkS();
                byte[] key = this.name(true);
                this.checkS();
                byte[] val = this.entityValue(true);
                if (val == null && (val = this.externalID(true, false)) == null) {
                    throw this.error("Unexpected end.", new Object[0]);
                }
                this.s();
                this.pents.put(key, val);
            } else {
                byte[] key = this.name(true);
                this.checkS();
                byte[] val = this.entityValue(false);
                if (val == null) {
                    val = this.externalID(true, false);
                    if (val == null) {
                        throw this.error("Unexpected end.", new Object[0]);
                    }
                    if (this.s()) {
                        this.check(BuildText.ND);
                        this.checkS();
                        this.name(true);
                    }
                }
                this.s();
                this.ents.put(key, val);
            }
            this.check('>');
            this.pe = true;
        } else if (this.consume(BuildText.ELEM)) {
            this.checkS();
            this.name(true);
            this.checkS();
            this.pe = true;
            if (!this.consume(BuildText.EMP) && !this.consume(BuildText.ANY)) {
                if (this.consume('(')) {
                    this.s();
                    if (this.consume(BuildText.PC)) {
                        this.s();
                        boolean alt = false;
                        while (this.consume('|')) {
                            this.s();
                            this.name(true);
                            this.s();
                            alt = true;
                        }
                        this.check(')');
                        if (!this.consume('*') && alt) {
                            throw this.error("Unexpected end.", new Object[0]);
                        }
                    } else {
                        this.cp();
                        this.s();
                        while (!this.consume(')')) {
                            this.consume();
                        }
                        this.occ();
                    }
                } else {
                    throw this.error("Unexpected end.", new Object[0]);
                }
            }
            this.s();
            this.check('>');
        } else if (this.consume(BuildText.ATTL)) {
            this.pe = true;
            this.checkS();
            this.name(true);
            this.s();
            while (this.name(false) != null) {
                this.checkS();
                if (!(this.consume(BuildText.CD) || this.consume(BuildText.IDRS) || this.consume(BuildText.IDR) || this.consume(BuildText.ID) || this.consume(BuildText.ENTS) || this.consume(BuildText.ENT1) || this.consume(BuildText.NMTS) || this.consume(BuildText.NMT))) {
                    if (this.consume(BuildText.NOT)) {
                        this.checkS();
                        this.check('(');
                        do {
                            this.s();
                            this.name(true);
                            this.s();
                        } while (this.consume('|'));
                    } else {
                        this.check('(');
                        do {
                            this.s();
                            this.nmtoken();
                            this.s();
                        } while (this.consume('|'));
                    }
                    this.check(')');
                }
                this.pe = true;
                this.checkS();
                if (!this.consume(BuildText.REQ) && !this.consume(BuildText.IMP)) {
                    if (this.consume(BuildText.FIX)) {
                        this.checkS();
                    }
                    this.quote = this.qu();
                    this.attValue(this.consume());
                }
                this.s();
            }
            this.check('>');
        } else if (this.consume(BuildText.NOTA)) {
            this.checkS();
            this.name(true);
            this.s();
            this.externalID(false, false);
            this.s();
            this.check('>');
        } else if (this.consume(BuildText.COMS)) {
            this.comment();
        } else if (this.consume(Token.XML)) {
            this.pi();
        } else {
            return false;
        }
        this.s();
        this.pe = false;
        return true;
    }

    private void cp() throws IOException {
        this.s();
        byte[] name = this.name(false);
        if (name == null) {
            this.check('(');
            this.s();
            this.cp();
        } else {
            this.occ();
        }
        this.s();
        if (this.consume('|') || this.consume(',')) {
            this.cp();
            this.s();
        }
        if (name == null) {
            this.check(')');
            this.occ();
        }
    }

    private void occ() throws IOException {
        if (!this.consume('+') && !this.consume('?')) {
            this.consume('*');
        }
    }

    private byte[] entityValue(boolean p) throws IOException {
        int ch;
        int qu = this.consume();
        if (qu != 39 && qu != 34) {
            this.prev(1);
            return null;
        }
        TokenBuilder tok = new TokenBuilder();
        while ((ch = this.nextChar()) != qu) {
            if (ch == 38) {
                tok.add(this.ref(false));
                continue;
            }
            if (ch == 37) {
                if (!p) {
                    throw this.error("Parameter reference not allowed here.", new Object[0]);
                }
                tok.add(this.peRef());
                continue;
            }
            tok.add(ch);
        }
        XMLInput tmp = this.input;
        this.input = new XMLInput(new IOContent(tok.finish()));
        tok = new TokenBuilder();
        while ((ch = this.consume()) != 0) {
            if (ch == 38) {
                tok.add(this.ref(false));
                continue;
            }
            tok.add(ch);
        }
        this.input = tmp;
        return tok.finish();
    }

    private boolean version() throws IOException {
        if (!this.consume(BuildText.VERS)) {
            return false;
        }
        this.s();
        this.check('=');
        this.s();
        int d = this.qu();
        if (!this.consume(BuildText.VERS10) && !this.consume(BuildText.VERS11)) {
            throw this.error("XML version must be '1.0' or '1.1'.", new Object[0]);
        }
        this.check((char)d);
        return true;
    }

    private String encoding() throws IOException {
        if (!this.consume(BuildText.ENCOD)) {
            if (this.fragment) {
                throw this.error("Encoding expected in text declaration.", new Object[0]);
            }
            return null;
        }
        this.s();
        this.check('=');
        this.s();
        TokenBuilder tb = new TokenBuilder();
        int d = this.qu();
        int ch = this.nextChar();
        if (Token.letter(ch) && ch != 95) {
            while (Token.letterOrDigit(ch) || ch == 46 || ch == 45) {
                tb.add(ch);
                ch = this.nextChar();
            }
            this.prev(1);
        }
        this.check((char)d);
        if (tb.isEmpty()) {
            throw this.error("Invalid encoding.", tb);
        }
        String e = Token.string(tb.finish());
        this.input.encoding(e);
        return e;
    }

    private byte[] sddecl() throws IOException {
        if (!this.consume(BuildText.STANDALONE)) {
            return null;
        }
        this.s();
        this.check('=');
        this.s();
        int d = this.qu();
        byte[] sd = Token.token("no");
        if (!this.consume(sd) && !this.consume(sd = Token.token("yes"))) {
            sd = null;
        }
        this.check((char)d);
        if (sd == null || this.fragment) {
            throw this.error("Invalid standalone attribute in declaration.", new Object[0]);
        }
        return sd;
    }

    private BuildException error(String message, Object ... ext) {
        return new BuildException(this.detailedInfo() + ": " + message, ext);
    }

    @Override
    public String detailedInfo() {
        String path = this.input.io().path();
        return path.isEmpty() ? Util.info(Text.LINE_X, this.input.line()) : Util.info(Text.SCANPOS_X_X, this.input.io().path(), this.input.line());
    }

    @Override
    public double progressInfo() {
        double l = this.input.length();
        return l <= 0.0 ? 0.0 : (double)this.input.pos() / l;
    }

    private static enum Scan {
        CONTENT,
        ELEMENT,
        ATT,
        QUOTE;

    }
}

