/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.csv;

import org.basex.build.csv.CsvOptions;
import org.basex.build.csv.CsvParserOptions;
import org.basex.build.csv.CsvW3ArraysOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.NumbersOption;
import org.basex.util.options.ValueOption;

public final class CsvW3Options
extends CsvW3ArraysOptions {
    public static final ValueOption HEADER = new ValueOption("header", Types.ITEM_ZM, Bln.FALSE);
    public static final NumbersOption SELECT_COLUMNS = new NumbersOption("select-columns", new int[0]);
    public static final BooleanOption TRIM_ROWS = new BooleanOption("trim-rows", false);

    @Override
    public CsvParserOptions finish(InputInfo ii, CsvOptions.CsvFormat format) throws QueryException {
        Value header = this.get(HEADER);
        if (!Types.BOOLEAN_O.instance(header) && !Types.STRING_ZM.instance(header)) {
            throw QueryError.typeError(header, AtomType.STRING, ii);
        }
        CsvParserOptions copts = super.finish(ii, format);
        copts.set(CsvOptions.TRIM_ROWS, this.get(TRIM_ROWS));
        copts.set(CsvOptions.SELECT_COLUMNS, this.get(SELECT_COLUMNS));
        copts.set(CsvOptions.HEADER, this.get(HEADER));
        return copts;
    }
}

