/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.ws;

import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.http.web.WebFunction;
import org.basex.http.web.WebModule;
import org.basex.http.ws.WsPath;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.func.StaticFunc;
import org.basex.query.util.list.AnnList;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class WsFunction
extends WebFunction {
    public WsPath path;
    private WebFunction.WebParam message;

    public WsFunction(StaticFunc function, WebModule module, QueryContext qc) {
        super(function, module, qc);
    }

    @Override
    public boolean parseAnnotations(MainOptions mopts) throws QueryException {
        boolean[] declared = new boolean[this.function.arity()];
        boolean found = false;
        AnnList starts = AnnList.EMPTY;
        for (Ann ann : this.function.anns) {
            Annotation def = ann.definition;
            if (def == null || !Token.eq((byte[])def.name.uri(), (byte[])QueryText.WS_URI)) continue;
            found = true;
            Value value = ann.value();
            switch (def) {
                case _WS_HEADER_PARAM: {
                    String name = WsFunction.toString(value.itemAt(0L));
                    QNm var = this.checkVariable(WsFunction.toString(value.itemAt(1L)), declared);
                    long vs = value.size();
                    ItemList items = new ItemList(vs - 2L);
                    int v = 2;
                    while ((long)v < vs) {
                        items.add((Object)value.itemAt((long)v));
                        ++v;
                    }
                    this.headerParams.add(new WebFunction.WebParam(var, name, items.value()));
                    break;
                }
                case _WS_CLOSE: 
                case _WS_CONNECT: {
                    this.path = new WsPath(WsFunction.toString(value.itemAt(0L)));
                    starts = starts.attach(ann);
                    break;
                }
                case _WS_ERROR: 
                case _WS_MESSAGE: {
                    QNm msg = this.checkVariable(WsFunction.toString(value.itemAt(1L)), declared);
                    this.message = new WebFunction.WebParam(msg, "message", null);
                    this.path = new WsPath(WsFunction.toString(value.itemAt(0L)));
                    starts = starts.attach(ann);
                    break;
                }
            }
        }
        return this.checkParsed(found, starts, declared);
    }

    Expr[] bind(Object msg, Map<String, Value> values, QueryContext qc) throws QueryException {
        Expr[] args = new Expr[this.function.arity()];
        if (msg != null) {
            Str str;
            if (msg instanceof byte[]) {
                byte[] bytes = (byte[])msg;
                str = B64.get((byte[])bytes);
            } else {
                str = Str.get((String)((String)msg));
            }
            values.put("message", (Value)str);
        }
        for (WebFunction.WebParam param : this.headerParams) {
            this.bind(param.var(), args, values.get(param.name()), qc, "Value of '" + param.name() + "'");
        }
        if (this.message != null) {
            this.bind(this.message.var(), args, values.get(this.message.name()), qc, "Message");
        }
        return args;
    }

    public boolean matches(Annotation definition, WsPath pth) {
        for (Ann ann : this.function.anns) {
            if (definition != null && ann.definition != definition || pth != null && this.path.compareTo(pth) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(WebFunction func) {
        int n;
        if (func instanceof WsFunction) {
            WsFunction ws = (WsFunction)func;
            n = this.path.compareTo(ws.path);
        } else {
            n = 1;
        }
        return n;
    }

    @Override
    public QueryException error(String msg, Object ... ext) {
        return WsFunction.error(this.function.info, msg, ext);
    }

    private static QueryException error(InputInfo info, String msg, Object ... ext) {
        return QueryError.BASEX_WS_X.get(info, new Object[]{Util.info((Object)msg, (Object[])ext)});
    }
}

