/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.asciidoctor.extension.BlockMacroProcessor;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.DocinfoProcessor;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.InlineMacroProcessor;
import org.asciidoctor.extension.JavaExtensionRegistry;
import org.asciidoctor.extension.Name;
import org.asciidoctor.extension.Postprocessor;
import org.asciidoctor.extension.Preprocessor;
import org.asciidoctor.extension.Treeprocessor;
import org.asciidoctor.jruby.extension.processorproxies.BlockMacroProcessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.BlockProcessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.DocinfoProcessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.IncludeProcessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.InlineMacroProcessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.PostprocessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.PreprocessorProxy;
import org.asciidoctor.jruby.extension.processorproxies.TreeprocessorProxy;
import org.asciidoctor.jruby.internal.JRubyAsciidoctor;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaExtensionRegistryImpl
implements JavaExtensionRegistry {
    private final JRubyAsciidoctor asciidoctor;
    private Ruby rubyRuntime;

    public JavaExtensionRegistryImpl(JRubyAsciidoctor asciidoctor) {
        this.rubyRuntime = asciidoctor.getRubyRuntime();
        this.asciidoctor = asciidoctor;
    }

    public JavaExtensionRegistry docinfoProcessor(Class<? extends DocinfoProcessor> docInfoProcessor) {
        RubyClass rubyClass = DocinfoProcessorProxy.register(this.asciidoctor, docInfoProcessor);
        this.getAsciidoctorModule().callMethod("docinfo_processor", (IRubyObject)rubyClass);
        return this;
    }

    public JavaExtensionRegistry docinfoProcessor(DocinfoProcessor docInfoProcessor) {
        RubyClass rubyClass = DocinfoProcessorProxy.register(this.asciidoctor, docInfoProcessor);
        this.getAsciidoctorModule().callMethod("docinfo_processor", (IRubyObject)rubyClass);
        return this;
    }

    public JavaExtensionRegistry docinfoProcessor(String docInfoProcessor) {
        try {
            Class<?> docinfoProcessorClass = Class.forName(docInfoProcessor);
            this.docinfoProcessor(docinfoProcessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public JavaExtensionRegistry preprocessor(Class<? extends Preprocessor> preprocessor) {
        RubyClass rubyClass = PreprocessorProxy.register(this.asciidoctor, preprocessor);
        this.getAsciidoctorModule().callMethod("preprocessor", (IRubyObject)rubyClass);
        return this;
    }

    public JavaExtensionRegistry preprocessor(Preprocessor preprocessor) {
        RubyClass rubyClass = PreprocessorProxy.register(this.asciidoctor, preprocessor);
        this.getAsciidoctorModule().callMethod("preprocessor", (IRubyObject)rubyClass);
        return this;
    }

    public JavaExtensionRegistry preprocessor(String preprocessor) {
        try {
            Class<?> preprocessorClass = Class.forName(preprocessor);
            this.preprocessor(preprocessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public JavaExtensionRegistry postprocessor(String postprocessor) {
        try {
            Class<?> postprocessorClass = Class.forName(postprocessor);
            this.postprocessor(postprocessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public JavaExtensionRegistry postprocessor(Class<? extends Postprocessor> postprocessor) {
        RubyClass rubyClass = PostprocessorProxy.register(this.asciidoctor, postprocessor);
        this.getAsciidoctorModule().callMethod("postprocessor", (IRubyObject)rubyClass);
        return this;
    }

    public JavaExtensionRegistry postprocessor(Postprocessor postprocessor) {
        RubyClass rubyClass = PostprocessorProxy.register(this.asciidoctor, postprocessor);
        this.getAsciidoctorModule().callMethod("postprocessor", (IRubyObject)rubyClass);
        return this;
    }

    public JavaExtensionRegistry includeProcessor(String includeProcessor) {
        try {
            Class<?> includeProcessorClass = Class.forName(includeProcessor);
            this.includeProcessor(includeProcessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public JavaExtensionRegistry includeProcessor(Class<? extends IncludeProcessor> includeProcessor) {
        RubyClass rubyClass = IncludeProcessorProxy.register(this.asciidoctor, includeProcessor);
        this.getAsciidoctorModule().callMethod("include_processor", (IRubyObject)rubyClass);
        return this;
    }

    public JavaExtensionRegistry includeProcessor(IncludeProcessor includeProcessor) {
        RubyClass rubyClass = IncludeProcessorProxy.register(this.asciidoctor, includeProcessor);
        this.getAsciidoctorModule().callMethod("include_processor", (IRubyObject)rubyClass);
        return this;
    }

    public JavaExtensionRegistry treeprocessor(Treeprocessor treeprocessor) {
        RubyClass rubyClass = TreeprocessorProxy.register(this.asciidoctor, treeprocessor);
        this.getAsciidoctorModule().callMethod("treeprocessor", (IRubyObject)rubyClass);
        return this;
    }

    public JavaExtensionRegistry treeprocessor(Class<? extends Treeprocessor> abstractTreeProcessor) {
        RubyClass rubyClass = TreeprocessorProxy.register(this.asciidoctor, abstractTreeProcessor);
        this.getAsciidoctorModule().callMethod("treeprocessor", (IRubyObject)rubyClass);
        return this;
    }

    public JavaExtensionRegistry treeprocessor(String treeProcessor) {
        try {
            Class<?> treeProcessorClass = Class.forName(treeProcessor);
            this.treeprocessor(treeProcessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public JavaExtensionRegistry block(String blockName, String blockProcessor) {
        try {
            Class<?> blockProcessorClass = Class.forName(blockProcessor);
            this.block(blockName, blockProcessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public JavaExtensionRegistry block(String blockProcessor) {
        try {
            Class<?> blockProcessorClass = Class.forName(blockProcessor);
            this.block(blockProcessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public JavaExtensionRegistry block(String blockName, Class<? extends BlockProcessor> blockProcessor) {
        RubyClass rubyClass = BlockProcessorProxy.register(this.asciidoctor, blockProcessor);
        this.getAsciidoctorModule().callMethod("block_processor", new IRubyObject[]{rubyClass, this.rubyRuntime.newString(blockName)});
        return this;
    }

    public JavaExtensionRegistry block(Class<? extends BlockProcessor> blockProcessor) {
        this.getNames(blockProcessor).forEach(name -> this.block((String)name, blockProcessor));
        return this;
    }

    public JavaExtensionRegistry block(BlockProcessor blockProcessor) {
        RubyClass rubyClass = BlockProcessorProxy.register(this.asciidoctor, blockProcessor);
        this.getAsciidoctorModule().callMethod("block_processor", (IRubyObject)rubyClass);
        return this;
    }

    public JavaExtensionRegistry block(String blockName, BlockProcessor blockProcessor) {
        RubyClass rubyClass = BlockProcessorProxy.register(this.asciidoctor, blockProcessor);
        this.getAsciidoctorModule().callMethod("block_processor", new IRubyObject[]{rubyClass, this.rubyRuntime.newString(blockName)});
        return this;
    }

    public JavaExtensionRegistry blockMacro(String blockName, Class<? extends BlockMacroProcessor> blockMacroProcessor) {
        RubyClass rubyClass = BlockMacroProcessorProxy.register(this.asciidoctor, blockMacroProcessor);
        this.getAsciidoctorModule().callMethod("block_macro", new IRubyObject[]{rubyClass, this.rubyRuntime.newString(blockName)});
        return this;
    }

    public JavaExtensionRegistry blockMacro(Class<? extends BlockMacroProcessor> blockMacroProcessor) {
        this.getNames(blockMacroProcessor).forEach(name -> {
            RubyClass rubyClass = BlockMacroProcessorProxy.register(this.asciidoctor, blockMacroProcessor);
            this.getAsciidoctorModule().callMethod("block_macro", new IRubyObject[]{rubyClass, this.rubyRuntime.newString(name)});
        });
        return this;
    }

    public JavaExtensionRegistry blockMacro(String blockName, String blockMacroProcessor) {
        try {
            Class<?> blockMacroProcessorClass = Class.forName(blockMacroProcessor);
            this.blockMacro(blockName, blockMacroProcessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public JavaExtensionRegistry blockMacro(String blockMacroProcessor) {
        try {
            Class<?> blockMacroProcessorClass = Class.forName(blockMacroProcessor);
            this.blockMacro(blockMacroProcessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public JavaExtensionRegistry blockMacro(BlockMacroProcessor blockMacroProcessor) {
        RubyClass rubyClass = BlockMacroProcessorProxy.register(this.asciidoctor, blockMacroProcessor);
        this.getAsciidoctorModule().callMethod("block_macro", (IRubyObject)rubyClass);
        return this;
    }

    public JavaExtensionRegistry blockMacro(String macroName, BlockMacroProcessor blockMacroProcessor) {
        RubyClass rubyClass = BlockMacroProcessorProxy.register(this.asciidoctor, blockMacroProcessor);
        this.getAsciidoctorModule().callMethod("block_macro", new IRubyObject[]{rubyClass, this.rubyRuntime.newString(macroName)});
        return this;
    }

    public JavaExtensionRegistry inlineMacro(String macroName, InlineMacroProcessor inlineMacroProcessor) {
        RubyClass rubyClass = InlineMacroProcessorProxy.register(this.asciidoctor, inlineMacroProcessor);
        this.getAsciidoctorModule().callMethod("inline_macro", new IRubyObject[]{rubyClass, this.rubyRuntime.newString(macroName)});
        return this;
    }

    public JavaExtensionRegistry inlineMacro(InlineMacroProcessor inlineMacroProcessor) {
        RubyClass rubyClass = InlineMacroProcessorProxy.register(this.asciidoctor, inlineMacroProcessor);
        this.getAsciidoctorModule().callMethod("inline_macro", (IRubyObject)rubyClass);
        return this;
    }

    public JavaExtensionRegistry inlineMacro(String macroName, Class<? extends InlineMacroProcessor> inlineMacroProcessor) {
        RubyClass rubyClass = InlineMacroProcessorProxy.register(this.asciidoctor, inlineMacroProcessor);
        this.getAsciidoctorModule().callMethod("inline_macro", new IRubyObject[]{rubyClass, this.rubyRuntime.newString(macroName)});
        return this;
    }

    public JavaExtensionRegistry inlineMacro(Class<? extends InlineMacroProcessor> inlineMacroProcessor) {
        this.getNames(inlineMacroProcessor).forEach(name -> {
            RubyClass rubyClass = InlineMacroProcessorProxy.register(this.asciidoctor, inlineMacroProcessor);
            this.getAsciidoctorModule().callMethod("inline_macro", new IRubyObject[]{rubyClass, this.rubyRuntime.newString(name)});
        });
        return this;
    }

    public JavaExtensionRegistry inlineMacro(String macroName, String inlineMacroProcessor) {
        try {
            Class<?> inlineMacroProcessorClass = Class.forName(inlineMacroProcessor);
            this.inlineMacro(macroName, inlineMacroProcessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public JavaExtensionRegistry inlineMacro(String inlineMacroProcessor) {
        try {
            Class<?> inlineMacroProcessorClass = Class.forName(inlineMacroProcessor);
            this.inlineMacro(inlineMacroProcessorClass);
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<Name> getNameAnnotations(Annotation[] annotations, Set<Annotation> visitedAnnotations) {
        HashSet<Name> allNameAnnotations = new HashSet<Name>();
        for (Annotation anno : annotations) {
            if (visitedAnnotations.contains(anno)) continue;
            if (anno.annotationType().isAssignableFrom(Name.class)) {
                allNameAnnotations.add((Name)anno);
                continue;
            }
            visitedAnnotations.add(anno);
            allNameAnnotations.addAll(this.getNameAnnotations(anno.annotationType().getAnnotations(), visitedAnnotations));
        }
        return allNameAnnotations;
    }

    private Set<String> getNames(Class<?> clazz) {
        Set<String> nameAnnotations = this.getNameAnnotations(clazz.getAnnotations(), new HashSet<Annotation>()).stream().map(Name::value).distinct().collect(Collectors.toSet());
        if (nameAnnotations.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(clazz) + " must be registered with a name or it must have a Name annotation!");
        }
        return nameAnnotations;
    }

    private RubyModule getAsciidoctorModule() {
        return this.rubyRuntime.getModule("AsciidoctorModule");
    }
}

