/*
 *  Copyright (C) 2010 Ryszard Wiśniewski <brut.alll@gmail.com>
 *  Copyright (C) 2010 Connor Tumbleson <connor.tumbleson@gmail.com>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package brut.androlib;

import brut.androlib.res.Framework;

import java.io.File;

import org.junit.*;
import static org.junit.Assert.*;

public class FrameworkTest extends BaseTest {
    private static final String FRAMEWORK_APK = "framework.apk";

    @BeforeClass
    public static void beforeClass() throws Exception {
        copyResourceDir(FrameworkTest.class, "framework", sTmpDir);
    }

    @Test
    public void isFrameworkTaggingWorking() throws Exception {
        sConfig.setFrameworkDirectory(sTmpDir.getAbsolutePath());
        sConfig.setFrameworkTag("building");

        File frameApk = new File(sTmpDir, FRAMEWORK_APK);
        new Framework(sConfig).install(frameApk);

        assertTrue(new File(sTmpDir, "2-building.apk").exists());
    }

    @Test
    public void isFrameworkInstallingWorking() throws Exception {
        sConfig.setFrameworkDirectory(sTmpDir.getAbsolutePath());

        File frameApk = new File(sTmpDir, FRAMEWORK_APK);
        new Framework(sConfig).install(frameApk);

        assertTrue(new File(sTmpDir, "2.apk").exists());
    }
}
