/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  /usr/bin/gengetopt -i RNAmultifold.ggo --file-name=RNAmultifold_cmdl --include-getopt --default-optional --unamed-opts --func-name=RNAmultifold_cmdline_parser --arg-struct-name=RNAmultifold_args_info

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif


#include "RNAmultifold_cmdl.h"

const char *RNAmultifold_args_info_purpose = "Compute secondary structures of multiple interacting RNAs";

const char *RNAmultifold_args_info_usage = "Usage: RNAmultifold [OPTION]... [FILE]...";

const char *RNAmultifold_args_info_versiontext = "";

const char *RNAmultifold_args_info_description = "The program works much like RNAfold, but allows one to specify multiple RNA\nsequences which are then allowed to form conncected components. RNA sequences\nare read from stdin in the usual format, i.e. each line of input corresponds to\none sequence, except for lines starting with \">\" which contain the name of\nthe next sequence(s).\nMultiple strands must be concatenated using the \'&\' character as separator.\nRNAmultifold can compute MFE, partition function, corresponding ensemble free\nenergy and base pairing probabilities. These properties are either computed for\na particular arrangement (concatenation) of sequences, for the full ensemble of\nthe complex of input RNAs, or all complexes formed by the input sequences up to\na specified number of interacting sequences.\nOutput consists of a PostScript \"dot plot\" file containing the pair\nprobabilities, see the RNAfold man page for details.\nThe program will continue to read new sequences until a line consisting of the\nsingle character '@' or an end of file condition is encountered.\n\n";

const char *RNAmultifold_args_info_detailed_help[] = {
  "  -h, --help                    Print help and exit",
  "      --detailed-help           Print help, including all details and hidden\n                                  options, and exit",
  "      --full-help               Print help, including hidden options, and exit",
  "  -V, --version                 Print version and exit",
  "  -v, --verbose                 Be verbose.\n                                    (default=off)",
  "  Lower the log level setting such that even INFO messages are passed through.\n\n",
  "\nI/O Options:",
  "  Command line options for input and output (pre-)processing\n\n",
  "  -j, --jobs[=number]           Split batch input into jobs and start\n                                  processing in parallel using multiple\n                                  threads. A value of 0 indicates to use as\n                                  many parallel threads as computation cores\n                                  are available.\n                                    (default=`0')",
  "  Default processing of input data is performed in a serial fashion, i.e. one\n  sequence pair at a time. Using this switch, a user can instead start the\n  computation for many sequence pairs in the input in parallel. RNAmultifold\n  will create as many parallel computation slots as specified and assigns input\n  sequences of the input file(s) to the available slots. Note, that this\n  increases memory consumption since input alignments have to be kept in memory\n  until an empty compute slot is available and each running job requires its\n  own dynamic programming matrices.\n\n",
  "      --unordered               Do not try to keep output in order with input\n                                  while parallel processing is in place.\n                                    (default=off)",
  "  When parallel input processing (--jobs flag) is enabled, the order in which\n  input is processed depends on the host machines job scheduler. Therefore, any\n  output to stdout or files generated by this program will most likely not\n  follow the order of the corresponding input data set. The default of\n  RNAmultifold is to use a specialized data structure to still keep the results\n  output in order with the input data. However, this comes with a trade-off in\n  terms of memory consumption, since all output must be kept in memory for as\n  long as no chunks of consecutive, ordered output are available. By setting\n  this flag, RNAmultifold will not buffer individual results but print them as\n  soon as they have been computated.\n\n",
  "      --noconv                  Do not automatically substitute nucleotide\n                                  \"T\" with \"U\".\n\n                                    (default=off)",
  "      --auto-id                 Automatically generate an ID for each sequence.\n                                    (default=off)",
  "  The default mode of RNAmultifold is to automatically determine an ID from the\n  input sequence data if the input file format allows to do that. Sequence IDs\n  are usually given in the FASTA header of input sequences. If this flag is\n  active, RNAmultifold ignores any IDs retrieved from the input and\n  automatically generates an ID for each sequence. This ID consists of a prefix\n  and an increasing number. This flag can also be used to add a FASTA header to\n  the output even if the input has none.\n\n",
  "      --id-prefix=STRING        Prefix for automatically generated IDs (as used\n                                  in output file names).\n                                    (default=`sequence')",
  "  If this parameter is set, each sequence will be prefixed with the provided\n  string. Hence, the output files will obey the following naming scheme:\n  \"prefix_xxxx_ss.ps\" (secondary structure plot), \"prefix_xxxx_dp.ps\"\n  (dot-plot), \"prefix_xxxx_dp2.ps\" (stack probabilities), etc. where xxxx is\n  the sequence number. Note: Setting this parameter implies --auto-id.\n\n",
  "      --id-delim=CHAR           Change the delimiter between prefix and\n                                  increasing number for automatically generated\n                                  IDs (as used in output file names).\n                                    (default=`_')",
  "  This parameter can be used to change the default delimiter \"_\" between the\n  prefix string and the increasing number for automatically generated ID.\n\n",
  "      --id-digits=INT           Specify the number of digits of the counter in\n                                  automatically generated alignment IDs.\n                                    (default=`4')",
  "  When alignments IDs are automatically generated, they receive an increasing\n  number, starting with 1. This number will always be left-padded by leading\n  zeros, such that the number takes up a certain width. Using this parameter,\n  the width can be specified to the users need. We allow numbers in the range\n  [1:18]. This option implies --auto-id.\n\n",
  "      --id-start=LONG           Specify the first number in automatically\n                                  generated IDs.\n                                    (default=`1')",
  "  When sequence IDs are automatically generated, they receive an increasing\n  number, usually starting with 1. Using this parameter, the first number can\n  be specified to the users requirements. Note: negative numbers are not\n  allowed.\n  Note: Setting this parameter implies to ignore any IDs retrieved from the\n  input data, i.e. it activates the --auto-id flag.\n\n",
  "      --filename-delim=CHAR     Change the delimiting character used in\n                                  sanitized filenames.\n                                    (default=`ID-delimiter')",
  "  This parameter can be used to change the delimiting character used while\n  sanitizing filenames, i.e. replacing invalid characters. Note, that the\n  default delimiter ALWAYS is the first character of the \"ID delimiter\" as\n  supplied through the --id-delim option. If the delimiter is a whitespace\n  character or empty, invalid characters will be simply removed rather than\n  substituted. Currently, we regard the following characters as illegal for use\n  in filenames: backslash '\', slash '/', question mark '?', percent sign '%',\n  asterisk '*', colon ':', pipe symbol '|', double quote '\"', triangular\n  brackets '<' and '>'.\n\n",
  "      --filename-full           Use full FASTA header to create filenames.\n                                    (default=off)",
  "  This parameter can be used to deactivate the default behavior of limiting\n  output filenames to the first word of the sequence ID. Consider the following\n  example: An input with FASTA header '>NM_0001 Homo Sapiens some gene' usually\n  produces output files with the prefix \"NM_0001\" without the additional data\n  available in the FASTA header, e.g. \"NM_0001_ss.ps\" for secondary structure\n  plots. With this flag set, no truncation of the output filenames is done,\n  i.e. output filenames receive the full FASTA header data as prefixes. Note,\n  however, that invalid characters (such as whitespace) will be substituted by\n  a delimiting character or simply removed, (see also the parameter option\n  --filename-delim).\n\n",
  "      --log-level=level         Set log level threshold.\n                                    (default=`2')",
  "  By default, any log messages are filtered such that only warnings (level 2)\n  or errors (level 3) are printed. This setting allows for specifying the log\n  level threshold, where higher values result in fewer information. Log-level 5\n  turns off all messages, even errors and other critical information.\n\n",
  "      --log-file[=filename]     Print log messages to a file instead of stderr.\n                                    (default=`RNAmultifold.log')",
  "      --log-time                Include time stamp in log messages.\n\n                                    (default=off)",
  "      --log-call                Include file and line of log calling function.\n\n                                    (default=off)",
  "\nAlgorithms:",
  "  Select additional algorithms which should be included in the calculations.\n  The Minimum free energy (MFE) and a structure representative are calculated\n  in any case.\n\n",
  "  -p, --partfunc[=INT]          Calculate the partition function and base\n                                  pairing probability matrix in addition to the\n                                  MFE structure. Default is calculation of mfe\n                                  structure only.\n                                    (default=`1')",
  "  In addition to the MFE structure we print a coarse representation of the pair\n  probabilities in form of a pseudo bracket notation, followed by the ensemble\n  free energy.\n  Note that unless you also specify -d2 or -d0, the partition function and mfe\n  calculations will use a slightly different energy model. See the discussion\n  of dangling end options below.\n\n  An additionally passed value to this option changes the behavior of partition\n  function calculation:\n\n   In order to calculate the partition function but not the pair probabilities\n  use the -p0 option and save about\n   50% in runtime. This prints the ensemble free energy 'dG=-kT ln(Z)'.\n\n",
  "  -a, --all_pf[=INT]            Compute the partition function and free\n                                  energies not only for the complex formed by\n                                  the input sequences (the \"ABC... mutimer\"),\n                                  but also of all complexes formed by the input\n                                  sequences up to the number of input\n                                  sequences, e.g. AAA, AAB, ABB, BBB, etc.\n                                    (default=`1')",
  "  The output will contain the free energies for each of these species. Using -a\n  automatically switches on the -p option.\n\n",
  "  -c, --concentrations          In addition to everything listed under the -a\n                                  option, read in initial monomer\n                                  concentrations and compute the expected\n                                  equilibrium concentrations of all possible\n                                  species (A, B, AA, BB, AB, etc).\n                                    (default=off)",
  "  Start concentrations are read from stdin (unless the -f option is used) in\n  [mol/l], equilibrium concentrations are given realtive to the sum of the\n  inputs. An arbitrary number of initial concentrations can be specified (one\n  tuple of concentrations per line).\n\n",
  "  -f, --concfile=filename       Specify a file with initial concentrations for\n                                  the input sequences.",
  "  The table consits of arbitrary many lines with multiple numbers separated by\n  whitespace (the concentration of the input sequences A, B, C, etc.). This\n  option will automatically toggle the -c (and thus -a and -p) options (see\n  above).\n\n",
  "      --absolute-concentrations Report absolute instead of relative\n                                  concentrations\n\n                                    (default=off)",
  "      --betaScale=DOUBLE        Set the scaling of the Boltzmann factors.\n                                    (default=`1.')",
  "  The argument provided with this option is used to scale the thermodynamic\n  temperature in the Boltzmann factors independently from the temperature of\n  the individual loop energy contributions. The Boltzmann factors then become\n  'exp(- dG/(kT*betaScale))' where 'k' is the Boltzmann constant, 'dG' the free\n  energy contribution of the state and 'T' the absolute temperature.\n\n",
  "  -S, --pfScale=DOUBLE          In the calculation of the pf use scale*mfe as\n                                  an estimate for the ensemble free energy\n                                  (used to avoid overflows).\n                                    (default=`1.07')",
  "  The default is 1.07, useful values are 1.0 to 1.2. Occasionally needed for\n  long sequences.\n\n",
  "      --bppmThreshold=cutoff    Set the threshold/cutoff for base pair\n                                  probabilities included in the postscript\n                                  output.\n\n                                    (default=`1e-5')",
  "  By setting the threshold the base pair probabilities that are included in the\n  output can be varied. By default only those exceeding '1e-5' in probability\n  will be shown as squares in the dot plot. Changing the threshold to any other\n  value allows for increase or decrease of data.\n\n",
  "  -g, --gquad                   Incoorporate G-Quadruplex formation into the\n                                  structure prediction algorithm.\n                                    (default=off)",
  "  Note, only intramolecular G-quadruplexes are considered.\n\n",
  "\nStructure Constraints:",
  "  Command line options to interact with the structure constraints feature of\n  this program\n\n",
  "      --maxBPspan=INT           Set the maximum base pair span.\n\n                                    (default=`-1')",
  "      --commands=filename       Read additional commands from file\n",
  "  Commands include hard and soft constraints, but also structure motifs in\n  hairpin and internal loops that need to be treeted differently. Furthermore,\n  commands can be set for unstructured and structured domains.\n\n",
  "\nEnergy Parameters:",
  "  Energy parameter sets can be adapted or loaded from user-provided input files\n\n",
  "  -T, --temp=DOUBLE             Rescale energy parameters to a temperature of\n                                  temp C. Default is 37C.\n\n                                    (default=`37.0')",
  "  -P, --paramFile=paramfile     Read energy parameters from paramfile, instead\n                                  of using the default parameter set.\n",
  "  Different sets of energy parameters for RNA and DNA should accompany your\n  distribution.\n  See the RNAlib documentation for details on the file format. The placeholder\n  file name 'DNA' can be used to load DNA parameters without the need to\n  actually specify any input file.\n\n",
  "  -4, --noTetra                 Do not include special tabulated stabilizing\n                                  energies for tri-, tetra- and hexaloop\n                                  hairpins.\n                                    (default=off)",
  "  Mostly for testing.\n\n",
  "      --salt=DOUBLE             Set salt concentration in molar (M). Default is\n                                  1.021M.\n\n",
  "\nModel Details:",
  "  Tweak the energy model and pairing rules additionally using the following\n  parameters\n\n",
  "  -d, --dangles=INT             How to treat \"dangling end\" energies for\n                                  bases adjacent to helices in free ends and\n                                  multi-loops.\n                                    (default=`2')",
  "  \n  With -d1 only unpaired bases can participate in at most one dangling end.\n  With -d2 this check is ignored, dangling energies will be added for the bases\n  adjacent to a helix on both sides in any case; this is the default for mfe\n  and partition function folding (-p).\n  The option -d0 ignores dangling ends altogether (mostly for debugging).\n  With -d3 mfe folding will allow coaxial stacking of adjacent helices in\n  multi-loops. At the moment the implementation will not allow coaxial stacking\n  of the two enclosed pairs in a loop of degree 3 and works only for mfe\n  folding.\n\n  Note that with -d1 and -d3 only the MFE computations will be using this\n  setting while partition function uses -d2 setting, i.e. dangling ends will be\n  treated differently.\n\n",
  "      --noLP                    Produce structures without lonely pairs\n                                  (helices of length 1).\n                                    (default=off)",
  "  For partition function folding this only disallows pairs that can only occur\n  isolated. Other pairs may still occasionally occur as helices of length 1.\n\n",
  "      --noGU                    Do not allow GU pairs.\n\n                                    (default=off)",
  "      --noClosingGU             Do not allow GU pairs at the end of helices.\n\n                                    (default=off)",
  "      --nsp=STRING              Allow other pairs in addition to the usual\n                                  AU,GC,and GU pairs.\n",
  "  Its argument is a comma separated list of additionally allowed pairs. If the\n  first character is a \"-\" then AB will imply that AB and BA are allowed\n  pairs, e.g. --nsp=\"-GA\"  will allow GA and AG pairs. Nonstandard pairs are\n  given 0 stacking energy.\n\n",
  "      --energyModel=INT         Set energy model.\n",
  "  Rarely used option to fold sequences from the artificial ABCD... alphabet,\n  where A pairs B, C-D etc.  Use the energy parameters for GC (--energyModel 1)\n  or AU (--energyModel 2) pairs.\n\n",
  "      --helical-rise=FLOAT      Set the helical rise of the helix in units of\n                                  Angstrom.\n                                    (default=`2.8')",
  "  Use with caution! This value will be re-set automatically to 3.4 in case DNA\n  parameters are loaded via -P DNA and no further value is provided.\n\n",
  "      --backbone-length=FLOAT   Set the average backbone length for looped\n                                  regions in units of Angstrom.\n                                    (default=`6.0')",
  "  Use with caution! This value will be re-set automatically to 6.76 in case DNA\n  parameters are loaded via -P DNA and no further value is provided.\n\n",
  "\nIf in doubt our program is right, nature is at fault.\nComments should be sent to rna@tbi.univie.ac.at.\n\n",
    0
};
static void
init_full_help_array(void)
{
  RNAmultifold_args_info_full_help[0] = RNAmultifold_args_info_detailed_help[0];
  RNAmultifold_args_info_full_help[1] = RNAmultifold_args_info_detailed_help[1];
  RNAmultifold_args_info_full_help[2] = RNAmultifold_args_info_detailed_help[2];
  RNAmultifold_args_info_full_help[3] = RNAmultifold_args_info_detailed_help[3];
  RNAmultifold_args_info_full_help[4] = RNAmultifold_args_info_detailed_help[4];
  RNAmultifold_args_info_full_help[5] = RNAmultifold_args_info_detailed_help[6];
  RNAmultifold_args_info_full_help[6] = RNAmultifold_args_info_detailed_help[7];
  RNAmultifold_args_info_full_help[7] = RNAmultifold_args_info_detailed_help[8];
  RNAmultifold_args_info_full_help[8] = RNAmultifold_args_info_detailed_help[10];
  RNAmultifold_args_info_full_help[9] = RNAmultifold_args_info_detailed_help[12];
  RNAmultifold_args_info_full_help[10] = RNAmultifold_args_info_detailed_help[13];
  RNAmultifold_args_info_full_help[11] = RNAmultifold_args_info_detailed_help[15];
  RNAmultifold_args_info_full_help[12] = RNAmultifold_args_info_detailed_help[17];
  RNAmultifold_args_info_full_help[13] = RNAmultifold_args_info_detailed_help[19];
  RNAmultifold_args_info_full_help[14] = RNAmultifold_args_info_detailed_help[21];
  RNAmultifold_args_info_full_help[15] = RNAmultifold_args_info_detailed_help[23];
  RNAmultifold_args_info_full_help[16] = RNAmultifold_args_info_detailed_help[25];
  RNAmultifold_args_info_full_help[17] = RNAmultifold_args_info_detailed_help[27];
  RNAmultifold_args_info_full_help[18] = RNAmultifold_args_info_detailed_help[29];
  RNAmultifold_args_info_full_help[19] = RNAmultifold_args_info_detailed_help[30];
  RNAmultifold_args_info_full_help[20] = RNAmultifold_args_info_detailed_help[31];
  RNAmultifold_args_info_full_help[21] = RNAmultifold_args_info_detailed_help[32];
  RNAmultifold_args_info_full_help[22] = RNAmultifold_args_info_detailed_help[33];
  RNAmultifold_args_info_full_help[23] = RNAmultifold_args_info_detailed_help[34];
  RNAmultifold_args_info_full_help[24] = RNAmultifold_args_info_detailed_help[36];
  RNAmultifold_args_info_full_help[25] = RNAmultifold_args_info_detailed_help[38];
  RNAmultifold_args_info_full_help[26] = RNAmultifold_args_info_detailed_help[40];
  RNAmultifold_args_info_full_help[27] = RNAmultifold_args_info_detailed_help[42];
  RNAmultifold_args_info_full_help[28] = RNAmultifold_args_info_detailed_help[43];
  RNAmultifold_args_info_full_help[29] = RNAmultifold_args_info_detailed_help[45];
  RNAmultifold_args_info_full_help[30] = RNAmultifold_args_info_detailed_help[47];
  RNAmultifold_args_info_full_help[31] = RNAmultifold_args_info_detailed_help[49];
  RNAmultifold_args_info_full_help[32] = RNAmultifold_args_info_detailed_help[51];
  RNAmultifold_args_info_full_help[33] = RNAmultifold_args_info_detailed_help[52];
  RNAmultifold_args_info_full_help[34] = RNAmultifold_args_info_detailed_help[53];
  RNAmultifold_args_info_full_help[35] = RNAmultifold_args_info_detailed_help[54];
  RNAmultifold_args_info_full_help[36] = RNAmultifold_args_info_detailed_help[56];
  RNAmultifold_args_info_full_help[37] = RNAmultifold_args_info_detailed_help[57];
  RNAmultifold_args_info_full_help[38] = RNAmultifold_args_info_detailed_help[58];
  RNAmultifold_args_info_full_help[39] = RNAmultifold_args_info_detailed_help[59];
  RNAmultifold_args_info_full_help[40] = RNAmultifold_args_info_detailed_help[61];
  RNAmultifold_args_info_full_help[41] = RNAmultifold_args_info_detailed_help[63];
  RNAmultifold_args_info_full_help[42] = RNAmultifold_args_info_detailed_help[64];
  RNAmultifold_args_info_full_help[43] = RNAmultifold_args_info_detailed_help[65];
  RNAmultifold_args_info_full_help[44] = RNAmultifold_args_info_detailed_help[66];
  RNAmultifold_args_info_full_help[45] = RNAmultifold_args_info_detailed_help[68];
  RNAmultifold_args_info_full_help[46] = RNAmultifold_args_info_detailed_help[70];
  RNAmultifold_args_info_full_help[47] = RNAmultifold_args_info_detailed_help[71];
  RNAmultifold_args_info_full_help[48] = RNAmultifold_args_info_detailed_help[72];
  RNAmultifold_args_info_full_help[49] = RNAmultifold_args_info_detailed_help[74];
  RNAmultifold_args_info_full_help[50] = RNAmultifold_args_info_detailed_help[76];
  RNAmultifold_args_info_full_help[51] = RNAmultifold_args_info_detailed_help[78];
  RNAmultifold_args_info_full_help[52] = RNAmultifold_args_info_detailed_help[80];
  RNAmultifold_args_info_full_help[53] = 0; 
  
}

const char *RNAmultifold_args_info_full_help[54];

static void
init_help_array(void)
{
  RNAmultifold_args_info_help[0] = RNAmultifold_args_info_detailed_help[0];
  RNAmultifold_args_info_help[1] = RNAmultifold_args_info_detailed_help[1];
  RNAmultifold_args_info_help[2] = RNAmultifold_args_info_detailed_help[2];
  RNAmultifold_args_info_help[3] = RNAmultifold_args_info_detailed_help[3];
  RNAmultifold_args_info_help[4] = RNAmultifold_args_info_detailed_help[4];
  RNAmultifold_args_info_help[5] = RNAmultifold_args_info_detailed_help[6];
  RNAmultifold_args_info_help[6] = RNAmultifold_args_info_detailed_help[7];
  RNAmultifold_args_info_help[7] = RNAmultifold_args_info_detailed_help[8];
  RNAmultifold_args_info_help[8] = RNAmultifold_args_info_detailed_help[12];
  RNAmultifold_args_info_help[9] = RNAmultifold_args_info_detailed_help[13];
  RNAmultifold_args_info_help[10] = RNAmultifold_args_info_detailed_help[15];
  RNAmultifold_args_info_help[11] = RNAmultifold_args_info_detailed_help[32];
  RNAmultifold_args_info_help[12] = RNAmultifold_args_info_detailed_help[33];
  RNAmultifold_args_info_help[13] = RNAmultifold_args_info_detailed_help[34];
  RNAmultifold_args_info_help[14] = RNAmultifold_args_info_detailed_help[36];
  RNAmultifold_args_info_help[15] = RNAmultifold_args_info_detailed_help[38];
  RNAmultifold_args_info_help[16] = RNAmultifold_args_info_detailed_help[40];
  RNAmultifold_args_info_help[17] = RNAmultifold_args_info_detailed_help[42];
  RNAmultifold_args_info_help[18] = RNAmultifold_args_info_detailed_help[49];
  RNAmultifold_args_info_help[19] = RNAmultifold_args_info_detailed_help[51];
  RNAmultifold_args_info_help[20] = RNAmultifold_args_info_detailed_help[52];
  RNAmultifold_args_info_help[21] = RNAmultifold_args_info_detailed_help[53];
  RNAmultifold_args_info_help[22] = RNAmultifold_args_info_detailed_help[56];
  RNAmultifold_args_info_help[23] = RNAmultifold_args_info_detailed_help[57];
  RNAmultifold_args_info_help[24] = RNAmultifold_args_info_detailed_help[58];
  RNAmultifold_args_info_help[25] = RNAmultifold_args_info_detailed_help[59];
  RNAmultifold_args_info_help[26] = RNAmultifold_args_info_detailed_help[63];
  RNAmultifold_args_info_help[27] = RNAmultifold_args_info_detailed_help[64];
  RNAmultifold_args_info_help[28] = RNAmultifold_args_info_detailed_help[65];
  RNAmultifold_args_info_help[29] = RNAmultifold_args_info_detailed_help[66];
  RNAmultifold_args_info_help[30] = RNAmultifold_args_info_detailed_help[68];
  RNAmultifold_args_info_help[31] = RNAmultifold_args_info_detailed_help[80];
  RNAmultifold_args_info_help[32] = 0; 
  
}

const char *RNAmultifold_args_info_help[33];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_LONG
  , ARG_FLOAT
  , ARG_DOUBLE
} RNAmultifold_cmdline_parser_arg_type;

static
void clear_given (struct RNAmultifold_args_info *args_info);
static
void clear_args (struct RNAmultifold_args_info *args_info);

static int
RNAmultifold_cmdline_parser_internal (int argc, char **argv, struct RNAmultifold_args_info *args_info,
                        struct RNAmultifold_cmdline_parser_params *params, const char *additional_error);

static int
RNAmultifold_cmdline_parser_required2 (struct RNAmultifold_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct RNAmultifold_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->detailed_help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->jobs_given = 0 ;
  args_info->unordered_given = 0 ;
  args_info->noconv_given = 0 ;
  args_info->auto_id_given = 0 ;
  args_info->id_prefix_given = 0 ;
  args_info->id_delim_given = 0 ;
  args_info->id_digits_given = 0 ;
  args_info->id_start_given = 0 ;
  args_info->filename_delim_given = 0 ;
  args_info->filename_full_given = 0 ;
  args_info->log_level_given = 0 ;
  args_info->log_file_given = 0 ;
  args_info->log_time_given = 0 ;
  args_info->log_call_given = 0 ;
  args_info->partfunc_given = 0 ;
  args_info->all_pf_given = 0 ;
  args_info->concentrations_given = 0 ;
  args_info->concfile_given = 0 ;
  args_info->absolute_concentrations_given = 0 ;
  args_info->betaScale_given = 0 ;
  args_info->pfScale_given = 0 ;
  args_info->bppmThreshold_given = 0 ;
  args_info->gquad_given = 0 ;
  args_info->maxBPspan_given = 0 ;
  args_info->commands_given = 0 ;
  args_info->temp_given = 0 ;
  args_info->paramFile_given = 0 ;
  args_info->noTetra_given = 0 ;
  args_info->salt_given = 0 ;
  args_info->dangles_given = 0 ;
  args_info->noLP_given = 0 ;
  args_info->noGU_given = 0 ;
  args_info->noClosingGU_given = 0 ;
  args_info->nsp_given = 0 ;
  args_info->energyModel_given = 0 ;
  args_info->helical_rise_given = 0 ;
  args_info->backbone_length_given = 0 ;
}

static
void clear_args (struct RNAmultifold_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->verbose_flag = 0;
  args_info->jobs_arg = 0;
  args_info->jobs_orig = NULL;
  args_info->unordered_flag = 0;
  args_info->noconv_flag = 0;
  args_info->auto_id_flag = 0;
  args_info->id_prefix_arg = gengetopt_strdup ("sequence");
  args_info->id_prefix_orig = NULL;
  args_info->id_delim_arg = gengetopt_strdup ("_");
  args_info->id_delim_orig = NULL;
  args_info->id_digits_arg = 4;
  args_info->id_digits_orig = NULL;
  args_info->id_start_arg = 1;
  args_info->id_start_orig = NULL;
  args_info->filename_delim_arg = gengetopt_strdup ("ID-delimiter");
  args_info->filename_delim_orig = NULL;
  args_info->filename_full_flag = 0;
  args_info->log_level_arg = 2;
  args_info->log_level_orig = NULL;
  args_info->log_file_arg = gengetopt_strdup ("RNAmultifold.log");
  args_info->log_file_orig = NULL;
  args_info->log_time_flag = 0;
  args_info->log_call_flag = 0;
  args_info->partfunc_arg = 1;
  args_info->partfunc_orig = NULL;
  args_info->all_pf_arg = 1;
  args_info->all_pf_orig = NULL;
  args_info->concentrations_flag = 0;
  args_info->concfile_arg = NULL;
  args_info->concfile_orig = NULL;
  args_info->absolute_concentrations_flag = 0;
  args_info->betaScale_arg = 1.;
  args_info->betaScale_orig = NULL;
  args_info->pfScale_arg = 1.07;
  args_info->pfScale_orig = NULL;
  args_info->bppmThreshold_arg = 1e-5;
  args_info->bppmThreshold_orig = NULL;
  args_info->gquad_flag = 0;
  args_info->maxBPspan_arg = -1;
  args_info->maxBPspan_orig = NULL;
  args_info->commands_arg = NULL;
  args_info->commands_orig = NULL;
  args_info->temp_arg = 37.0;
  args_info->temp_orig = NULL;
  args_info->paramFile_arg = NULL;
  args_info->paramFile_orig = NULL;
  args_info->noTetra_flag = 0;
  args_info->salt_orig = NULL;
  args_info->dangles_arg = 2;
  args_info->dangles_orig = NULL;
  args_info->noLP_flag = 0;
  args_info->noGU_flag = 0;
  args_info->noClosingGU_flag = 0;
  args_info->nsp_arg = NULL;
  args_info->nsp_orig = NULL;
  args_info->energyModel_orig = NULL;
  args_info->helical_rise_arg = 2.8;
  args_info->helical_rise_orig = NULL;
  args_info->backbone_length_arg = 6.0;
  args_info->backbone_length_orig = NULL;
  
}

static
void init_args_info(struct RNAmultifold_args_info *args_info)
{
  init_full_help_array(); 
  init_help_array(); 
  args_info->help_help = RNAmultifold_args_info_detailed_help[0] ;
  args_info->detailed_help_help = RNAmultifold_args_info_detailed_help[1] ;
  args_info->full_help_help = RNAmultifold_args_info_detailed_help[2] ;
  args_info->version_help = RNAmultifold_args_info_detailed_help[3] ;
  args_info->verbose_help = RNAmultifold_args_info_detailed_help[4] ;
  args_info->jobs_help = RNAmultifold_args_info_detailed_help[8] ;
  args_info->unordered_help = RNAmultifold_args_info_detailed_help[10] ;
  args_info->noconv_help = RNAmultifold_args_info_detailed_help[12] ;
  args_info->auto_id_help = RNAmultifold_args_info_detailed_help[13] ;
  args_info->id_prefix_help = RNAmultifold_args_info_detailed_help[15] ;
  args_info->id_delim_help = RNAmultifold_args_info_detailed_help[17] ;
  args_info->id_digits_help = RNAmultifold_args_info_detailed_help[19] ;
  args_info->id_start_help = RNAmultifold_args_info_detailed_help[21] ;
  args_info->filename_delim_help = RNAmultifold_args_info_detailed_help[23] ;
  args_info->filename_full_help = RNAmultifold_args_info_detailed_help[25] ;
  args_info->log_level_help = RNAmultifold_args_info_detailed_help[27] ;
  args_info->log_file_help = RNAmultifold_args_info_detailed_help[29] ;
  args_info->log_time_help = RNAmultifold_args_info_detailed_help[30] ;
  args_info->log_call_help = RNAmultifold_args_info_detailed_help[31] ;
  args_info->partfunc_help = RNAmultifold_args_info_detailed_help[34] ;
  args_info->all_pf_help = RNAmultifold_args_info_detailed_help[36] ;
  args_info->concentrations_help = RNAmultifold_args_info_detailed_help[38] ;
  args_info->concfile_help = RNAmultifold_args_info_detailed_help[40] ;
  args_info->absolute_concentrations_help = RNAmultifold_args_info_detailed_help[42] ;
  args_info->betaScale_help = RNAmultifold_args_info_detailed_help[43] ;
  args_info->pfScale_help = RNAmultifold_args_info_detailed_help[45] ;
  args_info->bppmThreshold_help = RNAmultifold_args_info_detailed_help[47] ;
  args_info->gquad_help = RNAmultifold_args_info_detailed_help[49] ;
  args_info->maxBPspan_help = RNAmultifold_args_info_detailed_help[53] ;
  args_info->commands_help = RNAmultifold_args_info_detailed_help[54] ;
  args_info->temp_help = RNAmultifold_args_info_detailed_help[58] ;
  args_info->paramFile_help = RNAmultifold_args_info_detailed_help[59] ;
  args_info->noTetra_help = RNAmultifold_args_info_detailed_help[61] ;
  args_info->salt_help = RNAmultifold_args_info_detailed_help[63] ;
  args_info->dangles_help = RNAmultifold_args_info_detailed_help[66] ;
  args_info->noLP_help = RNAmultifold_args_info_detailed_help[68] ;
  args_info->noGU_help = RNAmultifold_args_info_detailed_help[70] ;
  args_info->noClosingGU_help = RNAmultifold_args_info_detailed_help[71] ;
  args_info->nsp_help = RNAmultifold_args_info_detailed_help[72] ;
  args_info->energyModel_help = RNAmultifold_args_info_detailed_help[74] ;
  args_info->helical_rise_help = RNAmultifold_args_info_detailed_help[76] ;
  args_info->backbone_length_help = RNAmultifold_args_info_detailed_help[78] ;
  
}

void
RNAmultifold_cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(RNAMULTIFOLD_CMDLINE_PARSER_PACKAGE_NAME) ? RNAMULTIFOLD_CMDLINE_PARSER_PACKAGE_NAME : RNAMULTIFOLD_CMDLINE_PARSER_PACKAGE),
     RNAMULTIFOLD_CMDLINE_PARSER_VERSION);

  if (strlen(RNAmultifold_args_info_versiontext) > 0)
    printf("\n%s\n", RNAmultifold_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(RNAmultifold_args_info_purpose);
	size_t len_usage = strlen(RNAmultifold_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", RNAmultifold_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", RNAmultifold_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(RNAmultifold_args_info_description) > 0) {
		printf("%s\n\n", RNAmultifold_args_info_description);
	}
}

void
RNAmultifold_cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAmultifold_args_info_help[i])
    printf("%s\n", RNAmultifold_args_info_help[i++]);
}

void
RNAmultifold_cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAmultifold_args_info_full_help[i])
    printf("%s\n", RNAmultifold_args_info_full_help[i++]);
}

void
RNAmultifold_cmdline_parser_print_detailed_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAmultifold_args_info_detailed_help[i])
    printf("%s\n", RNAmultifold_args_info_detailed_help[i++]);
}

void
RNAmultifold_cmdline_parser_init (struct RNAmultifold_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
RNAmultifold_cmdline_parser_params_init(struct RNAmultifold_cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct RNAmultifold_cmdline_parser_params *
RNAmultifold_cmdline_parser_params_create(void)
{
  struct RNAmultifold_cmdline_parser_params *params = 
    (struct RNAmultifold_cmdline_parser_params *)malloc(sizeof(struct RNAmultifold_cmdline_parser_params));
  RNAmultifold_cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
RNAmultifold_cmdline_parser_release (struct RNAmultifold_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->jobs_orig));
  free_string_field (&(args_info->id_prefix_arg));
  free_string_field (&(args_info->id_prefix_orig));
  free_string_field (&(args_info->id_delim_arg));
  free_string_field (&(args_info->id_delim_orig));
  free_string_field (&(args_info->id_digits_orig));
  free_string_field (&(args_info->id_start_orig));
  free_string_field (&(args_info->filename_delim_arg));
  free_string_field (&(args_info->filename_delim_orig));
  free_string_field (&(args_info->log_level_orig));
  free_string_field (&(args_info->log_file_arg));
  free_string_field (&(args_info->log_file_orig));
  free_string_field (&(args_info->partfunc_orig));
  free_string_field (&(args_info->all_pf_orig));
  free_string_field (&(args_info->concfile_arg));
  free_string_field (&(args_info->concfile_orig));
  free_string_field (&(args_info->betaScale_orig));
  free_string_field (&(args_info->pfScale_orig));
  free_string_field (&(args_info->bppmThreshold_orig));
  free_string_field (&(args_info->maxBPspan_orig));
  free_string_field (&(args_info->commands_arg));
  free_string_field (&(args_info->commands_orig));
  free_string_field (&(args_info->temp_orig));
  free_string_field (&(args_info->paramFile_arg));
  free_string_field (&(args_info->paramFile_orig));
  free_string_field (&(args_info->salt_orig));
  free_string_field (&(args_info->dangles_orig));
  free_string_field (&(args_info->nsp_arg));
  free_string_field (&(args_info->nsp_orig));
  free_string_field (&(args_info->energyModel_orig));
  free_string_field (&(args_info->helical_rise_orig));
  free_string_field (&(args_info->backbone_length_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
RNAmultifold_cmdline_parser_dump(FILE *outfile, struct RNAmultifold_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", RNAMULTIFOLD_CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->detailed_help_given)
    write_into_file(outfile, "detailed-help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", 0, 0 );
  if (args_info->jobs_given)
    write_into_file(outfile, "jobs", args_info->jobs_orig, 0);
  if (args_info->unordered_given)
    write_into_file(outfile, "unordered", 0, 0 );
  if (args_info->noconv_given)
    write_into_file(outfile, "noconv", 0, 0 );
  if (args_info->auto_id_given)
    write_into_file(outfile, "auto-id", 0, 0 );
  if (args_info->id_prefix_given)
    write_into_file(outfile, "id-prefix", args_info->id_prefix_orig, 0);
  if (args_info->id_delim_given)
    write_into_file(outfile, "id-delim", args_info->id_delim_orig, 0);
  if (args_info->id_digits_given)
    write_into_file(outfile, "id-digits", args_info->id_digits_orig, 0);
  if (args_info->id_start_given)
    write_into_file(outfile, "id-start", args_info->id_start_orig, 0);
  if (args_info->filename_delim_given)
    write_into_file(outfile, "filename-delim", args_info->filename_delim_orig, 0);
  if (args_info->filename_full_given)
    write_into_file(outfile, "filename-full", 0, 0 );
  if (args_info->log_level_given)
    write_into_file(outfile, "log-level", args_info->log_level_orig, 0);
  if (args_info->log_file_given)
    write_into_file(outfile, "log-file", args_info->log_file_orig, 0);
  if (args_info->log_time_given)
    write_into_file(outfile, "log-time", 0, 0 );
  if (args_info->log_call_given)
    write_into_file(outfile, "log-call", 0, 0 );
  if (args_info->partfunc_given)
    write_into_file(outfile, "partfunc", args_info->partfunc_orig, 0);
  if (args_info->all_pf_given)
    write_into_file(outfile, "all_pf", args_info->all_pf_orig, 0);
  if (args_info->concentrations_given)
    write_into_file(outfile, "concentrations", 0, 0 );
  if (args_info->concfile_given)
    write_into_file(outfile, "concfile", args_info->concfile_orig, 0);
  if (args_info->absolute_concentrations_given)
    write_into_file(outfile, "absolute-concentrations", 0, 0 );
  if (args_info->betaScale_given)
    write_into_file(outfile, "betaScale", args_info->betaScale_orig, 0);
  if (args_info->pfScale_given)
    write_into_file(outfile, "pfScale", args_info->pfScale_orig, 0);
  if (args_info->bppmThreshold_given)
    write_into_file(outfile, "bppmThreshold", args_info->bppmThreshold_orig, 0);
  if (args_info->gquad_given)
    write_into_file(outfile, "gquad", 0, 0 );
  if (args_info->maxBPspan_given)
    write_into_file(outfile, "maxBPspan", args_info->maxBPspan_orig, 0);
  if (args_info->commands_given)
    write_into_file(outfile, "commands", args_info->commands_orig, 0);
  if (args_info->temp_given)
    write_into_file(outfile, "temp", args_info->temp_orig, 0);
  if (args_info->paramFile_given)
    write_into_file(outfile, "paramFile", args_info->paramFile_orig, 0);
  if (args_info->noTetra_given)
    write_into_file(outfile, "noTetra", 0, 0 );
  if (args_info->salt_given)
    write_into_file(outfile, "salt", args_info->salt_orig, 0);
  if (args_info->dangles_given)
    write_into_file(outfile, "dangles", args_info->dangles_orig, 0);
  if (args_info->noLP_given)
    write_into_file(outfile, "noLP", 0, 0 );
  if (args_info->noGU_given)
    write_into_file(outfile, "noGU", 0, 0 );
  if (args_info->noClosingGU_given)
    write_into_file(outfile, "noClosingGU", 0, 0 );
  if (args_info->nsp_given)
    write_into_file(outfile, "nsp", args_info->nsp_orig, 0);
  if (args_info->energyModel_given)
    write_into_file(outfile, "energyModel", args_info->energyModel_orig, 0);
  if (args_info->helical_rise_given)
    write_into_file(outfile, "helical-rise", args_info->helical_rise_orig, 0);
  if (args_info->backbone_length_given)
    write_into_file(outfile, "backbone-length", args_info->backbone_length_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
RNAmultifold_cmdline_parser_file_save(const char *filename, struct RNAmultifold_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", RNAMULTIFOLD_CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = RNAmultifold_cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
RNAmultifold_cmdline_parser_free (struct RNAmultifold_args_info *args_info)
{
  RNAmultifold_cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
RNAmultifold_cmdline_parser (int argc, char **argv, struct RNAmultifold_args_info *args_info)
{
  return RNAmultifold_cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
RNAmultifold_cmdline_parser_ext (int argc, char **argv, struct RNAmultifold_args_info *args_info,
                   struct RNAmultifold_cmdline_parser_params *params)
{
  int result;
  result = RNAmultifold_cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAmultifold_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAmultifold_cmdline_parser2 (int argc, char **argv, struct RNAmultifold_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct RNAmultifold_cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = RNAmultifold_cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAmultifold_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAmultifold_cmdline_parser_required (struct RNAmultifold_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (RNAmultifold_cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      RNAmultifold_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAmultifold_cmdline_parser_required2 (struct RNAmultifold_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  
  /* checks for dependences among options */
  if (args_info->unordered_given && ! args_info->jobs_given)
    {
      fprintf (stderr, "%s: '--unordered' option depends on option 'jobs'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->absolute_concentrations_given && ! args_info->concentrations_given)
    {
      fprintf (stderr, "%s: '--absolute-concentrations' option depends on option 'concentrations'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->betaScale_given && ! args_info->partfunc_given)
    {
      fprintf (stderr, "%s: '--betaScale' option depends on option 'partfunc'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }

  return error_occurred;
}

/*
 * Extracted from the glibc source tree, version 2.3.6
 *
 * Licensed under the GPL as per the whole glibc source tree.
 *
 * This file was modified so that getopt_long can be called
 * many times without risking previous memory to be spoiled.
 *
 * Modified by Andre Noll and Lorenzo Bettini for use in
 * GNU gengetopt generated files.
 *
 */

/* 
 * we must include anything we need since this file is not thought to be
 * inserted in a file already using getopt.h
 *
 * Lorenzo
 */

struct option
{
  const char *name;
  /* has_arg can't be an enum because some compilers complain about
     type mismatches in all the code that assumes it is an int.  */
  int has_arg;
  int *flag;
  int val;
};

/* This version of `getopt' appears to the caller like standard Unix `getopt'
   but it behaves differently for the user, since it allows the user
   to intersperse the options with the other arguments.

   As `getopt' works, it permutes the elements of ARGV so that,
   when it is done, all the options precede everything else.  Thus
   all application programs are extended to handle flexible argument order.
*/
/*
   If the field `flag' is not NULL, it points to a variable that is set
   to the value given in the field `val' when the option is found, but
   left unchanged if the option is not found.

   To have a long-named option do something other than set an `int' to
   a compiled-in constant, such as set a value from `custom_optarg', set the
   option's `flag' field to zero and its `val' field to a nonzero
   value (the equivalent single-letter option character, if there is
   one).  For long options that have a zero `flag' field, `getopt'
   returns the contents of the `val' field.  */

/* Names for the values of the `has_arg' field of `struct option'.  */
#ifndef no_argument
#define no_argument		0
#endif

#ifndef required_argument
#define required_argument	1
#endif

#ifndef optional_argument
#define optional_argument	2
#endif

struct custom_getopt_data {
	/*
	 * These have exactly the same meaning as the corresponding global variables,
	 * except that they are used for the reentrant versions of getopt.
	 */
	int custom_optind;
	int custom_opterr;
	int custom_optopt;
	char *custom_optarg;

	/* True if the internal members have been initialized.  */
	int initialized;

	/*
	 * The next char to be scanned in the option-element in which the last option
	 * character we returned was found.  This allows us to pick up the scan where
	 * we left off.  If this is zero, or a null string, it means resume the scan by
	 * advancing to the next ARGV-element.
	 */
	char *nextchar;

	/*
	 * Describe the part of ARGV that contains non-options that have been skipped.
	 * `first_nonopt' is the index in ARGV of the first of them; `last_nonopt' is
	 * the index after the last of them.
	 */
	int first_nonopt;
	int last_nonopt;
};

/*
 * the variables optarg, optind, opterr and optopt are renamed with
 * the custom_ prefix so that they don't interfere with getopt ones.
 *
 * Moreover they're static so they are visible only from within the
 * file where this very file will be included.
 */

/*
 * For communication from `custom_getopt' to the caller.  When `custom_getopt' finds an
 * option that takes an argument, the argument value is returned here.
 */
static char *custom_optarg;

/*
 * Index in ARGV of the next element to be scanned.  This is used for
 * communication to and from the caller and for communication between
 * successive calls to `custom_getopt'.
 *
 * On entry to `custom_getopt', 1 means this is the first call; initialize.
 *
 * When `custom_getopt' returns -1, this is the index of the first of the non-option
 * elements that the caller should itself scan.
 *
 * Otherwise, `custom_optind' communicates from one call to the next how much of ARGV
 * has been scanned so far.
 *
 * 1003.2 says this must be 1 before any call.
 */
static int custom_optind = 1;

/*
 * Callers store zero here to inhibit the error message for unrecognized
 * options.
 */
static int custom_opterr = 1;

/*
 * Set to an option character which was unrecognized.  This must be initialized
 * on some systems to avoid linking in the system's own getopt implementation.
 */
static int custom_optopt = '?';

/*
 * Exchange two adjacent subsequences of ARGV.  One subsequence is elements
 * [first_nonopt,last_nonopt) which contains all the non-options that have been
 * skipped so far.  The other is elements [last_nonopt,custom_optind), which contains
 * all the options processed since those non-options were skipped.
 * `first_nonopt' and `last_nonopt' are relocated so that they describe the new
 * indices of the non-options in ARGV after they are moved.
 */
static void exchange(char **argv, struct custom_getopt_data *d)
{
	int bottom = d->first_nonopt;
	int middle = d->last_nonopt;
	int top = d->custom_optind;
	char *tem;

	/*
	 * Exchange the shorter segment with the far end of the longer segment.
	 * That puts the shorter segment into the right place.  It leaves the
	 * longer segment in the right place overall, but it consists of two
	 * parts that need to be swapped next.
	 */
	while (top > middle && middle > bottom) {
		if (top - middle > middle - bottom) {
			/* Bottom segment is the short one.  */
			int len = middle - bottom;
			int i;

			/* Swap it with the top part of the top segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] =
					argv[top - (middle - bottom) + i];
				argv[top - (middle - bottom) + i] = tem;
			}
			/* Exclude the moved bottom segment from further swapping.  */
			top -= len;
		} else {
			/* Top segment is the short one.  */
			int len = top - middle;
			int i;

			/* Swap it with the bottom part of the bottom segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] = argv[middle + i];
				argv[middle + i] = tem;
			}
			/* Exclude the moved top segment from further swapping.  */
			bottom += len;
		}
	}
	/* Update records for the slots the non-options now occupy.  */
	d->first_nonopt += (d->custom_optind - d->last_nonopt);
	d->last_nonopt = d->custom_optind;
}

/* Initialize the internal data when the first call is made.  */
static void custom_getopt_initialize(struct custom_getopt_data *d)
{
	/*
	 * Start processing options with ARGV-element 1 (since ARGV-element 0
	 * is the program name); the sequence of previously skipped non-option
	 * ARGV-elements is empty.
	 */
	d->first_nonopt = d->last_nonopt = d->custom_optind;
	d->nextchar = NULL;
	d->initialized = 1;
}

#define NONOPTION_P (argv[d->custom_optind][0] != '-' || argv[d->custom_optind][1] == '\0')

/* return: zero: continue, nonzero: return given value to user */
static int shuffle_argv(int argc, char *const *argv,const struct option *longopts,
	struct custom_getopt_data *d)
{
	/*
	 * Give FIRST_NONOPT & LAST_NONOPT rational values if CUSTOM_OPTIND has been
	 * moved back by the user (who may also have changed the arguments).
	 */
	if (d->last_nonopt > d->custom_optind)
		d->last_nonopt = d->custom_optind;
	if (d->first_nonopt > d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * If we have just processed some options following some
	 * non-options, exchange them so that the options come first.
	 */
	if (d->first_nonopt != d->last_nonopt &&
			d->last_nonopt != d->custom_optind)
		exchange((char **) argv, d);
	else if (d->last_nonopt != d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * Skip any additional non-options and extend the range of
	 * non-options previously skipped.
	 */
	while (d->custom_optind < argc && NONOPTION_P)
		d->custom_optind++;
	d->last_nonopt = d->custom_optind;
	/*
	 * The special ARGV-element `--' means premature end of options.  Skip
	 * it like a null option, then exchange with previous non-options as if
	 * it were an option, then skip everything else like a non-option.
	 */
	if (d->custom_optind != argc && !strcmp(argv[d->custom_optind], "--")) {
		d->custom_optind++;
		if (d->first_nonopt != d->last_nonopt
				&& d->last_nonopt != d->custom_optind)
			exchange((char **) argv, d);
		else if (d->first_nonopt == d->last_nonopt)
			d->first_nonopt = d->custom_optind;
		d->last_nonopt = argc;
		d->custom_optind = argc;
	}
	/*
	 * If we have done all the ARGV-elements, stop the scan and back over
	 * any non-options that we skipped and permuted.
	 */
	if (d->custom_optind == argc) {
		/*
		 * Set the next-arg-index to point at the non-options that we
		 * previously skipped, so the caller will digest them.
		 */
		if (d->first_nonopt != d->last_nonopt)
			d->custom_optind = d->first_nonopt;
		return -1;
	}
	/*
	 * If we have come to a non-option and did not permute it, either stop
	 * the scan or describe it to the caller and pass it by.
	 */
	if (NONOPTION_P) {
		d->custom_optarg = argv[d->custom_optind++];
		return 1;
	}
	/*
	 * We have found another option-ARGV-element. Skip the initial
	 * punctuation.
	 */
	d->nextchar = (argv[d->custom_optind] + 1 + (longopts != NULL && argv[d->custom_optind][1] == '-'));
	return 0;
}

/*
 * Check whether the ARGV-element is a long option.
 *
 * If there's a long option "fubar" and the ARGV-element is "-fu", consider
 * that an abbreviation of the long option, just like "--fu", and not "-f" with
 * arg "u".
 *
 * This distinction seems to be the most useful approach.
 *
 */
static int check_long_opt(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		int print_errors, struct custom_getopt_data *d)
{
	char *nameend;
	const struct option *p;
	const struct option *pfound = NULL;
	int exact = 0;
	int ambig = 0;
	int indfound = -1;
	int option_index;

	for (nameend = d->nextchar; *nameend && *nameend != '='; nameend++)
		/* Do nothing.  */ ;

	/* Test all long options for either exact match or abbreviated matches */
	for (p = longopts, option_index = 0; p->name; p++, option_index++)
		if (!strncmp(p->name, d->nextchar, nameend - d->nextchar)) {
			if ((unsigned int) (nameend - d->nextchar)
					== (unsigned int) strlen(p->name)) {
				/* Exact match found.  */
				pfound = p;
				indfound = option_index;
				exact = 1;
				break;
			} else if (pfound == NULL) {
				/* First nonexact match found.  */
				pfound = p;
				indfound = option_index;
			} else if (pfound->has_arg != p->has_arg
					|| pfound->flag != p->flag
					|| pfound->val != p->val)
				/* Second or later nonexact match found.  */
				ambig = 1;
		}
	if (ambig && !exact) {
		if (print_errors) {
			fprintf(stderr,
				"%s: option `%s' is ambiguous\n",
				argv[0], argv[d->custom_optind]);
		}
		d->nextchar += strlen(d->nextchar);
		d->custom_optind++;
		d->custom_optopt = 0;
		return '?';
	}
	if (pfound) {
		option_index = indfound;
		d->custom_optind++;
		if (*nameend) {
			if (pfound->has_arg != no_argument)
				d->custom_optarg = nameend + 1;
			else {
				if (print_errors) {
					if (argv[d->custom_optind - 1][1] == '-') {
						/* --option */
						fprintf(stderr, "%s: option `--%s' doesn't allow an argument\n",
							argv[0], pfound->name);
					} else {
						/* +option or -option */
						fprintf(stderr, "%s: option `%c%s' doesn't allow an argument\n",
							argv[0], argv[d->custom_optind - 1][0], pfound->name);
					}

				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return '?';
			}
		} else if (pfound->has_arg == required_argument) {
			if (d->custom_optind < argc)
				d->custom_optarg = argv[d->custom_optind++];
			else {
				if (print_errors) {
					fprintf(stderr,
						"%s: option `%s' requires an argument\n",
						argv[0],
						argv[d->custom_optind - 1]);
				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return optstring[0] == ':' ? ':' : '?';
			}
		}
		d->nextchar += strlen(d->nextchar);
		if (longind != NULL)
			*longind = option_index;
		if (pfound->flag) {
			*(pfound->flag) = pfound->val;
			return 0;
		}
		return pfound->val;
	}
	/*
	 * Can't find it as a long option.  If this is not getopt_long_only, or
	 * the option starts with '--' or is not a valid short option, then
	 * it's an error.  Otherwise interpret it as a short option.
	 */
	if (print_errors) {
		if (argv[d->custom_optind][1] == '-') {
			/* --option */
			fprintf(stderr,
				"%s: unrecognized option `--%s'\n",
				argv[0], d->nextchar);
		} else {
			/* +option or -option */
			fprintf(stderr,
				"%s: unrecognized option `%c%s'\n",
				argv[0], argv[d->custom_optind][0],
				d->nextchar);
		}
	}
	d->nextchar = (char *) "";
	d->custom_optind++;
	d->custom_optopt = 0;
	return '?';
}

static int check_short_opt(int argc, char *const *argv, const char *optstring,
		int print_errors, struct custom_getopt_data *d)
{
	char c = *d->nextchar++;
	const char *temp = strchr(optstring, c);

	/* Increment `custom_optind' when we start to process its last character.  */
	if (*d->nextchar == '\0')
		++d->custom_optind;
	if (!temp || c == ':') {
		if (print_errors)
			fprintf(stderr, "%s: invalid option -- %c\n", argv[0], c);

		d->custom_optopt = c;
		return '?';
	}
	if (temp[1] == ':') {
		if (temp[2] == ':') {
			/* This is an option that accepts an argument optionally.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				d->custom_optind++;
			} else
				d->custom_optarg = NULL;
			d->nextchar = NULL;
		} else {
			/* This is an option that requires an argument.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				/*
				 * If we end this ARGV-element by taking the
				 * rest as an arg, we must advance to the next
				 * element now.
				 */
				d->custom_optind++;
			} else if (d->custom_optind == argc) {
				if (print_errors) {
					fprintf(stderr,
						"%s: option requires an argument -- %c\n",
						argv[0], c);
				}
				d->custom_optopt = c;
				if (optstring[0] == ':')
					c = ':';
				else
					c = '?';
			} else
				/*
				 * We already incremented `custom_optind' once;
				 * increment it again when taking next ARGV-elt
				 * as argument.
				 */
				d->custom_optarg = argv[d->custom_optind++];
			d->nextchar = NULL;
		}
	}
	return c;
}

/*
 * Scan elements of ARGV for option characters given in OPTSTRING.
 *
 * If an element of ARGV starts with '-', and is not exactly "-" or "--",
 * then it is an option element.  The characters of this element
 * (aside from the initial '-') are option characters.  If `getopt'
 * is called repeatedly, it returns successively each of the option characters
 * from each of the option elements.
 *
 * If `getopt' finds another option character, it returns that character,
 * updating `custom_optind' and `nextchar' so that the next call to `getopt' can
 * resume the scan with the following option character or ARGV-element.
 *
 * If there are no more option characters, `getopt' returns -1.
 * Then `custom_optind' is the index in ARGV of the first ARGV-element
 * that is not an option.  (The ARGV-elements have been permuted
 * so that those that are not options now come last.)
 *
 * OPTSTRING is a string containing the legitimate option characters.
 * If an option character is seen that is not listed in OPTSTRING,
 * return '?' after printing an error message.  If you set `custom_opterr' to
 * zero, the error message is suppressed but we still return '?'.
 *
 * If a char in OPTSTRING is followed by a colon, that means it wants an arg,
 * so the following text in the same ARGV-element, or the text of the following
 * ARGV-element, is returned in `custom_optarg'.  Two colons mean an option that
 * wants an optional arg; if there is text in the current ARGV-element,
 * it is returned in `custom_optarg', otherwise `custom_optarg' is set to zero.
 *
 * If OPTSTRING starts with `-' or `+', it requests different methods of
 * handling the non-option ARGV-elements.
 * See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.
 *
 * Long-named options begin with `--' instead of `-'.
 * Their names may be abbreviated as long as the abbreviation is unique
 * or is an exact match for some defined option.  If they have an
 * argument, it follows the option name in the same ARGV-element, separated
 * from the option name by a `=', or else the in next ARGV-element.
 * When `getopt' finds a long-named option, it returns 0 if that option's
 * `flag' field is nonzero, the value of the option's `val' field
 * if the `flag' field is zero.
 *
 * The elements of ARGV aren't really const, because we permute them.
 * But we pretend they're const in the prototype to be compatible
 * with other systems.
 *
 * LONGOPTS is a vector of `struct option' terminated by an
 * element containing a name which is zero.
 *
 * LONGIND returns the index in LONGOPT of the long-named option found.
 * It is only valid when a long-named option has been found by the most
 * recent call.
 *
 * Return the option character from OPTS just read.  Return -1 when there are
 * no more options.  For unrecognized options, or options missing arguments,
 * `custom_optopt' is set to the option letter, and '?' is returned.
 *
 * The OPTS string is a list of characters which are recognized option letters,
 * optionally followed by colons, specifying that that letter takes an
 * argument, to be placed in `custom_optarg'.
 *
 * If a letter in OPTS is followed by two colons, its argument is optional.
 * This behavior is specific to the GNU `getopt'.
 *
 * The argument `--' causes premature termination of argument scanning,
 * explicitly telling `getopt' that there are no more options.  If OPTS begins
 * with `--', then non-option arguments are treated as arguments to the option
 * '\0'.  This behavior is specific to the GNU `getopt'.
 */

static int getopt_internal_r(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		struct custom_getopt_data *d)
{
	int ret, print_errors = d->custom_opterr;

	if (optstring[0] == ':')
		print_errors = 0;
	if (argc < 1)
		return -1;
	d->custom_optarg = NULL;

	/* 
	 * This is a big difference with GNU getopt, since optind == 0
	 * means initialization while here 1 means first call.
	 */
	if (d->custom_optind == 0 || !d->initialized) {
		if (d->custom_optind == 0)
			d->custom_optind = 1;	/* Don't scan ARGV[0], the program name.  */
		custom_getopt_initialize(d);
	}
	if (d->nextchar == NULL || *d->nextchar == '\0') {
		ret = shuffle_argv(argc, argv, longopts, d);
		if (ret)
			return ret;
	}
	if (longopts && (argv[d->custom_optind][1] == '-' ))
		return check_long_opt(argc, argv, optstring, longopts,
			longind, print_errors, d);
	return check_short_opt(argc, argv, optstring, print_errors, d);
}

static int custom_getopt_internal(int argc, char *const *argv, const char *optstring,
	const struct option *longopts, int *longind)
{
	int result;
	/* Keep a global copy of all internal members of d */
	static struct custom_getopt_data d;

	d.custom_optind = custom_optind;
	d.custom_opterr = custom_opterr;
	result = getopt_internal_r(argc, argv, optstring, longopts,
		longind, &d);
	custom_optind = d.custom_optind;
	custom_optarg = d.custom_optarg;
	custom_optopt = d.custom_optopt;
	return result;
}

static int custom_getopt_long (int argc, char *const *argv, const char *options,
	const struct option *long_options, int *opt_index)
{
	return custom_getopt_internal(argc, argv, options, long_options,
		opt_index);
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see RNAmultifold_cmdline_parser_params.check_ambiguity
 * @param override @see RNAmultifold_cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               RNAmultifold_cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_LONG:
    if (val) *((long *)field) = (long)strtol (val, &stop_char, 0);
    break;
  case ARG_FLOAT:
    if (val) *((float *)field) = (float)strtod (val, &stop_char);
    break;
  case ARG_DOUBLE:
    if (val) *((double *)field) = strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_LONG:
  case ARG_FLOAT:
  case ARG_DOUBLE:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
RNAmultifold_cmdline_parser_internal (
  int argc, char **argv, struct RNAmultifold_args_info *args_info,
                        struct RNAmultifold_cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct RNAmultifold_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;

  char *optarg;
  int optind;
  int opterr;
  int optopt;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    RNAmultifold_cmdline_parser_init (args_info);

  RNAmultifold_cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "detailed-help",	0, NULL, 0 },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "verbose",	0, NULL, 'v' },
        { "jobs",	2, NULL, 'j' },
        { "unordered",	0, NULL, 0 },
        { "noconv",	0, NULL, 0 },
        { "auto-id",	0, NULL, 0 },
        { "id-prefix",	1, NULL, 0 },
        { "id-delim",	1, NULL, 0 },
        { "id-digits",	1, NULL, 0 },
        { "id-start",	1, NULL, 0 },
        { "filename-delim",	1, NULL, 0 },
        { "filename-full",	0, NULL, 0 },
        { "log-level",	1, NULL, 0 },
        { "log-file",	2, NULL, 0 },
        { "log-time",	0, NULL, 0 },
        { "log-call",	0, NULL, 0 },
        { "partfunc",	2, NULL, 'p' },
        { "all_pf",	2, NULL, 'a' },
        { "concentrations",	0, NULL, 'c' },
        { "concfile",	1, NULL, 'f' },
        { "absolute-concentrations",	0, NULL, 0 },
        { "betaScale",	1, NULL, 0 },
        { "pfScale",	1, NULL, 'S' },
        { "bppmThreshold",	1, NULL, 0 },
        { "gquad",	0, NULL, 'g' },
        { "maxBPspan",	1, NULL, 0 },
        { "commands",	1, NULL, 0 },
        { "temp",	1, NULL, 'T' },
        { "paramFile",	1, NULL, 'P' },
        { "noTetra",	0, NULL, '4' },
        { "salt",	1, NULL, 0 },
        { "dangles",	1, NULL, 'd' },
        { "noLP",	0, NULL, 0 },
        { "noGU",	0, NULL, 0 },
        { "noClosingGU",	0, NULL, 0 },
        { "nsp",	1, NULL, 0 },
        { "energyModel",	1, NULL, 0 },
        { "helical-rise",	1, NULL, 0 },
        { "backbone-length",	1, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      custom_optarg = optarg;
      custom_optind = optind;
      custom_opterr = opterr;
      custom_optopt = optopt;

      c = custom_getopt_long (argc, argv, "hVvj::p::a::cf:S:gT:P:4d:", long_options, &option_index);

      optarg = custom_optarg;
      optind = custom_optind;
      opterr = custom_opterr;
      optopt = custom_optopt;

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          RNAmultifold_cmdline_parser_print_help ();
          RNAmultifold_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          RNAmultifold_cmdline_parser_print_version ();
          RNAmultifold_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'v':	/* Be verbose.
.  */
        
        
          if (update_arg((void *)&(args_info->verbose_flag), 0, &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "verbose", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'j':	/* Split batch input into jobs and start processing in parallel using multiple threads. A value of 0 indicates to use as many parallel threads as computation cores are available.
.  */
        
        
          if (update_arg( (void *)&(args_info->jobs_arg), 
               &(args_info->jobs_orig), &(args_info->jobs_given),
              &(local_args_info.jobs_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "jobs", 'j',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* Calculate the partition function and base pairing probability matrix in addition to the MFE structure. Default is calculation of mfe structure only.
.  */
        
        
          if (update_arg( (void *)&(args_info->partfunc_arg), 
               &(args_info->partfunc_orig), &(args_info->partfunc_given),
              &(local_args_info.partfunc_given), optarg, 0, "1", ARG_INT,
              check_ambiguity, override, 0, 0,
              "partfunc", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'a':	/* Compute the partition function and free energies not only for the complex formed by the input sequences (the \"ABC... mutimer\"), but also of all complexes formed by the input sequences up to the number of input sequences, e.g. AAA, AAB, ABB, BBB, etc.
.  */
        
        
          if (update_arg( (void *)&(args_info->all_pf_arg), 
               &(args_info->all_pf_orig), &(args_info->all_pf_given),
              &(local_args_info.all_pf_given), optarg, 0, "1", ARG_INT,
              check_ambiguity, override, 0, 0,
              "all_pf", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* In addition to everything listed under the -a option, read in initial monomer concentrations and compute the expected equilibrium concentrations of all possible species (A, B, AA, BB, AB, etc).
.  */
        
        
          if (update_arg((void *)&(args_info->concentrations_flag), 0, &(args_info->concentrations_given),
              &(local_args_info.concentrations_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "concentrations", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* Specify a file with initial concentrations for the input sequences..  */
        
        
          if (update_arg( (void *)&(args_info->concfile_arg), 
               &(args_info->concfile_orig), &(args_info->concfile_given),
              &(local_args_info.concfile_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "concfile", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* In the calculation of the pf use scale*mfe as an estimate for the ensemble free energy (used to avoid overflows).
.  */
        
        
          if (update_arg( (void *)&(args_info->pfScale_arg), 
               &(args_info->pfScale_orig), &(args_info->pfScale_given),
              &(local_args_info.pfScale_given), optarg, 0, "1.07", ARG_DOUBLE,
              check_ambiguity, override, 0, 0,
              "pfScale", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'g':	/* Incoorporate G-Quadruplex formation into the structure prediction algorithm.
.  */
        
        
          if (update_arg((void *)&(args_info->gquad_flag), 0, &(args_info->gquad_given),
              &(local_args_info.gquad_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "gquad", 'g',
              additional_error))
            goto failure;
        
          break;
        case 'T':	/* Rescale energy parameters to a temperature of temp C. Default is 37C.
        
.  */
        
        
          if (update_arg( (void *)&(args_info->temp_arg), 
               &(args_info->temp_orig), &(args_info->temp_given),
              &(local_args_info.temp_given), optarg, 0, "37.0", ARG_DOUBLE,
              check_ambiguity, override, 0, 0,
              "temp", 'T',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Read energy parameters from paramfile, instead of using the default parameter set.
.  */
        
        
          if (update_arg( (void *)&(args_info->paramFile_arg), 
               &(args_info->paramFile_orig), &(args_info->paramFile_given),
              &(local_args_info.paramFile_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "paramFile", 'P',
              additional_error))
            goto failure;
        
          break;
        case '4':	/* Do not include special tabulated stabilizing energies for tri-, tetra- and hexaloop hairpins.
.  */
        
        
          if (update_arg((void *)&(args_info->noTetra_flag), 0, &(args_info->noTetra_given),
              &(local_args_info.noTetra_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "noTetra", '4',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops.
.  */
        
        
          if (update_arg( (void *)&(args_info->dangles_arg), 
               &(args_info->dangles_orig), &(args_info->dangles_given),
              &(local_args_info.dangles_given), optarg, 0, "2", ARG_INT,
              check_ambiguity, override, 0, 0,
              "dangles", 'd',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "detailed-help") == 0) {
            RNAmultifold_cmdline_parser_print_detailed_help ();
            RNAmultifold_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            RNAmultifold_cmdline_parser_print_full_help ();
            RNAmultifold_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* Do not try to keep output in order with input while parallel processing is in place.
.  */
          if (strcmp (long_options[option_index].name, "unordered") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->unordered_flag), 0, &(args_info->unordered_given),
                &(local_args_info.unordered_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "unordered", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not automatically substitute nucleotide \"T\" with \"U\".
          
.  */
          else if (strcmp (long_options[option_index].name, "noconv") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noconv_flag), 0, &(args_info->noconv_given),
                &(local_args_info.noconv_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noconv", '-',
                additional_error))
              goto failure;
          
          }
          /* Automatically generate an ID for each sequence.
.  */
          else if (strcmp (long_options[option_index].name, "auto-id") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->auto_id_flag), 0, &(args_info->auto_id_given),
                &(local_args_info.auto_id_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "auto-id", '-',
                additional_error))
              goto failure;
          
          }
          /* Prefix for automatically generated IDs (as used in output file names).
.  */
          else if (strcmp (long_options[option_index].name, "id-prefix") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_prefix_arg), 
                 &(args_info->id_prefix_orig), &(args_info->id_prefix_given),
                &(local_args_info.id_prefix_given), optarg, 0, "sequence", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "id-prefix", '-',
                additional_error))
              goto failure;
          
          }
          /* Change the delimiter between prefix and increasing number for automatically generated IDs (as used in output file names).
.  */
          else if (strcmp (long_options[option_index].name, "id-delim") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_delim_arg), 
                 &(args_info->id_delim_orig), &(args_info->id_delim_given),
                &(local_args_info.id_delim_given), optarg, 0, "_", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "id-delim", '-',
                additional_error))
              goto failure;
          
          }
          /* Specify the number of digits of the counter in automatically generated alignment IDs.
.  */
          else if (strcmp (long_options[option_index].name, "id-digits") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_digits_arg), 
                 &(args_info->id_digits_orig), &(args_info->id_digits_given),
                &(local_args_info.id_digits_given), optarg, 0, "4", ARG_INT,
                check_ambiguity, override, 0, 0,
                "id-digits", '-',
                additional_error))
              goto failure;
          
          }
          /* Specify the first number in automatically generated IDs.
.  */
          else if (strcmp (long_options[option_index].name, "id-start") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_start_arg), 
                 &(args_info->id_start_orig), &(args_info->id_start_given),
                &(local_args_info.id_start_given), optarg, 0, "1", ARG_LONG,
                check_ambiguity, override, 0, 0,
                "id-start", '-',
                additional_error))
              goto failure;
          
          }
          /* Change the delimiting character used in sanitized filenames.
.  */
          else if (strcmp (long_options[option_index].name, "filename-delim") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->filename_delim_arg), 
                 &(args_info->filename_delim_orig), &(args_info->filename_delim_given),
                &(local_args_info.filename_delim_given), optarg, 0, "ID-delimiter", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "filename-delim", '-',
                additional_error))
              goto failure;
          
          }
          /* Use full FASTA header to create filenames.
.  */
          else if (strcmp (long_options[option_index].name, "filename-full") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->filename_full_flag), 0, &(args_info->filename_full_given),
                &(local_args_info.filename_full_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "filename-full", '-',
                additional_error))
              goto failure;
          
          }
          /* Set log level threshold.
.  */
          else if (strcmp (long_options[option_index].name, "log-level") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->log_level_arg), 
                 &(args_info->log_level_orig), &(args_info->log_level_given),
                &(local_args_info.log_level_given), optarg, 0, "2", ARG_INT,
                check_ambiguity, override, 0, 0,
                "log-level", '-',
                additional_error))
              goto failure;
          
          }
          /* Print log messages to a file instead of stderr.
.  */
          else if (strcmp (long_options[option_index].name, "log-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->log_file_arg), 
                 &(args_info->log_file_orig), &(args_info->log_file_given),
                &(local_args_info.log_file_given), optarg, 0, "RNAmultifold.log", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "log-file", '-',
                additional_error))
              goto failure;
          
          }
          /* Include time stamp in log messages.
          
.  */
          else if (strcmp (long_options[option_index].name, "log-time") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->log_time_flag), 0, &(args_info->log_time_given),
                &(local_args_info.log_time_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "log-time", '-',
                additional_error))
              goto failure;
          
          }
          /* Include file and line of log calling function.
          
.  */
          else if (strcmp (long_options[option_index].name, "log-call") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->log_call_flag), 0, &(args_info->log_call_given),
                &(local_args_info.log_call_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "log-call", '-',
                additional_error))
              goto failure;
          
          }
          /* Report absolute instead of relative concentrations
          
.  */
          else if (strcmp (long_options[option_index].name, "absolute-concentrations") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->absolute_concentrations_flag), 0, &(args_info->absolute_concentrations_given),
                &(local_args_info.absolute_concentrations_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "absolute-concentrations", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the scaling of the Boltzmann factors.
.  */
          else if (strcmp (long_options[option_index].name, "betaScale") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->betaScale_arg), 
                 &(args_info->betaScale_orig), &(args_info->betaScale_given),
                &(local_args_info.betaScale_given), optarg, 0, "1.", ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "betaScale", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the threshold/cutoff for base pair probabilities included in the postscript output.
          
.  */
          else if (strcmp (long_options[option_index].name, "bppmThreshold") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->bppmThreshold_arg), 
                 &(args_info->bppmThreshold_orig), &(args_info->bppmThreshold_given),
                &(local_args_info.bppmThreshold_given), optarg, 0, "1e-5", ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "bppmThreshold", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the maximum base pair span.
          
.  */
          else if (strcmp (long_options[option_index].name, "maxBPspan") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->maxBPspan_arg), 
                 &(args_info->maxBPspan_orig), &(args_info->maxBPspan_given),
                &(local_args_info.maxBPspan_given), optarg, 0, "-1", ARG_INT,
                check_ambiguity, override, 0, 0,
                "maxBPspan", '-',
                additional_error))
              goto failure;
          
          }
          /* Read additional commands from file
.  */
          else if (strcmp (long_options[option_index].name, "commands") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->commands_arg), 
                 &(args_info->commands_orig), &(args_info->commands_given),
                &(local_args_info.commands_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "commands", '-',
                additional_error))
              goto failure;
          
          }
          /* Set salt concentration in molar (M). Default is 1.021M.
          
.  */
          else if (strcmp (long_options[option_index].name, "salt") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->salt_arg), 
                 &(args_info->salt_orig), &(args_info->salt_given),
                &(local_args_info.salt_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "salt", '-',
                additional_error))
              goto failure;
          
          }
          /* Produce structures without lonely pairs (helices of length 1).
.  */
          else if (strcmp (long_options[option_index].name, "noLP") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noLP_flag), 0, &(args_info->noLP_given),
                &(local_args_info.noLP_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noLP", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not allow GU pairs.
          
.  */
          else if (strcmp (long_options[option_index].name, "noGU") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noGU_flag), 0, &(args_info->noGU_given),
                &(local_args_info.noGU_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noGU", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not allow GU pairs at the end of helices.
          
.  */
          else if (strcmp (long_options[option_index].name, "noClosingGU") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noClosingGU_flag), 0, &(args_info->noClosingGU_given),
                &(local_args_info.noClosingGU_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noClosingGU", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow other pairs in addition to the usual AU,GC,and GU pairs.
.  */
          else if (strcmp (long_options[option_index].name, "nsp") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->nsp_arg), 
                 &(args_info->nsp_orig), &(args_info->nsp_given),
                &(local_args_info.nsp_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "nsp", '-',
                additional_error))
              goto failure;
          
          }
          /* Set energy model.
.  */
          else if (strcmp (long_options[option_index].name, "energyModel") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->energyModel_arg), 
                 &(args_info->energyModel_orig), &(args_info->energyModel_given),
                &(local_args_info.energyModel_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "energyModel", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the helical rise of the helix in units of Angstrom.
.  */
          else if (strcmp (long_options[option_index].name, "helical-rise") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->helical_rise_arg), 
                 &(args_info->helical_rise_orig), &(args_info->helical_rise_given),
                &(local_args_info.helical_rise_given), optarg, 0, "2.8", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "helical-rise", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the average backbone length for looped regions in units of Angstrom.
.  */
          else if (strcmp (long_options[option_index].name, "backbone-length") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->backbone_length_arg), 
                 &(args_info->backbone_length_orig), &(args_info->backbone_length_given),
                &(local_args_info.backbone_length_given), optarg, 0, "6.0", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "backbone-length", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", RNAMULTIFOLD_CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
      error_occurred += RNAmultifold_cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  RNAmultifold_cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */


      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;
    }

  return 0;

failure:
  
  RNAmultifold_cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
