[comment {-*- tcl -*- doctools manpage}]
[manpage_begin docidx_intro n 1.0]
[see_also docidx_lang_cmdref]
[see_also docidx_lang_faq]
[see_also docidx_lang_intro]
[see_also docidx_lang_syntax]
[see_also docidx_plugin_apiref]
[see_also doctoc_intro]
[see_also doctools::idx]
[see_also doctools_intro]
[keywords index]
[keywords {keyword index}]
[keywords markup]
[keywords {semantic markup}]
[copyright {2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Documentation tools}]
[titledesc {docidx introduction}]
[category  {Documentation tools}]
[description]
[para]

[term docidx] (short for [emph {documentation tables of contents}])
stands for a set of related, yet different, entities which are working
together for the easy creation and transformation of keyword-based
indices for documentation. These are

[list_begin enumerated]
[enum]

A tcl based language for the semantic markup of a keyword index.
Markup is represented by Tcl commands.

[enum]

A package providing the ability to read and transform texts written in
that markup language. It is important to note that the actual
transformation of the input text is delegated to plugins.

[enum]

An API describing the interface between the package above and a
plugin.

[list_end]

[para]

Which of the more detailed documents are relevant to the reader of
this introduction depends on their role in the documentation process.

[para]

[list_begin enumerated]
[enum]
A [term writer] of documentation has to understand the markup language
itself. A beginner to docidx should read the more informally written
[term {docidx language introduction}] first. Having digested this
the formal [term {docidx language syntax}] specification should
become understandable. A writer experienced with docidx may only
need the [term {docidx language command reference}] from time to
time to refresh her memory.

[para]

While a document is written the [syscmd dtp] application can be used
to validate it, and after completion it also performs the conversion
into the chosen system of visual markup, be it *roff, HTML, plain
text, wiki, etc. The simpler [syscmd dtplite] application makes
internal use of docidx when handling directories of documentation,
automatically generating a proper keyword index for them.

[enum]
A [term processor] of documentation written in the [term docidx]
markup language has to know which tools are available for use.

[para]

The main tool is the aforementioned [syscmd dtp] application provided
by Tcllib. The simpler [syscmd dtplite] does not expose docidx to the
user.

At the bottom level, common to both applications, however sits the
package [package doctoools::idx], providing the basic facilities to
read and process files containing text in the docidx format.

[enum]
At last, but not least, [term {plugin writers}] have to understand the
interaction between the [package doctools::idx] package and its
plugins, as described in the [term {docidx plugin API reference}].

[list_end]

[section {RELATED FORMATS}]

docidx does not stand alone, it has two companion formats. These are
called [term doctoc] and [term doctools], and they are for the markup
of [term {tables of contents}], and general documentation,
respectively.

They are described in their own sets of documents, starting at the
[term {doctoc introduction}] and the [term {doctools introduction}],
respectively.

[vset CATEGORY doctools]
[include ../common-text/feedback.inc]
[manpage_end]
