
[//000000001]: # (math::filters \- Tcl Math Library)
[//000000002]: # (Generated from file 'filtergen\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (Copyright &copy; 2020 by Arjen Markus)
[//000000004]: # (math::filters\(n\) 0\.3 tcllib "Tcl Math Library")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

math::filters \- Digital filters

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [PROCEDURES](#section2)

  - [Keywords](#keywords)

  - [Category](#category)

  - [Copyright](#copyright)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.6 9  
package require TclOO  
package require math::filters ?0\.3?  

[__::math::filters::filterButterworth__ *lowpass* *order* *samplefreq* *cutofffreq*](#1)  
[__::math::filters::filter__ *coeffs* *data*](#2)  
[__::math::filters::filterObj__ new *coeffs* *yinit*](#3)  
[__$filterObj__ filter *x*](#4)  
[__$filterObj__ reset](#5)  

# <a name='description'></a>DESCRIPTION

The __math::filters__ package implements digital filters, notably
Butterworth low\-pass and high\-pass filters\. The procedures allow to filter an
entire data series as well as filter data one by one\.

# <a name='section2'></a>PROCEDURES

The package defines the following public procedures:

  - <a name='1'></a>__::math::filters::filterButterworth__ *lowpass* *order* *samplefreq* *cutofffreq*

    Determine the coefficients for a Butterworth filter of given order\. The
    coefficients are returned as a list of the x\-coefficients, the
    y\-coefficients and the scale\. The formula is \(n is the filter order\):

                       n             n
        scale * y_k = sum x_(k-i) + sum y_(k-i)
                      i=0           i=1

      * bool *lowpass*

        Generate a low\-pass filter \(1\) or a high\-pass filter \(0\)

      * integer *lowpass*

        The order of the filter to be generated

      * double *samplefreq*

        Sampling frequency of the data series

      * double *cutofffreq*

        Cut\-off frequency for the filter

  - <a name='2'></a>__::math::filters::filter__ *coeffs* *data*

    Filter the entire data series based on the filter coefficients\.

      * list *coeffs*

        List of coefficients as generated by *filterButterworth* \(or in fact
        any similar list of coefficients\)

      * list *data*

        Data to be filtered

  - <a name='3'></a>__::math::filters::filterObj__ new *coeffs* *yinit*

    Create a filter object\. The initial x data are taken as zero\. The initial y
    data can be prescribed\. If they are not given, they are taken as zero as
    well\.

      * list *coeffs*

        List of coefficients as generated by *filterButterworth* \(or in fact
        any similar list of coefficients\)

      * list *yinit*

        \(Optional\) initial data for the filter result\.

  - <a name='4'></a>__$filterObj__ filter *x*

    Filter a single value and return the result\.

      * double *x*

        The value to be filtered

  - <a name='5'></a>__$filterObj__ reset

    Reset the filter object \(start anew\)

# <a name='keywords'></a>KEYWORDS

[digital](\.\./\.\./\.\./\.\./index\.md\#digital),
[filtering](\.\./\.\./\.\./\.\./index\.md\#filtering)

# <a name='category'></a>CATEGORY

Mathematics

# <a name='copyright'></a>COPYRIGHT

Copyright &copy; 2020 by Arjen Markus
