###############################################################################
#                                                                             #
# Fireinfo                                                                    #
# Copyright (C) 2013 IPFire Team (www.ipfire.org)                             #
#                                                                             #
# This program is free software: you can redistribute it and/or modify        #
# it under the terms of the GNU General Public License as published by        #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# This program is distributed in the hope that it will be useful,             #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with this program.  If not, see <http://www.gnu.org/licenses/>.       #
#                                                                             #
###############################################################################

import os.path

DMI_VENDORS = [
	"/sys/class/dmi/id/sys_vendor",
	"/sys/class/dmi/id/board_vendor",
	"/sys/class/dmi/id/bios_vendor",
]

class BIOS(object):
	def __init__(self, system):
		self.system = system

	def check_vendor(self, vendor, startswith=True):
		for file in DMI_VENDORS:
			if not os.path.exists(file):
				continue

			with open(file, "r") as f:
				v = f.read()

			# Strip the vendor string.
			v = v.strip()

			if startswith and v.startswith(vendor):
				return True
			elif v == vendor:
				return True

		return False
