## Merchant Admin Frontend

The Merchant Admin Frontend is a Single Page Application (SPA) that connects with a running Taler Merchant Backend. It allows you to manage instances, orders, products, and tipping.

## System requirements

- Node: v16.15.0
- pnpm: 7.14.2
- make

## Compiling from source

Run `pnpm install --frozen-lockfile --filter @gnu-taler/merchant-backoffice...` to install all the nodejs dependencies.

Then, entering the command `pnpm build` creates the distribution in the `dist` folder.

By default, the installation prefix will be `/usr/local/share/taler/merchant-backoffice/` but it can be overridden by `--prefix` by the configuration process:

```shell
./configure --prefix=/another/directory
```

To install run `make install`

## Local testing

To have the Merchant SPA point to a different server, override the local storage:

```js
localStorage.setItem("merchant-base-url", "http://backend.taler.localhost:4321/");
```

## Running develop

In order to run a development server you will have to apply

```shell
./dev.mjs
```

This should start a watch process that will reload the server every time a file is saved.

The application needs to connect to a merchant-backend properly configured to run.

## Building for deploy

To build and deploy the SPA on your local server run the install script:

```shell
make install
```

## Runtime dependencies

*   preact: Fast 3kB alternative to React with the same modern API

*   preact-router: URL component router for Preact

*   SWR: React Hooks library for data fetching (stale-while-revalidate)

*   Yup: Schema builder for value parsing and validation (to be deprecated)

*   Date-fns: A library for manipulating javascript dates

*   qrcode-generator: Simplest QR-code implementation based on JIS X 0510:1999

*   @gnu-taler/taler-util: Types and tooling

*   history: Manage the history stack, navigate, and make states persist in between sessions

*   jed: gettext as a library for internationalization
