#!/bin/bash
set -exuo pipefail
# Update system
apt-get update -yq
apt-get upgrade -yq

# Build package
export VERSION="$(./contrib/ci/jobs/4-deb-package/version.sh)"
echo "Building package version ${VERSION}"
make deb

# Test package
sudo ./contrib/ci/deb-test.sh

# Move to artifact
ls -alh ../*.deb
mkdir -p /artifacts/libeufin/${CI_COMMIT_REF} # Variable comes from CI environment
mv ../*.deb /artifacts/libeufin/${CI_COMMIT_REF}/
