/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.Whitespace;

public class XSLStylesheet
extends StyleElement {
    PreparedStylesheet exec;
    private PrincipalStylesheetModule principalStylesheetModule;
    public static final int ANNOTATION_UNSPECIFIED = 0;
    public static final int ANNOTATION_STRIP = 1;
    public static final int ANNOTATION_PRESERVE = 2;
    private int defaultValidation = 4;
    private StructuredQName defaultMode = null;

    public PreparedStylesheet getPreparedStylesheet() {
        return this.principalStylesheetModule == null ? null : this.principalStylesheetModule.getPreparedStylesheet();
    }

    public void setPrincipalStylesheetModule(PrincipalStylesheetModule module) {
        this.principalStylesheetModule = module;
        this.exec = module.getPreparedStylesheet();
    }

    public PrincipalStylesheetModule getPrincipalStylesheetModule() {
        return this.principalStylesheetModule;
    }

    public PreparedStylesheet getExecutable() {
        return this.exec;
    }

    protected boolean mayContainParam(String attName) {
        return true;
    }

    public LocationMap getLocationMap() {
        return this.exec.getLocationMap();
    }

    public RuleManager getRuleManager() {
        return this.exec.getRuleManager();
    }

    public StructuredQName getDefaultMode() {
        return this.defaultMode;
    }

    public KeyManager getKeyManager() {
        if (this.exec.getKeyManager() == null) {
            this.exec.setKeyManager(new KeyManager(this.getConfiguration()));
        }
        return this.exec.getKeyManager();
    }

    public void prepareAttributes() throws XPathException {
        String inputTypeAnnotationsAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String val;
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("version") || f.equals("id") || f.equals("extension-element-prefixes") || f.equals("exclude-result-prefixes")) continue;
            if (f.equals("default-validation")) {
                val = Whitespace.trim(atts.getValue(a));
                this.defaultValidation = Validation.getCode(val);
                if (this.defaultValidation == -1) {
                    this.compileError("Invalid value for default-validation attribute. Permitted values are (strict, lax, preserve, strip)", "XTSE0020");
                    continue;
                }
                if (this.getExecutable().isSchemaAware() || this.defaultValidation == 4) continue;
                this.defaultValidation = 4;
                this.compileError("default-validation='" + val + "' requires a schema-aware processor", "XTSE1660");
                continue;
            }
            if (f.equals("input-type-annotations")) {
                inputTypeAnnotationsAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("default-mode")) {
                val = Whitespace.trim(atts.getValue(a));
                if (val.equals("#unnamed")) continue;
                try {
                    this.defaultMode = this.makeQName(atts.getValue(a));
                    continue;
                }
                catch (NamespaceException err) {
                    throw new XPathException(err.getMessage(), "XTST0030");
                }
            }
            this.checkUnknownAttribute(nc);
        }
        if (this.version == null) {
            this.reportAbsence("version");
        }
        if (!(inputTypeAnnotationsAtt == null || inputTypeAnnotationsAtt.equals("strip") || inputTypeAnnotationsAtt.equals("preserve") || inputTypeAnnotationsAtt.equals("unspecified"))) {
            this.compileError("Invalid value for input-type-annotations attribute. Permitted values are (strip, preserve, unspecified)", "XTSE0020");
        }
    }

    public int getDefaultValidation() {
        return this.defaultValidation;
    }

    public int getInputTypeAnnotationsAttribute() throws XPathException {
        String inputTypeAnnotationsAtt = this.getAttributeValue("", "input-type-annotations");
        if (inputTypeAnnotationsAtt != null) {
            if (inputTypeAnnotationsAtt.equals("strip")) {
                return 1;
            }
            if (inputTypeAnnotationsAtt.equals("preserve")) {
                return 2;
            }
            if (inputTypeAnnotationsAtt.equals("unspecified")) {
                return 0;
            }
            this.compileError("Invalid value for input-type-annotations attribute. Permitted values are (strip, preserve, unspecified)", "XTSE0020");
        }
        return -1;
    }

    public void validate(Declaration decl) throws XPathException {
        NodeInfo curr;
        if (this.validationError != null) {
            this.compileError(this.validationError);
        }
        if (this.getParent().getNodeKind() != 9) {
            this.compileError(this.getDisplayName() + " must be the outermost element", "XTSE0010");
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = (NodeInfo)kids.next()) != null) {
            if (curr.getNodeKind() == 3 || curr instanceof StyleElement && ((StyleElement)curr).isDeclaration() || curr instanceof DataElement || !"http://www.w3.org/1999/XSL/Transform".equals(curr.getURI()) && !"".equals(curr.getURI()) || curr instanceof AbsentExtensionElement && ((StyleElement)curr).forwardsCompatibleModeIsEnabled()) continue;
            if ("http://www.w3.org/1999/XSL/Transform".equals(curr.getURI())) {
                ((StyleElement)curr).compileError("Element " + curr.getDisplayName() + " must not appear directly within " + this.getDisplayName(), "XTSE0010");
                continue;
            }
            ((StyleElement)curr).compileError("Element " + curr.getDisplayName() + " must not appear directly within " + this.getDisplayName() + " because it is not in a namespace", "XTSE0130");
        }
    }

    public void processAllAttributes() throws XPathException {
        NodeInfo node;
        this.processDefaultCollationAttribute("");
        this.prepareAttributes();
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((node = (NodeInfo)iter.next()) != null) {
            if (!(node instanceof StyleElement)) continue;
            try {
                ((StyleElement)node).processAllAttributes();
            }
            catch (XPathException err) {
                ((StyleElement)node).compileError(err);
            }
        }
    }

    protected void index(Declaration decl, PrincipalStylesheetModule top) throws XPathException {
        this.compileError("xsl:stylesheet can appear only as the outermost element", "XTSE0010");
    }

    public Expression compile(Executable exec, Declaration decl) {
        return null;
    }
}

