// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace System.Text.RegularExpressions
{
    internal static partial class RegexCaseEquivalences
    {
        // THE FOLLOWING DATA IS AUTO GENERATED BY GenerateRegexCasingTable program UNDER THE TOOLS FOLDER
        // PLEASE DON'T MODIFY BY HAND
        // IF YOU NEED TO UPDATE UNICODE VERSION FOLLOW THE GUIDE AT src/libraries/System.Private.CoreLib/Tools/GenUnicodeProp/Updating-Unicode-Versions.md

        private static ReadOnlySpan<char> EquivalenceCasingValues => new char[2336]
        {
            '\u0041', '\u0061', '\u0042', '\u0062', '\u0043', '\u0063', '\u0044', '\u0064', '\u0045', '\u0065', '\u0046', '\u0066', '\u0047', '\u0067', '\u0048', '\u0068',
            '\u0049', '\u0069', '\u004A', '\u006A', '\u004B', '\u006B', '\u212A', '\u004C', '\u006C', '\u004D', '\u006D', '\u004E', '\u006E', '\u004F', '\u006F', '\u0050',
            '\u0070', '\u0051', '\u0071', '\u0052', '\u0072', '\u0053', '\u0073', '\u0054', '\u0074', '\u0055', '\u0075', '\u0056', '\u0076', '\u0057', '\u0077', '\u0058',
            '\u0078', '\u0059', '\u0079', '\u005A', '\u007A', '\u00C0', '\u00E0', '\u00C1', '\u00E1', '\u00C2', '\u00E2', '\u00C3', '\u00E3', '\u00C4', '\u00E4', '\u00C5',
            '\u00E5', '\u212B', '\u00C6', '\u00E6', '\u00C7', '\u00E7', '\u00C8', '\u00E8', '\u00C9', '\u00E9', '\u00CA', '\u00EA', '\u00CB', '\u00EB', '\u00CC', '\u00EC',
            '\u00CD', '\u00ED', '\u00CE', '\u00EE', '\u00CF', '\u00EF', '\u00D0', '\u00F0', '\u00D1', '\u00F1', '\u00D2', '\u00F2', '\u00D3', '\u00F3', '\u00D4', '\u00F4',
            '\u00D5', '\u00F5', '\u00D6', '\u00F6', '\u00D8', '\u00F8', '\u00D9', '\u00F9', '\u00DA', '\u00FA', '\u00DB', '\u00FB', '\u00DC', '\u00FC', '\u00DD', '\u00FD',
            '\u00DE', '\u00FE', '\u0100', '\u0101', '\u0102', '\u0103', '\u0104', '\u0105', '\u0106', '\u0107', '\u0108', '\u0109', '\u010A', '\u010B', '\u010C', '\u010D',
            '\u010E', '\u010F', '\u0110', '\u0111', '\u0112', '\u0113', '\u0114', '\u0115', '\u0116', '\u0117', '\u0118', '\u0119', '\u011A', '\u011B', '\u011C', '\u011D',
            '\u011E', '\u011F', '\u0120', '\u0121', '\u0122', '\u0123', '\u0124', '\u0125', '\u0126', '\u0127', '\u0128', '\u0129', '\u012A', '\u012B', '\u012C', '\u012D',
            '\u012E', '\u012F', '\u0132', '\u0133', '\u0134', '\u0135', '\u0136', '\u0137', '\u0139', '\u013A', '\u013B', '\u013C', '\u013D', '\u013E', '\u013F', '\u0140',
            '\u0141', '\u0142', '\u0143', '\u0144', '\u0145', '\u0146', '\u0147', '\u0148', '\u014A', '\u014B', '\u014C', '\u014D', '\u014E', '\u014F', '\u0150', '\u0151',
            '\u0152', '\u0153', '\u0154', '\u0155', '\u0156', '\u0157', '\u0158', '\u0159', '\u015A', '\u015B', '\u015C', '\u015D', '\u015E', '\u015F', '\u0160', '\u0161',
            '\u0162', '\u0163', '\u0164', '\u0165', '\u0166', '\u0167', '\u0168', '\u0169', '\u016A', '\u016B', '\u016C', '\u016D', '\u016E', '\u016F', '\u0170', '\u0171',
            '\u0172', '\u0173', '\u0174', '\u0175', '\u0176', '\u0177', '\u00FF', '\u0178', '\u0179', '\u017A', '\u017B', '\u017C', '\u017D', '\u017E', '\u0181', '\u0253',
            '\u0182', '\u0183', '\u0184', '\u0185', '\u0186', '\u0254', '\u0187', '\u0188', '\u0189', '\u0256', '\u018A', '\u0257', '\u018B', '\u018C', '\u018E', '\u01DD',
            '\u018F', '\u0259', '\u0190', '\u025B', '\u0191', '\u0192', '\u0193', '\u0260', '\u0194', '\u0263', '\u0196', '\u0269', '\u0197', '\u0268', '\u0198', '\u0199',
            '\u019C', '\u026F', '\u019D', '\u0272', '\u019F', '\u0275', '\u01A0', '\u01A1', '\u01A2', '\u01A3', '\u01A4', '\u01A5', '\u01A6', '\u0280', '\u01A7', '\u01A8',
            '\u01A9', '\u0283', '\u01AC', '\u01AD', '\u01AE', '\u0288', '\u01AF', '\u01B0', '\u01B1', '\u028A', '\u01B2', '\u028B', '\u01B3', '\u01B4', '\u01B5', '\u01B6',
            '\u01B7', '\u0292', '\u01B8', '\u01B9', '\u01BC', '\u01BD', '\u01C4', '\u01C5', '\u01C6', '\u01C7', '\u01C8', '\u01C9', '\u01CA', '\u01CB', '\u01CC', '\u01CD',
            '\u01CE', '\u01CF', '\u01D0', '\u01D1', '\u01D2', '\u01D3', '\u01D4', '\u01D5', '\u01D6', '\u01D7', '\u01D8', '\u01D9', '\u01DA', '\u01DB', '\u01DC', '\u01DE',
            '\u01DF', '\u01E0', '\u01E1', '\u01E2', '\u01E3', '\u01E4', '\u01E5', '\u01E6', '\u01E7', '\u01E8', '\u01E9', '\u01EA', '\u01EB', '\u01EC', '\u01ED', '\u01EE',
            '\u01EF', '\u01F1', '\u01F2', '\u01F3', '\u01F4', '\u01F5', '\u0195', '\u01F6', '\u01BF', '\u01F7', '\u01F8', '\u01F9', '\u01FA', '\u01FB', '\u01FC', '\u01FD',
            '\u01FE', '\u01FF', '\u0200', '\u0201', '\u0202', '\u0203', '\u0204', '\u0205', '\u0206', '\u0207', '\u0208', '\u0209', '\u020A', '\u020B', '\u020C', '\u020D',
            '\u020E', '\u020F', '\u0210', '\u0211', '\u0212', '\u0213', '\u0214', '\u0215', '\u0216', '\u0217', '\u0218', '\u0219', '\u021A', '\u021B', '\u021C', '\u021D',
            '\u021E', '\u021F', '\u019E', '\u0220', '\u0222', '\u0223', '\u0224', '\u0225', '\u0226', '\u0227', '\u0228', '\u0229', '\u022A', '\u022B', '\u022C', '\u022D',
            '\u022E', '\u022F', '\u0230', '\u0231', '\u0232', '\u0233', '\u023A', '\u2C65', '\u023B', '\u023C', '\u019A', '\u023D', '\u023E', '\u2C66', '\u0241', '\u0242',
            '\u0180', '\u0243', '\u0244', '\u0289', '\u0245', '\u028C', '\u0246', '\u0247', '\u0248', '\u0249', '\u024A', '\u024B', '\u024C', '\u024D', '\u024E', '\u024F',
            '\u0370', '\u0371', '\u0372', '\u0373', '\u0376', '\u0377', '\u037F', '\u03F3', '\u0386', '\u03AC', '\u0388', '\u03AD', '\u0389', '\u03AE', '\u038A', '\u03AF',
            '\u038C', '\u03CC', '\u038E', '\u03CD', '\u038F', '\u03CE', '\u0391', '\u03B1', '\u0392', '\u03B2', '\u0393', '\u03B3', '\u0394', '\u03B4', '\u0395', '\u03B5',
            '\u0396', '\u03B6', '\u0397', '\u03B7', '\u0398', '\u03B8', '\u03F4', '\u0399', '\u03B9', '\u039A', '\u03BA', '\u039B', '\u03BB', '\u039C', '\u03BC', '\u039D',
            '\u03BD', '\u039E', '\u03BE', '\u039F', '\u03BF', '\u03A0', '\u03C0', '\u03A1', '\u03C1', '\u03A3', '\u03C3', '\u03A4', '\u03C4', '\u03A5', '\u03C5', '\u03A6',
            '\u03C6', '\u03A7', '\u03C7', '\u03A8', '\u03C8', '\u03A9', '\u03C9', '\u2126', '\u03AA', '\u03CA', '\u03AB', '\u03CB', '\u03CF', '\u03D7', '\u03D8', '\u03D9',
            '\u03DA', '\u03DB', '\u03DC', '\u03DD', '\u03DE', '\u03DF', '\u03E0', '\u03E1', '\u03E2', '\u03E3', '\u03E4', '\u03E5', '\u03E6', '\u03E7', '\u03E8', '\u03E9',
            '\u03EA', '\u03EB', '\u03EC', '\u03ED', '\u03EE', '\u03EF', '\u03F7', '\u03F8', '\u03F2', '\u03F9', '\u03FA', '\u03FB', '\u037B', '\u03FD', '\u037C', '\u03FE',
            '\u037D', '\u03FF', '\u0400', '\u0450', '\u0401', '\u0451', '\u0402', '\u0452', '\u0403', '\u0453', '\u0404', '\u0454', '\u0405', '\u0455', '\u0406', '\u0456',
            '\u0407', '\u0457', '\u0408', '\u0458', '\u0409', '\u0459', '\u040A', '\u045A', '\u040B', '\u045B', '\u040C', '\u045C', '\u040D', '\u045D', '\u040E', '\u045E',
            '\u040F', '\u045F', '\u0410', '\u0430', '\u0411', '\u0431', '\u0412', '\u0432', '\u0413', '\u0433', '\u0414', '\u0434', '\u0415', '\u0435', '\u0416', '\u0436',
            '\u0417', '\u0437', '\u0418', '\u0438', '\u0419', '\u0439', '\u041A', '\u043A', '\u041B', '\u043B', '\u041C', '\u043C', '\u041D', '\u043D', '\u041E', '\u043E',
            '\u041F', '\u043F', '\u0420', '\u0440', '\u0421', '\u0441', '\u0422', '\u0442', '\u0423', '\u0443', '\u0424', '\u0444', '\u0425', '\u0445', '\u0426', '\u0446',
            '\u0427', '\u0447', '\u0428', '\u0448', '\u0429', '\u0449', '\u042A', '\u044A', '\u042B', '\u044B', '\u042C', '\u044C', '\u042D', '\u044D', '\u042E', '\u044E',
            '\u042F', '\u044F', '\u0460', '\u0461', '\u0462', '\u0463', '\u0464', '\u0465', '\u0466', '\u0467', '\u0468', '\u0469', '\u046A', '\u046B', '\u046C', '\u046D',
            '\u046E', '\u046F', '\u0470', '\u0471', '\u0472', '\u0473', '\u0474', '\u0475', '\u0476', '\u0477', '\u0478', '\u0479', '\u047A', '\u047B', '\u047C', '\u047D',
            '\u047E', '\u047F', '\u0480', '\u0481', '\u048A', '\u048B', '\u048C', '\u048D', '\u048E', '\u048F', '\u0490', '\u0491', '\u0492', '\u0493', '\u0494', '\u0495',
            '\u0496', '\u0497', '\u0498', '\u0499', '\u049A', '\u049B', '\u049C', '\u049D', '\u049E', '\u049F', '\u04A0', '\u04A1', '\u04A2', '\u04A3', '\u04A4', '\u04A5',
            '\u04A6', '\u04A7', '\u04A8', '\u04A9', '\u04AA', '\u04AB', '\u04AC', '\u04AD', '\u04AE', '\u04AF', '\u04B0', '\u04B1', '\u04B2', '\u04B3', '\u04B4', '\u04B5',
            '\u04B6', '\u04B7', '\u04B8', '\u04B9', '\u04BA', '\u04BB', '\u04BC', '\u04BD', '\u04BE', '\u04BF', '\u04C0', '\u04CF', '\u04C1', '\u04C2', '\u04C3', '\u04C4',
            '\u04C5', '\u04C6', '\u04C7', '\u04C8', '\u04C9', '\u04CA', '\u04CB', '\u04CC', '\u04CD', '\u04CE', '\u04D0', '\u04D1', '\u04D2', '\u04D3', '\u04D4', '\u04D5',
            '\u04D6', '\u04D7', '\u04D8', '\u04D9', '\u04DA', '\u04DB', '\u04DC', '\u04DD', '\u04DE', '\u04DF', '\u04E0', '\u04E1', '\u04E2', '\u04E3', '\u04E4', '\u04E5',
            '\u04E6', '\u04E7', '\u04E8', '\u04E9', '\u04EA', '\u04EB', '\u04EC', '\u04ED', '\u04EE', '\u04EF', '\u04F0', '\u04F1', '\u04F2', '\u04F3', '\u04F4', '\u04F5',
            '\u04F6', '\u04F7', '\u04F8', '\u04F9', '\u04FA', '\u04FB', '\u04FC', '\u04FD', '\u04FE', '\u04FF', '\u0500', '\u0501', '\u0502', '\u0503', '\u0504', '\u0505',
            '\u0506', '\u0507', '\u0508', '\u0509', '\u050A', '\u050B', '\u050C', '\u050D', '\u050E', '\u050F', '\u0510', '\u0511', '\u0512', '\u0513', '\u0514', '\u0515',
            '\u0516', '\u0517', '\u0518', '\u0519', '\u051A', '\u051B', '\u051C', '\u051D', '\u051E', '\u051F', '\u0520', '\u0521', '\u0522', '\u0523', '\u0524', '\u0525',
            '\u0526', '\u0527', '\u0528', '\u0529', '\u052A', '\u052B', '\u052C', '\u052D', '\u052E', '\u052F', '\u0531', '\u0561', '\u0532', '\u0562', '\u0533', '\u0563',
            '\u0534', '\u0564', '\u0535', '\u0565', '\u0536', '\u0566', '\u0537', '\u0567', '\u0538', '\u0568', '\u0539', '\u0569', '\u053A', '\u056A', '\u053B', '\u056B',
            '\u053C', '\u056C', '\u053D', '\u056D', '\u053E', '\u056E', '\u053F', '\u056F', '\u0540', '\u0570', '\u0541', '\u0571', '\u0542', '\u0572', '\u0543', '\u0573',
            '\u0544', '\u0574', '\u0545', '\u0575', '\u0546', '\u0576', '\u0547', '\u0577', '\u0548', '\u0578', '\u0549', '\u0579', '\u054A', '\u057A', '\u054B', '\u057B',
            '\u054C', '\u057C', '\u054D', '\u057D', '\u054E', '\u057E', '\u054F', '\u057F', '\u0550', '\u0580', '\u0551', '\u0581', '\u0552', '\u0582', '\u0553', '\u0583',
            '\u0554', '\u0584', '\u0555', '\u0585', '\u0556', '\u0586', '\u10A0', '\u2D00', '\u10A1', '\u2D01', '\u10A2', '\u2D02', '\u10A3', '\u2D03', '\u10A4', '\u2D04',
            '\u10A5', '\u2D05', '\u10A6', '\u2D06', '\u10A7', '\u2D07', '\u10A8', '\u2D08', '\u10A9', '\u2D09', '\u10AA', '\u2D0A', '\u10AB', '\u2D0B', '\u10AC', '\u2D0C',
            '\u10AD', '\u2D0D', '\u10AE', '\u2D0E', '\u10AF', '\u2D0F', '\u10B0', '\u2D10', '\u10B1', '\u2D11', '\u10B2', '\u2D12', '\u10B3', '\u2D13', '\u10B4', '\u2D14',
            '\u10B5', '\u2D15', '\u10B6', '\u2D16', '\u10B7', '\u2D17', '\u10B8', '\u2D18', '\u10B9', '\u2D19', '\u10BA', '\u2D1A', '\u10BB', '\u2D1B', '\u10BC', '\u2D1C',
            '\u10BD', '\u2D1D', '\u10BE', '\u2D1E', '\u10BF', '\u2D1F', '\u10C0', '\u2D20', '\u10C1', '\u2D21', '\u10C2', '\u2D22', '\u10C3', '\u2D23', '\u10C4', '\u2D24',
            '\u10C5', '\u2D25', '\u10C7', '\u2D27', '\u10CD', '\u2D2D', '\u13A0', '\uAB70', '\u13A1', '\uAB71', '\u13A2', '\uAB72', '\u13A3', '\uAB73', '\u13A4', '\uAB74',
            '\u13A5', '\uAB75', '\u13A6', '\uAB76', '\u13A7', '\uAB77', '\u13A8', '\uAB78', '\u13A9', '\uAB79', '\u13AA', '\uAB7A', '\u13AB', '\uAB7B', '\u13AC', '\uAB7C',
            '\u13AD', '\uAB7D', '\u13AE', '\uAB7E', '\u13AF', '\uAB7F', '\u13B0', '\uAB80', '\u13B1', '\uAB81', '\u13B2', '\uAB82', '\u13B3', '\uAB83', '\u13B4', '\uAB84',
            '\u13B5', '\uAB85', '\u13B6', '\uAB86', '\u13B7', '\uAB87', '\u13B8', '\uAB88', '\u13B9', '\uAB89', '\u13BA', '\uAB8A', '\u13BB', '\uAB8B', '\u13BC', '\uAB8C',
            '\u13BD', '\uAB8D', '\u13BE', '\uAB8E', '\u13BF', '\uAB8F', '\u13C0', '\uAB90', '\u13C1', '\uAB91', '\u13C2', '\uAB92', '\u13C3', '\uAB93', '\u13C4', '\uAB94',
            '\u13C5', '\uAB95', '\u13C6', '\uAB96', '\u13C7', '\uAB97', '\u13C8', '\uAB98', '\u13C9', '\uAB99', '\u13CA', '\uAB9A', '\u13CB', '\uAB9B', '\u13CC', '\uAB9C',
            '\u13CD', '\uAB9D', '\u13CE', '\uAB9E', '\u13CF', '\uAB9F', '\u13D0', '\uABA0', '\u13D1', '\uABA1', '\u13D2', '\uABA2', '\u13D3', '\uABA3', '\u13D4', '\uABA4',
            '\u13D5', '\uABA5', '\u13D6', '\uABA6', '\u13D7', '\uABA7', '\u13D8', '\uABA8', '\u13D9', '\uABA9', '\u13DA', '\uABAA', '\u13DB', '\uABAB', '\u13DC', '\uABAC',
            '\u13DD', '\uABAD', '\u13DE', '\uABAE', '\u13DF', '\uABAF', '\u13E0', '\uABB0', '\u13E1', '\uABB1', '\u13E2', '\uABB2', '\u13E3', '\uABB3', '\u13E4', '\uABB4',
            '\u13E5', '\uABB5', '\u13E6', '\uABB6', '\u13E7', '\uABB7', '\u13E8', '\uABB8', '\u13E9', '\uABB9', '\u13EA', '\uABBA', '\u13EB', '\uABBB', '\u13EC', '\uABBC',
            '\u13ED', '\uABBD', '\u13EE', '\uABBE', '\u13EF', '\uABBF', '\u13F0', '\u13F8', '\u13F1', '\u13F9', '\u13F2', '\u13FA', '\u13F3', '\u13FB', '\u13F4', '\u13FC',
            '\u13F5', '\u13FD', '\u10D0', '\u1C90', '\u10D1', '\u1C91', '\u10D2', '\u1C92', '\u10D3', '\u1C93', '\u10D4', '\u1C94', '\u10D5', '\u1C95', '\u10D6', '\u1C96',
            '\u10D7', '\u1C97', '\u10D8', '\u1C98', '\u10D9', '\u1C99', '\u10DA', '\u1C9A', '\u10DB', '\u1C9B', '\u10DC', '\u1C9C', '\u10DD', '\u1C9D', '\u10DE', '\u1C9E',
            '\u10DF', '\u1C9F', '\u10E0', '\u1CA0', '\u10E1', '\u1CA1', '\u10E2', '\u1CA2', '\u10E3', '\u1CA3', '\u10E4', '\u1CA4', '\u10E5', '\u1CA5', '\u10E6', '\u1CA6',
            '\u10E7', '\u1CA7', '\u10E8', '\u1CA8', '\u10E9', '\u1CA9', '\u10EA', '\u1CAA', '\u10EB', '\u1CAB', '\u10EC', '\u1CAC', '\u10ED', '\u1CAD', '\u10EE', '\u1CAE',
            '\u10EF', '\u1CAF', '\u10F0', '\u1CB0', '\u10F1', '\u1CB1', '\u10F2', '\u1CB2', '\u10F3', '\u1CB3', '\u10F4', '\u1CB4', '\u10F5', '\u1CB5', '\u10F6', '\u1CB6',
            '\u10F7', '\u1CB7', '\u10F8', '\u1CB8', '\u10F9', '\u1CB9', '\u10FA', '\u1CBA', '\u10FD', '\u1CBD', '\u10FE', '\u1CBE', '\u10FF', '\u1CBF', '\u1E00', '\u1E01',
            '\u1E02', '\u1E03', '\u1E04', '\u1E05', '\u1E06', '\u1E07', '\u1E08', '\u1E09', '\u1E0A', '\u1E0B', '\u1E0C', '\u1E0D', '\u1E0E', '\u1E0F', '\u1E10', '\u1E11',
            '\u1E12', '\u1E13', '\u1E14', '\u1E15', '\u1E16', '\u1E17', '\u1E18', '\u1E19', '\u1E1A', '\u1E1B', '\u1E1C', '\u1E1D', '\u1E1E', '\u1E1F', '\u1E20', '\u1E21',
            '\u1E22', '\u1E23', '\u1E24', '\u1E25', '\u1E26', '\u1E27', '\u1E28', '\u1E29', '\u1E2A', '\u1E2B', '\u1E2C', '\u1E2D', '\u1E2E', '\u1E2F', '\u1E30', '\u1E31',
            '\u1E32', '\u1E33', '\u1E34', '\u1E35', '\u1E36', '\u1E37', '\u1E38', '\u1E39', '\u1E3A', '\u1E3B', '\u1E3C', '\u1E3D', '\u1E3E', '\u1E3F', '\u1E40', '\u1E41',
            '\u1E42', '\u1E43', '\u1E44', '\u1E45', '\u1E46', '\u1E47', '\u1E48', '\u1E49', '\u1E4A', '\u1E4B', '\u1E4C', '\u1E4D', '\u1E4E', '\u1E4F', '\u1E50', '\u1E51',
            '\u1E52', '\u1E53', '\u1E54', '\u1E55', '\u1E56', '\u1E57', '\u1E58', '\u1E59', '\u1E5A', '\u1E5B', '\u1E5C', '\u1E5D', '\u1E5E', '\u1E5F', '\u1E60', '\u1E61',
            '\u1E62', '\u1E63', '\u1E64', '\u1E65', '\u1E66', '\u1E67', '\u1E68', '\u1E69', '\u1E6A', '\u1E6B', '\u1E6C', '\u1E6D', '\u1E6E', '\u1E6F', '\u1E70', '\u1E71',
            '\u1E72', '\u1E73', '\u1E74', '\u1E75', '\u1E76', '\u1E77', '\u1E78', '\u1E79', '\u1E7A', '\u1E7B', '\u1E7C', '\u1E7D', '\u1E7E', '\u1E7F', '\u1E80', '\u1E81',
            '\u1E82', '\u1E83', '\u1E84', '\u1E85', '\u1E86', '\u1E87', '\u1E88', '\u1E89', '\u1E8A', '\u1E8B', '\u1E8C', '\u1E8D', '\u1E8E', '\u1E8F', '\u1E90', '\u1E91',
            '\u1E92', '\u1E93', '\u1E94', '\u1E95', '\u00DF', '\u1E9E', '\u1EA0', '\u1EA1', '\u1EA2', '\u1EA3', '\u1EA4', '\u1EA5', '\u1EA6', '\u1EA7', '\u1EA8', '\u1EA9',
            '\u1EAA', '\u1EAB', '\u1EAC', '\u1EAD', '\u1EAE', '\u1EAF', '\u1EB0', '\u1EB1', '\u1EB2', '\u1EB3', '\u1EB4', '\u1EB5', '\u1EB6', '\u1EB7', '\u1EB8', '\u1EB9',
            '\u1EBA', '\u1EBB', '\u1EBC', '\u1EBD', '\u1EBE', '\u1EBF', '\u1EC0', '\u1EC1', '\u1EC2', '\u1EC3', '\u1EC4', '\u1EC5', '\u1EC6', '\u1EC7', '\u1EC8', '\u1EC9',
            '\u1ECA', '\u1ECB', '\u1ECC', '\u1ECD', '\u1ECE', '\u1ECF', '\u1ED0', '\u1ED1', '\u1ED2', '\u1ED3', '\u1ED4', '\u1ED5', '\u1ED6', '\u1ED7', '\u1ED8', '\u1ED9',
            '\u1EDA', '\u1EDB', '\u1EDC', '\u1EDD', '\u1EDE', '\u1EDF', '\u1EE0', '\u1EE1', '\u1EE2', '\u1EE3', '\u1EE4', '\u1EE5', '\u1EE6', '\u1EE7', '\u1EE8', '\u1EE9',
            '\u1EEA', '\u1EEB', '\u1EEC', '\u1EED', '\u1EEE', '\u1EEF', '\u1EF0', '\u1EF1', '\u1EF2', '\u1EF3', '\u1EF4', '\u1EF5', '\u1EF6', '\u1EF7', '\u1EF8', '\u1EF9',
            '\u1EFA', '\u1EFB', '\u1EFC', '\u1EFD', '\u1EFE', '\u1EFF', '\u1F00', '\u1F08', '\u1F01', '\u1F09', '\u1F02', '\u1F0A', '\u1F03', '\u1F0B', '\u1F04', '\u1F0C',
            '\u1F05', '\u1F0D', '\u1F06', '\u1F0E', '\u1F07', '\u1F0F', '\u1F10', '\u1F18', '\u1F11', '\u1F19', '\u1F12', '\u1F1A', '\u1F13', '\u1F1B', '\u1F14', '\u1F1C',
            '\u1F15', '\u1F1D', '\u1F20', '\u1F28', '\u1F21', '\u1F29', '\u1F22', '\u1F2A', '\u1F23', '\u1F2B', '\u1F24', '\u1F2C', '\u1F25', '\u1F2D', '\u1F26', '\u1F2E',
            '\u1F27', '\u1F2F', '\u1F30', '\u1F38', '\u1F31', '\u1F39', '\u1F32', '\u1F3A', '\u1F33', '\u1F3B', '\u1F34', '\u1F3C', '\u1F35', '\u1F3D', '\u1F36', '\u1F3E',
            '\u1F37', '\u1F3F', '\u1F40', '\u1F48', '\u1F41', '\u1F49', '\u1F42', '\u1F4A', '\u1F43', '\u1F4B', '\u1F44', '\u1F4C', '\u1F45', '\u1F4D', '\u1F51', '\u1F59',
            '\u1F53', '\u1F5B', '\u1F55', '\u1F5D', '\u1F57', '\u1F5F', '\u1F60', '\u1F68', '\u1F61', '\u1F69', '\u1F62', '\u1F6A', '\u1F63', '\u1F6B', '\u1F64', '\u1F6C',
            '\u1F65', '\u1F6D', '\u1F66', '\u1F6E', '\u1F67', '\u1F6F', '\u1F80', '\u1F88', '\u1F81', '\u1F89', '\u1F82', '\u1F8A', '\u1F83', '\u1F8B', '\u1F84', '\u1F8C',
            '\u1F85', '\u1F8D', '\u1F86', '\u1F8E', '\u1F87', '\u1F8F', '\u1F90', '\u1F98', '\u1F91', '\u1F99', '\u1F92', '\u1F9A', '\u1F93', '\u1F9B', '\u1F94', '\u1F9C',
            '\u1F95', '\u1F9D', '\u1F96', '\u1F9E', '\u1F97', '\u1F9F', '\u1FA0', '\u1FA8', '\u1FA1', '\u1FA9', '\u1FA2', '\u1FAA', '\u1FA3', '\u1FAB', '\u1FA4', '\u1FAC',
            '\u1FA5', '\u1FAD', '\u1FA6', '\u1FAE', '\u1FA7', '\u1FAF', '\u1FB0', '\u1FB8', '\u1FB1', '\u1FB9', '\u1F70', '\u1FBA', '\u1F71', '\u1FBB', '\u1FB3', '\u1FBC',
            '\u1F72', '\u1FC8', '\u1F73', '\u1FC9', '\u1F74', '\u1FCA', '\u1F75', '\u1FCB', '\u1FC3', '\u1FCC', '\u1FD0', '\u1FD8', '\u1FD1', '\u1FD9', '\u1F76', '\u1FDA',
            '\u1F77', '\u1FDB', '\u1FE0', '\u1FE8', '\u1FE1', '\u1FE9', '\u1F7A', '\u1FEA', '\u1F7B', '\u1FEB', '\u1FE5', '\u1FEC', '\u1F78', '\u1FF8', '\u1F79', '\u1FF9',
            '\u1F7C', '\u1FFA', '\u1F7D', '\u1FFB', '\u1FF3', '\u1FFC', '\u2132', '\u214E', '\u2160', '\u2170', '\u2161', '\u2171', '\u2162', '\u2172', '\u2163', '\u2173',
            '\u2164', '\u2174', '\u2165', '\u2175', '\u2166', '\u2176', '\u2167', '\u2177', '\u2168', '\u2178', '\u2169', '\u2179', '\u216A', '\u217A', '\u216B', '\u217B',
            '\u216C', '\u217C', '\u216D', '\u217D', '\u216E', '\u217E', '\u216F', '\u217F', '\u2183', '\u2184', '\u24B6', '\u24D0', '\u24B7', '\u24D1', '\u24B8', '\u24D2',
            '\u24B9', '\u24D3', '\u24BA', '\u24D4', '\u24BB', '\u24D5', '\u24BC', '\u24D6', '\u24BD', '\u24D7', '\u24BE', '\u24D8', '\u24BF', '\u24D9', '\u24C0', '\u24DA',
            '\u24C1', '\u24DB', '\u24C2', '\u24DC', '\u24C3', '\u24DD', '\u24C4', '\u24DE', '\u24C5', '\u24DF', '\u24C6', '\u24E0', '\u24C7', '\u24E1', '\u24C8', '\u24E2',
            '\u24C9', '\u24E3', '\u24CA', '\u24E4', '\u24CB', '\u24E5', '\u24CC', '\u24E6', '\u24CD', '\u24E7', '\u24CE', '\u24E8', '\u24CF', '\u24E9', '\u2C00', '\u2C30',
            '\u2C01', '\u2C31', '\u2C02', '\u2C32', '\u2C03', '\u2C33', '\u2C04', '\u2C34', '\u2C05', '\u2C35', '\u2C06', '\u2C36', '\u2C07', '\u2C37', '\u2C08', '\u2C38',
            '\u2C09', '\u2C39', '\u2C0A', '\u2C3A', '\u2C0B', '\u2C3B', '\u2C0C', '\u2C3C', '\u2C0D', '\u2C3D', '\u2C0E', '\u2C3E', '\u2C0F', '\u2C3F', '\u2C10', '\u2C40',
            '\u2C11', '\u2C41', '\u2C12', '\u2C42', '\u2C13', '\u2C43', '\u2C14', '\u2C44', '\u2C15', '\u2C45', '\u2C16', '\u2C46', '\u2C17', '\u2C47', '\u2C18', '\u2C48',
            '\u2C19', '\u2C49', '\u2C1A', '\u2C4A', '\u2C1B', '\u2C4B', '\u2C1C', '\u2C4C', '\u2C1D', '\u2C4D', '\u2C1E', '\u2C4E', '\u2C1F', '\u2C4F', '\u2C20', '\u2C50',
            '\u2C21', '\u2C51', '\u2C22', '\u2C52', '\u2C23', '\u2C53', '\u2C24', '\u2C54', '\u2C25', '\u2C55', '\u2C26', '\u2C56', '\u2C27', '\u2C57', '\u2C28', '\u2C58',
            '\u2C29', '\u2C59', '\u2C2A', '\u2C5A', '\u2C2B', '\u2C5B', '\u2C2C', '\u2C5C', '\u2C2D', '\u2C5D', '\u2C2E', '\u2C5E', '\u2C2F', '\u2C5F', '\u2C60', '\u2C61',
            '\u026B', '\u2C62', '\u1D7D', '\u2C63', '\u027D', '\u2C64', '\u2C67', '\u2C68', '\u2C69', '\u2C6A', '\u2C6B', '\u2C6C', '\u0251', '\u2C6D', '\u0271', '\u2C6E',
            '\u0250', '\u2C6F', '\u0252', '\u2C70', '\u2C72', '\u2C73', '\u2C75', '\u2C76', '\u023F', '\u2C7E', '\u0240', '\u2C7F', '\u2C80', '\u2C81', '\u2C82', '\u2C83',
            '\u2C84', '\u2C85', '\u2C86', '\u2C87', '\u2C88', '\u2C89', '\u2C8A', '\u2C8B', '\u2C8C', '\u2C8D', '\u2C8E', '\u2C8F', '\u2C90', '\u2C91', '\u2C92', '\u2C93',
            '\u2C94', '\u2C95', '\u2C96', '\u2C97', '\u2C98', '\u2C99', '\u2C9A', '\u2C9B', '\u2C9C', '\u2C9D', '\u2C9E', '\u2C9F', '\u2CA0', '\u2CA1', '\u2CA2', '\u2CA3',
            '\u2CA4', '\u2CA5', '\u2CA6', '\u2CA7', '\u2CA8', '\u2CA9', '\u2CAA', '\u2CAB', '\u2CAC', '\u2CAD', '\u2CAE', '\u2CAF', '\u2CB0', '\u2CB1', '\u2CB2', '\u2CB3',
            '\u2CB4', '\u2CB5', '\u2CB6', '\u2CB7', '\u2CB8', '\u2CB9', '\u2CBA', '\u2CBB', '\u2CBC', '\u2CBD', '\u2CBE', '\u2CBF', '\u2CC0', '\u2CC1', '\u2CC2', '\u2CC3',
            '\u2CC4', '\u2CC5', '\u2CC6', '\u2CC7', '\u2CC8', '\u2CC9', '\u2CCA', '\u2CCB', '\u2CCC', '\u2CCD', '\u2CCE', '\u2CCF', '\u2CD0', '\u2CD1', '\u2CD2', '\u2CD3',
            '\u2CD4', '\u2CD5', '\u2CD6', '\u2CD7', '\u2CD8', '\u2CD9', '\u2CDA', '\u2CDB', '\u2CDC', '\u2CDD', '\u2CDE', '\u2CDF', '\u2CE0', '\u2CE1', '\u2CE2', '\u2CE3',
            '\u2CEB', '\u2CEC', '\u2CED', '\u2CEE', '\u2CF2', '\u2CF3', '\uA640', '\uA641', '\uA642', '\uA643', '\uA644', '\uA645', '\uA646', '\uA647', '\uA648', '\uA649',
            '\uA64A', '\uA64B', '\uA64C', '\uA64D', '\uA64E', '\uA64F', '\uA650', '\uA651', '\uA652', '\uA653', '\uA654', '\uA655', '\uA656', '\uA657', '\uA658', '\uA659',
            '\uA65A', '\uA65B', '\uA65C', '\uA65D', '\uA65E', '\uA65F', '\uA660', '\uA661', '\uA662', '\uA663', '\uA664', '\uA665', '\uA666', '\uA667', '\uA668', '\uA669',
            '\uA66A', '\uA66B', '\uA66C', '\uA66D', '\uA680', '\uA681', '\uA682', '\uA683', '\uA684', '\uA685', '\uA686', '\uA687', '\uA688', '\uA689', '\uA68A', '\uA68B',
            '\uA68C', '\uA68D', '\uA68E', '\uA68F', '\uA690', '\uA691', '\uA692', '\uA693', '\uA694', '\uA695', '\uA696', '\uA697', '\uA698', '\uA699', '\uA69A', '\uA69B',
            '\uA722', '\uA723', '\uA724', '\uA725', '\uA726', '\uA727', '\uA728', '\uA729', '\uA72A', '\uA72B', '\uA72C', '\uA72D', '\uA72E', '\uA72F', '\uA732', '\uA733',
            '\uA734', '\uA735', '\uA736', '\uA737', '\uA738', '\uA739', '\uA73A', '\uA73B', '\uA73C', '\uA73D', '\uA73E', '\uA73F', '\uA740', '\uA741', '\uA742', '\uA743',
            '\uA744', '\uA745', '\uA746', '\uA747', '\uA748', '\uA749', '\uA74A', '\uA74B', '\uA74C', '\uA74D', '\uA74E', '\uA74F', '\uA750', '\uA751', '\uA752', '\uA753',
            '\uA754', '\uA755', '\uA756', '\uA757', '\uA758', '\uA759', '\uA75A', '\uA75B', '\uA75C', '\uA75D', '\uA75E', '\uA75F', '\uA760', '\uA761', '\uA762', '\uA763',
            '\uA764', '\uA765', '\uA766', '\uA767', '\uA768', '\uA769', '\uA76A', '\uA76B', '\uA76C', '\uA76D', '\uA76E', '\uA76F', '\uA779', '\uA77A', '\uA77B', '\uA77C',
            '\u1D79', '\uA77D', '\uA77E', '\uA77F', '\uA780', '\uA781', '\uA782', '\uA783', '\uA784', '\uA785', '\uA786', '\uA787', '\uA78B', '\uA78C', '\u0265', '\uA78D',
            '\uA790', '\uA791', '\uA792', '\uA793', '\uA796', '\uA797', '\uA798', '\uA799', '\uA79A', '\uA79B', '\uA79C', '\uA79D', '\uA79E', '\uA79F', '\uA7A0', '\uA7A1',
            '\uA7A2', '\uA7A3', '\uA7A4', '\uA7A5', '\uA7A6', '\uA7A7', '\uA7A8', '\uA7A9', '\u0266', '\uA7AA', '\u025C', '\uA7AB', '\u0261', '\uA7AC', '\u026C', '\uA7AD',
            '\u026A', '\uA7AE', '\u029E', '\uA7B0', '\u0287', '\uA7B1', '\u029D', '\uA7B2', '\uA7B3', '\uAB53', '\uA7B4', '\uA7B5', '\uA7B6', '\uA7B7', '\uA7B8', '\uA7B9',
            '\uA7BA', '\uA7BB', '\uA7BC', '\uA7BD', '\uA7BE', '\uA7BF', '\uA7C0', '\uA7C1', '\uA7C2', '\uA7C3', '\uA794', '\uA7C4', '\u0282', '\uA7C5', '\u1D8E', '\uA7C6',
            '\uA7C7', '\uA7C8', '\uA7C9', '\uA7CA', '\uA7D0', '\uA7D1', '\uA7D6', '\uA7D7', '\uA7D8', '\uA7D9', '\uA7F5', '\uA7F6', '\uFF21', '\uFF41', '\uFF22', '\uFF42',
            '\uFF23', '\uFF43', '\uFF24', '\uFF44', '\uFF25', '\uFF45', '\uFF26', '\uFF46', '\uFF27', '\uFF47', '\uFF28', '\uFF48', '\uFF29', '\uFF49', '\uFF2A', '\uFF4A',
            '\uFF2B', '\uFF4B', '\uFF2C', '\uFF4C', '\uFF2D', '\uFF4D', '\uFF2E', '\uFF4E', '\uFF2F', '\uFF4F', '\uFF30', '\uFF50', '\uFF31', '\uFF51', '\uFF32', '\uFF52',
            '\uFF33', '\uFF53', '\uFF34', '\uFF54', '\uFF35', '\uFF55', '\uFF36', '\uFF56', '\uFF37', '\uFF57', '\uFF38', '\uFF58', '\uFF39', '\uFF59', '\uFF3A', '\uFF5A'
        };

        private static ReadOnlySpan<ushort> EquivalenceFirstLevelLookup => new ushort[64]
        {
            0x0000, 0x0400, 0xffff, 0xffff, 0x0800, 0xffff, 0xffff, 0x0c00, 0x1000, 0x1400, 0xffff, 0x1800, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x1c00, 0x2000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x2400
        };

        private static ReadOnlySpan<ushort> EquivalenceCasingMap => new ushort[10240]
        {
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0x4000, 0x4002, 0x4004, 0x4006, 0x4008, 0x400a, 0x400c, 0x400e, 0x4010, 0x4012, 0x6014, 0x4017, 0x4019, 0x401b, 0x401d,
            0x401f, 0x4021, 0x4023, 0x4025, 0x4027, 0x4029, 0x402b, 0x402d, 0x402f, 0x4031, 0x4033, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0x4000, 0x4002, 0x4004, 0x4006, 0x4008, 0x400a, 0x400c, 0x400e, 0x4010, 0x4012, 0x6014, 0x4017, 0x4019, 0x401b, 0x401d,
            0x401f, 0x4021, 0x4023, 0x4025, 0x4027, 0x4029, 0x402b, 0x402d, 0x402f, 0x4031, 0x4033, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0x4035, 0x4037, 0x4039, 0x403b, 0x403d, 0x603f, 0x4042, 0x4044, 0x4046, 0x4048, 0x404a, 0x404c, 0x404e, 0x4050, 0x4052, 0x4054,
            0x4056, 0x4058, 0x405a, 0x405c, 0x405e, 0x4060, 0x4062, 0xffff, 0x4064, 0x4066, 0x4068, 0x406a, 0x406c, 0x406e, 0x4070, 0x4594,
            0x4035, 0x4037, 0x4039, 0x403b, 0x403d, 0x603f, 0x4042, 0x4044, 0x4046, 0x4048, 0x404a, 0x404c, 0x404e, 0x4050, 0x4052, 0x4054,
            0x4056, 0x4058, 0x405a, 0x405c, 0x405e, 0x4060, 0x4062, 0xffff, 0x4064, 0x4066, 0x4068, 0x406a, 0x406c, 0x406e, 0x4070, 0x40e6,
            0x4072, 0x4072, 0x4074, 0x4074, 0x4076, 0x4076, 0x4078, 0x4078, 0x407a, 0x407a, 0x407c, 0x407c, 0x407e, 0x407e, 0x4080, 0x4080,
            0x4082, 0x4082, 0x4084, 0x4084, 0x4086, 0x4086, 0x4088, 0x4088, 0x408a, 0x408a, 0x408c, 0x408c, 0x408e, 0x408e, 0x4090, 0x4090,
            0x4092, 0x4092, 0x4094, 0x4094, 0x4096, 0x4096, 0x4098, 0x4098, 0x409a, 0x409a, 0x409c, 0x409c, 0x409e, 0x409e, 0x40a0, 0x40a0,
            0xffff, 0xffff, 0x40a2, 0x40a2, 0x40a4, 0x40a4, 0x40a6, 0x40a6, 0xffff, 0x40a8, 0x40a8, 0x40aa, 0x40aa, 0x40ac, 0x40ac, 0x40ae,
            0x40ae, 0x40b0, 0x40b0, 0x40b2, 0x40b2, 0x40b4, 0x40b4, 0x40b6, 0x40b6, 0xffff, 0x40b8, 0x40b8, 0x40ba, 0x40ba, 0x40bc, 0x40bc,
            0x40be, 0x40be, 0x40c0, 0x40c0, 0x40c2, 0x40c2, 0x40c4, 0x40c4, 0x40c6, 0x40c6, 0x40c8, 0x40c8, 0x40ca, 0x40ca, 0x40cc, 0x40cc,
            0x40ce, 0x40ce, 0x40d0, 0x40d0, 0x40d2, 0x40d2, 0x40d4, 0x40d4, 0x40d6, 0x40d6, 0x40d8, 0x40d8, 0x40da, 0x40da, 0x40dc, 0x40dc,
            0x40de, 0x40de, 0x40e0, 0x40e0, 0x40e2, 0x40e2, 0x40e4, 0x40e4, 0x40e6, 0x40e8, 0x40e8, 0x40ea, 0x40ea, 0x40ec, 0x40ec, 0xffff,
            0x41b0, 0x40ee, 0x40f0, 0x40f0, 0x40f2, 0x40f2, 0x40f4, 0x40f6, 0x40f6, 0x40f8, 0x40fa, 0x40fc, 0x40fc, 0xffff, 0x40fe, 0x4100,
            0x4102, 0x4104, 0x4104, 0x4106, 0x4108, 0x4166, 0x410a, 0x410c, 0x410e, 0x410e, 0x41aa, 0xffff, 0x4110, 0x4112, 0x4192, 0x4114,
            0x4116, 0x4116, 0x4118, 0x4118, 0x411a, 0x411a, 0x411c, 0x411e, 0x411e, 0x4120, 0xffff, 0xffff, 0x4122, 0x4122, 0x4124, 0x4126,
            0x4126, 0x4128, 0x412a, 0x412c, 0x412c, 0x412e, 0x412e, 0x4130, 0x4132, 0x4132, 0xffff, 0xffff, 0x4134, 0x4134, 0xffff, 0x4168,
            0xffff, 0xffff, 0xffff, 0xffff, 0x6136, 0x6136, 0x6136, 0x6139, 0x6139, 0x6139, 0x613c, 0x613c, 0x613c, 0x413f, 0x413f, 0x4141,
            0x4141, 0x4143, 0x4143, 0x4145, 0x4145, 0x4147, 0x4147, 0x4149, 0x4149, 0x414b, 0x414b, 0x414d, 0x414d, 0x40fe, 0x414f, 0x414f,
            0x4151, 0x4151, 0x4153, 0x4153, 0x4155, 0x4155, 0x4157, 0x4157, 0x4159, 0x4159, 0x415b, 0x415b, 0x415d, 0x415d, 0x415f, 0x415f,
            0xffff, 0x6161, 0x6161, 0x6161, 0x4164, 0x4164, 0x4166, 0x4168, 0x416a, 0x416a, 0x416c, 0x416c, 0x416e, 0x416e, 0x4170, 0x4170,
            0x4172, 0x4172, 0x4174, 0x4174, 0x4176, 0x4176, 0x4178, 0x4178, 0x417a, 0x417a, 0x417c, 0x417c, 0x417e, 0x417e, 0x4180, 0x4180,
            0x4182, 0x4182, 0x4184, 0x4184, 0x4186, 0x4186, 0x4188, 0x4188, 0x418a, 0x418a, 0x418c, 0x418c, 0x418e, 0x418e, 0x4190, 0x4190,
            0x4192, 0xffff, 0x4194, 0x4194, 0x4196, 0x4196, 0x4198, 0x4198, 0x419a, 0x419a, 0x419c, 0x419c, 0x419e, 0x419e, 0x41a0, 0x41a0,
            0x41a2, 0x41a2, 0x41a4, 0x41a4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x41a6, 0x41a8, 0x41a8, 0x41aa, 0x41ac, 0x4788,
            0x478a, 0x41ae, 0x41ae, 0x41b0, 0x41b2, 0x41b4, 0x41b6, 0x41b6, 0x41b8, 0x41b8, 0x41ba, 0x41ba, 0x41bc, 0x41bc, 0x41be, 0x41be,
            0x4780, 0x477c, 0x4782, 0x40ee, 0x40f4, 0xffff, 0x40f8, 0x40fa, 0xffff, 0x4100, 0xffff, 0x4102, 0x48ba, 0xffff, 0xffff, 0xffff,
            0x4106, 0x48bc, 0xffff, 0x4108, 0xffff, 0x489e, 0x48b8, 0xffff, 0x410c, 0x410a, 0x48c0, 0x4770, 0x48be, 0xffff, 0xffff, 0x4110,
            0xffff, 0x477e, 0x4112, 0xffff, 0xffff, 0x4114, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x4774, 0xffff, 0xffff,
            0x411c, 0xffff, 0x48dc, 0x4120, 0xffff, 0xffff, 0xffff, 0x48c4, 0x4124, 0x41b2, 0x4128, 0x412a, 0x41b4, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0x4130, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x48c6, 0x48c2, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0x41c0, 0x41c0, 0x41c2, 0x41c2, 0xffff, 0xffff, 0x41c4, 0x41c4, 0xffff, 0xffff, 0xffff, 0x422c, 0x422e, 0x4230, 0xffff, 0x41c6,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x41c8, 0xffff, 0x41ca, 0x41cc, 0x41ce, 0xffff, 0x41d0, 0xffff, 0x41d2, 0x41d4,
            0xffff, 0x41d6, 0x41d8, 0x41da, 0x41dc, 0x41de, 0x41e0, 0x41e2, 0x61e4, 0x41e7, 0x41e9, 0x41eb, 0x41ed, 0x41ef, 0x41f1, 0x41f3,
            0x41f5, 0x41f7, 0xffff, 0x41f9, 0x41fb, 0x41fd, 0x41ff, 0x4201, 0x4203, 0x6205, 0x4208, 0x420a, 0x41c8, 0x41ca, 0x41cc, 0x41ce,
            0xffff, 0x41d6, 0x41d8, 0x41da, 0x41dc, 0x41de, 0x41e0, 0x41e2, 0x61e4, 0x41e7, 0x41e9, 0x41eb, 0x41ed, 0x41ef, 0x41f1, 0x41f3,
            0x41f5, 0x41f7, 0xffff, 0x41f9, 0x41fb, 0x41fd, 0x41ff, 0x4201, 0x4203, 0x6205, 0x4208, 0x420a, 0x41d0, 0x41d2, 0x41d4, 0x420c,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x420c, 0x420e, 0x420e, 0x4210, 0x4210, 0x4212, 0x4212, 0x4214, 0x4214,
            0x4216, 0x4216, 0x4218, 0x4218, 0x421a, 0x421a, 0x421c, 0x421c, 0x421e, 0x421e, 0x4220, 0x4220, 0x4222, 0x4222, 0x4224, 0x4224,
            0xffff, 0xffff, 0x4228, 0x41c6, 0x61e4, 0xffff, 0xffff, 0x4226, 0x4226, 0x4228, 0x422a, 0x422a, 0xffff, 0x422c, 0x422e, 0x4230,
            0x4232, 0x4234, 0x4236, 0x4238, 0x423a, 0x423c, 0x423e, 0x4240, 0x4242, 0x4244, 0x4246, 0x4248, 0x424a, 0x424c, 0x424e, 0x4250,
            0x4252, 0x4254, 0x4256, 0x4258, 0x425a, 0x425c, 0x425e, 0x4260, 0x4262, 0x4264, 0x4266, 0x4268, 0x426a, 0x426c, 0x426e, 0x4270,
            0x4272, 0x4274, 0x4276, 0x4278, 0x427a, 0x427c, 0x427e, 0x4280, 0x4282, 0x4284, 0x4286, 0x4288, 0x428a, 0x428c, 0x428e, 0x4290,
            0x4252, 0x4254, 0x4256, 0x4258, 0x425a, 0x425c, 0x425e, 0x4260, 0x4262, 0x4264, 0x4266, 0x4268, 0x426a, 0x426c, 0x426e, 0x4270,
            0x4272, 0x4274, 0x4276, 0x4278, 0x427a, 0x427c, 0x427e, 0x4280, 0x4282, 0x4284, 0x4286, 0x4288, 0x428a, 0x428c, 0x428e, 0x4290,
            0x4232, 0x4234, 0x4236, 0x4238, 0x423a, 0x423c, 0x423e, 0x4240, 0x4242, 0x4244, 0x4246, 0x4248, 0x424a, 0x424c, 0x424e, 0x4250,
            0x4292, 0x4292, 0x4294, 0x4294, 0x4296, 0x4296, 0x4298, 0x4298, 0x429a, 0x429a, 0x429c, 0x429c, 0x429e, 0x429e, 0x42a0, 0x42a0,
            0x42a2, 0x42a2, 0x42a4, 0x42a4, 0x42a6, 0x42a6, 0x42a8, 0x42a8, 0x42aa, 0x42aa, 0x42ac, 0x42ac, 0x42ae, 0x42ae, 0x42b0, 0x42b0,
            0x42b2, 0x42b2, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x42b4, 0x42b4, 0x42b6, 0x42b6, 0x42b8, 0x42b8,
            0x42ba, 0x42ba, 0x42bc, 0x42bc, 0x42be, 0x42be, 0x42c0, 0x42c0, 0x42c2, 0x42c2, 0x42c4, 0x42c4, 0x42c6, 0x42c6, 0x42c8, 0x42c8,
            0x42ca, 0x42ca, 0x42cc, 0x42cc, 0x42ce, 0x42ce, 0x42d0, 0x42d0, 0x42d2, 0x42d2, 0x42d4, 0x42d4, 0x42d6, 0x42d6, 0x42d8, 0x42d8,
            0x42da, 0x42da, 0x42dc, 0x42dc, 0x42de, 0x42de, 0x42e0, 0x42e0, 0x42e2, 0x42e2, 0x42e4, 0x42e4, 0x42e6, 0x42e6, 0x42e8, 0x42e8,
            0x42ea, 0x42ec, 0x42ec, 0x42ee, 0x42ee, 0x42f0, 0x42f0, 0x42f2, 0x42f2, 0x42f4, 0x42f4, 0x42f6, 0x42f6, 0x42f8, 0x42f8, 0x42ea,
            0x42fa, 0x42fa, 0x42fc, 0x42fc, 0x42fe, 0x42fe, 0x4300, 0x4300, 0x4302, 0x4302, 0x4304, 0x4304, 0x4306, 0x4306, 0x4308, 0x4308,
            0x430a, 0x430a, 0x430c, 0x430c, 0x430e, 0x430e, 0x4310, 0x4310, 0x4312, 0x4312, 0x4314, 0x4314, 0x4316, 0x4316, 0x4318, 0x4318,
            0x431a, 0x431a, 0x431c, 0x431c, 0x431e, 0x431e, 0x4320, 0x4320, 0x4322, 0x4322, 0x4324, 0x4324, 0x4326, 0x4326, 0x4328, 0x4328,
            0x432a, 0x432a, 0x432c, 0x432c, 0x432e, 0x432e, 0x4330, 0x4330, 0x4332, 0x4332, 0x4334, 0x4334, 0x4336, 0x4336, 0x4338, 0x4338,
            0x433a, 0x433a, 0x433c, 0x433c, 0x433e, 0x433e, 0x4340, 0x4340, 0x4342, 0x4342, 0x4344, 0x4344, 0x4346, 0x4346, 0x4348, 0x4348,
            0x434a, 0x434a, 0x434c, 0x434c, 0x434e, 0x434e, 0x4350, 0x4350, 0x4352, 0x4352, 0x4354, 0x4354, 0x4356, 0x4356, 0x4358, 0x4358,
            0xffff, 0x435a, 0x435c, 0x435e, 0x4360, 0x4362, 0x4364, 0x4366, 0x4368, 0x436a, 0x436c, 0x436e, 0x4370, 0x4372, 0x4374, 0x4376,
            0x4378, 0x437a, 0x437c, 0x437e, 0x4380, 0x4382, 0x4384, 0x4386, 0x4388, 0x438a, 0x438c, 0x438e, 0x4390, 0x4392, 0x4394, 0x4396,
            0x4398, 0x439a, 0x439c, 0x439e, 0x43a0, 0x43a2, 0x43a4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0x435a, 0x435c, 0x435e, 0x4360, 0x4362, 0x4364, 0x4366, 0x4368, 0x436a, 0x436c, 0x436e, 0x4370, 0x4372, 0x4374, 0x4376,
            0x4378, 0x437a, 0x437c, 0x437e, 0x4380, 0x4382, 0x4384, 0x4386, 0x4388, 0x438a, 0x438c, 0x438e, 0x4390, 0x4392, 0x4394, 0x4396,
            0x4398, 0x439a, 0x439c, 0x439e, 0x43a0, 0x43a2, 0x43a4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0x43a6, 0x43a8, 0x43aa, 0x43ac, 0x43ae, 0x43b0, 0x43b2, 0x43b4, 0x43b6, 0x43b8, 0x43ba, 0x43bc, 0x43be, 0x43c0, 0x43c2, 0x43c4,
            0x43c6, 0x43c8, 0x43ca, 0x43cc, 0x43ce, 0x43d0, 0x43d2, 0x43d4, 0x43d6, 0x43d8, 0x43da, 0x43dc, 0x43de, 0x43e0, 0x43e2, 0x43e4,
            0x43e6, 0x43e8, 0x43ea, 0x43ec, 0x43ee, 0x43f0, 0xffff, 0x43f2, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x43f4, 0xffff, 0xffff,
            0x44a2, 0x44a4, 0x44a6, 0x44a8, 0x44aa, 0x44ac, 0x44ae, 0x44b0, 0x44b2, 0x44b4, 0x44b6, 0x44b8, 0x44ba, 0x44bc, 0x44be, 0x44c0,
            0x44c2, 0x44c4, 0x44c6, 0x44c8, 0x44ca, 0x44cc, 0x44ce, 0x44d0, 0x44d2, 0x44d4, 0x44d6, 0x44d8, 0x44da, 0x44dc, 0x44de, 0x44e0,
            0x44e2, 0x44e4, 0x44e6, 0x44e8, 0x44ea, 0x44ec, 0x44ee, 0x44f0, 0x44f2, 0x44f4, 0x44f6, 0xffff, 0xffff, 0x44f8, 0x44fa, 0x44fc,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0x43f6, 0x43f8, 0x43fa, 0x43fc, 0x43fe, 0x4400, 0x4402, 0x4404, 0x4406, 0x4408, 0x440a, 0x440c, 0x440e, 0x4410, 0x4412, 0x4414,
            0x4416, 0x4418, 0x441a, 0x441c, 0x441e, 0x4420, 0x4422, 0x4424, 0x4426, 0x4428, 0x442a, 0x442c, 0x442e, 0x4430, 0x4432, 0x4434,
            0x4436, 0x4438, 0x443a, 0x443c, 0x443e, 0x4440, 0x4442, 0x4444, 0x4446, 0x4448, 0x444a, 0x444c, 0x444e, 0x4450, 0x4452, 0x4454,
            0x4456, 0x4458, 0x445a, 0x445c, 0x445e, 0x4460, 0x4462, 0x4464, 0x4466, 0x4468, 0x446a, 0x446c, 0x446e, 0x4470, 0x4472, 0x4474,
            0x4476, 0x4478, 0x447a, 0x447c, 0x447e, 0x4480, 0x4482, 0x4484, 0x4486, 0x4488, 0x448a, 0x448c, 0x448e, 0x4490, 0x4492, 0x4494,
            0x4496, 0x4498, 0x449a, 0x449c, 0x449e, 0x44a0, 0xffff, 0xffff, 0x4496, 0x4498, 0x449a, 0x449c, 0x449e, 0x44a0, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0x44a2, 0x44a4, 0x44a6, 0x44a8, 0x44aa, 0x44ac, 0x44ae, 0x44b0, 0x44b2, 0x44b4, 0x44b6, 0x44b8, 0x44ba, 0x44bc, 0x44be, 0x44c0,
            0x44c2, 0x44c4, 0x44c6, 0x44c8, 0x44ca, 0x44cc, 0x44ce, 0x44d0, 0x44d2, 0x44d4, 0x44d6, 0x44d8, 0x44da, 0x44dc, 0x44de, 0x44e0,
            0x44e2, 0x44e4, 0x44e6, 0x44e8, 0x44ea, 0x44ec, 0x44ee, 0x44f0, 0x44f2, 0x44f4, 0x44f6, 0xffff, 0xffff, 0x44f8, 0x44fa, 0x44fc,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x4890, 0xffff, 0xffff, 0xffff, 0x4772, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x48de, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0x44fe, 0x44fe, 0x4500, 0x4500, 0x4502, 0x4502, 0x4504, 0x4504, 0x4506, 0x4506, 0x4508, 0x4508, 0x450a, 0x450a, 0x450c, 0x450c,
            0x450e, 0x450e, 0x4510, 0x4510, 0x4512, 0x4512, 0x4514, 0x4514, 0x4516, 0x4516, 0x4518, 0x4518, 0x451a, 0x451a, 0x451c, 0x451c,
            0x451e, 0x451e, 0x4520, 0x4520, 0x4522, 0x4522, 0x4524, 0x4524, 0x4526, 0x4526, 0x4528, 0x4528, 0x452a, 0x452a, 0x452c, 0x452c,
            0x452e, 0x452e, 0x4530, 0x4530, 0x4532, 0x4532, 0x4534, 0x4534, 0x4536, 0x4536, 0x4538, 0x4538, 0x453a, 0x453a, 0x453c, 0x453c,
            0x453e, 0x453e, 0x4540, 0x4540, 0x4542, 0x4542, 0x4544, 0x4544, 0x4546, 0x4546, 0x4548, 0x4548, 0x454a, 0x454a, 0x454c, 0x454c,
            0x454e, 0x454e, 0x4550, 0x4550, 0x4552, 0x4552, 0x4554, 0x4554, 0x4556, 0x4556, 0x4558, 0x4558, 0x455a, 0x455a, 0x455c, 0x455c,
            0x455e, 0x455e, 0x4560, 0x4560, 0x4562, 0x4562, 0x4564, 0x4564, 0x4566, 0x4566, 0x4568, 0x4568, 0x456a, 0x456a, 0x456c, 0x456c,
            0x456e, 0x456e, 0x4570, 0x4570, 0x4572, 0x4572, 0x4574, 0x4574, 0x4576, 0x4576, 0x4578, 0x4578, 0x457a, 0x457a, 0x457c, 0x457c,
            0x457e, 0x457e, 0x4580, 0x4580, 0x4582, 0x4582, 0x4584, 0x4584, 0x4586, 0x4586, 0x4588, 0x4588, 0x458a, 0x458a, 0x458c, 0x458c,
            0x458e, 0x458e, 0x4590, 0x4590, 0x4592, 0x4592, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x4594, 0xffff,
            0x4596, 0x4596, 0x4598, 0x4598, 0x459a, 0x459a, 0x459c, 0x459c, 0x459e, 0x459e, 0x45a0, 0x45a0, 0x45a2, 0x45a2, 0x45a4, 0x45a4,
            0x45a6, 0x45a6, 0x45a8, 0x45a8, 0x45aa, 0x45aa, 0x45ac, 0x45ac, 0x45ae, 0x45ae, 0x45b0, 0x45b0, 0x45b2, 0x45b2, 0x45b4, 0x45b4,
            0x45b6, 0x45b6, 0x45b8, 0x45b8, 0x45ba, 0x45ba, 0x45bc, 0x45bc, 0x45be, 0x45be, 0x45c0, 0x45c0, 0x45c2, 0x45c2, 0x45c4, 0x45c4,
            0x45c6, 0x45c6, 0x45c8, 0x45c8, 0x45ca, 0x45ca, 0x45cc, 0x45cc, 0x45ce, 0x45ce, 0x45d0, 0x45d0, 0x45d2, 0x45d2, 0x45d4, 0x45d4,
            0x45d6, 0x45d6, 0x45d8, 0x45d8, 0x45da, 0x45da, 0x45dc, 0x45dc, 0x45de, 0x45de, 0x45e0, 0x45e0, 0x45e2, 0x45e2, 0x45e4, 0x45e4,
            0x45e6, 0x45e6, 0x45e8, 0x45e8, 0x45ea, 0x45ea, 0x45ec, 0x45ec, 0x45ee, 0x45ee, 0x45f0, 0x45f0, 0x45f2, 0x45f2, 0x45f4, 0x45f4,
            0x45f6, 0x45f8, 0x45fa, 0x45fc, 0x45fe, 0x4600, 0x4602, 0x4604, 0x45f6, 0x45f8, 0x45fa, 0x45fc, 0x45fe, 0x4600, 0x4602, 0x4604,
            0x4606, 0x4608, 0x460a, 0x460c, 0x460e, 0x4610, 0xffff, 0xffff, 0x4606, 0x4608, 0x460a, 0x460c, 0x460e, 0x4610, 0xffff, 0xffff,
            0x4612, 0x4614, 0x4616, 0x4618, 0x461a, 0x461c, 0x461e, 0x4620, 0x4612, 0x4614, 0x4616, 0x4618, 0x461a, 0x461c, 0x461e, 0x4620,
            0x4622, 0x4624, 0x4626, 0x4628, 0x462a, 0x462c, 0x462e, 0x4630, 0x4622, 0x4624, 0x4626, 0x4628, 0x462a, 0x462c, 0x462e, 0x4630,
            0x4632, 0x4634, 0x4636, 0x4638, 0x463a, 0x463c, 0xffff, 0xffff, 0x4632, 0x4634, 0x4636, 0x4638, 0x463a, 0x463c, 0xffff, 0xffff,
            0xffff, 0x463e, 0xffff, 0x4640, 0xffff, 0x4642, 0xffff, 0x4644, 0xffff, 0x463e, 0xffff, 0x4640, 0xffff, 0x4642, 0xffff, 0x4644,
            0x4646, 0x4648, 0x464a, 0x464c, 0x464e, 0x4650, 0x4652, 0x4654, 0x4646, 0x4648, 0x464a, 0x464c, 0x464e, 0x4650, 0x4652, 0x4654,
            0x468a, 0x468c, 0x4690, 0x4692, 0x4694, 0x4696, 0x469e, 0x46a0, 0x46ac, 0x46ae, 0x46a6, 0x46a8, 0x46b0, 0x46b2, 0xffff, 0xffff,
            0x4656, 0x4658, 0x465a, 0x465c, 0x465e, 0x4660, 0x4662, 0x4664, 0x4656, 0x4658, 0x465a, 0x465c, 0x465e, 0x4660, 0x4662, 0x4664,
            0x4666, 0x4668, 0x466a, 0x466c, 0x466e, 0x4670, 0x4672, 0x4674, 0x4666, 0x4668, 0x466a, 0x466c, 0x466e, 0x4670, 0x4672, 0x4674,
            0x4676, 0x4678, 0x467a, 0x467c, 0x467e, 0x4680, 0x4682, 0x4684, 0x4676, 0x4678, 0x467a, 0x467c, 0x467e, 0x4680, 0x4682, 0x4684,
            0x4686, 0x4688, 0xffff, 0x468e, 0xffff, 0xffff, 0xffff, 0xffff, 0x4686, 0x4688, 0x468a, 0x468c, 0x468e, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0x4698, 0xffff, 0xffff, 0xffff, 0xffff, 0x4690, 0x4692, 0x4694, 0x4696, 0x4698, 0xffff, 0xffff, 0xffff,
            0x469a, 0x469c, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x469a, 0x469c, 0x469e, 0x46a0, 0xffff, 0xffff, 0xffff, 0xffff,
            0x46a2, 0x46a4, 0xffff, 0xffff, 0xffff, 0x46aa, 0xffff, 0xffff, 0x46a2, 0x46a4, 0x46a6, 0x46a8, 0x46aa, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0x46b4, 0xffff, 0xffff, 0xffff, 0xffff, 0x46ac, 0x46ae, 0x46b0, 0x46b2, 0x46b4, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6205, 0xffff, 0xffff, 0xffff, 0x6014, 0x603f, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0x46b6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x46b6, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0x46b8, 0x46ba, 0x46bc, 0x46be, 0x46c0, 0x46c2, 0x46c4, 0x46c6, 0x46c8, 0x46ca, 0x46cc, 0x46ce, 0x46d0, 0x46d2, 0x46d4, 0x46d6,
            0x46b8, 0x46ba, 0x46bc, 0x46be, 0x46c0, 0x46c2, 0x46c4, 0x46c6, 0x46c8, 0x46ca, 0x46cc, 0x46ce, 0x46d0, 0x46d2, 0x46d4, 0x46d6,
            0xffff, 0xffff, 0xffff, 0x46d8, 0x46d8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x46da, 0x46dc, 0x46de, 0x46e0, 0x46e2, 0x46e4, 0x46e6, 0x46e8, 0x46ea, 0x46ec,
            0x46ee, 0x46f0, 0x46f2, 0x46f4, 0x46f6, 0x46f8, 0x46fa, 0x46fc, 0x46fe, 0x4700, 0x4702, 0x4704, 0x4706, 0x4708, 0x470a, 0x470c,
            0x46da, 0x46dc, 0x46de, 0x46e0, 0x46e2, 0x46e4, 0x46e6, 0x46e8, 0x46ea, 0x46ec, 0x46ee, 0x46f0, 0x46f2, 0x46f4, 0x46f6, 0x46f8,
            0x46fa, 0x46fc, 0x46fe, 0x4700, 0x4702, 0x4704, 0x4706, 0x4708, 0x470a, 0x470c, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0x470e, 0x4710, 0x4712, 0x4714, 0x4716, 0x4718, 0x471a, 0x471c, 0x471e, 0x4720, 0x4722, 0x4724, 0x4726, 0x4728, 0x472a, 0x472c,
            0x472e, 0x4730, 0x4732, 0x4734, 0x4736, 0x4738, 0x473a, 0x473c, 0x473e, 0x4740, 0x4742, 0x4744, 0x4746, 0x4748, 0x474a, 0x474c,
            0x474e, 0x4750, 0x4752, 0x4754, 0x4756, 0x4758, 0x475a, 0x475c, 0x475e, 0x4760, 0x4762, 0x4764, 0x4766, 0x4768, 0x476a, 0x476c,
            0x470e, 0x4710, 0x4712, 0x4714, 0x4716, 0x4718, 0x471a, 0x471c, 0x471e, 0x4720, 0x4722, 0x4724, 0x4726, 0x4728, 0x472a, 0x472c,
            0x472e, 0x4730, 0x4732, 0x4734, 0x4736, 0x4738, 0x473a, 0x473c, 0x473e, 0x4740, 0x4742, 0x4744, 0x4746, 0x4748, 0x474a, 0x474c,
            0x474e, 0x4750, 0x4752, 0x4754, 0x4756, 0x4758, 0x475a, 0x475c, 0x475e, 0x4760, 0x4762, 0x4764, 0x4766, 0x4768, 0x476a, 0x476c,
            0x476e, 0x476e, 0x4770, 0x4772, 0x4774, 0x41a6, 0x41ac, 0x4776, 0x4776, 0x4778, 0x4778, 0x477a, 0x477a, 0x477c, 0x477e, 0x4780,
            0x4782, 0xffff, 0x4784, 0x4784, 0xffff, 0x4786, 0x4786, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x4788, 0x478a,
            0x478c, 0x478c, 0x478e, 0x478e, 0x4790, 0x4790, 0x4792, 0x4792, 0x4794, 0x4794, 0x4796, 0x4796, 0x4798, 0x4798, 0x479a, 0x479a,
            0x479c, 0x479c, 0x479e, 0x479e, 0x47a0, 0x47a0, 0x47a2, 0x47a2, 0x47a4, 0x47a4, 0x47a6, 0x47a6, 0x47a8, 0x47a8, 0x47aa, 0x47aa,
            0x47ac, 0x47ac, 0x47ae, 0x47ae, 0x47b0, 0x47b0, 0x47b2, 0x47b2, 0x47b4, 0x47b4, 0x47b6, 0x47b6, 0x47b8, 0x47b8, 0x47ba, 0x47ba,
            0x47bc, 0x47bc, 0x47be, 0x47be, 0x47c0, 0x47c0, 0x47c2, 0x47c2, 0x47c4, 0x47c4, 0x47c6, 0x47c6, 0x47c8, 0x47c8, 0x47ca, 0x47ca,
            0x47cc, 0x47cc, 0x47ce, 0x47ce, 0x47d0, 0x47d0, 0x47d2, 0x47d2, 0x47d4, 0x47d4, 0x47d6, 0x47d6, 0x47d8, 0x47d8, 0x47da, 0x47da,
            0x47dc, 0x47dc, 0x47de, 0x47de, 0x47e0, 0x47e0, 0x47e2, 0x47e2, 0x47e4, 0x47e4, 0x47e6, 0x47e6, 0x47e8, 0x47e8, 0x47ea, 0x47ea,
            0x47ec, 0x47ec, 0x47ee, 0x47ee, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x47f0, 0x47f0, 0x47f2, 0x47f2, 0xffff,
            0xffff, 0xffff, 0x47f4, 0x47f4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0x43a6, 0x43a8, 0x43aa, 0x43ac, 0x43ae, 0x43b0, 0x43b2, 0x43b4, 0x43b6, 0x43b8, 0x43ba, 0x43bc, 0x43be, 0x43c0, 0x43c2, 0x43c4,
            0x43c6, 0x43c8, 0x43ca, 0x43cc, 0x43ce, 0x43d0, 0x43d2, 0x43d4, 0x43d6, 0x43d8, 0x43da, 0x43dc, 0x43de, 0x43e0, 0x43e2, 0x43e4,
            0x43e6, 0x43e8, 0x43ea, 0x43ec, 0x43ee, 0x43f0, 0xffff, 0x43f2, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x43f4, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0x47f6, 0x47f6, 0x47f8, 0x47f8, 0x47fa, 0x47fa, 0x47fc, 0x47fc, 0x47fe, 0x47fe, 0x4800, 0x4800, 0x4802, 0x4802, 0x4804, 0x4804,
            0x4806, 0x4806, 0x4808, 0x4808, 0x480a, 0x480a, 0x480c, 0x480c, 0x480e, 0x480e, 0x4810, 0x4810, 0x4812, 0x4812, 0x4814, 0x4814,
            0x4816, 0x4816, 0x4818, 0x4818, 0x481a, 0x481a, 0x481c, 0x481c, 0x481e, 0x481e, 0x4820, 0x4820, 0x4822, 0x4822, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0x4824, 0x4824, 0x4826, 0x4826, 0x4828, 0x4828, 0x482a, 0x482a, 0x482c, 0x482c, 0x482e, 0x482e, 0x4830, 0x4830, 0x4832, 0x4832,
            0x4834, 0x4834, 0x4836, 0x4836, 0x4838, 0x4838, 0x483a, 0x483a, 0x483c, 0x483c, 0x483e, 0x483e, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0x4840, 0x4840, 0x4842, 0x4842, 0x4844, 0x4844, 0x4846, 0x4846, 0x4848, 0x4848, 0x484a, 0x484a, 0x484c, 0x484c,
            0xffff, 0xffff, 0x484e, 0x484e, 0x4850, 0x4850, 0x4852, 0x4852, 0x4854, 0x4854, 0x4856, 0x4856, 0x4858, 0x4858, 0x485a, 0x485a,
            0x485c, 0x485c, 0x485e, 0x485e, 0x4860, 0x4860, 0x4862, 0x4862, 0x4864, 0x4864, 0x4866, 0x4866, 0x4868, 0x4868, 0x486a, 0x486a,
            0x486c, 0x486c, 0x486e, 0x486e, 0x4870, 0x4870, 0x4872, 0x4872, 0x4874, 0x4874, 0x4876, 0x4876, 0x4878, 0x4878, 0x487a, 0x487a,
            0x487c, 0x487c, 0x487e, 0x487e, 0x4880, 0x4880, 0x4882, 0x4882, 0x4884, 0x4884, 0x4886, 0x4886, 0x4888, 0x4888, 0x488a, 0x488a,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x488c, 0x488c, 0x488e, 0x488e, 0x4890, 0x4892, 0x4892,
            0x4894, 0x4894, 0x4896, 0x4896, 0x4898, 0x4898, 0x489a, 0x489a, 0xffff, 0xffff, 0xffff, 0x489c, 0x489c, 0x489e, 0xffff, 0xffff,
            0x48a0, 0x48a0, 0x48a2, 0x48a2, 0x48da, 0xffff, 0x48a4, 0x48a4, 0x48a6, 0x48a6, 0x48a8, 0x48a8, 0x48aa, 0x48aa, 0x48ac, 0x48ac,
            0x48ae, 0x48ae, 0x48b0, 0x48b0, 0x48b2, 0x48b2, 0x48b4, 0x48b4, 0x48b6, 0x48b6, 0x48b8, 0x48ba, 0x48bc, 0x48be, 0x48c0, 0xffff,
            0x48c2, 0x48c4, 0x48c6, 0x48c8, 0x48ca, 0x48ca, 0x48cc, 0x48cc, 0x48ce, 0x48ce, 0x48d0, 0x48d0, 0x48d2, 0x48d2, 0x48d4, 0x48d4,
            0x48d6, 0x48d6, 0x48d8, 0x48d8, 0x48da, 0x48dc, 0x48de, 0x48e0, 0x48e0, 0x48e2, 0x48e2, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0x48e4, 0x48e4, 0xffff, 0xffff, 0xffff, 0xffff, 0x48e6, 0x48e6, 0x48e8, 0x48e8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x48ea, 0x48ea, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0x48c8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0x43f6, 0x43f8, 0x43fa, 0x43fc, 0x43fe, 0x4400, 0x4402, 0x4404, 0x4406, 0x4408, 0x440a, 0x440c, 0x440e, 0x4410, 0x4412, 0x4414,
            0x4416, 0x4418, 0x441a, 0x441c, 0x441e, 0x4420, 0x4422, 0x4424, 0x4426, 0x4428, 0x442a, 0x442c, 0x442e, 0x4430, 0x4432, 0x4434,
            0x4436, 0x4438, 0x443a, 0x443c, 0x443e, 0x4440, 0x4442, 0x4444, 0x4446, 0x4448, 0x444a, 0x444c, 0x444e, 0x4450, 0x4452, 0x4454,
            0x4456, 0x4458, 0x445a, 0x445c, 0x445e, 0x4460, 0x4462, 0x4464, 0x4466, 0x4468, 0x446a, 0x446c, 0x446e, 0x4470, 0x4472, 0x4474,
            0x4476, 0x4478, 0x447a, 0x447c, 0x447e, 0x4480, 0x4482, 0x4484, 0x4486, 0x4488, 0x448a, 0x448c, 0x448e, 0x4490, 0x4492, 0x4494,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0x48ec, 0x48ee, 0x48f0, 0x48f2, 0x48f4, 0x48f6, 0x48f8, 0x48fa, 0x48fc, 0x48fe, 0x4900, 0x4902, 0x4904, 0x4906, 0x4908,
            0x490a, 0x490c, 0x490e, 0x4910, 0x4912, 0x4914, 0x4916, 0x4918, 0x491a, 0x491c, 0x491e, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0x48ec, 0x48ee, 0x48f0, 0x48f2, 0x48f4, 0x48f6, 0x48f8, 0x48fa, 0x48fc, 0x48fe, 0x4900, 0x4902, 0x4904, 0x4906, 0x4908,
            0x490a, 0x490c, 0x490e, 0x4910, 0x4912, 0x4914, 0x4916, 0x4918, 0x491a, 0x491c, 0x491e, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
            0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
        };
    }
}
