import { TSortFunction } from "./TableClientSide/state/sortSlice";
import { TUseSelect } from "./TableClientSide/state/selectSlice";
import { MenuProps, ModalProps } from "@mantine/core";
import { ReactNode } from "react";
import { TPartialHeaderCol } from "./hooks/useRowFactoryBuilder/types";
import { TPaging, TSorting } from "../../genericTypes";
export type TServerSideTableMetadata = null | {
    paging?: TPaging;
    sorting?: TSorting;
};
export declare enum DEFAULT_COLUMNS {
    SELECT_ALL = "select_all",
    ACTION = "action"
}
export type TTableAccessorReturn = any;
interface THeaderConfigBasics<T> {
    id: string;
    label: string;
    accessor: (row: T) => TTableAccessorReturn;
    component?: ({ row, value }: {
        row: T;
        value: TTableAccessorReturn;
    }) => JSX.Element;
    sorting?: {
        enabled: boolean;
        sortFn?: TSortFunction<T>;
    };
}
interface THeaderConfigWithComponent<T> extends THeaderConfigBasics<T> {
    label: never;
}
interface THeaderConfigWithLabel<T> extends THeaderConfigBasics<T> {
    label: string | any;
}
export type THeaderConfig<T> = THeaderConfigWithComponent<T> | THeaderConfigWithLabel<T>;
export type TnoDataBadgeConfig<T> = {
    content?: React.FC<{
        row: T;
        col: TPartialHeaderCol<T>;
    }>;
    component?: React.FC<{
        row: T;
        col: TPartialHeaderCol<T>;
    }>;
    pattern?: (args: {
        row: T;
        value: TTableAccessorReturn;
    }) => boolean;
    disabled?: boolean;
};
export declare enum ETableRowStatus {
    IN_DELETION_PROCESS = "IN_DELETION_PROCESS"
}
export type TTableRowConfig<T> = {
    rowStatus?: (row: T) => ETableRowStatus | undefined;
};
export type TTableConfig<T> = {
    columns: Array<THeaderConfig<T>>;
    rows?: TTableRowConfig<T>;
    rowIdentifierAccessor: (row: T) => string;
    enableSelect?: boolean;
    sorting: {
        default: TSorting;
    };
    meta?: {
        noDataTextContent?: ReactNode;
        noDataBadge?: TnoDataBadgeConfig<T>;
    };
};
export type TUseTableConfigInternal<T> = TTableConfig<T> & {
    action?: ({ row, columns, id, }: {
        row: T;
        columns: THeaderConfig<T>[];
        id: string;
    }) => JSX.Element;
};
export type THeader = {
    id: string;
    label: any;
    actions: {
        autoSort: () => void;
        selectAll: () => void;
    };
    meta: {
        sorting: {
            isSorted: boolean;
            isSortable: boolean;
            direction: string;
        };
        isGenerated: boolean;
    };
};
export type TPaginationReturnProps = {
    index: number;
    size: number;
    totalDisplayableResults: number;
    totalResults?: number;
    actions: {
        gotoPageIndex: (index: number) => void;
        setPageSize: (size: number) => void;
    };
};
export type TTableReturnRowMeta = {
    component: string | React.ReactElement;
    events: {
        onClick: (event: any) => void;
    };
    selection: {
        setSelected: () => void;
        selected: boolean;
    };
    id: string;
};
export type TTableReturnRow<T> = {
    raw: T;
    id: string;
    status?: ETableRowStatus;
    getColumns: () => Array<TTableReturnRowMeta>;
};
export type TUseTableReturn<T> = {
    head: {
        columns: Array<THeader>;
    };
    body: {
        fillers: Array<{
            colSpan: number;
        }>;
        rows: Array<TTableReturnRow<T>>;
        meta: {
            noDataTextContent?: ReactNode;
        };
    };
    paging: TPaginationReturnProps;
    selection: ReturnType<TUseSelect>;
};
export type TActionMenuRawProps<T> = {
    row: T;
    columns: THeaderConfig<T>[];
    id: string;
};
export type TWiredActionMenuProps<T> = {
    tableProps: TActionMenuRawProps<T>;
    menuProps?: Partial<MenuProps>;
    actionIcon?: ReactNode;
};
export type TActionMenuConfig<T> = TActionMenuItem<T>[];
export type TActionMenuItem<T> = {
    id: string;
    label: string | ((args: TActionMenuRawProps<T>) => string);
    icon?: ReactNode | React.FC<TActionMenuRawProps<T>>;
    action?: (args: TActionMenuRawProps<T>, meta: {
        setLoading: (val: boolean) => void;
    }) => void;
    modal?: {
        content: (args: TActionMenuRawProps<T> & {
            setModalOpen: (val: boolean) => void;
        }) => ReactNode;
        props?: Partial<ModalProps>;
        id: string;
    };
    tooltip?: {
        customText?: (args: TActionMenuRawProps<T>) => string | undefined;
        showInMenu?: (args: TActionMenuRawProps<T>) => boolean;
    };
    disabled?: (args: TActionMenuRawProps<T>) => boolean;
    hidden?: (args: TActionMenuRawProps<T>) => boolean;
};
export type TModalConfig<T> = Record<string, {
    open: boolean;
    data: TActionMenuRawProps<T>;
}>;
export type TMenuState = {
    open: boolean;
    loading: string[];
};
export type TMenuConfig = Record<string, TMenuState>;
export {};
//# sourceMappingURL=types.d.ts.map