package roleassignments

import (
	"context"
	"fmt"
	"net/http"

	"github.com/hashicorp/go-azure-helpers/resourcemanager/commonids"
	"github.com/hashicorp/go-azure-sdk/sdk/client"
	"github.com/hashicorp/go-azure-sdk/sdk/odata"
)

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See NOTICE.txt in the project root for license information.

type DeleteByIdOperationResponse struct {
	HttpResponse *http.Response
	OData        *odata.OData
	Model        *RoleAssignment
}

type DeleteByIdOperationOptions struct {
	TenantId *string
}

func DefaultDeleteByIdOperationOptions() DeleteByIdOperationOptions {
	return DeleteByIdOperationOptions{}
}

func (o DeleteByIdOperationOptions) ToHeaders() *client.Headers {
	out := client.Headers{}

	return &out
}

func (o DeleteByIdOperationOptions) ToOData() *odata.Query {
	out := odata.Query{}

	return &out
}

func (o DeleteByIdOperationOptions) ToQuery() *client.QueryParams {
	out := client.QueryParams{}
	if o.TenantId != nil {
		out.Append("tenantId", fmt.Sprintf("%v", *o.TenantId))
	}
	return &out
}

// DeleteById ...
func (c RoleAssignmentsClient) DeleteById(ctx context.Context, id commonids.ScopeId, options DeleteByIdOperationOptions) (result DeleteByIdOperationResponse, err error) {
	opts := client.RequestOptions{
		ContentType: "application/json; charset=utf-8",
		ExpectedStatusCodes: []int{
			http.StatusNoContent,
			http.StatusOK,
		},
		HttpMethod:    http.MethodDelete,
		OptionsObject: options,
		Path:          id.ID(),
	}

	req, err := c.Client.NewRequest(ctx, opts)
	if err != nil {
		return
	}

	var resp *client.Response
	resp, err = req.Execute(ctx)
	if resp != nil {
		result.OData = resp.OData
		result.HttpResponse = resp.Response
	}
	if err != nil {
		return
	}

	var model RoleAssignment
	result.Model = &model
	if err = resp.Unmarshal(result.Model); err != nil {
		return
	}

	return
}
