
## `github.com/hashicorp/go-azure-sdk/resource-manager/apimanagement/2023-03-01-preview/productapi` Documentation

The `productapi` SDK allows for interaction with Azure Resource Manager `apimanagement` (API Version `2023-03-01-preview`).

This readme covers example usages, but further information on [using this SDK can be found in the project root](https://github.com/hashicorp/go-azure-sdk/tree/main/docs).

### Import Path

```go
import "github.com/hashicorp/go-azure-sdk/resource-manager/apimanagement/2023-03-01-preview/productapi"
```


### Client Initialization

```go
client := productapi.NewProductApiClientWithBaseURI("https://management.azure.com")
client.Client.Authorizer = authorizer
```


### Example Usage: `ProductApiClient.CheckEntityExists`

```go
ctx := context.TODO()
id := productapi.NewProductApiID("12345678-1234-9876-4563-123456789012", "example-resource-group", "serviceName", "productId", "apiId")

read, err := client.CheckEntityExists(ctx, id)
if err != nil {
	// handle the error
}
if model := read.Model; model != nil {
	// do something with the model/response object
}
```


### Example Usage: `ProductApiClient.CreateOrUpdate`

```go
ctx := context.TODO()
id := productapi.NewProductApiID("12345678-1234-9876-4563-123456789012", "example-resource-group", "serviceName", "productId", "apiId")

read, err := client.CreateOrUpdate(ctx, id)
if err != nil {
	// handle the error
}
if model := read.Model; model != nil {
	// do something with the model/response object
}
```


### Example Usage: `ProductApiClient.Delete`

```go
ctx := context.TODO()
id := productapi.NewProductApiID("12345678-1234-9876-4563-123456789012", "example-resource-group", "serviceName", "productId", "apiId")

read, err := client.Delete(ctx, id)
if err != nil {
	// handle the error
}
if model := read.Model; model != nil {
	// do something with the model/response object
}
```


### Example Usage: `ProductApiClient.ListByProduct`

```go
ctx := context.TODO()
id := productapi.NewProductID("12345678-1234-9876-4563-123456789012", "example-resource-group", "serviceName", "productId")

// alternatively `client.ListByProduct(ctx, id, productapi.DefaultListByProductOperationOptions())` can be used to do batched pagination
items, err := client.ListByProductComplete(ctx, id, productapi.DefaultListByProductOperationOptions())
if err != nil {
	// handle the error
}
for _, item := range items {
	// do something
}
```
