//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspasteboarditem?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSPasteboardItem;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSPasteboardItem {}
);

#[cfg(feature = "NSPasteboard")]
extern_conformance!(
    unsafe impl NSPasteboardReading for NSPasteboardItem {}
);

#[cfg(feature = "NSPasteboard")]
extern_conformance!(
    unsafe impl NSPasteboardWriting for NSPasteboardItem {}
);

impl NSPasteboardItem {
    extern_methods!(
        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(types))]
        #[unsafe(method_family = none)]
        pub unsafe fn types(&self) -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(availableTypeFromArray:))]
        #[unsafe(method_family = none)]
        pub unsafe fn availableTypeFromArray(
            &self,
            types: &NSArray<NSPasteboardType>,
        ) -> Option<Retained<NSPasteboardType>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(setDataProvider:forTypes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDataProvider_forTypes(
            &self,
            data_provider: &ProtocolObject<dyn NSPasteboardItemDataProvider>,
            types: &NSArray<NSPasteboardType>,
        ) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(setData:forType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setData_forType(&self, data: &NSData, r#type: &NSPasteboardType) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(setString:forType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setString_forType(
            &self,
            string: &NSString,
            r#type: &NSPasteboardType,
        ) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(setPropertyList:forType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPropertyList_forType(
            &self,
            property_list: &AnyObject,
            r#type: &NSPasteboardType,
        ) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(dataForType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataForType(&self, r#type: &NSPasteboardType) -> Option<Retained<NSData>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(stringForType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringForType(&self, r#type: &NSPasteboardType)
            -> Option<Retained<NSString>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(propertyListForType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn propertyListForType(
            &self,
            r#type: &NSPasteboardType,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(all(feature = "NSPasteboard", feature = "block2"))]
        /// Determines whether this pasteboard item matches the specified patterns, without notifying the user.
        ///
        /// Because this method only gives an indication of whether a pasteboard item matches a particular pattern and doesn’t allow the app to access the contents, the system doesn’t notify the user about reading the contents of the pasteboard.
        ///
        ///
        /// Parameter `patterns`: The patterns to detect on the pasteboard item.
        ///
        /// Parameter `completionHandler`: A block that the system invokes after detecting patterns on the pasteboard item. The block receives either a set with the patterns found on the pasteboard item or an error if detection failed.
        #[unsafe(method(detectPatternsForPatterns:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn detectPatternsForPatterns_completionHandler(
            &self,
            patterns: &NSSet<NSPasteboardDetectionPattern>,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSSet<NSPasteboardDetectionPattern>, *mut NSError),
            >,
        );

        #[cfg(all(feature = "NSPasteboard", feature = "block2"))]
        /// Determines whether this pasteboard item matches the specified patterns, reading the contents if it finds a match.
        ///
        /// - Important: Calling this method notifies the user that the app has read the contents of the pasteboard, if a match is found.
        ///
        /// For details about the types returned for each pattern, see `NSPasteboardDetectionPattern`.
        ///
        ///
        /// Parameter `patterns`: The patterns to detect on the pasteboard item.
        ///
        /// Parameter `completionHandler`: A block that the system invokes after detecting patterns on the pasteboard item. The block returns either dictionary with the patterns found on the pasteboard item or an error if detection failed. The dictionary keys specify the matched patterns, and the values specify the corresponding content of the pasteboard.
        #[unsafe(method(detectValuesForPatterns:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn detectValuesForPatterns_completionHandler(
            &self,
            patterns: &NSSet<NSPasteboardDetectionPattern>,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSDictionary<NSPasteboardDetectionPattern, AnyObject>, *mut NSError),
            >,
        );

        #[cfg(all(feature = "NSPasteboard", feature = "block2"))]
        /// Determines available metadata from the specified metadata types for this pasteboard item, without notifying the user.
        ///
        /// Because this method only gives access to limited types of metadata and doesn’t allow the app to access the contents, the system doesn’t notify the user about reading the contents of the pasteboard.
        ///
        /// For details about the metadata returned for each type, see `NSPasteboardMetadataType`.
        ///
        ///
        /// Parameter `types`: The metadata types to detect on the pasteboard item.
        ///
        /// Parameter `completionHandler`: A block that the system invokes after detecting metadata on the pasteboard item. The block receives either a dictionary with the metadata types found on the pasteboard item or an error if detection failed. The dictionary keys specify the matched metadata types, and the values specify the corresponding metadata.
        #[unsafe(method(detectMetadataForTypes:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn detectMetadataForTypes_completionHandler(
            &self,
            types: &NSSet<NSPasteboardMetadataType>,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSDictionary<NSPasteboardMetadataType, AnyObject>, *mut NSError),
            >,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl NSPasteboardItem {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspasteboarditemdataprovider?language=objc)
    pub unsafe trait NSPasteboardItemDataProvider: NSObjectProtocol {
        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(pasteboard:item:provideDataForType:))]
        #[unsafe(method_family = none)]
        unsafe fn pasteboard_item_provideDataForType(
            &self,
            pasteboard: Option<&NSPasteboard>,
            item: &NSPasteboardItem,
            r#type: &NSPasteboardType,
        );

        #[cfg(feature = "NSPasteboard")]
        #[optional]
        #[unsafe(method(pasteboardFinishedWithDataProvider:))]
        #[unsafe(method_family = none)]
        unsafe fn pasteboardFinishedWithDataProvider(&self, pasteboard: &NSPasteboard);
    }
);
