/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal.introspection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.apache.aries.jax.rs.whiteboard.internal.introspection.Proxies;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.ClassUnwrapper;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.osgi.service.jaxrs.runtime.dto.ResourceMethodInfoDTO;

public class ClassIntrospector {
    public static Collection<ResourceMethodInfoDTO> getResourceMethodInfos(Class<?> clazz, Bus bus) {
        Class<?> realClass = ClassIntrospector.unwrap(clazz, bus);
        ClassResourceInfo classResourceInfo = ResourceUtils.createClassResourceInfo(realClass, realClass, (boolean)true, (boolean)true, (Bus)bus);
        Stream<ResourceMethodInfoDTO> convert = ClassIntrospector.convert(new HashSet<ClassResourceInfo>(), "/", null, null, null, null, true, classResourceInfo);
        return convert.collect(Collectors.toList());
    }

    private static Class<?> unwrap(Class<?> clazz, Bus bus) {
        ClassUnwrapper unwrapper;
        ClassUnwrapper classUnwrapper = unwrapper = bus == null ? null : (ClassUnwrapper)bus.getExtension(ClassUnwrapper.class);
        if (unwrapper != null) {
            return unwrapper.getRealClassFromClass(clazz);
        }
        return Proxies.unwrap(clazz);
    }

    private static Stream<ResourceMethodInfoDTO> convert(Set<ClassResourceInfo> visited, String parentPath, String defaultHttpMethod, List<MediaType> defaultConsumeTypes, List<MediaType> defaultProduceTypes, Set<String> defaultNameBindings, boolean recurse, ClassResourceInfo classResourceInfo) {
        Set<String> nameBindings;
        List<MediaType> produceMime;
        visited.add(classResourceInfo);
        String path = parentPath + ClassIntrospector.getPathSafe(classResourceInfo);
        List<MediaType> consumeMime = ClassIntrospector.getConsumesInfo(classResourceInfo.getResourceClass());
        if (consumeMime == null) {
            consumeMime = defaultConsumeTypes;
        }
        if ((produceMime = ClassIntrospector.getProducesInfo(classResourceInfo.getResourceClass())) == null) {
            produceMime = defaultProduceTypes;
        }
        if ((nameBindings = classResourceInfo.getNameBindings()).isEmpty()) {
            nameBindings = defaultNameBindings;
        }
        MethodDispatcher methodDispatcher = classResourceInfo.getMethodDispatcher();
        Set operationResourceInfos = methodDispatcher.getOperationResourceInfos();
        ArrayList<MediaType> consumeParam = consumeMime == null ? null : new ArrayList<MediaType>(consumeMime);
        ArrayList<MediaType> produceParam = produceMime == null ? null : new ArrayList<MediaType>(produceMime);
        HashSet<String> nameBindingsParam = nameBindings == null ? null : new HashSet<String>(nameBindings);
        Stream<ResourceMethodInfoDTO> stream = operationResourceInfos.stream().flatMap(ori -> ClassIntrospector.convert(visited, path, defaultHttpMethod, (List<MediaType>)consumeParam, (List<MediaType>)produceParam, (Set<String>)nameBindingsParam, recurse, ori)).collect(Collectors.toList()).stream();
        visited.remove(classResourceInfo);
        return stream;
    }

    private static Stream<ResourceMethodInfoDTO> convert(Set<ClassResourceInfo> visited, String parentPath, String defaultHttpMethod, List<MediaType> defaultConsumeTypes, List<MediaType> defaultProduceTypes, Set<String> defaultNameBindings, boolean recurse, OperationResourceInfo operationResourceInfo) {
        Class<?> returnType;
        ClassResourceInfo classResourceInfo;
        ClassResourceInfo subResource;
        Set<String> nameBindings;
        String httpMethod;
        List<MediaType> produceTypes;
        List<MediaType> consumeTypes = ClassIntrospector.getConsumesInfo(operationResourceInfo.getAnnotatedMethod());
        if (consumeTypes == null) {
            consumeTypes = defaultConsumeTypes;
        }
        if ((produceTypes = ClassIntrospector.getProducesInfo(operationResourceInfo.getAnnotatedMethod())) == null) {
            produceTypes = defaultProduceTypes;
        }
        if ((httpMethod = operationResourceInfo.getHttpMethod()) == null) {
            httpMethod = defaultHttpMethod;
        }
        if ((nameBindings = operationResourceInfo.getNameBindings()).isEmpty()) {
            nameBindings = defaultNameBindings;
        }
        String path = parentPath + operationResourceInfo.getURITemplate().getValue();
        if (operationResourceInfo.isSubResourceLocator() && (subResource = (classResourceInfo = operationResourceInfo.getClassResourceInfo()).getSubResource(returnType = operationResourceInfo.getAnnotatedMethod().getReturnType(), returnType)) != null) {
            if (recurse) {
                return ClassIntrospector.convert(visited, path, httpMethod, consumeTypes, produceTypes, nameBindings, !visited.contains(subResource), subResource);
            }
            return Stream.empty();
        }
        ResourceMethodInfoDTO resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.consumingMimeType = consumeTypes == null ? null : (String[])consumeTypes.stream().map(MediaType::toString).toArray(String[]::new);
        resourceMethodInfoDTO.producingMimeType = produceTypes == null ? null : (String[])produceTypes.stream().map(MediaType::toString).toArray(String[]::new);
        resourceMethodInfoDTO.nameBindings = nameBindings == null ? null : nameBindings.toArray(new String[0]);
        resourceMethodInfoDTO.path = ClassIntrospector.normalize(path);
        resourceMethodInfoDTO.method = httpMethod;
        return Stream.of(resourceMethodInfoDTO);
    }

    private static List<MediaType> getConsumesInfo(Method method) {
        Consumes consumes = (Consumes)AnnotationUtils.getMethodAnnotation((Method)method, Consumes.class);
        return consumes == null ? null : JAXRSUtils.getMediaTypes((String[])consumes.value());
    }

    private static List<MediaType> getConsumesInfo(Class<?> clazz) {
        Consumes consumes = (Consumes)AnnotationUtils.getClassAnnotation(clazz, Consumes.class);
        return consumes == null ? null : JAXRSUtils.getMediaTypes((String[])consumes.value());
    }

    private static String getPathSafe(ClassResourceInfo classResourceInfo) {
        Path path = classResourceInfo.getPath();
        if (path == null) {
            return "/";
        }
        return path.value();
    }

    private static List<MediaType> getProducesInfo(Method method) {
        Produces produces = (Produces)AnnotationUtils.getMethodAnnotation((Method)method, Produces.class);
        return produces == null ? null : JAXRSUtils.getMediaTypes((String[])produces.value());
    }

    private static List<MediaType> getProducesInfo(Class<?> clazz) {
        Produces produces = (Produces)AnnotationUtils.getClassAnnotation(clazz, Produces.class);
        return produces == null ? null : JAXRSUtils.getMediaTypes((String[])produces.value());
    }

    private static String normalize(String path) {
        return "/" + Arrays.stream(path.split("/")).filter(s -> !s.isEmpty()).collect(Collectors.joining("/"));
    }
}

