/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ExtendedOptional<T> {
    private final Optional<T> delegate;

    private ExtendedOptional(Optional<T> delegate) {
        this.delegate = delegate;
    }

    public static <T> ExtendedOptional<T> extend(Optional<T> delegate) {
        return new ExtendedOptional<T>(delegate);
    }

    public T get() {
        return this.delegate.get();
    }

    public boolean isPresent() {
        return this.delegate.isPresent();
    }

    public boolean isEmpty() {
        return !this.delegate.isPresent();
    }

    public void ifPresent(Consumer<? super T> action) {
        this.delegate.ifPresent(action);
    }

    public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        Object value = this.delegate.orElse(null);
        if (value != null) {
            action.accept(value);
        } else {
            emptyAction.run();
        }
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        return this.delegate.filter(predicate);
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        return this.delegate.map(mapper);
    }

    public <U> Optional<U> flatMap(Function<? super T, ? extends Optional<? extends U>> mapper) {
        return this.delegate.flatMap(mapper);
    }

    public Optional<T> or(Supplier<? extends Optional<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isPresent()) {
            return this.delegate;
        }
        Optional<? extends T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    public Stream<T> stream() {
        Object value = this.delegate.orElse(null);
        if (value != null) {
            return Stream.of(value);
        }
        return Stream.empty();
    }

    public T orElse(T other) {
        return this.delegate.orElse(other);
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        return this.delegate.orElseGet(supplier);
    }

    public T orElseThrow() {
        T value = this.delegate.orElse(null);
        if (value == null) {
            throw new NoSuchElementException("No value present");
        }
        return value;
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this.delegate.orElseThrow(exceptionSupplier);
    }
}

